Ext.define("Keysystems.Controls.SettingsGrid", {
	extend: "Ext.grid.property.Grid",
	mixins: ['Keysystems.Base.Abstract'],
	xtype: "rks-property-grid",
	layout: {
		type: "vbox",
		align: "stretch",
	},
	autoRender: true,
	hideHeaders: true,
	enableColumnResize: true,
	nameColumnWidth: 350,
	border: true,
	viewConfig: {
		markDirty: false,
	},
	user: null,	
	nameField: 'Code',
	valueField: 'Value',
	config: {
		onPropertyChanged: null,
		onSelectionChanged: null
	},
	constructor: function (cfg) {
		var me = this;
		Ext.apply(me, cfg);
		me.callParent(arguments);

		this.editingPlugin.on({
			edit: (editingPlugin, {record, value}) => this.onPropertyEditComplete(record, value),
			scope: this,
		});
	},
	initComponent() {
		const me = this;
		me.beforeInitComponent();
		me.store = Ext.create("Ext.data.Store", {
			fields: ["Code", "Name", "Category"],
			groupField: "Category",
			proxy: 'memory',
		});
		me.features = Ext.create('Ext.grid.feature.Grouping', {
			groupHeaderTpl: ["{name}"]
		});
		me.listeners = {
			selectionchange: function (_, sels) {
				if (me.onSelectionChanged) me.onSelectionChanged(sels);
			}
		}
		this.callParent();		

		//this.on('celldblclick', this.onCellDblClick, this);
	},

	loadData(items, user) {
		this.user = user;
		this.store.loadData(items);

		this.sourceConfig = {};
		items.forEach((item) => {
			if (item.DataType === "MCASE" && !Array.isArray(item.Value))
				item.Value = JSON.parse(item.Value);
			
			if (item.Code.lastIndexOf('_COLOR') === (item.Code.length - 6) && !item.Value){
				item.Value = "rgb(255, 255, 255)";
			}
			item.InitValue = item.Value;
			item.InitExtValue = item.EditorTypeName;

			const code = item.Code;
			if (!this.sourceConfig[code]) {
				const type = item.DataType;
				const editor = this.getSourceConfigPropertyEditor(item);

				this.sourceConfig[code] = {
					displayName: item.Name,
					renderer: this.getRendererFn(item),
					editor,
					type,
				};
			}
		});
		if (this.onSelectionChanged) this.onSelectionChanged(null);
		this.reconfigure();
	},

	getRendererFn() {
		const me = this;
		return (value, meta, rec) => {
			const type = rec.data.DataType;

			let rawHtml = false;
			switch (type) {
				case "DATETIME":
					value = Ext.Date.format(me.getDateFromSQL(value), 'd.m.Y');
					break;
				case "BIT":
					value = value === null ? "Не определено" : (+value ? "Да" : "Нет");
					break;
				case "CASE":
				case "COMBO":
					if (+value || +value === 0)
						value = JSON.parse(rec.data.EditorTypeName)[value]
					break;
				case "MCASE":
					const options = JSON.parse(rec.data.EditorTypeName);
					value = options.filter((option, index) => rec.data.Value.indexOf(index) >= 0).map(option => option.Text).join(', ');
					break;
				case "VARCHAR":
					if (rec.data.Code.indexOf('_COLOR') > 0) {
						switch (rec.data.Code) {
							case 'NASTR_COLOR_RISK_MIN':
							case 'NASTR_COLOR_RISK_AVERAGE':
							case 'NASTR_COLOR_RISK_MAX':
								const parts = value.split(';');
								if (parts.length > 2) value = parts[2];
						}
						const colorMatch = /rgb\((.*)\)/.exec(value);
						value = colorMatch && colorMatch.length > 1 ? colorMatch[1] : "255,255,255";
						const border = value === "255,255,255" ? "1px solid lightgray" : "0px";

						value = `<div style="display:flex; flex-direction: row; padding-top: 2px">
<div style="border: ${border}; background: rgb(${value}); width: 16px; height: 16px;"></div>
<div style="padding-left: 5px">${value}</div>
</div>`;
						rawHtml = true;
					}
					break;
			}
			if (value == null) value = '';

			if (!rawHtml) value = Ext.String.htmlEncode(value);
			return rec.data.Changed ? `<b>${value}</b>` : value;
		};
	},

	getDateFromSQL(value) {
		const regexDateSQL = /(\d{4})(\d{2})(\d{2})/;
		if (regexDateSQL.test(value)) {
			const match = regexDateSQL.exec(value);
			value = new Date(match[1], match[2] - 1, match[3]);
		}
		return value;
	},

	onPropertyEditComplete(record, value) {
		switch (record.get('DataType')) {
			case "MCASE":
				record.set('Changed', JSON.stringify(value) != JSON.stringify(record.get('InitValue')));
				break;
			case "DATETIME":
				record.set('Value', Ext.Date.format(value, 'Ymd'));
			default:
				record.set('Changed', value != record.get('InitValue'));
				break;
		}

		if (this.onPropertyChanged) this.onPropertyChanged();
	},

	/**Изменить значение в связанной записи
	 */
	changePropertyValue(code, value) {
		const rec = this.store.findRecord("Code", code);
		if (rec) {
			rec.set('Value', value);
			this.onPropertyEditComplete(rec, value);
		}
	},
	refreshView() {
		this.getView().refresh();
	},
	getSourceConfigPropertyEditor(item) {
		const me = this;
		return new Ext.grid.CellEditor({
			field: me.createControl(item),
			listeners: {
				beforestartedit: (cellEditor) => {
					const {context, field} = cellEditor;
					if (!context) return;
					if (field.beforeEdit) field.beforeEdit(context);
				}
			}
		});
	},
	createControl: function (item) {
		const me = this;
		switch (item.DataType) {
			case 'REFER':
			case 'SINGLE_REFER':
			case 'REFER_01':
			case 'REFER_02':
				let cfg = {};
				switch (item.Code) {
					case 'NASTR_DEFAULT_PROP':
						return Ext.create('Ext.form.field.Text', {
							editable: false,
							value: item.Value,
							triggers: {
								btn: {
									cls: 'x_btn_dict x-dict-trigger',
									handler: function () {
										let panelProp = Ext.create('Keysystems.Panel.Prop', {
											owner: this,
											title: item.Name,
											parentView: {code: item.ObjCode, keyEdit: 'edit'},
											header: false,
											showComment: false,
											flex: 1,
											code: item.ObjCode,
											decimalData: me.decimalData,
											saveFunc: function (data) {
												let oldValue = JSON.stringify(JSON.parse(item.EditorTypeName).data);
												let newValue = JSON.stringify(data);
												if (oldValue === newValue) return;
												let editor = this.owner;
												me.setDefaultProp(panelProp, item, data,
													result => {
														if (!result) return;
														this.oldData = JSON.stringify(data);
														editor && editor.setValue(result);
													});
											}
										});

										let data = item.EditorTypeName ? JSON.parse(item.EditorTypeName) : '';
										data.AllowPropSave = true;
										data.AllowPropSelect = true;
										data.AllowPropFill = false;
										data.AllowPropMask = true;
										data.AllowPropUpDown = true;

										panelProp.loadData(data);

										Ext.create('Ext.window.Window', {
											modal: true,
											title: 'Реквизиты',
											height: 400,
											width: 600,
											layout: {type: 'vbox', align: 'stretch'},
											maximizable: true,
											items: [panelProp]
										}).show();

									}
								}
							}
						});
					case "NASTR_PROP_COLUMNS":
						let whereArgsPropColumns = {};
						return me.createReferEditor(item, {
							initWhereArgs: () => (whereArgsPropColumns)
						}, (callback) => {
							Settings.getValue([
								{ObjCode: item.ObjCode, PropCode: 'NASTR_DEFAULT_PROP', User: 0, IsRefer: true}
							]).then(function (res) {
								whereArgsPropColumns = {
									InLinksOnly: {type: 'bool', value: 'True'},
									InLinks: {type: 'List_int', value: JSON.stringify(res[0].value)}
								};
								if (callback) callback();
							});
						});
						break;
					case "NASTR_SINGLE_STATUS":
					case "NASTR_STATUS_APPROVED":
					case "NASTR_STATUS_REJECT":
					case "NASTR_AGREE_STATUS":
						cfg.whereArgs = {
							ObjCode: {value: item.ObjCode, type: 'string'}
						};
						break;
					case "NASTR_REPORTS_REVIZ":
						let mode = 0,
							arrModeReviz = ["EF_REVIZ_PRINT", "EF_REVIZ_PRINT_VFA", "EF_REVIZ_PRINT_BR", "EF_REVIZ_PRINT_IC",
								"EF_REVIZ_PRINT_DC_FZ_44", "EF_REVIZ_PRINT_DC_FZ_223"];
						if (arrModeReviz.indexOf(item.ObjCode) >= 0)
							mode = 1    //ReportPrintMode.Reviz
						else if (item.ObjCode === "EF_PLANPROJ_PRINT" || item.ObjCode === "EF_SPLANPROJ_PRINT_VFA")
							mode = 3    //ReportPrintMode.SplanProj
						else if (item.ObjCode === "EF_RECORDS_PRINT" || item.ObjCode === "EF_RECORD_MOD_PRINT")
							mode = 4    //ReportPrintMode.Record

						cfg.whereArgs = {
							Mode: {value: mode, type: 'int'}
						};
						break;
					case "NASTR_SHOW_NPA":
					case "NASTR_CENTRAL_FK":
						cfg.whereArgs = {
							SType: {value: JSON.stringify([1]), type: 'List_int'} //TypeOrg.Проверяющая
						};
						break;
					case 'NASTR_VFA_SWORK':
					case 'NASTR_INFO_BY_REVIZ_SWORK':
						let whereArgsVFA = {};
						return me.createReferEditor(item, {
							initWhereArgs: () => (whereArgsVFA)
						}, (callBack) => {
							ajaxRequest({
								url: 'SSettings/GetExcludeSWorks_A',
								params: {objCode: item.ObjCode},
								success: function (res) {
									whereArgsVFA = {
										NotInLinks: {type: 'List_int', value: JSON.stringify(res)}
									};
									if (callBack) callBack();
								}
							});
						});
					case 'NASTR_TASK_ACCESS_EDIT':
						let whereArgsTaskAccess = {};
						return me.createReferEditor(item, {
							initWhereArgs: () => (whereArgsTaskAccess)
						}, (callback) => {
							Settings.getValue([
								{
									ObjCode: 'DICTIONARY_STASK',
									PropCode: 'NASTR_REALIZATIONAP',
									User: 0,
									IsRefer: true
								}
							]).then(function (res) {
								whereArgsTaskAccess = {
									NotInLinks: {type: 'List_int', value: JSON.stringify(res[0].value)}
								};
								if (callback) callback();
							});
						});
					case "NASTR_USER_GROUP_EDIT":
						cfg.whereArgs = {
							DisplayGroups: {type: 'bool', value: 'True'}
						};
						break;
					case 'NASTR_PM_SENDTO_FILTER':
						return Ext.create('Ext.form.field.Text', {
							editable: false,
							value: item.Value,
							triggers: {
								btn: {
									cls: 'x_btn_dict x-dict-trigger',
									handler: function () {
										const rec = me.editingPlugin.activeRecord;
										const oldValue = JSON.parse(rec.data.EditorTypeName);

										ajaxRequest({
											url: 'SSettings/GetSendToFilter_A',
											params: {},
											success: function (result) {
												if (!result) return;

												const mode = +result === 1 ? "get_tree_groups" : "get_tree_orgs";
												const tree = Ext.create('Keysystems.UsersGroups.Tree',
													{
														title: 'Пользователи и группы',
														closeAction: 'hide',
														multiSelect: true,
														formatName: true,
														mode: mode,
														uids: oldValue.map(r => r.UID),
														ok: function (records) {
															me.setValue(item, JSON.stringify(records.map(r => +r.data.UID)), true);

															const displayValue = me.getDictValueToDisplay(records, item);
															rec.set('InitValue', displayValue);
															rec.set('Value', displayValue);

															rec.set('InitExtValue', JSON.stringify(records.map(r => r.data)));
															rec.set('EditorTypeName', JSON.stringify(records.map(r => r.data)));
														}
													});
												tree.show();
											}
										})
									}
								}
							}
						});
				}
 
				if (item.Code.indexOf("NASTR_REPORT") >= 0) {
					let mode = item.ObjCode === "DOCUMENT_PLANREVIZ"
						? 3  //ReportPrintMode.SplanProj
						: (item.ObjCode === "DOCUMENT_PLANREVIZ_MOD"
							? 9 //ReportPrintMode.PlanrevizSimpleMod
							: (item.ObjCode === "DOCUMENT_PLANCENTRAL"
								? 5  //ReportPrintMode.Plancentral
								: (item.ObjCode === "DOCUMENT_PLANCENTRAL_MOD"
									? 6 //ReportPrintMode.PlancentralChanges
									: item.ObjCode === "TAB_DF_DOCUMENTS_TASK"
										? 10 : null))); //ReportPrintMode.DFDocuments

					if (mode) {
						cfg.whereArgs = {
							Mode: {value: mode, type: 'int'}
						};
					}
				}
				// справочник
				return me.createReferEditor(item, cfg);
			case 'DIRPATH':
			case 'VARCHAR':
				switch (item.Code) {
					case 'NASTR_AUTONUMERIC_MASK':
						return Ext.create('Keysystems.form.field.Trigger.TextEditor', {
							listeners: {
								blur: function (th) {
									me.changePropertyValue(item.Code, th.value);
								}
							},
							onTriggerClick: function () {
								const rec = me.editingPlugin.activeRecord;

								Ext.create('Keysystems.AutoNumeric.Edit', {
									value: {mask: rec.data.Value, numVal: rec.data.EditorTypeName},
									owner: this,
									baseSaveData: function (value) {
										let oldValue = JSON.stringify({
											mask: rec.data.Value,
											numVal: rec.data.EditorTypeName
										});
										let newValue = JSON.stringify(value);
										if (oldValue === newValue) return;

										const editor = this;
										me.setAutoNumeric(editor, item, value, (res) => {
											if (res.saved) {
												editor.oldData = newValue;
												rec.set('InitValue', value.mask);
												rec.set('Value', value.mask);
												rec.set('InitExtValue', value.numVal);
												rec.set('EditorTypeName', value.numVal);
											} else if (res.errorMessage)
												console.error(res.errorMessage);
										});

									}
								});
							}
						});
					case 'NASTR_AUTONUMERIC_MASKIKM':
					case 'NASTR_AUTONUMERIC_MASKIKM2':
						return Ext.create('Keysystems.form.field.Trigger.TextEditor', {
							listeners: {
								blur: function (th) {
									me.changePropertyValue(item.Code, th.value);
								}
							},
							onTriggerClick: function () {
								const rec = me.editingPlugin.activeRecord;
								let extValue = rec.data.EditorTypeName ? JSON.parse(rec.data.EditorTypeName) : {
									value: "{#}",
									numVal: 0
								};
								let value = {mask: rec.data.Value, numVal: extValue.numVal, sOrg: extValue.sOrg};
								Ext.create('Keysystems.AutoNumericIKM.Edit', {
									value: {mask: rec.data.Value, numVal: value.numVal, sOrg: value.sOrg},
									owner: this,
									baseSaveData: function (v) {
										let oldValue = JSON.stringify(value),
											newValue = JSON.stringify(v);
										if (oldValue === newValue) return;

										let editor = this,
											valueToSave = {
												mask: v.mask,
												numVal: v.numVal,
												sOrg: (v.sOrg.data || v.sOrg).LINK
											};
										me.setAutoNumeric(editor, item, valueToSave, (res) => {
											if (res.saved) {
												editor.oldData = newValue;
												if (valueToSave.sOrg === window.user.org.data.LINK) {
													rec.set('InitValue', v.mask);
													rec.set('Value', v.mask);
													rec.set('InitExtValue', newValue);
													rec.set('EditorTypeName', newValue);
												}
											} else if (res.errorMessage)
												console.error(res.errorMessage);
										});

									}
								});
							}
						});
					//вероятно не используется
					// case 'NASTR_LASTNAME_EXCEPTION':
					// 	return Ext.create('Keysystems.form.field.Trigger.TextEditor', {
					// 		value: item.Value,
					// 		onTriggerClick: function () {
					// 			let th = this,
					// 				editor = Ext.create('RevizorListEditor', {
					// 					data: th.getValue().split('; '),
					// 					okFunc: function (list) {
					// 						var nv = list.join('; ');
					// 						th.setValue(nv);
					// 						me.setValue(item, nv);
					// 					},
					// 				});
					// 			editor.show();
					// 		}
					// 	});
					//property.EditorTypeName = typeof (ItemsEditor).AssemblyQualifiedName;
					case 'NASTR_FILTER':
						return Ext.create('Ext.form.field.Text', {
							editable: false,
							triggers: {
								dict: {
									cls: 'x_btn_search x-dict-trigger',
									handler: function () {
										const rec = me.editingPlugin.activeRecord;
										let extV = rec.data.EditorTypeName ? JSON.parse(rec.data.EditorTypeName) : '';
										Ext.each(extV, function (el) {
											el.ReadOnly = false;
										});
										Ext.create('Revizor.FilterView', {
											title: item.Name,
											filter: extV,
											closeAction: 'hide',
											owner: this,
											ok: function () {
												const newValue = Keysystems.Base.List.prototype.getFilter.call({
													getFilterValue: Keysystems.Base.List.prototype.getFilterValue,
													filter: extV
												});
												me.setFilter(this, item, newValue).then(res => {
														rec.set('InitValue', res);
														rec.set('Value', res);

														const newExtV = extV.slice();
														newExtV.map(v => delete v.fieldCondition);

														rec.set('InitExtValue', JSON.stringify(newExtV));
														rec.set('EditorTypeName', JSON.stringify(newExtV));
													}
												);
											}
										}).show();
									}
								}
							}
						});
					case 'NASTR_DURATION':
					case 'NASTR_FILE_MASK':
					case 'NASTR_AUTOFILL':
						return Ext.create('Keysystems.Controls.Formula.Edit', {
							value: item.Value,
							listeners: {
								blur: {
									fn: (th) => me.changePropertyValue(item.Code, th.value),
									buffer: 500
								}
							}
						});
					//property.EditorTypeName = typeof (FormulaEditor).AssemblyQualifiedName;
					case 'NASTR_CHECK_SAVE':
						return Ext.create('Ext.form.field.Text', {
							editable: false,
							triggers: {
								dict: {
									cls: 'x_btn_dict x-dict-trigger',
									handler: function () {
										const rec = me.editingPlugin.activeRecord;
										const saveRules = JSON.parse(rec.data.EditorTypeName);
										Keysystems.Edits.DocVid.prototype.btnSaveRulesHandler.call({
											saveRuleLink: -1,
											objs: {
												saveRules: saveRules,
												btnSaveRules: {
													setIconCls: Ext.emptyFn,
													setTooltip: function () {
														saveRules.data.forEach(r => {
															if (!r.TLINK) r.TLINK = null;
															delete r.id;
															delete r.LINK_SELF;
														});
														let oldValue = JSON.stringify(JSON.parse(rec.data.EditorTypeName).data);
														let newValue = JSON.stringify(saveRules.data);
														if (oldValue === newValue) return;
														me.setSaveRules(null, item, saveRules)
															.then(result => {
																if (!result) return;
																rec.set('InitValue', result);
																rec.set('Value', result);
																rec.set('InitExtValue', JSON.stringify(saveRules));
																rec.set('EditorTypeName', JSON.stringify(saveRules));
															});
													}
												}
											}
										});
									}
								}
							}
						});
					case 'DATASOURCE_NALOG':
					case 'DATASOURCE_GUOT':
					case 'DATASOURCE_ADM_NACH_CODE':
					case 'DATASOURCE_ADM_TRANSFER_PD':
						break;
					case 'NASTR_NOTCHANGE_FIELDS_REPLACE':
						return Ext.create('Ext.form.field.Text', {
							editable: false,
							triggers: {
								btn: {
									cls: 'x_btn_dict x-dict-trigger',
									handler: function () {
										const rec = me.editingPlugin.activeRecord;
										const extV = rec.data.EditorTypeName ? JSON.parse(rec.data.EditorTypeName) : '';

										let v = [];
										Ext.each(item.Value.split(';'), function (el) {
											let d = el.split('|'),
												code = d.length === 2 ? d[1] : d[2],
												table = d.length === 2 ? d[0] : d[1],
												name = d.length === 2 ? ArrayLib.filter(extV.data.data, ['CODE'], d[1])[0].NAME : d[0];

											v.push({CODE: code, TABLE: table, NAME: name});
										});

										const cfg = {
											code: 'DICTIONARY_OBJECT_FIELDS',
											selectLinks: v,
											fieldLink: 'CODE',
											isFake: true,
											hidePagging: true,
											btnsShow: {
												print: true,
												galka: true,
												unmark: true,
												wrap: true,
												exit: true
											},
											baseRefresh: function (callBack) {
												if (callBack) callBack(KsLib.objCopy(extV));
											},
											baseGetData: function (callBack) {
												if (callBack) callBack(KsLib.objCopy(extV));
											},
											functions: {
												ok: function (val) {
													let data = val.map(v => v.data ?? v);
													let nv = data.length === 1
														? data[0].NAME + '|' + data[0].TABLE + '|' + data[0].CODE
														: data.map(el => el.TABLE + '|' + el.CODE).join(';');

													//todo посмотреть в вине
													rec.set('InitValue', nv);
													rec.set('Value', nv);
												}
											}
										};
										dictFunc(cfg);
									}
								}
							}
						});
					case 'NASTR_FILLDOCVID_SORGC':
					case 'NASTR_RESPONS':
						return Ext.create('Ext.form.field.Text', {
							editable: false,
							value: item.Value,
							triggers: {
								dict: {
									cls: 'x_btn_dict x-dict-trigger',
									handler: function () {
										const rec = me.editingPlugin.activeRecord;
										const data = rec.data.EditorTypeName ? JSON.parse(rec.data.EditorTypeName) : '';

										let pp = Ext.create('Keysystems.Panel.ReferOrd', {
											title: item.Name,
											f: 'edit',
											viewMinSize: [500, 300],
											code: item.Code === "NASTR_FILLDOCVID_SORGC" ? "DICTIONARY_SDOCVID" : item.ObjCode,
											owner: this,
											baseSaveData: function (nv, callback) {
												pp.setLoading(KS.L10n.settings_saving);
												//значение настройки - строка с линками через запятую
												let links = nv.map(r => (r.data || r).LINK);
												me.setValue(item, links.join(',')).then(() => {
													pp.setLoading(false);
													//расширенное значение настройки - словарь с записями в нужном порядке
													const displayValue = wmc.get(nv.length ? 'CheckValue' : 'NotCheckValue', links.length);
													rec.set('InitValue', displayValue);
													rec.set('Value', displayValue);
													rec.set('InitExtValue', JSON.stringify(nv));
													rec.set('EditorTypeName', JSON.stringify(nv));
													this.successSaveFunc({result: true}, callback, nv);
												});
											}
										});
										pp.setMetaDate({
											columns: [{
												dataIndex: 'CODE',
												text: 'Код',
												sortable: false
											}, {
												dataIndex: 'NAME',
												text: 'Наименование',
												flex: 1,
												sortable: false
											}],
											fields: ['LINK', 'CODE', 'NAME', 'ORD'],
											data: data
										});
										pp.oldData = JSON.stringify(pp.dataCollector());
									}
								}
							}
						});

					case 'NASTR_COLOR_RISK_MIN':
					case 'NASTR_COLOR_RISK_AVERAGE':
					case 'NASTR_COLOR_RISK_MAX':
						return Ext.create('Ext.form.field.Text', {
							editable: false,
							userCls: 'rks-risk-colorpicker',
							//в текстовое поле перед текстом добавляем квадрат с цветом
							beforeBodyEl: '<div id="' + item.Code + '-swatchEl" class="rks-color-preview" ' +
								'style="background-color: ' + (item.Value ? item.Value.split(';')[2] : 'white') + '"></div>',
							triggers: {
								btn: {
									cls: 'x_btn_form-changes-gz x-dict-trigger',
									handler: function () {
										const rec = me.editingPlugin.activeRecord;

										Ext.create('Keysystems.RiskColor.Edit', {
											value: this.getValue(),
											owner: this,
											baseSaveData: function (nv) {
												me.changePropertyValue(item.Code, nv);
												const newColor = nv ? nv.split(';')[2] : 'white';
												const ctrlPreview = Ext.get(item.Code + '-swatchEl');
												if (ctrlPreview) ctrlPreview.setStyle({'background-color': newColor});
												this.oldData = JSON.stringify(this.dataCollector());
											}
										});
									}
								}
							}

						});
					case "NASTR_EIS_REVIZACT":
					case "NASTR_EIS_REVIZACTPRESC":
					case "NASTR_EIS_REVIZDECISION":
					case "NASTR_EIS_REVIZDECISIONPRESC":
					case "NASTR_EIS_REVIZCONCLUSION":
					case "NASTR_EIS_REVIZCONCLUSIONPRESC":
					case "NASTR_EIS_REVIZDOC":
					case "NASTR_EIS_REVIZCANCELDOC":
					case "NASTR_EIS_REVIZUCANCELDOC":
					case "NASTR_EIS_REVIZORDERDOC":
					case "NASTR_EIS_PLANORDERDOC":
					case "NASTR_EIS_PLANDOC":
					case "NASTR_EIS_REVIZCRORDERDOC":
					case "NASTR_EIS_ACTPRESCCAN":
					case "NASTR_EIS_ACTPRESCPARTCAN":
					case "NASTR_EIS_CONCLUSIONPRESCCAN":
					case "NASTR_EIS_CONCLPRESCPARTCAN":
					case "NASTR_EIS_ACTPRESCSTAY":
					case "NASTR_EIS_CONCLUSIONPRESCSTAY":
					case "NASTR_EIS_SURVEYORDERDOC":
					case "NASTR_EIS_CHIEF_DECISION":
					case "NASTR_EIS_WARRANT":
					case "NASTR_EIS_WARRANT_KEEP":
					case "NASTR_EIS_WARRANT_CANCEL":
					case "NASTR_EIS_WARRANT_PART_CANCEL":
					case "NASTR_GIS_DOC_1":
					case "NASTR_GIS_DOC_2":
					case "NASTR_GIS_DOC_3":
					case "NASTR_GIS_DOC_4":
					case "NASTR_GIS_DOC_5":
					case "NASTR_GIS_DOC_6":
					case "NASTR_GIS_DOC_7":
					case "NASTR_GIS_DOC_8":
					case "NASTR_GIS_DOC_9":
					case "NASTR_GIS_DOC_10":
					case "NASTR_GIS_DOC_11":
					case "NASTR_GIS_DOC_12":
					case "NASTR_GIS_DOC_13":
					case "NASTR_GIS_DOC_14":
					case "NASTR_GIS_DOC_15":
					case "NASTR_GIS_DOC_16":
					case "NASTR_GIS_DOC_17":
					case "NASTR_GIS_DOC_18":
					case "NASTR_GIS_REVIZORDERDOC":
					case "NASTR_GIS_CHIEF_DECISION":
					case "NASTR_GIS_SDOCVID_REPORT_EAM":
					case "NASTR_OBJECTIONACT_DOCVID":
					case "NASTR_DOCREVIZ_DOCVID":
						return Ext.create('Ext.form.field.Text', {
							value: item.Value,
							editable: false,
							triggers: {
								dict: {
									cls: 'x_btn_dict x-dict-trigger',
									handler: function () {
										const rec = me.editingPlugin.activeRecord;

										Ext.create('Keysystems.TaskDocVidsBox.Edit', {
											docVidMode: item.Code.indexOf('GIS') >= 0 ? 'MULTI' : 'SINGLE',
											docVidsKey: item.Code,
											docVids: [{key: 'DOC', fieldLabel: 'Документ'}],
											title: item.Name,
											value: rec.data.EditorTypeName,
											owner: this,
											baseSaveData: function (nv, callback) {
												const sValue = nv.map(v => v.map(v => (v.data || v).LINK).join(',')).join(';');
												me.setValue(item, sValue);

												const displayValue = nv.length ? wmc.get('CheckValue', nv[nv.length - 1].length) : wmc.get('NotCheckValue');
												rec.set('InitValue', displayValue);
												rec.set('Value', displayValue);
												rec.set('InitExtValue', JSON.stringify(nv));
												rec.set('EditorTypeName', JSON.stringify(nv));
												this.successSaveFunc({result: true}, callback, JSON.stringify(nv));
											}
										});
									}
								}
							}
						});
					//property.TypeName = typeof (StringReadOnlyTypeConverter).AssemblyQualifiedName;
					//property.EditorTypeName = typeof (TaskDocVidBoxEditor).AssemblyQualifiedName;
					default:
						if (item.Code.indexOf('DATASOURCE_') === 0) {
							//property.EditorTypeName = typeof (LoginBoxEditor).AssemblyQualifiedName;
						} else if (item.Code.indexOf('NASTR_AUTOFILL') === 0) {
							//property.EditorTypeName = typeof (FormulaEditor).AssemblyQualifiedName;
						} else if (item.Code.lastIndexOf('_COLOR') === (item.Code.length - 6)) {
							//Настройки связанные с выбором цвета/палитры
							return Ext.create('Keysystems.form.field.Color', {
								mode10: true
							});
							//property.TypeName = typeof (StringReadOnlyTypeConverter).AssemblyQualifiedName;
							//property.EditorTypeName = typeof (PaletteBoxEditor).AssemblyQualifiedName;
						}
						break;
				}
				// Текстовый редактор
				// Выбор пути или каталога
				return Ext.create('Keysystems.form.field.Trigger.TextEditor', {
					listeners: {
						change: {
							fn: (th, nv) => me.changePropertyValue(item.Code, nv),
							buffer: 500
						}
					}
				});
			case 'INT':
			case 'NUMERIC':
			case 'SMALLINT':
				switch (item.Code) {
					case 'NASTR_REVIZ_SAVE_TIMEOUT':
						return Ext.create('Ext.form.field.Number', {
							minValue: 0,
							maxValue: 30,
							ksLimitMaxMin: true,
							enforceMaxLength: true,
							enableKeyEvents: true,
							regNumbers: /[0-9]/,
							listeners: {
								keypress: function (field, e) {
									if (!this.regNumbers.exec(String.fromCharCode(e.getKey()))) e.preventDefault();
								}
							}
						});
				}
				// Числовой редактор
				return Ext.create('Ext.form.Number', {
					listeners: {
						change: {
							fn: function (th, nv) {
								if (item.ObjCode === 'NASTR_CHECK_STAMP_INTERVAL') window.checkStampInterval = +nv;
							}, buffer: 500
						}
					}
				});
			case 'DATETIME':
				// Календарь
				return Ext.create('Ext.form.Date', {
					beforeEdit: function (context) {
						context.value = me.getDateFromSQL(context.record.data.Value);
					}
				});
			case 'BIT':
				// переключатель (Нет/Да)
				return Ext.create('Ext.form.field.ComboBox', {
					editable: false,
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					value: item.Value * 1,
					store: CBDataLib.getStore(CBDataLib.get(_, 0, {0: 'Нет', 1: 'Да'})),
					listeners: {
						change: function (th, nv) {
							if (item.ObjCode === 'NASTR_MODAL_EDIT_WINDOW') window.modalEdit = nv;
						}
					}
				});
			case 'CASE':
			case 'COMBO':
				const extV = item.EditorTypeName ? JSON.parse(item.EditorTypeName) : '';
				// Выбор опций
				const options = {};
				Ext.each(extV, function (text, i) {
					options[i] = text;
				});
				return Ext.create('Keysystems.Controls.ComboBoxExtra', {
					editable: false,
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					store: CBDataLib.getStore(CBDataLib.get(_, 0, options)),
					listeners: {
						change: function (th, nv) {
							if (item.Code === 'NASTR_PM_ADDRESS_TYPE') Keysystems.Revizor.Mail.sendToFilter = null;
						}
					}
				});
			case 'MCASE':
				let mCaseOptions = JSON.parse(item.EditorTypeName);
				let d = {};
				Ext.each(mCaseOptions, function (option, i) {
					d[i] = option.Text;
				});
				// Выбор нескольких опций
				return Ext.create('Keysystems.Controls.ComboBoxExtra', {
					editable: false,
					multiSelect: true,
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					store: CBDataLib.getStore(CBDataLib.get(_, 0, d))
				});
		}

		return Ext.create('Keysystems.form.field.Trigger.TextEditor');
	},

	getControlId: function (item) {
		return (this.code || 'common') + '_' + item.ObjCode + '_' + item.Code;
	},

	createReferEditor: function (item, defCfg, beforeCreateFn) {
		const me = this;

		return Ext.create('Ext.form.field.Text', {
			editable: false,
			value: item.Value,
			triggers: {
				btn: {
					cls: 'x_btn_dict x-dict-trigger',
					handler: function () {
						const showDict = function () {
							const rec = me.editingPlugin.activeRecord;

							const extV = rec.data.EditorTypeName ? JSON.parse(rec.data.EditorTypeName) : '';
							const cfg = {
								key: item.ObjCode + '_' + item.Code,
								code: item.CodeDict,
								selectLinks: extV,
								mode: item.DataType === 'SINGLE_REFER' ? 'SINGLE' : 'MULTI',
								cleaningKey: false,
							};
							if (defCfg) Ext.apply(cfg, defCfg);
							
							// Отчеты формируемые без открытия окна параметров
							if (item.Code === 'NASTR_REPORTS_WITHOUT_WINDOW') {
								const parentCode = rec.data.ObjCode === 'DOCUMENT_PLANREVIZ'
									? 'NASTR_REPORT_PLANREVIZ'
									: rec.data.ObjCode === 'DOCUMENT_PLANREVIZ_MOD'
										? 'NASTR_REPORT_PLANREVIZ_MOD'
										: rec.data.ObjCode === 'TAB_DF_DOCUMENTS_TASK'
											? 'NASTR_REPORT_DFTASK'
											: 'NASTR_REPORTS_REVIZ',
									parentNastr = me.getStore().getDataExt().filter(d => d.Code === parentCode),
									parentData = parentNastr.length && parentNastr[0].EditorTypeName
										? JSON.parse(parentNastr[0].EditorTypeName) : null;
								
								if (parentData) {
									cfg.whereArgs = {
										InLinksOnly: {type: 'bool', value: 'True'},
										InLinks: {
											type: 'List_int',
											value: JSON.stringify(parentData.map(d => d.LINK))
										}
									};
								}
							}
							
							dictFunc(cfg,
								{
									ok: function (value) {
										const links = value.map(v => (v.data || v).LINK);
										
										// Отчет
										if (['NASTR_REPORTS_REVIZ', 'NASTR_REPORT_PLANREVIZ', 'DOCUMENT_PLANREVIZ_MOD',
											'NASTR_REPORT_DFTASK'].indexOf(item.Code) !== -1) {
											const childNastr = me.getStore().getDataExt().filter(d => d.Code === 'NASTR_REPORTS_WITHOUT_WINDOW'),
												childData = childNastr.length && childNastr[0].EditorTypeName
													? JSON.parse(childNastr[0].EditorTypeName) : null;
											if (childData) {
												if (childData.map(d => d.LINK).filter(d => links.indexOf(d) === -1).length) {
													warning('Нельзя удалить! Удаляемые записи привязаны в настройке \'Отчеты формируемые без открытия окна параметров\'');
													return;
												}
											}
										}
										
										me.setValue(item, JSON.stringify(links), true);

										const displayValue = me.getDictValueToDisplay(value, item);
										rec.set('InitValue', displayValue);
										rec.set('Value', displayValue);

										const valueJSON = JSON.stringify(value.map(v => v.data || v));
										rec.set('EditorTypeName', valueJSON);
										rec.set('InitExtValue', valueJSON);
									}
								}
							);
						}
						if (beforeCreateFn && Ext.isFunction(beforeCreateFn))
							beforeCreateFn(showDict);
						else
							showDict();

					}
				}
			}
		});
	},

	getDictValueToDisplay: function (values, item) {
		let displayValue;
		if (values.length === 1) {
			const visibleFields = dictListController[item.CodeDict]?.getVisibleFields ? dictListController[item.CodeDict].getVisibleFields() : "CODE,NAME";
			displayValue = window.getTextByVisibleFields(item.CodeDict, visibleFields, values[0].data);
		} else {
			displayValue = values.length === 0 ? 'Нет отобранных значений (записей)' : 'Отобрано значений (записей) - ' + values.length
		}
		return displayValue;
	},

	/**
	 * Серверное сохранение значения настройки (используется для настроек типа REFER и настроек, редактируемых в отдельном модальном окне)
	 * @param item {object} объект настройки
	 * @param v {object} значение
	 * @param isRefer {boolean} тип REFER (да/нет)
	 * */
	setValue: function (item, v, isRefer) {
		const setting = {
			Value: v,
			ObjCode: item.ObjCode,
			PropCode: item.Code,
			User: this.user,
			IsRefer: isRefer
		};
		if (isRefer) setting.DictCode = item.CodeDict;
		return Settings.setValue([setting]);
	},

	setSaveRules: function (owner, item, v) {
		if (owner) owner.setLoading(KS.L10n.settings_saving);
		return new Promise(function (resolve, reject) {
			ajaxRequest({
				url: 'SSettings/SetSaveRules_A',
				params: {value: JSON.stringify(v.data), code: item.ObjCode},
				success: function (res) {
					if (owner) owner.setLoading(false);
					if (res) {
						item.EditorTypeName = JSON.stringify(res.value);
						item.Value = res.message;
					}
					resolve(res.message);
				},
				failure: function (res) {
					if (owner) owner.setLoading(false);
					console.err('Ошибка сохранения настройки "Правила предварительного контроля" ' + res);
					reject('error', r);
				}
			});
		});
	},

	/**
	 * Сохранить настройку автонумерации
	 * @param owner {Ext.Component} окно, откуда вызвали
	 * @param item {object} объект настройки
	 * @param v {object} значение
	 * @param callback
	 * */
	setAutoNumeric: function (owner, item, v, callback) {
		let me = this;
		owner && owner.setLoading(KS.L10n.settings_saving);
		ajaxRequest({
			url: 'SSettings/SetAutoNumeric_A',
			params: {value: JSON.stringify(v), objCode: item.ObjCode, propCode: item.Code},
			success: function (res) {
				owner && owner.setLoading(false);
				QuickMsgs.save();
				if (callback) callback(res);
			},
			failure: function (res) {
				owner && owner.setLoading(false);
				if (callback) callback(res);
			}
		});
	},

	setFilter: function (owner, item, v) {
		owner.setLoading(KS.L10n.settings_saving);
		return new Promise(function (resolve, reject) {
			ajaxRequest({
				url: 'SSettings/SetFilter_A',
				params: {value: v, objCode: item.ObjCode, propCode: item.Code, user: -1},
				success: function (res) {
					if (owner) owner.setLoading(false);
					QuickMsgs.save();
					resolve(res);
				}
			});
		});
	},

	/**
	 * Сохранить настройку "Реквизиты
	 * @param owner {Ext.Component} окно, откуда вызвали
	 * @param item {object} объект настройки
	 * @param v {object} значение
	 * @param callback
	 * */
	setDefaultProp: function (owner, item, data, callback) {
		owner && owner.setLoading(KS.L10n.settings_saving);
		ajaxRequest({
			url: 'SSettings/SetDefaultProp_A',
			params: {value: JSON.stringify(data), objCode: item.ObjCode},
			success: function (res) {
				owner && owner.setLoading(false);
				QuickMsgs.save();
				if (res) {
					let newValue = JSON.parse(item.EditorTypeName);
					newValue.data = data;
					item.EditorTypeName = JSON.stringify(newValue);
					item.Value = res;
				}
				if (callback) callback(res);
			},
			failure: function (res) {
				owner && owner.setLoading(false);
				if (callback) callback(res);
			}
		});
	},

	/**
	 * Есть изменения
	 * @returns {*}
	 */
	getChanges: function () {
		return this.store.getDataExt().filter(r => r.Changed);
	},

	/**
	 * Откатить изменения
	 */
	cancelChanges: function () {
		this.store.data.items.filter(r => r.data.Changed).forEach(r => {
			r.data.Value = r.data.InitValue;
			r.data.EditorTypeName = r.data.InitExtValue;
			r.data.Changed = false;
		});
		this.getView().refresh();
	},

	/**
	 * Применить изменения
	 */
	storeChanges: function () {
		this.store.data.items.filter(r => r.data.Changed).forEach(r => {
			r.data.InitValue = r.Value;
			r.data.InitExtValue = r.EditorTypeName;
			r.data.Changed = false;
		});
		this.getView().refresh();
	},

	/**
	 * Переключить отображение
	 * @param enableGrouping с группировкой или без
	 */
	switchGrouping(enableGrouping) {
		const groupFeature = this.features.filter(f => f instanceof Ext.grid.feature.Grouping)[0];
		if (!groupFeature || groupFeature.disabled === !enableGrouping) return;
		
		if (enableGrouping) {
			groupFeature.enable();
		}
		else{
			groupFeature.disable();
			this.store.sort('Name', 'ASC');
		}
		this.reconfigure();
	},
	
	
});
