﻿Ext.define('Keysystems.Panel.Prop', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Abstract'],
	title: 'Реквизиты',
	layout: {type: 'vbox', align: 'stretch'},
	fieldExt: 'VAL_CODE',
	fieldLink: 'S_PROP',
	fieldFile: 'VAL',
	fieldName: 'TEMP_SPROP_NAME',
	scrollable: true,
	autoRender: true,
	bodyPadding: 0,
	border: 0,
	saveFunc: null,
	showComment: null,
	decimalData: {
		groupSep: ' ',
		decimalSep: '.',
		decimals: 0
	},	
	constructor: function(cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initKsData: function(ksData) { ksData.link = -1; },

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		
		if (me.showComment === null) me.showComment = me.parentView.code.startsWith('DICTIONARY_S');

		me.store = Ext.create('Ext.data.TreeStore', {
			fields: [],
			data: [],
			listeners: { beforeload: function() { return !me.isCreate; } },
			remoteSort: false,
			proxy: 'memory',
			defaultRootText: '',
			sorters: ['ORD'],
			loadData: function(data) { me.propPanel.setRootNode({ expanded: true, children: data }); }
		});

		me.items = [
			me.propPanel = Ext.create('Ext.tree.Panel', {
				rootVisible: false,
				sortableColumns: false,
				allowDeselect: false,
				rowLines: true,
				flex: 1,
				border: 0,
				columns: [],
				columnLines: true,
				viewConfig: { isLockingView: true },
				saveFunc: null,
				store: me.store,
				tbar: me.createTBar(),
				features: [
					{
						ftype: 'summary',
						showSummaryRow: false
					}
				],
				plugins:[
					Ext.create('Ext.grid.plugin.CellEditing', {
						clicksToEdit: 1,
						listeners: {
							beforeedit: function(th, col) {
								var rec = col.record,
									readOnly = rec.get('TEMP_SPROP_READONLY');

								return !(me.readOnly || readOnly);
							}
						}
					}),
					'gridclipboard'
				]				
			}),
			Ext.create('Ext.resizer.Splitter', {hidden: !this.showComment}),
			Ext.create('Ext.panel.Panel', {
				layout: 'fit',
				bodyPadding: 10,
				border: 0,
				hidden: !this.showComment,
				items:[
					me.sksc('propComment', Ext.create('Ext.form.field.TextArea',
						{
							flex: 1,
							fieldLabel: 'Примечание',
							readOnlyCls: '',
							readOnly: true
						}))
				]
			})			
		]
		me.propPanel.on('selectionchange', (th, sels)=>{
			me.onSelectionChange(th, sels);	
		});
		me.callParent(arguments);
	},

	onSelectionChange: function(th, sels) {
		var me = this,
			rec = sels[0],
			remDis = true;

		if (me.readOnly || (rec && rec.get('TEMP_SPROP_READONLY'))) return;
		if (rec) {
			remDis = ArrayLib.filter(rec.parentNode.childNodes, ['data', 'S_PROP'], rec.get('S_PROP')).length < 2;
			let ord = rec.get('ORD'),
				maxOrd = rec.parentNode.childNodes.length - 1;

			me.gksc('tsbTopProp').setDisabled(!ord);
			me.gksc('tsbUpProp').setDisabled(!ord);
			me.gksc('tsbDownProp').setDisabled(ord === maxOrd);
			me.gksc('tsbBottomProp').setDisabled(ord === maxOrd);
			me.gksc('tsbCleanProp').setDisabled(!(rec.get('VAL') || '').toString().replace(/[0\s]+/g, ''));
			me.gksc('tsbFillProp').setDisabled(me.gksc('tsbFillProp').needDisable(rec));
			me.gksc('tsbMaskProp').setDisabled(['Файл', 'Список', 'Флаг'].indexOf(miscTypes.CalcType[rec.data.TEMP_SPROP_TYPE]) !== -1);
			me.gksc('propComment').setValue(rec.get('TEMP_SPROP_COMMENT'));
		}
		else
			me.gksc('propComment').setValue(null);

		me.gksc('tsbSameProp').setDisabled(!rec);
		me.gksc('tsbDeleteProp').setDisabled(remDis);
	},

	addSameProp: function(rec, copyVal) {
		let me = this,
			d = rec.getData();

		if (!copyVal) {
			delete d.VAL;
			delete d.VAL_CODE;
			delete d.VAL_NAME;
		}
		d.leaf = true;
		d.LINK = me.ksData.link--;
		Ext.each(rec.parentNode.childNodes, function(el) { if (el.get('ORD') > d.ORD) el.set('ORD', el.get('ORD') + 1); });
		d.ORD++;
		rec.parentNode.appendChild(d);
		me.propPanel.store.sort('ORD', 'ASC');

		me.onSelectionChange(me, [me.propPanel.getFrstSelect()]);
	},

	createTBar: function() {
		var me = this;
		return [
			me.sksc('tsbSaveProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_save',
				tooltip: 'Сохранить',
				tooltipType: 'title',
				hidden: true,
				handler: function() {
					if (me.saveFunc) me.saveFunc(me.getData());
				}
			})),
			me.sksc('tsbDictProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_dict',
				tooltip: 'Реквизиты',
				tooltipType: 'title',
				hidden: true,
				handler: function() {
					var selectLinks = [];
					me.store.each(function(r) { selectLinks.push({ data: { LINK: r.get('S_PROP') } }); });

					var settings = {
						    mode: 'MULTI',
						    parentView: me,
						    selectLinks: selectLinks,
						    code: dnl.S_PROP
					    },
						functions = {
							ok: function(values) {
								//todo вероятно где-то здесь должна быть установка поля ORD, сейчас всегда 0 после выбора
								
								var delList = [];
								me.store.each(function(r) {
									var pos = ArrayLib.find(values, ['data', 'LINK'], r.get('S_PROP'));
									if (pos === -1) {
										delList.push(r);
									} else {
										values.splice(pos, 1);
									}
								});
								for (var i = 0, len = delList.length; i < len; i++) delList[i].parentNode.removeChild(delList[i], true);
								var root = me.store.getRootNode();
								Ext.each(values, function(val) {
									var r = {
										S_PROP: val.data.LINK,
										TEMP_SPROP_CODE: val.data.CODE,
										TEMP_SPROP_NAME: val.data.NAME,
										TEMP_SPROP_TYPE: val.data.TYPE,
										LIST: val.raw.LIST,
										DICT_CODE: val.data.DICT_CODE,
										leaf: val.data.leaf,
										root: val.data.root
									};
									root ? root.appendChild(r) : me.store.loadData(r, false);
								});
							}
						};

					dictFunc(settings, functions);
				}
			})),
			me.sksc('tsbSameProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_copy',
				tooltip: 'Создать подобный',
				tooltipType: 'title',
				hidden: true,
				disabled: true,
				handler: function() {
					var rec = me.propPanel.getFrstSelect();
					if (rec) {
						if (rec.get('VAL').replace(/[0\s]+/g, '')) {
							Ext.Msg.show({
								title: wmc.get('AddSameProp'),
								msg: wmc.get('CopyPropVal'),
								buttons: Ext.MessageBox.YESNOCANCEL,
								fn: function(bId) { if (bId !== 'cancel') me.addSameProp(rec, bId === 'yes'); },
								icon: Ext.MessageBox.QUESTION
							});
						} else {
							me.addSameProp(rec);
						}
					}
				}
			})),
			me.sksc('tsbDeleteProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				hidden: true,
				disabled: true,
				handler: function() {
					me.removeSelection(function(el) {
						var root = me.store.getRootNode(),
							ord = el.get('ORD');
						Ext.each(root.childNodes, function(e) { if (e.get('ORD') > ord) e.set('ORD', e.get('ORD') - 1); });
					}, function() { me.onSelectionChange(me, [me.propPanel.getFrstSelect()]); });
				}
			})),
			me.sksc('tsbMaskProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_mask',
				tooltip: 'Маска',
				tooltipType: 'title',
				hidden: true,
				//disabled: true,
				handler: function() {
					var rec = me.propPanel.getFrstSelect();
					if (rec) {
						Ext.create('Keysystems.Controls.FormulaEditor', {
							text: rec.get('VAL'),
							/*Code: me.Code,
							IncludeThruNumber: me.IncludeThruNumber,
							IncludeSCalc: me.IncludeSCalc,
							SCalcLinks: me.SCalcLinks,
							SWorkLinks: me.SWorkLinks,
							DH1: me.DH1,
							DH2: me.DH2,
							IsMask: me.IsMask,*/
							okFunc: function(text) { rec.set('VAL', text); },
							parentView: me
						});
					}
				}
			})),
			me.sksc('tsbFillProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_fill',
				tooltip: 'Заполнить',
				tooltipType: 'title',
				needDisable: function(rec) { return !rec.get('MASK'); },
				//hidden: true,
				disabled: true,
				handler: function() { me.calculateProp.call(me); }
			})),
			me.sksc('tsbCleanProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_clean',
				tooltip: 'Очистить значение',
				tooltipType: 'title',
				disabled: true,
				handler: function() {
					Ext.Msg.show({
						title: wmc.get('CleanTitle'),
						msg: wmc.get('Clean'),
						buttons: Ext.MessageBox.YESNO,
						fn: function(bId) {
							if (bId === 'yes') {
								var rec = me.propPanel.getFrstSelect();
								rec.set('VAL_CODE', '');
								rec.set('VAL_NAME', '');
								rec.set('VAL', '');
							}
						},
						icon: Ext.MessageBox.QUESTION
					});
				}
			})),
			{ xtype: 'tbseparator' },
			me.sksc('tsbExpand', Ext.create('Ext.Button', {
				iconCls: 'x_btn_treeexpand',
				tooltip: 'Развернуть все узлы',
				tooltipType: 'title',
				handler: function() {
					setTimeout(function() {
						var root = me.propPanel.getStore().getRootNode();
						if (root) root.expandChildren(true);
					}, 10);
				}
			})),
			me.sksc('tsbCollapse', Ext.create('Ext.Button', {
				iconCls: 'x_btn_treecollapse',
				tooltip: 'Свернуть все узлы',
				tooltipType: 'title',
				handler: function() {
					setTimeout(function() {
						var root = me.propPanel.getStore().getRootNode();
						if (root) root.collapseChildren(true);
					}, 10);
				}
			})),
			{ xtype: 'tbseparator' },
			me.sksc('tsbTopProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_top',
				tooltip: 'В начало',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.moveRec(_, 0); }
			})),
			me.sksc('tsbUpProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_up',
				tooltip: 'Вверх',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.moveRec(-1); }
			})),
			me.sksc('tsbDownProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_down',
				tooltip: 'Вниз',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.moveRec(1); }
			})),
			me.sksc('tsbBottomProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_bottom',
				tooltip: 'В конец',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.moveRec(_, me.propPanel.getFrstSelect().parentNode.childNodes.length - 1); }
			}))
		];
	},

	moveRec: function(d, pos) {
		var me = this,
			rec = me.propPanel.getFrstSelect();
		if (rec) {
			var ord = rec.get('ORD');
			if (pos === _) {
				pos = ord + d;

				var swapRec = ArrayLib.filter(rec.parentNode.childNodes, ['data', 'ORD'], ord + d)[0];
				if (swapRec) swapRec.set('ORD', ord);
			} else {
				Ext.each(rec.parentNode.childNodes, pos < ord ? function(el) { if (el.get('ORD') < ord) el.set('ORD', el.get('ORD') + 1); } : function(el) { if (el.get('ORD') > ord) el.set('ORD', el.get('ORD') - 1); }
				);
			}
			rec.set('ORD', pos);
			me.propPanel.store.sort('ORD', 'ASC');
			me.onSelectionChange(me, [rec]);
		}
	},

	loadData: function(propData) {
		var me = this;

		if (Ext.isArray(propData)) return me.propPanel.setRootNode({ expanded: true, children: propData });

		if (propData.AllowPropSelect) me.gksc('tsbDictProp').show();
		if (propData.AllowPropSave) me.gksc('tsbSaveProp').show();
		if (!propData.AllowPropFill && propData.AllowPropFill !== _) me.gksc('tsbFillProp').hide();
		if (propData.AllowPropMask) me.gksc('tsbMaskProp').show();
		if (propData.AllowPropCopy) {
			me.gksc('tsbSameProp').show();
			me.gksc('tsbDeleteProp').show();
		}
		if (!propData.AllowPropUpDown) {
			me.gksc('tsbTopProp').hide();
			me.gksc('tsbUpProp').hide();
			me.gksc('tsbDownProp').hide();
			me.gksc('tsbBottomProp').hide();
		}

		me.columnsUpd(propData.columns);
		me.fieldsUpd(propData.fields);

		me.propPanel.setMetaDate(propData, {
			profileCode: me.parentView.code,
			profileKey: 'Prop',
			gateCode: me.parentView.keyEdit
		});

		me.oldData = JSON.stringify(me.dataCollector());
		me.onSelectionChange(me, [me.propPanel.getFrstSelect()]);

		return me;
	},

	isMask: function(val){
		return val && val.indexOf && val.indexOf('{') >= 0;
	},
	getData: function(isJson) {
		const me = this;
		return this.propPanel.store.getDataExt(function(rec) {
			if (rec.VAL && miscTypes.CalcType[rec.TEMP_SPROP_TYPE] === 'Дата' && !me.isMask(rec.VAL)) 
				rec.VAL = (new Date(rec.VAL)).toDateString();
			if (rec.VAL === undefined) rec.VAL = null;
			return rec;
		}, isJson);
	},

	thereIsField: function(fields, name) {
		return (Ext.Array.indexOf(fields, name) !== -1) || (ArrayLib.find(fields, ['name'], name) !== -1);
		},
	fieldsUpd: function(fields) {
		var me = this;
		if (!me.thereIsField(fields, 'id')) fields.push('id');
		if (!me.thereIsField(fields, 'tree')) fields.push('tree');
	},
	columnsUpd: function(columns) {
		var me = this;

		if (ArrayLib.find(columns, ['dataIndex'], 'tree') === -1) {
			columns.unshift(me.getTreeColumnCfg());
		}

		var pos = ArrayLib.find(columns, ['dataIndex'], 'VAL');
		if (pos !== -1) {
			var colVal = columns[pos];
			colVal.xtype = 'multitypecolumn';
			colVal.align = 'byType';
			colVal.fieldType = 'TEMP_SPROP_TYPE';
			colVal.fieldExt = me.fieldExt;
			colVal.fieldDictCode = 'DICT_CODE';
			colVal.decimalData = me.decimalData;
			colVal.fileEdit = me.fileEdit.bind(me);
			colVal.getList = function(rec) {
				var res = [];
				Ext.each(rec.get('LIST').split('\r\n'), function(el) { res.push({ val: el }); });
				return res;
			};
			colVal.initWhereArgs = function(rec) {
				return getMaskWhereArgs(me.getParentLink(), me.getParentCode(), rec.get('LIST'));
			};
			colVal.getXtype = function(t) {
				var type = this.types[t];
				
				switch (type) {
				case 'Текст':
					return {
						xtype: 'triggertexteditor',
						maxLength: 8000,
						getEditorTitle: function() { return colVal.text; },
						listeners: { change: function(th, v) { if (th.editRecord) th.editRecord.set('VAL', v); } }
					};
				default:
					return this.callParent(arguments);
				};
			};
		}

		pos = ArrayLib.find(columns, ['dataIndex'], 'COND');
		if (pos !== -1) {
			columns[pos].editor = {
				xtype: 'formulaedit',
				listeners: {
					change: function(th, v) {
						var rec = ArrayLib.getByPath(th, 'ownerCt.editingPlugin.context.record');
						if (rec) rec.set('COND', v);
					}
				}
			};
		}
	},

	getParentView: function() { return this.parentView; },

	getParentLink: function() { return this.getParentView().getLink(); },

	getParentCode: function() { return this.getParentView().code; },

	setVals: function(v) {
		this.set('VAL_CODE', v.VAL_CODE);
		this.set('VAL_NAME', v.VAL_NAME);
		this.set('VAL', v.VAL);
	},

	getCalcParams: function() { return JSON.stringify(this.calcParams || {}); },

	calculateProp: function() {
		var me = this,
			rec = me.propPanel.getFrstSelect();
		if (!(me.getParentView() && rec && rec.get('MASK'))) return;

		const loadMask = new Ext.LoadMask({
			msg: 'Подсчет...',
			target: me,
			autoShow: true,
			rid: ajaxRequest({
				url: 'SCalc/CalculateProp_A',
				params: {
					code: me.getParentCode(),
					link: me.getParentLink(),
					formula: rec.get('MASK'),
					calcType: rec.get('TEMP_SPROP_TYPE'),
					dictCode: rec.get('DICT_CODE') || '',
					prms: me.getCalcParams()
				},
				success: function(result) { me.setVals.call(rec, result); },
				failure: function() { me.setVals.call(rec, {}); },
				callback: function() { loadMask.destroy(); }
			})
		});
	},

	dataCollector: function() {
		let me = this,
			data = me.getData();
		return data;
	},

	isFilled: Ext.trueFn,
	
	setReadOnly: function(v){
		this.readOnly = true;
		this.propPanel.setReadOnly(v);
		this.propPanel.getToolbar().items.items.forEach(item=>{
			if (['x_btn_treeexpand','x_btn_treecollapse'].indexOf(item.iconCls) === -1)
				item.setDisabled(true);
		});
	},

	//#region редактирование файла

	fileEdit: function(rec) {
		var me = this;

		Ext.create('Keysystems.File', {
			iconCls: getExtStyle(rec.get(me.fieldExt)),
			createFile: function(callBack) { me.createFile(rec.get(me.fieldLink), callBack); },
			updRecord: function(fileObj) { me.updFileRecord(fileObj, rec); },
			getFileId: function() { return rec.get(me.fieldFile); },
			downloadFile: function() { me.downloadFile(rec); },
			clearFile: function() { me.clearFile(rec); }
		});
	},
	createFile: function(propLink, callBack) { 
		var me = this,
			parentView = me.parentView,
			link = parentView.ksData.link;
		
		if (link > 0) {
			UploaderLib.newFile(parentView.code, link, propLink, -1, 0, me, callBack);
		} else {
			warning("Необходимо сохранить запись!");
		}
	},
	clearFile: function(rec) {
		var me = this;
		me.updFileRecord({ id: 0, ext: '' }, rec);
	},
	updFileRecord: function(fileObj, rec) {
		var me = this;
		rec.beginEdit();
		rec.set(me.fieldFile, fileObj.id);
		rec.set(me.fieldExt, fileObj.ext);
		rec.endEdit();
	},
	downloadFile: function(rec) { UploaderLib.getFile(rec.get(this.fieldFile), rec.get(this.fieldName)); },

	//#endregion редактирование файла
});