﻿var ksGantt = {
	zoomWidth: [2, 5, 10, 20, 30, 60, 120, 180, 300, 360, 480],
	zoomLevels: function (preset) {
		var key = 'zoom_' + preset;
		if (this[key]) return this[key];
		var res = [];
		Ext.each(this.zoomWidth, function (w) {
			res.push({
				width: w,
				increment: 1,
				resolution: 1,
				preset: preset,
				resolutionUnit: 'DAY'
			});
		});
		return this[key] = res;
	}
};

// ReSharper disable UseOfImplicitGlobalInFunctionScope
Sch.preset.Manager.registerPreset('Keysystems.Gantt.Tasks', {
// ReSharper restore UseOfImplicitGlobalInFunctionScope
	//Отображение даты в тулбаре для регламентов (только число)
	timeColumnWidth: 40,
	rowHeight: 24,
	displayDateFormat: 'd',
	shiftUnit: 'DAY',
	shiftIncrement: 1,
	timeResolution: {unit: 'DAY', increment: 1},
	headerConfig: {middle: {unit: 'DAY', align: 'center', dateFormat: 'd'}}
});

Sch.preset.Manager.registerPreset("Keysystems.Gantt.Status", {
	//Отображение даты в тулбаре для статусов (пустое)
	timeColumnWidth: 40,
	rowHeight: 24,
	displayDateFormat: 'd',
	shiftUnit: 'DAY',
	shiftIncrement: 1,
	timeResolution: {unit: 'DAY', increment: 1},
	headerConfig: {middle: {unit: "DAY", align: 'center', dateFormat: '\t'}}
});

Ext.define('Keysystems.Panel.Gantt', {
	extend: 'Gnt.panel.Gantt',
	multiSelect: false,
	leftLabelField: 'NAME',
	enableTaskDragDrop: false,
	resize: 'right',
	autoScroll: false,
	batchSync: false,
	highlightWeekends: false,
	loadMask: false,
	resizeHandles: 'right',
	cascadeChanges: false,
	visibleZoomFactor: 5,
	tooltipTpl: new Ext.XTemplate('<h4 class="tipHeader">{NAME}</h4>').compile(),
	dayConst: 864e5,
	isDuration: true,

	taskCls: 'ks-gantt-task',
	initialCls: 'ks-initial',
	optionalCls: 'ks-optional',

	fieldDOCC: 'TASKDOCC',
	fieldDOCP: 'TASKDOCP',

	columns: [{xtype: 'namecolumn', width: 200}],
	createTBar: function () {
		var me = this;
		return [
			{
				iconCls: 'x_btn_new',
				tooltip: 'Создать',
				tooltipType: 'title',
				handler: function () {
					me.edit({f: 'new'});
				}
			},
			me.copyBtn = Ext.create('Ext.Button', {
				key: 'same',
				iconCls: 'x_btn_copy',
				tooltip: 'Создать подобную',
				tooltipType: 'title',
				disabled: true,
				handler: function () {
					me.edit({f: 'copy'});
				}
			}),
			{
				key: 'edit',
				iconCls: 'x_btn_edit',
				tooltip: 'Редактировать',
				tooltipType: 'title',
				disabled: true,
				handler: function () {
					me.edit({f: 'edit'});
				}
			},
			{
				key: 'delete',
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				disabled: true,
				handler: function () {
					me.remove();
				}
			},
			{xtype: 'tbseparator'},
			{
				iconCls: 'x_btn_ZoomIn',
				tooltip: 'Увеличить',
				tooltipType: 'title',
				handler: function () {
					if (me.getTaskStore().toArray().length > 1) me.zoomIn();
				}
			},
			{
				iconCls: 'x_btn_ZoomOut',
				tooltip: 'Уменьшить',
				tooltipType: 'title',
				handler: function () {
					if (me.getTaskStore().toArray().length > 1) me.zoomOut();
				}
			},
			{
				iconCls: 'x_btn_ZoomToFit',
				tooltip: 'По ширине',
				tooltipType: 'title',
				handler: function () {
					if (me.getTaskStore().toArray().length > 1) me.zoomToFit(me.getTaskStore().toArray());
				}
			},
			{
				iconCls: 'x_btn_gotobar',
				tooltip: 'Перейти к текущему',
				tooltipType: 'title',
				handler: function () {
					var sel = me.getSelectionModel().getSelection();
					if (sel.length) {
						me.scrollToDate(sel[0].raw.StartDate);
					}
				}
			}
		];
	},

	initComponent: function () {
		var me = this;

		me.tbar = me.createTBar();

		me.timeAxis = Ext.create('Sch.data.TimeAxis', {
			//Ось времени,куда помещаются таски
			continuous: true, //Бесконечная
			autoAdjust: true //Адаптация на основании start-end
		});
		me.viewConfig = {
			getRowClass: function (rec) {
				var cls = me.taskCls;
				if (rec.get('INITIAL')) {
					cls += ' ' + me.initialCls;
				}
				if (rec.get('OPTIONAL')) {
					cls += ' ' + me.optionalCls;
				}
				return cls;
			},
			dependencyViewConfig: {
				onDependencyDrop: function (th, from, to) {
					me.editSeq(from, to);
				},
				dragZoneConfig: {
					listeners: {
						dndstart: function (dragzone) {
							dragzone.proxy.el.hide();
						}
					}
				}
			}
		};

		me.callParent(arguments);

		me.store.dependencyStore.isValidDependency = me._isValidDependency;

		me.on('dependencycontextmenu', function (th, rec, e) {
			me.showSeqContextMenu(rec, e);
			e.stopEvent();
		});
		me.on('dependencydblclick', function (th1, rec) {
			me.editSeq(rec.get(me.fieldDOCP), rec.get(me.fieldDOCC));
		});
		me.on('itemdblclick', function (th1, record) {
			me.edit({f: 'edit', record: record, callBack: me.addTask});
		});
		me.on('selectionchange', function (th1, record) {
			let toolbar = me.getToolbar(),
				tBarItems = toolbar ? toolbar.items.items : null;
			if (!toolbar || !tBarItems) return;
			
			tBarItems.filter(item => ['same', 'edit', 'delete'].indexOf(item.key) >= 0)
				.forEach(item => item.setDisabled(me.readOnly || !record.length));
		});
	},

	_isValidDependency: function (h, b, e, g) {
		var d, c, a;
		var f = h instanceof Gnt.model.Dependency;
		if (f) {
			d = h.getSourceId();
			c = this.getTaskById(d);
			b = h.getTargetId();
			a = this.getTaskById(b);
			if (h.stores.length) {
				g = h;
			}
		} else {
			d = h;
			c = this.getTaskById(d);
			a = this.getTaskById(b);
		}
		if (!g && f && !h.isValid()) {
			return false;
		} else {
			if (!d || !b || d == b) {
				return false;
			}
		}
		if (!c || !a || c.contains(a) || a.contains(c)) {
			return false;
		}
		/*if (this.hasTransitiveDependency(d, b, g) /* || this.hasTransitiveDependency(b, d, g)) {
			return false;
		}
		/*var s = this.successorsHaveTransitiveDependency(d, b, g);
		if (s) {
			return false;
		}
		s = this.predecessorsHaveTransitiveDependency(d, b, g);
		if (s) {
			return false;
		}*/
		/*if (this.strictDependencyValidation) {
			if (this.groupsHasTransitiveDependency(a.getInternalId(), c.getInternalId(), g)) {
				return false;
			}
		}*/
		return true;
	},

	setGanttData: function (ganttModel) {
		var me = this,
			ts = me.taskStore;
		if (ganttModel) {
			me.adaptGanttData(ganttModel);

			//Загружаем колонки
			var pos = ArrayLib.find(ganttModel.columns, ['dataIndex'], 'CODE');
			if (pos !== -1) ganttModel.columns[pos].width = 45;

			pos = ArrayLib.find(ganttModel.columns, ['dataIndex'], me.leftLabelField);
			if (pos !== -1) ganttModel.columns[pos].width = 150;

			me.lockedGrid.reconfigure(ts, ganttModel.columns);

			//Задаем старт - конец
			ts.getTasksTimeSpan = function () {
				return {start: ganttModel.StartDate, end: ganttModel.EndDate};
			};

			//Загружаем поля
			ts.setFields(ganttModel.fields);

			//Загружаем таскс и сортируем
			me.taskStore.reload();
			ganttModel.tasks.forEach(task => {				
				me.taskStore.getRootNode().appendChild(new TaskTaskModel(task));
			});			
			ts.sort('Group', 'ASC');
			//Загружаем зависимости
			me.dependencyStore.loadData(ganttModel.sequence);
			me.timeAxis.setTimeSpan(ganttModel.StartDate, ganttModel.EndDate);
		} else {
			ts.loadData([], false);
			me.dependencyStore.loadData([], false);
		}
	},

	addStartDate: function (tasks, startDate, duration, today) {
		var me = this;
		Ext.each(tasks, function (t) {
			if (!t.StartDate) {
				t.StartDate = startDate ? new Date(startDate.getTime() + duration * me.dayConst) : today;
				t.EndDate = new Date(t.StartDate.getTime() + t.DURATION * me.dayConst);
				me.addStartDate(t.child, t.StartDate, t.DURATION);
			}
		});
	},

	_addObjSeq: function (t, s, next) {
		var me = this,
			kf, //key find
			kg, //key get
			ka, //key array
			f;
		if (next) {
			kf = me.fieldDOCP;
			kg = me.fieldDOCC;
			ka = 'child';
		} else {
			kf = me.fieldDOCC;
			kg = me.fieldDOCP;
			ka = 'parent';
		}

		f = t.LINK === s[kf];
		if (f) {
			var i = ArrayLib.find(me.tasks, ['LINK'], s[kg]);
			if (i === -1) t.GROUP = s;
			else t[ka].push(me.tasks[i]);
		}
		return f;
	},

	addObjSeq: function (task) {
		var me = this;
		task.parent = [];
		task.child = [];
		Ext.each(me.sequence, function (s) {
			if (!me._addObjSeq(task, s, 0)) me._addObjSeq(task, s, 1);
		});
	},

	adaptTask: function (tasks) {
		var me = this;
		Ext.each(tasks, function (t) {
			if (!t.Group && t.Group !== 0) {
				t.Group = me._group++;
				me.adaptTask(t.child);
			}
		});
	},

	addSeqCP: function (task) {
		var me = this;
		task.seqP = [];
		task.seqC = [];
		Ext.each(me.sequence, function (s) {
			if (task.LINK === s[me.fieldDOCC]) {
				task.seqP.push(s);
			} else if (task.LINK === s[me.fieldDOCP]) {
				task.seqC.push(s);
			}
		});
	},

	adaptGanttData: function (ganttModel) {
		if (!ganttModel.tasks.length) return ganttModel;
		var me = this,
			tasks = ganttModel.tasks,
			sequence = ganttModel.sequence,
			i = 0,
			len;

		me.tasks = tasks;
		me.sequence = sequence;

		//Добавляем всем таскам зависимости и атрибуты
		Ext.each(tasks, function (t) {
			t.DURATION = t.DURATION || 1;
			t.DurationUnit = 'd';
			t.leaf = true;
			t.Name = t.NAME;
			me.addObjSeq(t);
			delete t.Group;
			delete t.StartDate;
		});

		me._group = 0;

		//Сначала добавляем все инициирующие и их child
		var arrInit = Ext.Array.filter(tasks, function (t) {
			return t.INITIAL && !t.parent.length;
		});
		me.adaptTask(arrInit);

		//Остальные
		var arrOth = Ext.Array.filter(tasks, function (t) {
			return !t.Group && t.Group !== 0;
		});
		me.adaptTask(arrOth);

		//Добавляем начало - конец
		me.addStartDate(arrInit.concat(arrOth), 0, 0, new Date(new Date().toDateString()));

		//Добавляю филд сортировки
		if (ArrayLib.find(ganttModel.fields, ['name'], 'Group') === -1) {
			ganttModel.fields.push({name: 'Group', type: 'int'});
		}

		//Добавляю информацию о E-MAIL
		Ext.each(ganttModel.mail, function (m) {
			i = ArrayLib.find(tasks, ['LINK'], m.TASKDOC);
			if (i !== -1) tasks[i].mail = m;

			var tmp1 = ArrayLib.filter(ganttModel.mailUsers, ['TASKDOCMAIL'], m.LINK),
				users = [];
			Ext.each(tmp1, function (row) {
				var user = ArrayLib.filter(ganttModel.users, ['LINK'], row.S_USERS)[0];
				if (user) users.push(user);
			});
			m.users = users;
		});

		var max = tasks[0].EndDate,
			min = tasks[0].StartDate;
		Ext.each(tasks, function (t) {
			me.addSeqCP(t);
			if (t.EndDate > max) max = t.EndDate;
			if (t.StartDate < min) min = t.StartDate;

			//Обнуляю зависимости до LINK
			for (i = 0, len = t.child.length; i < len; i++) t.child[i] = t.child[i].LINK;
			for (i = 0, len = t.parent.length; i < len; i++) t.parent[i] = t.parent[i].LINK;
		});

		//Добавляем длительность
		i = ArrayLib.find(ganttModel.columns, ['dataIndex'], 'DURATION');

		if (me.isDuration) {
			var tmp = {
				dataIndex: 'DURATION',
				draggable: false,
				hidden: false,
				text: 'Длительность',
				width: 60
			};
			if (i === -1) {
				ganttModel.columns.push(tmp);
			} else {
				ganttModel.columns[i] = tmp;
			}
		} else {
			if (i !== -1) {
				ganttModel.columns.splice(i, 1);
			}
		}

		ganttModel.StartDate = new Date(min.getTime() - me.dayConst);
		ganttModel.EndDate = new Date(max.getTime() + me.dayConst);

		return ganttModel;
	},

	edit: function (cfg) {
		var me = this;
		me.editFn(cfg.f, cfg.record || me.getSelectionModel().getSelection()[0], Ext.emptyFn, me);
	},

	remove: function () {
		var me = this;
		me.removeFn(me.getSelectionModel().getSelection(), me);
	},

	showSeqContextMenu: Ext.emptyFn,
	addSeq: Ext.emptyFn,
	editFn: Ext.emptyFn,
	removeFn: Ext.emptyFn
});

window.ksGantt = ksGantt;