﻿Ext.define('Keysystems.Panel.Calc', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	layout: { type: 'vbox', align: 'stretch' },
	disableCellCls: '', //'ks-disable-cell',
	enableCellCls: 'ks-enable-cell',
	scalcEditableCls: 'ks-scalc-editeble',
	isFill: true,
	flex: 1,
	readOnlyList: ['cmbTRevizObjects'],
	arrDisable: ['new', 'delete', 'check', 'calc', 'fill', 'calcauto'],

	dtTable: 'DT_VAL',
	personTable: 'PERSON_VAL',
	dtPersonTable: 'DT_PERSON_VAL',

	getFields: function() {
		return this.fields || (this.fields = [
			'id',
			'tree',
			'LINK',
			'LINK_SELF',
			'S_CALC',
			'CODE',
			'NAME',
			'ORD',
			'TYPE',
			'FORMULA',
			'RECALC',
			'LATER',
			'AUTOPERSON',
			'DH1',
			'DH2',
			'VAL',
			'DT',
			'ReadOnly',
			'HasChilds',
			'table',
			'S_PERSON'
		]);
	},
	getColumns: function() {
		const me = this;		
		return me.columns || (me.columns = [
			me.getTreeColumnCfg(),
			{
				dataIndex: 'CODE',
				text: 'Код',
				flex: 2,
				menuDisabled: true,
				renderer: me.cellRenderer.bind(me)
			},
			{
				dataIndex: 'NAME',
				text: 'Наименование',
				flex: 6,
				format: 'd.m.Y',
				menuDisabled: true,
				renderer: function(v, m, r) {
					if (r.get('table') === me.dtTable) return renderDate(new Date(v), m, r);
					return me.cellRenderer(v, m, r);
				},
				editor: {
					xtype: 'datefield',
					format: 'd.m.Y',
					listeners: {
						change: function(th, nv, ov) {
							if (th.isReturnValue) return;
							var rec = me.grid.editingPlugin.activeRecord,
								back = false;
							rec.parentNode.eachChild(function(r) {
								if (rec !== r && th.isEqual(nv, new Date(r.get('DT')))) {
									back = true;
									return false;
								}
								return true;
							});
							if (back) {
								warning(wmc.get('CrossingPeriod', Ext.Date.format(nv, 'd.m.Y')));
								th.isReturnValue = true;
								th.setValue(ov);
								th.isReturnValue = false;
							} else {
								rec.set('DT', nv);
							}
						}
					}
				}
			},
			{
				dataIndex: 'VAL',
				text: 'Значение',
				flex: 2,
				xtype: 'multitypecolumn',
				menuDisabled: true,
				tdCls: 'valTdCls',
				decimalData: me.decimalData,
				renderer: function (v, m, r) {
					if (!r.get('ReadOnly')) m.tdCls += ' ' + me.enableCellCls;
					const col = this.headerCt?.getGridColumns().filter(col => col.dataIndex === 'VAL')[0];
					return col.defaultRenderer ? col.defaultRenderer.call(col, v, m, r) : v;
				}
			}
		]);
	},
	cellRenderer: function(v, m, r) {
		m.tdCls += ' ' + this.disableCellCls;
		return v;
	},

	initKsData: function(ksData) {
		ksData.calcLink = -1;
		ksData.sCalcData = {};
		ksData.rawData = {};
	},

	initKsControls: function(ksControls) {
		var me = this;
		ksControls.cmbTRevizObjects = me.createCmbTRevizObjects();
		if (!me.store) {
			me.store = Ext.create('Ext.data.TreeStore', {
				fields: me.getFields(),
				sorters: [{ property: 'ORD', direction: 'ASC' }],
				proxy: 'memory',
				defaultRootText: '',
				rootNode: { expanded: true, children: [] }
			});
		}
		ksControls.grid = me.createGrid();
	},

	createCmbTRevizObjects: function() {
		var me = this;
		return Ext.create('Ext.form.ComboBox', {
			labelWidth: me.labelWidth,
			fieldLabel: 'Объект',
			editable: false,
			padding: 5,
			value: '',
			displayField: 'TEMP_NAME',
			valueField: 'LINK',
			queryMode: 'local',
			store: Ext.create('Ext.data.Store', {
				fields: [{ name: 'LINK', type: 'int' }, 'TEMP_NAME'],
				data: me.getTRevizObjects()
			}),
			listeners: {
				change: function(th, v, ov) {
					if (ov) me.setSCalcData(ov);
					me.updSCalcData();
				}
			}
		});
	},

	createGrid: function() {
		var me = this;
		return Ext.create('Ext.tree.Panel', {
			autoScroll: true,
			autoRender: true,
			rootVisible: false,
			sortableColumns: false,
			flex: 1,
			tbar: me.createTBarGrid(),
			border: 0,
			store: me.store,
			columns: me.getColumns(),
			columnLines: true,
			autoSizeOnExpandCollapse: true,
			plugins: [
				Ext.create('Ext.grid.plugin.CellEditing', {
					clicksToEdit: 1,
					listeners: {
						beforeedit: function(editor, e) {
							if (me.readOnly || e.field === 'NAME' && e.record.get('table') !== me.dtTable) return false;
							return true;
						}
					}
				})
			],
			viewConfig: {
				isLockingView: true,
				getRowClass: function(r) {
					let rowStyle = '';
					if (!r.get('ReadOnly')) rowStyle += me.scalcEditableCls;

					let isBold = me.getSCalcsBold().filter(link => link === r.get('LINK'));
					if (isBold.length) rowStyle += 'x-bold';
					
					return rowStyle;
				}
			},
			listeners: {
				selectionchange: function(th, sels) { me.gridCalc_AfterRowActivate(sels[0]); },
				itemdblclick: function(th, rec) {
					if (!rec.get('table')) {
						me.calcEdit(rec);
					}
				},
				render: function(grid) {
					let view = grid.getView();
					view.tip = Ext.create('Ext.tip.ToolTip', {
						shadow: false,
						target: view.getId(),
						delegate: view.itemSelector + ' .valTdCls',
						trackMouse: true,
						listeners: {
							beforeshow: function updateTipBody(tip) {
								let tipGridView = tip.target.component,
									record = tipGridView.getRecord(tip.triggerElement),
									formula = record.get('FORMULA'),
									type = record.get("TYPE");
								if (!formula && (type === null || type === undefined)) return false;

								let tooltip = [];
								if (formula) tooltip.push(`Формула: ${record.get('FORMULA')}`);
								if (type !== null && type !== undefined) tooltip.push(`Тип: ${miscTypes.CalcType[record.get("TYPE")]}`);
								tip.update(tooltip.join('<br />'));
							}
						}
					});
				},
			}
		});
	},

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();

		me.items = [me.getKsControl('cmbTRevizObjects'), me.grid = me.getKsControl('grid')];

		me.callParent(arguments);
	},

	isInWorkPeriod: function(dt) {
		var dh = this.getDTPeriod();
		return (dt = new Date(dt)) >= dh.dh1 && dt <= dh.dh2;
	},

	getManager: function(personRows) {
		var res = _;
		Ext.each(personRows, function(r) {
			var d = (r.data || r),
				s = d.STATUS;
			if (miscTypes.RevizorStatus[s] === 'Руководитель' || s === 'Руководитель') {
				res = d;
				return false;
			}
			return true;
		});
		return res;
	},

	isCalcByPersonReadOnly: function(rowSCalc) {
		var type = rowSCalc.get('TYPE'),
			isFormula = type !== null && rowSCalc.get('FORMULA'),
			byPersons = type != null && rowSCalc.get('AUTOPERSON') !== null,
			autoPerson = byPersons && (miscTypes.CalcType[type] === 'Количество' || miscTypes.CalcType[type] === 'Сумма') ?
				rowSCalc.get('AUTOPERSON') : 0,
			formulaByPersonsReadOnly = isFormula && byPersons &&
			((rowSCalc.get('FORMULA').indexOf('ГРУППА') !== -1) || (rowSCalc.get('FORMULA').indexOf('{Нарушение}') !== -1));
		return formulaByPersonsReadOnly || autoPerson !== 0;
	},

	// Добавить запись значения показателя
	insertDSCalcRow: function(rowDsCalc) {
		if (!rowDsCalc) return;
		var me = this,
			rowDtVal,
			dh = me.getDTPeriod(),
			//dt = new Date(dh.dh1.toDateString());
			dt = new Date(me.getDT().toDateString());
		rowDsCalc.eachChild(function(rec) {
			if (rec.get('table') !== me.dtTable) return;
			rowDtVal = rec;
			var d = new Date(rec.get('DT'));
			if (d > dt) dt = d;
		});
		dt.setDate(dt.getDate() + 1);
		if (!me.isInWorkPeriod(dt)) dt = new Date();

		var autoPerson = rowDsCalc.get('AUTOPERSON'),

			rowDtValNew = rowDsCalc.appendChild({
				NAME: dt,
				DT: dt,
				table: me.dtTable,
				S_CALC: rowDsCalc.get('LINK'),
				leaf: true,
				LINK: me.ksData.calcLink--,
				ReadOnly: autoPerson === 0,
				TYPE: rowDsCalc.get('TYPE'),
				LATER: true,
				HasChilds: rowDsCalc.get('HasChilds')
			});

		rowDsCalc.set('leaf', false);

		me.FillDSCalcRow(rowDtValNew, rowDsCalc);

		if (autoPerson !== null) {
			rowDtValNew.set('leaf', false);
			var personRows = me.getSPersons();
			if (miscTypes.AutoPersonMethod[autoPerson] === 'Все - руководителю группы') {
				var p = me.getManager(personRows);
				me.FillDSCalcRow(rowDtValNew.appendChild({
					DT: dt,
					S_CALC: rowDsCalc.get('LINK'),
					LINK: me.ksData.calcLink--,
					ReadOnly: true,
					S_PERSON: p.LINK,
					leaf: true,
					LATER: true,
					CODE: p.CODE,
					NAME: p.NAME,
					table: me.dtPersonTable,
					TYPE: rowDsCalc.get('TYPE'),
					HasChilds: rowDsCalc.get('HasChilds')
				}), rowDsCalc);
			} else {
				Ext.each(personRows, function(r) {
					var d = r.data || r;
					me.FillDSCalcRow(rowDtValNew.appendChild({
						DT: dt,
						S_CALC: rowDsCalc.get('LINK'),
						LINK: me.ksData.calcLink--,
						ReadOnly: me.isCalcByPersonReadOnly(rowDsCalc),
						S_PERSON: d.LINK,
						CODE: d.CODE,
						NAME: d.NAME,
						leaf: true,
						LATER: true,
						table: me.dtPersonTable,
						TYPE: rowDsCalc.get('TYPE'),
						HasChilds: rowDsCalc.get('HasChilds')
					}), rowDsCalc);
				});
			}
		}
	},

	FillDSCalcRow: Ext.emptyFn,

	gridCalc_AfterRowActivate: function(rec) {
		var me = this,
			tsb = me.tsb;
		me.activeRow = rec;

		if (me.readOnly) return _;
		if (rec) {
			var add = !me.grid.isDisabled() && !rec.get('HasChilds') && rec.get('LATER') && rec.get('TYPE') !== null,
				del = add && rec.get('table') === me.dtTable; // && me.isInWorkPeriod(rec.get('DT'));

			tsb.new.setDisabled(!add);
			tsb.delete.setDisabled(!del);
			tsb.calc.setDisabled(!!rec.get('table'));
		} else {
			tsb.new.disable();
			tsb.delete.disable();
			tsb.calc.disable();
		}
	},

	tsbCalcNew_Click: function() {
		var me = this;
		if (!me.activeRow || me.activeRow.get('HasChilds') || !me.activeRow.get('LATER')) return;

		var calcRow = me.activeRow.get('table') ? me.store.getNodeBy(me.activeRow.get('S_CALC')) : me.activeRow;
		if (calcRow) me.insertDSCalcRow(calcRow);
	},

	createTBarGrid: function() {
		var me = this,
			tsb = me.tsb = {};
		return [
			tsb.new = Ext.create('Ext.Button', {
				iconCls: 'x_btn_new',
				tooltip: 'Создать',
				tooltipType: 'title',
				disabled: true,
				scope: me,
				handler: me.tsbCalcNew_Click
			}),
			tsb.delete = Ext.create('Ext.Button', {
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.grid.removeSelection(function(r) { return r.get('table') === me.dtTable; }); }
			}),
			Ext.create('Ext.Button', {
				iconCls: 'x_btn_treeexpand',
				tooltip: 'Развернуть все узлы',
				tooltipType: 'title',
				handler: function() {
					me.grid.enableAnimations = false;
					me.grid.expandAll();
					me.grid.enableAnimations = true;
					// обновим, т.к. пропадают записи
					me.grid.view.refresh();
				}
			}),
			Ext.create('Ext.Button', {
				iconCls: 'x_btn_treecollapse',
				tooltip: 'Свернуть все узлы',
				tooltipType: 'title',
				handler: function() {
					me.grid.enableAnimations = false;
					me.grid.collapseAll();
					me.grid.enableAnimations = true;
				}
			}),
			{ xtype: 'tbseparator' },
			tsb.calcauto = Ext.create('Ext.button.Split', {
				iconCls: 'x_btn_calcauto',
				tooltip: 'Пересчитать показатели',
				tooltipType: 'title',
				menu: {
					items: [
						{
							text: 'Все - руководителю группы',
							handler: function() { me.fillDcSCalcMsg(1); }
						},
						{
							text: 'Пропорционально времени участия',
							handler: function() { me.fillDcSCalcMsg(2); }
						},
						{
							text: 'Всем - поровну',
							handler: function() { me.fillDcSCalcMsg(3); }
						}
					]
				},
				handler: function() { me.fillDcSCalcMsg(null); }
			}),
			tsb.check = Ext.create('Ext.Button', {
				iconCls: 'x_btn_check',
				tooltip: 'Контроль показателей',
				tooltipType: 'title',
				handler: function() { me.checkDsCalc(); }
			}),
			{ xtype: 'tbseparator' },
			tsb.calc = Ext.create('Ext.Button', {
				iconCls: 'x_btn_edit',
				tooltip: 'Редактировать показатель',
				tooltipType: 'title',
				handler: function() {
					var sel = me.grid.getSelectionModel().getSelection()[0];
					if (sel && !sel.get('table')) me.calcEdit(sel);
				}
			}),
			{ xtype: 'tbseparator' },
			tsb.fill = Ext.create('Ext.Button', {
				iconCls: me.getFillIconCls(),
				tooltip: me.getFillText(),
				tooltipType: 'title',
				handler: function() {
					me.isFill = !me.isFill;
					this.setIconCls(me.getFillIconCls());
					this.setTooltip(me.getFillText());
					me.setSCalcData(me.getKsControl('cmbTRevizObjects').getValue());
					me.updSCalcData();

					var grid = me.ksControls.grid,
						store = grid.getStore(),
						filter = store.filters.items.filter(f => { return f._property === 'VAL'; })[0];
					
					if (filter) {
						store.filters.remove(filter);
					}
					if (!me.isFill) {
						store.filters.add({
								property: 'VAL',
								filterFn: function (item) {
									var v = item.get('VAL');
									return v && (v + '').replace(/[0\s,.]+/g, '');
								}
							}
						);
					}
					
					store.filter();
					grid.collapseAll();
				}
			})
			//{ xtype: 'tbseparator' },
			//tsb.refresh = Ext.create('Ext.Button', {
			//	iconCls: 'x_btn_refresh',
			//	tooltip: 'Обновить',
			//	tooltipType: 'title',
			//	handler: function() {
			//		//me.parentSave(function() {
			//		me.clear();
			//		me.upd();
			//		//});
			//	}
			//})
		];
	},

	calcEdit: function(rec) {
		var me = this,
			cfg = {
				f: 'edit',
				data: rec,
				title: 'Показатели',
				linkCode: 'SCalc',
				code: dnl.S_CALC,
				updRecord: function() {
					me.parentSave(function() {
						me.clear();
						me.upd();
					});
				},
				readOnly: me.readOnly || me.ksReadOnly,
				parentView: me
			};

		Ext.create('Keysystems.SCalc.Edit', cfg);
	},

	getFillIconCls: function() { return this.isFill ? 'x_btn_fill' : 'x_btn_empty'; },
	getFillText: function() { return this.isFill ? 'Скрыть пустые' : 'Показать пустые'; },

	getCmbTRevizObjectsData: function() {
		var res = ArrayLib.filter(this.getTRevizObjects(), ['LINK_SELF'], null);
		res = quickSort(res, 1);
		return res;
	},

	getCalcItem: function(source, link) {
		var i = ArrayLib.find(source, ['LINK'], link, 0, ['children']);
		if (i === -1) return _;
		if (!Ext.isArray(i)) i = [i];
		var res = { children: source };
		Ext.each(i, function(k) { res = res.children[k]; });
		return res;
	},

	_arrVal: ['PERSON_VAL', 'DT_VAL', 'DT_PERSON_VAL'],

	dataSetConvert: function(ds, persons) {
		var me = this,
			res = ds.S_CALC;
		Ext.each(me._arrVal, function(n) {
			Ext.each(ds[n], function(v) {
				var p = me.getCalcItem(res, v.S_CALC);
				if (p) {
					v.table = n;
					v.leaf = true;
					v.LINK = me.ksData.calcLink--;
					if (v.S_PERSON) {
						if (v.DT) p = ArrayLib.filter(p.children || (p.children = []), ['DT'], v.DT)[0] || p;

						var person = ArrayLib.filter(persons, ['S_PERSON'], v.S_PERSON)[0];
						if (person) {
							v.CODE = person.TEMP_SPERSON_CODE;
							v.NAME = person.TEMP_SPERSON_FIO;
						}
					} else {
						if (v.DT) v.NAME = v.DT;
					}
					p.leaf = false;
					(p.children || (p.children = [])).push(v);
				}
			});
		});
		return { expanded: true, children: res };
	},

	getSCalcData: function(object, callBack) {
		var me = this,
			raw = me.ksData.rawData,
			sCalcData = me.ksData.sCalcData;

		if (sCalcData[object]) {
			callBack(sCalcData[object]);
			return;
		}

		const audit = ArrayLib.filter(me.getTRevizAudit(), ['T_REVIZ_OBJECTS'], object)[0];
		if (audit) {
			const loadMask = new Ext.LoadMask({
				msg: KS.L10n.loading_data,
				view: me,
				rid: ajaxRequest({
					url: 'SReviz/GetDsCalc_A',
					params: { link: me.getRevizLink(), audit: audit.LINK },
					success: function(result) {
						callBack(sCalcData[object] = me.dataSetConvert(result, me.getSPersons()));

						me.setSCalcData(object);
						raw[object] = JSON.stringify(sCalcData[object]);
					},
					callback: function() { loadMask.destroy(); }
				})
			});
			loadMask.show();
		}
	},

	setSCalcData: function(audit) {
		var root = this.store.getRootNode();
		if (root) this.ksData.sCalcData[audit] = this.getRecordData(root);
	},

	getRecordData: function(node) {
		var me = this,
			res = node.getData();
		//delete res.expanded;
		res.loaded = false;
		res.children = [];
		Ext.each(node.childNodes, function(c) { res.children.push(me.getRecordData(c)); });
		return res;
	},

	checkDsCalc: function(callBack) {
		var me = this;
		if (!me.getKsControl('cmbTRevizObjects').store.getCount() && callBack) {
			callBack();
		} else {
			me.genDSCalc(_, function (calc) {
				const loadMask = new Ext.LoadMask({
					msg: wmc.getMask('CalcsControl'),
					target: me,
					autoShow: true,
					rid: ajaxRequest({
						url: 'SReviz/CheckDsCalc_A',
						params: { link: me.getRevizLink(), calc: JSON.stringify(calc) },
						success: function (result) {
							if (result) {
								Ext.create('Keysystems.CheckMsg', { msg: result.msg.replace('\r', '<br>'), nextFn: callBack, isNext: !result.critical }).show();
							} else {
								if (callBack) {
									callBack();
								} else {
									Ext.Msg.show({
										title: 'Контроль показателей',
										msg: wmc.get('NoErrors'),
										buttons: Ext.MessageBox.OK,
										animateTarget: me,
										icon: Ext.MessageBox.INFO
									});
								}
							}
						},
						callback: function () { loadMask.destroy(); }
					})
				});
			});
		}
	},

	fillDcSCalcMsg: function(forceAutoPerson) {
		var me = this,
			rec = me.grid.getSelectionModel().getSelection()[0];
		if (rec) {
			me.extraSelfDialogShow(
				function() { me.fillDcSCalcItog(forceAutoPerson); },
				function() { me.fillDcSCalcItog(forceAutoPerson, rec); }
			);
		} else {
			me.extraDialogShow(function() { me.fillDcSCalcItog(forceAutoPerson); });
		}
	},

	recalcRequest: function(params, object) {
		var me = this;
		// Долгая команда
		me.showLoadMaskLong({
			msg: wmc.getMask('RecalcCalcs'),
			url: 'SReviz/RecalcDsCalc_A',
			params: params,
			success: function(result) {
				if (result.S_CALC && result.S_CALC.length) {
					me.ksData.sCalcData[object] = me.dataSetConvert(result, me.getSPersons());
					me.updSCalcData();
				}
			}
		});		
	},

	fillDcSCalcItog: function(forceAutoPerson, rec) {
		var me = this;

		me.genDSCalc(_, function(calc) {
			var object = me.getKsControl('cmbTRevizObjects').getValue();
			var audit = ArrayLib.filter(me.getTRevizAudit(), ['T_REVIZ_OBJECTS'], object)[0];
			if (!audit) return;
			me.recalcRequest({
				link: me.getRevizLink(),
				forceAutoPerson: forceAutoPerson,
				audit: audit.LINK,
				calc: JSON.stringify(calc),
				calcLink: rec ? rec.get('table') ? rec.get('S_CALC') : rec.get('LINK') : 0
			}, object);
		});
	},

	runByChildren: function(root, metod, i) {
		var me = this;
		i = i || 0;
		Ext.each(root.children, function(r) {
			metod(r, i);
			if (r.children) me.runByChildren(r, metod, i + 1);
		});
	},

	getLaterPersonVal: function(rec, audit, dt, res) {
		var me = this;
		//if (!(r.children && r.children.length)) return;
		Ext.each(rec.children, function(r) {
			if (r.table !== me.dtTable || !r.VAL) return;
			res.push({
				S_CALC: r.S_CALC,
				VAL: r.VAL,
				DT: r.DT || dt,
				S_PERSON: null,
				T_REVIZ_AUDIT: audit
			});
		});
	},

	getLaterVal: function(rec, audit, dt, res) {
		var me = this;
		//if (!(r.children && r.children.length)) return;
		Ext.each(rec.children, function(r) {
			if (r.table !== me.dtTable || !r.VAL) return;
			res.push({
				S_CALC: r.S_CALC,
				VAL: r.VAL,
				DT: r.DT || dt,
				S_PERSON: null,
				T_REVIZ_AUDIT: audit
			});
		});
	},

	getPersonVal: function(rec, audit, dt, res) {
		var me = this;
		//if (!(r.children && r.children.length)) return;
		Ext.each(rec.children, function(r) {
			if (r.table !== me.dtPersonTable || !r.VAL) return;
			res.push({
				S_CALC: r.S_CALC,
				VAL: r.VAL,
				DT: r.DT || dt,
				S_PERSON: null,
				T_REVIZ_AUDIT: audit
			});
		});
	},

	getTableLvlName: function(i) { return 'S_CALC' + (i ? ('_Level' + i) : ''); },

	_arrCalcRow: ['LINK', 'LINK_SELF', 'CODE', 'NAME', 'ORD', 'TYPE', 'FORMULA', 'RECALC', 'LATER', 'AUTOPERSON', 'DH1', 'DH2', 'VAL', 'DT', 'ReadOnly', 'HasChilds'],
	_arrOtherRow: ['LINK', 'S_CALC', 'VAL', 'DT', 'S_PERSON', 'ReadOnly', 'HasChilds', 'TYPE', 'AUTOPERSON', 'LATER', 'FORMULA'],

	serializeDsCalc: function(d) {
		var me = this,
			res = {};
		me.runByChildren(d, function(r, i) {
			switch (r.table) {
			case me.dtTable:
			case me.personTable:
			case me.dtPersonTable:
				(res[r.table] || (res[r.table] = [])).push(ArrayLib.copyByKeys(me._arrOtherRow, r, {}));
				break;
			default:
				var tn = me.getTableLvlName(i);
				(res[tn] || (res[tn] = [])).push(ArrayLib.copyByKeys(me._arrCalcRow, r, {}));
			}
		});
		return res;
	},

	genDSCalc: function(audit, callback) {
		var me = this;

		audit = audit || me.getKsControl('cmbTRevizObjects').getValue();

		me.setSCalcData(audit);

		me.getSCalcData(audit, function(d) { callback(me.serializeDsCalc(d)); });
	},

	extraDialogShow: function(yesFunc, noFunc, callBack) {
		var me = this;
		Ext.Msg.show({
			title: KS.L10n.RECALC_TITLE,
			msg: Ext.String.format(KS.L10n.RevizTasks_RevizRecalc, ''),
			buttons: Ext.MessageBox.YESNO,
			buttonText: { yes: 'Да', no: 'Нет' },
			animateTarget: me,
			fn: function(buttonId) {
				if (buttonId === 'yes') {
					if (yesFunc) yesFunc();
				} else {
					if (noFunc) noFunc();
				}
				if (callBack) callBack();
			},
			icon: Ext.MessageBox.QUESTION
		});
	},

	extraSelfDialogShow: function(yesFunc, extraFunc, noFunc, callBack) {
		var me = this;
		Ext.Msg.show({
			title: KS.L10n.RECALC_TITLE,
			msg: Ext.String.format(KS.L10n.RevizTasks_RevizRecalc, ''),
			buttons: Ext.MessageBox.YESNOCANCEL,
			buttonText: { yes: 'Да', no: 'Текущий', cancel: 'Нет' },
			animateTarget: me,
			fn: function(buttonId) {
				switch (buttonId) {
				case 'yes':
					if (yesFunc) yesFunc();
					break;
				case 'no':
					if (extraFunc) extraFunc();
					break;
				default:
					if (noFunc) noFunc();
				}
				if (callBack) callBack();
			},
			icon: Ext.MessageBox.QUESTION
		});
	},

	getData: function(fn) {
		var me = this,
			raw = me.ksData.rawData,
			sCalcData = me.ksData.sCalcData,
			res = {};

		me.setSCalcData(me.getKsControl('cmbTRevizObjects').getValue());

		Ext.each(me.getTRevizObjects(), function(o) {
			if (sCalcData[o.LINK] && raw[o.LINK] && JSON.stringify(sCalcData[o.LINK]) !== raw[o.LINK]) {
				var d = me.serializeDsCalc(sCalcData[o.LINK]);
				if (Ext.isFunction(fn)) d = fn(d, o.LINK);
				if (d) res[o.LINK] = JSON.stringify(d);
			}
		});
		return res;
	},

	clear: function() {
		this.ksData.rawData = {};
		this.ksData.sCalcData = {};
		this.store.root = _;
	},

	setReadOnly: function(state) {
		var th = this,
			ksc = th.ksControls;

		th.readOnly = state;
		Ext.each(th.arrDisable, function(name) {
			if (th.tsb[name].setDisabled) th.tsb[name].setDisabled(state);
		});

		Ext.each(th.readOnlyList, function(name) {
			ksc[name] && ksc[name].setReadOnly && ksc[name].setReadOnly(state);
		});
	},

	//#region upd

	upd: function() {
		this.updCmbTRevizObjects();
		this.updSCalcData();
	},

	updCmbTRevizObjects: function() {
		var me = this,
			cmb = me.getKsControl('cmbTRevizObjects');
		cmb.loadData(me.getCmbTRevizObjectsData());
		cmb.setValueSelectOrFrst();
	},

	updSCalcData: function() {
		var me = this;
		me.getSCalcData(me.getKsControl('cmbTRevizObjects').getValue(), function(d) {
			me.store.setRootNode(JSON.parse(JSON.stringify(d)));
		});
	},

	//#endregion upd

	//#region by override

	//by override
	getTRevizObjects: function() {
		throw new Error(wmc.get('NeedOverride'));
		return [];
	},

	//by override
	getTRevizAudit: function() {
		throw new Error(wmc.get('NeedOverride'));
		return [];
	},

	//by override
	getDT: function() {
		throw new Error(wmc.get('NeedOverride'));
		return new Date();
	},

	//by override
	getDTPeriod: function() {
		throw new Error(wmc.get('NeedOverride'));
		return { dh1: longPeriod.begin, dh2: longPeriod.end };
	},

	//by override
	getRevizLink: function() {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	getSPersons: function() {
		throw new Error(wmc.get('NeedOverride'));
		return [];
	},
	//by override
	getSCalcsBold: function () {
		throw new Error(wmc.get('NeedOverride'));
		return [];
	},

	//by override
	parentSave: function(callBack) {
		throw new Error(wmc.get('NeedOverride'));
		callBack();
	}

	//#endregion by override
});