﻿/*
Copyright (c) 2014 Keysystems.ru

Contact:  http://www.keysystems.ru/contact

Commercial Usage
Licensees holding valid commercial licenses may use this file in accordance with the Commercial Software License Agreement provided with the Software or, alternatively, in accordance with the terms contained in a written agreement between you and Sencha.

If you are unsure which license is appropriate for your use, please contact the sales department at http://www.keysystems.ru/contact


Авторское право (c) 2014 Keysystems.ru

Контакты:  http://www.keysystems.ru/contact

Коммерческое использование
Лицензиаты имеющие действительные коммерческие лицензии могут использовать этот файл в соответствии с лицензионным соглашением коммерческого программного обеспечения поставляемой с программным обеспечением либо, альтернативно, в соответствии с условиями содержащимися в письменном соглашении между вами и Sencha.

Если вы не уверены, какая лицензию подходит для вашего использования, пожалуйста, свяжитесь с отделом продаж в http://www.keysystems.ru/contact
*/

Ext.define('Keysystems.Controls.NestedGrid.RowExpander', {
	extend: 'Ext.grid.plugin.RowExpander',
	noChildrenCss: 'x-grid-row-expander-none',
	addCollapsedCls: {
		before: function(values, out) {
			var me = this.rowExpander;
			if (me.hasChildren(values.record)) {
				if (!me.recordsExpanded[values.record.internalId]) {
					values.itemClasses.push(me.rowCollapsedCls);
				}
			} else {
				values.itemClasses.push(me.noChildrenCss);
			}
		},
		priority: 500
	},
	toggleRow: function(rowIdx, record) {
		var me = this,
			ownerLock = me.grid.ownerLockable,
			lockedView = ownerLock.lockedGrid.view,
			lockedRow = Ext.fly(lockedView.getNode(rowIdx), '_rowExpander'),
			fireView,
			isCollapsed,
			row,
			nextBd,
			rowNode,
			view;

		var r = me.setRowExpand(rowIdx, record);
		if (r.returnBreak) return;
		isCollapsed = r.isCollapsed;

		var addOrRemoveCls = isCollapsed ? 'removeCls' : 'addCls',
			fireGrid = ownerLock || me.grid;

		view = me.view;
		rowNode = view.getNode(rowIdx);
		row = Ext.fly(rowNode, '_rowExpander');
		nextBd = row.down(me.rowBodyTrSelector, true);

		Ext.suspendLayouts();
		row[addOrRemoveCls](me.rowCollapsedCls);
		Ext.fly(nextBd)[addOrRemoveCls](me.rowBodyHiddenCls);
		me.recordsExpanded[record.internalId] = isCollapsed;
		view.refreshSize();

		fireGrid.fireEvent(isCollapsed ? 'expandbody' : 'collapsebody', row.dom, record, nextBd, row.down('.' + fireGrid.expandBoxCls, true));

		if (ownerLock) {
			fireView = ownerLock.getView();
			me.resizeLockedRow(rowIdx, record, row, lockedView);
			lockedRow[addOrRemoveCls](me.rowCollapsedCls);
			lockedView.refreshSize();
		} else {
			fireView = view;
		}
		fireView.fireEvent(isCollapsed ? 'expandbody' : 'collapsebody', row.dom, record, nextBd);

		Ext.resumeLayouts(true);
	},

	resizeLockedRow: function (rowIdx, record, row, view) {
		if (row) {
			var rowHeight = row.getHeight(),
				g = record.grid,
				byScroll = 17; //для отрисовки скролла
			row = Ext.fly(view.getNode(rowIdx), '_rowExpander');
			if (g && (!g.renderCount)) {
				g.view.refreshSize();
				g.view.setHeight(g.view.getHeight() + byScroll); 

				g.columnManager.headerCt.resizeLockedRow = row.dom;
				g.columnManager.headerCt.on('resize', function (th, w, h) {
					if (th.resizeLockedRow) {
						th.resizeLockedRow.style.height = Ext.dom.AbstractElement.addUnits(h + rowHeight + byScroll);
						delete th.resizeLockedRow;
					}
				});
				g.renderCount = 1;
			}

			row.setHeight(rowHeight);
		}
	},

	resizeAllLockedRows: function() {
		var me = this,
			recs = me.grid.store.data.items,
			len = recs.length,
			view = me.grid.ownerLockable.lockedGrid.view,
			i = 0;
		for (; i < len; i++) {
			me.resizeLockedRow(i, recs[i], Ext.fly(me.view.getNode(i), '_rowExpander'), view);
		}
	},

	hasChildren: function() {
		return true;
	},

	setRowExpand: function(rowIdx, record) {
		var me = this,
			lockedView = me.grid.ownerLockable.lockedGrid.view,
			lockedRow = Ext.fly(lockedView.getNode(rowIdx), '_rowExpander');
		if (lockedRow) {
			var isCollapsed = lockedRow.hasCls(me.rowCollapsedCls),
				isChildren = lockedRow.hasCls(me.noChildrenCss),
				returnBreak;
			if (me.hasChildren(record)) {
				if (isChildren) {
					lockedRow.removeCls(me.noChildrenCss);
					lockedRow.addCls(me.rowCollapsedCls);
					isCollapsed = true;
				}
			} else {
				if (!isChildren) {
					lockedRow.addCls(me.noChildrenCss);
				}
				if (isCollapsed) {
					lockedRow.removeCls(me.rowCollapsedCls);
				} else {
					var view = me.view,
						rowNode = view.getNode(rowIdx),
						row = Ext.fly(rowNode, '_rowExpander'),
						nextBd = row.down(me.rowBodyTrSelector, true);
					Ext.fly(nextBd).addCls(me.rowBodyHiddenCls);
					me.recordsExpanded[record.internalId] = false;
					me.resizeLockedRow(rowIdx, record, row, lockedView);
				}
				returnBreak = true;
			}
		}
		return { isCollapsed: isCollapsed, returnBreak: returnBreak };
	},

	setAllRowExpand: function() {
		var me = this,
			recs = me.grid.store.data.items,
			len = recs.length,
			i = 0;
		for (; i < len; i++) {
			me.setRowExpand(i, recs[i]);
		}
	},

	onKeyDown: function(view, record, row, rowIdx, e) {
		var ds = view.store,
			sels = view.getSelectionModel().getSelection(),
			ln = sels.length,
			i = 0;
		switch (e.getKey()) {
		case e.ENTER:
			for (; i < ln; i++) {
				rowIdx = Ext.Array.indexOf(ds, sels[i]);
				this.toggleRow(rowIdx, sels[i]);
			}
			break;
		case e.LEFT:
			for (; i < ln; i++) {
				if (this.recordsExpanded[sels[i].internalId]) {
					rowIdx = Ext.Array.indexOf(ds, sels[i]);
					this.toggleRow(rowIdx, sels[i]);
				}
			}
			break;
		case e.RIGHT:
			for (; i < ln; i++) {
				if (!this.recordsExpanded[sels[i].internalId]) {
					rowIdx = Ext.Array.indexOf(ds, sels[i]);
					this.toggleRow(rowIdx, sels[i]);
				}
			}
			break;
		}
	}
});

Ext.define('Keysystems.Controls.NestedGrid', {
	extend: 'Ext.grid.Panel',
	eventDelay: 20,
	config: {
		columns: [],
		data: [],
		autoScroll: true,
		columnLines: true,
		expandBoxCls: 'ux-row-expander-box',
		expandOnDblClick: true,
		relationField: 'LINK',
		relationSubField: 'LINK',
		subGridData: [],
		subGridFields: [],
		subGridColumns: [],
		subGridSelects: [],
		subGridSelectField: 'LINK',
		subSelModel: 'Ext.selection.RowModel',
		subSelectedItemCls: 'x-reviz-row-focus',
		subOverItemCls: 'x-reviz-row-over'
	},
	constructor: function(cfg) {
		var me = this;
		me.initConfig(cfg);
		me.callParent(arguments);
	},
	initComponent: function() {
		var me = this;

		me.enableLocking = true;
		me.lastSelectNode = [];

		//subGrids
		me.subGrids = [];
		me.subModel = Ext.define('Ext.data.Store.ImplicitModel-' + Ext.id(), {
			extend: 'Ext.data.Model',
			fields: me.subGridFields,
			proxy: 'memory'
		});
		me.loadSubData(me.subGridData);
		me.viewConfig = {
			indexInStore: function(node) {
				node = node && node.isCollapsedPlaceholder ? this.getNode(node) : this.getNode(node, false);
				if (!node && node !== 0) {
					return -1;
				}
				var recordIndex = node.getAttribute('data-recordIndex');
				if (recordIndex) {
					return parseInt(recordIndex, 10);
				}
				return this.dataSource.indexOf(this.getRecord(node));
			},
			getRecord: function(node) {
				node = this.getNode(node);
				if (node) return this.dataSource.data.get(node.getAttribute('data-recordId'));
			}
		};

		me.rowExpander = Ext.create('Keysystems.Controls.NestedGrid.RowExpander', {
			rowBodyTpl: '<div class="' + me.expandBoxCls + '"></div>',
			expandOnDblClick: false,
			hasChildren: function(rec) {
				return me.getSubDataByRec(rec).length;
			}
		});
		me.plugins = me.plugins || [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 })];
		if (Ext.isArray(me.plugins)) {
			me.plugins.push(me.rowExpander);
		} else {
			me.plugins = [me.rowExpander, me.plugins];
		}

		if (!me.store) {
			if (!me.model) {
				me.model = Ext.define('Ext.data.Store.ImplicitModel-' + Ext.id(), {
					extend: 'Ext.data.Model',
					fields: [],
					proxy: 'memory'
				});
			}
			me.store = Ext.create('Ext.data.Store', {
				model: me.model,
				sorters: me.sorters,
				data: me.data
			});
		}
		if (!me.selModel) {
			me.selModel = Ext.create('Ext.selection.RowModel', {
				mode: me.selectionMode
			});
		}

		if (!me.listeners) me.listeners = {};
		me.listeners.expandbody = function(rowNode, record, expandRow, expandBox) {
			if (!record.grid || !expandBox.childNodes.length) {
				var store = Ext.create('Ext.data.Store', {
					model: me.subModel,
					sorters: me.subSorters,
					data: me.getSubDataByRec(record)
				});
				record.grid = Ext.create('Ext.grid.Panel', {
					ownerRecord: record,
					overflowY: 'auto',
					relationValue: record.data[me.relationField],
					autoDestroy: true,
					ownerCt: me,
					store: store,
					selModel: Ext.create(me.subSelModel),
					columns: me.subGridColumns,
					plugins: me.subPlugins || [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 })],
					viewConfig: {
						selectedItemCls: me.subSelectedItemCls,
						overItemCls: me.subOverItemCls,
						getRecord: function(node) {
							node = this.getNode(node);
							if (node) return this.dataSource.data.get(node.getAttribute('data-recordId'));
						},
						focus: function(selectText, delay, callback, scope) {
							var saveScroll = Ext.isIE && !delay,
								scrollPos,
								ownerScrollPos;

							if (saveScroll) {
								scrollPos = this.el.dom.scrollLeft;
								ownerScrollPos = me.normalGrid.view.el.dom.scrollLeft;
							}
							//this.callParent(arguments);
							Ext.Component.prototype.focus.call(this, selectText, delay, callback, scope);
							if (saveScroll) {
								this.el.dom.scrollLeft = scrollPos;
								me.normalGrid.view.el.dom.scrollLeft = ownerScrollPos;
							}
						}
					},
					listeners: me.subListeners
				});
				record.grid.on('select', function(th, rec) {
					var parentRow = th.view.ownerCt.ownerRecord;
					if (me.selModel.selectionMode === 'SINGLE') {
						me.deselectCount = 1;
						setTimeout(function() {
							me.deselectCount = 0;
						}, me.eventDelay);
						me.subDeselect(record.grid, true);
						me.selModel.select(parentRow);
					} else {
						if (ArrayLib.find(me.subGridSelects, [selField], rec.data.LINK) == -1) {
							var sel = {};
							sel[me.subGridSelectField] = rec.data.LINK;
							me.subGridSelects.push(sel);
						}
						var oldSel = me.selModel.getSelection();
						if (Ext.Array.indexOf(oldSel, parentRow) === -1) {
							oldSel.push(parentRow);
							me.selModel.select(oldSel);
						}
					}
				});
				record.grid.on('deselect', function(th, rec) {
					if (me.selModel.selectionMode === 'MULTI') {
						var iPos = ArrayLib.find(me.subGridSelects, [selField], rec.data.LINK);
						if (iPos !== -1) {
							me.subGridSelects.splice(iPos, 1);
						}
					}
				});
				me.subGrids.push(record.grid);
				if (expandBox) {
					me.on('columnresize', function () {
						if (me.rowExpander && me.rowExpander.recordsExpanded[record.internalId]) {
							record.grid.view.refresh();
						}
					});

					record.grid.render(expandBox);
					record.grid.view.refresh();

					var subSel = [],
						selField = me.subGridSelectField,
						items = record.grid.store.data.items,
						len = items.length,
						i = 0;
					for (; i < len; i++) {
						if (ArrayLib.find(me.subGridSelects, [selField], items[i].data.LINK) > -1) {
							subSel.push(items[i]);
						}
					}
					if (subSel.length) record.grid.selModel.select(subSel);
				}
			}
		};

		me.callParent(arguments);
	},
	subDeselect: function(except) {
		var me = this,
			sgs = me.subGrids,
			len = sgs.length,
			i = 0;
		for (; i < len; i++) {
			if (except != sgs[i]) sgs[i].selModel.deselectAll();
		}
	},
	loadData: function(data, appEnd) {
		var me = this;
		me.rowExpander.recordsExpanded = {};
		me.store.loadData(data, !!appEnd);
		me.subGrids.length = 0;
	},
	loadSubData: function(data) {
		var me = this,
			newData = [],
			re = me.rowExpander,
			sgs = me.subGrids,
			len = data.length,
			rec,
			i = 0;

		for (; i < len; i++) {
			rec = data[i];
			if (!rec.isModel) {
				rec = Ext.ModelManager.create(rec, me.subModel);
			}
			newData.push(rec);
		}
		me.subGridData = newData;

		len = sgs.length;
		for (i = 0; i < len; i++) {
			sgs[i].ownerRecord.grid = null;
			sgs[i].close();
			//sgs[i].store.loadData(me.getSubDataByRec(sgs[i].ownerRecord), false);
		}
		me.subGrids = [];
		if (re) {
			re.setAllRowExpand();
			re.resizeAllLockedRows();
			for (i = 0; i < len; i++)
				if (!re.recordsExpanded[sgs[i].ownerRecord.internalId])
					sgs[i].renderCount = 0;
		}
	},
	setFields: function(fields) {
		this.setFields(fields);
	},
	setSubFields: function(fields) {
		this.subModel.setFields(fields);
	},
	reconfigure: function(columns) {
		this.callParent(arguments.length === 2 ? arguments : [this.store, columns]);
	},
	reconfigureSub: function(columns) {
		var me = this,
			gs = me.subGrids,
			len = gs.length,
			re = me.rowExpander,
			g,
			i = 0;
		me.subGridColumns = columns;
		for (; i < len; i++) {
			g = gs[i];
			g.reconfigure(g.store, columns);
		}
		if (re) {
			re.resizeAllLockedRows();
			for (i = 0; i < len; i++)
				if (!re.recordsExpanded[gs[i].ownerRecord.internalId])
					gs[i].renderCount = 0;
		}
	},
	selectSub: function(sels, field) {
		var me = this,
			gs = me.subGrids,
			len = gs.length,
			g,
			iPos,
			i = 0,
			subSel;
		if (!field) field = 'LINK';
		me.subGridSelects = sels;
		me.subGridSelectField = field;
		for (; i < len; i++) {
			g = gs[i];
			subSel = [];
			iPos = ArrayLib.find(sels, [field], g.record.data.LINK);
			while (iPos > -1) {
				subSel.push(g.store.find('LINK', sels[iPos][field]));
				iPos = ArrayLib.find(sels, [field], g.record.data.LINK, iPos + 1);
			}
			g.getSelectionModel().select(subSel);
		}
	},
	collapseAll: function() {
		var me = this,
			recs = me.store.data.items,
			len = recs.length,
			i = 0,
			record;

		if (me.rowExpander) {
			for (; i < len; i++) {
				record = recs[i];

				if (me.rowExpander.recordsExpanded[record.internalId]) {
					me.rowExpander.toggleRow(i, record);
				}
			}
		}
	},
	expandAll: function() {
		var me = this,
			recs = me.store.data.items,
			len = recs.length,
			i = 0,
			record;

		for (; i < len; i++) {
			record = recs[i];

			if (!me.rowExpander.recordsExpanded[record.internalId]) {
				me.rowExpander.toggleRow(i, record);
			}
		}
	},
	getSubDataByRec: function(rec) {
		var me = this;
		return ArrayLib.filter(me.subGridData, ['data', me.relationSubField], rec.data[me.relationField]);
	},
	subRowsRemove: function(value) {
		var me = this,
			i = 0;
		if (!Ext.isArray(value)) {
			value = [value];
		}
		var len = value.length,
			dLen = me.subGridData.length,
			j;
		for (; i < len; i++) {
			for (j = dLen - 1; j > -1; j--) {
				if (value[i] == me.subGridData[j]) {
					me.subGridData.splice(j, 1);
					break;
				}
			}
		}
	},
	getSubSelection: function() {
		var me = this,
			sel = me.selModel.getSelection();
		if (sel.length) {
			sel = sel[0];
			if (sel.grid) {
				return sel.grid.selModel.getSelection();
			}
		}
		return [];
	},
	renderSubData: function() {
		this.loadSubData(this.subGridData);
	}
});