﻿Ext.define('Keysystems.Controls.ClickLabel', {
	extend: 'Ext.form.field.Display',
	userCls: 'rks-click-label',
	initEvents: function() {
		var me = this;
		me.callParent();
		me.mon(me.inputEl, 'click', me.onMouseDown, me);
	},
	onMouseDown: function(e, dom) {
		var me = this;
		me.handler(e, dom);
	},
	handler: function() {}
});

//Период действия 
Ext.define('Keysystems.Controls.PeriodEdit', {
	extend: 'Ext.form.FieldContainer',
	alias: 'widget.PeriodEdit',
	layout: 'hbox',
	allowBlank: true,
	labelWidth: 150,
	fieldLabel: 'Период действия',
	_cfgDh: {
		format: 'd.m.Y',
		minValue: '01.01.1900',
		maxValue: '31.12.2100',
		flex: 1
	},
	_cfgDh1: { value: '01.01.1900' },
	_cfgDh2: { value: '31.12.2100' },
	cfgDh: {},
	cfgDh1: {},
	cfgDh2: {},
	cfgnbDays: { hidden: true },
	getOrgP: function() { return window.user.org.data.LINK },
	contextMenuCreate: function() {
		var me = this,
			now = new Date(new Date().toDateString()),
			year = now.getFullYear(),
			getHalfYear = function(fst) {
				if (fst)
					return {
						dh1: '01.01.' + year,
						dh2: '30.06.' + year
					};
				else
					return {
						dh1: '01.07.' + year,
						dh2: '31.12.' + year
					};
			},
			getQuarter = function(n) {
				switch (n) {
				case 1:
					return {
						dh1: '01.01.' + year,
						dh2: '31.03.' + year
					};
				case 2:
					return {
						dh1: '01.04.' + year,
						dh2: '30.06.' + year
					};
				case 3:
					return {
						dh1: '01.07.' + year,
						dh2: '30.09.' + year
					};
				default:
					return {
						dh1: '01.10.' + year,
						dh2: '31.12.' + year
					};
				}
			},
			getQuarterByDate = function(d) {
				var m = d.getMonth();
				switch (true) {
				case m > -1 && m < 3:
					return getQuarter(1);
				case m > 2 && m < 6:
					return getQuarter(2);
				case m > 5 && m < 9:
					return getQuarter(3);
				default:
					return getQuarter(4);
				}
			},
			contextMenu = Ext.create('Ext.menu.Menu', {
				items: [
					me.stateChangerMonth = Ext.create('Ext.Action', {
						text: 'Год/месяц',
						hidden: true,
						state: 1,
						handler: function() {
							me.setStateFn(1);
						}
					}),
					me.stateChangerKvartal = Ext.create('Ext.Action', {
						text: 'Год/квартал',
						hidden: true,
						state: 2,
						handler: function() {
							me.setStateFn(2);
						}
					}),
					me.stateChangerExtentedKvartal = Ext.create('Ext.Action', {
						text: 'Год/кварталы',
						hidden: true,
						state: 4,
						handler: function() {
							me.setStateFn(4);
						}
					}),
					me.stateChangerDatePeriod = Ext.create('Ext.Action', {
						text: 'Диапазон дат',
						hidden: true,
						state: 8,
						handler: function() {
							me.setStateFn(8);
						}
					}),
					Ext.create('Ext.menu.Separator'),
					me.dayBtn = Ext.create('Ext.Action', {
						text: 'День',
						handler: function() {
							var d1 = new Date(now),
								d2 = new Date(now);
							d2.setDate(now.getDate() + 1);
							me.setValue(d1, d2);
						}
					}),
					me.monthBtn = Ext.create('Ext.Action', {
						text: 'Месяц',
						handler: function() {
							var value = new Date(new Date().toDateString());
							value.setDate(1);
							me.setValue(value, Ext.Date.getLastDateOfMonth(value));
						}
					}),
					me.quarterBtn = Ext.create('Ext.Action', {
						text: 'Квартал',
						handler: function() {
							var value = new Date(new Date().toDateString()),
								q = getQuarterByDate(value);
							me.setValue(q.dh1, q.dh2);
						}
					}),
					me.halfYearBtn = Ext.create('Ext.Action', {
						text: 'Полугодие',
						handler: function() {
							var value = new Date(new Date().toDateString()),
								q = getHalfYear(value.getMonth() < 6);
							me.setValue(q.dh1, q.dh2);
						}
					}),
					me.nineMonthsBtn = Ext.create('Ext.Action', {
						text: '9 месяцев',
						handler: function() {
							me.setValue('01.01.' + year, '30.09.' + year);
						}
					}),
					me.yearBtn = Ext.create('Ext.Action', {
						text: 'Год',
						handler: function() {
							me.setValue('01.01.' + year, '31.12.' + year);
						}
					}),
					Ext.create('Ext.menu.Separator'),
					{
						text: 'Месяцы ' + year,
						menu: [
							Ext.create('Ext.Action', {
								text: 'Январь',
								handler: function() {
									me.setValue('01.01.' + year, '31.01.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Февраль',
								handler: function() {
									var d = new Date();
									d.setMonth(1);
									me.setValue('01.02.' + year, Ext.Date.getLastDateOfMonth(d));
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Март',
								handler: function() {
									me.setValue('01.03.' + year, '31.03.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Апрель',
								handler: function() {
									me.setValue('01.04.' + year, '30.04.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Май',
								handler: function() {
									me.setValue('01.05.' + year, '31.05.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Июнь',
								handler: function() {
									me.setValue('01.06.' + year, '30.06.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Июль',
								handler: function() {
									me.setValue('01.07.' + year, '31.07.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Август',
								handler: function() {
									me.setValue('01.08.' + year, '31.08.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Сенятбрь',
								handler: function() {
									me.setValue('01.09.' + year, '30.09.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Октябрь',
								handler: function() {
									me.setValue('01.10.' + year, '31.10.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Ноябрь',
								handler: function() {
									me.setValue('01.11.' + year, '30.11.' + year);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Декабрь',
								handler: function() {
									me.setValue('01.12.' + year, '31.12.' + year);
								}
							})
						]
					},
					{
						text: 'Кварталы ' + year,
						menu: [
							Ext.create('Ext.Action', {
								text: 'Первый',
								handler: function() {
									var q = getQuarter(1);
									me.setValue(q.dh1, q.dh2);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Второй',
								handler: function() {
									var q = getQuarter(2);
									me.setValue(q.dh1, q.dh2);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Третий',
								handler: function() {
									var q = getQuarter(3);
									me.setValue(q.dh1, q.dh2);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Четвертый',
								handler: function() {
									var q = getQuarter(4);
									me.setValue(q.dh1, q.dh2);
								}
							})
						]
					},
					{
						text: 'Полугодия ' + year,
						menu: [
							Ext.create('Ext.Action', {
								text: 'Первое',
								handler: function() {
									var q = getHalfYear(true);
									me.setValue(q.dh1, q.dh2);
								}
							}),
							Ext.create('Ext.Action', {
								text: 'Второе',
								handler: function() {
									var q = getHalfYear(false);
									me.setValue(q.dh1, q.dh2);
								}
							})
						]
					},
					Ext.create('Ext.menu.Separator'),
					Ext.create('Ext.Action', {
						text: 'Широкий период',
						handler: function() {
							me.setValue(longPeriod.begin, longPeriod.end);
						}
					})
				]
			});
		return contextMenu;
	},
	initComponent: function() {
		var me = this,
			cfg1 = {
				allowBlank: me.allowBlank,
				listeners: me.d1Listeners,
				getOrgP: me.getOrgP
			},
			cfg2 = {
				allowBlank: me.allowBlank,
				margin: '0 3 0 0',
				listeners: me.d2Listeners,
				getOrgP: me.getOrgP
			},
			cfg3 = {
				allowOnlyWhitespace: false,
				allowDecimals: false,
				allowExponential: false,
				labelWidth: 0,
				maxLength: 7,
				width: 60,
				minValue: 0,
				checkChangeBuffer: 500
			};

		Ext.apply(cfg1, me._cfgDh1, me._cfgDh);
		Ext.apply(cfg1, me.cfgDh1, me.cfgDh);
		Ext.apply(cfg2, me._cfgDh2, me._cfgDh);
		Ext.apply(cfg2, me.cfgDh2, me.cfgDh);
		Ext.apply(cfg3, me.cfgnbDays);

		me.contextMenu = me.contextMenuCreate();
		me.items = [
			me.dh1 = Ext.create('Ext.form.field.Date', cfg1),
			me.clickLbl = Ext.create('Keysystems.Controls.ClickLabel', {
				padding: '1 5 0 5',
				value: '...',
				state: 'date',
				handler: function(e) {
					if (me.ksReadOnly || me.readOnly) return false;
					e.stopEvent();
					me.contextMenu.showAt(e.getXY());
					return false;
				}
			}),
			me.dh2 = Ext.create('Ext.form.field.Date', cfg2),
			me.nbDays = Ext.create('Ext.form.field.Number', cfg3),
			{
				xtype: 'label',
				text: 'дн',
				align: 'middle',
				margin: '5 0 0 5',
				hidden: me.cfgnbDays.hidden
			}
		];

		if (me.isSwap) {
			me.dh1.on('blur', function() { me.swap(); });
			me.dh2.on('blur', function() { me.swap(); });
		};
		me.dh1.on('blur', function() {
			var dt = me.getValue(),
				focusEl = Ext.Element.getActiveElement();

		    me.setValue(dt.dh1, dt.dh2);

			if (focusEl === me.dh1.getFocusEl().dom || focusEl === me.dh2.getFocusEl().dom) return me.needFireEvent = me.dateChanged(me.lastValue, dt);

			if (me.dateChanged(me.lastValue, dt) || me.needFireEvent) {
				getCntDaysInPeriod(dt.dh1, dt.dh2, me.getOrgP(), function(val) {
					if (me.nbDays) {
						me.nbDays.setValue(val.workDays);
						if (val.workDays && me.isSwap) me.swap();
					}
				});

				me.lastValue = dt;
				me.fireEvent('ksChange', dt.dh1, dt.dh2, 'dh1');
			}
		});

		me.dh2.on('blur', function() {
			var dt = me.getValue(),
				focusEl = Ext.Element.getActiveElement();

			me.setValue(dt.dh1, dt.dh2);

			if (focusEl === me.dh1.getFocusEl().dom || focusEl === me.dh2.getFocusEl().dom) return me.needFireEvent = me.dateChanged(me.lastValue, dt);

			if (me.dateChanged(me.lastValue, dt) || me.needFireEvent) {
				getCntDaysInPeriod(dt.dh1, dt.dh2, me.getOrgP(), function(val) {
					if (me.nbDays) {
						me.nbDays.setValue(val.workDays);
						if (val.workDays && me.isSwap) me.swap();
					}
				});

				me.lastValue = dt;
				me.fireEvent('ksChange', dt.dh1, dt.dh2, 'dh2');
			}
		});

		me.nbDays.on('change', function (th, newValue, oldValue) {
			if (!th.disabled && oldValue && oldValue !== newValue) {
				PeriodLib.getNextDay(me.dh1.getValue(),
					me.nbDays.getValue(),
					me.getOrgP(),
					function(dhEnd) {
						me.dh2.setValue(new Date(dhEnd));
						me.fireEvent('ksChange', me.dh1.getValue(), me.dh2.getValue());
					});
			}
		});

		me.on('ksChange', function(dh1, dh2, dhKey) {
			dhKey = dhKey || 'dh1';
			this[dhKey].getHolidays();
		});

		//Украдем метод у field.Date
		me.setHolidays = me.dh1.setHolidays;

		this.callParent(arguments);
	},
	swap: function() {
		var me = this,

			focusEl = Ext.Element.getActiveElement();
		if (focusEl === me.dh1.getFocusEl().dom || focusEl === me.dh2.getFocusEl().dom) return;

		var dh1 = me.dh1.getValue(),
			dh2 = me.dh2.getValue(),
			tmp;

		if (dh1 > dh2) {
			tmp = dh1;
			me.dh1.setValue(dh2);
			me.dh2.setValue(tmp);
		}
	},
	setValue: function(dh1, dh2) {
		var me = this;

		if (!me.lastValue) me.lastValue = { dh1: longPeriod.begin, dh2: longPeriod.end };

		me.dh1.setValue(dh1);
		me.dh2.setValue(dh2);

		var dh1V = me.dh1.getValue(),
			dh2V = me.dh2.getValue();

		if (!me.isHidden() && me.dateChanged(me.lastValue, { dh1: dh1V, dh2: dh2V })) {
			me.fireEvent('ksChange', dh1V, dh2V);
			if (!me.ignoreColorize) {
				me.dh1.colorizeHoliday(dh1V);
				me.dh2.colorizeHoliday(dh2V);
			}
		}

		me.lastValue = { dh1: dh1V, dh2: dh2V };
	},
	getValue: function(isJson) {
		var result = {
			dh1: this.dh1.getValue(),
			dh2: this.dh2.getValue()
		};

		if (this.dh1.isEmpty()) {
			result.dh1 = new Date('1900/01/01');
		}

		if (this.dh2.isEmpty()) {
			result.dh2 = new Date('2100/12/31');
		}

		if (isJson) {
			result.dh1 = result.dh1.toDateString();
			result.dh2 = result.dh2.toDateString();
			result = JSON.stringify(result);
		}

		return result;
	},
	isValid: function() {
		if (this.dh1.getErrors().length == 0 && this.dh2.getErrors().length == 0) {
			return (this.dh1 <= this.dh2);
		}
		return (this.dh1.getErrors().length == 0 && this.dh2.getErrors().length == 0);
	},
	isEmpty: function() {
		return !(this.dh1.getValue() && this.dh2.getValue() && this.isValid());
	},
	focus: function() { this.dh1.focus(arguments); },
	setReadOnly: function(state) {
		this.dh1.setReadOnly(state);
		this.dh2.setReadOnly(state);
		this.clickLbl.setDisabled(state);
		this[state ? 'addCls' : 'removeCls']('ks-readOnly');
	},
	dateChanged: function(dt1, dt2) {
		if (Ext.isObject(dt1) && !Ext.isDate(dt1.dh1) || !Ext.isDate(dt2.dh2)) return false;
		if (Ext.isObject(dt2) && !Ext.isDate(dt2.dh1) || !Ext.isDate(dt2.dh2)) return false;
		if (!dt1 && dt2) return true;
		//if (!Ext.isDate(dt1) || !Ext.isDate(dt2)) return false;
		return !(this.isStateChange || Ext.Date.isEqualDh(dt1, dt2));
	},
	getAsWhereArgs: function(res, field) {
		var dh = this.getValue();
		(res || (res = {}))[(field || (field = 'DH')) + '1'] = { value: dh.dh1, type: 'Date' };
		res[field + '2'] = { value: dh.dh2, type: 'Date' };
		return res;
	}
});

//Период проведения
Ext.define('Keysystems.Controls.QuarterEdit', {
	extend: 'Ext.form.FieldContainer',
	allowBlank: true,
	periodHolding: function(year, period, dh) {
		var startDate,
			endDate;

		switch (period) {
		case 1:
			startDate = '01.01.';
			endDate = '31.03.';
			break;
		case 2:
			startDate = '01.04.';
			endDate = '30.06.';
			break;
		case 3:
			startDate = '01.07.';
			endDate = '30.09.';
			break;
		case 4:
			startDate = '01.10.';
			endDate = '31.12.';
			break;
		case 5:
			startDate = '01.01.';
			endDate = '30.06.';
			break;
		case 6:
			startDate = '01.07.';
			endDate = '31.12.';
			break;
		case 7:
			startDate = '01.01.';
			endDate = '30.09.';
			break;
		default:
			startDate = '01.01.';
			endDate = '31.12.';
			break;
		}
		//Признак того что нужен формат ответа string а не date
		//В dh передается дата из объекта DT на случай широкого периода
		if (dh) {
			return year ?
				{
					begin: startDate + year,
					end: endDate + year
				} :
				{
					begin: startDate + dh.dh1.getFullYear(),
					end: endDate + dh.dh2.getFullYear()
				};
		}

		if (year) {
			startDate += year;
			endDate += year;
		} else {
			return null;
		}

		return {
			dh1: new Date(startDate.split('.').reverse().join('/')),
			dh2: new Date(endDate.split('.').reverse().join('/'))
		};
	},
	monthHolding: function(year, month, dateFormat) {
		var startDate = '01.',
			endDate = (new Date(year, month, 0)).getDate() + '.';

		month = (month < 10) ? '0' + month : month;
		var dh = {
			begin: startDate + month + '.' + year,
			end: endDate + month + '.' + year
		};
		return dateFormat ?
			{
				dh1: new Date(dh.begin.split('.').reverse().join('/')),
				dh2: new Date(dh.end.split('.').reverse().join('/'))
			} :
			dh;
	},
	getValue: function(isJson) {
		var me = this,
			year = me.holdingYear.getValue(),
			quarter = me.holdingQuarter.getValue();

		var result = ((me.state === 1) && year && quarter !== 0) ? me.monthHolding(year, quarter, true) : me.periodHolding(year, quarter);
		return isJson ? JSON.stringify(result) : result;
	},
	setValue: function(dh1, dh2, state) {
		var me = this;

		if (!Ext.isDate(dh1, dh2)) {
			dh1 = new Date(dh1);
			dh2 = new Date(dh2);
		}
		var period = me.getQuarter(dh1.getMonth(), dh2.getMonth());
		if (dh1.getFullYear() === dh2.getFullYear()) {
			switch (state) {
			case 1:
				me.holdingQuarter.setValue(period === 0 ? 0 : dh2.getMonth() + 1);
				me.holdingYear.setValue(dh1.getFullYear());
				break;
			default:
				me.holdingQuarter.setValue(period);
				me.holdingYear.setValue(dh1.getFullYear());
				break;
			}
		} else {
			me.holdingYear.setValue('');
			me.holdingQuarter.setValue(0);
		}

		if (!me.isHidden()) me.fireEvent('ksChange', dh1, dh2);
	},
	getQuarter: function(monthBegin, monthEnd) {
		var period = 0;

		if (monthEnd - monthBegin >= 5) {
			if ((monthBegin === 0) && (monthEnd === 5)) {
				period = 5;
			};

			if ((monthBegin === 6) && (monthEnd === 11)) {
				period = 6;
			};

			if ((monthBegin === 0) && (monthEnd === 8)) {
				period = 7;
			};
		} else {
			period = Math.floor((monthEnd + monthBegin) / 6) + 1;
		}

		return period;
	},
	initComponent: function() {
		var me = this;
		me.layout = 'hbox';
		me.contextMenu = Ext.create('Ext.menu.Menu', {
			items: [
				me.stateChangerMonth = Ext.create('Ext.Action', {
					text: 'Год/месяц',
					itemId: 'Month',
					hidden: true,
					state: 1,
					handler: function() {
						me.setStateFn(1);
					}
				}),
				me.stateChangerKvartal = Ext.create('Ext.Action', {
					text: 'Год/квартал',
					hidden: true,
					itemId: 'Kvartal',
					state: 2,
					handler: function() {
						me.setStateFn(2);
					}
				}),
				me.stateChangerExtentedKvartal = Ext.create('Ext.Action', {
					text: 'Год/кварталы',
					hidden: true,
					itemId: 'ExtentedKvartal',
					state: 4,
					handler: function() {
						me.setStateFn(4);
					}
				}),
				me.stateChangerDatePeriod = Ext.create('Ext.Action', {
					text: 'Диапазон дат',
					hidden: true,
					itemId: 'DatePeriod',
					state: 8,
					handler: function() {
						me.setStateFn(8);
					}
				})
			]
		});
		me.items = [
			me.holdingYear = Ext.create('Ext.form.field.Number', {
				flex: 1,
				emptyText: '...',
				value: me.startYear,
				maxValue: 2100,
				minValue: 1900,
				maxWidth: 80,
				listeners: me.holdingYearListeners,
				validateOnChange: false
			}),
			Ext.create('Keysystems.Controls.ClickLabel', {
				padding: '4 5 0 5',
				value: '...',
				state: 'date',
				handler: function(e) {
					e.stopEvent();
					me.contextMenu.showAt(e.getXY());
					return false;
				}
			}),
			me.holdingQuarter = Ext.create('Ext.form.ComboBox', {
				flex: 1,
				editable: false,
				margin: '0 3 0 0',
				minWidth: 100,
				listeners: me.holdingQuarterListeners,
				queryMode: 'local',
				displayField: CBDataLib.displayField,
				valueField: CBDataLib.valueField,
				store: Ext.create('Ext.data.Store', {
					fields: CBDataLib.getFields(),
					data: CBDataLib.get('PeriodTypes_ExtentedKvartal'),
					proxy: 'memory'
				})
			})
		];
		me.holdingQuarter.store.load();
		me.holdingYear.on('blur', function() {
			var result = me.getValue();
			if (!result || me.holdingYear.activeError) {
				return false;
			}
			me.fireEvent('ksChange', result.dh1, result.dh2);
		});
		me.holdingQuarter.on('select', function() {
			var result = me.getValue();
			if (!result || me.holdingYear.activeError) {
				return false;
			}
			me.fireEvent('ksChange', result.dh1, result.dh2);
		});
		me.holdingQuarter.on('beforeselect', function() {
			if (!me.holdingYear.getValue()) {
				me.holdingYear.setValue(new Date().getFullYear());
			}
		});
		this.callParent(arguments);
	},
	setQuarterStore: function(state) {
		this.holdingQuarter.store.loadData(CBDataLib.get('PeriodTypes_' + state));
	},
	setReadOnly: function(state) {
		this.holdingYear.setReadOnly(state);
		this.holdingQuarter.setReadOnly(state);
		this[state ? 'addCls' : 'removeCls']('ks-readOnly');
	}
});

//Смежный класс 
Ext.define('Keysystems.Controls.KsPeriod', {
	extend: 'Ext.form.FieldContainer',
	get TypePeriod() {
		if (!this.m_TypePeriod) {
			this.m_TypePeriod = {};
			// ReSharper disable UseOfImplicitGlobalInFunctionScope
			var types = window.miscTypes.TypePeriod;
			// ReSharper restore UseOfImplicitGlobalInFunctionScope
			for (var key in types) this.m_TypePeriod[types[key]] = key * 1;
		}
		return this.m_TypePeriod;
	},
	state: 8,
	allStates: 8, //Число доступных состояний: 1: Month; 2:Kvartal; 4:ExtendedKvartal; 8:DatePeriod 
	allowBlank: true,
	labelWidth: 150,
	fieldLabel: 'Период проведения',
	layout: 'hbox',
	initComponent: function() {
		var me = this;
		me.hideStore = {};
		me.showStore = {};

		for (var key in me.TypePeriod) {
			if (key !== 'DatePeriod') {
				me.hideStore[me.TypePeriod[key]] = function() {
					me.Quarter.hide();
				};
				me.showStore[me.TypePeriod[key]] = function() {
					me.Quarter.setQuarterStore(window.miscTypes.TypePeriod[me.state]);
					me.Quarter.show();
				};
			} else {
				me.hideStore[me.TypePeriod[key]] = function() {
					me.DT.hide();
				};
				me.showStore[me.TypePeriod[key]] = function() {
					me.DT.show();
				};
			}
		};
		me.items = [
			me.DT = Ext.create('Keysystems.Controls.PeriodEdit', {
				labelWidth: 0,
				fieldLabel: '',
				isSwap: 'true',
				allowBlank: me.allowBlank,
				ignoreColorize: me.ignoreColorize,
				flex: 1,
				hidden: true,
				d1Listeners: me.d1Listeners,
				d2Listeners: me.d2Listeners,
				setStateFn: function(state) {
					me.setState(state);
				}
			}),
			me.Quarter = Ext.create('Keysystems.Controls.QuarterEdit', {
				startYear: me.startYear,
				flex: 1,
				hidden: true,
				holdingYearListeners: me.holdingYearListeners,
				holdingQuarterListeners: me.holdingQuarterListeners,
				setStateFn: function(state) {
					me.setState(state);
					//обновим данные при переключениями между состояниями
					if (!me.isHidden()) me.fireEvent('ksChange', this.getValue().dh1, this.getValue().dh2);
				}
			})
		];
		me.DT.on('ksChange', function(dh1, dh2) {
			var dt = { dh1: dh1, dh2: dh2 };
			if (me.dateChanged(me.lastValue, dt)) {
				me.lastValue = dt;
				me.fireEvent('ksChange', dh1, dh2);
			}
		});
		me.Quarter.on('ksChange', function(dh1, dh2) {
			var dt = { dh1: dh1, dh2: dh2 };
			if (me.dateChanged(me.lastValue, dt)) {
				me.lastValue = dt;
				me.fireEvent('ksChange', dh1, dh2);
			}
		});
		me.setState(me.state);
		me.callParent(arguments);
	},
	getValue: function() {
		var result = this[this.state === 8 ? 'DT' : 'Quarter'].getValue();
		return result ? result : this['DT'].getValue();
	},
	//Функция для возврата значения в формате DBegin, DEnd
	getWhereArgsValue: function(year, quarter, dt) {
		var me = this,
			periodFunc = me.Quarter.periodHolding;

		if (me.state === 1) {
			return me.Quarter.monthHolding(year, quarter);
		}
		var dh = year ? periodFunc(year, quarter, true) : periodFunc(year, quarter, dt);
		return dh;
	},
	getYear: function() {
		var me = this,
			dt = me.getValue();
		return dt.dh1.getFullYear() === dt.dh2.getFullYear() ? dt.dh2.getFullYear() : false;
	},
	getMonth: function() {
		var me = this,
			dt = me.getValue(),
			dh1 = dt.dh1.getMonth(),
			dh2 = dt.dh2.getMonth();

		return dh1 === dh2 ? dh2 : false;
	},
	getQuarter: function(dt) {
		if (!dt) return;
		const m = dt.getMonth();
		switch (true) {
			case m >= 0 && m < 3:
				return 1;
			case m > 2 && m < 6:
				return 2;
			case m > 5 && m < 9:
				return 3;
			default:
				return 4;
		}
	},
	setValue: function(dh1, dh2) {
		var me = this;

		if (!me.lastValue) {
			me.lastValue = { dh1: dh1, dh2: dh2 };
		}

		//принудительное выставление состояний, в случае если значения шире текущего диапазона
		if (!me.isStateChange) {
			if ((dh1.getMonth() !== dh2.getMonth() && me.state === 1) ||
				(me.getQuarter(dh1) !== me.getQuarter(dh2) && me.state === 2) ||
				(dh1.getFullYear() !== dh2.getFullYear() && me.state !== 8)) {
				me.setState(8);
			if (dh1.getMonth() === dh2.getMonth() && (me.state === 2 || me.state === 4))
				me.setState(1);
			}
		}
		me.DT.setValue(dh1, dh2);
		me.Quarter.setValue(me.DT.dh1.getValue(), me.DT.dh2.getValue(), me.state);		
	},
	setState: function(state) {
		var me = this;
		me.isStateChange = true;
		var val = me.getValue();

		state = Ext.isString(state) ? me.TypePeriod[state] : state;
		if (!(me.allStates & state)) {
			me.isStateChange = false;
			return;
		}
		var stateChangers = me[state === 8 ? 'DT' : 'Quarter'].contextMenu.items.items;

		for (var i = 0; i < 4; i++) {
			stateChangers[i][(!(me.allStates & stateChangers[i].state) || !!(state & stateChangers[i].state)) ? 'hide' : 'show']();
		}

		me.hideStore[me.state]();
		me.Quarter.state = me.state = state;
		me.showStore[state]();
		
		me.setValue(val.dh1, val.dh2);

		me.isStateChange = false;
	},
	setReadOnly: function(state) {
		this.DT.setReadOnly(state);
		this.Quarter.setReadOnly(state);
		this[state ? 'addCls' : 'removeCls']('ks-readOnly');
	},
	dateChanged: function(dt1, dt2) { return !(this.isStateChange || Ext.Date.isEqualDh(dt1, dt2)); }
});