Ext.define('Keysystems.Controls.InvalidControlsPanel', {
	extend: 'Ext.panel.Panel',
	xtype: 'rks-document-invalidcontrols',
	cls: 'ks-invalid-controls',
	title: KS.L10n.zapolnennostobyazatelnikhpolei,
	layout: 'fit',
	renderConfig: {
		invalidControls: null
	},
	initComponent() {
		this.viewModel = Ext.create('Ext.app.ViewModel', {
			data: {
				invalidControls: []
			},
			stores: {
				invalidControlsStore: {
					data: '{invalidControls}'
				}
			}
		});
		this.items = Ext.create('Ext.view.View', {
			cls: 'ks-invalid-controls-view',
			itemSelector: '.ks-invalid-controls-view__list-link',
			padding: 25,
			scrollable: true,
			listeners: {
				itemclick: 'invalidControlsClick'
			},
			bind: {
				store: '{invalidControlsStore}'
			},
			invalidControlsClick: function (view, rec) {
				const control = rec.get('control');
				const parent = rec.get('parent');

				if (parent) {
					const tab = rec.get('tab');
					parent.setActiveTab(tab);
				}

				if (control.el) {
					control.el.dom.scrollIntoView({
						block: 'center'
					});
				}

				if ('highlightInputEl' in control) {
					control.highlightInputEl();
				}
				else {
					(control.inputEl || control.getEl()).frame("#7eadd9");
					control.focus(false, 200);
				}
				
			},
			tpl:
				`
            <div>
                <div class="ks-invalid-controls-view__title">${KS.L10n.neobhodimi_zapolit_sledushie_polya} (${KS.L10n.clicknite_na_punkt_chtobi_pereyti_k_zapolneniy}):</div>
                <ul class="ks-invalid-controls-view__list">
                    <tpl for=".">
                        <li class="ks-invalid-controls-view__list-item">
                            <span>— </span><span class="ks-invalid-controls-view__list-link">{title}</span>
                            <tpl if="optional"><span>(можно оставить пустым)</span></tpl>                                                        
                        </li>
                    </tpl>
                </ul>
            </div>
        `,
		});
		this.callParent(arguments);
	},

	applyInvalidControls(invalidControls) {
		const vm = this.lookupViewModel();
		vm.set({invalidControls});
	},


});