﻿Ext.define('Keysystems.Controls.GroupingGrid', {
	extend: 'Ext.grid.Panel',
	border: false,
	autoScroll: true,
	columnLines: true,
	expandOnDblClick: true,
	fieldLink: 'LINK', // По аналогии с Base.List поле линка записей в гриде
	hideGroupedHeader: false,
	groupBoldTxt: true, //Настройка на выделение групп жирным шрифтом
	groupField: 'group', //Поле по которому групируются данные
	groupLinkField: 'T_REVIZ_OBJECTS', //Поле линка группы
	groupNameField: 'TEMP_NAME', //Поле имени группы
	groupHeaderTpl: '{name}',
	groupSelectedCls: 'rks-grid-group-selected',
	sortField: 'MAIN', //Поле по которому будет проходить сортировка
	sortDirection: 'DESC', //Порядок сортировки групп
	subNameField: null, //По умолчанию отключенно. если задать сюда название колонки то добавит в данные этой колонки отступы
	plugins: ['gridclipboard'],
	initComponent: function () {
		var me = this;

		me.columns = me.columns || [];
		me.data = me.data || [];
		me.groups = me.groups || [];
		me.fields = me.fields || [{name: me.groupField, type: 'string'}];

		me.features = [
			// Ext.create('Keysystems.Controls.GroupingFeature', {
			// 	enableGroupingMenu: false,
			// 	enableNoGroups: false,
			// 	groupHeaderTpl: me.groupHeaderTpl,
			// 	hideGroupedHeader: me.hideGroupedHeader
			// }),
			Ext.create('Ext.grid.feature.Grouping', {
				groupHeaderTpl: [
					'{[values.children[0].data.' + me.groupField + ']}'
				]
			}),
			{
				ftype: 'summary',
				showSummaryRow: false
			}
		];


		//Прятать фиктивные записи
		me.viewConfig = me.viewConfig || {};

		var getRowClass = me.viewConfig.getRowClass;//сохраняем, чтобы не перекрыть уже существующую функцию

		me.viewConfig.getRowClass = function (rec) {
			var cls = getRowClass ? getRowClass(rec) : '';
			if (rec.get(me.fieldLink) === 0) {
				cls += ' ks-hidden';
			}
			return cls;
		};
		
		if (!me.store) {
			me.store = Ext.create('Ext.data.Store', {
				fields: me.fields,
				data: me.data,
				proxy: 'memory',
				groupField: me.groupField,
				groupers: [
					{
						property: me.sortField,
						direction: me.sortDirection,
						getGroupString: function (instance) {
							return instance.get(me.groupField);
						}
					}
				],
				remoteSort: false,
				//Получение данных без фантомных записей,
				//если приходит параметр groupLink то данные только этой группы
				getClearData: function (group, isJson) {
					var data = me.store.getDataExt(),
						len = data.length,
						clearData = [],
						i = 0;

					for (; i < len; i++) {
						if (data[i][me.fieldLink] !== 0 && (Ext.isString(group) ? data[i][me.groupField] === group : true)) {
							clearData.push(data[i]);
						}
					}
					return isJson ? JSON.stringify(clearData) : clearData;
				}
			});
		}

		if (!me.listeners) me.listeners = {};

		me.listeners.selectionchange = me.listeners.selectionchange || function (th, selected) {
			if (selected.length === 0) return;
			me.selectLinks = selected;

			//если выделена строка - снимаем выделение с группы
			if (selected[0].data[me.fieldLink]) {
				let els = Ext.select("#" + me.id + " ." + me.groupSelectedCls, true);
				els.removeCls(me.groupSelectedCls);
			}
		};

		me.listeners.groupclick = me.listeners.groupclick || function (view, node, group) {
			//найдем группу 
			let data = ArrayLib.filter(me.store.data.items, ['data', me.groupField], group),
				pos = ArrayLib.find(data, ['data', me.fieldLink], 0);
			//выделение группы в модели (в ui скрыта) 
			if (pos !== -1) {
				me.selModel.select(data[pos]);
			}
			//выделение группы в интерфейсе
			me.setGroupSelect(node, group);
		};

		if (!me.tbar) me.tbar = [];
		me.callParent(arguments);
	},

	setColumns: function (columns) {
		var me = this,
			pos = ArrayLib.find(columns, ['dataIndex'], me.subNameField);

		if (pos !== -1) {
			columns[pos].tdCls = 'ks-group-indent';
		}

		me.setKsColumnManager(columns || me.columns);
	},

	setKsColumnManager: function (columns) {
		var me = this;
		if (me.ksColumnManager) {
			me.ksColumnManager.adaptedColumns(columns);
			me.ksColumnManager.update();
		} else {
			me.creKsColumnManager(columns);
		}
	},

	creKsColumnManager: function (columns, grid) {
		var me = this;

		if (!grid) grid = me;

		me.ksColumnManager = Ext.create('Keysystems.Controls.Grid.ColumnManager', {
			inputColumns: columns,
			code: me.profileCode || me.code,
			prefix: me.prefix,
			profileKey: me.profileKey || 'GridColumns',
			gateCode: me.GateCode,
			controlName: me.controlName,
			grid: grid
		});
	},
	//генерация словаря груп
	genGroupsNames: function (list) {
		var me = this,
			result = {};

		for (var i = 0; i < list.length; i++) {
			result[list[i].LINK] = list[i];
		}

		me.ksData.groupsNames = result;
		return result;
	},

	//Назначить группе класс селекта
	setGroupSelect: function (node, group) {
		const me = this;
		try {
			//todo ломается на запятой в имени группы в качестве css-селектора 
			const divGroup = Ext.select("div[data-groupname='" + group + "']");
			divGroup.first()?.addCls(me.groupSelectedCls);
		}
		catch (e) {
			console.error(e);
		}

		// не знаю почему не работает через node. помог только прямой запрос к дому по атрибуту
		//Ext.fly(node).addCls(me.groupSelectedCls);
	},

	//Назначить группы данным
	setGroupsForData: function (data, groups) {
		var me = this;

		me.groups = groups;
		for (var i = 0, pos, len = data.length; i < len; i++) {
			pos = ArrayLib.find(groups, [me.fieldLink], (data[i][me.groupLinkField] || 0));
			if (pos !== -1) {
				data[i].group = groups[pos][me.groupNameField];
				data[i][me.sortField] = groups[pos][me.sortField];
			}
		}
		if (me.sortCol) {
			me.store.sort(me.sortCol, 'ASC');
		}
		me.store.loadData(data);
		me.setGroupsEmptyData();
	},
	//Добавить пустые записи группам
	setGroupsEmptyData: function () {
		var me = this,
			emptyData = [],
			data = me.store.getDataExt(),
			emptyRows = ArrayLib.filter(data, [me.fieldLink], 0);

		Ext.each(me.groups, function (group, i) {
			var pos = ArrayLib.find(emptyRows, [me.groupField], group[me.groupNameField]);
			if (pos === -1) {
				emptyData.push({
					ORD: -1,
					group: group[me.groupNameField]
				});

				emptyData[emptyData.length - 1][me.fieldLink] = 0;
				emptyData[emptyData.length - 1][me.sortField] = group[me.sortField];
				emptyData[emptyData.length - 1][me.groupLinkField] = group[me.fieldLink];
			}
		});

		me.store.loadData(emptyData, true);
	},
	//удалить элементы для группы. если не указана группа, чистим всё
	deleteGroupData: function (group) {
		var me = this,
			oldRecords = [],
			store = me.store;

		if (group) {
			var groupData = store.getClearData(group);

			for (var i = 0, len = groupData.length; i < len; i++) {
				var link = groupData[i][me.fieldLink],
					oldRec = store.findRecord(me.fieldLink, link, 0, false, true);

				if (oldRec) {
					oldRecords.push(oldRec);
				}
			}
			store.remove(oldRecords);
		} else {
			store.removeAll();
			me.setGroupsEmptyData();
		}
	},
	setAdaptedFields: function (fields) {
		var me = this;
		if (!me.thereIsField(fields, me.groupField)) {
			fields.push({name: me.groupField, type: 'string'});
		}

		me.store.setFields(fields);
	},
	setSelect: function (selectLinks) {
		var me = this;
		if (!selectLinks) return;
		var selected = [];
		Ext.each(selectLinks, function (row) {
			if (row) {
				if (row.data) row = row.data;
				var el = me.store.findRecord(me.fieldLink, row[me.fieldLink] || row);
				if (el) {
					selected.push(el);
					if (row[me.sortField]) el.set(me.sortField, true);
				}
			}
		});
		if (selected.length !== 0) {
			extraSelect(selected, me);
		}
	},
	thereIsField: function (fields, name) {
		return (Ext.Array.indexOf(fields, name) !== -1) || (ArrayLib.find(fields, ['name'], name) !== -1);
	}
});

//пока не используется
/*Ext.define('Keysystems.Controls.GroupingFeature', {
	extend: 'Ext.grid.feature.Grouping',
	collapseTip: '',
	expandTip: '',
	init: function() {
		var th = this,
			groupTpl = ArrayLib.copy(th.groupRowTpl),
			ind = groupTpl.indexOf("<div data-groupname=\"{groupName:htmlEncode}\" class=\"");
		//Добавляем класс для отображения основных организаций (жирный шрифт)
		ArrayLib.insert(groupTpl, ind + 1, "{[this.formatName(values.record, values)]}");

		//Добавляем элемент для сворачивания \ разворачивания
		ind = groupTpl.indexOf("<div class=\"");
		ArrayLib.insert(groupTpl, ind, "<div class=\"{[this.addCollapsedCls(values)]}\"><\/div>");

		groupTpl[groupTpl.length - 1].formatName = function(record, values) {
			if (values.groupRenderInfo.groupValue && this.groupingFeature.grid.groupBoldTxt) return 'ks-bold ';
		};

		groupTpl[groupTpl.length - 1].addCollapsedCls = function(values) {
			var children = values.groupRenderInfo.children,
				cls = '';

			if (children && children.length !== 0) {
				cls += 'ks-collapse-img' + ' ks-' + (values.isCollapsedGroup ? 'collapse' : 'expand');
			}

			return cls;
		};

		th.groupRowTpl = groupTpl;
		th.callParent(arguments);
	}
});*/