﻿Ext.define('Keysystems.Controls.Grid.ColumnManager',
	{
		extend: 'Ext.window.Window',
		iconCls: 'x_btn_settings',
		title: 'Настроить список',
		minWidth: 500,
		width: 800,
		code: '',
		profileKey: '',
		autoDestroy: false,
		maximizable: true,
		closeAction: 'hide',
		modal: true,
		layout: {type: 'vbox', align: 'stretch'},
		inputColumns: [],
		constructor: function(cfg) {
			Ext.apply(this, cfg);
			this.callParent(arguments);
		},
		update: function() {
			const me = this,
				  grid = me.grid;

			me.setColumns(me.columnsGrid.store.getRootNode().childNodes);
			me.beforeRefreshGrid(grid);
			let columnFilters = grid.getColumnFilters();
			grid.reconfigure(grid.store, me.columns);
			
			//при вызове reconfigure скрывается строка фильтрации. открываем заново и восстанавливаем значения фильтров
			if (columnFilters) {
				grid.applyColumnFilters(columnFilters);
			}
			grid.view.refresh();
		},

		delayUpdate: function() {
			var me = this;
			if (me.updateTimeoutId) clearTimeout(me.updateTimeoutId);
			me.updateTimeoutId = setTimeout(function() {
					delete me.updateTimeoutId;
					me.update();
				},
				1500);
		},

		setColumns: function(data) {
			var me = this,
				iPos,
				setOrderFn = function(columns, inputColumns) {
					if (!columns || !columns.length) return;
					for (var i = 0, len = inputColumns.length; i < len; i++) {
						iPos = ArrayLib.find(columns, ['data', 'dataIndex'], inputColumns[i].dataIndex);
						if (iPos !== -1) {
							//todo: ПЕРЕПИСАТЬ ЭТОТ ДЕБИЛИЗМ
							inputColumns[i].index = columns[iPos].data.number;
							inputColumns[i].hidden = !columns[iPos].data.visibility;
							inputColumns[i].summaryType = columns[iPos].data.summaryType ? 'sum' : null;
							if (!columns[iPos].childNodes || !inputColumns[i].columns
							) //закольцовываем при необходимости
								continue;
							setOrderFn(columns[iPos].childNodes, inputColumns[i].columns);
						}
					}
				},
				setColumnsDataFn = function(columns) {
					const result = [];
					for (var i = 0, len = columns.length; i < len; i++) {
						const c = columns[i].columns && columns[i].columns.length;
						result.push({
							number: i + 1,
							text: columns[i].text,
							dataIndex: columns[i].dataIndex,
							isSummary: columns[i].isSummary,
							summaryType: columns[i].summaryType,
							visibility: !columns[i].hidden,
							width: columns[i].width,
							flex: columns[i].flex,
							leaf: !c,
							children: c ? setColumnsDataFn(columns[i].columns) : null,
							needIcon: columns[i].xtype && columns[i].xtype.toLowerCase() === 'actionimg'
						});
						columns[i].isDescendantOf = me.isDescendantOf;
					}
					return result;
				};

			if (data.length) setOrderFn(data, me.columns);
			me.columns = quickSort(me.columns, 'index', false, 'columns');
			me.columnsData = setColumnsDataFn(me.columns);
			me.setOrder(me.columnsData);
		},
		adaptedColumns: function(cols) {
			var me = this,
				iPos,
				setOrderFn = function(columns) {
					if (!columns || !columns.length) return;
					for (var i = 0, len = columns.length; i < len; i++) {
						if (!columns[i].listeners) columns[i].listeners = {};
						iPos = ArrayLib.find(me.orders, ['dataIndex'], columns[i].dataIndex);
						if (iPos !== -1) {
							let isTreeClm = columns[i].dataIndex === 'tree' || columns[i].dataIndex === 'rowNumberer'; 
							if (!isTreeClm)
								columns[i].index = me.orders[iPos].number;
							columns[i].hidden = !me.orders[iPos].visibility;
							if (me.orders[iPos].width) columns[i].width = me.orders[iPos].width;
							if (me.orders[iPos].flex) columns[i].flex = me.orders[iPos].flex;
							if (me.orders[iPos].hasOwnProperty('summaryType')) columns[i].summaryType = me.orders[iPos].summaryType;
							setOrderFn(columns[i].columns);
						}
					}
				},
				setColumnsDataFn = function(columns, isChilds) {
					const data = [];

					for (var i = 0, len = columns.length; i < len; i++) {
						const dd = columns[i].dataIndex === 'tree' || columns[i].dataIndex === 'M' || columns[i].dataIndex === 'rowNumberer' || isChilds;
						const idx = i + 1;
						data.push({
							number: idx,
							isSummary: columns[i].isSummary,
							summaryType: columns[i].summaryType,
							text: columns[i].text,
							width: columns[i].width,
							flex: columns[i].flex,
							dataIndex: columns[i].dataIndex,
							visibility: !columns[i].hidden,
							leaf: !(columns[i].columns && columns[i].columns.length),
							children: (columns[i].columns && columns[i].columns.length)
								? setColumnsDataFn(columns[i].columns, true)
								: null,
							needIcon: columns[i].xtype && columns[i].xtype.toLowerCase() === 'actionimg',
							allowDrag: !dd,
							allowDrop: !dd
						});
						columns[i].isDescendantOf = me.isDescendantOf;
					}
					return data;
				};

			me.getOrder();
			setOrderFn(cols);
			me.columns = quickSort(cols, 'index', false, 'columns');
			me.columnsData = setColumnsDataFn(me.columns);

			me.setOrder(me.columnsData);

			if (me.store) {
				const root = me.store.getRootNode();
				root.removeAll();
				root.appendChild(me.columnsData);
			}
		},
		isDescendantOf: function(container) {
			return this.ownerCt !== container.ownerCt || this.dataIndex === 'M' || this.dataIndex === 'tree' || this.dataIndex === 'rowNumberer';
		},
		initComponent: function() {
			var me = this;
				
			me.getCookSize();
			me.listeners = {
				hide: function() {
					me.update();
					me.setCookSize(me.width, me.height);
					me.saveToBase();
				}
			};
			const colRN = me.inputColumns.filter(col=>col.dataIndex === 'rowNumberer')[0];
			if (colRN) colRN.index = -100;
			me.adaptedColumns(me.inputColumns);
			me.store = Ext.create('Ext.data.TreeStore',
				{
					fields: ['number', 'dataIndex', 'text', 'visibility', 'flex', 'width', 'needIcon', 'summaryType'],
					root: {
						expanded: true,
						children: me.columnsData
					},
					proxy: 'memory',
					defaultRootText: ''
				});
			me.store.sort('number');
			me.items = [
				me.columnsGrid = Ext.create('Ext.tree.Panel',
					{
						flex: 1,
						rootVisible: false,
						scrollable: true,
						autoSizeOnExpandCollapse: true,
						viewConfig: {
							plugins: {
								ptype: 'gridviewdragdrop',
								containerScroll: true,
								onViewRender: function(view) {
									const th = this;
									var scrollEl;

									if (th.enableDrag) {
										if (th.containerScroll) {
											scrollEl = view.getEl();
										}

										th.dragZone = new Ext.view.DragZone({
											view: view,
											ddGroup: th.dragGroup || th.ddGroup,
											dragText: th.dragText,
											containerScroll: th.containerScroll,
											scrollEl: scrollEl,
											isPreventDrag: function(e, record) {
												return record.get('allowDrag') === false;
											}
										});
									}

									if (th.enableDrop) {
										th.dropZone = new Ext.grid.ViewDropZone({
											view: view,
											ddGroup: th.dropGroup || th.ddGroup,
											positionIndicator: function(node, data, e) {
												const th = this;
												const view = th.view;
												const pos = th.getPosition(e, node);
												const overRecord = view.getRecord(node);
												const draggingRecords = data.records;
												var indicatorY;

												if (!Ext.Array.contains(draggingRecords, overRecord) &&
													(
														pos == 'before' &&
														!th.containsRecordAtOffset(draggingRecords,
															overRecord,
															-1) ||
														pos == 'after' &&
														!th.containsRecordAtOffset(draggingRecords, overRecord, 1)
													) &&
													(overRecord.data.depth < 2 ||
														overRecord.data.allowDrop ||
														(overRecord.data.children.length > 1 && pos == 'after'))) {
													th.valid = true;

													if (th.overRecord != overRecord || th.currentPosition != pos) {

														indicatorY = Ext.fly(node).getY() - view.el.getY() - 1;
														if (pos == 'after') {
															indicatorY += Ext.fly(node).getHeight();
														}
														th.getIndicator().setWidth(Ext.fly(view.el).getWidth())
															.showAt(0, indicatorY);

														// Cache the overRecord and the 'before' or 'after' indicator.
														th.overRecord = overRecord;
														th.currentPosition = pos;
													}
												} else {
													th.invalidateDrop();
												}
											}
										});
									}
								}
							},
							listeners: {
								beforedrop: function(node, data, overModel, dropPosition, dropHandlers) {
									const dataIndex = overModel && overModel.data.dataIndex;

									if (dataIndex && (dataIndex == 'M' || dataIndex == 'tree' || dataIndex == 'rowNumberer') ||
										overModel.data.depth > 1) {
										dropHandlers.cancelDrop();
									} else {
										const overNumber = overModel.data.number;
										const fromNumber = data.records[0].data.number;
										const move = overNumber - fromNumber;

										dropHandlers.processDrop();
										me.swapNode(move, dropPosition);
									}
								}
							},
							getRowClass: (rec) => {
								//пробуем скрыть строки с колонками дерева и нумератора строк
								return rec.get('dataIndex') === 'tree' || rec.get('dataIndex') === 'rowNumberer'
									? 'ks-hidden'
									: (rec.match || '')
							}
						},
						border: 0,
						store: me.store,
						tbar: {
							padding: '0 0 4 0',
							items: [
								me.topColumnBtn = Ext.create('Ext.Button',
									{
										iconCls: 'x_btn_top',
										tooltip: 'В начало',
										tooltipType: 'title',
										handler: function () {
											let diff = me.columnsGrid.getFrstSelect().data.number - 1,
												lockedColumn = me.columnsGrid.store.findNode('dataIndex', 'M') 
													|| me.columnsGrid.store.findNode('dataIndex', 'tree')
													|| me.columnsGrid.store.findNode('dataIndex', 'rowNumberer');
											if (lockedColumn) 
												diff -= lockedColumn.data.number;
											me.swapNode(-diff);
										}
									}),
								me.upColumnBtn = Ext.create('Ext.Button',
									{
										iconCls: 'x_btn_up',
										tooltip: 'Вверх',
										tooltipType: 'title',
										handler: function () {
											me.swapNode(-1);
										}
									}),
								
								me.downColumnBtn = Ext.create('Ext.Button',
									{
										iconCls: 'x_btn_down',
										tooltip: 'Вниз',
										tooltipType: 'title',
										handler: function () {
											me.swapNode(1);
										}
									}),
								me.bottomColumnBtn = Ext.create('Ext.Button',
									{
										iconCls: 'x_btn_bottom',
										tooltip: 'В конец',
										tooltipType: 'title',
										handler: function () {
											let number = me.columnsGrid.getFrstSelect().data.number,
												data = me.columnsGrid.getStore().getDataExt(),
												maxNumber = Math.max.apply(Math, data.map((o) => o.number)),
												diff = maxNumber - number;
											me.swapNode(diff);
										}
									}),
								'-',
								me.searchField = Ext.create('Keysystems.Tree.SearchPanel', {
									searchField: 'text',
									flex: 1
								})
							]
						},
						columns: [
							Keysystems.Base.Abstract.prototype.getTreeColumnCfg(),							
							{
								dataIndex: 'number',
								draggable: false,
								sortable: false,
								menuDisabled: true,
								width: 100,
								/*renderer: function(val, meta, rec, ind) {
									return val + 1;
								},*/
								editor: {
									xtype: 'numberfield',
									minValue: 1,
									hideTrigger: true,
									keyNavEnabled: false,
									mouseWheelEnabled: false,
									maxValue: me.inputColumns.length + 1
								},
								text: '№ п/п'
							}, {
								dataIndex: 'text',
								draggable: false,
								sortable: false,
								flex: 1,
								text: 'Наименование',
								menuDisabled: true,
								renderer: function(val, meta, rec, ind) {
									if (rec.get('needIcon')) {
										const index = ArrayLib.find(me.columns, ['dataIndex'], rec.get('dataIndex'));
										return `<span class="ks-column-header-icon ${me.columns[index === -1
											? ind
											: index].iconCls}"/>`;
									}
									return val;
								}
							}, {
								xtype: 'checkcolumnextra',
								dataIndex: 'visibility',
								draggable: false,
								sortable: false,
								menuDisabled: true,
								headerCheckbox: true,
								cls: 'rks-column-header-checkbox',
								width: 100,
								text: 'Видимый',
								checkRenderer: function(val, meta, rec) {
									const di = rec.get('dataIndex');
									if (di === 'tree' || di === 'M') return '';
								},
								listeners: {
									beforecheckchange: function(th, inx, check, rec) {
										let column = rec.get('dataIndex');
										return column !== 'tree' && column !== 'M';
									},
									checkchange: function(th, rowIndex, checked, node) {
										me.showHideParentNodes(node, checked);
										me.showHideChildNodes(node.childNodes, checked);
										me.delayUpdate();
									},
									headercheckchange: function(checkColumn, checked) {
										if (!checked){
											//никогда не скрываем колонку rowNumberer, tree и M
											me.store.findNode('dataIndex', 'rowNumberer')?.set('visibility', true);
											me.store.findNode('dataIndex', 'tree')?.set('visibility', true);
											me.store.findNode('dataIndex', 'M')?.set('visibility', true);											
										}
									},
								}
							},
							{
								xtype: 'checkcolumnextra',
								dataIndex: 'summaryType',
								draggable: false,
								sortable: false,
								menuDisabled: true,
								//todo открыть после реализации headercheckchange
								//headerCheckbox: true,
								cls: 'rks-column-header-checkbox',
								width: 100,
								text: 'Сумма',
								checkRenderer: function(val, meta, rec) {
									if (!rec.data.isSummary) return '';
								},
								listeners: {
									beforecheckchange: function(th, inx, check, rec) {
										return rec.data.isSummary || false;
									},
									checkchange: function(th, rowIndex, checked, node) {
										if (!node.data.isSummary) return false;

										node.set('summaryType', checked);
										node.data['summaryType'] = checked;
										me.delayUpdate();
									}
								}
							}
						],
						listeners: {
							select: function(th, rec) {
								let canMoveUp = false,
									canMoveDown = false;
								
								if (['tree', 'M', 'rowNumberer'].indexOf(rec.get('dataIndex')) < 0) {
									let number = rec.get('number');
									if (number < 3) {
										if (me.columnsGrid.store.findNode('dataIndex', 'M')) number--;
										if (me.columnsGrid.store.findNode('dataIndex', 'tree')) number--;
										if (me.columnsGrid.store.findNode('dataIndex', 'rowNumberer')) number--;
									}
									canMoveUp = number > 1;

									let maxNumber =  me.columnsGrid.store.last().get('number');
									canMoveDown = number !== maxNumber;
								}
								
								me.topColumnBtn.setDisabled(!canMoveUp);
								me.upColumnBtn.setDisabled(!canMoveUp);
								me.downColumnBtn.setDisabled(!canMoveDown);
								me.bottomColumnBtn.setDisabled(!canMoveDown);
							}
						},
						plugins: [me.editor = Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1, listeners: {
								beforeedit: function(th, col) {
									const rec = col.record;
									const di = rec.get('dataIndex');
									const state = (di === 'tree' || di === 'M');

									return !state;
								},
								validateedit: function(editor, e, eOpts) {
									const {
										value,
										originalValue
									} = e;

									if (Ext.isNumber(value) && value !== originalValue) {
										editor.cancelEdit();
										return me.swapNode(value - originalValue);
									}
								}
							}
						})],
						columnLines: true,
						rowLines: true
					})
			];

			//me.columnsGrid.view.lockedView.on('beforedrop', function(node, data, overModel, dropPosition, dropHandlers) {
			//	var dataIndex = overModel && overModel.data.dataIndex;

			//	if (dataIndex && (dataIndex == 'M' || dataIndex == 'tree') || overModel.data.depth > 1) {
			//		dropHandlers.cancelDrop();
			//	} else {
			//		var overNumber = overModel.data.number,
			//			fromNumber = data.records[0].data.number;

			//		dropHandlers.processDrop();
			//		me.swapNode(overNumber - fromNumber);
			//	}
			//});
			
			me.searchField.treePanel = me.columnsGrid;
			me.callParent(arguments);
			me.bindGrid();
		},
		isChildHide: function(node) {
			for (var i = 0, len = node.childNodes.length; i < len; i++) {
				if (node.childNodes[i].data.visibility) {
					return false;
				}
			}
			return true;
		},
		showHideChildNodes: function(nodes, check) {
			if (nodes && nodes.length) {
				for (var i = 0, len = nodes.length; i < len; i++) {
					nodes[i].set('visibility', check);
					this.showHideChildNodes(nodes[i].childNodes, check);
				}
			}
		},
		showHideParentNodes: function(node, check) {
			if (!node.parentNode) return;
			if (check) {
				if (!node.parentNode.data.visibility) {
					node.parentNode.set('visibility', true);
					this.showHideParentNodes(node.parentNode, true);
				}
			} else {
				if (node.parentNode.data.visibility) {
					if (this.isChildHide(node.parentNode)) {
						node.parentNode.set('visibility', false);
					}
				}
			}
		},
		onColumnShowHide: function(hc, column, visible){
			let me = this;
			let rec = me.columnsGrid.getStore().findNode("dataIndex", column.dataIndex)
				?? me.columnsGrid.getStore().findNode("dataIndex", column.text);
			if (!rec) return;
			rec.set('visibility', visible);
			me.showHideParentNodes(rec, visible);
			me.showHideChildNodes(rec.childNodes, visible);
			me.setOrderByLive(hc.items);
			me.saveDelay();
		},
		
		getCookSize: function() {
			const me = this;
			var wh = Ext.util.Cookies.get('columnsOrder_wh');
			if (!wh) {
				wh = { w: 300, h: 300 };
			} else {
				wh = jQuery.parseJSON(wh);
				wh = { w: wh[0], h: wh[1] };
			}
			me.width = wh.w;
			me.height = wh.h;
		},
		setCookSize: function(w, h) {
			Ext.util.Cookies.set('columnsOrder_wh',
				JSON.stringify([w || 0, h || 0]),
				new Date((new Date()).getTime() + cacheTime));
		},
		swapNode: function(move, dropPosition) {
			let me = this,
				node = me.columnsGrid.getFrstSelect();
			if (!node) return;

			const n = node.data.number + move;
			const allNodes = node.parentNode.childNodes;
			const iPos = allNodes.indexOf(node);
			const maxInd = allNodes[allNodes.length - 1].data.number; //getMaxIndex(allNodes, n);
			const overRecordDataIndex = allNodes[n - 1].data.dataIndex;

			if (n < 0 || n > maxInd) return;

			//Если юзер пытается поставить колонку первой, но там древовидная колонка либо M колонка то не даём.
			if (overRecordDataIndex === 'tree' || overRecordDataIndex === 'M' || overRecordDataIndex === 'rowNumberer') {
				me.columnsGrid.view.refresh();
				return false;
			}

			
			//ArrayLib.find(allNodes, ['data', 'number'], n),
			const di = allNodes[allNodes.indexOf(node)].get('dataIndex');
			var state;

			switch (di) {
				case 'tree':
				case 'rowNumberer':
					state = iPos === 0;
					break;
				case 'M':
					var treePos = ArrayLib.find(allNodes, ['data', 'dataIndex'], 'tree');
					if (!treePos) treePos = ArrayLib.find(allNodes, ['data', 'dataIndex'], 'rowNumberer');
					state = iPos === (treePos === -1 ? 0 : 1);
					break;
				default:
					state = false;
			}

			if (state) return;

			me.columnsGrid.store.suspendEvents();
			
			if (move < 0) {
				for (var i = n; i < maxInd; i++) {
					if (i === node.data.number) continue;
					if (allNodes[i - 1]) {
						allNodes[i - 1].data.number = i + 1;
					}
				}
			} else {
				for (var i = n; i > node.data.number; i--) {
					if (i === node.data.number) continue;
					if (allNodes[i - 1]) {
						allNodes[i - 1].data.number = i - 1;
					}
				}
			}

			node.set('number', n);
			me.store.sort({ property: 'number', direction: 'ASC' });
			//еще раз пробегаем по массиву и исключаем вероятность одинаковых строк с одним number
			Ext.each(allNodes, (n, ind) => {
				n.set('number', ind + 1);
			})

			me.delayUpdate();
			me.store.sort({ property: 'number', direction: 'ASC' });
			me.columnsGrid.store.resumeEvents();
			me.columnsGrid.getView().refresh();
			return true;
		},
		getOrder: function() {
			const me = this;
			if (!(me.gateCode || me.code)) return me.orders = [];
			me.orders = LocalStorage.get(me.getKey()) || [];
			return me.orders;
		},
		setOrder: function(cols) {
			const me = this;
			var fn = function(data, columns) {
				if (!columns || !columns.length) return;
				for (var i = 0, len = columns.length; i < len; i++) {
					data.push({
						isSummary: columns[i].isSummary,
						summaryType: columns[i].summaryType,
						number: columns[i].number + 1,
						dataIndex: columns[i].dataIndex,
						width: columns[i].width,
						flex: columns[i].flex,
						visibility: columns[i].visibility
					});
					fn(data, columns[i].children);
				}
			};
			const orders = [];
			fn(orders, cols);
			me.orders = orders;
			LocalStorage.set(me.getKey(), orders);
		},		
		saveToBase: function() {
			const me = this;
			LocalStorage.set(me.getKey(), me.orders);

			me.m_save({
				url: 'data/SaveGridProfile',
				params: {
					code: me.code,
					gateCode: me.gateCode,
					controlName: me.controlName,
					profile: LocalStorage.get(me.getKey(), true)
				}
			});
		},
		saveSort: function(field, direction) {
			let me = this,
				key = me.getKey() + 'Sort',
				res = { name: field, type: direction };

			ajaxRequest({
				url: (me.linkCode || 'data') + '/SaveProfile_A',
				params: {
					key,
					code: me.code,
					gateCode: me.gateCode,
					controlName: me.controlName,
					profile: JSON.stringify(res)
				}
			});
		},
		saveColumnFilters: function() {
			let me = this,
				key = me.getKey() + 'Filters',	
				res = me.grid.getColumnFilters();

			LocalStorage.set(key, res);

			ajaxRequest({
				url: (me.linkCode || 'data') + '/SaveProfile_A',
				params: {
					key: key,
					code: me.code,
					gateCode: me.gateCode,
					controlName: me.controlName,
					profile: LocalStorage.get(key, true)
				}
			});
		},
		m_save: function(cfg) {
			const me = this;
			if (me.profileKey) {
				cfg.params.key = me.getKey(); // me.profileKey;
				cfg.url = (me.linkCode || 'data') + '/SaveProfile_A';
			}
			ajaxRequest(cfg);
		},
		getKey: function() {
			const me = this;
			if (!me.cacheKey) {
				me.cacheKey = (me.prefix ? me.prefix + '_' : '') +
					(me.code ? me.code + '_' : '') +
					(me.gateCode ? me.gateCode + '_' : '') +
					(me.controlName ? me.controlName + '_' : '') +
					me.profileKey;
			}
			return me.cacheKey;
		},
		m_getCol: function(dataIndex, store) {
			const me = this;
			if (!store) store = me.columns;
			if (!store) return false;
			for (var i = 0, len = store.length; i < len; i++) {
				if (store[i].dataIndex == dataIndex) return store[i];
				if (store[i].columns && store[i].columns.length) {
					const res = me.m_getCol(dataIndex, store[i].columns);
					if (res) return res;
				}
			}
			return false;
		},
		setWidthColumn: function(w, dataIndex, flex) {
			const me = this;
			var c = me.m_getCol(dataIndex);

			if (c) {
				if (w && c.width != w) c.width = w;
				if (flex && !c.flex) c.flex = true;
			}

			c = ArrayLib.find(me.orders, ['dataIndex'], dataIndex);
			if (c !== -1 && (me.orders[c].width != w) || (flex && !me.orders[c].flex)) {
				if (w) me.orders[c].width = w;
				if (flex) me.orders[c].flex = true;

				me.saveDelay();
			}
		},
		saveDelay: function() {
			var me = this;
			//задержка перед сохранения для избежания многократных сохранений
			if (me.isSaveDelay) clearTimeout(me.isSaveDelay);
			me.isSaveDelay = setTimeout(function() {
					me.isSaveDelay = false;
					me.saveToBase();
				},
				saveProfileTimeOut);
		},
		bindGrid: function(grid) {
			var me = this;
			if (grid) me.grid = grid;
			me.grid.columnSettings = me;
			var hc = me.grid.columnManager.secondHeaderCt || me.grid.columnManager.headerCt;
			
			me.beforeRefreshGrid(me.grid);
			me.grid.reconfigure(me.grid.store, me.columns);
			hc.on('columnresize', function(ct, column, w) {
				me.setWidthColumn(w, column.dataIndex);
			});

			hc.on('columnmove',
				function() {
					me.setOrderByLive(hc.items);
					me.saveDelay();
				});

			hc.on('columnhide', (_, column) => me.onColumnShowHide(hc, column, false));
			hc.on('columnshow', (_, column) => me.onColumnShowHide(hc, column, true));
			
			hc.on('sortchange',
				function (ct, column, direction) {
					me.saveSort(column.dataIndex, direction);
				});

			if (me.grid.rendered){
				if (me.grid.localData) {
					setTimeout(function () {
						me.loadColumnFilters();
						me.loadSorters();
						me.grid.view.refresh();
						me.grid.view.features?.filter(f => f.ftype === 'summary')[0]?.doRefresh();
					}, 20);
				}
				else{
					me.loadColumnFilters();
					me.loadSorters();
				}
			}
			else {
				me.grid.on('afterrender', () => {
					me.loadColumnFilters();
					me.loadSorters();
				});
			}
			me.grid.on('onShowFilterRow', () => me.saveColumnFilters());
			me.grid.store.on('filterchange', () => me.saveColumnFilters());

			//todo вынести в перегрузку Ext.grid.header.Container.getMenuItems
			let menu = hc.getMenu();
			me.appendHeaderMenu(menu);
		},

		/**
		 * Подгрузить фильтры из профиля (строка фильтрации и фильтры колонок)
		 */
		loadColumnFilters: function() {
			const me = this;
			let columnFilters = LocalStorage.get(me.getKey() + "Filters");
			if (columnFilters) me.grid.applyColumnFilters(columnFilters);
		},

		/**
		 * Загрузить сортировку из профиля
		 */
		loadSorters: function() {
			const me = this;
			const sort = LocalStorage.get(me.getKey() + "Sort");
			if (!sort) return; 
			if (sort.name && sort.type) {
				me.grid.store.sort({property: sort.name, direction: sort.type});
			}
		},
		
		beforeRefreshGrid: function(grid) {
			// эти действия необходимо выполнять до refresh, чтобы определить showSummaryRow
			var me = this,
				view = grid.view;
			const summaryFeature = view.features[ArrayLib.find(view.features, ['ftype'], 'summary')];
			if (summaryFeature/* && summaryFeature.summaryRecord*/) {
				//const { internalId } = summaryFeature.summaryRecord;
				//summaryRow = $(`tr[data-recordid=${internalId}]`);

				const columns = me.columnsGrid.store.getRootNode().childNodes;
				let allCols = columns.slice();
				Ext.each(columns, parentCol => {
					if (parentCol.childNodes) {
						Ext.each(parentCol.childNodes, childCol => {
							allCols.push(childCol);
						});
					}
				});
				const res = allCols.filter((col) => col.data.summaryType);
				//if (summaryRow) {
					if (res.length === 0) {
						summaryFeature.showSummaryRow = false;
					} else {
						summaryFeature.showSummaryRow = true;
						summaryFeature.onStoreUpdate();
					}
				//}
			}
		},
		
		appendHeaderMenu: function(menu) {
			const me = this,
				cs = me.grid.columnSettings || me.grid.ownerCt.columnSettings;
			
			//избегаем дублирования пунктов
			if ((menu.items.items ?? menu.items).filter(item=>item.text === 'Настроить список').length) return;			
				
			menu.add(
				'-',
				{
					itemId: 'settItem',
					text: 'Настроить список',
					iconCls: 'x_btn_settings',
					handler: function() {
						me.beforeRefreshGrid(cs.grid);
						cs.grid.view.refresh();
						cs.show();
					},
					scope: me
				});
		},

		setOrderByLive: function(cols) {
			var me = this,
				fn = function(data, columns) {
					if (!columns || !columns.length || !columns.each) return;
					columns.each(function(c, i) {
						if (!c.dataIndex && !c.text) return;
						data.push({
							number: i,
							dataIndex: !c.dataIndex ? c.text : c.dataIndex,
							width: c.width,
							flex: c.flex,
							visibility: !c.hidden,
							isSummary: c.isSummary,
							summaryType: c.summaryType
						});
						fn(data, c.items);
					});
				};
			const orders = [];
			fn(orders, cols);
			me.orders = orders;
			LocalStorage.set(me.getKey(), orders);

			setTimeout(function() {
				me.adaptedColumns(me.columns);
			}, window.eventDelay);
		},
		/** Очистить локальный профиль грида
		 */
		cleanProfile: function() {
			const columnsKey = this.getKey();
			LocalStorage.remove(columnsKey);
			const filtersKey =`${columnsKey}Filters`;
			LocalStorage.remove(filtersKey);
		},
		/** Очистить локальный профиль грида (по коду)
		 */
		cleanProfileByCode: function(code, gateCode) {
			const columnsKey =`${code}_${(gateCode ? gateCode + '_' : '')}${Keysystems.Base.List.prototype.profileKey}GridColumns`;
			LocalStorage.remove(columnsKey);
			const filtersKey =`${columnsKey}Filters`;
			LocalStorage.remove(filtersKey);
		}
	});