Ext.define('Keysystems.Controls.Toolbar.DocumentStatusBar', {
	extend: 'Ext.toolbar.Toolbar',
	xtype: 'rks-documentstatusbar',
	alias: 'widget.documentStatusBar',
	dock: 'top',
	readOnly: false,
	statusText: '',
	icon: undefined,
	statusType: undefined,
	collapsedRowsCount: 3,	
	isCollapsible: false,
	btnCollapseIconCls: 'bottom_toolbar_arrow',
	btnExpandIconCls: 'top_toolbar_arrow',
	collapsibleCls: 'ks-ux-toolbar-documentstatusbar--collapsible',
	collapsedCls: 'ks-ux-toolbar-documentstatusbar--collapsed',

	constructor(config) {
		if (Ext.isDefined(config.ReadOnly)) {
			config.readOnly = config.ReadOnly;

			delete config.ReadOnly;
		}

		if (Ext.isDefined(config.TitleStatus)) {
			config.statusText = config.TitleStatus;

			delete config.TitleStatus;
		}

		if (Ext.isDefined(config.Icon)) {
			config.icon = config.Icon;

			delete config.Icon;
		}

		if (Ext.isDefined(config.Type)) {
			config.statusType = config.Type;

			delete config.Type;
		}

		this.callParent([config]);
	},

	initComponent() {
		this.addCls(['ks-ux-toolbar-documentstatusbar', this.collapsedCls]);

		this.items = [
			{
				xtype: 'rks-ux-toolbar-text-item',
				cls: 'ks-ux-toolbar-documentstatusbar__text-ct',
				textElCls: 'ks-ux-toolbar-documentstatusbar__text',
				itemId: 'textItem',
				flex: 1,
				margin: '0 16 0 0',
				text: (this.readOnly ? KS.L10n.tolkodlyachteniya + ' - ' : '') + this.statusText,
				buttons: this.buttons,
				buttonOnClick: this.buttonOnClick,
				iconCls: this.icon ? 'x_btn_' + this.icon : (this.statusType === 'warning' ? 'x_btn_warning' : 'x_btn_info')
			},
			{
				flex: 0,
				tooltip: 'раскрыть',
				itemId: 'collapseBtn',
				iconCls: 'x_btn_' + this.btnCollapseIconCls,
				hidden: true,
				scope: this,
				handler: this.onToggleExpandBtnClick
			},
			{
				flex: 0,
				tooltip: KS.L10n.zakrit,
				iconCls: 'x_btn_close_grey',
				scope: this,
				handler: this.onCloseBtnClick
			}
		];

		this.callParent();
	},

	onCloseBtnClick() {
		this.destroy();
	},

	onToggleExpandBtnClick() {
		this.toggleCollapsed();
	},

	// onBoxReady() {
	// 	this.callParent(arguments);
	//
	// 	const textItem = this.getTextItem();
	// 	const collapseBtn = this.getCollapseBtn();
	//
	// 	const textRowsCount = textItem.textEl.getTextRowsCount();
	//
	// 	this.isCollapsible = textRowsCount > this.collapsedRowsCount;
	//
	// 	if (this.isCollapsible) {
	// 		this.addCls(this.collapsibleCls);
	// 		collapseBtn.setHidden(false);
	// 	}
	// },

	toggleCollapsed() {
		const isCollapsed = this.isCollapsed();

		this.toggleCls(this.collapsedCls, !isCollapsed);

		this.getCollapseBtn().setIconCls('x_btn_' + (isCollapsed ? this.btnExpandIconCls : this.btnCollapseIconCls));

		this.updateLayout();
	},

	getTextItem() {
		return this.textItem || (this.textItem = this.getComponent('textItem'));
	},

	getCollapseBtn() {
		return this.collapseBtn || (this.collapseBtn = this.getComponent('collapseBtn'));
	},

	isCollapsed() {
		return this.getTextItem().textEl.isScrollable();
	}
});

Ext.define('Keysystems.Controls.Toolbar.TextItem', {
	extend: 'Ext.toolbar.Item',

	xtype: 'rks-ux-toolbar-text-item',

	cls: 'ks-ux-toolbar-text-item',

	textElCls: undefined,

	iconElCls: undefined,

	/* eslint-disable indent, max-len */
	renderTpl: [
		'<div class="ks-ux-toolbar-text-item">',
		'<div id="{id}-iconEl" data-ref="iconEl" class="ks-ux-toolbar-text-item__icon {iconElCls}"></div>',
		'<div id="{id}-textEl" data-ref="textEl" class="ks-ux-toolbar-text-item__text {textElCls}">{text}</div>',		
		'<div id="{id}-actionsEl" data-ref="actionsEl" class="ks-ux-toolbar-text-item__text {textElCls}"></div>',
		'</div>'
	],

	/* eslint-enable indent, max-len */

	childEls: ['iconEl', 'textEl', 'actionsEl'],

	renderConfig: {
		text: undefined,
		buttons: undefined,
		iconCls: undefined
	},

	initRenderData() {
		const { textElCls, iconElCls } = this;
		return Ext.apply(this.callParent(), {
			textElCls, iconElCls
		});
	},

	updateIconCls(cls, oldCls) {
		const { iconEl } = this;

		if (oldCls) {
			iconEl.removeCls(oldCls);
		}

		if (cls) {
			iconEl.addCls(cls);
		}

		iconEl[cls ? 'show' : 'hide']();

		return cls;
	},

	updateText(text) {
		const { textEl } = this;

		textEl.setHtml(text);

		textEl[text ? 'show' : 'hide']();

		return text;
	},

	updateButtons(buttons) {
		const me = this;
		const { actionsEl } = this;
		const view = Ext.create('Ext.view.View', {
			store: Ext.create('Ext.data.Store', {
				fields: ['id', 'text', 'title'],
				proxy: 'memory',
				data: buttons
			}),
			itemSelector: '.ks-ux-toolbar-text-item__action',
			tpl: ['<tpl for=".">',
				'<span class="ks-ux-toolbar-text-item__action" title="{tooltip}">{text}</span>',
				'</tpl>'],
			listeners: {
				itemclick: function (view, rec){
					if (me.buttonOnClick) me.buttonOnClick(rec.data);
				}
			},
		});
		
		view.render(actionsEl);
	}
});