﻿/*
Copyright (c) 2014 Keysystems.ru

Contact:  http://www.keysystems.ru/contact

Commercial Usage
Licensees holding valid commercial licenses may use this file in accordance with the Commercial Software License Agreement provided with the Software or, alternatively, in accordance with the terms contained in a written agreement between you and Sencha.

If you are unsure which license is appropriate for your use, please contact the sales department at http://www.keysystems.ru/contact


Авторское право (c) 2014 Keysystems.ru

Контакты:  http://www.keysystems.ru/contact

Коммерческое использование
Лицензиаты имеющие действительные коммерческие лицензии могут использовать этот файл в соответствии с лицензионным соглашением коммерческого программного обеспечения поставляемой с программным обеспечением либо, альтернативно, в соответствии с условиями содержащимися в письменном соглашении между вами и Sencha.

Если вы не уверены, какая лицензию подходит для вашего использования, пожалуйста, свяжитесь с отделом продаж в http://www.keysystems.ru/contact
*/

Ext.define('Keysystems.form.field.TextAreaTrigger', {
	extend: 'Ext.form.field.Text',
	alias: 'widget.textareatrigger',
	userCls: 'rks-textarea-trigger',
	trgCls: 'x_btn_function',
	triggers: {
		btn: {
			cls: 'x-dict-trigger ',
			extraCls: /firefox|iceweasel/i.test(Ext.userAgent) ? 'x-keysystems-textareatrigger-ff' : '',
			handler: function () {
				this.onTriggerClick();
			}
		}
	},
	blankText: KS.L10n.pole_obyazatelno_dlya_zapolneniya,
	msgTarget: 'side',
	initComponent: function () {
		var me = this;
		var trg = me.getTrigger('btn');
		if (trg) trg.cls += me.trgCls;
		me.callParent(arguments);
	},
	fieldStyle: 'resize: none',
	fieldSubTpl: [
		'<textarea id="{id}" role="{role}" {inputAttrTpl}',
		'<tpl if="name"> name="{name}"</tpl>',
		'<tpl if="rows"> rows="{rows}"',
		'<tpl else> rows="1"',
		'</tpl>',
		'<tpl if="cols"> cols="{cols}" </tpl>',
		'<tpl if="placeholder"> placeholder="{placeholder}"</tpl>',
		'<tpl if="size"> size="{size}"</tpl>',
		'<tpl if="maxLength !== undefined"> maxlength="{maxLength}"</tpl>',
		'<tpl if="readOnly"> readonly="readonly"</tpl>',
		'<tpl if="disabled"> disabled="disabled"</tpl>',
		'<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>',
		' class="{fieldCls} {typeCls} {inputCls}" ',
		'<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
		' autocomplete="off">\n',
		'<tpl if="value">{[Ext.util.Format.htmlEncode(values.value)]}</tpl>',
		'</textarea>',
		{disableFormats: true}
	]
});

//Справочники
Ext.define('Keysystems.Controls.Dict.Edit', {
	extend: 'Ext.form.FieldContainer',
	alias: 'widget.dictedit',
	userCls: 'rks-dictEdit',
	config: {
		labelWidth: 150,
		width: _,
		height: 24,
		codeField: 'CODE',
		nameField: 'NAME',
		animDict: false,
		cleaningKey: true,
		fieldLabel: '',
		fieldLink: 'LINK',
		showVisibleFields: false,
		textSelected: KS.L10n.Отобрано,
		textNotSelected: '',
		handler: []
	},
	constructor: function(cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function() {
		var me = this;
		if (!Ext.isArray(me.handler)) me.handler = [me.handler];
		me.layout = 'hbox';
		me.itemsCreate();
		me.callParent(arguments);
		me.setReadOnly(me.readOnly);
		me.setValue(me.value);
		me.on('ksDictChange', Ext.emptyFn);
	},
	createContextMenu: function () {
		const me = this;
		let items = [];
		if (!me.readOnly && me.cleaningKey) {
			items.push(
				{
					text: KS.L10n.clear_value,
					listeners: {
						'click': function () {
							selectDialogShow(KS.L10n.attention, `${KS.L10n.clear_value}?`, function () {								
								(me.ksSetValue || me.setValue).call(me, null);
							});
						}
					}
				}
			)
		}
		if (me.mode && me.mode.toUpperCase() === 'MULTI') {
			items.push({
				xtype: 'menucheckitem',
				text: KS.L10n.show_selected,
				listeners: {
					checkchange: function (_, checked) {
						me.getContextMenu().hide();
						me.showVisibleFields = checked;
						if (me.fieldName) me.fieldName.setValue(me.getNameLabelText(me.value));
						else if (me.fieldCode) me.fieldCode.setValue(me.getCodeLabelText(me.value));
					}
				}

			});
		}
		return Ext.create('Ext.menu.Menu', {items: items});
	},
	getContextMenu: function () {
		return this.contextMenu || (this.contextMenu = this.createContextMenu());
	},
	onTriggerContextMenu: function (ev) {
		if (ev.button === 2 && window.isDebug) {
			ev.stopEvent();
			this.getContextMenu().showAt(ev.getXY());
		}
	},
	initTrigger: function () {
		var me = this,
			triggerWrap = me.triggerWrap,
			triggerEl = me.triggerEl,
			disableCheck = me.disableCheck,
			els,
			len,
			el,
			i,
			idx,
			cls;

		if (me.repeatTriggerClick) {
			me.triggerRepeater = new Ext.util.ClickRepeater(triggerWrap, {
				preventDefault: true,
				handler: me.onTriggerWrapClick,
				listeners: {
					mouseup: me.onTriggerWrapMouseup,
					contextmenu: me.onTriggerContextMenu,
					scope: me
				},
				scope: me
			});
		} else {
			me.mon(triggerWrap, {
				click: me.onTriggerWrapClick,
				contextmenu: me.onTriggerContextMenu,
				mouseup: me.onTriggerWrapMouseup,
				scope: me
			});
		}

		triggerEl.setVisibilityMode(Ext.Element.DISPLAY);
		triggerEl.addClsOnOver(me.triggerBaseCls + '-over', disableCheck, me);

		els = triggerEl.elements;
		len = els.length;

		for (i = 0; i < len; i++) {
			el = els[i];
			idx = i + 1;
			cls = me['trigger' + (idx) + 'Cls'];
			if (cls) {
				el.addClsOnOver(cls + '-over', disableCheck, me);
				el.addClsOnClick(cls + '-click', disableCheck, me);
			}
		}

		triggerEl.addClsOnClick(me.triggerBaseCls + '-click', disableCheck, me);

	},
	getFieldCfg: function () {
		var me = this,
			cfg = {
				Code: this.Code,
				Action: this.Action,
				ParentID: this.ParentID,
				btnsCount: me.handler.length,
				editable: me.cleaningKey,
				enableKeyEvents: true,
				width: me.codeWidth || 150,
				initTrigger: me.initTrigger,
				onTriggerContextMenu: me.onTriggerContextMenu.bind(me),
				msgTarget: 'disabled',
				listeners: {
					render: function (e) {
						e.getEl().on('contextmenu', function (target) {
							target.stopEvent();
							const cm = me.getContextMenu();
							cm.showAt(target.getXY());
						}, e);
					}
				}
			};
		
		if (me.cleaningKey) {
			let contextFn = function() {
				let field = me.fieldCode || me.fieldName,
					newVal = field.getValue(),
					oldVal = me.getOldContextValue(me.fieldCode ? me.codeField : me.nameField);

				if (oldVal === null) oldVal = '';
				if (newVal !== oldVal) {
					if (me.handler.length) {
						if (!me.denyFind && !me.readOnly) {
							me.contextSearch = newVal;
						}
						// для отчетов передаем сам контрол в handler
						me.handler[me.handler.length - 1].handler(me);
						delete me.contextSearch;
					}
				}
			};

			cfg.listeners.change = function(th, newValue) {
				if (!me.passClear && newValue === '') {
					me._clear();
				}
			};
			
			cfg.listeners.keydown = function(th, e) {
				if (me.readOnly) {
					e.stopEvent();
					return;
				}
				
				if ([e.BACKSPACE, e.DELETE].indexOf(e.getKey()) !== -1) {
					if (th.getValue() === '' && !me.isEmpty()) {
						me._clear();
					}
				} else if (e.ENTER === e.getKey()) {
					contextFn();
				}
			};
			
			cfg.listeners.blur = function() {
				if (me.readOnly || (me.fieldCode || me.fieldName).hidden) return;

				let field = me.fieldCode || me.fieldName,
					newVal = field.getValue(),
					oldVal = me.getOldContextValue(me.fieldCode ? me.codeField : me.nameField);
				
				if (oldVal === null) oldVal = '';
				if (newVal !== oldVal && !newVal.trim().length) {
					if (me.clear) {
						me.clear();
					} else {
						me._clear();
					}
				} else {
					contextFn();
				}
			};
		}
	
		//if (me.codeWidth) cfg.width = me.codeWidth;
		//else cfg.flex = 1;
		if (me.handler.length) cfg.triggers = {};
		for (var i = 0, len = me.handler.length; i < len; i++) {

			if (typeof me.handler[i] === 'function') {
				me.handler[i] = {
					handler: me.handler[i],
					cls: 'x_btn_dict x-dict-trigger'
				};
			}
			let func = me.handler[i].handler;
			cfg.triggers['trigger' + (i + 1)] = {
				cls: me.handler[i].cls,
				width: '22px',
				handler: func
			};
			/*
			//EXTJS71 посмотреть где используется анимация
			if (me.animDict) {
				cfg['onTrigger' + (i + 1) + 'Over'] = function(target) {
					if (!this.childList) this.childList = [];
					var iPos = ArrayLib.find(this.childList, ['el', 'dom'], target);
					if (iPos === -1) {
						iPos = this.childList.length;
						this.childList.push({ el: { dom: target } });
					}

					transform.scaleX(this.childList[iPos], 0.025);
					//transform.rotate(this.childList[iPos], 3);
				};
				cfg['onTrigger' + (i + 1) + 'Out'] = function(target) {
					var iPos = ArrayLib.find(this.childList, ['el', 'dom'], target);
					if (iPos !== -1) this.childList[iPos].isTransform = false;
				};
			}*/
		}
		return cfg;
	},
	getOldContextValue: function(field) {
		let me = this,
			result = '',
			v = me.value;

		if (v && v.length > 1) {
			return Ext.String.format(me.textSelected, v.length)
		}

		if (v && v[0]) {
			result = v[0][field];
			if (!result && v[0].data) {
				result = v[0].data[field];
			}
		}

		return result;
	},
	getTextCfg: function () {
		const me = this;
		return {
			readOnly: true,
			flex: 3,			
			blankText: KS.L10n.pole_obyazatelno_dlya_zapolneniya,
			msgTarget: 'side',
			listeners: {
				render: function (e) {
					e.getEl().on('contextmenu', function (target) {
						target.stopEvent();
						const cm = me.getContextMenu();
						cm.showAt(target.getXY());
					}, e);
				}
			}
		};
	},
	itemsCreate: function () {
		var me = this;
		if (me.items == null)
			me.items = [
				me.fieldCode = Ext.create('Ext.form.field.Text', me.getFieldCfg()),
				{xtype: 'splitter'},
				me.fieldName = Ext.create('Ext.form.field.Text', me.getTextCfg())
			];
	},
	getCodeLabelText: function (v) {
		const me = this;
		var len = v.length;
		if (len) {
			if (len === 1) {
				v = v[0].data || v[0];
				return v[this.codeField];
			}
			else if (me.showVisibleFields && !me.fieldName){
				let arr = [];
				v.forEach(value => {
					arr.push((value.data || value)[this.codeField] || ' ');
				});
				return arr.join('; ');
			}
			return Ext.String.format(me.textSelected, len);
		}
		return me.textNotSelected;
	},
	getNameLabelText: function (v) {
		const me = this;
		const len = v.length;
		if (len) {
			if (len === 1) {
				v = (v = v[0]).data || v;
				const res = window.getTextByVisibleFields(this.code || this.Code, this.visibleFields, v, this.nameField);
				if (me.fieldCode || res) return res;
			}
			else if (me.showVisibleFields){
				let arr = [];
				// Если в форме отбора записи из спраочника есть чек по выбору основной колонки - то сортируем по ней				
				if (me.mainColumn){
					v.sort((a, b) => !(a.data || a).MAIN - !(b.data || b).MAIN);
				}
				v.forEach(value => {
					arr.push(window.getTextByVisibleFields(this.code || this.Code, this.visibleFields, value.data || value, this.nameField))
				});
				return arr.join('; ');
			}
			return Ext.String.format(me.textSelected, len);
		}
		return me.textNotSelected;
	},
	setLabelText: function (v) {
		var me = this;
		me.passClear = true;
		if (me.fieldCode) me.fieldCode.setValue(me.getCodeLabelText(v));
		if (me.fieldName) me.fieldName.setValue(me.getNameLabelText(v));
		delete me.passClear;
	},
	dictToJSON: function () {
		var me = this,
			res = [];
		Ext.each(me, function (rec) {
			res.push(rec.data || rec);
		});
		return res;
	},
	setValue: function (value) {
		var me = this,
			chValue = function () {
				if (!value) value = [];
				if (!Ext.isArray(value)) value = [value];
				for (var i = value.length - 1; i > -1; i--) {
					var v = value[i];
					if (!v || (!(v.data || v)[me.fieldLink])) value.splice(i, 1);
				}
				value.toJSON = me.dictToJSON;
			};

		chValue(value);
		me.value = value;
		me.setLabelText(value);
		me.fill();
		me.checkBadLinks();
		me._checkChange();
	},

	_checkChange: function () {
		var me = this,
			v = me.getLinks(1);
		if (me.lstLinks && me.lstLinks !== v) {
			//this, value, getLinks(1), last getLinks(1)
			me.fireEvent('change', me, me.getValue(), v, me.lstLinks);
		}
		me.lstLinks = v;
	},

	checkBadLinks: function () {
		KsDictBadLib.checkBadLinks(this);
	},

	colorizeBad: function (v) {
		var me = this;
		v = !!v;
		me.fieldCode && me.fieldCode.inputEl && me.fieldCode.inputEl[v ? 'addCls' : 'removeCls']('ks-holiday');
		me.fieldName && me.fieldName.inputEl && me.fieldName.inputEl[v ? 'addCls' : 'removeCls']('ks-holiday');
	},

	setValueBy: function (value, field) {
		var me = this,
			res = [];
		if (field) {
			if (!Ext.isArray(value)) value = [value];
			Ext.each(value, function (v) {
				v = v.data || v;
				var r = {};
				r[me.fieldLink] = v[field];
				r[me.codeField] = v[field + '_' + me.codeField];
				r[me.nameField] = v[field + '_' + me.nameField];
				res.push(r);
			});
		} else {
			res = value;
		}
		me.setValue(res);
	},

	getValue: function () {
		return this.value;
	},
	getCodeNameValue: function() {
		let me = this,
			value = me.value,
			res = [];
		
		Ext.each(value, v => {
			let val = v.data || v;
			res.push({
				LINK: val[me.fieldLink],
				CODE: val[me.codeField],
				NAME: val[me.nameField]
			});
		});
		
		return res;
	},
	isLock: function () {
		return this.lock;
	},
	setLock: function (lock) {
		this.lock = lock;
		this.setDisabled(lock);
		this.setReadOnly(lock);
	},
	setReadOnly: function (state) {
		var me = this;
		if (me.fieldCode && me.cleaningKey) me.fieldCode.editable = !state;
		me.readOnly = state;
		me[state ? 'addCls' : 'removeCls']('ks-readOnly');
	},
	getLink: function (fieldLink) {
		return this.getLinks(0, fieldLink)[0] || 0;
	},
	getCode: function () {
		var codeField = this.codeField,
			code = '',
			v = this.value;

		if (v && v[0]) {
			code = v[0][codeField];
			if (!code && v[0].data) code = v[0].data[codeField];
		}

		return code;
	},
	getLinks: function (isJson, fieldLink) {
		if (!this.value) return [];

		fieldLink = fieldLink || this.fieldLink;
		var result = [],
			link;

		for (var i = 0, len = this.value.length; i < len; i++) {
			if (this.value[i]) {
				link = this.value[i][fieldLink];
				if (!link && this.value[i].data) link = this.value[i].data[fieldLink];
				if (link) result.push(link);
			}
		}
		return isJson ? JSON.stringify(result) : result;
	},
	isEmpty: function () {
		var val = this.getValue();
		for (var i = 0, len = val.length; i < len; i++) {
			if (val[i] && ((val[i].data && val[i].data[this.fieldLink]) || val[i][this.fieldLink])) {
				return false;
			}
		}
		return true;
	},

	beforeclear: function () {
		return !this.readOnly;
	},

	//by override
	clear: Ext.emptyFn,
	//by override
	fill: Ext.emptyFn,
	_clear: function () {
		if (this.beforeclear() === false) return;
		this.setValue([]);
		this.clear();
	},
	highlightInputEl: function(){
		this.getEl().frame("#7eadd9");
		(this.fieldCode || this.fieldName).focus(false, 200);
	},
	validate: function(){
		(this.fieldName || this.fieldCode).validate();
	}
});

//Справочники только с полем для имени
Ext.define('Keysystems.Controls.DictName.Edit', {
	alias: 'widget.dictnameedit',
	extend: 'Keysystems.Controls.Dict.Edit',
	itemsCreate: function () {
		var me = this,
			cfg = me.getFieldCfg();

		cfg.flex = 1;
		me.items = [me.fieldName = Ext.create('Ext.form.field.Text', cfg)];
	}
});

//Справочники только с полем для кода
Ext.define('Keysystems.Controls.DictCode.Edit', {
	extend: 'Keysystems.Controls.Dict.Edit',
	itemsCreate: function () {
		var me = this,
			cfg = me.getFieldCfg();

		cfg.flex = 1;
		me.items = [me.fieldCode = Ext.create('Ext.form.field.Text', cfg)];
		me.fieldCode.owner = me;
	},
	setFullValue: function (value) {
		var me = this;
		me.setValue(value);
		if (value.length == 1) {
			var row = value[0],
				text = '';
			if (!(row && row.data)) return;
			if (row.data.CODE) {
				text += row.data.CODE + '. ';
			}
			text += row.data.NAME;
			me.fieldCode.setValue(text);
		}
	}
});
//Редактор формул
Ext.define('Keysystems.Controls.Formula.Edit', {
	alias: 'widget.formulaedit',
	extend: 'Keysystems.form.field.TextAreaTrigger',
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	onTriggerClick: function () {
		this.execute();
	},
	execute: function (callBack) {
		var me = this;
		Ext.create('Keysystems.Controls.FormulaEditor', {
			text: me.getValue(),
			Code: me.Code,
			IncludeThruNumber: me.IncludeThruNumber,
			IncludeSCalc: me.IncludeSCalc,
			SCalcLinks: me.SCalcLinks,
			SWorkLinks: me.SWorkLinks,
			DH1: me.DH1,
			DH2: me.DH2,
			IsMask: me.IsMask,
			okFunc: function (text) {
				me.setValue(text);
				if (callBack) callBack(text);
			},
			parentView: me.ownerCt
		});
	}
});

//Тип вида документа
Ext.define('Keysystems.Controls.DocVid.Type', {
	extend: 'Ext.form.FieldContainer',
	fieldLabel: 'Тип документа',
	ksAllowEmpty: true,
	get DocType() {
		if (!this.m_DocType) {
			this.m_DocType = {};
			// ReSharper disable UseOfImplicitGlobalInFunctionScope
			var t = miscTypes.DocType;
			// ReSharper restore UseOfImplicitGlobalInFunctionScope
			for (var key in t) this.m_DocType[t[key]] = key * 1;
		}
		return this.m_DocType;
	},

	getFilterTypes: function () {
		return this.m_filterTypes;
	},
	setFilterTypes: function (v) {
		var me = this,
			t = me.DocType;
		me.m_filterTypes = v;

		if (!v || v === t.Внутренний || v === t.Исходящий || v === t.Входящий) {
			me.insideBox.setDisabled(true);
			me.inBox.setDisabled(true);
			me.outBox.setDisabled(true);
		} else {
			me.insideBox.setDisabled(!(v & t.Внутренний));
			me.inBox.setDisabled(!(v & t.Входящий));
			me.outBox.setDisabled(!(v & t.Исходящий));
		}

		var arr = [t.Внутренний, t.Исходящий, t.Входящий];
		var value = me.getValue();
		Ext.each(arr, function (t1) {
			if (!(value & t1) && (v & t1)) {
				me.setValue(v);
				return false;
			}
			return true;
		});
	},
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function () {
		var me = this;
		me.layout = 'hbox';
		me.bodyPadding = 10;
		me.items = [
			me.insideBox = Ext.create('Ext.form.field.Checkbox', {
				boxLabel: 'внутренний',
				padding: '0 10 0 0',
				checked: true
			}),
			me.inBox = Ext.create('Ext.form.field.Checkbox', {
				boxLabel: 'входящий',
				padding: '0 10 0 10',
				listeners: {change: me.inOutChange}
			}),
			me.outBox = Ext.create('Ext.form.field.Checkbox', {
				boxLabel: 'исходящий',
				padding: '0 10 0 10',
				listeners: {change: me.inOutChange}
			})
		];

		this.callParent(arguments);
	},
	setValue: function (type) {
		var me = this,
			t = me.DocType;
		me.insideBox.setValue(!!(type & t.Внутренний));
		me.outBox.setValue(!!(type & t.Исходящий));
		me.inBox.setValue(!!(type & t.Входящий));
	},
	getValue: function () {
		var me = this,
			result = 0,
			t = me.DocType;
		if (me.insideBox.getValue()) result += t.Внутренний;
		if (me.outBox.getValue()) result += t.Исходящий;
		if (me.inBox.getValue()) result += t.Входящий;
		return result;
	},
	getCorrDisabled: function () {
		return !(this.inBox.getValue() || this.outBox.getValue());
	}
});
Ext.define('Keysystems.Controls.IconCombo', {
	extend: 'Ext.form.field.ComboBox',
	alias: 'widget.iconcombo',
	type: 'iconcombo',
	autoSelect: false,
	typeAhead: false,
	//по дефолту (0 или 4) при вводе текста сразу показывается выпадающий список с операторами
	minChars: 10000,
	queryMode: 'local',
	initComponent: function () {
		Ext.apply(this, {
			listConfig: {
				iconClsField: this.iconClsField,
				getInnerTpl: function () {
					return '<tpl for=".">' + '<div class="x-combo-list-item ux-icon-combo-item ux-icon-combo-item-image ' + '{' + this.iconClsField + '}">' + '{' + this.displayField + '}' + '</div></tpl>';
				}
			},
			fieldSubTpl: [
				'<div class="{hiddenDataCls}" role="presentation"></div>',
				'<div class="ux-icon-combo-wrap"><input id="{id}" type="{type}" spellcheck="false" {inputAttrTpl}',
				'<tpl if="value">value="{value}"</tpl>',
				'<tpl if="name"> name="{name}"</tpl>',
				'<tpl if="placeholder"> placeholder="{placeholder}"</tpl>',
				'<tpl if="readOnly"> readonly="readonly"</tpl>',
				'<tpl if="disabled"> disabled="disabled"</tpl>',
				'<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
				'class="x-form-text x-form-text-default {fieldCls} {typeCls}" autocomplete="off" /></div>',
				{
					compiled: true,
					disableFormats: true
				}
			]			
		});

		this.callParent(arguments);
	},

	onRender: function () {
		this.callParent(arguments);

		var posit = this.el.down('div[class=ux-icon-combo-wrap]');
		posit.applyStyles({position: 'relative'});
		this.el.down('input').addCls('ux-icon-combo-input');

		this.icon = Ext.core.DomHelper.append(posit, {
			tag: 'div',
			style: 'position:absolute;'
		});
	},

	setIconCls: function () {
		if (this.rendered) {
			var rec = this.store.findRecord(this.valueField, this.getValue());
			if (rec) {
				this.icon.className = 'ux-icon-combo-icon ' + rec.get(this.iconClsField);
			}
			else if (!this.editable) {
				this.icon.className = ' ';
			}
		} else {
			this.on('render', this.setIconCls, this, {single: true});
		}
	},

	setTextCls: function () {
		if (this.rendered) {
			let inputEl = Ext.get(this.inputId);
			if (!inputEl) return;
			inputEl.setStyle({color: 'black'});
		} else {
			this.on('render', this.setTextCls, this, {single: true});
		}
	},

	listeners: {
		change: function () {
			this.setIconCls();
			this.setTextCls();
		},
		keydown: function () {
			this.setTextCls();
		},
		focus: function () {
			this.setTextCls();
		},
		blur: function () {
			this.setTextCls();
		},
	},
	setValue: function () {
		this.callParent(arguments);
		this.setIconCls();
		this.setTextCls();
	}
});

/**
 * Комбо с операторами фильтрации
 * allowedConditions {Array.<number>} - массив отображаемых операторов
 * conditionMappings {Object.<number, {name: string, value: string, icon: string}>} - перегруженные свойства операторов
 * showDeleteBtn {boolean} [true]- видимость кнопки очистки значения
 */
Ext.define('Keysystems.Controls.FilterOperator', {
	extend: 'Keysystems.Controls.IconCombo',
	displayField: "name",
	valueField: "value",
	iconClsField: 'icon',
	mode: 'local',
	checkChangeBuffer: 500,
	enableKeyEvents: true,
	allowBlank: true,
	matchFieldWidth: false,
	config: {
		allowedConditions: [],
		conditionMappings: {},
		showDeleteBtn: true,
	},
	delKeys: [
		Ext.EventObjectImpl.prototype.DELETE,
	],
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function () {
		let me = this,
			data = [];
		me.allowedConditions.forEach(condition => {
			let item = {
				'name': miscTypes.Conditions[condition],
				'value': condition,
			};
			switch (+condition) {
				case 0: //"Равно":
					item.icon = "x_btn_FilterOp_Equals";
					break;
				case 1: //"Не равно":
					item.icon = "x_btn_FilterOp_NotEquals";
					break;
				case 2: //"Больше":
					item.icon = "x_btn_FilterOp_GreaterThan";
					break;
				case 3: //"Больше или равно":
					item.icon = "x_btn_FilterOp_GreaterThanOrEqualTo";
					break;
				case 4: //"Меньше":
					item.icon = "x_btn_FilterOp_LessThan";
					break;
				case 5: //"Меньше или равно":
					item.icon = "x_btn_FilterOp_LessThanOrEqualTo";
					break;
				case 6: //"Содержит":
					item.icon = "x_btn_FilterOp_Contains";
					break;
				case 7: //"Не содержит":
					item.icon = "x_btn_FilterOp_DoesNotContain";
					break;
				case 8: //"Начинается с":
					item.icon = "x_btn_FilterOp_StartsWith";
					break;
				case 9: //"Заканчивается на":
					item.icon = "x_btn_FilterOp_EndsWith";
					break;
			}
			let mapping = me.conditionMappings[condition];
			if (mapping) {
				if (mapping.name) item.name = mapping.name;
				if (mapping.value) item.value = mapping.value;
				if (mapping.icon) item.icon = mapping.icon;
			}

			data.push(item);
		});

		this.store = Ext.create('Ext.data.Store',
			{
				fields: ['icon', 'name', 'value'],
				data: data,
				proxy: 'memory'
			});
		me.on('keydown', function (th, e) {
			if (me.delKeys.indexOf(e.getKey()) >= 0) {
				me.clearValue();
			}
			//чтобы не срабатывала прокрутка страницы при нажатии вправо/влево
			if ((e.keyCode == 37)||(e.keyCode == 39)) {
				return false;
			}
		});
		if (!me.showDeleteBtn) me.getTrigger('delete').cls += ' ks-hidden';

		me.callParent();
		Ext.apply(this, {
			listConfig: {
				iconClsField: this.iconClsField,
				getInnerTpl: function () {
					return '<tpl for=".">' + '<div class="x-combo-list-item ux-icon-combo-item ux-icon-combo-item-filterimage ' + '{' + this.iconClsField + '}">' + '{' + this.displayField + '}' + '</div></tpl>';
				}
			}
		});
	},
	triggers: {
		'delete': {
			cls: 'x-form-arrow-trigger x-form-trigger x-dict-trigger x_btn_delete_note_def',
			width: '22px',
			handler: function () {
				this.setValue('');
				this.selectText();
			}
		}
	},	
	getDisplayValue: function(tplData) {
		const s = this.callParent(arguments);
		return this.store.findRecord(this.displayField, s) ? '' : s;
	},
});

//плагин для редактирования строки грида
Ext.define('Keysystems.grid.plugin.RowEditing', {
	extend: 'Ext.grid.plugin.RowEditing',
	clicksToEdit: 1,
	autoComplete: true,
	readOnly: false,
	getReadOnly: function () {
		return this.readOnly;
	},
	getColumnField: function () {
		return this.getReadOnly() ? this.getViewColumnField.apply(this, arguments) : this.callParent(arguments);
	},
	getViewColumnField: function (columnHeader, defaultField) {
		var field = columnHeader.viewField;
		if (!(field && field.isFormField)) {
			field = columnHeader.viewField = this.createViewColumnField(columnHeader, defaultField);
		}
		return field;
	},
	createViewColumnField: function (columnHeader, defaultField) {
		var field = columnHeader.viewField;

		if (!field && columnHeader.viewer) {
			field = columnHeader.viewer;
			columnHeader.viewer = null;
		}

		if (!field && defaultField) {
			field = defaultField;
		}

		if (field) {
			if (field.isComponent) {
				field.column = columnHeader;
				field.isEditorComponent = true;
			} else {
				if (Ext.isString(field)) {
					field = {
						name: columnHeader.dataIndex,
						xtype: field,
						column: columnHeader,
						isEditorComponent: true
					};
				} else {
					field = Ext.apply({
						name: columnHeader.dataIndex,
						column: columnHeader,
						isEditorComponent: true
					}, field);
				}
				field = Ext.ComponentManager.create(field, this.defaultFieldXType);
			}
			columnHeader.viewField = field;
		}
		return field;
	},
	createColumnField: function () {
		var me = this,
			field = me.callParent(arguments);
		if (field && me.autoComplete) {
			field.on('change', function (th, v) {
				if (th instanceof Keysystems.Controls.CalcField) v = th.getNumValue();
				me.context.record.set(field.name, v);
				me.fireEvent('updrecord', field.name, v, me.context.record, me.context);
			});
		}
		return field;
	},
	initEditor: function () {
		return Ext.create('Keysystems.grid.RowEditor', this.initEditorConfig());
	},
	initEditorConfig: function () {
		var cfg = this.callParent(arguments);
		cfg.autoComplete = this.autoComplete;
		return cfg;
	},
	init: function () {
		this.callParent(arguments);
		this.onBeforeReconfigure();
		this.onReconfigure();
	}
});
Ext.define('Keysystems.grid.RowEditor', {
	extend: 'Ext.grid.RowEditor',
	clicksToEdit: 1,
	autoComplete: true,
	beforeEdit: function () {
		var me = this,
			scrollDelta;

		if (me.isVisible() && me.errorSummary && me.isDirty()) {
			if (me.autoComplete) {
				if (!me.completeEdit()) return false;
			} else {
				if (!me.autoCancel) {
					scrollDelta = me.getScrollDelta();
					if (scrollDelta) {
						me.scrollingViewEl.scrollBy(0, scrollDelta, true);
					}
					me.showToolTip();
					return false;
				}
			}
		}
	},
	updateButton: function () {
	},
	getFloatingButtons: function () {
		var btns = this.callParent(arguments);
		btns.hide();
		return btns;
	}
});

//comboBox с null-значениями в items
Ext.define('Keysystems.Controls.ComboBoxExtra', {
	extend: 'Ext.form.field.ComboBox',
	alias: ['widget.comboboxextra', 'widget.comboextra'],
	delKeys: [
		Ext.EventObjectImpl.prototype.DELETE,
	],
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function () {
		var me = this,
			res = me.callParent(arguments);
		me.on('change', function (th, v) {
			if (th.multiSelect) {
				if (!v.length) th.setValue([null]);
				if (v.length > 1) {
					Ext.each(v, function (v1, i) {
						if (v1 === null) {
							v.splice(i, 1);
							th.setValue(v);
							return false;
						}
						return true;
					});
				}
			}
		});

		me.on('keydown', function (th, e) {
			if (me.delKeys.indexOf(e.getKey()) >= 0) {
				me.clearValue();
			}
		});

		//открываем по клику. по умолчанию combobox открывается только по клику на стрелке.
		me.on('focus', function () {
			this.expand();
		});
		return res;
	},
	setValue: function (value, doSelect) {
		var me = this,
			valueNotFoundText = me.valueNotFoundText,
			inputEl = me.inputEl,
			i,
			len,
			record,
			dataObj,
			matchedRecords = [],
			displayTplData = [],
			processedValue = [];

		if (me.store.loading) {

			me.value = value;
			me.setHiddenValue(me.value);
			return me;
		}


		value = Ext.Array.fromExtra(value);


		for (i = 0, len = value.length; i < len; i++) {
			record = value[i];
			if (!record || !record.isModel) {
				record = me.findRecordByValue(record);
			}

			if (record) {
				matchedRecords.push(record);
				displayTplData.push(record.data);
				processedValue.push(record.get(me.valueField));
			} else {


				if (!me.forceSelection) {
					processedValue.push(value[i]);
					dataObj = {};
					dataObj[me.displayField] = value[i];
					displayTplData.push(dataObj);

				} else if (Ext.isDefined(valueNotFoundText)) {
					displayTplData.push(valueNotFoundText);
				}
			}
		}


		me.setHiddenValue(processedValue);
		me.value = me.multiSelect ? processedValue : processedValue[0];
		if (!Ext.isDefined(me.value)) {
			me.value = null;
		}
		me.displayTplData = displayTplData;
		me.lastSelection = me.valueModels = matchedRecords;

		if (inputEl && me.emptyText && !Ext.isEmpty(value)) {
			inputEl.removeCls(me.emptyCls);
		}


		me.setRawValue(me.getDisplayValue());
		me.checkChange();

		//todo в EXTJS71 нет таких методов
		// if (doSelect !== false) {
		// 	me.syncSelection();
		// }
		//me.applyEmptyText();

		return me;
	},
	setKsReadOnly: function () {
		return false;
	}
});

/**
 * @class Keysystems.Controls.ListItemsPanel
 * @extends Ext.panel.Panel
 *
 * Shows a list of available group.
 *
 * @constructor
 * Create a new Feed Panel
 * @param {Object} config The config object
 */

Ext.define('Keysystems.Controls.ListItemsPanel', {
	extend: 'Ext.panel.Panel',

	alias: 'widget.listitemspanel',
	animCollapse: true,
	layout: 'fit',
	title: 'Группировка',
	actionPanel: null,

	initComponent: function () {
		this.items = this.createView();
		this.callParent(arguments);
	},

	/**
	 * Create the DataView to be used for the feed list.
	 * @private
	 * @return {Ext.view.View}
	 */
	createView: function () {
		return this.view = Ext.create('widget.dataview', {
			store: Ext.create('Ext.data.Store', {fields: ['title', 'url', 'cls'], data: this.feeds}),
			selModel: {mode: 'SINGLE', listeners: {scope: this, selectionchange: this.onSelectionChange}},
			listeners: {scope: this, viewready: this.onViewReady},
			trackOver: true,
			cls: 'feed-list',
			itemSelector: '.feed-list-item',
			overItemCls: 'feed-list-item-hover',
			tpl: '<tpl for="."><div class="feed-list-item {cls}">{title}</div></tpl>'
		});
	},

	onViewReady: function () {
		this.view.getSelectionModel().select(this.view.store.first());
	},


	/**
	 * Used when view selection changes so we can disable toolbar buttons.
	 * @private
	 */
	onSelectionChange: function () {
		var selected = this.getSelectedItem();
		if (selected) this.loadFeed(selected);
	},

	/**
	 * React to the load feed menu click.
	 * @private
	 */
	onLoadClick: function () {
		this.loadFeed(this.menu.activeFeed);
	},

	/**
	 * Loads a feed.
	 * @private
	 * @param {Ext.data.Model} rec The feed
	 */
	loadFeed: function (rec) {
		if (rec) this.fireEvent('itemselect', this, rec.get('url'));
	},

	/**
	 * Gets the currently selected record in the view.
	 * @private
	 * @return {Ext.data.Model} Returns the selected model. false if nothing is selected.
	 */
	getSelectedItem: function () {
		return this.view.getSelectionModel().getSelection()[0] || false;
	},


	/**
	 * React to a validation on a feed passing
	 * @private
	 * @param {FeedViewer.FeedWindow} win
	 * @param {String} title The title of the feed
	 * @param {String} url The url of the feed
	 */
	onFeedValid: function (win, title, url) {
		var view = this.view,
			store = view.store,
			rec;
		var match = store.find('url', url);
		if (match == -1) {
			rec = store.add({url: url, title: title, cls: 'feed-list-item'})[0];
			this.animateNode(view.getNode(rec), 0, 1);
		}
	},

	/**
	 * React to a validation on a feed passing
	 * @private
	 * @param {FeedViewer.FeedWindow} win
	 * @param {String} title The title of the feed
	 * @param {String} url The url of the feed
	 */
	onFeedValidNoAnim: function (win, title, url) {
		var view = this.view,
			store = view.store;

		var match = store.find('url', url);
		if (match == -1) store.add({url: url, title: title})[0];
	},

	/**
	 * Animate a node in the view when it is added/removed
	 * @private
	 * @param {Mixed} el The element to animate
	 * @param {Number} start The start opacity
	 * @param {Number} end The end opacity
	 * @param {Object} listeners (optional) Any listeners
	 */
	animateNode: function (el, start, end, listeners) {
		//todo extJS 71 - ошибка анимации - style undefined
		return;
		if (el == null) return;

		Ext.create('Ext.fx.Anim', {
			target: Ext.get(el),
			duration: 500,
			from: {opacity: start},
			to: {opacity: end},
			listeners: listeners
		});
	},

	// Inherit docs
	onDestroy: function () {
		this.callParent(arguments);
	}
});

Ext.define('Keysystems.grid.plugin.CalcRowEditing', {
	extend: 'Keysystems.grid.plugin.RowEditing',
	initEditor: function () {
		var me = this,
			cfg = me.initEditorConfig(),
			arr = ['getLaterData', 'getNestedData', 'getPersonData', 'getNewPersonData', 'setPersonData', 'setLaterData', 'setNestedData'];

		Ext.each(arr, function (key) {
			cfg[key] = me[key];
		});

		return Ext.create('Keysystems.grid.CalcRowEditor', cfg);
	}
});
Ext.define('Keysystems.grid.CalcRowEditor', {
	extend: 'Keysystems.grid.RowEditor',
	laterLink: -1,
	nestedLink: -1,
	defaultField: {
		xtype: 'displayfield',
		getModelData: function () {
			return null;
		}
	},
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.basicFormConfigs.push('findField', 'getValues');
		this.callParent(arguments);
	},
	loadRecord: function (record) {
		var me = this,
			form = me.getForm(),
			fields = form.getFields(),
			items = fields.items,
			length = items.length,
			i,
			displayFields,
			isValid;

		me.showCalcEditor(fields.items, record);

		for (i = 0; i < length; i++) {
			items[i].suspendEvents();
		}

		form.loadRecord(record);

		for (i = 0; i < length; i++) {
			items[i].resumeEvents();
		}

		isValid = form.isValid();
		if (me.errorSummary) {
			if (isValid) {
				me.hideToolTip();
			} else {
				me.showToolTip();
			}
		}

		me.updateGrids(record);

		displayFields = me.query('>displayfield');
		length = displayFields.length;

		for (i = 0; i < length; i++) {
			me.renderColumnData(displayFields[i], record);
		}
	},
	updateGrids: function (rec) {
		var me = this,
			showGrid = function (grid) {
				if (!me.floatingButtons.isVisible()) {
					var x = me.editingPlugin.grid.ownerCt.ownerCt.getX() + (me.editingPlugin.grid.getWidth() - 710) / 2;
					me.floatingButtons.show();
					me.floatingButtons.setX(x);
				} else me.floatingButtons.show();
				if (me.showGrid && me.showGrid != grid) {
					me.showGrid.hide();
				}
				me.showGrid = grid;
				grid.show();
			};
		if (rec.data.AUTOPERSON === null || rec.data.AUTOPERSON === '') {
			if (rec.data.LATER) {
				me.laterGrid.store.loadData(me.getLaterData(rec), false);
				showGrid(me.laterGrid);
			} else me.floatingButtons.hide();
		} else {
			if (rec.data.LATER) {
				var d = me.getNestedData(rec);
				me.nestedGrid.loadData(d.data);
				me.nestedGrid.normalGrid.editingPlugin.readOnly = me.isDefField(rec);
				me.nestedGrid.loadSubData(d.subData);
				me.nestedGrid.subPlugins[0].readOnly = rec.data.AUTOPERSON !== 0;
				showGrid(me.nestedGrid);
			} else {
				me.personGrid.store.loadData(me.getPersonData(rec), false);
				me.personGrid.editingPlugin.readOnly = rec.data.AUTOPERSON !== 0;
				showGrid(me.personGrid);
			}
		}
	},
	findField: function (id) {
		return this.getFields()
			.findBy(function (f) {
				return f.isVisible() && (f.id === id || f.getName() === id);
			});
	},
	showCalcEditor: function (fields, rec) {
		var me = this,
			iPos = ArrayLib.find(fields, ['name'], me.editingPlugin.calcField);
		if (iPos !== -1) {
			var column = fields[iPos].column,
				fieldContainer = column.isLocked() ? me.lockedColumnContainer : me.normalColumnContainer;

			me.addFieldsForColumn(column, true, rec);
			if (column.field.isNew) {
				fieldContainer.insert(column.getVisibleIndex(), column.getEditor());
				delete column.field.isNew;
			}
		}
	},
	isDefField: function (rec) {
		return (!rec || rec.data.FORMULA || !rec.data.TYPE || (rec.data.children && !rec.raw.tempChild) || (!rec.data.RECALC && rec.data.AUTOPERSON === 0));
	},
	createCalcColumnField: function (columnHeader, defaultField, rec) {
		var me = this,
			field,
			type = me.isDefField(rec) ? 'default' : rec.data.TYPE;
		if (columnHeader.fieldType === type) {
			field = columnHeader.field;
		} else {
			if (!columnHeader.fields) columnHeader.fields = {};
			field = columnHeader.fields[type];
			if (!field) field = me.getCfgEditor(type, defaultField);
			if (field) {
				if (field.isFormField) {
					field.column = columnHeader;
					field.show();
				} else {
					if (Ext.isString(field)) {
						field = {
							name: columnHeader.dataIndex,
							xtype: field,
							column: columnHeader
						};
					} else {
						field = Ext.apply({
							name: columnHeader.dataIndex,
							column: columnHeader
						}, field);
					}
					field = Ext.ComponentManager.create(field, me.defaultFieldXType);
					field.isNew = true;
				}
				columnHeader.fields[type] = field;
				columnHeader.field = field;
				var oldField = columnHeader.fields[columnHeader.fieldType];
				if (oldField) {
					oldField.hide();
				}
				columnHeader.fieldType = type;
			}
		}
		return field;
	},
	getCfgEditor: function (type, defaultField) {
		switch (type) {
			case 'Файл': //todo надо ли
				return defaultField;
			case 'Количество':
			case 'Сумма':
				return {
					xtype: 'numberfield',
					decimalPrecision: 4
				};
			case 'Дата':
				return {
					xtype: 'datefield',
					format: 'd.m.Y'
				};
			case 'Текст':
				return {xtype: 'textfield'};
			case 'Флаг':
				return {xtype: 'checkbox'};
			default:
				return defaultField;
		}
	},
	addFieldsForColumn: function (column, initial, rec) {
		var me = this,
			i,
			length,
			field,
			fn = function () {
				field.fieldStyle = 'text-align:' + column.align;
				field.setWidth(column.width - 2);
				if (column.xtype === 'actioncolumn') {
					field.fieldCls += ' ' + Ext.baseCSSPrefix + 'form-action-col-field';
				}

				if (me.isVisible() && me.context) {
					if (field.is('displayfield')) {
						me.renderColumnData(field, rec, column);
					} else {
						field.suspendEvents();
						field.setValue(rec.get(column.dataIndex));
						field.resumeEvents();
					}
				}
				if (column.hidden) {
					me.onColumnHide(column);
				} else if (column.rendered && !initial) {

					me.onColumnShow(column);
				}
			};

		if (Ext.isArray(column)) {
			for (i = 0, length = column.length; i < length; i++) {
				me.addFieldsForColumn(column[i], initial, rec);
			}
			return field;
		}

		if (column.dataIndex == me.editingPlugin.calcField) {
			field = me.createCalcColumnField(column, me.defaultField, rec);
			fn();
		} else {
			if (column.getEditor) {
				field = column.getEditor(null, me.defaultField);
				fn();
			}
		}
		return field;
	},
	getValues: function (asString, dirtyOnly, includeEmptyText, useDataValues) {
		var values = {},
			fields = this.getFields().items,
			f,
			fLen = fields.length,
			isArray = Ext.isArray,
			field,
			data,
			val,
			bucket,
			name;

		for (f = 0; f < fLen; f++) {
			field = fields[f];

			if (field.isVisible() && (field.column.ownerCt.grid === this.owner.initialConfig.view.ownerCt) && (!dirtyOnly || field.isDirty())) {
				data = field[useDataValues ? 'getModelData' : 'getSubmitData'](includeEmptyText);

				if (Ext.isObject(data)) {
					for (name in data) {
						if (data.hasOwnProperty(name)) {
							val = data[name];

							if (includeEmptyText && val === '') {
								val = field.emptyText || '';
							}

							if (values.hasOwnProperty(name)) {
								bucket = values[name];

								if (!isArray(bucket)) {
									bucket = values[name] = [bucket];
								}

								if (isArray(val)) {
									values[name] = bucket.concat(val);
								} else {
									bucket.push(val);
								}
							} else {
								values[name] = val;
							}
						}
					}
				}
			}
		}

		if (asString) {
			values = Ext.Object.toQueryString(values);
		}
		return values;
	},
	getRefItems: function () {
		var me = this,
			result;

		if (me.lockable) {
			result = me.lockedColumnContainer.getRefItems();
			result.push.apply(result, me.normalColumnContainer.getRefItems());
		} else {
			result = me.callParent();
		}
		result.push.apply(result, me.getFloatingButtons().getRefItems());
		return result;
	},
	getFloatingButtons: function () {
		var me = this,
			cssPrefix = Ext.baseCSSPrefix,
			laterColumns = [
				{
					text: 'Дата',
					dataIndex: 'DT',
					xtype: 'datecolumn',
					format: 'd.m.Y',
					flex: 8,
					editor: {
						xtype: 'datefield',
						listeners: {
							change: function (th, newV, oldV) {
								if (!th.rollBack) {
									var items = th.ownerCt.grid.store.data.items,
										i = 0,
										len = items.length;
									for (; i < len; i++) {
										if (th.isEqual(items[i].data.DT, newV)) {
											th.rollBack = true;
											th.setValue(oldV);
											th.rollBack = false;
											warning('Значение ' + (Ext.isDate(newV) ? newV.toLocaleDateString() : newV) + ' уже имеется.');
											return;
										}
									}
								}
							}
						}
					}
				},
				{text: 'Значение', dataIndex: 'VAL', flex: 3}
			],
			personColumns = [
				{text: 'Код', dataIndex: 'CODE', flex: 1},
				{text: 'ФИО', dataIndex: 'NAME', flex: 7},
				{text: 'Значение', dataIndex: 'VAL', flex: 3}
			],
			personFields = ['LINK', 'CODE', 'NAME', 'VAL', 'TYPE', 'LINK_SELF', 'S_PERSON'],
			laterFields = ['LINK', 'DT', 'VAL', 'TYPE'];
		if (!me.floatingButtons) {
			var config = {
				frame: true,
				shrinkWrap: true,
				hidden: true,
				position: 'bottom',
				baseCls: cssPrefix + 'grid-row-editor-buttons',
				uiCls: ['bottom'],
				setButtonPosition: function (position) {
					this.removeClsWithUI(this.position);
					this.position = position;
					this.addClsWithUI(position);
				},
				items: [
					me.personGrid = Ext.create('Ext.grid.Panel', {
						width: 700,
						hidden: true,
						border: 0,
						plugins: [Ext.create('Keysystems.grid.plugin.CalcCellEditing', {calcField: 'VAL'})],
						columnLines: true,
						columns: personColumns,
						store: Ext.create('Ext.data.Store', {
							fields: personFields,
							data: [],
							proxy: 'memory'
						})
					}),
					me.laterGrid = Ext.create('Ext.grid.Panel', {
						width: 700,
						hidden: true,
						border: 0,
						plugins: [
							Ext.create('Keysystems.grid.plugin.CalcCellEditing', {
								clicksToEdit: 1,
								calcField: 'VAL'
							})
						],
						columnLines: true,
						columns: laterColumns,
						store: Ext.create('Ext.data.Store', {
							fields: laterFields,
							data: [],
							sorters: 'DT',
							proxy: 'memory'
						}),
						tbar: [
							Ext.create('Ext.Button', {
								iconCls: 'x_btn_new',
								handler: function () {
									var checkFn = function (value) {
											var items = me.laterGrid.store.data.items,
												i = 0,
												len = items.length;
											for (; i < len; i++) {
												if (String(Ext.value(value, '')) === String(Ext.value(items[i].data.DT, ''))) {
													value.setDate(value.getDate() + 1);
													value = checkFn(value);
													break;
												}
											}
											return value;
										},
										date = checkFn(new Date(new Date().toDateString()));
									me.laterGrid.store.loadData([
										{
											DT: date,
											LINK: me.laterLink--,
											TYPE: me.context.record.data.TYPE,
											NEW: true
										}
									], true);
								}
							}),
							Ext.create('Ext.Button', {
								iconCls: 'x_btn_delete',
								handler: function () {
									var sels = me.laterGrid.getSelectionModel().getSelection();
									if (sels.length) {
										selectDialogShow('', wmc.get('DeleteMessage'), function () {
											me.laterGrid.getStore().remove(sels);
										});
									}
								}
							})
						]
					}),
					me.nestedGrid = Ext.create('Keysystems.Controls.NestedGrid', {
						width: 700,
						hidden: true,
						border: 0,
						//fields: laterFields,
						subGridFields: personFields,
						relationField: 'LINK',
						relationSubField: 'LINK_SELF',
						plugins: [Ext.create('Keysystems.grid.plugin.CalcCellEditing', {calcField: 'VAL'})],
						subPlugins: [Ext.create('Keysystems.grid.plugin.CalcCellEditing', {calcField: 'VAL'})],
						columns: laterColumns,
						subGridColumns: personColumns,
						sorters: 'DT',
						tbar: [
							Ext.create('Ext.Button', {
								iconCls: 'x_btn_new',
								handler: function () {
									var checkFn = function (value) {
											var items = me.nestedGrid.store.data.items,
												i = 0,
												len = items.length;
											for (; i < len; i++) {
												if (String(Ext.value(value, '')) === String(Ext.value(items[i].data.DT, ''))) {
													value.setDate(value.getDate() + 1);
													value = checkFn(value);
													break;
												}
											}
											return value;
										},
										date = checkFn(new Date(new Date().toDateString())),
										subData = me.getNewPersonData(me.context.record),
										j = 0,
										jLen = subData.length,
										newLink = me.nestedLink--;
									for (; j < jLen; j++) subData[j].LINK_SELF = newLink;
									me.nestedGrid.loadData([
										{
											DT: date,
											LINK: newLink,
											TYPE: me.context.record.data.TYPE,
											NEW: true
										}
									], true);
									me.nestedGrid.loadSubData(me.nestedGrid.subGridData.concat(subData));
								}
							}),
							Ext.create('Ext.Button', {
								iconCls: 'x_btn_delete',
								handler: function () {
									var sels = me.nestedGrid.getSelectionModel().getSelection();
									if (sels.length) {
										selectDialogShow(wmc.getQuestion('Delete'), wmc.get('DeleteMessage', sels.length), function () {
											me.nestedGrid.getStore().remove(sels);
										});
									}
								}
							}),
							{xtype: 'tbseparator'},
							Ext.create('Ext.Button', {
								iconCls: 'x_btn_treeexpand',
								handler: function () {
									me.nestedGrid.expandAll();
								}
							}),
							Ext.create('Ext.Button', {
								iconCls: 'x_btn_treecollapse',
								handler: function () {
									me.nestedGrid.collapseAll();
								}
							})
						]
					})
				]
			};
			me.nestedGrid.setFields(laterFields);
			me.floatingButtons = Ext.create('Ext.container.Container', config);
		}
		return me.floatingButtons;
	},
	getLaterData: function () {
		return [];
	},
	getPersonData: function () {
		return [];
	},
	getNewPersonData: function () {
		return [];
	},
	getNestedData: function () {
		return {
			data: [],
			subData: []
		};
	},
	completeEdit: function () {
		var me = this,
			rec = me.context.record;
		me.callParent(arguments);
		if (rec.data.AUTOPERSON === null || rec.data.AUTOPERSON === '') {
			if (rec.data.LATER) {
				me.setLaterData(me.laterGrid.store.data.items, rec);
			}
		} else {
			if (rec.data.LATER) {
				me.setNestedData(me.nestedGrid.store.data.items, me.nestedGrid.subGridData, rec);
			} else {
				me.setPersonData(me.personGrid.store.data.items, rec);
			}
		}
	},
	isDirty: function () {
		var me = this,
			isSubDirty = function () {
				var rec = me.context.record,
					items,
					i,
					len;
				if (rec.data.AUTOPERSON === null || rec.data.AUTOPERSON === '') {
					if (rec.data.LATER) {
						for (items = me.laterGrid.store.data.items, i = 0, len = items.length; i < len; i++) {
							if (items[i].dirty || items[i].raw.NEW) {
								return true;
							}
						}
					} else {
						return false;
					}
				} else {
					if (rec.data.LATER) {
						for (items = me.nestedGrid.store.data.items, i = 0, len = items.length; i < len; i++) {
							if (items[i].dirty || items[i].raw.NEW) {
								return true;
							}
						}
						for (items = me.nestedGrid.subGridData, i = 0, len = items.length; i < len; i++) {
							if (items[i].dirty) {
								return true;
							}
						}
					} else {
						for (items = me.personGrid.store.data.items, i = 0, len = items.length; i < len; i++) {
							if (items[i].dirty) {
								return true;
							}
						}
					}
				}
				return false;
			};
		return me.callParent() || isSubDirty();
	},
	setPersonData: function () {
	},
	setLaterData: function () {
	},
	setNestedData: function () {
	}
});


Ext.define('Keysystems.grid.plugin.CalcCellEditing', {
	extend: 'Ext.grid.plugin.CellEditing',
	alias: ['widget.calccellediting'],
	config: {
		clicksToEdit: 1,
		calcField: 'VAL'
	},
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initFieldAccessors: function (columns) {
		if (columns.isGroupHeader) {
			columns = columns.getGridColumns();
		} else if (!Ext.isArray(columns)) {
			columns = [columns];
		}

		var me = this,
			c,
			cLen = columns.length,
			column;

		for (c = 0; c < cLen; c++) {
			column = columns[c];

			if (!column.getEditor) {
				column.getEditor = function (record, defaultField) {
					return me.getColumnField(this, defaultField);
				};
			}
			if (!column.hasEditor) {
				column.hasEditor = function () {
					return me.hasColumnField(this);
				};
			}
			if (!column.setEditor) {
				column.setEditor = function (field) {
					me.setColumnField(this, field);
				};
			}
		}

		c = ArrayLib.find(columns, ['dataIndex'], me.calcField);

		if (c !== -1) {
			c = columns[c];
			c.fields = {};
			c.getEditor = function (rec, defaultField) {
				return me.getCalcColumnField(this, defaultField, rec);
			};
			if (!c.hasEditor) {
				c.hasEditor = function () {
					return me.hasColumnField(this);
				};
			}
			if (!c.setEditor) {
				c.setEditor = function (field) {
					me.setColumnField(this, field);
				};
			}
		}
	},
	getCalcColumnField: function (columnHeader, defaultField, rec) {
		return columnHeader.field = this.createCalcColumnField(columnHeader, defaultField, rec);
	},
	createCalcColumnField: function (columnHeader, defaultField, rec) {
		var field = columnHeader.fields[rec.data.TYPE];
		columnHeader.fieldType = rec.data.TYPE;
		if (!field) field = this.getCfgEditor(rec.data.TYPE);
		if ((!field && defaultField) || this.readOnly) field = defaultField;

		if (field) {
			if (field.isFormField) {
				field.column = columnHeader;
			} else {
				if (Ext.isString(field)) {
					field = {
						name: columnHeader.dataIndex,
						xtype: field,
						column: columnHeader
					};
				} else {
					field = Ext.apply({
						name: columnHeader.dataIndex,
						column: columnHeader
					}, field);
				}
				field = Ext.ComponentManager.create(field, this.defaultFieldXType);
				columnHeader.fields[rec.data.TYPE] = field;
			}
			columnHeader.field = field;
		}
		return field;
	},
	getCfgEditor: function (type) {
		switch (type) {
			case 'Количество':
			case 'Сумма':
				return {xtype: 'numberfield'};
			case 'Дата':
				return {xtype: 'datefield'};
			case 'Текст':
				return {xtype: 'textfield'};
			case 'Флаг':
				return {xtype: 'checkbox'};
			default:
				return undefined;
		}
	},
	getEditor: function (record, column) {
		var me = this,
			editors = me.editors,
			editorId = column.getItemId(),
			editor = editors.getByKey(editorId),

			editorOwner = me.grid.ownerLockable || me.grid;

		if (!editor || column.dataIndex == me.calcField) {
			editor = column.getEditor(record);
			if (!editor) {
				return false;
			}


			if (editor instanceof Ext.grid.CellEditor) {
				editor.floating = true;
			} else {
				editor = new Ext.grid.CellEditor({
					floating: true,
					editorId: editorId,
					field: editor
				});
			}

			editorOwner.add(editor);
			editor.on({
				scope: me,
				specialkey: me.onSpecialKey,
				complete: me.onEditComplete,
				canceledit: me.cancelEdit
			});
			column.on('removed', me.cancelActiveEdit, me);
			editors.add(editor);
		}

		if (column.isTreeColumn) {
			editor.isForTree = column.isTreeColumn;
			editor.addCls(Ext.baseCSSPrefix + 'tree-cell-editor');
		}
		editor.grid = me.grid;


		editor.editingPlugin = me;
		return editor;
	}
});

//в checkchange добавлена передача самой строки, а не только её индекс
Ext.define('Keysystems.grid.column.CheckColumnExtra', {
	extend: 'Ext.grid.column.Check',
	alias: ['widget.checkcolumnextra'],
	processEvent: function (type, view, cell, recordIndex, cellIndex, e, record, row) {
		var me = this,
			key = type === 'keydown' && e.getKey(),
			//в extjs71 глюки с установкой чека при условии type == 'mousedown'
			mousedown = false;//type == 'mousedown'

		if (!me.disabled && (type === 'ksEvent' || mousedown || (key == e.ENTER || key == e.SPACE))) {
			var dataIndex = me.dataIndex,
				checked = !record.get(dataIndex);

			if (me.fireEvent('beforecheckchange', me, recordIndex, checked, record) !== false) {
				if (me.readOnly) return false;

				record.set(dataIndex, checked);
				me.fireEvent('checkchange', me, recordIndex, checked, record);

				if (mousedown) e.stopEvent();

				if (!me.stopSelection) {
					view.selModel.selectByPosition({
						row: recordIndex,
						column: cellIndex
					});
				}

				return false;
			} else {
				return !me.stopSelection;
			}
		} else {
			return me.callParent(arguments);
		}
	},

	renderer: function (val, meta, rec) {
		var v;
		if (this.checkRenderer) {
			v = this.checkRenderer(val, meta, rec);
		}
		if (v !== undefined) return v;
		return this.defaultRenderer ? this.callParent(arguments, this.defaultRenderer) : val;
	},
	listeners: {
		beforecheckchange: function() {
			return !this.readOnly;
		}
	}
});

//Колона RowNumber смотрит на Page
Ext.define('Keysystems.grid.column.RowNumberPage', {
	extend: 'Ext.grid.RowNumberer',
	alias: ['widget.RowNumberPage'],
	renderer: function (v, p, record, rowIndex) {
		if (this.rowspan) {
			p.cellAttr = 'rowspan="' + this.rowspan + '"';
		}
		var st = record.store;

		if (st.currentPage != undefined && st.pageSize != undefined) {
			var fromRecord = ((st.currentPage - 1) * st.pageSize);
			if (fromRecord < 0) fromRecord = 0;
			return fromRecord + rowIndex + 1;
		} else {
			return rowIndex + 1;
		}
	}
});


Ext.define('Keysystems.SVarParam.List', {
	extend: 'Keysystems.Base.List',
	columnsAdapted: function (columns) {
		var me = this;
		Ext.each(columns, function (column) {
			column.renderer = function (val, metaData, record) {
				return record.get('BASE') ? '<span style="font-weight:bold;">' + rendererCell(val, metaData, record) + '</span>' : rendererCell(val, metaData, record);
			};
		});
		columns = me.callParent(arguments);
		return columns;
	}
});

Ext.define('Keysystems.STypeOrg.List', {
	extend: 'Keysystems.Base.List',
	canEdit: function(rec){
		if ([1, 2, 3, 4].indexOf((rec.data || rec).LINK) >= 0)
			return false;
		return this.callParent(arguments);
	},
});

Ext.define('Keysystems.toolbar.Paging', {
	extend: 'Ext.toolbar.Paging',
	pageSizeText: 'Размер страницы',
	dock: 'bottom',
	displayInfo: true,
	reload: false,
	config: {
		pageSizeOnChange: null
	},
	initComponent: function () {
		this.plugins = Ext.create('Ext.ux.ProgressBarPager', {defaultText : ''});
		this.callParent(arguments);
	},
	setPageSize: function (pageSize) {
		this.pageSizeNumberField.setValue(pageSize);
	},
	setMaxPageSize: function (pageSize) {
		this.pageSizeNumberField.setMaxValue(pageSize);
	},
	getPagingItems: function () {
		var me = this,
			items = me.callParent();

		Ext.each(items, function (el) {
			if (el && (typeof el === 'object')) {
				el.tooltipType = 'title';
			}
		});

		items.push(me.pageSizeNumberField = Ext.create('Ext.form.field.Number', {
			tooltip: me.pageSizeText,
			overflowText: me.pageSizeText,
			width: 100,
			value: me.pageSize,
			maxValue: me.pageSize.maxPageSize,
			minValue: 0,
			listeners: {
				change: {
					fn: function (th, newValue) {
						if (!newValue || newValue > this.maxValue) return 0;

						me.store.pageSize = newValue;
						me.pageSize = newValue;
						//me.reload = true;
						if (me.pageSizeOnChange) me.pageSizeOnChange.call(me, newValue);
						
						me.doRefresh();
					},
					buffer: 500
				},
				blur: function (th) {
					let newValue = th.getValue();
					if (!newValue || newValue > this.maxValue) {
						th.setValue(this.maxValue);
					}
				}
			}
		}));

		return items;
	},
	getPageData: function () {
		var store = this.store,
			totalCount = store.getTotalCount(),
			fromRecord = ((store.currentPage - 1) * store.pageSize) + 1;
		if (fromRecord < 0) fromRecord = 0;
		return {
			total: totalCount,
			currentPage: store.currentPage,
			pageCount: Math.ceil(totalCount / store.pageSize),
			fromRecord: fromRecord,
			toRecord: Math.min(store.currentPage * store.pageSize, totalCount)
		};
	},
	//взято с исходников extjs. изменено определение кол-ва записей в store и отображение label
	//исправлено: если на store наложен фильтр, то отображение контрола ломается вне зависимости от истинного кол-ва записей
	onLoad: function() {
		var me = this,
			pageData, currPage, pageCount, afterText, count, isEmpty, item;
		count = me.store.getDataExt().length; //me.store.getCount();
		isEmpty = count === 0;
		if (!isEmpty) {
			pageData = me.getPageData();
			currPage = pageData.currentPage;
			pageCount = pageData.pageCount;
			// Check for invalid current page.
			if (currPage > pageCount) {
				// If the surrent page is beyond the loaded end,
				// jump back to the loaded end if there is a valid page count.
				if (pageCount > 0) {
					me.store.loadPage(pageCount);
				} else // If no pages, reset the page field.
				{
					me.getInputItem().reset();
				}
				return;
			}
			afterText = Ext.String.format(me.afterPageText, isNaN(pageCount) ? 1 : pageCount);
		} else {
			currPage = 0;
			pageCount = 0;
			afterText = Ext.String.format(me.afterPageText, 0);
		}
		Ext.suspendLayouts();
		item = me.child('#afterTextItem');
		if (item) {
			item.update(afterText);
		}
		item = me.getInputItem();
		if (item) {
			item.setDisabled(isEmpty).setValue(currPage);
		}
		me.setChildDisabled('#first', currPage === 1 || isEmpty);
		me.setChildDisabled('#prev', currPage === 1 || isEmpty);
		me.setChildDisabled('#next', currPage === pageCount || isEmpty);
		me.setChildDisabled('#last', currPage === pageCount || isEmpty);
		me.setChildDisabled('#refresh', false);
		
		//закомментировано
		//me.updateInfo();

		//добавлено
		const a = this.getPageData();
		const c = count===0 ? this.emptyMsg : Ext.String.format(this.displayMsg,a.fromRecord,a.toRecord,this.store.getTotalCount()),b=a.pageCount>0?(a.currentPage/a.pageCount):0;
		this.displayItem.updateProgress(b,c,this.animate||this.defaultAnimConfig);
		
		Ext.resumeLayouts(true);
		if (!me.calledInternal) {
			me.fireEvent('change', me, pageData || me.emptyPageData);
		}
	}	
});

Ext.define('Keysystems.CheckMsg', {
	extend: 'Ext.window.Window',
	bodyPadding: 10,
	height: 400,
	width: 400,
	maximizable: true,
	modal: true,
	iconCls: 'x_btn_keysystems',
	title: 'Контроль показателей',
	initComponent: function () {
		var me = this,
			next = (me.isNext && me.nextFn);
		me.html = '<span style="color:red; font-weight:bold">В значениях показателей обнаружены ошибки!</span><br><br>' + me.msg;
		me.buttons = [
			Ext.create('Ext.Button', {
				text: 'Продолжить',
				hidden: !next,
				handler: function () {
					KsLib.tryRun(me.nextFn, me);
					me.close();
				}
			}),
			Ext.create('Ext.Button', {
				text: next ? 'Отмена' : 'Закрыть',
				handler: function () {
					me.close();
				}
			})
		];
		me.callParent(arguments);
	}
});

Ext.define('Keysystems.ux.TabCloseMenu', {
	extend: 'Ext.ux.TabCloseMenu',
	veryPanelCount: 20,
	doClose: function () {
		var me = this,
			superMethod = me.superclass.doClose,
			len = me.tabPanel.items.length;
		if (len > me.veryPanelCount) {
			selectDialogShow(wmc.get('Attention'), wmc.get('VeryPanelClose', len), function () {
				superMethod.apply(me);
			});
		} else {
			me.callParent(arguments);
		}
	}
});


Ext.define('Keysystems.form.field.VTypes', {
	pin: /(?!(.)\1\1).{3}/,
	digits: /[0-9]+$/,

	init: function () {
		var me = this;

		//pin number
		this.pinFn();
		//only digits
		this.digitsFn();
		//etc..
		this.checkLengthINNFn(); //Длина
		this.checkFormatINNFn(); //Формат INN
		this.checkLengthKppFn(); //Длина
		this.checkFormatKppFn(); //Формат КПП
		this.checkLengthOGRNFn(); //Длина
		this.checkFormatOGRNFn(); //Формат ОГРН
	},
	pinFn: function () {
		var me = this;

		Ext.apply(Ext.form.field.VTypes, {
			pin: function (val, field) {
				//check value
				return me.pin.test(val);
			},
			pinText: 'Символы не должны быть идентичными'
		});
	},
	digitsFn: function () {
		var me = this;

		Ext.apply(Ext.form.field.VTypes, {
			digits: function (val, field) {
				//check value
				return me.digits.test(val);
			},
			digitsText: 'Разрешены только цифры'
		});
	},
	checkLengthINNFn: function () {
		Ext.apply(Ext.form.field.VTypes, {
			LenINN: function (val, field) {
				//check value
				return val.length == 10 || val.length == 12;
			},
			LenINNText: 'Введённый ИНН является не полным'
		});
	},
	checkFormatINNFn: function () {
		Ext.apply(Ext.form.field.VTypes, {
			FormatINN: function (value, field) {
				//check value
				// проверка по контрольным цифрам
				if (value.length == 10) {
					var dgt10 = String(((
						2 * value[0] +
						4 * value[1] +
						10 * value[2] +
						3 * value[3] +
						5 * value[4] +
						9 * value[5] +
						4 * value[6] +
						6 * value[7] +
						8 * value[8]) %
						11) %
						10);
					if (value[9] == dgt10) {

						return true;
					} else {
						//alert("Введённый ИНН не прошёл проверку по контрольным цифрам");
						return true;
					}
				}
				if (value.length == 12) {
					var dgt11 = String(((
						7 * value[0] +
						2 * value[1] +
						4 * value[2] +
						10 * value[3] +
						3 * value[4] +
						5 * value[5] +
						9 * value[6] +
						4 * value[7] +
						6 * value[8] +
						8 * value[9]) %
						11) %
						10);
					var dgt12 = String(((
						3 * value[0] +
						7 * value[1] +
						2 * value[2] +
						4 * value[3] +
						10 * value[4] +
						3 * value[5] +
						5 * value[6] +
						9 * value[7] +
						4 * value[8] +
						6 * value[9] +
						8 * value[10]) %
						11) %
						10);
					if (value[10] == dgt11 && value[11] == dgt12) {
						return true;
					} else {
						//alert("Введённый ИНН не прошёл проверку по контрольным цифрам");
						return false;
					}
				}
			},
			FormatINNText: 'Введённый ИНН не прошёл проверку по контрольным цифрам'
		});
	},

	checkLengthKppFn: function () {
		Ext.apply(Ext.form.field.VTypes, {
			LenKpp: function (val, field) {
				//check value
				return val.length >= 9;
			},
			LenKppText: 'КПП должен представлять собой девятизначный код'
		});
	},
	checkFormatKppFn: function () {
		Ext.apply(Ext.form.field.VTypes, {
			FormatKpp: function (val, field) {
				//check value
				return val.match(/\d{4}[\dA-Z][\dA-Z]\d{3}/);
			},
			FormatKppText: 'КПП не соответствует формату'
		});
	},

	checkLengthOGRNFn: function () {
		Ext.apply(Ext.form.field.VTypes, {
			LenOGRN: function (val, field) {
				//check value
				return val.length == 13 || val.length == 15;
			},
			LenOGRNText: 'Введённый ОГРН является не полным'
		});
	},
	checkFormatOGRNFn: function () {
		Ext.apply(Ext.form.field.VTypes, {
			FormatOGRN: function (value, field) {
				//check value
				// проверка по контрольным цифрам
				if (value.length == 13) {
					// проверка по контрольным цифрам
					var num12 = value;
					num12 = Math.floor((num12 / 10) % 11);
					if (num12 == 10) {
						dgt13 = 0;
					} else {
						dgt13 = num12;
					}
					if (value[12] == dgt13) {
						return true;
					} else {
						//alert("Введённый ОГРН не прошёл проверку по контрольным цифрам");
						return false;
					}
				}
				// проверка ОГРН для ИП
				if (value.length == 15) {
					// проверка по контрольным цифрам
					var num14 = value;
					num14 = Math.floor((num14 / 10) % 13);
					var dgt15 = num14 % 10;
					if (value[14] == dgt15) {
						return true;
					} else {
						//alert("Введённый ОГРН не прошёл проверку по контрольным цифрам");
						return false;
					}
				}
			},
			FormatOGRNText: 'Введённый ОГРН не прошёл проверку по контрольным цифрам'
		});
	}	
});

Ext.create('Keysystems.form.field.VTypes').init();

Ext.define('Keysystems.form.field.override.Text', {
	override: 'Ext.form.field.Text',

	getErrors: function (value) {
		var me = this,
			errors = me.callSuper(arguments),
			validator = me.validator,
			vtype = me.vtype,
			vtypes = Ext.form.field.VTypes,
			regex = me.regex,
			format = Ext.String.format,
			msg,
			trimmed,
			isBlank;

		value = value || me.processRawValue(me.getRawValue());

		if (Ext.isFunction(validator)) {
			msg = validator.call(me, value);
			if (msg !== true) {
				errors.push(msg);
			}
		}

		trimmed = me.allowOnlyWhitespace ? value : Ext.String.trim(value);

		if (trimmed.length < 1 || (value === me.emptyText && me.valueContainsPlaceholder)) {
			if (!me.allowBlank) {
				errors.push(me.blankText);
			}
			// If we are not igigured to validate blank values, there cannot be any additional errors
			if (!me.validateBlank) {
				return errors;
			}
			isBlank = true;
		}

		// If a blank value has been allowed through, then exempt it dfrom the minLength check.
		// It must be allowed to hit the vtype validation.
		if (!isBlank && value.length < me.minLength) {
			errors.push(format(me.minLengthText, me.minLength));
		}
		if (value.length > me.maxLength) {
			errors.push(format(me.maxLengthText, me.maxLength));
		}

		switch (typeof vtype) {
			case 'string':
				if (!vtypes[vtype](value, me)) {
					errors.push(me.vtypeText || vtypes[vtype + 'Text']);
				}
				break;
			case 'object':
				Ext.Array.each(vtype, function (v) {
					if (!vtypes[v](value, me)) {
						errors.push(me.vtypeText || vtypes[v + 'Text']);
					}
				});
				break;
		}

		if (regex && !regex.test(value)) {
			errors.push(me.regexText || me.invalidText);
		}

		return errors;
	}
});

Ext.define('Keysystems.grid.column.Misc', {
	extend: 'Ext.grid.column.Column',
	alias: ['widget.misccolumn'],
	alternateClassName: 'Keysystems.grid.MiscColumn',
	defaultRenderer: function (v) {
		if (miscTypes && miscTypes[this.typeName]) {
			if (this.typeName === "FinancStatus" && v === 0) {
				return 'Неизвестно';
			}
			
			return miscTypes[this.typeName][v];
		}
		return v;
	}
});

Ext.define('Keysystems.grid.column.Decimal', {
	extend: 'Ext.grid.column.Column',
	alias: ['widget.decimalcolumn'],
	alternateClassName: 'Keysystems.grid.DecimalColumn',
	defaultRenderer: function (v) {
		if (v === null) {
			return v;
		}
		
		var me = this;
		return convertToDecimal(v, me.decimalData);
	}
});

Ext.define('Keysystems.ChangePass', {
	extend: 'Ext.window.Window',
	lowerEng: RegExp('^(?=.*[a-z])', 'g'),
	upperEng: RegExp('^(?=.*[A-Z])', 'g'),
	lowerRus: RegExp('^(?=.*[а-я])', 'g'),
	upperRus: RegExp('^(?=.*[А-Я])', 'g'),
	numbers: RegExp('^(?=.*[0-9_-])', 'g'),

	title: 'Смена пароля',
	resizable: false,
	draggable: false,
	closable: false,
	modal: true,
	autoShow: true,
	width: 300,
	newPwdChanged: false,
	confirmPwdChanged: false,
	minLength: 6,
	checkStrength: false,
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function () {
		var me = this;
		
		me.items = [
			{
				xtype: 'panel',
				border: 0,
				padding: '10 10 0 10',
				margin: 0,
				defaultType: 'label',
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				items: [
			me.oldPass = Ext.create('Ext.form.field.Text', {
				emptyText: 'Старый пароль',
				inputType: 'password',
				msgTarget: 'side',
			}),
			me.newPass = Ext.create('Ext.form.field.Text', {
				emptyText: 'Новый пароль',
				name: 'newPass',
				id: 'newPass',
				inputType: 'password',
				msgTarget: 'side',
				toolTip: 'title',
				initialPassField: 'confirmPass',
						validateOnChange: false,
						validator() {
							const psw = this.getValue();
							if (psw.length < me.minLength) 
								return Ext.String.format(KS.L10n.ChangePassword_password_min_length, me.minLength);
							if (me.checkStrength && !me.checkPasswordStrength(psw, 3))
								return KS.L10n.ChangePassword_strengthPasswordWarning ?? 'Пароль не удовлетворяет политике сложности';
							
							if (!me.confirmPwdChanged) return true;
							const pswRepeat = me.confirmPass.getValue();
							if (psw !== pswRepeat) return  KS.L10n.ChangePassword_passwords_not_equals;							
							return true;
						},
				listeners:
					{
						render: function () {
							me.toolTip = Ext.create('Ext.tip.ToolTip', {
								target: 'newPass',
								trackMouse: true,
								shadow: false
							});
							me.toolTip.disable();
						},
						change: function (th, val) {
									me.newPwdChanged = true;
									if (me.confirmPwdChanged)
										me.checkNewPassword();
								},
									}
			}),
			me.confirmPass = Ext.create('Ext.form.field.Text', {
				emptyText: 'Подтвердите пароль',
				name: 'confirmPass',
				id: 'confirmPass',
				inputType: 'password',
				msgTarget: 'side',
				toolTip: 'title',
				initialPassField: 'newPass',
						validateOnChange: false,
						validator() {
							if (!me.newPwdChanged) return true;
							const psw = this.getValue();
							const pswRepeat = me.confirmPass.getValue();
							return psw !== pswRepeat ? KS.L10n.ChangePassword_passwords_not_equals : true;
						},
				listeners: {
					render: function () {
						me.toolTip1 = Ext.create('Ext.tip.ToolTip', {
							target: 'confirmPass',
							trackMouse: true,
							shadow: false
						});
						me.toolTip1.disable();
					},
					change: function (th, val) {
								me.confirmPwdChanged = true;
								me.newPass.validate();
								if (me.newPwdChanged)
									me.checkNewPassword();
						}
					}
			})
				]
			}];
		me.buttons = [
			me.confirmBtn = Ext.create('Ext.Button', {
				text: 'OK',
				handler: function () {
					const validationResult = me.newPass.validator();
					if (validationResult === true) {
						me.ConfirmPass(me.oldPass.value, me.newPass.value, me.confirmPass.value);
					}
					else{
						me.newPass.validate();
				}
				}
			}),
			me.cnclBtn = Ext.create('Ext.Button', {
				text: 'Отмена',
				handler: function () {
					this.up('window').close();
				}
			})
		];
		me.callParent(arguments);

		ajaxRequest({
			url: '/Home/GetPasswordCharacteristics_A',
			params: {needResource: !KS.L10n.ChangePassword_strengthPasswordWarning},
			success: function (result) {
				me.minLength = result.minLength;
				me.checkStrength = result.checkStrength;
				if (result.resource){
					Ext.apply(KS.L10n, result.resource);
				}
			}
		});
	},
	ConfirmPass: function () {
		const me = this;
			me.fingerprint = new Fingerprint({screen_resolution: true}).get();
		if (!me.oldPass.isHidden()) {
				ajaxRequest({
					url: '/Home/ChangePassword_A',
					params: {
						rid: '',
						login: Ext.util.Cookies.get('Login'),
					oldPassword: me.oldPass.value,
					newPassword: me.newPass.value,
					hawOldPassword: true,
						tokien: Ext.util.Cookies.get('tokien'),
						clientID: me.fingerprint
					},
					success: function (result) {
					if (!result.result) {
							if (result.errorMsg) {
							showError(result.errorMsg.replace('#ERR#', ''), function () {
									window.render();
								});
							}
						} else {
						info(KS.L10n.ChangePassword_password_change_success);
							me.close();
						}
					}
				});
			} else {
				ajaxRequest({
					url: '/Home/ChangePassword_A',
					params: {
						rid: '',
						login: Ext.util.Cookies.get('Login'),
					newPassword: me.newPass.value,
						tokien: Ext.util.Cookies.get('tokien'),
						clientID: me.fingerprint
					},
					success: function (result) {
						if (!result.result) { // результат проверки старого поля на сервере
							if (result.errorMsg) {
								showError(result.errorMsg, function () {
									window.render();
								});
							}
						} else {
						info(KS.L10n.ChangePassword_password_change_success);
							me.close();
						}
					}
				});
			}
	},
	hideOldPassword: function(){
		const me = this;
		me.oldPass.hide();
	},
	checkPasswordStrength: function (val, strength){
		const me = this;
		let pwdStrength = 0;

		//прописные англ
		if (me.lowerEng.test(val))
			pwdStrength++;
		//строчные англ
		if (me.upperEng.test(val))
			pwdStrength++;
		//цифры
		if (me.numbers.test(val))
			pwdStrength++;
		//неалфавитные символы
		if (/[^a-zA-Z0-9]+/.test(val))
			pwdStrength++;
		
		if (strength < 0) strength = 0;
		if (strength > 4) strength = 4;
		return pwdStrength >= strength;
	},
	checkNewPassword: function(){
		const me = this;
		const input = me.newPass.triggerWrap;
		const valid = me.confirmPass.getValue() === me.newPass.getValue();

		input.removeCls('ks-bad-pass');

		if (valid) {
			me.toolTip1.disable();
		} else {
			me.toolTip1.enable();
			me.toolTip1.update(KS.L10n.ChangePassword_passwords_not_equals);
			input.addCls('ks-bad-pass');
		}
	}
});

Ext.define('Keysystems.grid.column.Dict', {
	extend: 'Ext.grid.column.Column',
	alias: ['widget.dictcolumn'],
	alternateClassName: 'Keysystems.grid.DictColumn',
	fieldName: 'NAME',
	fieldCode: 'CODE',
	fieldLink: 'LINK',
	ignoreCodeField: false,
	cleaningKey: true,
	defaultRenderer: function (v, meta, rec) {
		var me = this,
			di = me.dataIndex + '_',
			res = '',
			val = rec.get(di + me.fieldCode);
		if (val && !me.ignoreCodeField) res += val;
		val = rec.get(di + me.fieldName);
		if (val) {
			if (res) res += '. ';
			res += val;
		}
		return res;
	},
	getEditor: function (rec, defaultField) {
		var me = this,
			editor = me.grid ? me.grid.editingPlugin.getColumnField(me, defaultField) : me.editor;

		if (rec) editor.editRecord = rec; // При редактировании пустой(новой) записи, метод запускается дважды,второй раз в editor.editRecord ставится undefined

		return editor;
	},
	getRootHeader: function () {
		var me = this,
			owner = me.ownerCt || me.isContained;
		return owner ? owner.isRootHeader ? owner : me.getRootHeader.call(owner) : _;
	},
	initEditor: function () {
		var me = this,
			editor = me.editor || (me.editor = Ext.create({
				xtype: 'triggerdict',
				cleaningKey: me.cleaningKey,
				dataIndex: me.dataIndex
			}));

		if (!editor.defaultRenderer) editor.defaultRenderer = me.defaultRenderer.bind(me);
		if (!editor.trgClick) {
			editor.trgClick = editor.handler ||
				(
					editor.handler = function () {
						var c = editor,
							contextSearch = editor.contextSearch;
						me.beforeHandler(function () {
							dictFunc({
								mode: me.mode || 'SINGL',
								parentView: me.grid,
								mainColumn: me.mainColumn,
								selectLinks: (me.ksGetValue || me.getValue).call(me, c.editRecord),								
								inputDicts: me.getInputDicts(c.editRecord),
								whereArgs: me.initWhereArgs(c.editRecord),
								disallowedToCheckLinks: me.disallowedToCheckLinks,
								code: me.code,
								readOnly: me.readOnly,
								accessReadOnly: me.readOnly,
								control: editor,
								contextSearch: contextSearch
							}, {
								ok: function (value) {
									(me.ksSetValue || me.setValue).call(me, value, c.editRecord);
									//c.setValue(value[0] ? (value[0].data || value[0])[me.fieldLink] : 0);
								},
								close: me.closeFn
							});
						}, c.editRecord, c);
					});
		}
	},
	setValue: function (v, rec) {
		var me = this,
			d = v[0];
		d = d ? d.data || d : _;
		var link = d && d[me.fieldLink] || 0,
			code = d && d[me.fieldCode] || '',
			name = window.getTextByVisibleFields(me.code || me.Code, me.visibleFields, d, me.fieldName);
		rec.beginEdit();

		if (!me.ignoreCodeField) {
			rec.set(me.dataIndex + '_' + me.fieldCode, code);
		}

		rec.set(me.dataIndex + '_' + me.fieldName, name);
		rec.set(me.dataIndex, link);
		rec.endEdit();
	},
	getValue: function (rec) {
		var me = this,
			o = {};
		o[me.fieldLink] = rec.get(me.dataIndex);

		if (!me.ignoreCodeField) {
			o[me.fieldCode] = rec.get(me.dataIndex + '_' + me.fieldCode);
		}

		o[me.fieldName] = rec.get(me.dataIndex + '_' + me.fieldName);
		return [o];
	},
	initComponent: function () {
		var me = this;

		me.initEditor();

		me.callParent(arguments);

		var rh = me.getRootHeader();
		me.grid = rh ? rh.grid : _;
	},
	initWhereArgs: function () {
		return this.whereArgs;
	},
	getInputDicts: function () {
		return this.inputDicts;
	},
	beforeHandler: function (callback) {
		KsLib.tryRun(callback);
	}
});
Ext.define('Keysystems.form.field.Trigger.Dict', {
	extend: 'Ext.form.field.Text',
	alias: ['widget.triggerdict'],
	editable: false,
	cleaningKey: true,
	enableKeyEvents: true,
	triggers: {
		dict: {
			cls: 'x_btn_dict x-dict-trigger',
			handler: function () {
				if (this.trgClick) this.trgClick();
			}
		}
	},
	trgClick: null,
	delKeys: [
		Ext.EventObjectImpl.prototype.BACKSPACE,
		Ext.EventObjectImpl.prototype.DELETE,
		Ext.EventObjectImpl.prototype.LEFT,
		Ext.EventObjectImpl.prototype.HOME,
		Ext.EventObjectImpl.prototype.RIGHT,
		Ext.EventObjectImpl.prototype.END
	],
	initComponent: function () {
		var me = this;
		if (me.cleaningKey) {
			me.editable = true;
			let contextFn = function() {
				if (me.value !== me.originalValue) {
					if (me.trgClick) {
						if (!me.denyFind && !me.readOnly) {
							me.contextSearch = me.value;
						}
						me.trgClick();
						delete me.contextSearch;
					}
				}
			};
			me.on('keydown', function (th, e) {
				if (e.ENTER === e.getKey()) {
					contextFn();
				}
			});
			me.on('blur', function () {
				if (me.value !== me.originalValue && !me.value.trim().length) {
					if (me.ownerCt?.column?.ksSetValue && me.editRecord) {
						me.ownerCt.column.ksSetValue([], me.editRecord);
					} else if (me.clear) {
						me.clear();
					}
				} else {
					contextFn();
				}
			});
		}
		me.callParent(arguments);
	},
	clear: function () {
		var me = this;
		if (me.editRecord) me.editRecord.set(me.dataIndex, 0);
		//me.setValue(0);
	},
	setValue: function(value) {
		let me = this;
		
		me.callParent(arguments);
		
		if (me.editRecord) {
			me.editRecord.set(me.dataIndex, value);
		}
	},
	valueToRaw: function (v) {
		var me = this;
		return me.editRecord ? me.defaultRenderer(v, _, me.editRecord) : '';
	}
});

Ext.define('Keysystems.grid.column.MultiType', {
	extend: 'Ext.grid.column.Column',
	alias: ['widget.multitypecolumn'],
	alternateClassName: 'Keysystems.grid.MultiTypeColumn',
	fieldType: 'TYPE',
	fieldName: 'NAME',
	fieldCode: 'CODE',
	fieldLink: 'LINK',
	fieldDictCode: 'code',
	fieldList: 'LIST',
	fieldExt: 'TEMP_EXT',
	formatDate: 'd.m.Y',
	tdCls: 'rks-multitype-column-cell',
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function () {
		var me = this;
		if (!me.types) me.types = miscTypes.CalcType;
		
		me.callParent(arguments);
		
		me.grid = this.up('tablepanel');

		//клик по ячейке с чекбоксом не всегда приводит к его ред-ию. вызываем вручную
		me.grid?.on('cellclick', (view, td, cellIndex, record) => {
			//todo учесть plugin.beforeedit
			if (view.grid.readOnly || view.grid.ksReadOnly) return;
			
			let type = record.get(me.fieldType);
			if (+type !== 4) return;
			
			let dataIndex = view.panel.getColumnManager().getHeaderAtIndex(cellIndex)?.dataIndex;
			if (dataIndex !== "VAL") return;
			
			record.set('VAL', !record.get('VAL'));

			let plugin = view.grid.plugins.filter(plugin => plugin instanceof Ext.grid.plugin.CellEditing)[0];
			plugin?.startEdit(record, cellIndex);
		});
	},
	
	defaultRenderer: function (v, m, rec) {
		var me = this,
			t = rec.get(me.fieldType);
		t = me.types[t];
		if (m) {
			if (m.align === 'byType'){
				switch (t) {
					case 'Количество':
					case 'Сумма':
					case 'Дата':
						me.align = 'right';
						break;
					case 'Текст':
					case 'Справочник':
					case 'Список':
						me.align = 'left';
						break;
					case 'Флаг':
					case 'Файл':
						me.align = 'center';
						break;
				}
			}
			else if (!me.align) me.align = 'left';
		}
		switch (t) {
			case 'Количество':
				return +v;
			case 'Сумма':
				var resn = v * 1;
				return isNaN(resn) ? v : convertToDecimal(resn, me.decimalData);
			case 'Дата':
				var res = Ext.util.Format.date(v, me.formatDate);
				return res === 'NaN.NaN.0NaN' ? v : res;
			case 'Текст':
				return v;
			case 'Флаг':
				return Ext.grid.column.Check.prototype.defaultRenderer(v?.toString().toLowerCase() === 'true' || v === true, m);
			case 'Справочник':
				if (v === '0') v = '';
				return Keysystems.grid.column.Dict.prototype.defaultRenderer.call(me, v, m, rec) || v;
			case 'Список':
				return v;
			case 'Файл':
				let resFile = v,
					ext = rec.get(me.fieldExt);
				if (ext)
					resFile = `<div class="x-action-col-icon ${getExtStyle(ext)}" ></div>`;
				return resFile;
		}
		return v;
	},
	getDictCode: function (rec) {
		return rec.get(this.fieldDictCode);
	},
	getEditor: function (rec) {
		return this.getColumnField(rec);
	},
	getEditorId: function (rec) {
		return rec ? rec.get(this.fieldType) : 'ReadOnly';
	},
	isEditeble: function (rec) {
		return !rec.get('ReadOnly');
	},
	getColumnField: function (rec) {
		var me = this;
		if (!me.isEditeble(rec)) {
			delete me.editRecord;
			return _;
		}
		var type = rec.get(me.fieldType),
			fields = me.fields || (me.fields = {}),
			field = fields[type];

		me.editRecord = rec;

		if (!(field && field.isFormField)) field = me.fields[type] = me.createColumnField(type);

		if (field) {
			field.editRecord = rec;
			if (me.types[type] === 'Список') field.loadData(me.getList(rec));
		} else {
			delete me.editRecord;
		}

		return field;
	},

	getXtype: function (type) {
		var me = this;
		type = me.types[type];
		switch (type) {
			case 'Количество':
				return 'numberfield';
			case 'Сумма':
				return {
					xtype: 'calcfield',
					fieldLabel: '',
					decimalData: me.decimalData,
					getValue: function() {
						return this.rawToValue(this.processRawValue(this.getRawValue()));
					}
				};
			case 'Дата':
				return {
					xtype: 'datefield',
					format: me.formatDate,
					submitFormat: 'Y/m/d'
				};
			case 'Текст':
				return 'textfield';
			case 'Флаг':
				return 'checkbox';
			case 'Справочник':
				return {
					xtype: 'triggerdict',
					trgClick: function () {
						me.dictHandler.call(this, me.editRecord, me.getDictCode(me.editRecord), me);
					},
					defaultRenderer: me.defaultRenderer.bind(me),
					ksGetValue: function (rec) {
						if (rec.get('MULTISELECT')) {
							let res = [];
							if (rec.get('VAL') != 0) {
								Ext.each(rec.get('VAL').toString().split(';'), function (d) {
									res.push({LINK: d});
								});
							}
							return res;
						} else {
							var o = {},
								l = rec.get(me.dataIndex) * 1;

							o[me.fieldLink] = isNaN(l) ? '' : l;
							o[me.fieldCode] = rec.get(me.dataIndex + '_' + me.fieldCode);
							o[me.fieldName] = rec.get(me.dataIndex + '_' + me.fieldName);

							return [o];
						}
					},
					ksSetValue: function (v, rec) {
						let link = '',
							links = '',
							code = '',
							name = '';

						links = [];
						Ext.each(v, function (d) {
							links.push(d.data ? d.get('LINK') : d.LINK);
						});
						links = links.join(';');

						if (v.length > 1) {
							name = `Отобрано: ${v.length}`;
							link = links;
						} else {
							var d = v[0];
							d = d ? d.data || d : _;
							if (d !== _) {
								link = d[me.fieldLink] || '';
								code = d[me.fieldCode] || '';
								name = d[me.fieldName] || '';
							}
						}
						
						rec.beginEdit();
						rec.set(me.dataIndex + '_' + me.fieldCode, code);
						rec.set(me.dataIndex + '_' + me.fieldName, name);
						rec.set(me.dataIndex, link);
						rec.endEdit();
					},
					clear: function () {
						me.dictClear();
					},
					initWhereArgs: function (rec) {
						return me.initWhereArgs.call(this, rec);
					}
				};
			case 'Список':
				return {
					xtype: 'combobox',
					editable: false,
					maxLength: 1000,
					enforceMaxLength: true,
					store: Ext.create('Ext.data.Store', {fields: ['val'], data: [], proxy: 'memory'}),
					displayField: 'val',
					valueField: 'val'
				};
			case 'Файл':
				return Ext.create('Ext.Button', {
					reset: Ext.emptyFn,
					text: 'Файл',
					setValue: function () {
						// todo: найти способо вызвать handler после отработки всех событий
						// нельзя сразу вызывать handler. Необходимо дождаться, когда перерисуются все вьюхи
						//this.handler();
						this.setIconCls(getExtStyle(this.editRecord.get(me.fieldExt)));
					},
					resetOriginalValue: function () {
					},
					isFormField: true,
					getRawValue: function () {
						return this.editRecord.get(me.dataIndex);
					},
					getValue: function () {
						return this.editRecord.get(me.dataIndex);
					},
					isValid: Ext.trueFn,
					handler: function () {
						var rec = this.editRecord;
						this.setIconCls(getExtStyle(rec.get(me.fieldExt)));
						if (rec) me.fileEdit(rec);
					}
				});
		}
		return _;
	},

	dictClear: function () {
		var me = this,
			rec = me.editRecord;

		rec.beginEdit();
		rec.set(me.dataIndex + '_' + me.fieldCode, '');
		rec.set(me.dataIndex + '_' + me.fieldName, '');
		rec.set(me.dataIndex, 0);
		rec.endEdit();
	},

	dictHandler: function (rec, code, column) {
		var me = this;
		if (rec) {
			let mode = rec.get('MULTISELECT') ? 'MULTI' : 'SINGL';
			dictFunc({
				mode: me.mode || mode,
				parentView: me.parentView || column,
				mainColumn: me.mainColumn,
				selectLinks: (me.ksGetValue || me.getValue).call(me, rec),
				whereArgs: me.initWhereArgs(rec),
				code: code,
				control: me,
				contextSearch: me.contextSearch
			}, {
				ok: function (value) {
					(me.ksSetValue || me.setValue).call(me, value, rec);
					me.setValue(value[0] ? (value[0].data || value[0])[me.fieldLink] : 0);
				}
			});
		}
	},

	initWhereArgs: function () {
		return this.whereArgs;
	},

	createColumnField: function (type) {
		var me = this,
			field = me.getXtype(type);

		if (field) { 
			if (field.isComponent) {
				field.column = me;
				field.isEditorComponent = true;
			} else {
				field = Ext.apply({
					name: me.dataIndex,
					column: me,
					isEditorComponent: true,
				}, Ext.isString(field) ? {xtype: field} : field);

				field = Ext.ComponentManager.create(field);
			}
		}
		return field;
	},

	getList: function (rec) {
		var me = this;
		return rec.get(me.fieldList);
	},
	fileEdit: function (rec) {
		showError(wmc.get('NotMetodFile'));
	}
});

Ext.define('Keysystems.form.field.TextAreaComboBox', {
	extend: 'Ext.form.field.ComboBox',
	fieldSubTpl: [
		'<textarea id="{id}" role="{role}" {inputAttrTpl}',
		'<tpl if="name"> name="{name}"</tpl>',
		'<tpl if="rows"> rows="{rows}"',
		'<tpl else> rows="1"',
		'</tpl>',
		'<tpl if="cols"> cols="{cols}" </tpl>',
		'<tpl if="placeholder"> placeholder="{placeholder}"</tpl>',
		'<tpl if="size"> size="{size}"</tpl>',
		'<tpl if="maxLength !== undefined"> maxlength="{maxLength}"</tpl>',
		'<tpl if="readOnly"> readonly="readonly"</tpl>',
		'<tpl if="disabled"> disabled="disabled"</tpl>',
		'<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>',
		' class="{fieldCls} {typeCls} {inputCls} x-form-textarea" ',
		'<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
		' autocomplete="off">\n',
		'<tpl if="value">{[Ext.util.Format.htmlEncode(values.value)]}</tpl>',
		'</textarea>',
		{disableFormats: true}
	]
});

//todo колонка не ресайзится 
Ext.define('Keysystems.grid.column.ActionImg', {
	extend: 'Ext.grid.column.Action',
	alias: ['widget.actionimg'],
	dataIndex: 'IMG',
	width: 40,
	align: 'center',
	iconCls: '',
	maxWidth: 40,
	sortable: false,
	imgHandler: Ext.emptyFn,
	cellCond: function (rec) {
		return rec.get(this.dataIndex);
	},
	handler: function (grid, rowIndex, colIndex, item, e, rec) {
		this.imgHandler(grid, rec);
	},
	getClass: function (v, meta, rec) {
		return this.cellCond(rec) ? this.iconCls : '';
	},
	initRenderData() {
		//пробрасываем в шаблон картинку хэдера
		var data = this.callParent();
		data["headerIconCls"] = this.iconCls;
		data["headerText"] = this.text;
		return data;
	},
	//функционал нужен для того, чтобы добавить в хэдер span с картинкой
	// шаблон скорпирован с исходников extjs
	renderTpl: [
		'<div id="{id}-titleEl" data-ref="titleEl" role="presentation"',
		'{tipMarkup}class="',
		Ext.baseCSSPrefix,
		'column-header-inner<tpl if="!$comp.isContainer"> ',
		Ext.baseCSSPrefix,
		'leaf-column-header</tpl>',
		'<tpl if="empty"> ',
		Ext.baseCSSPrefix,
		'column-header-inner-empty</tpl>">',
		'<div id="{id}-textContainerEl" data-ref="textContainerEl" role="presentation" class="',
		Ext.baseCSSPrefix,
		'column-header-text-container">',
		'<div role="presentation" class="',
		Ext.baseCSSPrefix,
		'column-header-text-wrapper">',
		'<div id="{id}-textEl" data-ref="textEl" role="presentation" class="',
		Ext.baseCSSPrefix,
		'column-header-text',
		'{childElCls}">',
		'<span class="ks-column-header-icon {headerIconCls}"><tpl if="!headerIconCls">{headerText}</tpl></span>',
		'</div>',
		'{%',
		'values.$comp.afterText(out, values);',
		'%}',
		'</div>',
		'</div>',
		'<tpl if="!menuDisabled">',
		'<div id="{id}-triggerEl" data-ref="triggerEl" role="presentation" unselectable="on" class="',
		Ext.baseCSSPrefix,
		'column-header-trigger',
		'{childElCls}" style="{triggerStyle}"></div>',
		'</tpl>',
		'</div>',
		'{%this.renderContainer(out,values)%}'
	]
});

Ext.define('Keysystems.form.field.Trigger.TextEditor', {
	extend: 'Keysystems.form.field.TextAreaTrigger',
	alias: ['widget.triggertexteditor'],
	trgCls: 'x_btn_edit',
	enforceMaxLength: true,
	getEditorTitle: function () {
		return this.fieldLabel;
	},
	onTriggerClick: function () {
		var me = this;
		me.editable ? showTextEditor(me.getValue(), function (text) {
			me.setValue(text);
		}, me.getEditorTitle(), me.maxLength) : showTextViewer(me.getValue(), me.getEditorTitle());
	}
});

Ext.define('Keysystems.form.field.FileButtonMulti', {
	extend: 'Ext.form.field.FileButton',
	afterTpl: [
		'<input id="{id}-fileInputEl" data-ref="fileInputEl" class="{childElCls} {inputCls}" ',
		'type="file" size="1" name="{inputName}" unselectable="on" multiple ',
		'<tpl if="accept != null">accept="{accept}"</tpl>',
		'<tpl if="tabIndex != null">tabindex="{tabIndex}"</tpl>',
		'>'
	],
});

Ext.define('Keysystems.picker.Date', {
	extend: 'Ext.picker.Date',
	handleDateClick: function (e, t) {
		var me = this,
			handler = me.handler;

		me.isHoliday = t.className.indexOf('ks-holiday') > 0 || t.parentElement.className.indexOf('ks-holiday') > 0;

		e.stopEvent();
		if (!me.disabled && t.dateValue && !Ext.fly(t.parentNode).hasCls(me.disabledCellCls)) {
			me.doCancelFocus = me.focusOnSelect === false;
			me.setValue(new Date(t.dateValue));
			delete me.doCancelFocus;
			me.fireEvent('select', me, me.value);
			if (handler) {
				handler.call(me.scope || me, me, me.value);
			}

			me.onSelect();
		}
	},
	fullUpdate: function (date) {
		var th = this,
			res = th.callParent(arguments);
		th.fireEvent('ksFullUpdate', th);
		return res;
	},
	renderTpl: [
		'<div id="{id}-innerEl" data-ref="innerEl" role="presentation">',
		'<div class="{baseCls}-header">',
		'<div id="{id}-prevEl" data-ref="prevEl" class="{baseCls}-prev {baseCls}-arrow" role="presentation" title="{prevText}"></div>',
		'<div id="{id}-middleBtnEl" data-ref="middleBtnEl" class="{baseCls}-month" role="heading">{%this.renderMonthBtn(values, out)%}</div>',
		'<div id="{id}-nextEl" data-ref="nextEl" class="{baseCls}-next {baseCls}-arrow" role="presentation" title="{nextText}"></div>',
		'</div>',
		'<table role="grid" id="{id}-eventEl" data-ref="eventEl" class="{baseCls}-inner" cellspacing="0" tabindex="0" aria-readonly="true">',
		'<thead>',
		'<tr role="row">',
		'<tpl for="dayNames">',
		'<th role="columnheader" class="{parent.baseCls}-column-header" aria-label="{.}">',
		'<div role="presentation" class="{parent.baseCls}-column-header-inner">{.:this.firstInitial}</div>',
		'</th>',
		'</tpl>',
		'</tr>',
		'</thead>',
		'<tbody>',
		'<tr role="row">',
		'<tpl for="days">',
		'{#:this.isEndOfWeek}',
		'<td role="gridcell">',
		'<div hidefocus="on" class="{parent.baseCls}-date {#:this.isHoliday}"></div>',
		'</td>',
		'</tpl>',
		'</tr>',
		'</tbody>',
		'</table>',
		'<tpl if="showToday">',
		'<div id="{id}-footerEl" data-ref="footerEl" role="presentation" class="{baseCls}-footer">{%this.renderTodayBtn(values, out)%}</div>',
		'</tpl>',
		// These elements are used with Assistive Technologies such as screen readers
		'<div id="{id}-todayText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{todayText}.</div>',
		'<div id="{id}-ariaMinText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{ariaMinText}.</div>',
		'<div id="{id}-ariaMaxText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{ariaMaxText}.</div>',
		'<div id="{id}-ariaDisabledDaysText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{ariaDisabledDaysText}.</div>',
		'<div id="{id}-ariaDisabledDatesText" class="' + Ext.baseCSSPrefix + 'hidden-clip">{ariaDisabledDatesText}.</div>',
		'</div>',
		{
			firstInitial: function (value) {
				return Ext.picker.Date.prototype.getDayInitial(value);
			},
			isEndOfWeek: function (value) {
				// convert from 1 based index to 0 based
				// by decrementing value once.
				value--;
				// eslint-disable-next-line vars-on-top
				var end = value % 7 === 0 && value !== 0;
				return end ? '</tr><tr role="row">' : '';
			},
			renderTodayBtn: function (values, out) {
				Ext.DomHelper.generateMarkup(values.$comp.todayBtn.getRenderTree(), out);
			},
			renderMonthBtn: function (values, out) {
				Ext.DomHelper.generateMarkup(values.$comp.monthBtn.getRenderTree(), out);
			},
			isHoliday: function (value) {
				if (value !== 0) {
					var end = (value % 7 === 0 || (value + 1) % 7 === 0);
				}
				return end ? 'ks-holiday' : '';
			}
		}
	]
});

Ext.define('Keysystems.Document.Edit.Mini', {
	extend: 'Ext.form.FieldContainer',
	mixins: ['Keysystems.Base.Abstract'],
	layout: {type: 'hbox', align: 'stretch'},
	disabled: true,
	isPlan: false,
	initComponent: function () {
		var me = this;

		me.beforeInitComponent();
		me.items = [
			me.NUMBER = Ext.create('Ext.form.field.Text', {
				fieldLabel: '№',
				maxHeight: 22,
				flex: 2,
				labelWidth: 20,
				listeners: {
					change: function () {
						if (me.initValues) return;
						me.save();
					}
				}
			}),
			me.DT = Ext.create('Ext.form.field.Date', {
				width: 130,
				padding: '0 10 0 10',
				maxHeight: 22,
				labelWidth: 20,
				flex: 2,
				fieldLabel: 'от',
				listeners: {
					change: function () {
						if (me.initValues) return;
						me.save();
					}
				}
			}),
			me.btnFile = Ext.create('Ext.Button', {
				flex: 1,
				text: 'Файл',
				handler: me.fileEdit.bind(me)
			}),
			me.warningIcon = Ext.create('Ext.Component', {
				cls: 'x_btn_warning ks-column-header-icon',
				hidden: true,
				height: 22,
				width: 22
			})
		];

		me.callParent(arguments);
	},
	getOsnovLink: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},
	getWorkLink: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},
	getMasterLink: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},
	getLoadMaskTarget: function(){
		let me = this;
		return me.parentView ? (me.parentView.ownerCt ?? me.parentView) : null;	
	},
	save: function(callback){
		let me = this,
			params = me.docLink ? {
			link: me.docLink
		} : {
			osnov: me.getOsnovLink(),
			work: me.getWorkLink(),
			master: me.getMasterLink(),
			isPlan: me.isPlan
		};
		params.number = me.NUMBER.getValue();
		params.dt = me.DT.getValue();
		if (me.FILES)
			params.tabFiles = {
				FILES: me.FILES,
				EXTENTION: me.TEMP_EXT,
				MAIN: 1,
				NAME: me.NAME,
				LINK: me.FILES
			};

		const loadMask = new Ext.LoadMask({
			msg: "Сохранение документа...",
			target: me.getLoadMaskTarget(),
			autoShow: true,
			rid: ajaxRequest({
				url: 'SDocuments/AddOrEditDocOsnov_A',
				params: {data: JSON.stringify(params)},
				success: function (response) {
					loadMask.destroy();
					if (response && response.result === false){
						showError(response.ErrorMsg);
						return;
					}
					me.refresh();
					if (callback) callback();
				},
				failure: function (val) {
					loadMask.destroy();
					failureShow(val, wmc.get('SavingError'));
				}
			})
		});
	},
	change: function () {
		var me = this;
		if (me.refreshTimeOut) clearTimeout(me.refreshTimeOut);
		me.refreshTimeOut = setTimeout(function () {
			delete me.refreshTimeOut;
			me.refresh(1);
		}, 5000);
	},
	refresh: function () {
		var me = this;
		me.setDisabled(true);
		ajaxRequest({
			url: 'SDocuments/FillOsnov_A',
			params: {
				osnov: me.getOsnovLink(),
				work: me.getWorkLink(),
				master: me.getMasterLink(),
				isPlan: me.isPlan
			},
			callback: function (v) {
				me.initValues = true;
				if (v) {
					if (v.row) {
						me.NUMBER.setValue(v.row.NUMBER);
						me.DT.setValue(v.row.DT);
						me.docLink = v.row.LINK;
						me.FILES = v.row.FILES;
						me.existsMainFile = v.row.existsMainFile;
						me.btnFile.setIconCls(getExtStyle(me.TEMP_EXT = v.row.TEMP_EXT));

						if (v.toolTip) {
							me.warningIcon.show();
							if (me.warningIcon.el) {
								me.warningIcon.el.dom.dataset.qtip = v.toolTip;
							} else {
								var intervalId = setInterval(function () {
									if (me.warningIcon.el) {
										me.warningIcon.el.dom.dataset.qtip = v.toolTip;
										clearInterval(intervalId);
									}
								}, 500);
							}
						} else {
							me.warningIcon.hide();
						}
					}
					else{
						me.NUMBER.setValue(null);
						me.DT.setValue(null);
						me.docLink = null;
						me.FILES = null;
						me.existsMainFile = false;
						me.btnFile.setIconCls(null);
					}
					// нельзя редактировать при создании пункта плана или КМ, т.к. в контрллерах требуются положительные линки
					me.setDisabled(!(me.getMasterLink() && v.canEdit));
				}
				me.initValues = false;
			}
		});
	},

	//#region редактирование файла

	fileEdit: function () {
		var me = this,
			getFileLink = function () {
				return me.docLink;
			};

		me.sksc('FileWindow', Ext.create('Keysystems.File', {
			deleteMessage: KS.L10n.BaseRevizUpdController_DocumentClearMessage,
			docExists: getFileLink,
			iconCls: getExtStyle(me.TEMP_EXT),
			createFile: function (callback) {
				me.createFile(me.docLink > 0 ? me.docLink : 0, me.parentView, callback);
			},
			updRecord: function (fileObj, isMain) {
				me.updFileRecord(fileObj, isMain);
			},
			getFileId: function () {
				return me.FILES;
			},
			clearFile: function () {
				me.clearFile();
			},
			mainFileExists: function (exist, noExist) {
				me.mainFileExists(exist, noExist);
			},
			docEdit: function () {
				me.docEdit();
			},
			btnClearHandler: function (exist, noExist) {
				var id = this.getFileId();
				(id && id !== '0' || this.docExists ? exist : noExist)();
			}
		}));
	},
	createFile: function (link, ownerCt, callback) {
		const me = this;
		UploaderLib.newFile(dnl.DOCUMENTS, link, 0, -1, 0, ownerCt.ownerCt ?? ownerCt, (id, ext, name) => {
			me.FILES = id;
			me.NAME = name || '';
			me.existsMainFile = 1;
			me.TEMP_EXT = ext;
			me.save(() => {
				callback(id, ext, name)
			});
		})
	},
	clearFile: function () {
		var me = this,
			loadMaskTarget = me.getLoadMaskTarget(),
			loadMask = null;

		let rid = ajaxRequest({
				params: {
					code: dnl.DOCUMENTS,
					links: [me.docLink],
					recursive: false
				},
				url: 'data/DelSDictionary_A',
				success: function (res) {
					loadMask.hide();
					if (!res) return;
					me.FILES = 0;
					me.btnFile.setIconCls(getExtStyle(me.TEMP_EXT = ''));
					me.refresh();
				}
			});

		if (loadMaskTarget) {
			loadMask = new Ext.LoadMask({
					msg:`${KS.L10n.delete} документа...`,
					target: loadMaskTarget,
					autoShow: true,
					rid: rid
				}
			)
		}	
		
	},
	updFileRecord: function (fileObj, isMain) {
		var me = this;
		me.FILES = fileObj.id;
		me.NAME = fileObj.name || '';
		if (isMain) me.existsMainFile = isMain;
		me.btnFile.setIconCls(getExtStyle(me.TEMP_EXT = fileObj.ext));
		me.change();
	},
	mainFileExists: function (exist, notExists) {
		(this.existsMainFile ? exist : notExists)();
	},

	//#endregion редактирование файла

	//Редактирование привязанного документа
	docEdit: function () {
		var me = this,
			loadMaskTarget = me.getLoadMaskTarget(),
			loadMask = null;
		
		const rid = ajaxRequest({
			url: me.docLink ? 'SDocuments/GetEditRow_A' : 'SDocuments/AddOrEditDocOsnov_A',
			params: me.docLink ? {
				link: me.docLink,
				isGetRow: true
			} : {data:JSON.stringify({
					osnov: me.getOsnovLink(),
					work: me.getWorkLink(),
					master: me.getMasterLink(),
					isPlan: me.isPlan
				})},
			success: function (row) {
				if (loadMask) loadMask.hide();
				Ext.create('Keysystems.Documents.Edit', {
					f: 'edit',
					data: {data: row},
					osnov: me.getOsnovLink(),
					updRecord: function () {
						me.refresh();
					}
				});
				me.docLink = row['LINK'];
				me.gksc('FileWindow').setEnableBtns();
			},
			failure: function () {
				if (loadMask) loadMask.hide();
			}
		});
		if (loadMaskTarget) {
			loadMask = new Ext.LoadMask({
					msg: KS.L10n.loading_data,
					target: loadMaskTarget,
					autoShow: true,
					rid: rid
				}
			)
		}
	}
});
//Контрол объекта проверки
Ext.define('Keysystems.RevizObj', {
	extend: 'Ext.form.FieldContainer',
	mixins: ['Keysystems.Base.Abstract'],
	labelWidth: 150,
	ksAllowEmpty: true,
	fieldLabel: 'Объект',
	controlsArr: [], //"ЮЛ", "ИП", "ДЛ", "ФЛ"],
	parentView: _,
	mainColumn: true,
	visibleObjs: [],
	troField: 'T_REVIZ_OBJECTS', //T_PLANREVIZ_OBJECTS
    isType: true,

	getRowClass: function (rec) {
		var me = this,
			dt = me.getDT(),
			dh = {dh1: rec.get('DH1'), dh2: rec.get('DH2')};

		if (!PeriodLib.getPeriodsCross(dh, dt)) {
			return 'ks-document ks-notOverdue';
		}
	},

	tRevizObjectLink: -1,

	readOnlyList: [],
	arrDisable: [
		'newObjsBtn'
	],

	//#region Создание компонента
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},

	initComponent: function () {
		var me = this;
		me.layout = 'hbox';
		me.objs = {};
		me.objs.view = me.parentView;
		me.itemsCreate();
		me.callParent(arguments);
	},

	itemsCreate: function () {
		var me = this;
		if (me.items == null)
			me.items = [
				me.newObjsBtn = Ext.create('Ext.Button', me.getNewObjsBtnCfg()),
				me.objsPanel = Ext.create('Ext.form.FieldContainer', me.getObjsPanelCfg())
			];
	},
	//Создание следующего контрола в поле "Объект" inType = "ЮЛ", "ИП" etc.
	createObjsPanelControl: function (inType, val) {
		var me = this;

		if (!inType) {
			Ext.each(me.controlsArr, function (type) {
				if (!me[type] || me[type].isHidden()) {
					inType = type;
					return false;
				}
				return true;
			});
		}

		//Если есть входящий тип то создаем \ показываем его, если нету то создаем следующий по очереди из ksControls.controlsArr
		me.getObjControl(inType).show();
		//Для ДЛ, ЮЛ, СП
		if (val)
			me.getObjControl(inType).setValue(val);

		me.comboStoreReload();
		//Возвращаем название созданного компонента
		return inType;
	},
	//Создание комбобокса с выбором типа "Объекта"
	createControlCombo: function (value) {
		var me = this;

		return me['combo' + value] = Ext.create('Ext.form.field.ComboBox', {
			store: me.controlsArr,
			value: value,
			width: 50,
			editable: false,
			margin: '0 5px 0 4px',
			fieldCls: 'ks-combo-text',
			listeners: {
				change: function (th, newValue, oldValue) {
					if (oldValue && (!me.comboLoad)) {
						var tmpArr = ['ЮЛ', 'СП', 'ДЛ'],
							val;

						if (tmpArr.indexOf(newValue) !== -1 && tmpArr.indexOf(oldValue) !== -1) {
							val = me[oldValue].getValue();
						}

						me[oldValue].hide();
						me.createObjsPanelControl(newValue, val);
						me.eventTROEdit(); //controlName, val && val.orgList);
						me.comboStoreReload();
					}
				}
			}
		});
	},
	//Создание кнопки скрытия "Объекта" с формы
	createControlDel: function (value) {
		var me = this;

		return me['del' + value] = Ext.create('Ext.Button', {
			iconCls: 'x_btn_delete',
			tooltip: wmc.get('DeleteObjsByType', value),
			tooltipType: 'title',
			margin: '0 0 0 5px',
			cls: 'ks-button-image',
			//padding: '0 10 0 0',
			handler: function () {
				me.checkDelNewBtns(value);
				me.eventTROEdit();
				me.comboStoreReload();
			}
		});
	},
	//Метод создания контрола "Объекта контроля"
	getObjControl: function (t) {
		var me = this,
			allObjs = me.getAllObjsCfg();

		if (!me[t] && t) {
			var container = me.objsPanel,
				items = allObjs[t].createItems(),
				cfg = {
					layout: 'hbox',
					items: items
				};

			// todo: лучше не создавать лишние компоненты, скрытые правами доступа, но ломается сохранение объектов. Поэтому пока компоненты создаются, но скрываются на форме
			// if (me.isType) {
			// 	items.unshift(me.createControlCombo(t));
			// 	items.push(me.createControlDel(t));
			// }
			// else
			// {
			// 	me.labelWidth = me.labelWidth + 83;
			// 	me.labelEl.setWidth(me.labelWidth + 5);
			// }

			items.unshift(me.createControlCombo(t).setVisible(me.isType));
			items.push(me.createControlDel(t).setVisible(me.isType));

			if (!me.isType) {
				me.labelWidth = me.labelWidth + 83;
				me.labelEl.setWidth(me.labelWidth + 5);
			}

			Ext.apply(cfg, allObjs[t]);
			container.add(me[t] = Ext.create('Ext.form.FieldContainer', cfg));
		}
		//Добавляем созданный компонент в массив на ридонли
		if (me.readOnlyList.indexOf(t) === -1) {
			me.readOnlyList.push(t);
		}
		//Добавляем созданный компонент в массив на дизейбл
		if (me.arrDisable.indexOf('combo' + t) === -1) {
			me.arrDisable.push('combo' + t, 'del' + t);
		}

		return me[t];
	},

	//#endregion Создание компонента

	//#region Конфиги
	//Конфиг кнопки NEW
	getNewObjsBtnCfg: function () {
		var me = this;
		return {
			iconCls: 'x_btn_new',
			tooltip: wmc.get('AddOtherObj'),
			tooltipType: 'title',
			cls: 'ks-button-image',
			width: 24,
			handler: function () {
				me.checkDelNewBtns(me.createObjsPanelControl(), true);
			}
		};
	},
	//Конфиг контейнера
	getObjsPanelCfg: function () {
		return {
			flex: 1,
			layout: {type: 'vbox', align: 'stretch'}
		};
	},
	//Меняем иконку триггера
	triggerBtnEvent: function (value, objName) {
		var me = this,
			width = 0,
			obj = me[objName],
			newCls = (value && value.length ? 'x_btn_edit' : 'x_btn_new') + ' x-dict-trigger';

		if (value && value.length > 1) {
			obj.fieldCode = obj.fieldCode1;
			width = obj.fieldCode.width;
			obj.fieldCode2.hide();
		} else {
			obj.fieldCode = obj.fieldCode2;
			width = obj.fieldCode.width;
			obj.fieldCode1.hide();
		}

		obj.fieldCode2.width = obj.fieldCode1.width = width;
		obj.fieldCode.objCode = objName;
		obj.fieldCode.show();
		obj.setValue(obj.getValue());

		var fieldCode = obj.fieldCode;

		//Если 2 триггера то меняем класс кнопки в зависимости от value (NEW || EDIT)
		if (fieldCode.triggers.trigger1) {
			var trig = fieldCode.triggers.trigger1;
			if (trig.el) {
				var el = trig.el;
				el.removeCls(trig.cls);
				el.addCls(trig.cls = newCls);
			} else {
				trig.cls = newCls;
			}
		}
	},
	
	//Скрываем иконку триггера
	triggerBtnHidden: function (objName, state){
		var me = this,
			obj = me[objName],
			fieldCode = obj.fieldCode;
		
		if (fieldCode.triggers.trigger1) {
			var trig = fieldCode.triggers.trigger1;
			if (trig.el) {
				trig.el[state ? 'addCls' : 'removeCls']('ks-hidden');
			} else {
				trig.cls = trig.cls + (state ? ' ks-hidden' : '');
			}
		}
	},

	//Конфигурация контролов "Объект" (ЮЛ, ИП, ....)
	getAllObjsCfg: function () {
		var me = this;

		if (me.allObjsCfg) return me.allObjsCfg;

		var getRevizOneMain = function (checked, rec, th, isChild) {
				var mainObjs = 0,
					checkArr = isChild ? [] : this.getChecks(),
					mGrid = this.gksc('MultiSelectGrid');

				if (isChild) {
					Ext.each(mGrid.store.data.items, rec => {
						if (rec.data.MAIN) {
							checkArr.push(rec);
						}
					});
				}

				Ext.each(checkArr, function (el) {
					var d = el.data || el;
					if (d.MAIN && d.LINK !== rec.data.LINK) mainObjs++;
				});

				//Если пришли с колонки MAIN то просто отдаем настройку
				if (th && th.dataIndex && th.dataIndex === 'MAIN') {
					//Иначе на 1 больше показывает чем на самом деле
					if (checked) mainObjs--;
					return me.getRevizOneMain() ? mainObjs >= 1 : false;
				}

				return mainObjs >= 1;
			},
			objsHandlers = function (o) {
				return [
					{
						hidden: me.readOnly,
						handler: function () {
							var obj;

							if ((obj = me.gksc(this.objCode))) {
								let cfg = {};
								Ext.apply(cfg, dictListController[obj.code]);
								cfg.parentView = me;
								cfg.f = this.triggers && this.triggers.trigger1 && this.triggers.trigger1.cls.indexOf('x_btn_edit') >= 0 ? 'edit' : 'new';
								cfg.data = obj.getValue()[0];

								cfg.successSaveFunc = function (result) {
									var th = this;
									th.callParent(arguments);

									if (result.result) {
										var oldV = obj.getValue();
										result.row.MAIN = oldV && ((oldV[0] && oldV[0].data.MAIN) || oldV.length === 0);
										obj.ksSetValue([{data: result.row}]);
									}
								};
								if (obj.getInputDicts) cfg.inputDicts = obj.getInputDicts();

								cfg.updRecord = Ext.emptyFn;

								Ext.create(cfg.editClass, cfg);
							}
						},
						cls: 'x_btn_new x-dict-trigger'
					},
					o.handler
				];
			},
			overrideFieldCode = function (cmp) {
				//старый с 2 двумя триггерами
				cmp.fieldCode2 = cmp.fieldCode;
				//Создаем новый с 1 триггером
				var fc = cmp.getFieldCfg();
				fc.hidden = true;
				fc.btnsCount = 1;
				fc.ksAllowEmpty = cmp.ksAllowEmpty;
				fc.trigger1Cls = fc.trigger2Cls;
				fc.onTrigger1Click = fc.onTrigger2Click;
				delete fc.trigger2Cls;
				//Под 0 индексом филдкод с 1 триггером
				cmp.insert(0, cmp.fieldCode1 = Ext.create('Ext.form.field.Text', fc));
				me.triggerBtnEvent([], cmp.key);
			},
			baseCfg = {
				orgKey: 'S_ORG',
				personKey: 'S_PERSON',
				isEmpty: function () {
					return me[this.componentKey].isEmpty();
				},
				returnOldValue: function () {
					me[this.componentKey].setValue(me.allObjsCfg[this.name].oldValue);
				},
				setOldValue: function (value) {
					me.allObjsCfg[this.name].oldValue = value;
				},
				setReadOnly: function (state) {
					me.gksc(this.componentKey).setReadOnly(state);
					me.triggerBtnHidden(this.componentKey, state);
				}
			},
			onlyOneMain = me.getRevizOneMain();

		//конфигуратор списка организаций с доп полем выбора сотрудника
		let getListCfg_IP_DL = function (type) {
			return {
				beforeSetData: function (data, p) {
					this.callParent(arguments);
					me.beforeSetData();
				},
				createItems: function () {
					var meList = this,
						res = meList.callParent(arguments),
						dictOrg = type === 'ИП' ? me.ИП_S_ORGC : me.ДЛ_S_ORGC,
						dictPerson = type === 'ИП' ? me.ИП_S_PERSON : me.ДЛ_S_PERSON;
					//todo при отображении формы редактирования тоже дергается метод listcfg.createItems
					if (this.f) return res;

					meList.personFC = Ext.create('Ext.form.FieldContainer',
						{
							layout: {type: 'vbox', align: 'stretch'},
							padding: me.bodyPadding || 5,
							disabled: true,
							items: [
								me.createDictEdit({
									key: 'S_PERSON',
									mode: me.getMode(),
									code: dnl.S_PERSON,
									ksSetValue: function (v) {
										this.setValue(v);
										var personLinks = [];
										if (v) {
											Ext.each(v, function (val) {
												personLinks.push(val.LINK || val.data.LINK);
											});
										}
										let sOrg = meList.selSOrgRec.get('LINK');
										// удаляем размеченные
										meList.ORG_PERSON =
											meList.ORG_PERSON.filter(function (d) {
												return d.S_ORG !== sOrg || personLinks.indexOf(d.S_PERSON) !== -1;
											});
										// добавляем отмеченные
										var existsLinks = [];
										Ext.each(meList.getOrgPerson(sOrg), function (d) {
											existsLinks.push(d.S_PERSON);
										});

										Ext.each(v, function (val) {
											var personLink = val.LINK || val.data.LINK;
											if (existsLinks.indexOf(personLink) === -1) {
												meList.ORG_PERSON.push({
													S_ORG: sOrg,
													S_PERSON: personLink,
													S_PERSON_CODE: val.CODE || val.data.CODE,
													FIRSTNAME: val.FIRSTNAME || val.data.FIRSTNAME,
													LASTNAME: val.LASTNAME || val.data.LASTNAME,
													PATRONYMIC: val.PATRONYMIC || val.data.PATRONYMIC
												});
											}
										});
									},
									fieldLabel: 'Сотрудник',
									listCfg: {
										initWhereArgs: function () {
											return {
												SOrgs: {
													value: JSON.stringify([meList.selSOrgRec.get('LINK')]),
													type: 'List_int'
												}
											};
										},
										getInputDicts: function () {
											return [
												Ext.create('InputEditDict',
													{name: 'S_ORG', data: meList.selSOrgRec.data})
											];
										}
									}
								})
							]
						});

					res.splice(1, 0, meList.personFC);
					meList.ORG_PERSON = [];

					let persons = dictPerson.getValue();
					Ext.each(dictOrg.getLinks(),
						function (sOrg) {
							let personRows = persons.map(r => r.data || r).filter(r => r.TLINK_SELF === sOrg);
							Ext.each(personRows,
								function (p) {
									meList.ORG_PERSON.push({
										S_ORG: sOrg,
										S_PERSON: p.LINK,
										CODE: p.S_PERSON_CODE,
										FIRSTNAME: p.FIRSTNAME,
										LASTNAME: p.LASTNAME,
										PATRONYMIC: p.PATRONYMIC
									});
								});
						});

					(meList.dictList || meList).Grid.on('selectionchange',
						function (th, sels) {
							meList.selectPerson(sels[0]);
						});

					if (meList.functions.ok) {
						meList.functions.__ok = meList.functions.ok;
						meList.functions.ok = function (value) {
							let orgLinks = [];
							Ext.each(value,
								function (val) {
									v = val.data || v;
									orgLinks.push(v.LINK);
								});
							let personValues = [];
							meList.ORG_PERSON.filter(r => r.S_PERSON && orgLinks.indexOf(r.S_ORG) !== -1).forEach(r => {
								let v = {};
								Object.assign(v, r);
								v.LINK = v.S_PERSON;
								v.CODE = v.S_PERSON_CODE;
								v.TLINK_SELF = r.S_ORG;
								personValues.push({data: v});
							});
							dictPerson.setValue(personValues);
							meList.functions.__ok(value);
						};
					}

					return res;
				},
				createCheckColumn: function () {
					var meList = this,
						res = meList.callParent(arguments);
					meList.mColumn.on('checkchange',
						function (th, rowIndex, checked, rec) {
							var sOrg = rec.get('LINK');
							var tOrgPerson = meList.getOrgPerson(sOrg);
							if (!rec.get('M') && tOrgPerson.length) {
								meList.ORG_PERSON = meList.ORG_PERSON.filter(function (d) {
									return d.S_ORG !== sOrg;
								});
							}
							if (meList.selSOrgRec &&
								meList.selSOrgRec.get('LINK') === rec.get('LINK')) {
								meList.selectPerson(rec);
							}
						});
					return res;
				},
				getOrgPerson: function (sOrg) {
					return ArrayLib.filter(this.ORG_PERSON || [], ['S_ORG'], sOrg);
				},
				selectPerson: function (rec) {
					var fc = this.personFC,
						dictOrgPerson = fc.items.first();

					if (!rec) return;
					
					// if (rec) {
						this.selSOrgRec = rec;
						let sOrg = rec.get('LINK');
						let tOrgPerson = this.getOrgPerson(sOrg);
						if (rec.get('M')) {
							var v = this.convertListToDictList(tOrgPerson, 'S_PERSON');
							dictOrgPerson.setValue(v);
							fc.enable();
							return;
						} else {
							dictOrgPerson.setValue();
						}
					// } else {
					// 	delete this.selSOrgRec;
					// }
					fc.disable();
				},
				convertListToDictList: Keysystems.Base.Edit.prototype.convertListToDictList,
				convertToDictRec: Keysystems.Base.Edit.prototype.convertToDictRec
			}
		};

		me.allObjsCfg = {
			ЮЛ: Ext.apply({}, {
				name: 'ЮЛ',
				componentKey: 'ЮЛ_S_ORGC',
				createItems: function () {
					var cmp = me.createDictEdit({
							key: 'ЮЛ_S_ORGC',
							mode: me.getMode(),
							parentView: me,
							controlName: 'DICTEDITOR_RevizEditView_dictOrgUL',
							initWhereArgs: function () {
								return me.initWhereArgs(me.ЮЛWhereArgs);
							},
							mainColumn: me.mainColumn,
							getRevizOneMain: getRevizOneMain,
							listCfg: {
								onlyOneMain: onlyOneMain,
								beforeSetData: function (data, p) {
									this.callParent(arguments);
									me.beforeSetData();
								}
							},
							code: dnl.S_ORG,
							flex: 1,
							getRowClass: function (rec) {
								return me.getRowClass(rec);
							},
							ksAllowEmpty: me.ksAllowEmpty,
							ksSetValue: function (value) {
								if (!me.canChangeObjects.call(me.parentView, 'ЮЛ', value)) {
									return;
								}
								me.checkForFilials(value, me, 'ЮЛ', me.continueSetValue);
							},
							beforeclear: function () {
								return me.canChangeObjects.call(me.parentView, 'ЮЛ', []);
							}
						},
						function (o) {
							o.handler = objsHandlers(o);
							return o;
						});

					overrideFieldCode(cmp);
					return [cmp];
				},
				getValue: function () {
					return {orgList: me.gksc('ЮЛ_S_ORGC').getValue()};
				},
				setValue: function (val) {
					me.gksc('ЮЛ_S_ORGC').ksSetValue(val && val.orgList);
				}
			}, baseCfg),
			ИП: Ext.apply({}, {
				name: 'ИП',
				componentKey: 'ИП_S_ORGC',
				isEmpty: function () {
					return me.ИП_S_ORGC.isEmpty() || me.ИП_S_PERSON.isEmpty();
				},
				createItems: function () {
					var cmp = me.createDictEdit({
							key: 'ИП_S_ORGC',
							mode: me.getMode(),
							parentView: me,
							controlName: 'DICTEDITOR_RevizEditView_dictOrgIP',
							mainColumn: me.mainColumn,
							getRevizOneMain: getRevizOneMain,
							code: dnl.S_ORG,
							flex: 1,
							initWhereArgs: function () {
								return me.initWhereArgs(me.ИПWhereArgs);
							},
							getRowClass: function (rec) {
								return me.getRowClass(rec);
							},
							ksAllowEmpty: me.ksAllowEmpty,
							ksSetValue: function (value) {
								if (!me.canChangeObjects.call(me.parentView, 'ИП', value)) {
									return;
								}
								me.allObjsCfg.ИП.setOldValue(me.ИП_S_ORGC.getValue());
								me.ИП_S_ORGC.setValue(value);

								if (!value) {
									me.ИП_S_PERSON.setValue([]);
									me.triggerBtnEvent([], 'ИП_S_PERSON');
								}

								me.eventTROEdit('ИП', value, me.ИП_S_PERSON.getValue());
								me.triggerBtnEvent(value, 'ИП_S_ORGC');
							},
							beforeclear: function () {
								return me.canChangeObjects.call(me.parentView, 'ИП', []);
							},
							listCfg: getListCfg_IP_DL('ИП')
						},
						function (o) {
							o.handler = objsHandlers(o);
							return o;
						});
					overrideFieldCode(cmp);
					let res = [
						cmp,
						{xtype: 'splitter', border: 0},
						me.createDictEdit({
								key: 'ИП_S_PERSON',
								mode: me.getMode(),
								parentView: me,
								controlName: 'DICTEDITOR_RevizEditView_dictPersonIP',
								code: dnl.S_PERSON,
								nameField: 'SNAME',
								flex: 1,
								ksAllowEmpty: false,
								ksSetValue: function (value) {
									var rowPerson = value && value.length ? value[0].data : null;

									let refreshDictPerson = function () {
										me.ИП_S_PERSON.setValue(value);
										me.eventTROEdit('ИП', _, value || []);
										me.triggerBtnEvent(value, 'ИП_S_PERSON');
									}

									if (!rowPerson) {
										refreshDictPerson();
										return;
									}
									
									rowPerson.SNAME = rowPerson.NAME = window.getTextByVisibleFields(dnl.S_PERSON, _, rowPerson);

									if (me.isLoading()){
										refreshDictPerson();
										return;
									}
									
									let personLinks = [];
									Ext.each(value, function (v) {
										personLinks.push(v.data.LINK);
									});
									me.getOrgByPerson(personLinks, 'ИП', me.ИПWhereArgs.NotInLinks.value).then(
										function (res) {
											let orgs = me.ИП_S_ORGC.getLinks();
											if (orgs.length) {
												Ext.each(value,
													function (v) {
														v.data.TLINK_SELF = res.personOrgs[v.data.LINK];
													});
												refreshDictPerson();
											} else {
												if (!res.orgData.length) return;
												Ext.each(res.orgData, function (o) {
													o.data.MAIN = true;
												});

												if (me.canChangeObjects.call(me.parentView, 'ИП', res.orgData)) {
													me.ИП_S_ORGC.setValue(res.orgData);
													me.eventTROEdit('ИП', res.orgData, value || [], true);
													me.triggerBtnEvent(value, 'ИП_S_ORGC');

													Ext.each(value,
														function (v) {
															v.data.TLINK_SELF = res.personOrgs[v.data.LINK];
														});
													refreshDictPerson();
												}
											}
										});
								},
								initWhereArgs: function () {
									let orgs = me.ИП_S_ORGC.getLinks();
									let whereArgs = orgs.length
										? {
											SOrgs: {value: JSON.stringify(orgs), type: 'List_int'}
										}
										: {
											DH1: {value: longPeriod.begin, type: 'Date'},
											DH2: {value: longPeriod.end, type: 'Date'},
											SRegions: {value: me.ИПWhereArgs.Regions.value, type: 'List_int'},
											NotSOrgs: {value: me.ИПWhereArgs.NotInLinks.value, type: 'List_int'},
											STypeOrgs: {value: JSON.stringify(me.getIndivid()), type: 'List_int'}
										};
									return whereArgs;
								},
								getInputDicts: function () {
									let orgs = me.ИП_S_ORGC.getValue();
									return orgs.length
										? [Ext.create('InputEditDict', {name: 'S_ORG', data: orgs[0].data})]
										: [];
								}
							},
							function (o) {
								o.handler = objsHandlers(o);
								return o;
							})
					];
					overrideFieldCode(res[2]);
					return res;
				},
				returnOldValue: function () {
					me.ИП_S_ORGC.setValue(me.allObjsCfg.ИП.oldValue);
					me.ИП_S_PERSON.setValue([]);
				},
				setReadOnly: function (state) {
					me.gksc('ИП_S_ORGC').setReadOnly(state);
					me.gksc('ИП_S_PERSON').setReadOnly(state);
					me.triggerBtnHidden('ИП_S_ORGC', state);
					me.triggerBtnHidden('ИП_S_PERSON', state);
				},
				getValue: function () {
					return {
						orgList: me.gksc('ИП_S_ORGC').getValue(),
						persList: me.gksc('ИП_S_PERSON').getValue()
					};
				},
				setValue: function (val) {
					me.gksc('ИП_S_ORGC').ksSetValue(val && val.orgList);
					me.gksc('ИП_S_PERSON').ksSetValue(val && val.persList);
				}
			}, baseCfg),
			ДЛ: Ext.apply({}, {
				name: 'ДЛ',
				componentKey: 'ДЛ_S_ORGC',
				isEmpty: function () {
					return me.ДЛ_S_ORGC.isEmpty() || me.ДЛ_S_PERSON.isEmpty();
				},
				createItems: function () {
					var cmp =
						me.createDictEdit({
								key: 'ДЛ_S_ORGC',
								mode: me.getMode(),
								parentView: me,
								controlName: 'DICTEDITOR_RevizEditView_dictOrgDL1', //todo странный профиль
								mainColumn: me.mainColumn,
								getRevizOneMain: getRevizOneMain,
								code: dnl.S_ORG,
								flex: 1,
								initWhereArgs: function () {
									return me.initWhereArgs(me.ДЛWhereArgs);
								},
								getRowClass: function (rec) {
									return me.getRowClass(rec);
								},
								ksAllowEmpty: me.ksAllowEmpty,
								ksSetValue: function (value) {
									if (!me.canChangeObjects.call(me.parentView, 'ДЛ', value))
										return;
									me.allObjsCfg.ДЛ.setOldValue(me.ДЛ_S_ORGC.getValue());
									me.ДЛ_S_ORGC.setValue(value);

									if (!value) {
										me.ДЛ_S_PERSON.setValue([]);
										me.triggerBtnEvent([], 'ДЛ_S_PERSON');
									}

									me.eventTROEdit('ДЛ', value, me.ДЛ_S_PERSON.getValue());
									me.triggerBtnEvent(value, 'ДЛ_S_ORGC');
								},
								beforeclear: function () {
									return me.canChangeObjects.call(me.parentView, 'ДЛ', []);
								},
								listCfg: getListCfg_IP_DL('ДЛ')
							},
							function (o) {
								o.handler = objsHandlers(o);
								return o;
							});

					overrideFieldCode(cmp);

					let res = [
						cmp,
						{xtype: 'splitter', border: 0},
						me.createDictEdit({
								key: 'ДЛ_S_PERSON',
								mode: me.getMode(),
								parentView: me,
								controlName: 'DICTEDITOR_RevizEditView_dictPersonDL',
								code: dnl.S_PERSON,
								nameField: 'SNAME',
								flex: 1,
								getRowClass: function (rec) {
									return me.getRowClass(rec);
								},
								ksAllowEmpty: false,
								ksSetValue: function (value) {
									let rowPerson = value && value.length ? value[0].data : null;

									let refreshDictPerson = function () {
										me.ДЛ_S_PERSON.setValue(value);
										me.eventTROEdit('ДЛ', _, value || []);
										me.triggerBtnEvent(value, 'ДЛ_S_PERSON');
									}

									if (!rowPerson) {
										refreshDictPerson();
										return;
									}
									
									rowPerson.SNAME = rowPerson.NAME = window.getTextByVisibleFields(dnl.S_PERSON, _, rowPerson);
									
									if (me.isLoading()){
										refreshDictPerson();
										return;
									}
									let personLinks = [];
									Ext.each(value, function (v) {
										personLinks.push(v.data.LINK);
									});
									me.getOrgByPerson(personLinks, 'ДЛ', me.ИПWhereArgs.NotInLinks.value).then(
										function (res) {
											let orgs = me.ДЛ_S_ORGC.getLinks();
											if (orgs.length) {
												Ext.each(value,
													function (v) {
														v.data.TLINK_SELF = res.personOrgs[v.data.LINK];
													});
												refreshDictPerson();
											} else {
												if (!res.orgData.length) return;
												Ext.each(res.orgData, function (o) {
													o.data.MAIN = true;
												});

												if (me.canChangeObjects.call(me.parentView, 'ДЛ', res.orgData)) {
													me.ДЛ_S_ORGC.setValue(res.orgData);
													me.eventTROEdit('ДЛ', res.orgData, value || [], true);
													me.triggerBtnEvent(value, 'ДЛ_S_ORGC');

													Ext.each(value,
														function (v) {
															v.data.TLINK_SELF = res.personOrgs[v.data.LINK];
														});
													refreshDictPerson();
												}
											}
										});
								},
								initWhereArgs: function () {
									let orgs = me.ДЛ_S_ORGC.getLinks();
									let whereArgs = orgs.length
										? {
											SOrgs: {value: JSON.stringify(orgs), type: 'List_int'}
										}
										: {
											DH1: {value: longPeriod.begin, type: 'Date'},
											DH2: {value: longPeriod.end, type: 'Date'},
											SRegions: {value: me.ДЛWhereArgs.Regions.value, type: 'List_int'},
											NotSOrgs: {value: me.ДЛWhereArgs.NotInLinks.value, type: 'List_int'},
											NotSTypeOrgs: {value: JSON.stringify(me.getIndivid()), type: 'List_int'}
										};
									return whereArgs;
								},
								getInputDicts: function () {
									let orgs = me.ДЛ_S_ORGC.getValue();
									return orgs.length
										? [Ext.create('InputEditDict', {name: 'S_ORG', data: orgs[0].data})]
										: [];
								}
							},
							function (o) {
								o.handler = objsHandlers(o);
								return o;
							})
					];
					overrideFieldCode(res[2]);
					return res;
				},
				returnOldValue: function () {
					me.ДЛ_S_ORGC.setValue(me.allObjsCfg.ДЛ.oldValue);
					me.ДЛ_S_PERSON.setValue([]);
				},
				setReadOnly: function (state) {
					me.gksc('ДЛ_S_ORGC').setReadOnly(state);
					me.gksc('ДЛ_S_PERSON').setReadOnly(state);
					me.triggerBtnHidden('ДЛ_S_ORGC', state);
					me.triggerBtnHidden('ДЛ_S_PERSON', state);
				},
				getValue: function () {
					return {
						orgList: me.gksc('ДЛ_S_ORGC').getValue(),
						persList: me.gksc('ДЛ_S_PERSON').getValue()
					};
				},
				setValue: function (val) {
					me.gksc('ДЛ_S_ORGC').ksSetValue(val && val.orgList);
					me.gksc('ДЛ_S_PERSON').setValue(val && val.persList);
				}
			}, baseCfg),
			ФЛ: Ext.apply({}, {
				name: 'ФЛ',
				componentKey: 'ФЛ_S_PERSON',
				createItems: function () {
					var cmp =
						me.createDictEdit({
								key: 'ФЛ_S_PERSON',
								mode: 'MULTI',
								nameField: 'SNAME',
								parentView: me,
								controlName: 'DICTEDITOR_RevizEditView_dictPersonFL',
								mainColumn: me.mainColumn,
								getRevizOneMain: getRevizOneMain,
								code: dnl.S_PERSON,
								flex: 1,
								ksAllowEmpty: me.ksAllowEmpty,
								ksSetValue: function (value) {
									if (!me.canChangeObjects.call(me.parentView, 'ФЛ', value))
										return;
									if (value) {
										for (var i = 0, len = value.length; i < len; i++) {
											value[i].data.SNAME = value[i].data.NAME = window.getTextByVisibleFields(dnl.S_PERSON, _, value[i].data);
										}
									}
									me.allObjsCfg.ФЛ.setOldValue(me.ФЛ_S_PERSON.getValue());
									me.ФЛ_S_PERSON.setValue(value);
									me.eventTROEdit('ФЛ', value);
									me.triggerBtnEvent(value, 'ФЛ_S_PERSON');
								},
								beforeclear: function () {
									return me.canChangeObjects.call(me.parentView, 'ФЛ', []);
								}
							},
							function (o) {
								o.handler = objsHandlers(o);
								return o;
							});

					overrideFieldCode(cmp);

					return [cmp];
				},
				getValue: function () {
					return {
						persList: me.gksc('ФЛ_S_PERSON').getValue()
					};
				},
				setValue: function (val) {
					me.gksc('ФЛ_S_PERSON').ksSetValue(val && val.persList);
				}
			}, baseCfg),
			НПА: Ext.apply({}, {
				name: 'НПА',
				componentKey: 'НПА_S_NPA',
				orgKey: 'S_NPA',
				createItems: function () {
					return [
						me.createDictEdit({
							key: 'НПА_S_NPA',
							mode: me.getMode(),
							parentView: me,
							mainColumn: me.mainColumn,
							getRevizOneMain: getRevizOneMain,
							code: dnl.S_NPA,
							flex: 1,
							ksAllowEmpty: me.ksAllowEmpty,
							ksSetValue: function (value) {
								if (!me.canChangeObjects.call(me.parentView, 'НПА', value))
									return;
								me.allObjsCfg.НПА.setOldValue(me.НПА_S_NPA.getValue());
								me.НПА_S_NPA.setValue(value);
								me.eventTROEdit('НПА', value);
							},
							beforeclear: function () {
								return me.canChangeObjects.call(me.parentView, 'НПА', []);
							}
						})
					];
				},
				getValue: function () {
					return {
						orgList: me.gksc('НПА_S_NPA').getValue()
					};
				},
				setValue: function (val) {
					me.gksc('НПА_S_NPA').ksSetValue(val && val.orgList);
				}
			}, baseCfg),
			КК: Ext.apply({}, {
				name: 'КК',
				componentKey: 'КК_S_KVARTAL',
				orgKey: 'S_KVARTAL',
				createItems: function () {
					return [
						me.createDictEdit({
							key: 'КК_S_KVARTAL',
							parentView: me,
							mainColumn: me.mainColumn,
							code: dnl.S_KVARTAL,
							getRevizOneMain: getRevizOneMain,
							flex: 1,
							ksAllowEmpty: me.ksAllowEmpty,
							ksSetValue: function (value) {
								if (!me.canChangeObjects.call(me.parentView, 'КК', value))
									return false;
								me.allObjsCfg.КК.setOldValue(me.КК_S_KVARTAL.getValue());
								me.КК_S_KVARTAL.setValue(value);
								me.eventTROEdit('КК', value);
							},
							beforeclear: function () {
								return me.canChangeObjects.call(me.parentView, 'КК', []);
							}
						})
					];
				},
				getValue: function () {
					return {
						orgList: me.gksc('КК_S_KVARTAL').getValue()
					};
				},
				setValue: function (val) {
					me.gksc('КК_S_KVARTAL').ksSetValue(val && val.orgList);
				}
			}, baseCfg),
			СП: Ext.apply({}, {
				name: 'СП',
				componentKey: 'СП_S_ORG',
				isEmpty: function () {
					return me.СП_S_ORG.isEmpty() || me.СП_S_OTDEL.isEmpty();
				},
				createItems: function () {
					return [
						me.createDictEdit({
							key: 'СП_S_ORG',
							mode: me.getMode(),
							mainColumn: me.mainColumn,
							getRevizOneMain: getRevizOneMain,
							parentView: me,
							initWhereArgs: function () {
								return me.initWhereArgs(me.СПWhereArgs);
							},
							code: dnl.S_ORG,
							flex: 1,
							listCfg: {
								beforeSetData: function (data, p) {
									this.callParent(arguments);
									me.beforeSetData();
								}
							},
							getRowClass: function (rec) {
								return me.getRowClass(rec);
							},
							ksAllowEmpty: me.ksAllowEmpty,
							ksSetValue: function (value) {
								if (!me.canChangeObjects.call(me.parentView, 'СП', value))
									return;

								var oldLinks = JSON.stringify(me.СП_S_ORG.getLinks());
								me.allObjsCfg.СП.setOldValue(me.СП_S_ORG.getValue());
								me.СП_S_ORG.setValue(value);

								if (oldLinks !== JSON.stringify(me.СП_S_ORG.getLinks())) me.СП_S_OTDEL.setValue([]);

								me.СП_S_OTDEL.setDisabled(me.СП_S_ORG.isEmpty());
								me.eventTROEdit('СП', value);
							},
							beforeclear: function () {
								return me.canChangeObjects.call(me.parentView, 'СП', []);
							}
						}),
						{xtype: 'splitter', border: 0},
						me.createDictEdit({
							key: 'СП_S_OTDEL',
							mode: 'MULTI',
							parentView: me,
							initWhereArgs: function () {
								return me.СП_S_OTDEL_WhereArgs;
							},
							getSOrg: function () {
								return me.gksc('СП_S_ORG').getValue();
							},
							code: dnl.S_OTDEL,
							flex: 1,
							ksAllowEmpty: me.ksAllowEmpty,
							ksSetValue: function (value) {

								var obj = me.getRevizObjects()[0];
								if (obj) Ext.each(value, function (val) {
									(val.data || val).LINK_SELF = obj.LINK;
									(val.data || val).TLINK_SELF = obj.TLINK;
								});

								let objsParent = me.getRevizObjects().filter(r => !r.LINK_SELF)
									.map(v => ({'LINK': v.TLINK, 'MAIN': v.MAIN}));
								if (!me.canChangeObjects.call(me.parentView, 'СП', objsParent, false, value || []))
									return;

								if (obj) {
									me.СП_S_OTDEL.setValue(value);
									me.eventTROEdit('СП', value);
								}
							},
							beforeclear: function () {
								let objsParent = me.getRevizObjects().filter(r => !r.LINK_SELF)
									.map(v => ({'LINK': v.TLINK, 'MAIN': v.MAIN}));
								return me.canChangeObjects.call(me.parentView, 'СП', objsParent, false, []);
							},
							getSOrg: function () {
								return me.СП_S_ORG.getLink();
							}
						})
					];
				},
				returnOldValue: function () {
					me.СП_S_ORG.setValue(me.allObjsCfg.СП.oldValue);
					me.СП_S_OTDEL.setValue([]);
				},
				setReadOnly: function (state) {
					me.gksc('СП_S_ORG').setReadOnly(state);
					me.gksc('СП_S_OTDEL').setReadOnly(state);
					me.triggerBtnHidden('СП_S_ORG', state);
					me.triggerBtnHidden('СП_S_OTDEL', state);
				},
				getValue: function () {
					return {
						orgList: me.gksc('СП_S_ORG').getValue(),
						otdList: me.gksc('СП_S_OTDEL').getValue()
					};
				},
				setValue: function (val) {
					me.gksc('СП_S_ORG').ksSetValue(val && val.orgList);
					me.gksc('СП_S_OTDEL').ksSetValue(val && val.otdList);
				}
			}, baseCfg),
			ЗУ: Ext.apply({}, {
				name: 'ЗУ',
				componentKey: 'ЗУ_S_LAND',
				orgKey: 'S_LAND',
				createItems: function () {
					return [
						me.createDictEdit({
							key: 'ЗУ_S_LAND',
							mode: 'MULTI',
							parentView: me,
							whereArgs: me.ЗУWhereArgs,
							mainColumn: me.mainColumn,
							getRevizOneMain: getRevizOneMain,
							code: dnl.S_LAND,
							flex: 1,
							ksAllowEmpty: me.ksAllowEmpty,
							ksSetValue: function (value) {
								me.allObjsCfg.ЗУ.setOldValue(me.ЗУ_S_LAND.getValue());
								me.ЗУ_S_LAND.setValue(value);
								me.eventTROEdit('ЗУ', value);
							}
						})
					];
				},
				getValue: function () {
					return {
						orgList: me.gksc('ЗУ_S_LAND').getValue()
					};
				},
				setValue: function (val) {
					me.gksc('ЗУ_S_LAND').ksSetValue(val && val.orgList);
				}
			}, baseCfg)
		};

		return me.allObjsCfg;
	},
	getOrgByPerson: function (personLinks, typeObj, notInLinksJSON) {
		return new Promise(function (resolve, reject) {
			ajaxRequest({
				url: 'SReviz/GetOrgByPerson_A',
				params: {personLinks: JSON.stringify(personLinks), typeObj: typeObj, notInLinks: notInLinksJSON},
				success: resolve,
				failure: reject
			});
		});
	},
	//#endregion Конфиги

	//#region Загрузка данных
	//tRevizObjsAccess - список доступных типов
	setObjsData: function (tRevizObjsAccess, type, orgWhereArgs) {
		var me = this,
			individ = me.getIndivid(),
			revizObjType = me.getRevizObjType();

		me.controlsArr = [];
		//Заполняем доступные типы
		for (t in tRevizObjsAccess) {
			if (tRevizObjsAccess[t]) me.controlsArr.push(t);
		}

		var revObj = me.getRevizObjects();
		// если создали из пункта плана, у которого объект занимает несколько полей(н-р, тип ИП),
		// то при первом ksSetValue все значения tRevizObjects, кроме первого, у которого линк = -1, затрутся. 
		// В итоге следующий ksSetValue создаст новую запись в tRevizObjects с линком -1, который уже занят.
		if (revObj.length > 1) {
			Ext.each(revObj, o => {
				if (o.LINK < 0) {
					me.tRevizObjectLink--;
					return false;
				}
			});
		}
		//Конвертируем данные в нужный формат
		var orgsData = me.convertOrgsData(revObj);

		//#region Задаем аргументы для объектов
		me.ИПWhereArgs = {};

		if (orgWhereArgs.Regions) {
			me.ИПWhereArgs.Regions = {
				value: JSON.stringify(orgWhereArgs.Regions),
				type: 'List_int'
			};
		}

		if (orgWhereArgs.NotInLinks) {
			me.ИПWhereArgs.NotInLinks = {
				value: JSON.stringify(orgWhereArgs.NotInLinks),
				type: 'List_int'
			};
		}

		if (orgWhereArgs.SMinvo) {
			me.ИПWhereArgs.SMinvo = {
				value: JSON.stringify(orgWhereArgs.SMinvo),
				type: 'List_int'
			};
		}

		if (orgWhereArgs.SWorks) {
			me.ИПWhereArgs.SWorks = {
				value: JSON.stringify(orgWhereArgs.SWorks),
				type: 'List_int'
			};
		}

		if (orgWhereArgs.NotSWorks) {
			me.ИПWhereArgs.NotSWorks = {
				value: JSON.stringify(orgWhereArgs.NotSWorks),
				type: 'List_int'
			};
		}

		//ИП
		me.ИПWhereArgs.DH1 = {
			value: new Date(orgWhereArgs.DH1).toDateString(),
			type: 'Date'
		};
		me.ИПWhereArgs.DH2 = {
			value: new Date(orgWhereArgs.DH2).toDateString(),
			type: 'Date'
		};
		me.ИПWhereArgs.HighlightOrgPred = {
			value: 'True',
			type: 'bool'
		};
		me.ИПWhereArgs.SType = {
			value: JSON.stringify(individ),
			type: 'List_int'
		};
		//ЮЛ
		me.ЮЛWhereArgs = jQuery.parseJSON(JSON.stringify(me.ИПWhereArgs));
		me.ЮЛWhereArgs.NotSType = me.ЮЛWhereArgs.SType;

		delete me.ЮЛWhereArgs.SType;
		//ДЛ
		me.ДЛWhereArgs = jQuery.parseJSON(JSON.stringify(me.ЮЛWhereArgs));
		//СП
		me.СПWhereArgs = jQuery.parseJSON(JSON.stringify(me.ЮЛWhereArgs));
		me.СПWhereArgs.SType = {
			value: JSON.stringify([1]),
			type: 'List_int'
		};
		//#endregion Задаем аргументы для объектов

		me.newObjsBtn.setVisible(me.isType);

		if (type) {
			for (t in revizObjType) {
				if (revizObjType[t] & type) {
					me.checkDelNewBtns(me.createObjsPanelControl(t), true);
				}
			}

			if (me.ЮЛ_S_ORGC) {
				me.ЮЛ_S_ORGC.ksSetValue(orgsData.юлOrgList);
			}

			if (me.ИП_S_ORGC) {
				me.ИП_S_ORGC.ksSetValue(orgsData.ипOrgList);
			}

			if (me.ИП_S_PERSON) {
				me.ИП_S_PERSON.ksSetValue(orgsData.ипPerson);
			}

			if (me.ФЛ_S_PERSON) {
				me.ФЛ_S_PERSON.ksSetValue(orgsData.флPerson);
			}

			if (me.ДЛ_S_ORGC) {
				me.ДЛ_S_ORGC.ksSetValue(orgsData.длOrgList);
			}

			if (me.ДЛ_S_PERSON) {
				me.ДЛ_S_PERSON.ksSetValue(orgsData.длPerson);
			}

			if (me.КК_S_KVARTAL) {
				me.КК_S_KVARTAL.ksSetValue(orgsData.ккOrgList);
			}

			if (me.СП_S_ORG) {
				me.СП_S_ORG.ksSetValue(orgsData.спOrgList);
				me.СП_S_OTDEL_WhereArgs = {};
				me.СП_S_OTDEL_WhereArgs.SOrgs = {
					value: JSON.stringify(me.СП_S_ORG.getLinks()),
					type: 'List_int'
				};
			}

			if (me.СП_S_OTDEL) {
				me.СП_S_OTDEL.ksSetValue(orgsData.спOtdelList);
			}

			if (me.ЗУ_S_LAND) {
				me.ЗУ_S_LAND.ksSetValue(orgsData.зуOrgList);
			}

			if (me.НПА_S_NPA) {
				me.НПА_S_NPA.ksSetValue(orgsData.нпаOrgList);
			}
		} else {
			me.checkDelNewBtns(me.createObjsPanelControl(), true);
		}

		if (!individ.length) {
			me.controlsArr.splice(1, 1);
		}
	},
	//Конвертация организаций в формат клиента
	convertOrgsData: function (value) {
		var me = this,
			revizObjType = me.getRevizObjType(),
			tro = ArrayLib.filter(value, ['LINK_SELF'], null),
			юлOrgList = [],
			ипOrgList = [],
			ипPerson = [],
			флPerson = [],
			длOrgList = [],
			длPerson = [],
			ккOrgList = [],
			зуOrgList = [],
			нпаOrgList = [],
			спOrgList = [],
			спOtdelList = [],
			iPos;

		for (var i = 0, len = tro.length; i < len; i++) {
			switch (tro[i].TYPE) {
				case revizObjType.ЮЛ:
					юлOrgList.push({
						data: {
							LINK: tro[i].TLINK,
							CODE: tro[i].TEMP_CODE,
							NAME: tro[i].TEMP_NAME,
							SNAME: tro[i].TEMP_SNAME,
							MAIN: !!tro[i].MAIN,
							INN: tro[i].TEMP_INN
						}
					});
					break;
				case revizObjType.ИП:
					ипOrgList.push({
						data: {
							LINK: tro[i].TLINK,
							CODE: tro[i].TEMP_CODE,
							NAME: tro[i].TEMP_NAME,
							SNAME: tro[i].TEMP_SNAME,
							MAIN: tro[i].MAIN
						}
					});
					iPos = ArrayLib.find(value, ['LINK_SELF'], tro[i].LINK);
					if (iPos !== -1) {
						ипPerson.push({
							data: {
								LINK: value[iPos].TLINK,
								CODE: value[iPos].TEMP_CODE,
								NAME: value[iPos].TEMP_NAME,
								SNAME: value[iPos].TEMP_SNAME,
								MAIN: value[iPos].MAIN,
								FIRSTNAME: value[iPos].FIRSTNAME,
								LASTNAME: value[iPos].LASTNAME,
								PATRONYMIC: value[iPos].PATRONYMIC,
								LINK_SELF: tro[i].LINK,
								TLINK_SELF: tro[i].TLINK
							}
						});
					}
					break;
				case revizObjType.ФЛ:
					флPerson.push({
						data: {
							LINK: tro[i].TLINK,
							CODE: tro[i].TEMP_CODE,
							NAME: tro[i].TEMP_NAME || tro[i].TEMP_SNAME,
							SNAME: tro[i].TEMP_SNAME,
							MAIN: tro[i].MAIN,
							FIRSTNAME: tro[i].FIRSTNAME,
							LASTNAME: tro[i].LASTNAME,
							PATRONYMIC: tro[i].PATRONYMIC
						}
					});
					break;
				case revizObjType.ДЛ:
					длOrgList.push({
						data: {
							LINK: tro[i].TLINK,
							CODE: tro[i].TEMP_CODE,
							NAME: tro[i].TEMP_NAME,
							SNAME: tro[i].TEMP_SNAME,
							MAIN: tro[i].MAIN
						}
					});
					iPos = ArrayLib.find(value, ['LINK_SELF'], tro[i].LINK);
					if (iPos !== -1) {
						длPerson.push({
							data: {
								LINK: value[iPos].TLINK,
								CODE: value[iPos].TEMP_CODE,
								NAME: value[iPos].TEMP_NAME,
								SNAME: value[iPos].TEMP_SNAME,
								MAIN: value[iPos].MAIN,
								FIRSTNAME: value[iPos].FIRSTNAME,
								LASTNAME: value[iPos].LASTNAME,
								PATRONYMIC: value[iPos].PATRONYMIC,
								LINK_SELF: tro[i].LINK,
								TLINK_SELF: tro[i].TLINK
							}
						});
					}
					break;
				case revizObjType.ЗУ:
					зуOrgList.push({
						data: {
							LINK: tro[i].TLINK,
							CODE: tro[i].TEMP_CODE,
							NAME: tro[i].TEMP_NAME,
							SNAME: tro[i].TEMP_SNAME,
							MAIN: tro[i].MAIN
						}
					});
					break;
				case revizObjType.КК:
					ккOrgList.push({
						data: {
							LINK: tro[i].TLINK,
							CODE: tro[i].TEMP_CODE,
							NAME: tro[i].TEMP_NAME,
							SNAME: tro[i].TEMP_SNAME,
							MAIN: tro[i].MAIN
						}
					});
					break;
				case revizObjType.НПА:
					нпаOrgList.push({
						data: {
							LINK: tro[i].TLINK,
							CODE: tro[i].TEMP_CODE,
							NAME: tro[i].TEMP_NAME,
							SNAME: tro[i].TEMP_SNAME,
							MAIN: tro[i].MAIN
						}
					});
					break;
				case revizObjType.СП:
					спOrgList.push({
						data: {
							LINK: tro[i].TLINK,
							CODE: tro[i].TEMP_CODE,
							NAME: tro[i].TEMP_NAME,
							SNAME: tro[i].TEMP_SNAME,
							MAIN: tro[i].MAIN
						}
					});

					var otdels = ArrayLib.filter(value, ['LINK_SELF'], tro[i].LINK);

					Ext.each(otdels, function (otdel) {
						спOtdelList.push({
							data: {
								LINK: otdel.TLINK,
								CODE: otdel.TEMP_CODE,
								NAME: otdel.TEMP_NAME,
								SNAME: otdel.TEMP_SNAME,
								MAIN: otdel.MAIN,
								LINK_SELF: tro[i].LINK,
								TLINK_SELF: tro[i].TLINK
							}
						});
					});

					break;
			}
		}
		;

		return {
			юлOrgList: юлOrgList,
			ипOrgList: ипOrgList,
			ипPerson: ипPerson,
			длOrgList: длOrgList,
			длPerson: длPerson,
			флPerson: флPerson,
			ккOrgList: ккOrgList,
			зуOrgList: зуOrgList,
			спOrgList: спOrgList,
			спOtdelList: спOtdelList,
			нпаOrgList: нпаOrgList
		};
	},
	//#endregion Загрузка данных

	//#region События, проверки
	//Disable|Enable кнопок новый|удалить объект
	checkDelNewBtns: function (value, isNew) {
		var me = this,
			itms = me.objsPanel.items.items,
			visibleEls = 0,
			i = 0,
			len = itms.length;

		for (i; i < len; i++) {
			if (itms[i].isVisible()) {
				visibleEls++;
			}
		}
		;

		var controlsLen = me.controlsArr.length;

		if (visibleEls > 1 || (isNew && len > 1)) {
			if (!isNew) me[value].hide();
			var needDisable = (visibleEls === 2 && !isNew);
			for (i = 0; i < controlsLen; i++) {
				var key = 'del' + me.controlsArr[i],
					el = me[key];
				if (el && !el.isHidden()) el?.setDisabled(needDisable);
			}
		} else {
			me['del' + value]?.setDisabled(true);
		}

		me.newObjsBtn?.setDisabled(visibleEls === controlsLen);
	},
	//Пересоздать данные для комбо с доступными типами объектов
	comboStoreReload: function () {
		var me = this,
			storeList = [],
			i,
			len = me.controlsArr.length;

		me.comboLoad = true;
		me.visibleObjs = [];

		for (i = 0; i < len; i++) {
			if (!me[me.controlsArr[i]] || me[me.controlsArr[i]].isHidden()) {
				storeList.push({field1: me.controlsArr[i]});
			}
		}

		for (i = 0; i < len; i++) {
			var name = 'combo' + me.controlsArr[i];
			if (me[name]) {
				me[name].getStore().loadData([{field1: me.controlsArr[i]}].concat(storeList), false);
				me[name].setValue(me.controlsArr[i]);
				if (!me[me.controlsArr[i]].isHidden()) me.visibleObjs.push(me.controlsArr[i]);
			}
		}

		me.comboLoad = false;
	},
	//отрабатывается после изменения объекта контроля. Формирует данные для грида "Проверяющие"
	eventTROEdit: function (controlName, value, personValue, ignoreProp) {
		var me = this,
			list = [],
			oldObjs = me.getRevizObjects(),
			revizObjType = me.getRevizObjType(),
			getRevizObject = function (type, objects, tables) {
				var get = function (lvl, linkSelf, tLinkSelf) {
					var old = ArrayLib.filter(ArrayLib.filter(ArrayLib.filter(oldObjs, ['TYPE'], type), ['LINK_SELF'], linkSelf), ['TTABLE'], tables[lvl]),
						result = [],
						next = lvl < objects.length - 1;

					for (var i = 0, os = objects[lvl], len = os.length; i < len; i++) {
						let LINK_SELF = objects[lvl][i].data ? objects[lvl][i].data.LINK_SELF : objects[lvl][i].LINK_SELF,
							TLINK_SELF = objects[lvl][i].data ? objects[lvl][i].data.TLINK_SELF : objects[lvl][i].TLINK_SELF,
							o = os[i].data ? os[i].data : os[i];
						
						if (LINK_SELF != linkSelf && TLINK_SELF != tLinkSelf) continue;
						var pos = ArrayLib.find(old, ['TLINK'], o.LINK),
							link;

						if (pos === -1) {
							link = me.tRevizObjectLink--;
							result.push({
								LINK: link,
								LINK_SELF: linkSelf,
								TTABLE: tables[lvl],
								TLINK: o.LINK,
								TLINK_SELF: tLinkSelf,
								TYPE: type,
								MAIN: o.MAIN,
								TEMP_INN: o.INN,
								TEMP_CODE: o.CODE,
								TEMP_NAME: o.NAME,
								TEMP_SNAME: o.SNAME
							});
						} else {
							link = old[pos].LINK;
							old[pos].MAIN = o.MAIN;
							old[pos].TEMP_INN = o.INN;
							old[pos].TEMP_CODE = o.CODE;
							if (old[pos].TTABLE === "S_PERSON"){
								old[pos].TEMP_NAME = old[pos].TEMP_SNAME = o.NAME = window.getTextByVisibleFields(dnl.S_PERSON, _, os[i].data ?? os[i]);
							}
							else {
								old[pos].TEMP_NAME = o.NAME;
								old[pos].TEMP_SNAME = o.SNAME;
							} 
							//if (!o.hasOwnProperty('MAIN')) o.MAIN = old[pos].MAIN;
							result.push(old[pos]);
						}

						if (next) {
							result = result.concat(get(lvl + 1, link, o.LINK));
						}
					}
					return result;
				};
				return get(0, null);
			};

		me.checkObjectsForReviz.call(me.parentView, value, revizObjType[controlName]);
		me.checkObjectsHistoryChange.call(me.parentView);
		if (!ignoreProp) {
			me.changeObjProp.call(me.parentView, value, personValue, oldObjs, revizObjType[controlName]);
		}

		Ext.each(me.visibleObjs, function (objName) {
			var values = [],
				keys = [],
				v;

			if (me[objName].isHidden()) return true;

			switch (objName) {
				case 'ЮЛ':
				case 'ЗУ':
				case 'НПА':
				case 'КК':
					values = [me[objName].getValue().orgList];
					keys = [me[objName].orgKey];
					break;
				case 'ИП':
				case 'ДЛ':
					v = me[objName].getValue();
					values = [v.orgList, v.persList];
					keys = [me[objName].orgKey, me[objName].personKey];
					break;
				case 'ФЛ':
					values = [me[objName].getValue().persList];
					keys = [me[objName].personKey];
					break;
				case 'СП':
					v = me[objName].getValue();
					values = [v.orgList, v.otdList];
					keys = [me[objName].orgKey, 'S_OTDEL'];
					me.СП_S_OTDEL_WhereArgs = {};
					me.СП_S_OTDEL_WhereArgs.SOrgs = {
						value: JSON.stringify(me.СП_S_ORG.getLinks()),
						type: 'List_int'
					};
					break;
				default:
			}

			list = list.concat(getRevizObject(revizObjType[objName], values, keys));
		});

		me.setRevizObjects(list);

		//вынесла в CanChangeObjects
		//if (me.mainColumn && !me.parentView.isLoaded && me.getRevizOneMain() && me.thereMainObj.call(me.parentView) > 1) {
		//	warning(wmc.get('RevizOneMain'));
		//	me.getAllObjsCfg()[controlName].returnOldValue(controlName);
		//	me.setRevizObjects(oldObjs);
		//	return _;
		//}

		me.afterTROEdit(list, oldObjs);
		me.parentView.ksControls.revizObjs_Dict.refresh();

		return list;
	},
	//проверить на наличие филиалов. если есть, спросить и при согласии заменить
	checkForFilials: function (value, item, controlName, callback) {
		if (value === _) return;
		
		var me = item;
		if (value && value.length && !me.parentView.isLoaded && controlName === "ЮЛ") {
			var objOrgs = [];
			for (i = 0, len = value.length; i < len; i++) {
				objOrgs.push(value[i].data ? value[i].data.LINK : value[i].LINK);
			}
			ajaxRequest({
				ignoreError: true,
				url: 'SOrg/GetFilialsWithParents_A',
				timeout: 5000,
				params: {
					links: objOrgs
				},
				success: function (val) {
					var changingVal = value;
					var msgAsk = val.msgList[0] + '\nЗаменить филиалы на головные организации?';
					var replacePairs = val.replacePairs; // заменяющий-заменяемый
					var newRows = val.newRows;
					var replace = function (replacePairs, newRows) {
						Ext.each(newRows,
							function (nR) {
								if (nR.LINK in replacePairs) {
									var row = changingVal.filter(function (item) {
										return item.data.LINK === replacePairs[nR.LINK];
									});
									row[0].data.LINK = nR.LINK;
									row[0].data.LINK_SELF = nR.LINK_SELF;
									row[0].data.TYPE = nR.TYPE;
									row[0].data.INN = nR.INN;
									row[0].data.CODE = nR.CODE;
									row[0].data.NAME = nR.NAME;
									row[0].data.SNAME = nR.SNAME;
								}
							});

					}
					if (Object.keys(replacePairs).length > 0 && msgAsk[0].length > 0) {
						Ext.Msg.show({
							title: 'Заменить филиалы на головные организации?',
							buttons: Ext.MessageBox.YESNO,
							buttonText: {yes: 'Да', no: 'Нет'},
							msg: msgAsk,
							fn: function (buttonId) {
								if (buttonId === 'yes') {
									replace(replacePairs, newRows);
								}
								callback(value, item);
							},
							icon: Ext.MessageBox.QUESTION
						});
					} else {
						callback(value, item);
					}
				}
			});
		} else
			callback(value, item);
	},
	checkValue: function (value) {

	},
	//необходимые действия при установке значения в орг-объект. должны выполниться только после замены/не_замены филиалов, поэтому вынесено и впихнуто в колбэк
	continueSetValue: function (value, item) {
		var me = item;
		me.allObjsCfg.ЮЛ.setOldValue(me.ЮЛ_S_ORGC.getValue());
		me.ЮЛ_S_ORGC.setValue(value);
		me.eventTROEdit('ЮЛ', value);
		me.triggerBtnEvent(value, 'ЮЛ_S_ORGC');
	},
	afterTROEdit: function (newObjects, oldObjects) {
		var me = this,
			oldT = me.getRevizAudit(),
			pos,
			res = ArrayLib.copy(oldT),
			addObjs = [],
			delObjs = ArrayLib.copy(oldObjects);

		Ext.each(newObjects, function (newObj) {
			pos = ArrayLib.find(res, [me.troField], newObj.LINK);
			if (pos === -1) {
				if (!newObj.LINK_SELF) addObjs.push(newObj);
			} else {
				res[pos].MAIN = newObj.MAIN;
				pos = ArrayLib.find(delObjs, ['LINK'], newObj.LINK);
				delObjs.splice(pos, 1);
			}
		});

		Ext.each(delObjs, function (delObj) {
			Ext.each(ArrayLib.filter(res, [me.troField], delObj.LINK), function (delRow) {
				ArrayLib.remove(res, delRow);
			});
		});

		var nullsList = ArrayLib.filter(res, [me.troField], null);

		Ext.each(addObjs, function (addObj) {
			Ext.each(me.getS_ORGP_Grid().store.getLinks(), function (orgpLink) {
				var c = ArrayLib.filter(ArrayLib.filter(res, ['S_ORG'], orgpLink), [me.troField], addObj.LINK);
				if (!c.length) {
					res.push({
						LINK: me.getRevizAuditLink(),
						MAIN: addObj.MAIN,
						S_ORG: orgpLink
					});
					res[res.length - 1][me.troField] = addObj.LINK;
				}

				var rem = ArrayLib.filter(nullsList, ['S_ORG'], orgpLink);
				if (rem.length) {
					ArrayLib.remove(nullsList, rem[0]);
					ArrayLib.remove(res, rem[0]);
				}
			});
		});

		me.setRevizAudit(res);
		me.eventTRAEdit();
	},
	eventTRAEdit: function () {
		let me = this,
			links = me.getS_ORGP_Grid().store.getLinks();

		if (!me.getRevizSelf()) {
			me.ИПWhereArgs.NotInLinks.value = JSON.stringify(links);
			me.ЮЛWhereArgs.NotInLinks.value = me.ИПWhereArgs.NotInLinks.value;
			me.ДЛWhereArgs.NotInLinks.value = me.ИПWhereArgs.NotInLinks.value;
		}

		
		if (!me.isLoading()) {
			ajaxRequest({
				ignoreError: true,
				url: 'SOrg/GetRegionsByOrgs_A',
				timeout: 5000,
				params: {
					links
				},
				success: function (value) {
					me.ИПWhereArgs.Regions.value = JSON.stringify(value);
					me.ЮЛWhereArgs.Regions.value = me.ИПWhereArgs.Regions.value;
					me.ДЛWhereArgs.Regions.value = me.ИПWhereArgs.Regions.value;
				}
			});
		}
	},
	//Возвращает количество главных объектов
	thereMainObj: Ext.emptyFn,
	//#endregion События, проверки

	//#region Base.Abstract методы
	setReadOnly: function (state) {
		var me = this;

		me.readOnly = state;
		me[state ? 'addCls' : 'removeCls']('ks-readOnly');

		Ext.each(me.readOnlyList, function (name) {
			me[name] && me[name].setReadOnly && me[name].setReadOnly(state);
		});

		Ext.each(me.arrDisable, function (name) {
			me[name] && me[name].setDisabled && me[name].setDisabled(state);
		});
	},
	setKsControl: function (key, control) {
		return this[key] = control;
	},
	getKsControl: function (key) {
		var me = this;
		if (me[key]) return me[key];
	},
	//#endregion Base.Abstract методы

	//by override
	checkObjectsForReviz: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	setRevizObjects: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	setRevizAudit: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	getMode: function () {
		return 'MULTI';
	},

	//by override
	getRevizOneMain: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	getIndivid: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	getRevizObjects: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	getRevizAudit: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	getRevizObjType: function () {
		throw new Error(wmc.get('NeedOverride'));
		return [];
	},

	//by override
	getRevizSelf: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	getS_ORGP_Grid: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	getRevizAuditLink: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	getDT: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	checkObjectsHistoryChange: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	//by override
	changeObjProp: function () {
		throw new Error(wmc.get('NeedOverride'));
		return 0;
	},

	canChangeObjects: function () {
		return true;
	},
	beforeSetData: function () {
	},
	initWhereArgs: function (baseWhereArgs) {
		return baseWhereArgs;
	}
});

//Контрол для выбора цвета
Ext.define('Keysystems.form.field.Color', {
	extend: 'Ext.ux.colorpick.Field',
	alias: 'widget.colorfield',
	triggerCls: 'x_btn_form-changes-gz x-dict-trigger',
	enableKeyEvents: true,
	format: 'rgb',
	userCls: 'rks-colorpicker',
	editable: true,
	initComponent: function () {
		var me = this,
			result = me.callParent(arguments);

		me.on('keypress', function (f, e) {
			var ch = String.fromCharCode(e.getKey());
			if (!/[0-9,a-f,A-F,#]/.test(ch)) e.preventDefault();
		});

		me.on('change', function (f, v) {
			if (!f.beforeChange) {
				f.beforeChange = 1;
				var s = '',
					l = v.length;
				for (var i = 0; i < l; i++) if (/[0-9,a-f,A-F,#]/.test(v[i])) s += v[i];
				if (s !== v) f.setValue(s);
				f.beforeChange = 0;
			}
		});

		return result;
	},

	createPicker: function () {
		var me = this;
		return Ext.create('Ext.window.Window', {
			layout: {type: 'vbox', align: 'stretch'},
			//width: 200,
			resizable: false,
			closable: false,
			header: false,
			flex: 1,
			border: 0,
			items: Ext.create('Ext.picker.Color', {
				pickerField: me,
				ownerCt: me.ownerCt,
				focusOnShow: true,
				addColors: ['38B8BF'],
				initComponent: function () {
					this.colors = this.colors.concat(this.addColors);
					return this.callParent(arguments);
				},
				listeners: {
					select: function () {
						if (!this.isExp) this.pickerField.collapse();
					}
				}
			})
		});
	},

	setValue: function (val) {
		if (this.mode10 && val && val[0] === '#') {
			val = val.split(/^#(\w{2})(\w{2})(\w{2})/g).splice(1, 3).map(function (c) {
				return parseInt(c, 16);
			}).toString(',');
		}
		return this.callParent([val]);
	},
	onExpand: function () {
	},
	onCollapse: function () {
		let me = this,
			p = me.getPicker().items.items[0],
			color = me.hexToRgb(p.getValue());
		let rgb = Ext.String.format('rgb({0},{1},{2})', color.r, color.g, color.b);
		me.setColor(rgb);
	},
	hexToRgb: function (hex) {
		let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
		return result ? {
			r: parseInt(result[1], 16),
			g: parseInt(result[2], 16),
			b: parseInt(result[3], 16)
		} : null;
	}
});

//Форма настройки автонумерации
Ext.define('Keysystems.AutoNumeric.Edit', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	layout: {type: 'vbox', align: 'stretch'},
	title: 'Автонумерация',
	isWindow: true,
	flex: 1,
	f: 'edit',
	labelWidth: 150,
	viewMinSize: [500, 50],

	initComponent: function () {
		let me = this;

		me.beforeInitComponent();
		me.baseInitComponent();
		me.callParent(arguments);
		me.afterInitComponent();
	},

	createItems: function () {
		let me = this;
		return me.callParent([
			[
				me.sksc('MASK', Ext.create('Keysystems.Controls.Formula.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Маска'
				})),
				me.sksc('NumVal', Ext.create('Ext.form.field.Number', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Текущий номер'
				}))
			]
		]);
	},

	dataCollector: function () {
		let value = {mask: this.gksc('MASK').getValue(), numVal: this.gksc('NumVal').getValue()}
		return value;
	},
	baseSaveData: Ext.emptyFn,
	loadCopyEditData: Ext.emptyFn,
	isFilled: () => true,
	getExtra: function (callback) {
		let me = this;
		me.gksc('MASK').setValue(me.value.mask);
		me.gksc('NumVal').setValue(me.value.numVal);
		callback && callback();
	},

	getWindowCfg: function () {
		let res = this.callParent(arguments);
		res.resizable = false;
		res.maximizable = false;
		return res;
	}
});

//Форма настройки автонумерации ИКМ
Ext.define('Keysystems.AutoNumericIKM.Edit', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	layout: {type: 'vbox', align: 'stretch'},
	title: 'Автонумерация',
	isWindow: true,
	flex: 1,
	f: 'edit',
	labelWidth: 220,
	viewMinSize: [600, 50],

	initComponent: function() {
		let me = this;

		me.beforeInitComponent();
		me.baseInitComponent();
		me.callParent(arguments);
		me.afterInitComponent();
	},

	createItems: function() {
		let me = this;
		return me.callParent([
			[
				me.MASK = Ext.create('Keysystems.Controls.Formula.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Маска'
				}),
				me.S_ORG = me.createDictEdit({
					key: 'S_ORG',
					mode: 'SINGL',
					ksAllowEmpty: true,
					code: dnl.S_ORG,
					whereArgs: {SType: {value: JSON.stringify([1]), type: 'List_int'}},
					fieldLabel: 'Проверяющая организация'
				}),
				me.NUMVAL = Ext.create('Ext.form.field.Number', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Текущий номер'
				})
			]
		]);
	},

	dataCollector: function() {
		let me = this,
			sOrg = me.S_ORG.getValue();
		const v = {
			mask: me.MASK.getValue(),
			numVal: me.NUMVAL.getValue(),
			sOrg: sOrg.length ? sOrg[0] : null,
		};
		return v;
	},
	baseSaveData: Ext.emptyFn,
	loadCopyEditData: Ext.emptyFn,
	isFilled: () => true,
	getExtra: function(callback) {
		let me = this;
		me.MASK.setValue(me.value.mask);
		me.S_ORG.setValue(me.value.sOrg);
		me.NUMVAL.setValue(me.value.numVal);
		callback && callback();
	},

	getWindowCfg: function() {
		let res = this.callParent(arguments);
		res.resizable = false;
		res.maximizable = false;
		return res;
	}
});

//Форма изменения порядка строк
Ext.define('Keysystems.Panel.ReferOrd', {
	extend: 'Ext.grid.Panel',
	mixins: ['Keysystems.Base.Edit'],
	autoScroll: true,
	autoRender: true,
	flex: 1,
	border: 0,
	bodyPadding: 0,
	columns: [],
	columnLines: true,
	isWindow: true,

	initKsControls: function () {
		var me = this;

		if (!me.store) {
			me.store = Ext.create('Ext.data.Store', {
				fields: [],
				data: [],
				proxy: 'memory',
				sorters: ['ORD']
			});
		}
	},

	initComponent: function () {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();
		me.callParent(arguments);
		me.afterInitComponent();
	},

	initEvents: function () {
		var me = this;
		me.callParent(arguments);
		me.on('selectionchange', me.onSelectionChange.bind(me));
	},

	dataCollector: function () {
		return this.store.getDataExt();
	},
	baseSaveData: Ext.emptyFn,
	loadCopyEditData: Ext.emptyFn,
	isFilled: () => true,
	getExtra: function (callback) {
		callback && callback();
	},

	loadData: function (d) {
		var me = this;
		if (Ext.isArray(d)) Ext.grid.Panel.prototype.loadData.apply(me, arguments);
		else Keysystems.Base.Edit.prototype.loadData.apply(me, arguments);
	},

	onSelectionChange: function (th, sels) {
		var me = this,
			rec = sels[0];

		if (me.readOnly) return;
		if (rec) {
			var ord = rec.get('ORD'),
				maxOrd = me.store.count() - 1;

			me.gksc('tsbTopProp').setDisabled(!ord);
			me.gksc('tsbUpProp').setDisabled(!ord);
			me.gksc('tsbDownProp').setDisabled(ord === maxOrd);
			me.gksc('tsbBottomProp').setDisabled(ord === maxOrd);
		}
	},

	createTBar: function () {
		var me = this,
			res = me.callParent(arguments);
		res.push(
			'-',
			me.sksc('tsbDict', Ext.create('Ext.Button', {
				iconCls: 'x_btn_dict',
				tooltip: me.title,
				tooltipType: 'title',
				handler: function () {
					var selectLinks = [];
					me.store.each(function (r) {
						selectLinks.push({data: {LINK: r.get('LINK')}});
					});

					dictFunc({
						mode: 'MULTI',
						parentView: me,
						selectLinks: selectLinks,
						code: me.code
					}, {
						ok: function (v) {
							var res = [],
								i = 0,
								links = ArrayLib.getLinks();
							v = v.concat();
							me.store.each(function (r) {
								var pos = links.indexOf(r.get('LINK'));
								if (pos !== -1) {
									var d = r.getData();
									d.ORD = i++;
									res.push(d);
									links.splice(pos, 1);
									v.splice(pos, 1);
								}
							});

							v.length && Ext.each(v, function (r) {
								var d = r.getData();
								d.ORD = i++;
								res.push(d);
							});

							me.loadData(res, false);
						}
					});
				}
			})),
			me.sksc('tsbTopProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_top',
				tooltip: 'В начало',
				tooltipType: 'title',
				disabled: true,
				handler: function () {
					me.moveRec(_, 0);
				}
			})),
			me.sksc('tsbUpProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_up',
				tooltip: 'Вверх',
				tooltipType: 'title',
				disabled: true,
				handler: function () {
					me.moveRec(-1);
				}
			})),
			me.sksc('tsbDownProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_down',
				tooltip: 'Вниз',
				tooltipType: 'title',
				disabled: true,
				handler: function () {
					me.moveRec(1);
				}
			})),
			me.sksc('tsbBottomProp', Ext.create('Ext.Button', {
				iconCls: 'x_btn_bottom',
				tooltip: 'В конец',
				tooltipType: 'title',
				disabled: true,
				handler: function () {
					me.moveRec(_, me.store.count() - 1);
				}
			})));

		return res;
	},

	moveRec: function (d, pos) {
		var me = this,
			rec = me.getFrstSelect();
		if (rec) {
			var ord = rec.get('ORD');
			if (pos === _) {
				pos = ord + d;

				var swapRec = me.store.getRecord(pos, 'ORD');
				if (swapRec) swapRec.set('ORD', ord);
			} else {
				me.store.each(pos < ord
					? function (el) {
						if (el.get('ORD') < ord) el.set('ORD', el.get('ORD') + 1);
					}
					: function (el) {
						if (el.get('ORD') > ord) el.set('ORD', el.get('ORD') - 1);
					}
				);
			}
			rec.set('ORD', pos);
			me.store.sort('ORD', 'ASC');
			me.onSelectionChange(me, [rec]);
		}
	}
});

//Форма настройки цветовые риски
Ext.define('Keysystems.RiskColor.Edit', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	layout: {type: 'hbox'},
	title: 'Цветовые обозначения',
	isWindow: true,
	flex: 1,
	f: 'edit',
	labelWidth: 75,
	viewMinSize: [485, 30],

	initComponent: function () {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();
		me.callParent(arguments);
		me.afterInitComponent();
	},

	createItems: function () {
		var me = this;
		return me.callParent([
			[
				me.sksc('num_begin', Ext.create('Ext.form.field.Number', {
					labelWidth: me.labelWidth,
					width: 100 + me.labelWidth,
					fieldLabel: 'Диапазон'
				})),
				me.sksc('num_end', Ext.create('Ext.form.field.Number', {
					labelWidth: 15,
					labelSeparator: '',
					width: 115,
					padding: '0 0 0 3',
					labelPad: 0,
					fieldLabel: '...'
				})),
				me.sksc('color', Ext.create('Keysystems.form.field.Color', {
					padding: '0 0 0 5',
					mode10: true,
					width: 165,
				}))
			]
		]);
	},

	dataCollector: function () {
		var me = this;
		return me.gksc('num_begin').getValue() + ';' + me.gksc('num_end').getValue() + ';' + me.gksc('color').getValue();
	},
	baseSaveData: Ext.emptyFn,
	loadCopyEditData: Ext.emptyFn,
	isFilled: () => true,
	getExtra: function (callback) {
		var me = this,
			a = me.value.split(';');
		me.gksc('num_begin').setValue(a[0]);
		me.gksc('num_end').setValue(a[1]);
		me.gksc('color').setValue(a[2]);
		callback && callback();
	},

	getWindowCfg: function () {
		var res = this.callParent(arguments);
		res.resizable = false;
		res.maximizable = false;
		return res;
	}
});

Ext.define('Keysystems.FinManDaysBox.Edit', {
	extend: 'Ext.grid.Panel',
	mixins: ['Keysystems.Base.Edit'],
	isWindow: true,
	flex: 1,
	f: 'edit',
	viewMinSize: [500, 300],
	bodyPadding: 0,
	columnLines: true,

	initKsControls: function () {
		var me = this;

		me.plugins = [Ext.create('Ext.grid.plugin.CellEditing', {clicksToEdit: 1})];

		if (!me.columns) {
			me.columns = [
				{
					dataIndex: 'field1',
					text: 'Мин.финансирование',
					flex: 2,
					editor: {
						xtype: 'calcfield',
						fieldLabel: '',
						getValue: function () {
							return this.rawToValue(this.processRawValue(this.getRawValue()));
						}
					}
				},
				{
					dataIndex: 'field2',
					text: 'Чел.дн',
					flex: 1,
					editor: {
						xtype: 'calcfield',
						fieldLabel: '',
						getValue: function () {
							return this.rawToValue(this.processRawValue(this.getRawValue()));
						}
					}
				}
			];
		}
		if (!me.fields) me.fields = ['field1', 'field2'];

		if (!me.store) {
			me.store = Ext.create('Ext.data.Store', {
				fields: me.fields,
				data: [],
				proxy: 'memory'
			});
		}
	},

	initComponent: function () {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();
		me.callParent(arguments);
		me.afterInitComponent();
	},

	dataCollector: function () {
		var res = [];
		this.store.each(function (rec) {
			if (rec.data.field1 || rec.data.field2) res.push(rec.data.field1 + ':' + rec.data.field2);
		});
		return res.join(';');
	},
	baseSaveData: Ext.emptyFn,
	loadCopyEditData: Ext.emptyFn,
	isFilled: () => true,
	getExtra: function (callback) {
		var me = this,
			d = [];

		Ext.each(me.value.split(';'), function (v) {
			v = v.split(':');
			d.push({field1: v[0], field2: v[1]});
		});

		me.store.loadData(d, false);

		me.plugins[0].initFieldAccessors(me.getTopLevelColumnManager().getColumns());

		callback && callback();
	},

	getWindowCfg: function () {
		var res = this.callParent(arguments);
		res.resizable = false;
		res.maximizable = false;
		return res;
	}
});

Ext.define('Keysystems.TaskDocVidsBox.Edit', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	isWindow: true,
	flex: 1,
	f: 'edit',
	layout: {type: 'vbox', align: 'stretch'},
	viewMinSize: [600, 30],
	border: 0,
	docVidsKey: '',
	docVidsStore: {
		NASTR_OBJECTIONACT_DOCVID: [
			{key: 'ACT', fieldLabel: 'Акт'},
			{key: 'OBJECTIONT', fieldLabel: 'Возражения по акту'}
		],
		NASTR_DOCREVIZ_DOCVID: [
			{key: 'PLAN', fieldLabel: 'План'},
			{key: 'REPORT', fieldLabel: 'Отчет'},
			{key: 'DOC', fieldLabel: 'Документ'}
		]
	},

	initComponent: function () {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();
		me.callParent(arguments);
		me.afterInitComponent();
	},

	createItems: function () {
		var me = this,
			items = [
				me.createDictEdit({
					key: 'S_TASK',
					mode: 'SINGL',
					ksAllowEmpty: true,
					code: dnl.S_TASK,
					fieldLabel: 'Регламент',
					listeners: {
						change: function () {
							var d = me.items.items[1];
							d.setDisabled(this.isEmpty());
							d.setValue();
						}
					}
				})
			];

		Ext.each(me.docVidsStore[me.docVidsKey] || me.docVids || [], function (dv, i, arr) {
			var nextDv = arr[i + 1],
				c = me.createDictEdit(
					Ext.apply({
						mode: me.docVidMode,
						ksAllowEmpty: true,
						code: dnl.S_DOCVID,
						disabled: true,
						initWhereArgs: function () {
							return {
								STask: {value: me.gksc('S_TASK').getLinks(1), type: 'List_int'},
								InLinks: i ? {value: dv.InLinks, type: 'List_int'} : _,
								InLinksOnly: i ? {value: 'True', type: 'bool'} : _
							};
						},
						getNextDocVid: function () {
							var link = this.getLink();
							if (link) nextDv.nextDocVidPromise = me.getNextDocVid(me.gksc('S_TASK').getLink(), link);
							nextDv.selfObject.setDisabled(!link);
							nextDv.selfObject.setValue();
						},
						listeners: nextDv ? {
							change: function () {
								this.getNextDocVid();
							}
						} : _
					}, dv),
					i ? function (o) {
						var oldHandler = o.handler;
						o.handler = function () {
							const loadMask = new Ext.LoadMask({
								msg: KS.L10n.loading_data,
								target: me,
								autoShow: true
							});
							dv.nextDocVidPromise.then(function (links) {
								loadMask.destroy();
								dv.InLinks = JSON.stringify(links);
								oldHandler();
							});
						};
						return o;
					} : _
				);
			dv.selfObject = c;
			items.push(c);
		});

		return me.callParent([items]);
	},
	getNextDocVid: function (task, docvid) {
		return new Promise(function (resolve, reject) {
			ajaxRequest({
				url: 'STask/GetNextDocVid_A',
				params: {sTask: task, sDocVid: docvid},
				success: resolve,
				failure: reject
			});
		});
	},

	dataCollector: function () {
		var me = this, res = [];
		me.items.each(function (el) {
			if (!el.isEmpty()) res.push(el.getValue().map(val => val.data ?? val));
		});
		//res.toJSON = function() { return ArrayLib.getLinks(this); };
		res.toJSON = Keysystems.Controls.Dict.Edit.prototype.dictToJSON;
		return res;
	},
	baseSaveData: Ext.emptyFn,
	loadCopyEditData: Ext.emptyFn,
	isFilled: function () {
		var me = this,
			allEmpty = 1,
			empty;

		me.items.each(function (el) {
			var e = el.isEmpty();
			if (allEmpty && !e) allEmpty = 0;
			if (!empty && e) empty = el;
		});

		if (!allEmpty && empty) {
			me.addToInvalidControls(empty);
			return false;
		}

		return true;
	},
	getExtra: function (callback) {
		var me = this,
			v = me.value;
		if (v) {
			v = JSON.parse(v);
			me.items.each(function (el, i) {
				el.setValue(v[i]);
			});
		}
		callback && callback();
	},

	getWindowCfg: function () {
		var res = this.callParent(arguments);
		res.resizable = false;
		res.maximizable = false;
		return res;
	}
}),
//
	Ext.define('Keysystems.PlanModInfo',
		{
			extend: 'Ext.form.FieldContainer',
			mixins: ['Keysystems.Base.Abstract'],
			layout: {type: 'vbox', align: 'stretch'},
			code: '',
			isCentralFK: false,
			osnovType: '',
			limitOsnov: null,
			limitLinks: [],
			modeType: 'None',
			excludeLinks: [],
			smosnovChanged: Ext.emptyFn,
			smosnovAllowEmpty: false,
			commentAllowEmpty: false,
			commentLabel: 'Комментарий',
			commentPadding: '0 0 0 0',

			initComponent: function () {
				var me = this;

				me.beforeInitComponent();
				me.items = [
					me.createDictEdit({
						key: 'S_MOSNOV',
						mode: 'MULTI',
						code: dnl.S_MOSNOV,
						fieldLabel: 'Основание изменений',
						ksAllowEmpty: me.smosnovAllowEmpty,
						initWhereArgs: function () {
							var inLinksOnly = false,
								inLinks = [],
								notInLinks = me.osnovWA.notInLinks;

							if (me.osnovType === "PlanRevizOsnov") {
								if (me.isCentralFK) {
									// ограничение настройкой "Исключено из Плана-графика ФК"
									if (me.modType === 'Edit') {
										notInLinks = notInLinks.concat(me.excludeLinks);
									} else if (me.modType === 'Delete') {
										inLinksOnly = true;
										inLinks = me.excludeLinks;
									}
								} else {
									// ограничение настройкой "Не требующие согласования"
									if (me.limitOsnov !== null) {
										if (me.limitOsnov) {
											// только из настройки
											inLinks = me.limitLinks;
											inLinksOnly = true;
											notInLinks = [];
										} else {
											// всё, кроме из настройки
											inLinks = [];
											inLinksOnly = false;
											notInLinks = me.limitLinks;
										}

									} else {
										// ничем не ограничиваем
										inLinks = [];
										inLinksOnly = false;
										notInLinks = [];
									}
								}
							}

							return {
								NotInLinks: {value: JSON.stringify(notInLinks), type: 'List_int'},
								InLinksOnly: {value: inLinksOnly, type: 'bool'},
								InLinks: {value: JSON.stringify(inLinks), type: 'List_int'},
								OsnovType: {value: me.osnovType, type: 'OsnovType'},
								PlanRazdel: {value: me.osnovWA.planRazdel, type: 'int'},
								OrgsP: {value: JSON.stringify(me.osnovWA.orgsP), type: 'List_int'}
							}
						},
						listeners: {
							change: function (th, newVal) {
								me.smosnovChanged(th, newVal);
							}
						}
					}),
					me.sksc('comment', Ext.create('Ext.form.field.TextArea', {
						fieldLabel: me.commentLabel,
						labelWidth: me.labelWidth,
						padding: me.commentPadding,
						maxLength: 1000,
						ksAllowEmpty: me.commentAllowEmpty
					})),
					[
						me.sksc('number', Ext.create('Ext.form.field.Text', {
							fieldLabel: '№ изменений',
							labelWidth: me.labelWidth,
							height: 22,
							width: 194,
							readOnly: true,
							padding: '0 0 2 0'
						})),
						me.sksc('rect', Ext.create('Ext.form.field.Text', {
							fieldLabel: '№ уточнений',
							labelWidth: 100,
							height: 22,
							width: 144,
							hidden: true, // элемент для Плана ФК
							readOnly: true,
							padding: '0 0 0 20'
						})),
						me.sksc('dtAgree', Ext.create('Ext.form.field.Date', {
							width: 210,
							padding: '0 0 0 20',
							labelWidth: 125,
							fieldLabel: 'Дата согласования',
							readOnly: true
						})),
						me.sksc('dtUtv', Ext.create('Ext.form.field.Date', {
							width: 250,
							padding: '0 0 0 20',
							labelWidth: 125,
							fieldLabel: 'Дата утверждения'//,
							//readOnly: true
						}))
					]
				];

				me.callParent(arguments);
			},
			setValue: function (value) {
				if (!value) return;

				var me = this;
				me.code = value.codeName;
				me.isCentralFK = value.isCentralFK;
				me.osnovWA = value.osnovWA;
				me.limitOsnov = value.limitOsnov;
				me.limitLinks = value.limitLinks;
				me.modType = value.modType;
				me.excludeLinks = value.excludeLinks;
				me.osnovType = value.codeName === "PLANCENTRAL"
					? 'PlanCentralOsnov'
					: value.codeName === "PLANREVIZ"
						? 'PlanRevizOsnov'
						: value.codeName === "IFC_RECORD"
							? 'IfcRecordOsnov'
							: 'None';

				me.gksc('S_MOSNOV').setValue(value.osnov);

				me.gksc('comment').setValue(value.comment);

				me.gksc('number').setValue(value.proj.NUMBER);
				if (value.proj.NUMBER_RECTIFICATION) me.gksc('rect').setValue(value.proj.NUMBER_RECTIFICATION);
				me.gksc('dtAgree').setValue(value.proj.DT_AGREED);
				me.gksc('dtUtv').setValue(value.proj.DT);

				me.setFullObjsAccess(value.access, ['number', 'dtAgree', 'dtUtv']);

				me.planModInfoReadOnly = value.planModInfoReadOnly;

				me.changeControls();
				me.setReadOnly(me.planModInfoReadOnly);
			},
			dataCollector: function () {
				var me = this, res = [];
				res.osnov = me.gksc('S_MOSNOV').getLinks();
				res.comment = me.gksc('comment').getValue();
				res.dtUtv = me.gksc('dtUtv').getValue();
				return res;
			},
			changeControls: function () {
				var me = this;

				if (me.code === 'PLANREVIZ' && me.isCentralFK) {
					me.gksc('dtUtv').setVisible(false);
					me.gksc('dtAgree').setVisible(false);
				}
			},
			isFilled: function () {
				var me = this,r
					ksControls = me.ksControls;

				let res = {valid: true, invalidControls: []};
				if (me.code !== "IFC_RECORD" && ksControls.S_MOSNOV.isEmpty()) {
					res.valid = false;
					res.invalidControls.push(ksControls.S_MOSNOV);
				}

				if (!me.isCentralFK && me.code === "PLANREVIZ" && ksControls.comment.isEmpty()) {
					res.valid = false;
					res.invalidControls.push(ksControls.comment);
				}
				return res;
			},
			setReadOnly: function (value) {
				var me = this;

				// при Исключении механизм Plan.Edit серит PlanModInfo
				if (me.modType === 'Delete') me.setKsReadOnly(false);

				me.gksc('S_MOSNOV').setReadOnly(value);
				me.gksc('comment').setReadOnly(value);
				me.gksc('comment').cls = value ? 'ks-readOnly' : '';

				me.gksc('number').setKsReadOnly(true);
				me.gksc('rect').setKsReadOnly(true);
				me.gksc('dtAgree').setKsReadOnly(true);
				me.gksc('dtUtv').setKsReadOnly(me.code !== "IFC_RECORD" ? true : value);
			},
			setFullObjsAccess: function (access, keys) {
				var me = this,
					controls = me.ksControls;

				Ext.each(keys, function (key) {
					var c = me.gksc(key) || controls[key],
						accessMask = miscTypes.ObjAccessMask[access[key]];

					if (c && accessMask) {
						var func = accessMask[0],
							params = accessMask[1] == 'true';

						KsLib.tryRun(c[func], c, params);
					}
				});
			}
		}),
//
	Ext.define('Keysystems.Comment',
		{
			extend: 'Ext.window.Window',
			bodyPadding: 5,
			modal: true,
			layout: {type: 'fit', align: 'stretch'},

			cfg: {
				minHeight: 156,
				minWidth: 522,
				title: '',
				labelText: '',
				labelWidth: 100,
				initText: '',
				btnOkText: 'ОК',
				btnCancelText: 'Отмена',
				okFn: Ext.emptyFn
			},

			constructor: function(cfg) {
				var me = this;

				cfg = Ext.apply(me.cfg, cfg);

				Ext.apply(this, cfg);
				me.callParent(arguments);
			},
			initComponent: function() {
				var me = this;

				me.items = [
					me.textArea = Ext.create('Ext.form.field.TextArea',
						{
							fieldLabel: me.labelText,
							labelWidth: me.labelWidth,
							flex: 1,
							value: me.initText
						})
				];

				me.buttons = [
					Ext.create('Ext.Button', {
						text: me.btnOkText,
						handler: function() {
							KsLib.tryRun(me.okFn, me);
							me.close();
						}
					}),
					Ext.create('Ext.Button', {
						text: me.btnCancelText,
						handler: function() {
							KsLib.tryRun(me.cancelFn, me);
							me.close();
						}
					})
				];

				me.callParent(arguments);
			}
		}),

	Ext.define('Keysystems.ImageText',
		{
			extend: 'Ext.form.FieldContainer',
			layout: 'hbox',
			imgName: '',
			text: '',
			initComponent: function () {
				var me = this;
				me.createItems();
				me.callParent(arguments);
			},
			createItems: function () {
				var me = this;
				if (me.items == null)
					me.items = [
						Ext.create('Ext.container.Container',
							{
								cls: 'x-form-text-default x-form-trigger-wrap-default', //рамка + отступы текста
								flex: 1,
								layout: {
									type: 'hbox'
								},
								items: [
									me.img = Ext.create('Ext.Img', {
										minWidth: 21, 
										padding: '0 5 0 0',
										style: {
											backgroundRepeat: 'no-repeat',
										}
									}),
									me.label = Ext.create('Ext.form.Label')
								]
							})
					];
			},
			setValue: function (imgName, text) {
				var me = this;
				//me.img.setSrc(imgName);
				me.img.addCls(imgName);
				me.label.setText(text);
			}
		}),

	Ext.define('Keysystems.RefDropDown',
		{
			extend: 'Ext.form.FieldContainer',
			layout: 'hbox',
			//maxWidth: 55,		
			padding: '0 0 0 10px',
			initComponent: function () {
				var me = this;
				me.items = [
					me.btnRef = Ext.create('Ext.button.Split', {
						iconCls: 'x_btn_garant',
						userCls: 'rks-split-button',
						menu: new Ext.menu.Menu({
							items: [
								{
									text: 'Добавить', handler: function () {
										me.editRef();
									}
								},
								{
									text: 'Открыть', handler: function () {
										me.openRef();
									}
								},
								{
									text: 'Очистить', handler: function () {
										me.setValue(null);
									}
								}
							]
						})
					})
				]
				me.callParent();
			},
			openRef: function () {
				let ref = this.m_ref;
				if (!ref) return;
				window.open(ref, '_blank');
			},
			editRef: function () {
				var me = this;
				me.showEditor(function (text) {
					me.setValue(text);
				}, me.m_ref);
			},
			setValue: function (ref) {
				var me = this,
					menuEdit = me.btnRef.menu.items.items[0],
					menuOpen = me.btnRef.menu.items.items[1],
					menuDel = me.btnRef.menu.items.items[2];
				me.m_ref = ref;

				let text = !ref ? 'Добавить' : 'Редактировать';
				menuEdit.setText(text);

				me.btnRef.setIconCls('x_btn_' + (ref ? (ref.indexOf('consultant') >= 0 ? 'consultant' : 'garant') : 'garant_dis'));
				menuOpen.setDisabled(!ref);
				menuDel.setDisabled(!ref);
			},
			getValue: function () {
				return this.m_ref;
			},
			showEditor: function (callBack, text) {
				var me = this;
				if (!me.refEditor) {
					me.refEditor = Ext.create('Ext.window.Window',
						{
							items: [
								me.refTextArea =
									Ext.create('Ext.form.field.TextArea',
										{
											flex: 1,
											enforceMaxLength: true,
											enableKeyEvents: true,
											maxLength: 2000,
											listeners: {
												render: function (field) {
													field.getEl().on('paste',
														function (e) {
															//для случая копирования ссылки напрямую с гаранта
															//ссылка в буфере обмена лежит в формате rtf
															//в данный момент работает только в firefox75 (проверено в ie11 и chrome81)
															var clipboard = e.clipboardData || window.clipboardData;

															if (clipboard && clipboard.getData && clipboard.types &&
																clipboard.types.indexOf('text/rtf') >= 0) {
																var rtf = clipboard.getData('text/rtf');
																var matches = rtf.match(/HYPERLINK\s+\"(.*?)\"/i);
																if (matches && matches.length > 1) {
																	e.preventDefault();
																	(e.target || e.src).innerHTML = matches[1];
																}
															}
														},
														field);
												}
											}
										})
							],
							bodyPadding: 5,
							layout: {type: 'vbox', align: 'stretch'},
							setValue: function (value) {
								me.refTextArea.setValue(value);
							},
							minWidth: 600,
							minHeight: 50,
							title: 'Ссылка',
							modal: true,
							maximizable: true,
							closeAction: 'hide',
							buttons: [
								{
									text: 'Применить',
									handler: function () {
										me.refEditor.applyChanges = true;
										me.refEditor.close();
									}
								},
								{
									text: 'Отмена',
									handler: function () {
										me.refEditor.applyChanges = false;
										me.refEditor.close();
									}
								}
							],
							listeners: {
								show: function () {
									me.refEditor.applyChanges = false;
								},
								hide: function () {
									if (callBack && me.refEditor.applyChanges)
										callBack(me.refTextArea.getValue());
								}
							}
						});
				}
				me.refEditor.setValue(text);
				me.refEditor.show();
			}
		})
	/**
	 * Контрол фильтрации дерева - текстовое поле с кнопками Поиск либо Удалить.
	 * Фильтрация родителей происходит в зависимости от фильтрации детей - 
	 * если среди детей есть записи, подходящие под фильтр, родитель также подходит под фильтр.
	 * @param treePanel {object} дерево, по которому работает строка фильтрации
	 * */
	Ext.define('Keysystems.Tree.SearchPanel',
		{
			extend: 'Ext.form.field.Text',
			treePanel: null,
			searchField: 'NAME',
			padding: 2,
			triggers: {
				search: {
					cls: 'x_btn_search x-dict-trigger',
					handler: function () {
						if (this.triggers.search.cls.indexOf('x_btn_search') >= 0)
							this.setFilter(this.getValue());
						else
							this.setValue(null);
					}
				}
			},
			listeners: {
				change: {
					fn: (th, v) => {
						th.setFilter(v);
						let trig = th.triggers.search;
						if (trig && trig.el) {
							let fromCls = v ? 'x_btn_search' : 'x_btn_delete',
								toCls = v ? 'x_btn_delete' : 'x_btn_search';
							trig.el.removeCls(fromCls);
							trig.el.addCls(toCls);
							trig.cls = trig.cls.replace(fromCls, toCls);
						}
					},
					buffer: 500
				}
			},
			setFilter: function (v) {
				let me = this,
					store = me.treePanel.getStore();
				store.clearFilter();
				if (!v) return;
				store.filter([
					{
						property: me.searchField,
						value: v,
						comboVal: 'contains',
						filterFn: rec => (rec.get(me.searchField) ?? '').toString().toLowerCase().indexOf(v.toLowerCase()) >= 0
					}
				]);
			}
		});

	/**
	 * Контрол для задания автозаполнения по участникам
	 * */
	Ext.define('Keysystems.AutoPersonControl',
		{
			extend: 'Ext.form.FieldContainer',
			layout: {type: 'hbox', align: 'stretch'},
			bodyPadding: 0,
			label: null,
			labelWidth: 0,
			comboWidth: 400,    //ширина комбокса с типами автозаполнения
			initComponent: function () {
				var me = this;
				me.items = [
					me.cbAUTOPERSON = Ext.create('Ext.form.field.Checkbox', {
						fieldLabel: me.label,
						labelWidth: me.labelWidth - 1,
						listeners: {
							change: function (th1, newValue) {
								me.AUTOPERSON.setDisabled(!newValue);
								me.AUTOPERSON.setValue(newValue ? 0 : -1);
								me.fireEvent('change');
							}
						}
					})];
				if (me.flex) me.items.push('->'); 
				me.items.push(me.AUTOPERSON = Ext.create('Keysystems.Controls.ComboBoxExtra', {
					fieldLabel: 'Автозаполнение',
					labelWidth: 120,
					disabled: true,
					editable: false,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get('AutoPersonMethod', true, null, -1),
						proxy: 'memory'
					}),
					queryMode: 'local',
					displayField: 'value',
					valueField: 'index',
					value: 0,
					padding: me.flex ? 0 : '0 0 0 5',
					minWidth: me.comboWidth,
					listeners: {
						change: function () {
							me.fireEvent('change');
						}
					}
				}));				
				me.callParent();
			},
			setValue: function (value) {
				this.cbAUTOPERSON.setValue(value !== null);
				this.AUTOPERSON.setValue(value);
			},
			getValue: function(){
				return this.cbAUTOPERSON.getValue() ? this.AUTOPERSON.getValue() : null;
			},
			isEmpty: function () {
				const val = this.getValue();
				return val === null || +val === -1;
			}
		});

/**
 * Текстовое поле с возможность автозаполнения (на поле добавляет контекстное меню Заполнить) 
 * для корректной работы должны быть заданы cfg.mask (маска автозаполнения) и cfg.sender (ссылка на форму)
 * */
Ext.define('Keysystems.Controls.Text.AutoNumeric', {
	extend: 'Ext.form.field.Text',
	config: {
		mask: '{#}'
	},
	fillNextNum: function() {
		const me = this.sender;
		const field = this;

		const data = me.dataCollector();
		const rid = ajaxRequest({
			url: me.linkCode + '/FillAutoNumeric_A',
			params: {
				code: me.code,
				rollBackData: JSON.stringify({
					rollbackNumLink: me.gksd('rollbackNumLink'),
					rollbackNumVal: me.gksd('rollbackNumVal'),
					rollbackMissed: me.gksd('rollbackMissed')
				}),
				gzipData: SignalR.pack(data)
			},
			success: function (result) {
				if (me) me.hideLoadMask();

				if (!result) return;
				field.setValue(result.nextnum);
				if (result.rollBackData) {
					me.sksd('rollbackNumLink', result.rollBackData.rollbackNumLink);
					me.sksd('rollbackNumVal', result.rollBackData.rollbackNumVal);
					me.sksd('rollbackMissed', result.rollBackData.rollbackMissed);
				}
			},
			failure: function () {
				if (me) me.hideLoadMask();
			}
		})
		if (me) {
			me.showLoadMask({
				msg: KS.L10n.updating_data,
				rid: rid
			});
		}

	},
	listeners: {
		render: function (e) {
			e.getEl().on('contextmenu', function (target) {
				if (!this.mask) return;
				const field = this;
				let cm = new Ext.menu.Menu(
					{
						items: [
							{
								text: 'Заполнить',
								listeners: {
									click: () => field.fillNextNum()
								}
							}
						]
					}
				);
				target.stopEvent();
				cm.showAt(target.getXY());
			}, e);
		}
	}
});


/**
 * Плагин для копирования в буфер,
 * изначально взято https://forum.sencha.com/forum/showthread.php?310908-Clipboard-plugin, 
 * адаптировано под ркс,
 * подключать в конфиге: plugins: ['gridclipboard']
 */
Ext.define('Keysystems.grid.plugin.Clipboard', {
		extend: 'Ext.plugin.AbstractClipboard',
	
		alias: 'plugin.gridclipboard',
		requires: [
			'Ext.util.Format',
			'Ext.util.TSV'
		],
	
		formats: {
			cell: {
				get: 'getCells'
			},
			html: {
				get: 'getCellData'
			},
			raw: {
				get: 'getCellData',
				put: 'putCellData'
			}
		},

		config: {
			//по умолчанию вставка из буфера запрещена, 
			// при необходимости задать при инициализации плагина Ext.create('Keysystems.grid.plugin.Clipboard', {enablePaste: true})
			enablePaste: false
		},
		gridListeners: {
			render: 'onCmpReady'
		},	
		
		getCellData: function (format, erase) {
			const gridPanel = this.getCmp();
			if (gridPanel.view == null && gridPanel.viewConfig == null) 
				return;
			let	selModel = gridPanel.getSelectionModel(),
				ret = [],
				isRaw = format === 'raw',
				isText = format === 'text',
				data, dataIndex, lastRecord, row, view, columns, store, rowIdx,
				getCellText = function(column, rowIdx, record) {
					let dataIndex = column.dataIndex;
					if (isRaw) {
						data = record.data[dataIndex];
					}
					else if (column.xtype === 'checkcolumn' || column.xtype === 'checkcolumnextra'){
						data = record.data[dataIndex] ? "Да" : "Нет"
					}
					else {
						// Try to access the view node.
						let viewNode = view.all.item(rowIdx);
						// If we could not, it's because it's outside of the rendered block - recreate it.
						if (!viewNode) {
							viewNode = Ext.fly(view.createRowElement(record, rowIdx));
						}
						let cell = viewNode.down(column.getCellInnerSelector());
						data = cell.dom.innerHTML;
						data = data?.replace(/&nbsp;/g,  ' ');
						if (isText) {
							data = Ext.util.Format.stripTags(data);
						}
					}
					return data;
				}
	
			view = gridPanel.getView();
			columns = view.getVisibleColumnManager().getColumns();
			store = gridPanel.getStore();

			if (selModel instanceof Ext.selection.RowModel) {
				selModel.getSelection().forEach(function (record) {
					rowIdx = store.indexOf(record);
					columns.forEach(function (column) {
						// Do not copy the check column or row numberer column
						let ignoreExport = column.xtype === 'checkcolumn' || column.xtype === 'checkcolumnextra' 
							? false
							: column.ignoreExport;
						if (ignoreExport) {
							return;
						}

						if (lastRecord !== record) {
							lastRecord = record;
							ret.push(row = []);
						} 

						data = getCellText(column, rowIdx, record);
						row.push(data);

						if (erase && dataIndex) {
							record.set(dataIndex, null);
						}
					});
				});
			}
			else {
				let sel = selModel.getPosition();
				if (sel && sel.column) {
					rowIdx = store.indexOf(sel.record);
					data = getCellText(sel.column, rowIdx, sel.record);
					let row = data;
					ret.push([row]);
				}
			}
			return Ext.util.TSV.encode(ret, _, null);
		},
	
		getCells: function (format, erase) {
			var gridPanel = this.getCmp(),
				selModel = gridPanel.getSelectionModel(),
				ret = [],
				dataIndex, lastRecord, row, columns;
	
			columns = gridPanel.getView().getVisibleColumnManager().getColumns();
	
			selModel.getSelection().forEach(function (record) {
				columns.forEach(function (column) {
					if (lastRecord !== record) {
						lastRecord = record;
						ret.push(row = {
							model: record.self,
							fields: []
						});
					}
	
					dataIndex = column.dataIndex;
	
					row.fields.push({
						name: dataIndex,
						value: record.data[dataIndex]
					});
	
					if (erase && dataIndex) {
						record.set(dataIndex, null);
					}
				});
			});
	
			return ret;
		},
	
		getTextData: function (format, erase) {
			return this.getCellData(format, erase);
		},
	
		putCellData: function (data, format) {
			if (!this.enablePaste) return;
			
			var values = Ext.util.TSV.decode(data),
				row,
				recCount = values.length,
				colCount = recCount ? values[0].length : 0,
				sourceRowIdx, sourceColIdx,
				gridPanel = this.getCmp(),
				view = gridPanel.getView(),
				maxRowIdx = view.dataSource.getCount() - 1,
				columns = view.getVisibleColumnManager().getColumns(),
				maxColIdx = columns.length - 1,
				dataIndex,
				dataObject,
				store = gridPanel.getStore(),
				selection = gridPanel.getSelectionModel().getSelection(),
				destinationIdx = selection ? store.indexOf(selection[0]) + 1 : store.getCount(),
				recordsToInsert = [],
				column,
				destColIdx;
	
			for (sourceRowIdx = 0; sourceRowIdx < recCount; sourceRowIdx++) {
				row = values[sourceRowIdx];
				destColIdx = 0;
				dataObject = {};
	
				for (sourceColIdx = 0; sourceColIdx < colCount; sourceColIdx++) {
	
					while ((column = columns[destColIdx++]) && !(dataIndex = column.dataIndex)) ;
	
					if (dataIndex) {
						switch (format) {
							// Raw field values
							case 'raw':
								dataObject[dataIndex] = row[sourceColIdx];
								break;
	
							// Textual data with HTML tags stripped
							case 'text':
								dataObject[dataIndex] = row[sourceColIdx];
								break;
	
							// innerHTML from the cell inner
							case 'html':
								break;
						}
					}
	
					// If we are at the end of the destination row, break the column loop.
					if (sourceColIdx === maxColIdx) {
						break;
					}
				}
	
				recordsToInsert.push(dataObject);
	
				if (sourceRowIdx === maxRowIdx) {
					break;
				}
			}
	
			store.insert(destinationIdx, recordsToInsert);
		},
	
		putTextData: function (data, format) {
			this.putCellData(data, format);
		},
	
		getTarget: function (comp) {
			return comp.body;
		},
	
		privates: {
			validateAction: function (event) {
				var view = this.getCmp().getView();
	
				if (view.actionableMode) {
					return false;
				}
			}
		}
	});

Ext.define('Keysystems.BatchUserCreation',
	{
		extend: 'Ext.window.Window',
		bodyPadding: 5,
		modal: true,
		layout: {type: 'vbox', align: 'stretch'},
		title: 'Пакетное создание пользователей',
		labelWidth: 150,
		maxWidth: 480,
		iconCls: 'x_btn_copy',

		resizable: false,

		constructor: function(cfg) {
			let me = this;

			Ext.apply(this, cfg);
			me.callParent(arguments);
		},
		initComponent: function() {
			let me = this;

			me.items = [
				me.mask = Ext.create('Ext.form.field.Text', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Маска имени',
					ksAllowEmpty: true,
					msgTarget: 'side',
					allowBlank: false,
					maxLength: 128,
					value: '_{counter}'
				}),
				me.groups = Ext.create('Keysystems.Controls.DictName.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Группы',
					code: dnl.GROUPS_ADM,
					cleaningKey: false,
					getNameLabelText: function (v) {
						let th = this,
							len = v.length;
						
						if (len) {
							if (len === 1) {
								v = (v = v[0]).data || v;
								let res = window.getTextByVisibleFields(this.code || this.Code, this.visibleFields, v, this.nameField);
								if (th.fieldCode || res) {
									return res;
								}
							}
							
							return `Отобрано ${len} групп(ы)`;
						}
						
						return '';
					},
					handler: function() {
						dictFunc({
								parentView: me.view,
								code: dnl.GROUPS_ADM,
								mode: 'MULTI',
								selectLinks: me.groups.getValue()
							},
							{
								ok: function(value) {
									me.groups.setValue(value);
								}
							}
						);
					}
				}),
				me.cnt = Ext.create('Ext.form.field.Number', {
					fieldLabel: 'Количество пользователей в каждой группе',
					labelWidth: 400,
					allowOnlyWhitespace: false,
					enforceMaxLength: true,
					allowDecimals: false,
					allowExponential: false,
					maxValue: 999,
					minValue: 1,
					value: 1
				}),
				me.chbGenP = Ext.create('Ext.form.field.Checkbox', {
					hideLabel: true,
					boxLabel: 'Генерировать пароли',
					listeners: {
						change: function (th, newValue) {
							me.lengthP.setDisabled(!newValue);
							me.chbUseNumbers.setDisabled(!newValue);
							me.chbRegister.setDisabled(!newValue);
						}
					}
				}),
				Ext.create('Ext.form.FieldSet', {
					flex: 2,
					padding: 5,
					items: [
						Ext.create('Ext.form.FieldContainer', {
							layout: {type: 'hbox', align: 'stretch'},
							items: [
								me.lengthP = Ext.create('Ext.form.field.Number', {
									fieldLabel: 'Длина поля',
									labelWidth: me.labelWidth - 5,
									allowOnlyWhitespace: false,
									enforceMaxLength: true,
									allowDecimals: false,
									allowExponential: false,
									maxValue: 1000,
									minValue: 6,
									value: 6,
									maxHeight: 24,
									width: 210,
									disabled: true
								}),
								Ext.create('Ext.form.FieldContainer', {
									layout: {type: 'vbox', align: 'stretch'},
									padding: '0 0 0 10',
									items: [
										me.chbUseNumbers = Ext.create('Ext.form.field.Checkbox', {
											hideLabel: true,
											boxLabel: 'С использованием чисел',
											disabled: true
										}),
										me.chbRegister = Ext.create('Ext.form.field.Checkbox', {
											hideLabel: true,
											boxLabel: 'Переменный регистр символов',
											disabled: true
										})
									]
								})
							]
						}),
						me.arm = Ext.create('Keysystems.Controls.DictName.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'АРМ',
							code: dnl.ARM,
							cleaningKey: false,
							handler: function() {
								dictFunc({
										parentView: me.view,
										code: dnl.ARM,
										mode: 'SINGL',
										selectLinks: me.arm.getValue()
									},
									{
										ok: function(value) {
											me.arm.setValue(value);
										}
									}
								);
							}
						}),
						me.budget = Ext.create('Keysystems.Controls.DictName.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Счета бюджета',
							code: '',
							hidden: true,
							cleaningKey: false,
							handler: function() {
								dictFunc({
										parentView: me.view,
										code: '',
										mode: 'MULTI',
										selectLinks: me.budget.getValue()
									},
									{
										ok: function(value) {
											me.budget.setValue(value);
										}
									}
								);
							}
						}),
					]
				}),
				Ext.create('Ext.form.field.TextArea', {
					fieldLabel: '',
					disabled: true,
					inputWrapCls: '',
					triggerWrapCls: '',
					fieldStyle: 'background:none',
					preventScrollbars: true,
					value: `* Тег {counter} используется для генерации порядкового числа при формировании имени пользователя.
** В маске имени можно использовать формулы, начинающиеся со знака \'=\'.`
				}),
				Ext.create('Ext.form.field.Text', {
					fieldLabel: '',
					disabled: true,
					inputWrapCls: '',
					triggerWrapCls: '',
					fieldStyle: 'background:none',
					value: 'Пример формулы:',
					padding: '10 0 0 0'
				}),
				Ext.create('Ext.form.field.Text', {
					fieldLabel: '',
					disabled: true,
					value: '=\"_\"+RIGHT(group_name, 5) + \"_{counter}\"'
				}),
			];

			me.buttons = [
				Ext.create('Ext.Button', {
					text: 'Создать',
					handler: function() {
						me.okFn();
					}
				}),
				Ext.create('Ext.Button', {
					text: 'Закрыть',
					handler: function() {
						me.close();
					}
				})
			];

			me.callParent(arguments);
		},
		checkMask: function() {
			let me = this,
				mask = me.mask,
				maskVal = mask.getValue(),
				wrongChars = [ '<', '>', '?', '|', '#', '[', ']', '(', ')', '.', ',', '\'', '/', '|', '~', ':', ';', '*', '&', '^', '%', '$', '@', '-', '+', '№', '"', ' ' ],
				tagCounter = '{counter}',
				count = me.cnt.getValue(),
				groups = me.groups.getValue();

			if (mask.isEmpty()) {
				info(wmc.get('Input', mask.fieldLabel, function() { mask.focus(); }));
				return false;
			}

			if (maskVal.indexOf('=') !== -1 && (!maskVal.startsWith("=") || maskVal.length - maskVal.replaceAll('=', '').length > 1)) {
				warning('Символ \'=\', определяющий формулу расчёта, должен быть строго в начале строки и нигде более.');
				return false;
			}

			if (!maskVal.startsWith("=") && wrongChars.some(c => maskVal.indexOf(c) !== -1)) {
				showError('Недопустимый символ в маске имени пользователя');
				return false;
			}

			if (groups.length) {
				count = count * groups.length;
			}

			if (maskVal.indexOf(tagCounter) === -1 && count > 1) {
				warning(`Будет создано несколько пользователей, а в маске имён обнаружено только статичное имя. Необходимо добавить в конец маски счётчик ${tagCounter}.`);
				return false;
			}
			
			return true;
		},
		dataCollector: function() {
			let me = this,
				groupVal = me.groups.getValue(),
				groups = {},
				arm = me.arm.getValue(),
				armLinks = [],
				res = {
					mask: me.mask.getValue(),
					cnt: me.cnt.getValue(),
					isGenP: me.chbGenP.getValue(),
					lengthP: me.lengthP.getValue(),
					useNumbers: me.chbUseNumbers.getValue(),
					register: me.chbRegister.getValue()
				};
			
			Ext.each(groupVal, g => groups[g.data.UID] = g.data.NAME);
			res.groups = JSON.stringify(groups);
			Ext.each(arm, a => res.armLinks.push(a.data.LINK));
			res.armLinks = JSON.stringify(armLinks);
			
			return res;
		},
		okFn: function() {
			let me = this,
				id = '';
			
			if (me.checkMask()) {
				let data = me.dataCollector(),
					isGenP = data.isGenP;
				
				if (isGenP) {
					id = data.id = UploaderLib.getNextId();
				}

                const loadMask = new Ext.LoadMask({
                    msg: "Создание пользователей...",
                    target: me,
                    autoShow: true,
                    rid: ajaxRequest({
                        url: me.code + '/BatchUserCreation_A',
                        params: {data: JSON.stringify(data)},
                        success: function(res) {
                            loadMask.destroy();
                            
							if (res.ErrorMsg) {
								window.failureShow({
									statusText: res.ErrorMsg,
									messageText: "Ошибка при создании пользователей"
								}, "Внимание");
								return;
							}
							
							showDetailEventsLog({
								html: res.html,
								modal: true,
								title: '',
								fullTitle: 'Пакетное добавление пользователей',
								waitCloseFn: true,
								closeFn: function(callBack) {
									if (isGenP) {
										Ext.Msg.show({
											buttons: Ext.MessageBox.YESNOCANCEL,
											msg: 'Данный протокол содержит сгенерированные пароли. Для дальнейшего их использования настоятельно рекомендуется их сохранить или распечатать. Сохранить протокол?',
											fn: function (buttonId) {
												if (buttonId === 'yes') {
													UploaderLib.getFileAndFree(id, res.fileName);
													callBack();
												} else {
													ajaxRequest({
														url: 'Uploader/RemoveFile_A',
														params: { id }
													});
													callBack();
												}
											},
											icon: Ext.MessageBox.QUESTION
										});
									} else {
										callBack();
									}
								}
							});

							KsLib.tryRun(me.afterSuccessSave);	
                        },
                        failure: function (val) {
                            loadMask.destroy();
							showError('Возникла ошибка при сохранении!');
                        }
                    })
                });
			}
		}
	})

/**
 * Колока нумерации с меню для гридов (нумерация скрыта)
 */
Ext.define('RKS.grid.columns.RowNumberer', {
	extend: 'Ext.grid.column.RowNumberer',
	alias: 'widget.rks-grid-column-rownumberer',
	minWidth: 20,
	autoLock: true,
	sortable: false,
	draggable: false,
	resizable: false,
	hideable: false,
	menuDisabled: true,	
	headerWrap: false,
	text: '',
	cls: 'rks-grid-column-rownumberer ' + Ext.baseCSSPrefix + 'row-numberer',
	innerCls: 'rks-grid-column-rownumberer_cell-inner-row-numberer ' + Ext.baseCSSPrefix + 'grid-cell-inner-row-numberer',
	menuBtnCls: 'rks-grid-column-rownumberer__menu-btn',
	menuBtnIconCls: 'x_btn_grid_menu',
	privates: {
		//добавление кнопки в заголовок колонки
		afterText(out) {
			const { menuBtnCls, menuBtnIconCls } = this;
			out.push(`<div role="presentation" class="${menuBtnCls} ${menuBtnIconCls}"></div>`);
		}
	}
})
//#region setKsReadOnly

Ext.onReady(() => {

	const ksReadOnlyFns = {
		Items: function (v) {
			var me = this;
			me.ksReadOnly = v;
			me.dockedItems && Ext.each(this.dockedItems.items, function (item) {
				KsLib.tryRun(item.setKsReadOnly, item, v);
			});
			Ext.each(me.items.items, function (item) {
				KsLib.tryRun(item.setKsReadOnly, item, v);
			});

			me.on('add', function (th, item) {
				if (me.ksReadOnly) KsLib.tryRun(item.setKsReadOnly, item, true);
			});
		},
		FieldContainer: function (v) {
			this[(this.ksReadOnly = v) ? 'addCls' : 'removeCls'](this.ksReadOnlyCls);
			Ext.each(this.items.items, function (item) {
				KsLib.tryRun(item.setKsReadOnly, item, v);
			});
		},
		Disabled: function (v) {
			var me = this,
				lv = me.ksReadOnly == v;
			if ((me.ksReadOnly = v) && !me.extEnable) {
				me.extEnable = me.enable;
				me.enable = function () {
					return !this.ksReadOnly && this.extEnable.apply(this, arguments);
				};
			}
			if (!me.extDisabledCls) me.extDisabledCls = me.disabledCls;
			me.removeCls(v ? me.extDisabledCls : me.ksReadOnlyCls);

			me.disabledCls = v ? me.ksReadOnlyCls : me.extDisabledCls;
			if (!lv) me.setDisabled(v);
		},
		Base: function (v) {
			this[(this.ksReadOnly = v) ? 'addCls' : 'removeCls'](this.ksReadOnlyCls);
			this.setReadOnly(v);
		},
		Empty: Ext.emptyFn,
		Grid: function (v) {
			this.ksReadOnly = v;
			Ext.each(this.panel.dockedItems.items, function (item) {
				KsLib.tryRun(item.setKsReadOnly, item, v);
			});

			if (this.editingPlugin) this.editingPlugin.beforeEdit = v ? KsLib.falseFn : Ext.emptyFn;
		}
	};

	Ext.AbstractComponent.prototype.ksReadOnlyCls = 'ks-readOnly';
	Ext.form.FieldContainer.prototype.setKsReadOnly = ksReadOnlyFns.FieldContainer;
	Ext.each([Ext.window.Window, Ext.panel.Panel, Ext.tab.Panel, Ext.toolbar.Toolbar, Ext.form.FieldSet],
		function (cl) {
			cl.prototype.setKsReadOnly = ksReadOnlyFns.Items;
		});

	Ext.each(
		[
			Ext.form.field.ComboBox, Keysystems.Controls.ComboBoxExtra, Ext.button.Button, Ext.form.field.Date, Keysystems.Controls.ClickLabel,
			Ext.form.field.Number, Ext.form.field.Text, Ext.form.field.Checkbox
		], function (cl) {
			cl.prototype.setKsReadOnly = ksReadOnlyFns.Disabled;
		});

	Ext.each([Ext.form.field.TextArea, Keysystems.Controls.Dict.Edit], function (cl) {
		cl.prototype.setKsReadOnly = ksReadOnlyFns.Base;
	});
	Ext.each([Ext.form.Label, Ext.toolbar.Separator, Ext.Component], function (cl) {
		cl.prototype.setKsReadOnly = ksReadOnlyFns.Empty;
	});
	Ext.each([Ext.grid.View, Ext.tree.View], function (cl) {
		cl.prototype.setKsReadOnly = ksReadOnlyFns.Grid;
	});
});

//#endregion setKsReadOnly