﻿Ext.define('Ext.picker.CallCalc', {
	extend: 'Ext.window.Window',
	alias: 'widget.callcalc',
	header: false,
	style: 'border:1; border-radius:0;padding: 0; border-color: #1b376c;', // ПЕРЕНЕСТИ В СТИЛИ
	bodyStyle: 'border: 0', // ПЕРЕНЕСТИ В СТИЛИ
	resizable: false,
	width: 260,
	minWidth: 255, //на случай
	minHeight: 165, // resizable: true
	closable: false,
	enableKeyEvents: true,
	hideShadowOnDeactivate: true,
	layout: { type: 'vbox', align: 'stretch' },
	negativeTextSQRT: 'Ошибка: извлечение корня из отрицательного числа.',
	negativeTextZERO: 'Ошибка: это число не может быть нулем.',
	negativeTextMin: 'Ошибка: минимальное число для этого поля -922337203685477.',
	negativeTextMax: 'Ошибка: максимальное число для этого поля 922337203685477.',
	regNumbers: /[0-9]/,
	regOperations: /[\- \+ \* \/]/,
	initComponent: function() {
		var me = this;
		me.memory = 0;
		me.flagCountPersent = false;
		me.flagBSPressed = false;
		me.flagFloatSign = false;
		me.flagCountedNum = false;
		me.minValue = -922337203685477;
		me.maxValue = 922337203685477;
		me.items = me.createItems();
		me.callParent(arguments);

		me.on('beforeclose', function() {
			me.parentField.collapse();
			return false;
		});
	},
	createItems: function() {
		var me = this,
			res = [
				me.calculatorField = Ext.create('Ext.form.field.Text', {
					negativeTextSQRT: me.negativeTextSQRT,
					negativeTextZERO: me.negativeTextZERO,
					negativeTextMin: me.negativeTextMin,
					negativeTextMax: me.negativeTextMax,
					enableKeyEvents: true,
					flex: 1,
					margin: '5% 5% 5% 5%',
					value: me.parentField.getValue(),
					listeners: {
						keypress: function(field, e) { me.keysPressedOperations(e); }
					}
				}),
				//me.writeOperationField = Ext.create('Ext.form.field.Text', {
				//	flex: 1,
				//	margin: '1% 5% 5% 5%',
				//	disabled: true
				//}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					flex: 1,
					defaults: { margin: '0 2% 0 2%', flex: 1 },
					items: [
						me.memoryField = Ext.create('Ext.form.field.Text', {
							disabled: true,
							flex: 1,
							fieldStyle: 'text-align: center;'
						}), {
							text: 'Backspace',
							flex: 2,
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							handler: function() {
								if (me.flagCountedNum) {
									me.flagNewNum = false;
								}
								me.flagBSPressed = true;
								me.buttonsPressed();
							}
						}, {
							text: 'CE',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							handler: function() {
								me.clearAll();
								me.calculatorField.setValue();
								me.setCaretPosition(0);
							}
						}, {
							text: 'C',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							handler: function() {
								me.clearAll();
								me.calculatorField.setValue();
								me.setCaretPosition(0);
							}
						}
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					flex: 1,
					defaults: { margin: '0 2% 0 2%', flex: 2 },
					items: [
						{
							text: 'MC',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.memory = 0;
								me.memoryField.setValue('');
								me.calculatorField.inputEl.dom.focus();
							}
						}, {
							text: '7',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(7);
							}
						}, {
							text: '8',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(8);
							}
						}, {
							text: '9',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(9);
							}
						}, {
							text: '/',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								//me.writeOperationField.setValue('/');
								me.operationsPressed('/');
							}
						}, {
							text: 'sqrt',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								if (me.parseInFloatSign(me.calculatorField.getValue()) > me.maxValue) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextMax]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else if (me.parseInFloatSign(me.calculatorField.getValue()) < 0) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextSQRT]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else {
									me.calculatorField.setValue(me.parseOutFloatSign(Math.sqrt(me.parseInFloatSign(me.calculatorField.getValue()))));
								}
								me.calculatorField.inputEl.dom.focus();
							}
						}
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					flex: 1,
					defaults: { margin: '0 2% 0 2%', flex: 2 },
					items: [
						{
							text: 'MR',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								if (me.parseInFloatSign(me.memory) < me.minValue) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextMin]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else if (me.parseInFloatSign(me.memory) > me.maxValue) {

									me.calculatorField.setActiveError([me.calculatorField.negativeTextMax]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else {
									me.calculatorField.setValue(me.parseOutFloatSign(me.memory));
									me.calculatorField.inputEl.dom.focus();
								}
							}
						}, {
							text: '4',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(4);
							}
						}, {
							text: '5',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(5);
							}
						}, {
							text: '6',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(6);
							}
						}, {
							text: '*',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								//me.writeOperationField.setValue('*');
								me.operationsPressed('*');
							}
						}, {
							text: '%',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.flagCountPersent = true;
								me.operationsPressed('%');
							}
						}
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					flex: 1,
					defaults: { margin: '0 2% 0 2%', flex: 2 },
					items: [
						{
							text: 'MS',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								if (me.parseInFloatSign(me.calculatorField.getValue()) < me.minValue) {

									me.calculatorField.setActiveError([me.calculatorField.negativeTextMin]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else if (me.parseInFloatSign(me.calculatorField.getValue()) > me.maxValue) {

									me.calculatorField.setActiveError([me.calculatorField.negativeTextMax]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else {
									me.memoryField.setValue('M');
									me.memory = me.parseInFloatSign(me.calculatorField.getValue());
									me.calculatorField.inputEl.dom.focus();
								}
							}
						}, {
							text: '1',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(1);
							}
						}, {
							text: '2',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(2);
							}
						}, {
							text: '3',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(3);
							}
						}, {
							text: '-',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								//me.writeOperationField.setValue('-');
								me.operationsPressed('-');
							}
						}, {
							text: '1/x',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								if (me.parseInFloatSign(me.calculatorField.getValue()) < me.minValue) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextMin]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else if (me.parseInFloatSign(me.calculatorField.getValue()) > me.maxValue) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextMax]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else if (me.parseInFloatSign(me.calculatorField.getValue()) === 0 || me.parseInFloatSign(me.calculatorField.getValue()) === null) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextZERO]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else {
									me.calculatorField.setValue(me.parseOutFloatSign(1.0 / (me.parseInFloatSign(me.calculatorField.getValue()))));
								}
								me.calculatorField.inputEl.dom.focus();
							}
						}
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					flex: 1,
					defaults: { margin: '0 2% 0 2%', flex: 2 },
					items: [
						{
							text: 'M+',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								if (me.parseInFloatSign(me.memory) < me.minValue) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextMin]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else if (me.parseInFloatSign(me.memory) > me.maxValue) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextMax]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else {
									me.memoryField.setValue('M');
									me.memory = me.parseInFloatSign(me.calculatorField.getValue()) + me.memory;
									me.calculatorField.inputEl.dom.focus();
								}
							}
						}, {
							text: '0',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.buttonsPressed(0);
							}
						}, {
							text: '+/-',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								if (me.parseInFloatSign(me.calculatorField.getValue()) < me.minValue) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextMin]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else if (me.parseInFloatSign(me.calculatorField.getValue()) > me.maxValue) {
									me.calculatorField.setActiveError([me.calculatorField.negativeTextMax]);
									me.fireEvent('validitychange', me, false);
									me.updateLayout();
								} else {
									me.calculatorField.setValue(me.parseOutFloatSign(me.parseInFloatSign(me.calculatorField.getValue()) * (-1)));
									me.calculatorField.inputEl.dom.focus();
								}
							}
						}, {
							text: ',',
							cls: 'ks-calc-button-text-color-blue',
							xtype: 'button',
							flex: 1,
							handler: function() {
								var v = me.calculatorField.getValue();
								if (!v.match(/,/) && !v.match(/\../))
									me.buttonsPressed(',');
							}
						}, {
							text: '+',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								//me.writeOperationField.setValue('+');
								me.operationsPressed('+');
							}
						}, {
							text: '=',
							cls: 'ks-calc-button-text-color-red',
							xtype: 'button',
							flex: 1,
							handler: function() {
								me.flagCountedNum = true;
								//me.writeOperationField.setValue();
								me.operationsPressed('=');
								me.flagNewNum = false;
							}
						}
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					flex: 1,
					defaults: { margin: '0 2% 0 2%', flex: 2 },
					items: [
						{
							text: 'Применить',
							flex: 1,
							xtype: 'button',
							handler: function() {
								me.parentField.setValue(me.parseInFloatSign(me.calculatorField.getValue()));
								me.close();
							}
						}, {
							text: 'Отмена',
							flex: 1,
							xtype: 'button',
							handler: function() {
								me.calculatorField.setValue(me.parentField.getValue());
								me.clearAll();
								me.close();
							}
						}
					]
				})
			];
		return res;
	},
	keysPressedOperations: function(e) {
		var me = this;
		if (me.regNumbers.exec(String.fromCharCode(e.getKey()))) {
			e.preventDefault();
			me.buttonsPressed(String.fromCharCode(e.getKey()));
		} else if (me.regOperations.exec(String.fromCharCode(e.getKey()))) {
			e.preventDefault();
			//me.writeOperationField.setValue(me.regOperations.exec(String.fromCharCode(e.getKey())));
			me.operationsPressed(String.fromCharCode(e.getKey()));
			me.flagNewNum = true;
		} else {
			switch (e.getKey()) {
			case (e.BACKSPACE):
				break;
			case (44):
			case (46):
				var v = me.calculatorField.getValue();
				if (v.match(/,/) || v.match(/\../)) {
					e.preventDefault();
					break;
				}
				break; //. и ,
			case (e.LEFT):
				if (!(e.keyCode === 37 && e.charCode === 0)) {
					e.preventDefault();
				}
				break;
			case (e.RIGHT):
				if (!(e.keyCode === 39 && e.charCode === 0)) {
					e.preventDefault();
				}
				break;
			case (e.ENTER):
			case (61): //про enter или = считаем
				e.preventDefault();
				//me.writeOperationField.setValue();
				me.operationsPressed('=');
				me.flagNewNum = false;
				break;
			case (99):
			case (67): // очистка C
				e.preventDefault();
				me.calculatorField.setValue();
				me.clearAll();
				break;
			default:
				e.preventDefault();
				break;
			}
		}
	},
	clearAll: function() {
		var me = this;
		me.flagNewNum = false;
		me.currents = 0;
		//me.writeOperationField.setValue();
		me.pendingOp = '';
		me.op = '';
	},
	destroyer: function() {
		var me = this;
		me.parentField.collapse();
	},
	setCaretPosition: function(caretPos) { //поставить курсор в нужную позицию
		var me = this;
		var elem = me.calculatorField.inputEl.dom;
		if (elem.createTextRange) {
			var range = elem.createTextRange();
			range.move('character', caretPos);
			range.select();
		} else {
			if (elem.selectionStart) {
				elem.focus();
				elem.setSelectionRange(caretPos, caretPos);
			} else
				elem.focus();
		}
	},
	buttonsPressed: function(number) {
		var me = this;
		var strLength = me.calculatorField.getValue().length;
		var beforeInput = me.calculatorField.getValue().substr(0, me.calculatorField.inputEl.dom.selectionStart);
		var afterInput = me.calculatorField.getValue().substr(me.calculatorField.inputEl.dom.selectionEnd, strLength);
		if (me.flagNewNum) {
			me.calculatorField.setValue(number);
			me.setCaretPosition(me.calculatorField.getValue().length);
			me.flagNewNum = false;
		} else {
			if (me.flagBSPressed) {
				beforeInput = beforeInput.substr(0, beforeInput.length - 1);
				me.flagBSPressed = false;
			} else {
				beforeInput += number.toString();
			}
			me.calculatorField.setValue(beforeInput + afterInput);
			me.setCaretPosition(beforeInput.length);
		}
	},
	operationsPressed: function(op) {
		var me = this;
		var inNumberVal = me.parseInFloatSign(me.calculatorField.getValue());
		if (inNumberVal < me.minValue) {
			me.calculatorField.setActiveError([me.calculatorField.negativeTextMin]);
			me.fireEvent('validitychange', me, false);
			me.updateLayout();
		} else if (inNumberVal > me.maxValue) {
			me.calculatorField.setActiveError([me.calculatorField.negativeTextMax]);
			me.fireEvent('validitychange', me, false);
			me.updateLayout();
		} else if ((inNumberVal === 0 ||
			inNumberVal === null) &&
		(me.pendingOp === '/' && (op === '%' || op === '='))) {
			me.calculatorField.setActiveError([me.calculatorField.negativeTextZERO]);
			me.fireEvent('validitychange', me, false);
			me.updateLayout();
		} else {
			if (me.flagNewNum && me.pendingOp != '=') {
				me.calculatorField.setValue(me.parseOutFloatSign(me.currents));
			} else {
				me.flagNewNum = true;
				if (me.flagCountPersent) {
					me.calculatorField.setValue(me.parseOutFloatSign(me.currents * (me.parseInFloatSign(me.calculatorField.getValue()) / 100)));
				}
				switch (me.pendingOp) {
				case '+':
					me.currents += inNumberVal;
					break;
				case '-':
					me.currents -= inNumberVal;
					break;
				case '*':
					me.currents *= inNumberVal;
					break;
				case '/':
					me.currents /= inNumberVal;
					break;
				default:
					me.currents = inNumberVal;
					break;
				}
				me.pendingOp = op;
				if (!me.flagCountPersent) {
					me.calculatorField.setValue(me.parseOutFloatSign(me.currents));
				} else {
					me.flagCountPersent = false;
				}
			}
		}
		me.calculatorField.inputEl.dom.focus();
	},
	parseInFloatSign: function(value) { //запятая на точку
		if (value != "") {
			value = value.replace(' ', '');
			value = parseFloat(value.replace(',', '.'));
		}
		return isNaN(value) ? null : value;
	},
	parseOutFloatSign: function(value) { //точка на запятую
		if (!(value == null || value == "")) {
			value = value.toString().replace(".", ",");
		}
		return value;
	}
});

//новый класс для вызова калькулятора
Ext.define('Keysystems.Controls.CalcField', {
	extend: 'Ext.form.field.Picker',
	alias: 'widget.calcfield',
	decimalData: {
		groupSep: ' ',
		decimalSep: '.',
		decimals: 0
	},
	triggerCls: 'x-dict-trigger x_btn_calcauto',
	allowExponential: false,
	fieldLabel: 'Сумма',
	fieldStyle: "text-align:right;",
	matchFieldWidth: false,
	enableKeyEvents: true,
	regNumbers: /[0-9]/,
	minVal: -922337203685477,
	maxVal: 922337203685477,
	listeners: {
		keypress: function(field, e) {
			var me = this;
			if (me.regNumbers.exec(String.fromCharCode(e.getKey()))) {
			} else {
				switch (e.getKey()) {
				case (e.BACKSPACE):
					break;
				case (e.LEFT):
					if (!(e.keyCode === 37 && e.charCode === 0)) {
						e.preventDefault();
					}
					break;
				case (e.RIGHT):
					if (!(e.keyCode === 39 && e.charCode === 0)) {
						e.preventDefault();
					}
					break;
				case (44):
				case (46):
					break;
				case 45:
					if (this.minVal >= 0) e.preventDefault();
					break;
				default:
					e.preventDefault();
					break;
				}
			}
		},
		blur: function(th) {
			th.setValue(th.getValue());
		},
		change: function(th, newValue, oldValue) {
			var newVal = th.parseTextToNum(newValue);
			if (newVal > th.maxVal || newVal < th.minVal) th.setValue(oldValue);
		}
	},
	createPicker: function() {
		var me = this;
		return new Ext.picker.CallCalc({
			parentField: me
		});
	},
	getNumValue: function() {
		var th = this,
			val = th.getValue();
		return th.parseTextToNum(val);
	},
	getRawValue: function() {
		var th = this,
			value = th.callParent();
		
		return th.notDecimal ? value : convertToDecimal(value, th.decimalData);
		
	},
	parseTextToNum: function(val) { 
		return val ? parseFloat((val + '').replace(regSpace, '')) : 0;
	},
	getValue: function() {
		return this.callParent(arguments);
	},
	setValue: function(value) {
		return this.callParent([this.notDecimal ? value : convertToDecimal(value, this.decimalData)]);
	},
	onExpand: function() {
		var me = this,
			p = me.getPicker().calculatorField;
		p.setValue(me.value);
	},
	onCollapse: function() {
		var me = this,
			p = me.getPicker().calculatorField;
		me.setValue(p.getValue());
	}
});