﻿import NavigatorLib from "../Other/Navigator";

let maxPageSize = 500000;

Ext.define('Keysystems.Base.List',
	{
		extend: 'Ext.container.Container',
		mixins: ['Keysystems.Base.Abstract', 'Keysystems.ToolbarBuilder'],
		objs: {},
		iconCls: 'x_btn_dict',
		autoheightrowsCls: 'ks-autoheightrows',
		profileKey: 'ListExtra',
		fileColumn: false,
		fieldFile: 'FILES',
		fieldExt: 'TEMP_EXT',
		banLinks: [],
		mode: 'MULTI',
		code: '',
		readOnly: false,
		deleteCode: '',
		controlName: '', //Имя контрола для профиля
		linkCode: 'Data',
		GateCode: '',
		editClass: '',
		title: '',
		selectLinks: null,
		checkList: null,
		fieldLink: 'LINK',
		fieldName: 'NAME',
		checkModel: true,
		subCheckModel: false,
		closable: true,
		tabMode: false,
		viewMode: 'viewShow',
		head: true,
		hidePagging: false,
		hideTBar: false,
		//скрывать панель фильтрации
		hideFilterPanel: false,
		//скрывать нижнюю доп панель 
		hideBottomPanel: false,
		isItemDblClick: true,
		parentView: null,
		parentLink: undefined,
		checkListeners: null,
		checkRenderer: null,
		mainColumn: false,
		mainColumnEditable: true,
		mainColumnName: 'MAIN',
		whereList: null,
		inputDicts: undefined,
		refreshBtn: true,
		//todo: ПЕРЕПИСАТЬ ПРИ ПЕРЕХОДЕ НА НОВЫЙ ЭКСТ
		pageSize: maxPageSize,
		startPage: 1,
		filter: null, // фильтр, если не Null то подсвечиваем
		filterable: true, //может ли store фильтроваться по колонкам
		searchBtnCls: 'x-pressed x-btn-pressed x-btn-default-toolbar-small-pressed',
		arrDisable: ['new', 'copy', 'delete', 'check', 'uncheck', 'undo'],
		ignoreEditInitialConfig: ['GateCode', 'show', 'readOnly', 'tabMode'],
		delByChecked: false,
		multiSelectGridVisible: true,
		reloadData: false,
		profileLinkCode: 'data',
		allBtns: ['new', 'same', 'edit', 'open', 'delete', 'refresh', 'print', 'sendEsgfk', 'showEsgfkEventLog', 'galka',
			'unmark', 'search', 'undo', 'show_actual', 'autofilter', 'nastr_grid', 'relations',
			'wrap', 'showBatchChange', 'journal', 'profile', 'exit'],
		beforeDeleteFn: (endFunc, sels) => { endFunc() },

		initConfig: function(cfg) {
			var me = this;
			me.objs = {};
			me.whereArgs = {};
			me.selectLinks = [];
			if (!me.functions) me.functions = {};
			if (!me.btnsHide) me.btnsHide = {};
			if (!me.btnsShow) me.btnsShow = {};

			Ext.apply(me, cfg);

			me.viewMode = (me.tabMode && me.parentView) ? 'tabShow' : 'viewShow';
			
			me.beforeInitComponent();
		},
		constructor: function(cfg) {
			var me = this;
			me.isLoading = true;
			Ext.apply(this, cfg);
			Log.sendLog(wmc.get('createForm', me.title, me.code, me.linkCode, me.GateCode));
			me.callParent(arguments);
			
			me.createSelModel();
			me.createGridListeners();
			me.createItems();
			me.beforeSetWhereArgs();
			me.setWhereArgs && me.setWhereArgs();
			
			Ext.apply(me.whereArgs, me.initWhereArgs ? me.initWhereArgs() : me.getWhereArgs());
			me.initializeFilter();
			
			//if (me.whereArgs) console.log(me.whereArgs);
			//me.afterSetWhereArgs && me.afterSetWhereArgs(me.whereArgs);
			me.createBtns();
			me.createListeners();
			me.createView();
			me.addViewEvents();
			if (!me.notShow) me.show();
		},
		createListContextMenu: function() {
			const me = this;
			
			const contextMenu = me.Grid.getContextMenu() ?? Ext.create('Ext.menu.Menu');
			
			if (me.toolbar && me.objs.tbar) {
				const cmToolbarItems = me.buildTContextMenu();
				if (cmToolbarItems.length > 0) {
					contextMenu.add('-');
					cmToolbarItems.forEach(cmItem => {
						contextMenu.add(cmItem);
					})
				}
			}
			contextMenu.add([
				'-',
				Ext.create('Ext.Action',
					{
						iconCls: 'x_btn_clean',
						text: 'Очистить профиль',
						handler: () => me.profileOnClear(),
						//раскоментить при реализации двух других пунктов
						// menu: [
						// 	{
						// 		text: 'Очистить',
						// 		iconCls: 'x_btn_clean',
						// 		handler: function() { me.profileOnClear(); }
						// 	}, {
						// 		text: 'Заменить в базовом',
						// 		hidden: true, //!window.user.isAdmin,
						// 		handler: function() { me.profileOnReplace(); }
						// 	}, {
						// 		text: 'Скопировать пользователям',
						// 		hidden: true, //!window.user.isAdmin,
						// 		iconCls: 'x_btn_users',
						// 		handler: function() { me.profileOnCopy(); }
						// 	}
						// ],
					})]);


			return me.objs.contextMenu = contextMenu;
		},

		adaptListContextMenu: function(){
			const me = this;
			me.toolbar?.items.items.forEach(tool => {
				const cmItem = me.objs.contextMenu?.items.items.filter(item=>item.code && tool.code && item.code === tool.code)[0];
				if (cmItem){
					if (cmItem.text !== tool.tooltip) cmItem.setText(tool.tooltip);
					if (cmItem.iconCls !== tool.iconCls) cmItem.setIconCls(tool.iconCls);
					if (cmItem.disabled !== tool.disabled) cmItem.setDisabled(tool.disabled);
				}
			});
		},

		getReadOnly: function() { return this.readOnly || this.f === 'readOnly'; },
		addViewEvents: function() {
			var me = this,
				objs = me.objs;

			objs.view.on('close',
				function () {
					// не понятно зачем вызывать тут checkBadLinks, если вызовется в setValue() у Controls.Dict.Edit
					// if (me.checkModel) KsDictBadLib.checkBadLinks(me);
					me.onDestroy();
				});

			
			if (me.Grid && me.Grid.columnManager && me.Grid.columnManager.headerCt) {
				if (me.checkModel)
					me.Grid.columnManager.headerCt.on('beforeremove', function(th, c) { return c !== me.mColumn; });
			}

			me.on('ksAfterRefresh',
				function(th, recs) {
					var btns = th.objs.tbarBtns;
					if (btns)
						Ext.each([btns.wrap, btns.expandall, btns.collapseall, btns.autofilter],
							(btn) => btn && btn.setDisabled(!(recs && recs.length)));
				});

			objs.view.on('afterrender',() => {
				me.getData();
			});
		},
		afterRefresh: function() { if (this.Grid) this.fireEvent('ksAfterRefresh', this, this.Grid.store.data.items); },		
		beforeDestroy: function() {
			// пока не отрабатывает
			this.destroyDockedItems && this.destroyDockedItems();
			this.callParent();
		},

		thereIsField: function(fields, name) {
			return (Ext.Array.indexOf(fields, name) !== -1) || (ArrayLib.find(fields, ['name'], name) !== -1);
		},
		fieldsAdapted: function(fields) {
			var me = this;
			if (me.checkModel) fields.push('M');
			if (me.mainColumn && (!me.thereIsField(fields, me.mainColumnName))) fields.push(me.mainColumnName);
			if (me.fileColumn) {
				var pos = ArrayLib.find(fields, ['name'], me.fieldFile);
				if (pos === -1)
					fields.push(me.fieldFile);
				else
					fields[pos].type = 'string';
				if (!me.thereIsField(fields, 'FileColumn')) fields.push('FileColumn');
			}
			return fields;
		},
		columnsAdapted: function(columns) {
			var me = this,
				hasHeaderPadding = false;
			columns = allColumnAdapted(ArrayLib.copy(columns), me.Grid);
			
			if (me.mainColumn && (ArrayLib.find(columns, ['dataIndex'], me.mainColumnName) === -1)) {
				Ext.each(columns, c => hasHeaderPadding |= c.hasOwnProperty('headerPadding'));
				
				columns.unshift({
					xtype: 'checkcolumnextra',
					dataIndex: me.mainColumnName,
					width: 60,
					text: 'Основной',
					index: -1,
					headerPadding: hasHeaderPadding ? 22 : 0,
					listeners: {
						checkchange: function(th, indx, checked, rec, param, events, childRec) {
							// записи верхнего грида может не быть, когда включен пейджинг
							var isMainRec = !!rec;
							rec = rec || childRec;
							if (rec.data.M || childRec) {
								var pos = ArrayLib.find(me.checkList, ['data', 'LINK'], rec.data.LINK),
									mGrid = me.gksc('MultiSelectGrid');
								
								if (pos === -1) pos = ArrayLib.find(me.checkList, ['LINK'], rec.data.LINK);
								if (pos !== -1) me.checkList.splice(pos, 1);
								me.checkList.push(rec);

								var checkVal = checked;
								if (checked && me.getRevizOneMain(checked, rec, th)) {
									if (isMainRec) {
										rec.set(me.mainColumnName, false);
									}
									checkVal = false;
								}
								
								if (mGrid && !childRec) {
									me.checkMGridRecord(rec, checkVal);
								}
							}
						}
					}
				});

				if (me.mainColumnEditable) {
					columns[0].checkRenderer = function(val, meta, rec) { 
						if (!rec.data.M) return ''; 
					};
					columns[0].listeners.beforecheckchange = function(th, inx, check, rec) { 
						return rec.data.M || false;
					}
				} else {
					columns[0].listeners.beforecheckchange = function() { return false; };
				}
			}

			if (me.checkModel) {
				me.checkListeners = me.checkListeners || {};
				if (me.checkListeners.checkchange) {
					var checkchange, beforecheckchange;
					if (me.checkListeners.checkchange) checkchange = me.checkListeners.checkchange;
					if (me.checkListeners.beforecheckchange) beforecheckchange = me.checkListeners.beforecheckchange;

					me.checkListeners.beforecheckchange = function(th, rowIndex, checked, rec, eOpts) {
						if (me.readOnly) return false;
						return KsLib.tryRun(beforecheckchange, th, th, rowIndex, checked, rec, eOpts);
					};
					me.checkListeners.checkchange = function(th, rowIndex, checked, rec, eOpts) {
						me.checkModelChange(checked, rec);
						KsLib.tryRun(checkchange, th, th, rowIndex, checked, rec, eOpts);
					};
				} else {
					me.checkListeners.checkchange = function(th, rowIndex, checked, rec) {
						me.checkModelChange(checked, rec);
					};
				}
			 	columns = me.createCheckColumn(columns);
			}
			if (me.fileColumn) {
				columns.push({
					xtype: 'actioncolumn',
					dataIndex: 'FileColumn',
					text: 'Файл',
					width: 40,
					align: 'center',
					items: [
						{
							getClass: function (v, meta, rec) {
								return getExtStyle(rec.get(me.fieldExt));
							},
							handler: function (grid, rowIndex) {
								me.fileEdit(grid.getStore().getAt(rowIndex));
							}
						}
					]
				})
			}
			return columns;
		},
		
		checkMGridRecord: function(parentRec, val) {
			var me = this,
				mGrid = me.gksc('MultiSelectGrid');
			
			if (mGrid) {
				var childRec = mGrid.store.findRecord(me.fieldLink, parentRec.data[me.fieldLink]);
				if (childRec) {
					childRec.set(me.mainColumnName, val);
				}
			}
		},
		
		//Используется в мероприятиях. Настройка "Только один объект основной"
		getRevizOneMain: function(checked, rec, th) {
			var me = this,
				res = false;

			if (me.onlyOneMain) {
				var link = (rec.data || rec)[me.fieldLink];
				Ext.each(me.getChecks(),
					function(el) {
						var d = el.data || el;
						return !(res = !!(d[me.fieldLink] != link && d.MAIN));
					});
			}
			
			if (me.mainColumn){
				//Если пришли с колонки MAIN, удалим ранее отмеченную запись
				if (th && th.dataIndex && th.dataIndex === me.mainColumnName && checked) {
					var oldCheck = Ext.Array.filter(me.checkList, function(d) { return d.data.LINK !== rec.get('LINK') && d.data.MAIN;})[0];
					if (oldCheck) {
						oldCheck.set(me.mainColumnName, false);
						// Если отбираем только одну основную, вне списка объектов КМ/Планирование
						if (!me.onlyOneMain && me.mainColumnSingleCheck && me.gksc('MultiSelectGrid')){
							let oldCheckMulti = Ext.Array.filter(me.gksc('MultiSelectGrid').store.data.items, function(d) { return d.data.LINK !== rec.get('LINK') && d.data.MAIN;})[0];
							if (oldCheckMulti) {
								oldCheckMulti.set(me.mainColumnName, false);
							}
						}
					}					
				}
				else{
					res = true;
				}

				me.Grid.view.refresh();
				if (me.gksc('MultiSelectGrid')) me.gksc('MultiSelectGrid').view.refresh();
			}

			return res;
		},

		createCheckColumn: function(columns) {
			var me = this,
				hasHeaderPadding = false;
			
			Ext.each(columns, c => hasHeaderPadding |= c.headerPadding && c.headerPadding > 0);

			if (ArrayLib.find(columns, ['dataIndex'], 'М') === -1) {
				columns.unshift(me.mColumn = Ext.create('Keysystems.grid.column.CheckColumnExtra',
					{
						dataIndex: 'M',
						width: 40,
						text: 'M',
						draggable: false,
						resizable: true,
						readOnly: me.readOnly,
						headerPadding: hasHeaderPadding ? 22 : 0,
						tdCls: 'x-reviz-choice-column',
						index: -2,
						listeners: me.checkListeners,
						checkRenderer: me.checkRenderer
					}));
			}
			return columns;
		},
		checkModelChange: function(checked, rec, childRec) {
			var me = this,
				isMainRec = !!rec,
				rec = rec || childRec;

			if (checked && me.mode !== 'MULTI') {
				Ext.each(me.checkList,
					function(cr, i) {
						var link = (cr.data || cr)[me.fieldLink];
						if ((rec.data || rec)[me.fieldLink] != link) {
							var r = me.Grid.store.getRecord(link, me.fieldLink);
							if (r) r.set('M', false);
							me.checkList.splice(i, 1);
						}
					},
					_,
					true);
			}

			var iPos = ArrayLib.find(me.checkList, ['data', me.fieldLink], rec.data[me.fieldLink]);
			if (iPos === -1) iPos = ArrayLib.find(me.checkList, [me.fieldLink], rec.data[me.fieldLink]);

			if (checked) {
				if (iPos === -1) {
					if (!me.readOnly && me.mainColumn && me.mainColumnEditable && !me.getChecks().length &&
						me.getRevizOneMain(checked, rec) === true) {
						if (!isMainRec) {
							rec.set(me.mainColumnName, true);
							me.checkMGridRecord(rec, true);
						}
					}
					me.checkList.push(rec);
				}
			} else {
				if (iPos !== -1) me.checkList.splice(iPos, 1);
				if (me.mainColumnEditable) {
					rec.set(me.mainColumnName, false)
					me.checkMGridRecord(rec, false);
				}

				me.checkRecord(rec, false);
			}

			me.setChecks(me.checkList);
		},
		getColumnsProfileKey: function() {
			let me = this;
			if (!me.columnsProfileKey) {
				me.columnsProfileKey = me.getProfileKeyPrefix() + me.profileKey + 'GridColumns';
			}
			return me.columnsProfileKey;
		},
		getProfileKeyPrefix: function() {
			let me = this;
			return (me.prefix ? me.prefix + '_' : '') +
				(me.code ? me.code + '_' : '') +
				((me.gateCode || me.GateCode) ? (me.gateCode || me.GateCode) + '_' : '') +
				(me.controlName ? me.controlName + '_' : '');
		},
		baseGetData: function(endFunc, params) {
			var me = this;

			params = params || {};
			params.isProfile =
				true; //!LocalStorage.get(me.getColumnsProfileKey(), true);  //todo грузить всегда, пока не введены версии
			params.whereArgs = params.whereArgs ? JSON.stringify(params.whereArgs) : '';
			params.filter = me.getFilter();
			params.checkUserError = !!me.checkUserError; // проверять на доступность
			params.checkModel = !!me.checkModel;
			if (params.needToolbar == null) params.needToolbar = !me.hideTBar;
			if (me.checkModel) params.checkLinks = ArrayLib.getLinks(me.getChecks(), _, 1);
			
			if (!window.cachedResources["LIST_" + me.code])
				params.needResource = true;
			else
				delete params.needResource;
				

			const funcShowLoadMask = (rid) => me.showLoadMask({
				msg: params.reload ? KS.L10n.updating_data : KS.L10n.loading_data,
				iconCt: me.tabMode ? me.objs.view : null,
				rid: rid,
				opaque: !params.reload,
				cancelFn: function () {
					me.isExit = true;
					if (me.ridGet) SignalR.delCallBack(me.ridGet);
					me.objs.view.close();
				}
			});
			if (me.functions && me.functions.getData) {
				funcShowLoadMask();
				me.functions.getData.call(me,
					function (data) {
						if (me.isExit) return;
						me.hideLoadMask();
						if (endFunc) endFunc(data);
					},
					params);
			} else {
				me.ridGet = ajaxRequest({
					url: me.linkCode + '/Get_A',
					params: {gzipData: SignalR.pack(params)},
					success: function (result) {
						if (result.usererror || result.ban) { //ошибка на уровне проверки пользователя
							var msg = result.usererror || data.ban;
							msg = msg.replace(new RegExp('\r\n', 'g'), '<br>');
							me.loadMask.setErrorState(msg);
							return false;
						}						
						endFunc(result);
					},
					failure: function (response) {
						console.error(response);
						//showError(wmc.get('ErrorGetData'));
						me.loadMask.setErrorState();
					},
					callback: function () {
						delete me.ridGet;
					}
				});
				funcShowLoadMask(me.ridGet);
			}
		},
		
		setColumnManager: function(columns) {
			var me = this;
			if (me.columnManager) {
				me.columnManager.adaptedColumns(columns);
				me.columnManager.update();
			} else {
				me.creColumnManager(columns);
			}
		},
		creColumnManager: function(columns, grid) {
			var me = this;

			if (!grid) grid = me.objs.Grid;

			me.columnManager = Ext.create('Keysystems.Controls.Grid.ColumnManager',
				{
					inputColumns: columns,
					code: me.profileCode || me.code,
					linkCode: me.profileLinkCode,
					prefix: me.prefix,
					profileKey: (me.profileKey || '') + 'GridColumns',
					gateCode: me.GateCode,
					controlName: me.controlName,
					grid: grid
				});
		},

		//фоновая подгрузка предыдущей и следующей страницы
		getNextPrevPage: function(page, size, total, p) {
			var me = this;
			setTimeout(function() {
					p = p ||
					{
						whereArgs: me.appEndWhereArgs(me.getWhereArgs()),
						GateCode: me.GateCode,
						controlName: me.controlName,
						pageSize: size,
						order: me.getOrder(operation),
						filter: me.getFilter()
					};
					var pj = JSON.stringify(p);
					if (page > 1) {
						p = JSON.parse(pj);
						p.page = page - 1;

						PageDataLib.get(p);
					}
					var t = page * size - 1;
					if (t < total) {
						p = JSON.parse(pj);
						p.page = page + 1;

						PageDataLib.get(p);
					}
				},
				10);
		},

		/**
		 * Получить данные
		 * @param reload {boolean} полное обновление обновить с БД
		 */
		getData: function(reload) {
			let me = this,
				p = {
					whereArgs: me.appEndWhereArgs(me.getWhereArgs()),
					GateCode: me.GateCode,
					controlName: me.controlName,
					page: me.startPage,
					pageSize: me.gridStore.pageSize,
					reload: me.reloadData || reload,
					needToolbar: me.needToolbar
				};			
			me.baseGetData(function(data) {
					if (data) {
						if (me.beforeSetData(data, p) === false) return;
						me.setData(data.data);
					}
				},
				p);
		},

		beforeSetData: function(data, p) {
			var me = this,
				objs = me.objs,
				reload = p && p.reload;

			const errorMsg = data.ErrorMsg || data.data.ErrorMsg;
			if (errorMsg) {
				//info(errorMsg);
				me.loadMask.setErrorState(errorMsg);
				return false;
			}

			if (data.profile) {
				//console.log('Загрузка профиля окна списка (Начало)');
				for (let key in data.profile) {
					//console.log(key);
					if (key === "ListExtra") continue;
					LocalStorage.set(key, data.profile[key], true);
				}
				//console.log('Загрузка профиля окна списка (Конец)');
			}
			
			//повторно тулбар не строим
			if (!me.toolbar?.items || !me.toolbar.items.items.length)
				me.buildToolbar(data);
			
			if (me.multiSelectGridVisible && me.mode === 'MULTI' && me.checkModel && !me.tabMode) {
				let checkLinks = p.checkLinks ? JSON.parse(p.checkLinks) : [],
					checkRows = (data.data.data ?? data.data)?.filter(d => {
						return checkLinks.indexOf(d.LINK) !== -1;
					}) || [];
				
				me.gksc('splitterMSG').show();
				var mgrid = me.gksc('MultiSelectGrid');
				var cols = KsLib.objCopy(data.columns);
				if (me.mainColumn && ArrayLib.find(cols, ['dataIndex'], 'MAIN') === -1) {
					cols.unshift({
						xtype: 'checkcolumnextra',
						dataIndex: me.mainColumnName,
						width: 60,
						text: 'Основной',
						index: -1,
						listeners: {
							checkchange: function (th, indx, checked, rec) {
								let parentRec,
									i = -1,
									checkVal = checked;

								if (checked && me.getRevizOneMain(checked, rec, th, true)) {
									checkVal = false;
								}

								if (me.Grid.store.getRootNode) {
									// древовидная форма
									let allRecs = me.Grid.store.getRootNode().childNodes;

									Ext.each(allRecs, function (child) {
										parentRec = me.getRowByLink(child, rec.data[me.fieldLink]);
										if (parentRec) {
											return false;
										}
									});

									if (parentRec) {
										i = allRecs.indexOf(parentRec);
										parentRec.set(me.mainColumnName, checkVal);
									}

								} else {
									// обычная форма
									parentRec = me.Grid.store.findRecord(me.fieldLink, rec.data[me.fieldLink]);
									if (parentRec) {
										parentRec.set(me.mainColumnName, checkVal);
										i = me.Grid.getStore().indexOf(parentRec);
									}
								}

								var index = ArrayLib.find(me.Grid.visibleColumnManager.columns, ['dataIndex'], 'MAIN');
								me.Grid.visibleColumnManager.columns[index].fireEvent('checkchange',
									me.Grid.visibleColumnManager.columns[index], i, checkVal, parentRec, _, _, rec);

								// один Основной
								if (checkVal !== checked) {
									rec.set(me.mainColumnName, checkVal);
								}
							}
						}
					});
				}
				var flds = KsLib.objCopy(data.fields);
				if (me.mainColumn && (!me.thereIsField(flds, me.mainColumnName))) flds.push(me.mainColumnName);
				mgrid.setMetaDate({
						columns: allColumnAdapted(cols),
						fields: flds,
						data: checkRows
					},
					{
						profileCode: me.code,
						GateCode: me.GateCode,
						profileKey: 'MultiSelectGrid'
					});
				mgrid.show();
			}

			if (data.resource) {
				window.cachedResources["LIST_" + me.code] = true;
				Ext.apply(KS.L10n, data.resource);
			}

			data.fields = me.fieldsAdapted(data.fields);
			data.columns = me.columnsAdapted(data.columns);
			me.setColumnManager(data.columns);
			objs.Grid.store.setFields(data.fields);

			me.banLinks = data.banLinks || [];
			me.readOnlyLinks = data.readOnlyLinks || [];

			data.data.page = me.startPage;
			p.linkCode = me.linkCode;
			p.filter = me.getFilter();
			p.contextWA = JSON.stringify(data.data.contextWA);
			PageDataLib.set(PageDataLib.getKey(p), me.startPage, p.pageSize, JSON.parse(JSON.stringify(data.data)));

			if (me.pagingOn && !me.ignoreLoadNextPrevPages) me.getNextPrevPage(me.startPage, p.pageSize, data.data.total, p);
			
			if (data.data.order) {				
				let order = JSON.parse(data.data.order);
				if (order.name && order.type){
					//здесь при включении remoteSort: true будут еще раз рефрешиться данные через сервак.
					//без этого функционала не показывается индикатор сортировки					
					objs.Grid.store.sort({ property: order.name, direction: order.type });
					
					//можно еще так
					//let sorters = objs.Grid.store.getSorters();
					//sorters.add({ property: order.name, direction: order.type === 'DESC' ? 'ASC' : 'DESC' });
					//objs.Grid.down('headercontainer').getGridColumns().filter(clm=>clm.dataIndex === order.name)[0].toggleSortState();
				}	
			}

			var aro = data.readOnly || me.accessReadOnly;
			if (aro) me.setAccess(aro);

			if (me.getReadOnly()) me.setReadOnly(true);

			if (data.data.contextWA) {
				me.contextWA = data.data.contextWA;
			}
			return true;
		},

		setData: function(data, endFunc) {
			var me = this,
				store = me.objs.Grid.store,
				pagingTool = me.pagingTool;


			if (data.pageSize) {
				pagingTool.setPageSize(data.pageSize);
				pagingTool.setMaxPageSize(data.maxPageSize);
				pagingTool.setVisible(data.pagingOn);
			}

			me.dataCount = data.total;

			me.firstSelect = true;

			if (!me.objs.Grid.view.store.model) {
				me.objs.Grid.view.store.model = store.model;
			}
			
			me.objs.Grid.loadData(data.data, false);

			store.totalCount = data.total;
			store.currentPage = data.page;
			pagingTool.page = data.page;
			pagingTool.total = data.data.length;
			if (!me.hidePagging) {
				pagingTool.doRefresh();
			}

			var mro = _;
			if (me.mColumn) {
				mro = me.mColumn.readOnly;
				me.mColumn.readOnly = false;
			}

			me.setChecks(me.checkList);

			if (me.mColumn) me.mColumn.readOnly = mro;

			me.setSelect(me.selectLinks);
			const selected = me.Grid.getFrstSelect();
			if (selected) me.Grid.getView().focusRow(selected);
			
			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
			// Иногда не выставляется чек в колонке Основной 
			if (me.gksc('MultiSelectGrid')) me.gksc('MultiSelectGrid').view.refresh();
			me.afterRefresh();

			me.afterSetData();
			if (endFunc) endFunc();
		},
		
		afterSetData: function(){
			let me = this;
			me.isLoading = false;
			me.hideLoadMask();
		},
		select: function(model, selected) {
			var me = this;
			if (!model.store) {
				model.store = me.objs.Grid.getStore();
				if (!model.views.length) {
					model.views = [me.objs.Grid.view];
				}
			}
			model.select(selected);
		},
		createSelModel: function() {
			var me = this;

			if (me.checkModel) me.checkList = me.checkList || (me.selectLinks ? ArrayLib.copy(me.selectLinks) : []);
			me.checkList = me.checkList || [];
			if (!me.selectLinks) me.selectLinks = ArrayLib.copy(me.checkList);
			if (me.mode === 'SINGLE') me.mode = 'SINGL';
			me.objs.selModel = Ext.create('Ext.selection.RowModel',
				{
					mode: me.mode
				});			
		},
		createSubGridSelModel: function() {
			return Ext.create('Ext.selection.RowModel',
				{
					mode: this.subGridMode
				});
		},
		addRecord: function(row) {
			var me = this,
				grid = me.objs.Grid,
				rec = grid.store.createModel(row);
			grid.loadData([rec], true);
			me.refresh(true, 1);
			return rec;
		},
		setRecord: function (row, cmp) {
			var me = this,
				multiSelectGrid = me.gksc('MultiSelectGrid');
			cmp.data.set(row);
			if (multiSelectGrid) {
				var rec = multiSelectGrid.getStore().getRecord((row.data || row)[me.fieldLink], me.fieldLink);
				if (rec) {
					rec.set(row);
				}
			}
			this.refresh(true, 1);
		},
		updateRecord: function(row){
			const me = this;
			const store = me.Grid.getStore();
			let rec = store.findNode
				? store.findNode('LINK', (row.data || row).LINK)
				: store.findRecord('LINK', (row.data || row).LINK);
			if (rec) {
				rec.set(row);
			}
		},
		/**
		 * Обновить штамп для записи списка
		 * @param link линк записи
		 * @param stamp новый штамп
		 */
		updateStamp: function(link, stamp){
			const me = this;
			const store = me.Grid.getStore();
			let rec = store.findNode
				? store.findNode('LINK', link)
				: store.findRecord('LINK', link);
			if (rec) rec.set('STAMP', stamp);
		},
		selectRecord: function(rec, grid) { grid.extraSelect(rec); },
		new: function() {
			this.edit('new', null);
		},
		newSame: function() {
			let me = this,
				sel = me.objs.Grid.getFrstSelect();
			if (!sel)  return;
			    
			me.edit('copy', sel);
		},
		doEdit: function (){
			let me = this,
				sel = me.objs.Grid.getFrstSelect();
			if (!sel)  return;
			me.edit('edit', sel);
		},
		doAutoFilter:function () {
			let me = this;
			me.Grid.autoFilter((complete) => {
				if (me.objs.changeSelMod){
					me.objs.changeSelMode.setText(complete ? 'Выделить строку' : 'Выделить ячейку');
					me.objs.changeSelMode.setIconCls(complete ? 'x_btn_row' : 'x_btn_cell');					
				}
			});
		},
		showRelations: function(){
			let me = this,
				sel = me.objs.Grid.getSelectionModel().getSelection();
			if (!sel.length) return;

			Ext.create('RevizorRelationsView',
				{
					tabMode: me.tabMode,
					parentView: me.parentView,
					title: 'Связи документа - ' + me.title + ' - Отобрано:' + sel.length,
					code: me.code,
					links: ArrayLib.getLinks(sel)
				});	
		},
		doBatchChange: function(){
			let me = this,
				grid = me.objs.Grid,
				rowsSelected = grid.getSelectionModel().getSelection(),
				rowsChecked = this.getChecks(),
				curLinks = (rowsChecked && rowsChecked.length ? rowsChecked : rowsSelected).map(r => +r.data.LINK);
			
			if (curLinks.length > 1) {
				me.showBatchChange(curLinks);
			} else {
				let allLinks = grid.store.getLinks();
				if (!allLinks) return _;
				
				Ext.Msg.show({
					title: 'Пакетная замена',
					buttons: Ext.MessageBox.YESNOCANCEL,
					buttonText: {yes: 'Во всех записях', no: 'В текущей', cancel: 'Отмена'},
					msg: wmc.get('DoBatchChange'),
					fn: function (buttonId) {
						if (buttonId === 'yes') me.showBatchChange(allLinks);
						if (buttonId === 'no') me.showBatchChange([curLinks[0]]);
					},
					icon: Ext.MessageBox.QUESTION
				});
			}
		},
		enableToolShowActual: function(value, btn){
			if (!this.objs.tbarBtns) return;
			
			if (!btn) btn = this.objs.tbarBtns.show_actual;
			if (!btn) return;
			btn.setIconCls(value ? 'x_btn_fill_calendar' : 'x_btn_empty_calendar');
			btn.setTooltip(value ? 'Показать все' : 'Показать актуальные');
			if (value)
				btn.setPressed(true);
			else
				btn.setPressed(false);
			
		},
		doShowActual: function(th){
			let me = this;
			
			ajaxRequest({
				url: 'data/SaveShowActualToProfile',
				params: {
					code: me.code,
					gateCode: me.GateCode,
					value: th.pressed
				}
			});
			me.enableToolShowActual(th.pressed, th);
			me.showActual = th.pressed;
			me.refresh();
		},		
		setFilter: function(filter, variant) {
			let me = this;
			me.filter = filter;
			me.profileManager.set('filterVariant', variant || 0);
			me.sksd('filterVariant', variant);
			
			me.updFilterBtns();
			me.refresh();
			let jsonFilter = me.getFilter();
			ajaxRequest({
				url: 'data/SaveFilterToProfile_A',
				params: {
					code: me.code,
					gateCode: me.GateCode,
					filter: jsonFilter,
					profile: JSON.stringify(me.profileManager.getProfile()),
				}
			});
		},
		doClose: function() {
			this.objs.view.close();
		},	
		isModalEdit: function(){
			let me = this;
			return !(me.viewMode === 'tabShow' && !window.modalEdit && me.parentView && me.parentView.id === 'ks-main-tab-panel')	 
		},
		edit(f, data, defCfg) {
			var me = this,
				cfg = {
					f: f === 'edit' && (me.accessReadOnly || me.checkReadOnly(data)) ? 'readOnly' : f,
					data: data,
					code: me.code,
					dictList: me,
					refreshFunc: function() { me.refresh(); },
					tabMode: !me.isModalEdit(),
					parentView: me.objs.view,
					inputDicts: me.inputDicts,
					whereArgs: me.appEndWhereArgs(me.getWhereArgs()),
					setRecord: function(row, cmp) { return me.setRecord(row, cmp); },
					updateRecord: function(row) { return me.updateRecord(row); },
					addRecord: function(row) { return me.addRecord(row); },
					updateStamp: (link, stamp) => me.updateStamp(link, stamp),
					selectRecord: function(rec) {
						//Иначе иконка у isFileBtn не очищается
						if (me.fileColumn) me.objs.Grid.getSelectionModel().deselectAll();

						me.selectRecord(rec, me.objs.Grid);
					}
				};

			Ext.apply(cfg, dictListController[me.code]);

			for (var key in me.initialConfig)
				if (cfg[key] !== me.initialConfig[key] && me.ignoreEditInitialConfig.indexOf(key) === -1)
					cfg[key] = me.initialConfig[key];

			//Ext.apply(cfg, me.initialConfig);

			cfg.title = me.title;
			cfg.linkCode = me.linkCode;

			if (defCfg) {
				Ext.apply(cfg, defCfg);
			}

			if (me.functions && me.functions.edit) {
				me.functions.edit(cfg);
			} else {

				const funcEdit = function() {
					Ext.create(me.editClass || cfg.editClass, cfg);
				};
				let tab = cfg.tabMode && cfg.f === 'edit' &&  data?.data?.LINK 
					? window.tabView.items.items.filter(tab => tab.code === me.code && tab.link === data?.data?.LINK)[0]
					: null;
				if (tab){
					selectDialogShow(
						KS.L10n.attention,
						Ext.String.format(KS.L10n.already_open_edit, cfg.title),
						() => funcEdit(),
						() => tab.show()
					);
				}
				else {
					funcEdit();
				}
			}
		},
		
		showColumnManager: function(){
			let me = this;
			if (me.columnManager) me.columnManager.show();
		},
		
		enableWrap: function(btn){
			let me = this,
				grid = me.objs.Grid;
				
			if (grid.autoheightrows) {
				grid.getEl().removeCls(me.autoheightrowsCls);
				btn.setIconCls('x_btn_wrap');
				btn.setTooltip(wmc.get('Wrap'));
			} else {
				grid.getEl().addCls(me.autoheightrowsCls);
				btn.setIconCls('x_btn_nonwrap');
				btn.setTooltip(wmc.get('NonWrap'));
			}
			grid.autoheightrows = btn.pressed;	
		},

		//#region Filter

		/**
		 * Выставить доступность кнопок фильтрации панели инструментов
		 */
		enableToolFilter: function() {
			if (!this.objs.tbarBtns) return;
			
			let me = this,
				tbarBtns = me.objs.tbarBtns,
				btnUndo = tbarBtns ? tbarBtns.reset : _,
				btnSearch = tbarBtns ? tbarBtns.search : _;
			if (me.filter) {
				if (me.checkCondition(me.filter)) {
					//выставляем картнку о нажатом фильтре
					btnSearch && btnSearch.addCls(me.searchBtnCls);
					btnUndo && btnUndo.setDisabled(false);
				} else {
					btnSearch && btnSearch.removeCls(me.searchBtnCls);
					btnUndo && btnUndo.setDisabled(true);
				}
			} else {
				btnSearch && btnSearch.hide();
				btnUndo && btnUndo.hide();
			}
		},

		getFilterValue: function(el) {
			var v = el.Value;
			switch (miscTypes.ControlType[el.ControlType]) {
			case 'Dictionary':
				return ArrayLib.getLinks(v, _, 1);
			case 'DatePeriod':
			case 'ComboBox':
				return JSON.stringify(v);
			}

			return v;
		},

		/**
		 * Получить фильтр списка в формате JSON
		 * @returns {string}
		 */
		getFilter: function() {
			var me = this;
			if (!me.filter) return '[]';
			if (me.filter.asString) return me.filter.asString;

			var res = [];
			Ext.each(me.filter,
				function(el) {
					if (el.Condition !== null && el.Condition !== -1 && el.Value !== null) {
						res.push({
							Name: el.Name,
							Condition: el.Condition,
							Value: me.getFilterValue(el)
						});
					}
				});

			return me.filter.asString = JSON.stringify(res);
		},
		/**
		 * Отобразить  форму фильтрации
		 */
		search: function() {
			let me = this;
			try {
				let filterForm = Ext.create('Revizor.FilterView',
					{
						title: me.title + ' - Фильтр',
						code: me.code,
						variant: me.gksd('filterVariant'),
						//другая логика по сравнению с вином, 
						//там чеки в листе мероприятий видны в зависимости от доступности ЕИС и ГИС
						selectListAction: me.checkModel && me.mode === 'MULTI' ?
							((NavigatorLib.checkModelList && NavigatorLib.checkModelList.indexOf(me.code) >= 0) ? 5 : 1) : 0,
						filter: me.filter.map(p => Object.assign({}, p)),
						closeAction: 'hide',
						ok: function (filter, variant) {
							me.updFilterBtns();
							me.setFilter(filter, variant);
						}
					});
				me.beforeShowFilterView(filterForm.filter);
				filterForm.show();
			} catch (e) {
				window.failureShow({statusText: e.stack}, "Внимание");
				throw e;
			}
			me.updFilterBtns();
		},
		
		/** Выполнить перед отображением формы параметров фильтрации */
		beforeShowFilterView: function(pars){
			
		},

		updFilterBtns: function() {
			let me = this,
				hasFilter = me.checkCondition(me.filter);

			me.needBanLinks = hasFilter && me.checkModel;
			me.enableToolFilter();		
		},

		checkCondition: function(filter) { //установлен ли фильтр?
			for (var i = 0; i < filter.length; i++) {
				if (filter[i].Condition !== -1 && filter[i].Condition !== null && !filter[i].ReadOnly) return true;
			}
			return false;
		},

		/**
		 * Сбросить фильтр
		 */
		undo: function() {
			let me = this;
			me.clearBanLinks();
			Ext.each(me.filter,
				function(el) {
					if (!el.ReadOnly) {
						el.Condition = -1;
						el.Value = null;
					}
				});
			delete me.filter.asString;
			me.setFilter(me.filter);
		},

		//#endregion Filter

		clearBanLinks: function() { this.banLinks = []; },
		delete: function() {
			const me = this;
			let	sels = [];
			if (me.checkModel && me.delByChecked) {
				sels = me.checkList;
			}
			if (!sels?.length) { 
				sels = me.objs.Grid.getSelectionModel().getSelection();
			}
			const len = sels.length;
			if (!len) return;

			const endFunc = () => {
				selectDialogShow(KS.L10n.delete,
					wmc.get('DeleteMessage', len), 
					function () {
						const links = sels.map(r => r.data[me.fieldLink]);
						
						if (me.functions && me.functions['delete']) {
							me.functions['delete'].call(me,
								links,
								function (result) {
									if (me.stopDel) return;
									me.hideLoadMask();
									if (result) {
										me.refresh();
									}
								},
								me.tabMode,
								me.parentView);
						} else {
							const rows = sels.map(r => {return {LINK: r.data[me.fieldLink], STAMP: r.data.ORIGINAL_STAMP ?? r.data.STAMP}});
							me.showLoadMask({
								msg: KS.L10n.delete + '...',
								rid: ajaxRequest({
									params: {
										code: dnl[me.deleteCode] || me.deleteCode,
										data: JSON.stringify(rows),
									},
									url: 'data/BeforeDelete_A',
									success: function (value) {
										const checkStampResults = value ? value["checkStampResults"] : null;

										const funcDelete = function () {
											if (!links.length) {
												me.hideLoadMask();
												return;
											}
											
											ajaxRequest({
												params: {
													code: dnl[me.deleteCode] || me.deleteCode,
													links: links,
													recursive: false
												},
												url: 'data/DelSDictionary_A',
												success: function (value) {
													if (value.errorMessage) {
														me.hideLoadMask();
														window.failureShow({
															statusText: value.errorMessage,
															messageText: "Ошибка при удалении."
														}, KS.L10n.attention);
														return;
													}

													var notDel = value.notDel;
													if (me.checkModel && me.delByChecked)
														me.checkList = notDel
															? me.checkList.filter(function (l) {
																return value.notDelLinks.indexOf(l.data.LINK) !== -1;
															})
															: [];
													if (notDel && notDel.length)
														relationsMsg(me.code, notDel, value.notDelLinks, me.tabMode, me.parentView);
													if (me.checkModel) {
														Ext.each(sels,
															function (rec) {
																me.checkModelChange(false,
																	me.Grid.store.getRecord((rec.data || rec)[me.fieldLink],
																		me.fieldLink), rec);
															});
													}
													me.hideLoadMask();
													notDel.length !== links.length && me.refresh();
												},
												callback: function () {
													delete me.ridDel;
												}
											});
										};

										const funcShowCheckStampMessage = function (i) {
											ChooseBox.ShowCheckStampMessage(checkStampResults[i], (checkStampResult) => {
												if (checkStampResult.Action === 9){ //отмена 
													me.hideLoadMask();
													return;
												}

												if (checkStampResult.Action === 7) { //оставить - не удалять
													const index = links.indexOf(checkStampResult.Link);
													if (index > -1) links.splice(index, 1);
												}
												if (i < checkStampResults.length - 1) {
													funcShowCheckStampMessage(i + 1);
												} else {
													funcDelete();
												}
											})
										};

										if (checkStampResults?.length) {
											funcShowCheckStampMessage(0);
										} else {
											funcDelete();
										}
									},
									
								}),
								cancelFn: function () {
									me.stopDel = true;
									if (me.ridDel) SignalR.delCallBack(me.ridDel);
								}
							});
						}
					});
			};
			me.beforeDeleteFn(endFunc, sels);
		},
		profileOnClear: function() {
			//alert('Очистка профиля->' + this.getColumnsProfileKey());
			var me = this;
			selectDialogShow(wmc.get('CleanProfileTitle'),
				wmc.get('CleanProfile', this.title),
				function() {
					var code = me.code,
						dict = getDictParent(dictListController[code]);
					code = dict.profileCode || dict.$parentCode || code;
					ajaxRequest({
						url: 'data/CleanProfile_A',
						params: { title: me.title, code: code || '', gateCode: me.GateCode || '' },
						success: function(result) {
							if (result) {
								me.cleanLocalProfile(result.title);
							}
						}
					});
				});

		},
		/**
		 * Очистить локальный профиль (в localStorage и cacheEngine)
		 * @param title
		 */
		cleanLocalProfile: function(title){
			const me = this;
			me.columnManager?.cleanProfile();
			me.profileManager?.clearProfile();
			info(wmc.get('ClearedProfil', title ?? me.title), ()=>{
				me.getData(true);
				me.Grid.clearColumnFilter();
				if (me.Grid.getFilterMode() === 'filterRow'){
					me.Grid.showFilterRow();
				}
			});
		},
		buildToolbar: function(data) {
			let me = this;
			
			if (data && data.toolbar) {
				me.toolbarModel = data.toolbar;
			}
			me.createTBar();
			if (!me.toolbar) return;

			me.objs.tbar.forEach(item => {
				me.toolbar.add(item);
			})

			if (data) {
				me.enableToolFilter();
				me.enableToolShowActual(data.showActual);

				//проверка только для локального тулбара, в модели с сервера уже все отрабывает
				if (!me.toolbarModel && me.objs.tbarBtns && me.objs.tbarBtns.show_actual && data.fields) {
					let pos = data.fields.indexOf('DH1');
					if (pos === -1) pos = ArrayLib.find(data.fields, ['name'], 'DH1');
					if (!me.objs.tbarBtns.show_actual.hidden) me.objs.tbarBtns.show_actual[pos === -1 ? 'hide' : 'show']();
				}
			}
		},
				
		createTBar: function() {
			let me = this;
			me.buildTBar.call(this);
			return me.objs.tbar;
		},		
		createGridListeners: function() {
			var me = this,
				objs = me.objs,
				funcs = me.functions;

			objs.gridListeners = {
				selectionchange: function(th, selected) {
					if ((selected.length === 0 || me.firstSelect) && me.selectLinks.length) {
						me.firstSelect = false;
						me.setSelect([me.selectLinks[0]]);
						me.selectLinks.length = 1;
					} else {
						me.selectLinks = selected;
						me.firstSelect = false;
					}
					
					if (me.Grid.selModel.lastSelected && me.Grid.selModel.lastSelected.parentNode) {
						if (me.objs.tbarBtns?.make_child) {
							me.objs.tbarBtns.make_child.setDisabled(!me.Grid.selModel.lastSelected.parentNode.isRoot()
								|| me.Grid.selModel.lastSelected === me.gridStore.getAt(0)
								|| !me.selectLinks.length
								|| !me.canEdit(me.Grid.selModel.lastSelected));
						}

						if (me.objs.tbarBtns?.make_parent) {
							me.objs.tbarBtns.make_parent.setDisabled(me.Grid.selModel.lastSelected.parentNode.isRoot()
								|| !me.selectLinks.length
								|| !me.canEdit(me.Grid.selModel.lastSelected));
						}
					}
					
					me.setSBText(me.dataCount, me.selectLinks.length, me.checkList ? me.checkList.length : 0);
				},
				viewready: function (cmp) {
					cmp.getView().on('itemkeydown', function (cmp, rec, item, index, e) {
						const eventKey = e.getKey();
						switch (eventKey){
							case e.DELETE:
								me.delete();
								break;
							case e.SPACE:
								if (!me.checkModel || !me.mColumn) return;
								const rec = me.objs.Grid.getFrstSelect();
								if (!rec) return;

								const index = me.Grid.getStore().indexOf(rec);
								me.mColumn.fireEvent('checkchange', me.mColumn, index, !!!rec.get('M'), rec);								
								break;
						}
					});
				},
				reconfigure: function(){
					if (!me.isLoading) return;
					
					const cols = me.objs.Grid.headerCt.getGridColumns();
					if (me.fileColumn) {
						me.fileColumn = cols.filter(col => col.dataIndex === "FileColumn")[0];
						if (me.fileColumn) {
							//код старый и нерабочий, видимо когда-то предполагался драг-дроп на колонке с файлом
							UploaderLib.bindGrid(
								me.Grid.getTargetEl().dom,
								me.Grid.view,
								'x-grid-cell-headerId-' + me.fileColumn.getId(),
								function (link, ext, rec, callback) {
									me.updFileRecord({id: link, ext: ext}, rec);
									callback();
								}
							);
						}
					}
				}
		};

			if (funcs.select) objs.gridListeners.select = funcs.select;
			if (funcs.deselect) objs.gridListeners.deselect = funcs.deselect;
			if (me.fileColumn) {
				objs.gridListeners.select = function (th1, record, item, index, e, eOpts) {
					if (!record.data) return;
					me.objs.gridTBar[0].setIconCls(getExtStyle(record.get(me.fieldExt)));
					me.objs.gridTBar[0].setDisabled(me.accessReadOnly && !record.get(me.fieldFile));
					if (funcs.select) funcs.select(th1, record, item, index, e, eOpts);
				};
			}
			if (me.isItemDblClick) {
				if (funcs.ok) {
					objs.gridListeners.itemdblclick = function(th1, record, item, index, e) {
						if (me.disallowedToCheckLinks && me.disallowedToCheckLinks.indexOf(record.data.LINK) !== -1) return;
						if (Ext.fly(e.target)?.hasCls('x-tree-elbow-plus')) return;
						
						if (me.getReadOnly()) {
							if (funcs.edit || me.editClass) me.edit('edit', record);
							return;
						}

						if (me.mColumn && me.mColumn.fireEvent('beforecheckchange', me, index, true, record) === false
						) return;

						//Параметр указывающий что идёт закрытие формы
						me.isClosed = true;
						me.mColumn &&
							!record.get('M') &&
							me.mColumn.processEvent('ksEvent',
								me.Grid.view,
								_,
								me.Grid.getStore().indexOf(record),
								me.mColumn.index,
								_,
								record);

						if (!record.data.NAME) record.data.NAME = getDictRowName(record, me.code);
						if (me.mainColumn && me.mainColumnEditable && !me.readOnly) {
							record.set(me.mainColumnName, true);
							me.checkMGridRecord(record, true);
						}
						funcs.ok([record]);
						objs.view.close();
					};
				} else {
					objs.gridListeners.itemdblclick = function(th1, record, item, index, e) {
						if (Ext.fly(e.target)?.hasCls('x-tree-elbow-plus')) return;
						if (funcs.edit || me.editClass) me.edit('edit', record);
					};
				}
			}
		},
		createPaging: function(cfg) {
			var me = this,
				c = {
					pageSize: me.gridStore.pageSize,
					store: me.gridStore,
					pageSizeOnChange: function(value) {
						ajaxRequest({
							url: 'SSettings/SetValue_A',
							params: {
								objList: JSON.stringify([{
									Value: value,
									ObjCode: me.code,
									PropCode: 'NASTR_PAGING_SIZE',
									User: 0,
									IsRefer: false
								}])
							}
						});
					}
				};
			Ext.apply(c, cfg);
			var result = me.pagingTool = Ext.create('Keysystems.toolbar.Paging', c);
			return me.hidePagging ? null : result;
		},
		createStatusBar: function() {
			var objs = this.objs;
			return [
				objs.statusBarLeft = Ext.create('Ext.ux.StatusBar', { border: 0 }),
				objs.filterBarLeft = Ext.create('Ext.ux.StatusBar', { border: 0, hidden: true }),
				'->',
				objs.statusBarRight = Ext.create('Ext.ux.StatusBar', { border: 0 })
			];
		},
		setSBText: function(allCount, selCount, checkCount, filterCount) {
			var me = this,
				f1,
				f2,
				sbl = me.objs.statusBarLeft,
				sbr = me.objs.statusBarRight,
				fbl = me.objs.filterBarLeft,
				chText = '';

			if (sbl) {
				if (!sbl.rendered) {
					f1 = true;
					sbl.rendered = true;
				}
				if (sbl.allCount !== allCount) {
					sbl.allCount = allCount;
					sbl.setText(wmc.get('CountRows', allCount));
				}
				if (f1) sbl.rendered = false;
			}
			if (sbr) {
				if (me.checkModel) chText = wmc.get('Selected', checkCount) + ' ';
				if (!sbr.rendered) {
					f2 = true;
					sbr.rendered = true;
				}
				chText += wmc.get('Allocated', selCount);
				if (sbr.chText !== chText) {
					sbr.chText = chText;
					sbr.setText(chText);
				}
				if (f2) sbr.rendered = false;
			}

			let btns = me.objs.tbarBtns;
			if (btns) {
				//Если не может найти protoEl у btn значит что то не так. проверку на существование btn.protoEl тут добавлять нельзя
				Ext.each([btns.add_slave, btns.same, btns.edit, btns.delete, btns.relations],
					function (btn) {
						btn && btn.setDisabled(!selCount);
					});
				let btnJournalOne = btns.journal && btns.journal.menu ? btns.journal.menu.items.items.filter(item=>item.code === 'journal_one')[0] : null;
				if (btnJournalOne) btnJournalOne.setDisabled(!selCount);
			}

			if (fbl) {
				let emptyFilter = !filterCount;
				if (me.Grid?.store) {
					if (filterCount === undefined) {
						filterCount = me.Grid.store.visibleCount;
						const filters = me.Grid.store.getTreeFilters ? me.Grid.store.getTreeFilters() : me.Grid.store.getFilters().items;
						emptyFilter = !filters.length;
					}
					if (!emptyFilter && (!filterCount || me.Grid.store.data.length < filterCount)) {
						filterCount = me.Grid.store.data.length;
					}
				}
				
				fbl.setVisible(emptyFilter? false: Ext.isNumber(filterCount));
				fbl.setText('<div style="color:red;">'+ wmc.get('FilterApplied', filterCount) + '</div>');
			}
			me.checkReadOnly();
		},
		getOrder: function(operation) {
			if (!(operation && operation._sorters && operation._sorters.length)) return '';
			var me = this,
				s = operation._sorters[0],
				res = { name: s._property, type: s._direction };

			if (['M', me.mainColumnName].indexOf(s.property) !== -1) {
				var mlinks = [],
					mains = [];
				Ext.each(me.checkList,
					function(rec) {
						var b = rec.data || rec,
							l = b[me.fieldLink];
						if (l) {
							mlinks.push(l);
							if (b.MAIN) mains.push(l);
						}
					});
				res.mlink = JSON.stringify(mlinks);
				res.main = JSON.stringify(mains);
			}
			return JSON.stringify(res);
		},
		getListProxy: function() {
			var me = this;		

			return {
				type: 'memory',
				autoSync:true,
				$configStrict: false,
				read: function(operation) {
					if (!me.Grid) return;
					
					var me1 = this;
					if (operation.node && !operation.node.isRoot()) {
						me1.superclass.read.apply(me1, arguments);
						return;
					}

					// console.log('========== whereArgs ============ ');
					// console.log(me.whereArgs);
					me.baseRefresh(function(data) {
							if (!data) return;
							var resultSet = me1.getReader().read(data.data),
								records = resultSet.records,
								sorters = operation._sorters,
								groupers = operation._groupers,
								filters = operation._filters;

							resultSet.total = data.total;
							//scope.totalCount = data.total;
							me.dataCount = data.totalMaxCount || data.total;
							if (resultSet.success) {
								if (filters && filters.length) {
									records =
										Ext.Array.filter(records, Ext.util.Filter.createFilterFn(filters));
									resultSet.setRecords(records);
								}
								if (groupers && groupers.length) {
									sorters = sorters ? sorters.concat(groupers) : sorters;
								}

								if (sorters && sorters.length) {
									resultSet.setRecords(
										Ext.Array.sort(records, Ext.util.Sortable.createComparator(sorters)));
								}

								if (me.needBanLinks) {
									me.banLinks = data.banLinks || [];
									me.needBanLinks = false;
								}
								operation.setResultSet(resultSet);
								try {
									operation.setSuccessful(true);
								} catch(ex) {
								}
							}
							else {
								operation.setCompleted();
								// ReSharper disable Html.EventNotResolved
								me1.fireEvent('exception', me1, null, operation);
								// ReSharper restore Html.EventNotResolved
							}
	
							//todo посмотреть, где используется. закомментирование после перехода на ExtJS71
							//Ext.callback(callback, scope || me1, [operation]);

							//восстановим выделение, оно слетает при обновлении store
							let arrSel = [],
								store = me.Grid.getStore();

							let treeFilters = (operation.config.internalScope || operation.config.scope).treeFilters;
							if (treeFilters && treeFilters.length){
								//на событие фильтрации store повешено сохранение профиля. в итоге перебивается видимость строки фильтрации с повешенным фильтром на колонку
								store.suspendEvents();
								store.filter();
								store.resumeEvents();
							}
								
							me.selectLinks.forEach(rec=> {
								let sel = store.findNode
									? store.findNode('LINK', (rec.data || rec).LINK)
									: store.findRecord('LINK', (rec.data || rec).LINK);
								if (sel) arrSel.push(sel);
							});
							me.Grid.getSelectionModel().select(arrSel);
							me.selectLinks = arrSel;
							
							me.setExpand(me.expandedLinks);
							me.setChecks(me.checkList, records);
							me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
							KsLib.tryRun(me._afterRefresh, me);
							//KsLib.tryRun(me.afterRefresh, me, records);
							me.afterRefresh();
						},
						{
							whereArgs: me.appEndWhereArgs(me.getWhereArgs()),
							gateCode: me.GateCode,
							controlName: me.controlName,
							reload: me.pagingTool ? me.pagingTool.reload : false,
							page: operation.page || (me.gridStore && me.gridStore.currentPage) || me.startPage,
							pageSize: operation.limit || (me.gridStore && me.gridStore.pageSize) || me.pageSize,
							order: me.getOrder(operation),
							filter: me.getFilter(),
							checkLinks: me.needBanLinks ? ArrayLib.getLinks(me.getChecks(), _, 1) : _
						});
					if (me.pagingTool) me.pagingTool.reload = false;
				}
			};
		},
		getGridStore: function() {
			var me = this;
			return me.gridStore = Ext.create('Ext.data.Store', me.getGridStoreCfg());
		},
		getGridStoreCfg: function() {
			var me = this;
			return {
				//buffered : true,
				fields: [],
				data: [],
				pageSize: me.pageSize,
				listeners: { beforeload: function() { return !me.isCreate; } },
				//отключила remoteSort, вроде как все хорошо сортируется локально. 
				// для постраничного отображения сейчас сортировка в пределах страницы вне зависимости от remoteSort (в вине такая же картина) 
				//remoteSort: true,
				proxy: me.getListProxy()
			};
		},
		createGridTBar: function() {
			var me = this;
			if (me.fileColumn) {
				return me.objs.gridTBar = [
					Ext.create('Ext.Button',
						{
							text: 'Файл',
							handler: function() {
								let sel = me.objs.Grid.getFrstSelect();
								sel && me.fileEdit(sel);
							}
						})
				];
			}
			return _;
		},
		getRowClass: function(rec) {
			const me = this;
			const link = (rec.data || rec)[me.fieldLink];
			let cls = '';
			if (me.disallowedToCheckLinks?.indexOf(link) >=0) {
				cls += 'ks-disallowToCheck-row';
			}
			return cls;
		},
		getGridCfg: function() {
			var me = this,
				objs = me.objs;
			return {
				flex: 2,
				autoScroll: true,
				autoRender: true,
				contextMenuHidden: true,
				tbar: me.createGridTBar(),
				border: 0,
				features: [
					{
						ftype: 'summary',
						showSummaryRow: false
					}
				],
				selModel: objs.selModel,
				plugins: ['bufferedrenderer', 'gridclipboard'],
				store: me.getGridStore(),
				bbar: me.createPaging(),
				columns: [],
				columnLines: true,
				listeners: objs.gridListeners,
				viewConfig: { getRowClass: function(rec) { return me.getRowClass(rec); } }
			};
		},
		createItems: function() {
			var me = this,
				objs = me.objs;
			me.isCreate = true;
			objs.items = [
				me.Grid = objs.Grid = Ext.create('Ext.grid.Panel', me.getGridCfg()),
				me.sksc('splitterMSG', Ext.create('Ext.resizer.Splitter', { hidden: true, collapsible: true, collapseDirection: 'bottom' }))
			];
			if (me.multiSelectGridVisible) objs.items.push(me.sksc('MultiSelectGrid', me.createMultiSelectGrid()));
			me.isCreate = false;
			return me.objs.items;
		},
		beforeSetWhereArgs: function(){
			let me = this;
			me.loadProfile(me.extraProfile);
			me.updateProfileListeners(true);
		},
		loadProfile: function (v) {
			if (v) {
				let me = this,
					profileValues = JSON.parse(v);
				if (profileValues.filterVariant) {
					if (me.gksd('filterVariant') !== profileValues.filterVariant) {
						me.sksd('filterVariant', profileValues.filterVariant);
					}
				}
			}
			return this.callParent(arguments);
		},
		/**
		 * Инициализировать контролы панели фильтрации по аргументам списка
		 */
		initializeFilter: function () {
		},
		//#region MultiSelectGrid

		getMultiSelectGridCfg: function() {
			var me = this,
				functions = me.functions;
			return {
				hidden: true,
				autoScroll: true,
				autoRender: true,
				flex: 1,
				border: 0,
				selModel: { mode: 'MULTI' },
				tbar: [
					Ext.create('Ext.Button',
						{
							key: 'edit',
							iconCls: 'x_btn_edit',
							tooltip: 'Редактировать',
							tooltipType: 'title',
							disabled: true,
							hidden: me.btnsHide.edit || (!(functions.edit || me.editClass)),
							handler: function() {
								var rec = me.gksc('MultiSelectGrid').getFrstSelect();
								if (!rec) return;
								me.edit('edit', rec);
							}
						}),
					Ext.create('Ext.Button',
						{
							key: 'open',
							iconCls: 'x_btn_open',
							tooltip: 'Открыть',
							tooltipType: 'title',
							hidden: true,
							disabled: true,
							handler: function() {
								var rec = me.gksc('MultiSelectGrid').getFrstSelect();
								if (!rec) return;
								me.edit('readOnly', rec);
							}
						}),
					Ext.create('Ext.Button',
						{
							key: 'delete',
							iconCls: 'x_btn_delete',
							tooltip: 'Удалить',
							tooltipType: 'title',
							disabled: true,
							handler: function() {
								var sels = me.gksc('MultiSelectGrid').getSelectionModel().getSelection(),
									len = sels.length;
								if (len) {
									selectDialogShow(KS.L10n.attention,
										'Разметить выбранное?',
										function() {
											Ext.each(sels,
												function(rec) {
													me.checkModelChange(false,
														me.Grid.store.getRecord((rec.data || rec)[me.fieldLink],
															me.fieldLink), rec);
												});
										});
								}
							}
						})
				],
				columns: [],
				columnLines: true,
				plugins: ['bufferedrenderer'],
				store: Ext.create('Ext.data.Store',
					{
						fields: [],
						data: [],
						proxy: 'memory'
					}),
				listeners: {
					selectionchange: (_, sels) => Keysystems.Base.Edit.prototype.enableToolsGrid.call(this, me.gksc('MultiSelectGrid'), sels)					
				}
			};
		},
		createMultiSelectGrid: function() {
			var cfg = this.getMultiSelectGridCfg();
			return Ext.create(cfg.className || 'Ext.grid.Panel', cfg);
		},
		updMultiSelectGrid: function(rec, v) {
			var me = this,
				grid = me.gksc('MultiSelectGrid'),
				copyRec = rec.copy();
			if (grid && !grid.isHidden()) {
				var mrec = grid.store.getRecord((rec.data || rec)[me.fieldLink], me.fieldLink);
				if (v) {
					if (!mrec) grid.store.add(copyRec.data || rec);
				} else {
					if (mrec) grid.store.remove(mrec);
				}
			}
		},

		//#endregion MultiSelectGrid

		getSelect: function() {
			var sels = this.objs.Grid ? this.objs.Grid.getSelectionModel().getSelection() : [],
				i = 0,
				len = sels.length;
			for (; i < len; i++) {
				if (!sels[i].data.NAME) {
					sels[i].data.NAME = getDictRowName(sels[i], this.code);
				}
			}
			return sels;
		},
		createBtns: function() {
			var me = this,
				funcs = me.functions;

			if (funcs.ok) {
				me.objs.btns = [
					me.sksc('okBtn',
						Ext.create('Ext.Button',
							{
								text: 'Выбрать',
								handler: function() {
									if (funcs.ok) funcs.ok(me.checkModel ? me.getChecks() : me.getSelect());
									me.objs.view.close();
								}
							})),
					me.sksc('cancelBtn',
						Ext.create('Ext.Button',
							{
								text: 'Отмена',
								handler: function() { me.objs.view.close(); }
							}))
				];
			} else {
				delete me.objs.btns;
			}
		},
		createListeners: function() {
			var me = this;
			me.objs.listeners = {
				close: function() {
					if (me.functions.close) {
						me.functions.close.call(me, me.objs.Grid.store.data.items);
					}
				}
			};
		},
		viewCfg: function() {
			var me = this,
				objs = me.objs;
			objs.viewCfg = {
				title: me.head ? me.title : undefined,
				iconCls: me.head ? me.iconCls : undefined,
				closable: me.closable,
				layout: { type: 'vbox', align: 'stretch' },
				anchor: '100% 100%',
				flex: 1,
				height: 400,
				minHeight: 100,
				minWidth: 200,
				/** Основная панель, на которой размещаются все элементы окна списка */
				items: me.listHostPanel = Ext.create('Ext.panel.Panel', {
					flex: 1,
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 0,
					border: 0,
					bbar: me.createStatusBar(),
					items: objs.items,
					buttons: objs.btns,
					listeners: {
						render: function (e) {
							e.getEl().on('contextmenu', function (e) {
								e.stopEvent();
								if (!me.objs.contextMenu)
									me.createListContextMenu();
								me.adaptListContextMenu();
								me.objs.contextMenu.showAt(e.getXY());
							}, e);
						}
					}
				}),
				listeners: objs.listeners,
				dict: me,
				userCls: 'rks-base-list'
			};
			return objs.viewCfg;
		},
		createView: function() {
			var me = this,
				cfg = me.viewCfg();
			if (me.tabMode) {
				cfg.border = 0;
				me.objs.view = Ext.create('Ext.panel.Panel', cfg);
			} else {
				cfg.modal = true;
				cfg.width = 800;
				cfg.height = 600;
				cfg.maximizable = true;
				cfg.maximized = me.maximized;
				cfg.autoRender = true;
				cfg.constrain = true;
				me.objs.view = Ext.create('Ext.window.Window', cfg);
			}
			
			me.objs.view.on('close',
				function() {
					Log.sendLog(wmc.get('closeForm', me.title, me.code, me.linkCode, me.GateCode));

					delete window.lastDictListShow;
					me.afterClose();
				});

			if (!me.hideTBar) 
				me.toolbar = Ext.create('Ext.toolbar.Toolbar');
		},
		baseRefresh: function(endFunc, params) {
			var me = this;

			params.whereArgs = params.whereArgs ? JSON.stringify(params.whereArgs) : '';

			if (!me.hideMsg) {
				me.showLoadMask({
					msg: KS.L10n.updating_data,
					cancelFn: function() {
						me.stopRef = true;
						if (me.ridRef) SignalR.delCallBack(me.ridRef);
					}
				});
			}

			if (me.functions && me.functions.refresh) {
				me.functions.refresh.call(me,
					function(result) {
						if (me.stopRef) return;
						endFunc(result);
						me.hideLoadMask();
					},
					params);
			} else {
				params.linkCode = me.linkCode;

				PageDataLib.get(params,
					function(a) {
						endFunc(a);
						
						//возвращаемся на первую страницу, если кол-во страниц обновленных данных < текущей страницы 
						if (me.pagingOn && a.data.length === 0 && a.total > 0){
							me.gridStore.currentPage = 1;
							me.refresh();
							return;
						}
						me.getNextPrevPage(params.page, params.pageSize, a.total, params);
						if (me.objs.Grid && !me.getSelect().length) me.objs.Grid.extraSelectFrst();
						if (!me.hideMsg) me.hideLoadMask();
					});
				/*
				me.ridRef = ajaxRequest({
					url: me.linkCode + '/GetData_A',
					//params: { gzipData: JSON.stringify(params) },
					params: { gzipData: SignalR.pack(params) },
					success: function(result) { endFunc(result); },
					failure: function() { endFunc(null); },
					callback: function() {
						delete me.ridRef;
						me.hideLoadMask();
					}
				});*/
			}
		},
		getWhereArgs: function() { 
			return this.whereArgs || {};
		},
		appEndWhereArgs: function(whereArgs) {
			var me = this;
			whereArgs = whereArgs || me.getWhereArgs() || {};

			// Показать актуальные
			if (me.code.indexOf('DICTIONARY_S') >= 0)
				whereArgs.ShowActual = {value: me.showActual ? 'True' : 'False', type: 'bool'};

			if (me.contextWA) {
				Ext.apply(whereArgs, me.contextWA);
			}
			else {
				//явное удаление словаря contextWA. 
				//иначе получается единожды заданные contextWA пролезают в список без контекстного поиска при повторном вызове с того же контрола
				delete whereArgs.CodeValue;
				delete whereArgs.Context;
				delete whereArgs.ExactCode;
			}
			
			return whereArgs;
		},
		
		_afterRefresh: Ext.emptyFn,
		
		/**
		 * Task Revizor.List.Refresh
		 */
		doRefresh: function(){
			this.refresh(true);
		},
		
		refresh: function(reload, hideMsg) {
			var me = this;

			if (!me.hideMsg && hideMsg) {
				me.hideMsg = hideMsg;
				me._afterRefresh = function() {
					delete me.hideMsg;
					me._afterRefresh = Ext.emptyFn;
				};
			}
			me.pagingTool.reload = reload === _ || reload;
			me.clearPageCache();
			me.pagingTool.doRefresh();
		},

		clearPageCache: function() { PageDataLib.clearByParams({ linkCode: this.linkCode, GateCode: this.GateCode }); },

		show: function() {
			var me = this,
				view = me.objs.view,
				viewShow = function() {
					if (me.isExit) return;
					view.show(null,
						function() {
							Log.sendLog(wmc.get('showForm', me.title, me.code, me.linkCode, me.GateCode));
							if (view.getX() < 0) view.setX(0);
							if (view.getY() < 0) view.setY(0);

							window.lastDictListShow = me;
						});
				},
				tabShow = function() {
					if (me.isExit) return;
					if ((me.tabMode) && (me.parentView)) {
						view.code = me.code;
						view.GateCode = me.GateCode;
						var tab = me.parentView.add(view);
						if (tab && me.parentView.setActiveTab) me.parentView.setActiveTab(tab);
						
						viewShow();

						window.lastDictListShow = me;

						//ререндер вьюхи
						view.updateLayout();
					}
				};
			if (me.isExit) return;			
			if (me.toolbar) me.listHostPanel.addDocked(me.toolbar);
			me.viewMode === 'tabShow' ? tabShow() : viewShow();

			//if ((me.tabMode) && (me.parentView)) {
			//	if (me.code) { //me.parentView.isLayoutRoot()
			//		for (var i = 0, items = me.parentView.items.items, len = items.length; i < len; i++) {
			//			if ((items[i].code === me.code) && (items[i].GateCode === me.GateCode)) {
			//				selectDialogShow(
			//					KS.L10n.attention,
			//					wmc.get('AlreadyOpen', me.title),
			//					function() { tabShow(); },
			//					function() { items[i].show(); },
			//					view
			//				);
			//				return;
			//			}
			//		}
			//	}
			//	tabShow();
			//} else {
			//	viewShow();
			//}
		},
		setViewSelectLinks: function(list) {
			var me = this;
			me.selectLinks.length = 0;
			for (var i = 0, len = list.length; i < len; i++) {
				me.selectLinks.push(list[i]);
			}
		},

		getGrid: function() { return this[this.subGrid ? 'subGrid' : 'Grid']; },

		//#region check/uncheck

		//Можно ли устанавливать/снимать выбор с записи
		canCheck: function (rec, v) { return true; },

		//установка/снятие выборки с запуском эвента
		//rec	- строка грида
		//v		- значение (default - true)
		checkRecord: function(rec, v) {
			var me = this;
			if (v === _) v = true;
			if (!me.canCheck(rec, v)) return false;
			if (!!rec.get('M') != v) {
				var grid = me.getGrid();
				if (me.mColumn && me.mColumn.processEvent)
					me.mColumn.processEvent('ksEvent',
						grid.view,
						_,
						grid.getStore().indexOf(rec),
						me.mColumn.index,
						_,
						rec);
			}

			return me.bindCheckRecToList(rec, v);
		},

		bindCheckRecToList: function(rec, v) {
			var cl = this.checkList,
				i = ArrayLib.recordIndexOf(cl, rec, this.fieldLink);
			if (v) {
				if (i === -1) {
					cl.push(rec);
				} else {
					var or = cl[i];
					if (or !== rec) {
						rec.set(this.mainColumnName, (or.data || or).MAIN);
						cl[i] = rec;
						this.checkMGridRecord(rec, (or.data || or).MAIN);
					}
				}
			} else {
				if (i !== -1) cl.splice(i, 1);
			}

			this.updMultiSelectGrid(rec, v);

			return cl;
		},

		checkSelection: function() {
			var me = this;

			Ext.each(me.getGrid().getSelectionModel().getSelection(), function(rec) { me.checkRecord(rec); });

			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},
		checkInversion: function() {
			var me = this;

			me.getGrid().store.each(function(rec) { me.checkRecord(rec, !rec.get('M')); });

			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},
		checkFstToSel: function() {
			var me = this,
				grid = me.getGrid(),
				sel = grid.getSelectionModel().getSelection();

			if (sel.length) {
				grid.store.each(function(rec) {
					if (!sel.length) return false;
					me.checkRecord(rec);
					ArrayLib.remove(sel, rec);
					return true;
				});
			} else {
				me.checkAll();
			}

			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},
		checkSelToLst: function() {
			var me = this,
				grid = me.getGrid(),
				sel = grid.getSelectionModel().getSelection();

			if (sel.length) {
				Ext.each(grid.store.data.items,
					function(rec) {
						if (!sel.length) return false;
						me.checkRecord(rec);
						ArrayLib.remove(sel, rec);
						return true;
					},
					_,
					true);
			} else {
				me.checkAll();
			}

			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},
		checkCheckToCheck: function() {
			var me = this,
				grid = me.getGrid(),
				store = grid.getStore(),
				frst = false,
				last = false;

			store.each(function(rec) {
				if (rec.get('M')) {
					if (!frst) frst = rec;
					last = rec;
				}
			});

			if (frst) {
				var start = store.indexOf(frst),
					end = store.indexOf(last);

				Ext.each(store.getRange(start, end), function(rec) { me.checkRecord(rec); });
			}

			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},
		checkAll: function() {
			var me = this;

			me.getGrid().store.each(function(rec) { me.checkRecord(rec); });

			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},

		uncheckAllFromPage: function() {
			var me = this;

			me.getGrid().store.each(function(rec) { me.checkRecord(rec, false); });

			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},
		uncheckAll: function() {
			var me = this;
			if (me.checkList.length) {
				me.getGrid().store.each(function(rec) { me.checkRecord(rec, false); });
				if (me.banLinks.length) {
					Ext.each(me.checkList,
						function(rec) {
							var d = rec.data || rec;
							if (me.banLinks.indexOf(d[me.fieldLink] * 1) === -1) ArrayLib.remove(me.checkList, rec);
						},
						_,
						true);
				} else {
					me.checkList.length = 0;
				}
			}
			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},

		setChecks: function(checkList, sources) {
			var me = this,
				grid = me.getGrid();
			if (!grid) return false;
			
			if (me.checkModel || me.subCheckModel) {
				if (checkList && checkList.length) {
					var s = ArrayLib.compareSplitLists(me.checkList,
						    checkList,
						    function(r1, r2) { return KsLib.dictRecEqual(r1, r2, me.fieldLink); }),
						items = sources || grid.store.data.items;

					Ext.each(s.over1,
						function(rec) {
							var i = ArrayLib.recordIndexOf(items, rec);
							if (i !== -1) me.checkRecord(items[i], false);
						});

					Ext.each(s.equal,
						function(rec) {
							var i = ArrayLib.recordIndexOf(items, rec, me.fieldLink);
							if (i !== -1) me.checkRecord(items[i]);
						});

					Ext.each(s.over2, function(rec) { me.checkList.push(rec); });
				} else me.uncheckAll();
			}

			me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		},
		getChecks: function() {
			var me = this;

			Ext.each(me.checkList,
				function(rec) {
					var d = rec.data || rec;
					if (!d.NAME) d.NAME = getDictRowName(rec, me.code);
				});

			return me.checkList;
		},

		//#endregion check/uncheck

		selectAll: function() {
			var me = this;
			me.setViewSelectLinks(me.Grid.getStore().data.items);
			me.Grid.getSelectionModel().selectAll();
		},

		deselectAll: function() {
			this.setViewSelectLinks([]);
			this.Grid.getSelectionModel().deselectAll();
		},

		setSelect: function(selectLinks) {
			var me = this;
			if (!selectLinks) return;
			var selected = [];
			Ext.each(selectLinks,
				function(row) {
					if (row) {
						if (row.data) row = row.data;
						var el = me.Grid.store.findRecord(me.fieldLink, row[me.fieldLink] || row);
						if (el) {
							selected.push(el);
							if (row.MAIN) {
								el.set(me.mainColumnName, true);
								me.checkMGridRecord(el, true);
							}
						}
					}
				});
			return selected.length === 0 ? null :  me.Grid.extraSelect(selected);
		},

		Print: function() {
			Ext.ux.grid.Printer.print(this.objs.Grid,
				{
					title: this.title,
					printLinkText: 'Отправить на печать',
					closeLinkText: 'Закрыть'
				});
		},

		getFrstRecord: function() { return this.gridStore.getAt(0); },

		//by override
		afterClose: Ext.emptyFn,

		//#region редактирование файла

		fileEdit: function(rec) {
			let me = this;
			me.sksc('FileWindow',
				Ext.create('Keysystems.File',
					{
						readOnly: me.accessReadOnly || me.readOnly || me.getFileReadOnly(rec),
						iconCls: getExtStyle(rec.get(me.fieldExt)),
						createFile: function(callback) { me.createFile(rec.get(me.fieldLink), callback); },
						updRecord: function(fileObj) { me.updFileRecord(fileObj, rec); },
						getFileId: function() { return rec.get(me.fieldFile); },
						downloadFile: function() { me.downloadFile(rec); },
						downloadFileForEditor: function() { me.downloadFileForEditor(rec); },
						clearFile: function() { me.clearFile(rec); }
					}));
		},
		createFile: function(link, callback) { UploaderLib.newFile(this.code, link, 0, -1, 0, this.getLoadMaskTarget(), callback); },
		clearFile: function(rec) {
			var me = this;
			UploaderLib.saveFile(me.code,
				rec.get(me.fieldLink),
				0,
				function() {
					rec.set(me.fieldFile, 0);
					rec.set(me.fieldExt, '');
				});
		},
		updFileRecord: function(fileObj, rec) {
			var me = this;
			UploaderLib.saveFile(me.code,
				rec.get(me.fieldLink),
				fileObj.id,
				function(link) {
					rec.set(me.fieldFile, link);
					rec.set(me.fieldExt, fileObj.ext);
				});
		},
		getFileName: function(rec) { return rec.get(this.fieldName); },
		downloadFile: function(rec) {
			var me = this;
			UploaderLib.getFile(rec.get(this.fieldFile), me.getFileName(rec));
		},

		downloadFileForEditor: function(rec) {
			UploaderLib.getFileForEditor(this.code,
				rec.get(this.fieldLink),
				rec.get(this.fieldFile),
				rec.get(this.fieldName),
				true);
		},

		/**
		 * Можно ли редактировать файл в колонке Файл
		 * @param rec
		 * @returns {boolean}
		 */
		getFileReadOnly: function (rec){
			return false;
		},

		//#endregion редактирование файла

		_arrAddTBarBtns: ['new', 'same', 'add_slave'],
		_arrEditTBarBtns: ['delete', 'make_child', 'make_parent'],

		setAccess: function(readOnly) {
			var me = this,
				btns = me.objs.tbarBtns;

			me.accessReadOnly = readOnly;

			if (btns) {
				if (readOnly) {
					Ext.each(me._arrAddTBarBtns.concat(me._arrEditTBarBtns),
						function(n) { if (btns[n]) btns[n].hide(); });
					if (btns.edit) {
						btns.edit.setIconCls('x_btn_open');
						btns.edit.setTooltip('Открыть');
					}
				} else {
					Ext.each(me._arrAddTBarBtns.concat(me._arrEditTBarBtns),
						function(n) { if (btns[n] && !me.btnsHide[n]) btns[n].show(); });
					if (btns.edit) {
						btns.edit.setIconCls('x_btn_edit');
						btns.edit.setTooltip('Редактировать');
					}
				}
			}
		},

		setReadOnly: function(v) {
			var me = this;
			me.readOnly = v;

			var btn = me.gksc('okBtn');
			if (btn) btn[v ? 'hide' : 'show']();
			btn = me.gksc('cancelBtn');
			if (btn) btn.setText(v ? 'Закрыть' : 'Отмена');
		},

		checkReadOnly: function(rec) {
			var me = this, btns;
			if (!((me.editClass || me.functions.edit) && (btns = me.objs.tbarBtns)) || !me.objs.Grid) return false;
			if (!me.accessReadOnly && (rec || (rec = me.objs.Grid.getSelectionModel().getSelection()[0]))) {
				if (me.canEdit(rec)) {
					if (btns.delete) {
						btns.delete.setDisabled(false);
					}
					if (btns.edit) {
						btns.edit.setIconCls('x_btn_edit');
						btns.edit.setTooltip('Редактировать');
					}
					return false;
				} else {
					if (btns.delete) {
						btns.delete.setDisabled(true);
					}
					if (btns.edit) {
						btns.edit.setIconCls('x_btn_open');
						btns.edit.setTooltip('Открыть');
					}
				}
			}
			return true;
		},
		canEdit: function(rec){
			if (this.readOnlyLinks && this.readOnlyLinks.indexOf((rec.data || rec).LINK) >= 0)
				return false;
			return true;
		},
		getLinks: function(isJson) {
			var me = this,
				links = [];

			Ext.each(me.checkList,
				function(rec) {
					var b = rec.data || rec,
						l = b[me.fieldLink];
					if (l) links.push(l);
				});

			return isJson ? JSON.stringify(links) : links;
		},

		showEventLogList: function() {
			var me = this,
				code = me.code,
				tmp = code.split('_');

			if (!code) return;

			var func = function() {
				Ext.create('Revizor.EventLog.List',
					{
						tabMode: !window.modalEdit && me.parentView === window.tabView,
						parentView: me.parentView,
						title: 'Журнал событий (Категория - ' +
							(tmp[0] === 'DICTIONARY' ? 'Справочники)' : 'Документы)'),
						code: code
					});
			};

			// если уже открыто
			if (me.tabMode && me.parentView && me.code) {
				var tab = me.parentView.items.items.filter(function(i) {
					return i.code === me.code && i.GateCode === '';
				});
				if (tab.length) {
					me.parentView.setActiveTab(tab[0]);
				} else {
					func();
				}
			} else {
				func();
			}
		},

		showEventLogByLink: function(){
			let me = this,
				sel = me.objs.Grid.getFrstSelect();
			if (!sel) return;

			me.showLoadMask({
				msg: KS.L10n.loading_data,
				rid: ajaxRequest({
					params: {
						code: me.code,
						links: [sel.data[me.fieldLink]]
					},
					url: 'data/DetailEventsLog_A',
					success: function (html) {
						showDetailEventsLog.call(me, {
							html: html,
							modal: window.modalEdit || me.parentView !== window.tabView,
							title: me.title
						});
					},
					callback: function () {
						me.hideLoadMask();
					}
				})
			});			
		},

		showEsgfkEventLog: function(){
			let me = this,
				sel = me.objs.Grid.getFrstSelect();
			
			me.showLoadMask({
				msg: KS.L10n.loading_data,
				rid: ajaxRequest({
					params: {
						objCode: me.code,
						link: sel.data[me.fieldLink]
					},
					url: 'data/EsgfkEventLog_A',
					success: function (html) {
						me.hideLoadMask();
						showDetailEventsLog.call(me, {
							html: html.HtmlBody,
							modal: window.modalEdit || me.parentView !== window.tabView,
							title: "Протокол выгрузки данных в ГИС ЕСГФК"
						});
					},
					callback: function () {
						me.hideLoadMask();
					}
				})
			});
		},
		
		showBatchChange: function(links) {
			var me = this,
				code = me.profileCode || me.code;

			if (!code) return;
			
			Ext.create('Revizor.BatchChange',
				{
					title: KS.L10n.paketnaya_zamena + ' - ' + me.title,
					parentView: me.parentView,
					links: links,
					code: code,
					ok: function (props) {
						if (!props) return;
						me.showLoadMask({
							msg: props.preview ? KS.L10n.preparing_data : KS.L10n.saving,
							rid: ajaxRequest({
								params: {values: JSON.stringify(props)},
								url: 'Data/ExecuteBatchChange_A',
								success: function (res) {
									me.hideLoadMask();
									if (!res) return;
									
									if (res.error) {
										showError(res.error);
									} else {
										if (res.result === "preview") {
											let previewData = {
												data: {data: res.data, total: 0},
												columns: res.columns,
												fields: res.fields,
												toolbar: res.toolbar
											};
											let linearData = [];
											res.data.forEach(r=>{
												linearData.push(r);
												linearData = linearData.concat(r.children);
											});
											dictFunc({
												mode: 'MULTI',
												code: 'DICTIONARY_EOD_PREVIEW_LIST',
												head: false,
												hidePagging: true,
												footerPanel: false,
												selectLinks: linearData,
												needRefreshAfterSetData: false,
												btnsHide:{
													make_parent: true
												},
												viewCfg: function () {
													let cfg = this.callParent(arguments);
													cfg.title = 'Предварительный просмотр';
													return cfg;
												},
												baseRefresh: function (callBack) {
													callBack(previewData);
												},
												baseGetData: function (callBack) {
													callBack(previewData);
												}
											}, {
												ok: function (value) {
													let mainLinks = value.filter(rec=>!rec.data.LINK_SELF).map(rec=>rec.data.LINK),
														dictLinks = {};
													mainLinks.forEach(mainLink=> {
														dictLinks[mainLink] = value.filter(rec => rec.data.LINK_SELF === mainLink).map(rec => rec.data.LINK);														
													});
													let params = {
														code: props.code,
														propName: props.propName,
														dictLinks: JSON.stringify(dictLinks)
													}
													me.showLoadMask({
														msg: KS.L10n.saving,
														rid: ajaxRequest({
															params: {values: JSON.stringify(params)},
															url: 'Data/ExecuteBatchUnion_A',
															success: function (res) {
																me.hideLoadMask();
																if (!res) return;

																if (res.error) {
																	showError(res.error);
																} else {
																	if (res.result) {
																		me.refresh(true, 1);
																	}
																	ChooseBox.ShowHTMLLog({
																		title: KS.L10n.protocol_paketnoy_zameni,
																		text: res.text
																	});
																}
															},
															callback: function () {
																me.hideLoadMask();															
															}
														})
													})
												}
											});
											return;
										}

										if (res.result) {
											me.refresh(true, 1);
										}
										ChooseBox.ShowHTMLLog({
											title: KS.L10n.protocol_paketnoy_zameni,
											text: res.text
										});
									}

								},
								failure: function () {
									showError(wmc.get('ErrorGetData'));
								},
								callback: function () {
									me.hideLoadMask();
								},
								progress: function (response) {
									me.loadMask.setMsg(response);
								}
							})
						});
					}
				}).show();
		},

		//by override
		setExpand: Ext.emptyFn,

		//Очищает все значения фильтров в колонках
		clearColumnFilter: function() {
			let me = this;
			setTimeout(function () {
				me?.Grid?.clearColumnFilter();
			}, 20);			
		},

		moveTop: function(){
			this.reorder('Top');
		},
		
		moveUp: function(){
			this.reorder('Up');
		},

		moveDown: function(){
			this.reorder('Down');
		},

		moveBottom: function(){
			this.reorder('Bottom');
		},

		reorder: function(direction, links) {
			let me = this;
			if (!links){
				links = me.objs.Grid.getSelectionModel().getSelection().map(r=>r.data.LINK);				
			}
			if (!links.length) return;
			let params = {
				links: JSON.stringify(links),
				direction: direction,
				whereArgs: me.appEndWhereArgs(me.getWhereArgs()),
				gateCode: me.GateCode,
				controlName: me.controlName,
				filter: me.getFilter(),
			};

			Log.sendLog(KS.L10n.saving);
			me.showLoadMask({
				msg: KS.L10n.saving,
				rid: ajaxRequest({
					url: me.linkCode + '/Reorder_A',
					params: { gzipData: SignalR.pack(params) },
					success: function(result) {
						me.hideLoadMask();
						if (result.result) {
							Log.sendLog(wmc.get('SavingSuccess'));
							me.refresh();
							QuickMsgs.save();
						} else {
							if (result.ErrorMsg) {
								showError(result.ErrorMsg);
							}
							Log.sendLog(wmc.get('SavingError'));
							QuickMsgs.notSave();
						}
					},
					failure: function(val) {
						me.hideLoadMask();
						QuickMsgs.notSave();
						Log.sendLog(wmc.get('SavingError'));
						failureShow(val, wmc.get('SavingError'));
					}
				})
			});
		},

        send: function () {
            
        },

        sendEsgfk: function () {
			var me = this,
                links = [];
            Ext.each(me.objs.Grid.store.data.items,
                function (i) {
                    if (i.data.M) links.push(i.data.LINK);
                });
            if (links.length === 0){
				showError('Нет отмеченных записей!');
				return;
			}
            if (links.length) {
                me.showLoadMask({
                    msg: wmc.getMask('PrepareDataSendEsgfk'),
                    rid: ajaxRequest({
						url: me.linkCode + '/SendEsgfk_A',
                        params: {
							links: JSON.stringify(links)
                        },
                        success: function (res) {
	                        me.hideLoadMask();
	                        if (res) {                                
                                if (res.error) {
	                                showError(res.error);
                                } else {
                                    me.refresh(true, 1);
									ChooseBox.ShowHTMLLog({
										text: res.text,
										hasIgnoreButton: res.LinksAvailableToSend.length > 0,
										info: true,
										modal: false,
										resizable: true,
										maximizable: true,
										width: 800,
										height: 600,
										nextFn: function() {
											ChooseBox.ShowHTMLLog({
												text: res.printForm,
												hasIgnoreButton: true,
												info: true,
												modal: false,
												resizable: true,
												maximizable: true,
												maxHeight: Number.MAX_VALUE,
												maxWidth: Number.MAX_VALUE,
												width: 800,
												height: 600,
												nextFn: function() {
													var msg = res.hasError ? wmc.get('StatusChangeConfirm1') : wmc.get('StatusChangeConfirm2');
													
													selectDialogShow(wmc.get('SetSendStatusEsgfk'),
														msg,
														function() {
															ajaxRequest({
																url: me.linkCode + '/SetSendStatusEsgfk_A',
																params: {
																	links: JSON.stringify(res.LinksAvailableToSend)
																},
																success: function (res) {
																	if (res) {
																		//LoadMask.hide();
																		if (res.error) {
																			showError(res.error);
																		} else {
																			me.refresh(true, 1);
																		}
																	}
																}
															});
														});
												}
											});
										}
									});
                                }
                            }
                        },
	                    callback: function () {
		                    me.hideLoadMask();		                 
	                    }
                    })
                });
            }
		},
		
		/**
		 * Обновить значение контрола даты по значениям аргументов условий
		 */
		updateDateFromWhereArg: function(dBegin, dEnd, control){
			if (dBegin && dEnd) {
				let dh1 = new Date(dBegin),
					dh2 = new Date(dEnd),
					dt = control.getValue();
				if (dt.dh1.getTime() !== dh1.getTime() || dt.dh2.getTime() !== dh2.getTime()) {
					control.setValue(dh1, dh2);
				}
			}
		},

		/**
		 * Обновить значение контрола справочника по значению аргумента условия	
		 */
		updateDictFromWhereArg: function(whereArg, control){
			if (whereArg) {
				let links = JSON.parse(whereArg.value);

				if (!ArrayLib.equal(control.getLinks(), links)) {
					if (whereArg.extValue) {
						control.setValue(whereArg.extValue);
					}
					else {
						control.setValue(links.map(link => {
							return {LINK: link}
						}));
					}
				}
			}
		},

		getLoadMaskTarget: function () {
			return this.listHostPanel ? this.listHostPanel : (this.objs.view && this.objs.view.rendered ? this.objs.view : null);
		},
				
		sign: async function() {
			const me = this;
			const sels = me.objs.Grid.getSelectionModel().getSelection();
			if (!sels.length) return;
			const links = sels.map(r => r.data[me.fieldLink]);
			const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
				target: me.getLoadMaskTarget(),
				code: me.code,
				links,
				mode: 'EDS_SET'
			});
			const response = await serviceModule.executeAsync();
			if (response) me.afterSignCompleted(response);
		},

		unSign: async function() {
			const me = this;

			let res = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.ListTasks_UnSign_Снять_ЭП, 'no');
			if (res !== "yes") return;

			const sel = me.objs.Grid.getSelectionModel().getSelection();
			if (!sel.length) return;
			const links = sel.map(r => r.data[me.fieldLink]);

			const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
				target: me.getLoadMaskTarget(),
				code: me.code,
				links,
				mode: 'EDS_DELETE'
			});
			const response = await serviceModule.executeAsync();
			if (response) me.afterSignCompleted(response);
		},

		afterSignCompleted: function(response){
			const me = this;
			if (response?.rows) {
				response.rows.forEach(row => {
					me.updateRecord(row);
				})
			}
		},
		
		signList: function(params){
			const me = this;
			const code_eds_list = params.CODE_EDS_LIST;
			if (!code_eds_list) return
			const sel = me.objs.Grid.getSelectionModel().getSelection();
			if (!sel.length) return;
			const links = sel.map(r => r.data[me.fieldLink]);

			const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
				target: me.parentView,
				code: me.code,
				links,
				code_eds_list,
				mode: 'SIGN_LIST',
				modal: window.modalEdit || me.parentView !== window.tabView
			});
			serviceModule.execute();
		},

		signInfo: function(ext) {
			const me = this;
			const sel = me.objs.Grid.getSelectionModel().getSelection();
			if (!sel.length) return;
			const links = sel.map(r => r.data[me.fieldLink]);

			const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
				target: me.getLoadMaskTarget(),
				code: me.code,
				links: links,
				mode: ext ? 'EDS_EXTINFO' : 'SIGNATURE_INFO_PROTOCOL'				
			});
			serviceModule.execute();
		},

		extSignInfo: function(){
			this.signInfo(true);
		},

		syncDictEsgfk: function () {
			var me = this;

			me.showLoadMask({
				msg: wmc.getMask('SyncDictEsgfk'),
				rid: ajaxRequest({
					url: me.linkCode + '/SyncDictionaryEsgfk_A',
					success: function (res) {
						me.hideLoadMask();
						if (res) {
							if (res.error) {
								showError(res.error);
							}
							me.refresh(true, 1);
						} else {
							me.refresh(true, 1);
						}
					}
				})
			});
		},
    });