﻿let maxPageSize = 500000;

Ext.define('Keysystems.Base.List.Tree', {
	extend: 'Keysystems.Base.List',
	expandedLinks: [],
	needRefreshAfterSetData: false,
	getGridStore: function() {
		var me = this;
		return me.gridStore = Ext.create('Ext.data.TreeStore', me.getGridStoreCfg());
	},
	getGridStoreCfg: function() {
		let me = this;
		return {
			fields: [],
			data: [],
			pageSize: me.pageSize,
			listeners: {
				beforeload: function () {
					var expandedLinks = [],
						pushToExpanded = function (rec) {
							if (rec.isExpanded()) expandedLinks.push(rec.get('LINK'));
						},

						findExpandedChilds = function (r) {
							pushToExpanded(r);

							Ext.each(r.childNodes, function (ch) {
								pushToExpanded(ch);

								if (ch.childNodes) {
									Ext.each(ch.childNodes, function (chch) {
										findExpandedChilds(chch);
									});
								}
							});
						},
						allNodes = me.gridStore && me.gridStore.getRootNode().childNodes;

					if (allNodes)
						Ext.each(allNodes, function (node) {
							findExpandedChilds(node);
						});

					me.expandedLinks = expandedLinks;

					return !me.isCreate;
				}
			},
			//remoteSort: true,
			defaultRootText: '',
			//todo extjs 71 при исп-ии implicitModel требует defaultConfig
			//implicitModel : true,
			proxy: me.getListProxy(),
			loadPage: Ext.data.Store.prototype.loadPage,
			nextPage: Ext.data.Store.prototype.nextPage,
			previousPage: Ext.data.Store.prototype.previousPage,
			getTotalCount: function () {
				return this.totalCount;
			},
			getCurrentPage: function () {
				return this.currentPage;
			}
		}
	},
	getGridCfg: function() {
		var me = this,
			objs = me.objs;
		return {
			animate: false,
			autoscroll: true,
			autoRender: true,
			contextMenuHidden: true,
			flex: 2,
			rootVisible: false,
			multiSelect: true,
			rowLines: true,
			border: 0,
			selModel: objs.selModel,
			tbar: me.createGridTBar(),
			store: me.getGridStore(),
			bbar: me.createPaging(),
			autoSizeOnExpandCollapse: true,
			plugins: ['gridclipboard'],
			features: [
				{
					ftype: 'summary',
					showSummaryRow: false
				}
			],
			columns: [],
			columnLines: true,
			viewConfig: {
				isLockingView: true,
				preserveScrollOnRefresh: me.preserveScrollOnRefresh,
				toggleOnDblClick: false,
				getRowClass: function(rec) {
					return me._getRowClass(rec);
				}
			},
			listeners: objs.gridListeners
		};
	},

	_getRowClass: function(rec) {
		var me = this,
			cls = me.getRowClass(rec) || '';

		return me.filterable ? cls + ' ' + (rec.match || '') : cls;
	},

	createItems: function() {
		var me = this,
			objs = me.objs;
		me.isCreate = true;
		objs.items = [
			me.Grid = objs.Grid = Ext.create('Ext.tree.Panel', me.getGridCfg()),
			me.sksc('splitterMSG', Ext.create('Ext.resizer.Splitter', { hidden: true }))
		];
		if (me.multiSelectGridVisible) objs.items.push(me.sksc('MultiSelectGrid', me.createMultiSelectGrid()));
		
		me.isCreate = false;
		if (me.checkModel && me.mode === 'MULTI' && !me.readOnly) {
			me.uncheckVisible = me.checkVisible = true;
		}

		return objs.items;
	},
	
	columnsAdapted: function() {
		var me = this,
			columns = me.callParent(arguments);
		
		if  (!this.pagingOn) {
			if (me.code === 'DOCUMENTS' || me.code === 'DOCUMENT_DF_DOCUMENTS') {
				if (ArrayLib.find(columns, ['dataIndex'], 'tree') === -1) {
					columns.unshift({
						dataIndex: 'tree',
						minWidth: 55,
						draggable: false,
						sortable: false,
						iconCls: 'x-tree-noicon',
						cls: 'rks-tree-column',
						menuDisabled: true,
						onTitleElClick(e) {
							if (!e.target.classList.contains('x_btn_clear_filter') && !e.target.querySelector('.x_btn_clear_filter')){
								me.showColumnManager();
							}
							e.stopEvent();
						},
						renderer: function (v, m, rec) {
							let res = v;
							const sDocVid = rec.get('TYPE');
							if (sDocVid) {
								res = `<span style="width: 24px" class="x-action-col-icon ks-treecolumn-icon ${KsLib.getTaskTypeIconCls(sDocVid)}">`;
							}
							return res;
						},
						xtype: 'treecolumn',
						hasColumnChooser: true,
						index: -3,
						ignoreExport: true,
						listeners: {
							afterrender: function () {
								//автоподбор ширины колонки после рендера
								try { this.autoSize(); } catch {}
								this.ownerCt?.getHeaderAtIndex(0)?.textInnerEl?.addCls('ks-column-header-icon x_btn_grid_menu');
							}
						}
					});
				}
			} else {
				//rowNumberer совместно с tree смотрятся несколько странно
				const pos = ArrayLib.find(columns, ['dataIndex'], 'rowNumberer');
				if (pos !== -1) columns.splice(pos, 1);
				
				if (ArrayLib.find(columns, ['dataIndex'], 'tree') === -1) {
					let cfg =  {
						menuDisabled: true,
						onTitleElClick(e) {
							if (!e.target.classList.contains('x_btn_clear_filter') && !e.target.querySelector('.x_btn_clear_filter')){
								me.showColumnManager();
							}
							e.stopEvent();
						}
					}
					Ext.apply(cfg, this.getTreeColumnCfg());
					columns.unshift(cfg);
				}
			}
		}

		return columns;
	},
	fieldsAdapted: function(fields) {
		var me = this;
		me.callParent(arguments);
		if (!me.thereIsField(fields, 'id')) {
			fields.push('id');
		}
		if (!me.thereIsField(fields, 'tree')) {
			fields.push('tree');
		}
		return fields;
	},

	selectDialogShow: function(node) {
		if ((node) && (node.childNodes) && (node.childNodes.length)) {
			selectDialogShow(wmc.get('Note'), wmc.get('DoForChild'), objs.UseChield, objs.NoUseChield, objs.view);
		} else {
			//objs['NoUseChield']();
		}
	},

	getRowByLink: function(node, link) {
		var me = this;
		if (node.data[me.fieldLink] == link) {
			return node;
		} else {
			if ((node.childNodes) && (node.childNodes.length)) {
				var res;
				Ext.each(node.childNodes, function(child) {
					res = me.getRowByLink(child, link);
					if (res) {
						return false;
					}
				});
				return res;
			} else {
				return null;
			}
		}
	},

	getRowsCount: function(root) {
		if ((!root) || (!root.children) || (!root.children.length)) {
			return 0;
		}
		var res = 0;
		for (var i = 0, len = root.children.length; i < len; i++) {
			res += this.getRowsCount(root.children[i]) + 1;
		}
		return res;
	},

	//#region check/uncheck
	
	//Можно ли устанавливать/снимать выбор с записи
	canCheck: function (rec, v) { return true; },

	//установка/снятие выборки с запуском эвента
	//rec	- строка грида
	//v		- значение (default - true)
	checkRecord: function(rec, v) {
		var me = this;
		if (v === _) v = true;
		if (!me.canCheck(rec, v)) return false;
		rec.set('M', v);
		if (!v && me.mainColumn && me.mainColumnEditable) {
			rec.set(me.mainColumnName, v);
		}
		if (me.mainColumn && me.mainColumnEditable) {
			var val = v && !me.getRevizOneMain(v, rec);
			rec.set(me.mainColumnName, val);
			me.checkMGridRecord(rec, val);
		}

		return me.bindCheckRecToList(rec, v);
	},

	checkSelToLst: function() {
		var me = this,
			grid = me.getGrid(),
			sel = grid.getSelectionModel().getSelection();

		if (sel.length) {
			grid.store.each(function(rec) {
				if (!sel.length) return false;
				me.checkRecord(rec);
				ArrayLib.remove(sel, rec);
				return true;
			}, _, true);
		} else {
			me.checkAll();
		}

		me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
	},
	checkCheckToCheck: function() {
		var me = this,
			grid = me.getGrid(),
			store = grid.getStore(),
			frst = false,
			last = false;

		store.each(function(rec) {
			if (rec.get('M')) {
				if (!frst) frst = rec;
				last = rec;
			}
		});

		if (frst) {
			var runCheck;

			store.each(function(rec) {
				if (rec === frst) runCheck = true;
				if (runCheck) me.checkRecord(rec);
				if (rec == last) return false;
				return true;
			});
		}

		me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
	},

	setChecks: function(checkList, sources) {
		var me = this,
			grid = me.getGrid();
		if (!grid) return;

		if (checkList && checkList.length) {
			me.checkList = checkList;
			grid.getStore().each(function(rec) {
				me.checkRecord(rec, ArrayLib.recordIndexOf(checkList, rec, me.fieldLink) !== -1);
			});
		} else {
			me.uncheckAll();
		}

		me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
	},

	checkModelChange: function(checked, rec) {
		var me = this;

		if (me.mode === 'SINGL') {
			me.callParent(arguments);
		} else {
			var bt = {},
				btns = 0,
				state = false,
				btnTxt = ['Подчиненные', 'Главные', 'Подчиненные и главные', 'Только себя'],
				//Проверяет находятся ли главные или подчиненые в таком же состояние что и запись
				notOnlyMe = function(check, r, up) {
					var field = up ? 'parentNode' : 'childNodes';

					Ext.each(r[field], function(record) {
						//Проверяем противоположное состояние т.к. текущая запись уже находиться в нем
						if (!!record.get('M') === !check && !record.isRoot()) {
							state = true;
							return false;
						}

						if (record[field]) notOnlyMe(check, record, up);
					});

					return state;
				},
				checkSource = function(check, source) {
					Ext.each(source, function(ch) {
						me.checkRecord(ch, check);
					});
				},
				checkChilds = function(check, r) {
					Ext.each(r.childNodes, function(ch) {
						if (ch.childNodes) {
							Ext.each(ch.childNodes, function(chch) {
								checkChilds(check, chch);
							});
						}

						checkSource(check, ch);
					});

					me.checkRecord(r, check);
				},
				checkParents = function(check, r) {
					Ext.each(r.parentNode, function(parent) {
						if (parent.parentNode && !parent.parentNode.isRoot()) {
							Ext.each(parent.parentNode, function(p) {
								checkParents(check, p);
							});
						}

						if (!parent.isRoot()) {
							checkSource(check, parent);
						}
					});

					me.checkRecord(r, check);
				},
				checkMethod = function(name) {
					switch (name) {
					case 'Подчиненные':
						checkChilds(checked, rec);
						break;
					case 'Главные':
						checkParents(checked, rec);
						break;
					case 'Подчиненные и главные':
						checkChilds(checked, rec);
						checkParents(checked, rec);
						break;
					default:
						me.checkRecord(rec, checked);
					}

					me.setSBText(me.dataCount, me.selectLinks.length, me.checkList ? me.checkList.length : 0);
					if (me.afterCheckAll) me.afterCheckAll(me.checkList);
				},
				showMsg = function () {
					for (i = 0; i < btns; i++) bt[Ext.Msg.buttonIds[i]] = btnTxt[i];

					Ext.Msg.show({
						title: wmc.get(checked ? 'Check' : 'UnCheck'),
						buttons: btns + 1,
						buttonText: bt,
						msg: 'Дополнительно ' + (checked ? 'отметить' : 'разметить') + '?',
						fn: function(buttonId) {
							checkMethod(bt[buttonId]);
							//Сохраняем метод для того чтобы потом применить если поставили галку не спрашивать
							if (checked && !me.checkVisible) me.checkMethodName = bt[buttonId];
							if (!checked && me.uncheckVisible === false) me.uncheckMethodName = bt[buttonId];
						},
						checkVisible: me.checkVisible || me.uncheckVisible,
						checkHandler: function(th, check) {
							//Запоминаем в каком состоянии была нажата кнопка больше не спрашивать
							checked ? me.checkVisible = !check : me.uncheckVisible = !check;
						},
						icon: Ext.MessageBox.QUESTION
					});
				};

			if (checked ? me.checkVisible : me.uncheckVisible) {
				var nP = notOnlyMe(checked, rec, true);

				state = false;

				var nCh = notOnlyMe(checked, rec);

				if (rec.isLeaf() && nP) {
					btns = 2;
					btnTxt = ['Главные', 'Только себя'];
				} else if (rec.parentNode.isRoot() && nCh) {
					btns = 2;
					btnTxt = ['Подчиненные', 'Только себя'];
				} else {
					btns = 4;
				}

				if (!me.isClosed && (nP || nCh)) {
					showMsg();
				} else {
					checkMethod(checked ? me.checkMethodName : me.uncheckMethodName);
				}
			} else {
				checkMethod(checked ? me.checkMethodName : me.uncheckMethodName);
			}
		}
	},

	//#endregion check/uncheck

	afterRefresh: function() {
		if (this.Grid) {
			this.fireEvent('ksAfterRefresh', this, this.Grid.store.getRootNode().childNodes);
		}
	},

	setData: function(data, endFunc) {
		var me = this,
			store = me.objs.Grid.store,
			pagingTool = me.pagingTool;

		//if (store.model.prototype.isNode) delete store.model.prototype.isNode;
		
		if (!me.objs.Grid.view.store.model) {
			me.objs.Grid.view.store.model = store.model;
		}

		if (data.pageSize) {
			pagingTool.setPageSize(data.pageSize);
			pagingTool.setMaxPageSize(data.maxPageSize);
			pagingTool.setVisible(data.pagingOn);
		}

		me.firstSelect = true;
		me.objs.Grid.setRootNode({ expanded: true, children: data.data });
		//Для обновления представления согласно data.data
		if (me.needRefreshAfterSetData) {
			me.refresh();
		}

		store.totalCount = data.total;
		store.currentPage = data.page;
		pagingTool.page = data.page;
		pagingTool.total = data.total;
		if (!me.hidePagging) {
			pagingTool.doRefresh();
		}
		me.dataCount = data.totalMaxCount;
		me.setChecks(me.checkList, store.getRootNode());
		me.setSelect(me.selectLinks);
		const selected = me.Grid.getFrstSelect();
		if (selected) me.Grid.getView().focusRow(selected);
		me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
		// Иногда не выставляется чек в колонке Основной 
		if (me.gksc('MultiSelectGrid')) me.gksc('MultiSelectGrid').view.refresh();
		
		me.afterRefresh();
		me.afterSetData();
		if (endFunc) endFunc();
	},
	setSelect: function(selectLinks) {
		var me = this,
			grid = me.objs.Grid,
			list = [];
		for (var i = 0, len = selectLinks.length; i < len; i++) {
			var rec = selectLinks[i],
				link = rec ? rec.data ? rec.data[me.fieldLink] : rec[me.fieldLink] : 0;

			if (link) {
				var el = grid.store.getRecord(link, me.fieldLink);
				if (el) list.push(el);
			}
		}

		if (list.length) {
			//Чтоб не было переполнение стека
			var tmp = me.selectLinks;
			me.selectLinks = [];
			grid.selModel.select([]);
			me.selectLinks = tmp;
			grid.selModel.select(list);
		}
	},

	selectAll: function() {
		var me = this;
		me.objs.Grid.selModel.selectAll();

		me.selectLinks = me.objs.Grid.selModel.getSelection();
		me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
	},

	deselectAll: function() {
		var me = this;
		me.selectLinks.length = 0;
		me.objs.Grid.selModel.select([]);
		me.setSBText(me.dataCount, 0, me.checkList.length);
	},

	getSelect: function() { return this.Grid && this.Grid.getSelectionModel().getSelection(); },
	setRecord: function(row, cmp) {
		var me = this,
			l = cmp.data.get('LINK_SELF'),
			multiSelectGrid = me.gksc('MultiSelectGrid');
		cmp.data.set(row);
		if (l !== row.LINK_SELF) me.appendParent(cmp.data);
		
		if (multiSelectGrid) {
			var rec = multiSelectGrid.getStore().getRecord((row.data || row)[me.fieldLink], me.fieldLink);
			if (rec) {
				rec.set(row);
			}
		}

		me.refresh(true, 1);
	},
	appendParent: function(rec) {
		var me = this,
			rootNode = me.objs.Grid.store.getRootNode(),
			parent = me.getRowByLink(rootNode, rec.get('LINK_SELF'));

		if (parent) {
			parent.appendChild(rec);
			parent.set('leaf', false);
			parent.expand();
		} else {
			rootNode.appendChild(rec);
		}
	},
	addRecord: function(row) {
		row.leaf = true;
		var me = this,
			rootNode = me.objs.Grid.store.getRootNode(),
			rec = rootNode.createNode(row);

		me.appendParent(rec);
		me.refresh(true, 1);
		return rec;
	},

	getFrstRecord: function() { return this.objs.Grid.getStore().getRootNode().childNodes[0]; },
	setExpand: function(expandedLinks) {
		var me = this,
			expandNode = function(ch) {
				if (!expandedLinks) return false;

				var pos = expandedLinks.indexOf(ch.get('LINK'));
				if (pos !== -1) {
					ch.expand();
					expandedLinks.splice(pos, 1);
				}

				Ext.each(ch.childNodes, function(chch) {
					expandNode(chch);
				});
			};

		me.gridStore && me.gridStore.getRootNode().eachChild(expandNode);
	},

	/** Task Revizor.List.RowLevelDown	 
	 */
	treechangeHandler: function() {
		var me = this,
			objs = me.objs,
			grid = me.objs.Grid,
			sel = grid.getFrstSelect();

		if (sel && sel.data) {
			var link = sel.get('LINK'),
				currentWhereArgs = JSON.parse(JSON.stringify(me.appEndWhereArgs(me.getWhereArgs()))),
				links = [],
				pushChildsLink = function(ch) {
					links.push(ch.get('LINK'));

					ch.eachChild(pushChildsLink);
				};

			links.push(link);
			sel.eachChild && sel.eachChild(function(ch) {
				pushChildsLink(ch);
			});

			currentWhereArgs.NotInLinks = { value: JSON.stringify(links), type: 'List_int' };

			dictFunc({
				mode: 'SINGL',
				parentView: objs.view,
				whereArgs: currentWhereArgs,
				btnsHide: {
					make_child: true,
					make_parent: true,
					new: true,
					edit: true,
					same: true,
					delete: true,
					add_slave: true
				},
				title: 'Выбрать родителя для текущей записи',
				code: me.code
			}, {
				ok: function(v) {
					if (v.length) me.saveTreeChange(link, v);
				}
			});
		}
	},

	//Если нет value - значит на верхний уровень отправляем
	saveTreeChange: function(link, v) {
		var me = this,
			params = {
				LINK: link,
				LINK_SELF: v ? v[0].get('LINK') : 0,
				code: me.code
			};

		Log.sendLog(KS.L10n.saving);
		me.showLoadMask({
			msg: KS.L10n.saving,
			view: me.listHostPanel,
			rid: ajaxRequest({
				url: me.linkCode + '/SaveTreeChange_A',
				params: { gzipData: SignalR.pack(params) },
				success: function(result) {
					me.hideLoadMask();

					if (result.result) {
						Log.sendLog(wmc.get('SavingSuccess'));
						me.refresh();
						QuickMsgs.save();
					} else {
						if (result.ErrorMsg) {
							showError(result.ErrorMsg);
						}
						Log.sendLog(wmc.get('SavingError'));
						QuickMsgs.notSave();
					}
				},
				failure: function(val) {
					me.hideLoadMask();
					QuickMsgs.notSave();
					Log.sendLog(wmc.get('SavingError'));
					failureShow(val, wmc.get('SavingError'));
				}
			})
		});
	},
	
	newSelf: function (){
		let me = this,
		    sel = me.objs.Grid.getSelectionModel().getSelection();
		if (sel.length) {
			me.edit('new', sel[0]);
		}
	},
	
	expandAll:function(){
		let me = this;
		setTimeout(function() { me.objs.Grid.getStore().getRootNode().expandChildren(true); }, 10);		
	},
	
	collapseAll:function(){
		let me = this;
		setTimeout(function() { me.objs.Grid.getStore().getRootNode().collapseChildren(true); }, 10);
	},
	
	makeParent: function(){
		let me = this,
			sel = me.objs.Grid.getFrstSelect();
		if (sel && sel.data) {
			if (sel.parentNode.isRoot()) {
				info(wmc.get('RecordAlreadyParent'));
			} else {
				me.saveTreeChange(sel.data.LINK);
			}
		}
	},

	dragDrop: function(links, target, action) {
		if (!links) return;

		let me = this;

		let params = {
			links: JSON.stringify(links),
			target: target,
			action: action
		};

		Log.sendLog(KS.L10n.saving);
		me.showLoadMask({
			msg: KS.L10n.saving,
			view: me.listHostPanel,
			rid: ajaxRequest({
				url: me.linkCode + '/MakeChildren_A',
				params: params,
				success: function(result) {
					me.hideLoadMask();

					if (result) {
						Log.sendLog(wmc.get('SavingSuccess'));
						me.refresh();
						QuickMsgs.save();
					} else {
						if (result.ErrorMsg) {
							showError(result.ErrorMsg);
						}
						Log.sendLog(wmc.get('SavingError'));
						QuickMsgs.notSave();
					}
				},
				failure: function(val) {
					me.hideLoadMask();
					QuickMsgs.notSave();
					Log.sendLog(wmc.get('SavingError'));
					failureShow(val, wmc.get('SavingError'));
				}
			})
		});
	},
	
	
	
});