﻿import moment from "moment";

Date.prototype.toJSON = function() {
	return this.toDateString();
};
Ext.trueFn = function() {
	return true;
};
Ext.falseFn = function() {
	return false;
};
Ext.nullFn = function() {
	return null;
};

RegExp.prototype.baseTest = RegExp.prototype.test;
RegExp.prototype.test = function() {
	this.lastIndex = 0;
	return this.baseTest.apply(this, arguments);
};

Ext.apply = function(object, config, defaults) {
	if (defaults) {
		Ext.apply(object, defaults);
	}

	if (object && config && typeof config === 'object') {
		var i, j, k = {};

		for (i in config) {
			var v = config[i];
			if (v !== undefined) {
				if (Ext.isFunction(v) && object[i]) {
					k['__' + i] = object[i];
					v.$name = i;
					v.$previous = object[i];
					j = true;
				}
				object[i] = v;
			}
		}

		if (j) {
			Ext.apply(object, k);
		}

		if (Ext.enumerables) {
			for (j = Ext.enumerables.length; j--;) {
				k = Ext.enumerables[j];
				if (config.hasOwnProperty(k)) {
					object[k] = config[k];
				}
			}
		}
	}

	return object;
};

Ext.onReady(function() {
	Ext.BLANK_IMAGE_URL = urlPrefix + '/Content/Ext/theme-classic/resources/images/tree/s.gif';
	Ext.getBody().addCls(Ext.isWebKit ? 'ks-webkit' : 'ks-notwebkit');
	
	var proto;

	Ext.Base.addMembers({
		callParent: function(args, parentMethod) {
			var me = this,
				method = me.callParent.caller,
				superMethod = method &&
					(method.$previous ||
						((method = method.$owner ? method : method.caller) && method.$owner.superclass[method.$name]));
				superMethod = superMethod || parentMethod;
				
			if (!superMethod && me.mixins) {
				for (var className in me.mixins) {
					if (!method) {
					}

					if (superMethod = me.mixins[className][method.$name]) break;
				}
			}

			if (!superMethod) superMethod = me['__' + method.$name];

			return superMethod.apply(me, args || []);
		},
		
		//иногда падает ошибка при повторном открытии списков, в текущей версии extjs лечится перегрузкой метода getConfig
		//https://forum.sencha.com/forum/showthread.php?469880-Cannot-read-property-viewModel-of-null
		getConfig: function(name, peek, ifInitialized) {
			var me = this,
				ret, cfg, propName;
			if (name) {
				cfg = me.self.$config.configs[name];
				if (cfg) {
					propName = me.$configPrefixed ? cfg.names.internal : name;
					if (ifInitialized) {
						ret = me.hasOwnProperty(propName) ? me[propName] : null;
					} else if (peek) {
						ret = me.hasOwnProperty(propName) ? me[propName] : (me.config == null ? null : me.config[name]);
					} else {
						ret = me[cfg.names.get]();
					}
				} else {
					ret = me[name];
				}
			} else {
				ret = me.getCurrentConfig();
			}
			return ret;
		}		
	});

	Ext.Base.prototype.callOverridden = Ext.Base.prototype.callParent;

	Ext.AbstractComponent.prototype.removeCls = function() {
		var me = this,
			el = me.rendered ? me.el : me.protoEl;
		el && el.removeCls.apply(el, arguments);
		return me;
	};

	if (Ext.button) {
		if (Ext.button.Button) {
			proto = Ext.button.Button.prototype;
			proto.setReadOnly = function(readOnly) {
				var me = this,
					btnEl = me.btnEl;

				readOnly = !!readOnly;
				me[readOnly ? 'addCls' : 'removeCls']('ks-readOnly');
				me.readOnly = readOnly;

				if (btnEl) {
					btnEl.dom.readOnly = readOnly;
				} else if (me.rendering) {
					me.setReadOnlyOnBoxReady = true;
				}

				this.setDisabled(readOnly);
			};
		}

		if (Ext.button.Split) {
			Ext.button.Split.prototype.tooltipType = 'title';
		}
	}

	if (Ext.tab && Ext.tab.Tab) {
		Ext.tab.Tab.prototype.onClick = function(e) {
			var me = this;
			if (e.type !== 'keydown' && e.button === 1 && me.closable) {
				me.onCloseClick();
			}
			if (me.preventDefault || (me.disabled && me.getHref()) && e) {
				e.preventDefault();
			}

			if (e.type !== 'keydown' && e.button !== 0) {
				return;
			}
			if (!me.disabled) {
				me.doToggle();
				me.maybeShowMenu();
				me.fireHandler(e);
			}
		};

		if (Ext.tab.Panel) {
			Ext.tab.Panel.prototype.changeTab = function(tab, add, autoDestroy) {
				var me = this,
					pos = me.items.items.indexOf(tab);
				if (add) {
					if (pos === -1) {
						me.add(tab);
						if (me.items.length === 1) me.setActiveTab(tab);
					}
				} else {
					if (pos !== -1) me.remove(tab, !!autoDestroy);
				}
			};
		}
	}

	if (Ext.form) {
		if (Ext.form.field) {
			if (Ext.form.field.Trigger) {
				Ext.form.field.Trigger.prototype.getTriggerMarkup = function() {
					var me = this,
						count = me.btnsCount ? me.btnsCount : 1,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

					if (!me.trigger1Cls) {
						me.trigger1Cls = me.triggerCls;
					}

					for (var i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < count; i++) {
						var tCls = 'trigger' + (i + 1);
						triggerConfigs.push({
							tag: 'td',
							valign: 'top',
							cls: cls,
							style: 'width:' +
								(me[tCls + 'Width'] || me.triggerWidth) +
								'px;' +
								(hideTrigger ? 'display:none;' : ''),
							cn: {
								cls: [
									Ext.baseCSSPrefix + 'trigger-index-' + i,
									(me[tCls + 'BaseCls'] || me.triggerBaseCls), triggerCls
								].join(' '),
								role: 'button'
							}
						});
					}
					triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

					return Ext.DomHelper.markup(triggerConfigs);
				};

				Ext.form.field.Trigger.prototype.initTrigger = function() {
					var me = this,
						triggerWrap = me.triggerWrap,
						triggerEl = me.triggerEl,
						disableCheck = me.disableCheck,
						els,
						eLen,
						el,
						e,
						cls;

					if (me.repeatTriggerClick) {
						me.triggerRepeater = new Ext.util.ClickRepeater(triggerWrap,
							{
								preventDefault: true,
								handler: me.onTriggerWrapClick,
								listeners: {
									mouseup: me.onTriggerWrapMouseup,
									scope: me
								},
								scope: me
							});
					} else {
						me.mon(triggerWrap,
							{
								click: me.onTriggerWrapClick,
								mouseup: me.onTriggerWrapMouseup,
								mouseover: me.onTriggerWrapMouseover,
								mouseout: me.onTriggerWrapMouseout,
								scope: me
							});
					}

					triggerEl.setVisibilityMode(Ext.Element.DISPLAY);
					me.addClsOnOver
						? me.addClsOnOver.apply(triggerEl, [me.triggerBaseCls + '-over', disableCheck, me])
						: triggerEl.addClsOnOver(me.triggerBaseCls + '-over', disableCheck, me);

					els = triggerEl.elements;
					eLen = els.length;

					for (e = 0; e < eLen; e++) {
						el = els[e];
						cls = me['trigger' + (e + 1) + 'Cls'];
						el.addClsOnOver(cls + '-over', disableCheck, me);
						el.addClsOnClick(cls + '-click', disableCheck, me);
					}

					me.addClsOnClick
						? me.addClsOnClick.apply(triggerEl, [me.triggerBaseCls + '-click', disableCheck, me])
						: triggerEl.addClsOnClick(me.triggerBaseCls + '-click', disableCheck, me);
				};

				Ext.form.field.Trigger.prototype.onTriggerWrapMouseover = function() {
					var me = this,
						targetEl,
						match,
						triggerOverMethod,
						event;

					event = arguments[me.triggerRepeater ? 1 : 0];
					if (event && !me.readOnly && !me.disabled) {
						targetEl = event.getTarget('.' + me.triggerBaseCls, null);
						match = targetEl && targetEl.className.match(me.triggerIndexRe);

						if (match) {
							triggerOverMethod =
								me['onTrigger' + (parseInt(match[1], 10) + 1) + 'Over'] || me.onTriggerOver;
							if (triggerOverMethod) {
								triggerOverMethod.call(me, targetEl, event);
							}
						}
					}
				};

				Ext.form.field.Trigger.prototype.onTriggerWrapMouseout = function() {
					var me = this,
						targetEl,
						match,
						triggerOutMethod,
						event;

					event = arguments[me.triggerRepeater ? 1 : 0];
					if (event && !me.readOnly && !me.disabled) {
						targetEl = event.getTarget('.' + me.triggerBaseCls, null);
						match = targetEl && targetEl.className.match(me.triggerIndexRe);

						if (match) {
							triggerOutMethod =
								me['onTrigger' + (parseInt(match[1], 10) + 1) + 'Out'] || me.onTriggerOut;
							if (triggerOutMethod) {
								triggerOutMethod.call(me, targetEl, event);
							}
						}
					}
				};

				Ext.form.field.Trigger.prototype.onTriggerWrapClick = function() {
					var me = this,
						targetEl,
						match,
						triggerClickMethod,
						event;

					event = arguments[me.triggerRepeater ? 1 : 0];
					if (event && !me.readOnly && !me.disabled) {
						targetEl = event.getTarget('.' + me.triggerBaseCls, null);
						match = targetEl
							? targetEl.className.match(me.triggerIndexRe)
							: event.target.className.match(me.triggerIndexRe);

						if (match) {
							triggerClickMethod =
								me['onTrigger' + (parseInt(match[1], 10) + 1) + 'Click'] || me.onTriggerClick;
							if (triggerClickMethod) {
								triggerClickMethod.call(me, event);
							}
						}
					}
				};
			}

			if (Ext.form.field.Date) {
				proto = Ext.form.field.Date.prototype;
				proto.__onSelect = proto.onSelect;
				proto.afterSelect = Ext.emptyFn;
				proto.__setValue= proto.setValue;
				
				proto.setValue = function(val) {
					this.__setValue(val);
					if (this.enableColorize && val) {
						this.colorizeHoliday(val);
					}
				};
				
				proto.onSelect = function(m, d) {
					if (this.editable || this.editable === undefined) {
						if (this.enableColorize) {
							this.colorizeHoliday(d);
						}
						
						this.__onSelect(m, d);
						this.afterSelect(m, d);
					}
				};
				proto.emptyText = "дд.мм.гггг";
				proto.isEmpty = function() {
					return !(this.getValue() && !this.getErrors().length);
				};

				proto.colorizeHoliday = function(val) {
					let th = this;
					if (!val) return _;
					//дата может придти как Date либо как string в формате 01.01.2021 - в этом случае парсим
					let value = th.value || val,
						v = /\d{1,2}\.\d{1,2}\.\d{4}/.test(value) ? Ext.Date.parse(value, 'd.m.Y') : new Date(value),
						year = v.getFullYear(),
						orgP = th.getOrgP(),
						holidays = th.getHolidays(orgP + 'Holidays' + year, v) || [],
						strValue = v.toString();

					if (strValue.indexOf("Sat") !== -1 || strValue.indexOf("Sun") !== -1)
						th.addCls("ks-holiday");
					else
						th[holidays.indexOf(strValue) !== -1 ? "addCls" : "removeCls"]("ks-holiday");
				};
				
				proto.minValue = '01.01.1900';
				proto.maxValue = '31.12.2100';
				proto.setHolidays = function(holidaysKey, holidays) {
					window.user.holidays[holidaysKey] = holidays.map(function(v) {
						return new Date(v).toString()
					});
				};
				proto.getOrgP = function() {
					return window.user.org.data.LINK
				};
				proto.getHolidays = function(holidaysKey, value) {
					let val = this.value || value;
					if (!val) {
						throw new Error('Метод должен вызываться от dh1 или dh2 но не от KsPeriod');
						return _;
					}

					var me = this,
						orgP = me.getOrgP(),
						year = new Date(val).getFullYear(),
						usrHolidays = window.user.holidays;

					if (!holidaysKey) {
						holidaysKey = orgP + 'Holidays' + year;
					}

					if (!usrHolidays[holidaysKey]) {
						var dt1 = new Date('01/01/' + year),
							dt2 = new Date('12/31/' + year);

						ajaxRequest({
							url: 'data/GetRestDays_A',
							params: { dt1: dt1, dt2: dt2, sOrg: orgP },
							success: function(val) {
								if (val && val.indexOf) {
									me.setHolidays(holidaysKey, val);
									me.fireEvent('ksFullUpdate');
								}
							}
						});
						return [];
					} else {
						return usrHolidays[holidaysKey];
					}
				};
				//Замена базового пикера на наш
				proto.createPicker = function() {
					var me = this,
						format = Ext.String.format;

					return new Keysystems.picker.Date({
						getOrgP: me.getOrgP,
						getHolidays: me.getHolidays,
						setHolidays: me.setHolidays,
						pickerField: me,
						ownerCt: me.ownerCt,
						renderTo: document.body,
						floating: true,
						hidden: true,
						focusOnShow: true,
						minDate: me.minValue,
						maxDate: me.maxValue,
						disabledDatesRE: me.disabledDatesRE,
						disabledDatesText: me.disabledDatesText,
						disabledDays: me.disabledDays,
						disabledDaysText: me.disabledDaysText,
						format: me.format,
						showToday: me.showToday,
						startDay: me.startDay,
						minText: format(me.minText, me.formatDate(me.minValue)),
						maxText: format(me.maxText, me.formatDate(me.maxValue)),
						listeners: {
							scope: me,
							select: me.onSelect,
							ksFullUpdate: function(th) {
								if (!th.value) return _;
								var year = th.value.getFullYear(),
									orgP = th.getOrgP(),
									cells = th.cells.elements,
									holidays = th.getHolidays(orgP + 'Holidays' + year) || [],
									cellDate;

								Ext.each(cells,
									function(cell) {
										cellDate = new Date(cell.firstChild.dateValue).toString();
										cell.classList[(holidays.indexOf(cellDate) !== -1) ? 'add' : 'remove'](
											'ks-holiday');
									});
							}
						},
						keyNavConfig: {
							esc: function() {
								me.collapse();
							}
						}
					});
				};

				proto.format = "d.m.Y";
				proto.altFormats =
					"d.m.Y|d.m.y|n.j.Y|n.j.y|m.j.y|n.d.y|m.j.Y|n.d.Y|m-d-y|m-d-Y|d.m|m-d|md|dmy|dmY|d|Y-m-d|n-j|n.j|Y/m/d";
				Ext.override(proto,
					{
						initComponent: function() {
							this.callParent();
							if (this.visibleTime){
								this.fieldCls = "fieldDateTime";
								$(".fieldDateTime").mask("00r00r0000 00c00c00",
									{
										translation: { 'r': { pattern: /[\/]/, fallback: '.' }, 'c': {pattern: /[\/]/, fallback: ':'} }
									});
							}
							else{
								this.fieldCls = "fieldDate";
								$(".fieldDate").mask("00r00r0000",
									{
										translation: { 'r': { pattern: /[\/]/, fallback: '.' } }
									});
							}
						}
					});
			}

			var setKsAllowEmpty = function(value, cls) {
				var me = this;
				me.ksAllowEmpty = value;
				cls = cls || me.ksAllowEmptyCls || 'ks-AllowEmpty';

				if (me.items) {
					if (value) {
						if (me.labelEl) {
							me.labelEl.addCls(cls);
						} else {
							me.labelCls = cls + ' ' + me.labelCls;
						}
					} else {
						if (me.labelEl) me.labelEl.removeCls(cls);
					}
					if (!me.items.each) me.items.each = function(fn) {
						return Ext.each(this, fn);
					};

					me.items.each(function(item) {
						if (!(item.handler || item.hasOwnProperty('checked')))
							if (item instanceof Ext.form.FieldContainer || item instanceof Ext.form.field.Base ||
								item instanceof Ext.form.Label) {
								setKsAllowEmpty.call(item, value, cls); //todo: откат коммита 27404 - перпятствовал снятию признака обязательности заполнения поля 
							}
					});
				} else {
					var fn = me[value ? 'addCls' : 'removeCls'];
					if (fn) fn.call(me, cls);
					
					if (me.msgTarget !== 'disabled') me.msgTarget = 'side';
					me.allowBlank = !value;
					me.blankText = KS.L10n.pole_obyazatelno_dlya_zapolneniya;
				}
				if (me.validate) me.validate();
			};

			Ext.each([Ext.form.FieldContainer, Ext.form.field.Base, Ext.form.Labelable],
				function(c) {
					var initLabelable = c.prototype.initLabelable;
					c.prototype.setKsAllowEmpty = setKsAllowEmpty;
					c.prototype.changeKsAllowEmpty = function() {
						let me = this,
							cls = me.ksAllowEmptyCls || 'ks-AllowEmpty';
						me.ksAllowEmpty = !me.ksAllowEmpty;

						if (me.items) {
							if (me.ksAllowEmpty) {
								if (me.labelEl) {
									me.labelEl.addCls(cls);
								} else {
									me.labelCls = cls + ' ' + me.labelCls;
								}
							} else {
								if (me.labelEl) me.labelEl.removeCls(cls);
							}
							if (!me.items.each) me.items.each = function(fn) {
								return Ext.each(this, fn);
							};

							me.items.each(function(item) {
								if (!(item.handler || item.hasOwnProperty('checked')))
									if (item instanceof Ext.form.FieldContainer || item instanceof Ext.form.field.Base) {
										setKsAllowEmpty.call(item, me.ksAllowEmpty, cls);
									}
							});
						} else {
							var fn = me[me.ksAllowEmpty ? 'addCls' : 'removeCls'];
							if (fn) fn.call(me, cls);

							if (me.msgTarget !== 'disabled') me.msgTarget = 'side';
							me.allowBlank = !me.ksAllowEmpty;
							me.blankText = KS.L10n.pole_obyazatelno_dlya_zapolneniya;
							
						}
					};
					//c.prototype.readOnlyCls = 'ks-readOnly';
					c.prototype.initLabelable = function() {
						var me = this,
							res = initLabelable.apply(me, arguments);

						me.setKsAllowEmpty(me.ksAllowEmpty);

						return res;
					};
				});

			if (Ext.form.field.TextArea) {
				proto = Ext.form.field.TextArea.prototype;
				proto.getSelectionText = function() {
					var v = this.getValue(),
						el = this.inputEl.dom,
						s = el.selectionStart,
						e = el.selectionEnd;

					return v && s !== e ? v.substr(s, e - s) : '';
				};				
			}

			if (Ext.form.field.Text) {
				proto = Ext.form.field.Text.prototype;
				proto.isEmpty = function() {
					var v = this.getValue();
					if (Ext.isString(v)) v = v.replace(/ /g, "");
					return !v;
				};
				proto.highlightInputEl = function(){
					const { rendered, inputEl } = this;
					if (!rendered) return;
					const value = this.getValue() || '';
					if (value) dom.setSelectionRange(value.length, value.length);
					inputEl.frame("#7eadd9");
					this.focus(false, 200);
				}
			}

			if (Ext.form.field.ComboBox) {
				proto = Ext.form.field.ComboBox.prototype;
				proto.loadData = function(data) {
					var me = this,
						store = me.getStore();
					if (store) {
						store.proxy.data = data;
						store.loadData(data, false);
						me.setValue(me.getValue()); //без этого не отображается селект
					}
				};
				proto.setValueSelectOrFrst = function() {
					var me = this,
						v = me.getValue(),
						store = me.getStore();

					if (store) {
						if (v === null) {
							me.setValue(store.getAt(0));
						} else {
							if (me.multiSelect) {
								if (!Ext.isArray(v)) v = [v];
								var rv = [];
								Ext.each(v, function(v0) {
									if (store.findRecord(me.valueField, v0)) rv.push(v0);
								});
								v = rv;

								if (!v.length) v.push(store.getAt(0));
							} else {
								if (!store.findRecord(me.valueField, v)) v = store.getAt(0);
							}
							me.setValue(v);
						}
					}
				};
				proto.isEmpty = function() {
					var v = this.getValue();
					if (this.multiSelect) v = v.length ? v.length === 1 ? v[0] : v : null;
					return v === null;
				};
			}

			if (Ext.form.field.Number) {
				proto = Ext.form.field.Number.prototype;
				proto.oldInitComponent = proto.initComponent;
				proto.initComponent = function() {
					var res = this.oldInitComponent.apply(this, arguments);

					if (this.ksLimitMaxMin) {
						this.on('blur',
							function() {
								var val = this.getValue();

								if (val > this.maxValue) {
									this.setValue(this.maxValue);
								} else if (val < this.minValue) {
									this.setValue(this.minValue);
								}
							});

						this.on('afterender',
							function(th) {
								var val = this.getValue();

								if (val > this.maxValue) {
									this.setValue(this.maxValue);
								} else if (val < this.minValue) {
									this.setValue(this.minValue);
								}
							});
					}

					return res;
				};
			}
		}

		if (Ext.form.CheckboxGroup) {
			//добавляет метод loadData
			Ext.form.CheckboxGroup.prototype.loadData = function(data) {
				var me = this;
				me.removeAll();
				me.add(data);
			};
			Ext.form.CheckboxGroup.prototype.isEmpty = function() {
				return Ext.Object.isEmpty(this.getValue());
			};
		}

		Ext.each([Ext.form.field.Checkbox, Ext.form.field.Trigger],
			function(el) {
				el.prototype.isEmpty = function() {
					return !this.getValue();
				};
			});
	}

	if (Ext.Array && Ext.Array.from) {
		//преобразует в массив где null и undefined тоже считаются значениями
		Ext.Array.fromExtra = function(value, newReference) {
			if (Ext.isArray(value)) {
				return (newReference) ? slice.call(value) : value;
			}

			var type = typeof value;


			if (value && value.length !== undefined && type !== 'string' && (type !== 'function' || !value.apply)) {
				return Ext.Array.toArray(value);
			}

			return [value];
		};
	}

	if (Ext.tree) {
		if (Ext.tree.Panel) {
			proto = Ext.tree.Panel.prototype;
			proto.useArrows = true;
			proto.removeSelection = function (func, afterRem) {
				var me = this,
					model = me.getSelectionModel(),
					rowtree = [],
					rowchild = [],
					rowsel = [],
					rowdel = [],
					sels,
					countSels;
				sels = model.getSelection();
				countSels = sels.length;
				if (countSels) {
					var text = 'Удалить запис' + ((countSels > 1) ? 'и(' + countSels + ') ?' : 'ь?');
					selectDialogShow('',
						text,
						function () {
							sels.forEach(function (rowSel) {
								if (rowSel.childNodes.length != 0) {
									rowtree.push(rowSel);
								} else {
									rowchild.push(rowSel);
								}
							});
							for (var i = 0; i < rowchild.length; i++) {
								var havFunc = Ext.isFunction(func) ? func(rowchild[i]) !== false : true;
								if (!havFunc) {
									rowsel.push(rowchild[i]);
								} else {
									rowdel.push(rowchild[i]);
								}
							}
							;
							for (i = 0; i < rowtree.length; i++) {
								havFunc = Ext.isFunction(func) ? func(rowtree[i]) !== false : true;
								if (!havFunc) {
									rowsel.push(rowtree[i]);
								} else {
									rowsel.forEach(function (row) {
										if (rowtree[i].data.LINK == row.data.LINK_SELF) {
											rowsel.push(rowtree[i]);
										} else {
											rowdel.push(rowtree[i]);
										}
									});
								}
							}

							if (rowsel.length != 0) {
								model.select(rowsel);
								rowdel.forEach(function (item) {
									item.remove();
								});
							} else {
								rowtree.forEach(function (rowRoot) {
									rowchild.forEach(function (row) {
										if (rowRoot.data.LINK == row.data.LINK_SELF) {
											row.remove();
										}
									});
								});
								sels = model.getSelection();
								for (i = 0; i < sels.length; i++) {
									var index = sels[i].data.index;
									var parent = sels[i].parentNode;
									if ((parent.childNodes.length - 1) == index) {
										model.select(parent.childNodes[index - 1]);
									} else {
										model.select(parent.childNodes[index + 1]);
									}
									parent.removeChild(parent.childNodes[index]);
								}
							}

							if (afterRem) afterRem();
						});
				}
			};

			proto.extraSelect = function (selected) {
				var grid = this,
					model = grid.getSelectionModel(),
					store = grid.getStore(),
					view = grid.view;

				if (!model.store) {
					model.store = store;
					if (!model.views || !model.views.length) {
						model.views = [view];
					}
				}

				model.select(selected);
			};

			proto.extraSelectFrst = function () {
				this.extraSelect(this.store.getRootNode().getChildAt(0));
			};

			proto.getFrstSelect = function () {
				return this.getSelectionModel().getSelection()[0];
			};

			proto.setRootNode = function (root) {
				var th = this,
					store = th.getStore();

				if (store) {
					if (this.view && this.view.store && !this.view.store.model) {
						this.view.store.model = store.model;
					}

					store.setRootNode(root);
					th.extraSelectFrst();
				}
			};

			proto.loadData = function (data) {
				this.setRootNode({expanded: true, children: data});
			};
			
			if (!proto.listeners) proto.listeners = {};
			proto.listeners.afteritemexpand = function () {
				if (!this.autoSizeOnExpandCollapse) return;
				const colTree = this.headerCt?.getGridColumns().filter(col => col.dataIndex === 'tree')[0];
				try { colTree?.autoSize(); } catch { }
			}

			proto.listeners.afteritemcollapse = function () {
				if (!this.autoSizeOnExpandCollapse) return;

				//автоподбор ширины колонки с отображением иерархии при сворчивании узла
				const colTree = this.headerCt?.getGridColumns().filter(col => col.dataIndex === 'tree')[0];
				try { colTree?.autoSize(); } catch { }
			}

			/**
			 * Загрузить данные из линейного списка с заданными LINK и LINK_SELF
			 */
			proto.loadDataExt = function(data) {
				const me = this;
				const rootNode = me.store.getRootNode();
				rootNode.removeAll();

				const funcLevel = function (r) {
					if (!r.LINK_SELF) return "0";
					const rParent = data.filter(r2 => r2.LINK === r.LINK_SELF)[0];
					return rParent ? funcLevel(rParent) + "1" : "0";
				}
				data.forEach(r => r.LEVEL = funcLevel(r));
				data = data.sort((a, b) => +a.LEVEL - +b.LEVEL);
				data.forEach(row => {
					const rec = rootNode.createNode(row);
					const parent = row.LINK_SELF ? me.getRowByLink(rootNode, row.LINK_SELF) : null;

					if (parent) {
						parent.appendChild(rec);
						parent.set('leaf', false);
						parent.expand();
					} else {
						rootNode.appendChild(rec);
					}
				});
			};

			/**
			 * Инициализация по данным (колонки, поля, объекты)
 			 * @param value данные
			 * @param profileCfg конфиг профиля
			 * @param isHierarchicalData построить иерархию
			 */
			proto.setMetaDate = function (value, profileCfg, isHierarchicalData) {
				var grid = this,
					store = grid.getStore();

				if (profileCfg) {
					var cols = value.columns.slice();

					profileCfg.columnManager = Ext.create('Keysystems.Controls.Grid.ColumnManager',
						{
							inputColumns: allColumnAdapted(cols, grid),
							code: profileCfg.profileCode,
							prefix: profileCfg.prefix,
							profileKey: profileCfg.profileKey || 'GridColumns',
							gateCode: profileCfg.GateCode || profileCfg.gateCode,
							controlName: profileCfg.controlName,
							grid: grid
						});
				} else {
					grid.reconfigure(store, value.columns);
				}
				store.setFields(value.fields);
				if (isHierarchicalData)
					grid.setRootNode({ expanded: true, children: value.data });
				else {
					//оставила для совместимости. вообще в этом случае деревянная структура построена не будет
					grid.loadData(value.data);
				}
			};

			/**
			 * Найти узел в дереве по линку
			 * @param node узел родителя
			 * @param link линк, который ищем
			 */
			proto.getRowByLink = function(node, link) {
				const me = this;
				if (node.data.LINK == link) {
					return node;
				} else {
					if ((node.childNodes) && (node.childNodes.length)) {
						var res;
						Ext.each(node.childNodes, function(child) {
							res = me.getRowByLink(child, link);
							if (res) {
								return false;
							}
						});
						return res;
					} else {
						return null;
					}
				}
			};

			/** Получить режим фильтрации грида 
			 * @return {string} none - нет фильтра, filterRow - строка фильтрации
			 */
			proto.getFilterMode = function () {
				//для медленного showFilterRow
				// let grid = this,
				// 	cols = grid.columnManager.columns,
				// 	firstCol = cols.filter(col => col.isVisible() && col.filterInput)[0];
				// return firstCol.filterInput.hidden ? 'none' : 'filterRow';
				
				//для быстрого showFilterRow
				let filterInput = Ext.select("#" + this.id + " .rks-filter", true).elements[0];
				return !filterInput || filterInput.getStyle('display') === 'none'  ? 'none' : 'filterRow';
			}

			/** Отобразить/скрыть строку фильтрации грида 
			 * @param {function} callBack функция обратного вызова, выполняемая после отображения/скрытия строки фильтрации			 
			 */
			proto.showFilterRow = function (callBack) {
				//быстрый способ отрисовки
				//показываем контролы фильтрации
				const els = Ext.select("#" + this.id + " .rks-filter", true);
				if (!els?.elements?.length) return;
				
				const visible = els.elements[0]?.getStyle('display') === 'none';
				els.setStyle('display', visible ? '' : 'none');

				//сужаем/расширяем хэдеры колонок
				let headers = Ext.select("#" + this.id + " .x-leaf-column-header", true);
				headers.setStyle('height', visible ? 'calc(100% - 25px)' : '100%');

				//выравниваем высоту колонок с custom-фильтрами по макс. высоте группы.
				//в гридах с группами хедер таких колонок уплывает вверх на 1px.
				//это то ли баг в ext, то ли надо доработать отображение custom-фильтров
				//из-за этого увеличивается высота колонок
				// if (visible) {
				// 	let groupHeaders = Ext.select("#" + this.id + " .x-group-header", true);
				// 	if (groupHeaders?.elements?.length > 0) {
				// 		const maxHeight = Math.max(...groupHeaders.elements.map(el => el.getHeight()));
				// 		if (maxHeight > 0) {
				// 			headers.elements
				// 				.filter(el => el.id.indexOf('treecolumn') >= 0 || el.id.indexOf('checkcolumn') >= 0)
				// 				.forEach(el => el.setHeight(maxHeight));
				// 		}
				// 	}
				// }				
				
				this.getView().updateLayout();
				if (!this.eventsSuspended) this.fireEvent('onShowFilterRow');
				if (callBack) callBack(visible);
			}
			
			/** Очистить все значения фильтров в колонках
			 */
			proto.clearColumnFilter = function () {
				let grid = this;

				let cols = grid.columnManager.columns ?? grid.getVisibleColumns();
				Ext.each(cols,
					function (col) {
						if (col.filterInput) {
							col.filterInput.suspendEvents();
							col.filterInput.ksLastValue = null;
							col.filterInput.setValue(null);
							if (col.xtype === 'checkcolumn' || col.xtype === 'checkcolumnextra'){
								col.ksFilter('', '');
							}
							col.filterInput.resumeEvents(false);
							(col.titleEl ?? col).removeCls('ks-filterCol');
						}
					});

				grid.store.clearFilter();
			}

			/** Выполнить автофильтрацию - отображает строку фильтрации с установкой фильтра по активной ячейке.
			    В случае, если находимся в режиме выделения строки, то выполнится 
			    переход в режим выделения ячейки с выделением ячейки с наименованием, либо первой из колонок, если наименования нет
			 */
			proto.autoFilter = function (callBack) {
				let grid = this;
				if (grid.store.data.length === 0) return;

				const loadMask = new Ext.LoadMask({
					msg: wmc.getMask('FilterInProcess'),
					target: grid.ownerCt ?? grid,
					autoShow: true,
					closable: true
				});
				setTimeout(function () {
						let filterValue,
							filterColumn,
							filterIsSet = false;
						if (grid.getSelectionModelName() === 'row') {
							grid.changeSelectionModel('cell');
						}

						let sel = grid.getSelectionModel().getPosition ? grid.getSelectionModel().getPosition() : null;
						if (sel && sel.column && sel.column.isVisible()) {
							filterColumn = sel.column.dataIndex;
							filterValue = sel.record.get(filterColumn);
							filterValue = Ext.isDate(filterValue) || sel.column.xtype === "datecolumn" 
								? Ext.util.Format.date(filterValue, sel.column.format)
								: filterValue?.toString().toLowerCase();
							if (sel.column.xtype === "misccolumn") {
								if (sel.column.typeName) filterValue = miscTypes[sel.column.typeName][filterValue];
							}

							//сравним с уже заданным фильтром. если полностью совпадает - ничего не делаем
							let filters = grid.store.getTreeFilters ? grid.store.getTreeFilters() : grid.store.getFilters().items;
							if (filters.length === 1){
								let property = filters[0].property || filters[0]._property,
									value = filters[0].value || filters[0]._value;
								if (property === filterColumn && filterValue === value){
									loadMask.destroy();
									return;
								}
							}
						}
						
						grid.clearColumnFilter();
						
						grid.getStore().on('filterchange', () => {
							loadMask.destroy()
						}, {single: true});

						if (sel && sel.column && sel.column.isVisible()) {
							sel.column.filterInput && sel.column.filterInput.setValue(filterValue);
							filterIsSet = true;
						}

						if (grid.getFilterMode() === 'none' || !filterIsSet) {
							grid.showFilterRow();
							let cols = grid.columnManager.columns;
							cols.forEach(function (col) {
								if (!col.isVisible() || !col.filterInput) return;
								let input = col.filterInput,
									prop = col.dataIndex;

								if (!filterIsSet) {
									filterValue = sel && sel.record && sel.record.get(prop);
									filterValue = Ext.isDate(filterValue) || sel.column.xtype === "datecolumn" 
										? Ext.util.Format.date(filterValue, sel.column.format) 
										: filterValue?.toString().toLowerCase();
									if (sel.column.xtype === "misccolumn") {
										if (sel.column.typeName) filterValue = miscTypes[sel.column.typeName][filterValue];
									}
									input.setValue(filterValue);
									//input.ownerCt.ksFilter(val, 'equals');
									filterIsSet = true;
								} else if (filterColumn !== prop) {
									input.setValue();
								}
							});
						}
						
						if (!filterValue) loadMask.destroy();
						
						if (callBack) callBack(true);
					},
					10);
			}

			/** Получить режим выделения строк в гриде:
			 * "row" - выделение всей строки
			 * "cell" - выделение ячейки			    
			 */
			proto.getSelectionModelName = function () {
				return this.selModel instanceof Ext.selection.RowModel ? "row" : "cell";
			}

			/** Изменить режим выделения строк в гриде			 
			 * @param  {string} selModelName - режим, в который хотим перейти, "row" - выделение всей строки,  "cell" - выделение ячейки
			 * в случае если не задан, переключает между имеющимися
			 */			
			proto.changeSelectionModel = function (selModelName) {
				let grid = this,
					recSelected = grid.getSelectionModel().getSelection()[0],
					view = grid.getView(),
					selModelOld = view.getSelectionModel();
				const rowSelectedCls = 'rks-grid-row-selected';

				if (!selModelName) {
					selModelName = grid.getSelectionModelName() === 'row' ? 'cell' : 'row';
				}

				selModelOld.deselectAll(true);
				selModelOld.destroy();
				let selModel = selModelName === 'cell'
					? Ext.create('Ext.selection.CellModel', {
						mode: "SINGLE",
						listeners: {
							'select': function (selModel, rowIndex, row) {
								let cellRow = view.getRow(rowIndex);
								if (cellRow)
									Ext.fly(cellRow).addCls(rowSelectedCls);
							},

							'deselect': function (selModel, rowIndex) {
								let cellRow = view.getRow(rowIndex);
								if (cellRow)
									Ext.fly(cellRow).removeCls(rowSelectedCls);
							}
						}
					})
					: Ext.create('Ext.selection.RowModel', {});
				if (selModelName === "row") {
					let els = Ext.select("." + rowSelectedCls, true);
					els.removeCls(rowSelectedCls);
				}
				grid.selModel = selModel;
				view.setSelectionModel(selModel);
				selModel.bindStore(grid.store, true);
				selModel.bindComponent(grid.view);

				if (selModelName === "cell") {
					//для справочников по умолчанию NAME, для документов - первая из видимых колонок					
					let code = grid.ownerCt?.dict?.code,
						clmSelected = code && code.startsWith("DICTIONARY_") ? grid.down('gridcolumn[dataIndex=NAME]') : null;
					if (!clmSelected || clmSelected.hidden) {
						let visibleColumns = grid.down('headercontainer').getVisibleGridColumns();
						clmSelected = visibleColumns.filter(col => ['tree', 'M'].indexOf(col.dataIndex) === -1)[0] || visibleColumns[0];
					}
					if (clmSelected)
						selModel.select({
							row: recSelected ? recSelected : grid.getStore().getAt(0),
							column: clmSelected
						});
				} else {
					selModel.select(recSelected);
				}
				view.updateLayout();
			}

			/**
			 * Получить заполненнные фильтры по колонкам + состояние строки фильтрации
			 * @returns {*}
			 */
			proto.getColumnFilters = function() {
				let filters = this.store.getTreeFilters ? this.store.getTreeFilters() : this.store.getFilters().items,
					res = {
						filterMode: this.getFilterMode(),
						filters: filters.map(filter => {
							return {
								property: filter._property || filter.property,
								value: filter._value || filter.value,
								cond: filter._comboVal || filter.comboVal
							}
						})
					};
				return res;
			}
			/**
			 * Применить фильтры по колонкам в колонкам грида + состояние строки фильтрации
			 */
			proto.applyColumnFilters = function(columnFilters){
				this.suspendEvents();
				this.store.suspendEvents();
				if (columnFilters.filterMode === 'filterRow')
					this.showFilterRow();
				if (!columnFilters.filters) return;
				columnFilters.filters.forEach(filter => {
					let clm = this.down(`gridcolumn[dataIndex=${filter.property || filter._property}]`);
					if (clm && clm.filterInput) {
						clm.filterInput.suspendEvents();
						clm.filterInput.setValue(filter.cond);
						clm.filterInput.setValue(filter.value || filter._value);
						clm.ksFilter(filter.value || filter._value, filter.cond);
						clm.filterInput.resumeEvents(false);
					}
				});
				this.resumeEvents();
				this.store.resumeEvents();
			}
			
			proto.getToolbar = function(){
				return this.dockedItems.items.filter(item=>item.xtype === 'toolbar')[0];				
			}

			proto.getToolbarItem = function(key){
				let toolbar = this.getToolbar();
				return toolbar ? toolbar.items.items.filter(item=>item.key === key)[0] : null;
			}
			
			proto.setReadOnly = function(readOnly){
				this.readOnly = readOnly;
				let plugin = this.plugins.filter(plugin => plugin instanceof Ext.grid.plugin.CellEditing)[0];
				if (plugin) plugin.beforeEdit = readOnly ? KsLib.falseFn : Ext.emptyFn;
			}

			proto.isReadOnly = function() {
				return this.disabled || this.readOnly || this.ksReadOnly;
			}
		}
	}

	if (Ext.grid) {
		if (Ext.grid.Panel) {
			proto = Ext.grid.Panel.prototype;
			proto.removeSelection = function(func, afterRem) {
				var me = this,
					model = me.getSelectionModel(),
					rowsel = [],
					rowdel = [],
					sels = model.getSelection(),
					countSels = sels.length;
				if (countSels) {
					selectDialogShow(wmc.get('Deleting'),
						wmc.get('DeleteMessage', countSels),
						function() {
							for (var i = 0; i < countSels; i++) {
								var havFunc = Ext.isFunction(func) ? func(sels[i]) !== false : true;
								if (havFunc) {
									rowdel.push(sels[i]);
								} else {
									rowsel.push(sels[i]);
								}
							}

							if (rowsel.length) {
								model.select(rowsel);
								if (rowdel.length) me.getStore().remove(rowdel);
							} else {
								var view = me.getView();
								for (i = 0; i < countSels; i++) {
									var index = view.indexOf(sels[i]);
									me.getStore().remove(sels[i]);
									if (view.getRecord(index)) {
										model.select(index);
									} else if (view.getRecord(index - 1) && !model.isRowSelected(index - 1)) {
										model.select(index - 1);
									}
									;
								}
							}
							if (afterRem) afterRem();
						});
				}
			};

			proto.extraSelect = function(selected) {
				var grid = this,
					model = grid.getSelectionModel(),
					store = grid.getStore(),
					view = grid.view;

				if (!model.store) {
					model.store = store;
					if (!model.views || !model.views.length) {
						model.views = [view];
					}
				}

				model.select(selected);
			};

			proto.extraSelectFrst = function() {
				this.extraSelect(this.store.getAt(0));
			};

			proto.loadData = function(data, append, select = true) {
				var th = this,
					store = th.getStore();

				if (store) {
					store.loadData(data, append);
					if (select) {
						th.extraSelectFrst();
					}
				}
			};

			proto.getFrstSelect = Ext.tree.Panel.prototype.getFrstSelect;

			proto.setMetaDate = Ext.tree.Panel.prototype.setMetaDate;

			proto.getFilterMode = Ext.tree.Panel.prototype.getFilterMode;
			proto.showFilterRow = Ext.tree.Panel.prototype.showFilterRow;
			proto.clearColumnFilter = Ext.tree.Panel.prototype.clearColumnFilter;
			proto.autoFilter = Ext.tree.Panel.prototype.autoFilter;

			proto.getSelectionModelName = Ext.tree.Panel.prototype.getSelectionModelName;
			proto.changeSelectionModel = Ext.tree.Panel.prototype.changeSelectionModel;

			proto.getColumnFilters = Ext.tree.Panel.prototype.getColumnFilters;
			proto.applyColumnFilters = Ext.tree.Panel.prototype.applyColumnFilters;
			
			proto.getToolbar = Ext.tree.Panel.prototype.getToolbar;
			proto.getToolbarItem = Ext.tree.Panel.prototype.getToolbarItem;
			proto.setReadOnly = Ext.tree.Panel.prototype.setReadOnly;
			proto.isReadOnly = Ext.tree.Panel.prototype.isReadOnly;
		}

		if (Ext.grid.plugin && Ext.grid.plugin.CellEditing) {
			proto = Ext.grid.plugin.CellEditing.prototype;

			proto.oldInit = proto.init;

			proto.init = function() {
				var res = this.oldInit.apply(this, arguments);

				this.on('afteredit',
					function(th, e) {
						let ep = th;

						//Меняем даты местами в гридах если с > по
						if (th.isDhSwap) {
							setTimeout(function() {
									let ep = th,
										currentColumn = ep.context.field;

									if (ep.dhSwapFields && ep.dhSwapFields.length) {
										var ind = ep.dhSwapFields.indexOf(currentColumn.replace(/[0-9]/, ''));
										if (ind === -1) return;
										ep.dhSwapField = ep.dhSwapFields[ind];
									} else {
										ep.dhSwapField = ep.dhSwapField || 'DH';
									}

									var field1 = ep.dhSwapField + '1',
										field2 = ep.dhSwapField + '2',
										rec = e.record;

									if (ep.editing && (currentColumn === field1 || currentColumn === field2)) return;

									var dh1 = rec.get(field1),
										dh2 = rec.get(field2),
										tmp;

									if (dh1 && dh2 && dh1 > dh2) {
										tmp = dh1;
										rec.set(field1, dh2);
										rec.set(field2, tmp);
										ep.fireEvent('ksDhSwap', th, e);
										e.ksDhSwaped = true;
									}

									ep.fireEvent('ksAfteredit', th, e);
								},
								100);
						} else {
							ep.fireEvent('ksAfteredit', th, e);
						}
					});

				return res;
			};

			//метод скопирован с исходников ext7.1, изменены 2 строки (помечены *)
			proto.getCachedEditor = function(editorId, record, column) {
				var me = this,
					editors = me.editors,
					editorId = editorId + (column.getEditorId ? '_' + column.getEditorId(record) : ''), //*
					editor = editors.getByKey(editorId);
				if (me.grid.ownerCt && me.grid.ownerCt.dict && me.grid.ownerCt.dict.readOnly) return false; //*
				
				if (!editor) {
					editor = column.getEditor(record);
					if (!editor) {
						return false;
					}
					if (!(editor instanceof Ext.grid.CellEditor)) {						
						editor = Ext.widget(Ext.apply({
							xtype: 'celleditor',
							floating: true,
							editorId: editorId,
							field: editor
						}, editor.editorCfg));
					}					
					editor.field.excludeForm = true;
					if (editor.column !== column) {
						editor.column = column;
						column.on('removed', me.onColumnRemoved, me);
					}
					editors.add(editor);
				}
				editor.ownerCmp = me.grid.ownerGrid;
				if (column.isTreeColumn) {
					editor.isForTree = column.isTreeColumn;
					editor.addCls(Ext.baseCSSPrefix + 'tree-cell-editor');
				}				
				editor.setGrid(me.grid);
				editor.editingPlugin = me;
				editor.collectContainerElement = true;
				return editor;				
			};
		}
		if (Ext.grid.locking.Lockable) {
			Ext.grid.locking.Lockable.prototype.syncLockedWidth = function() {
				var me = this,
					locked = me.lockedGrid,
					lockedView = locked.view,
					lockedViewEl = lockedView.el ? lockedView.el.dom : null,
					normal = me.normalGrid,
					lockedColCount = locked.headerCt.getVisibleGridColumns().length,
					normalColCount = normal.headerCt.getVisibleGridColumns().length;

				Ext.suspendLayouts();


				if (normalColCount) {
					normal.show();
					if (lockedColCount) {


						if (!locked.headerCt.forceFit) {
							delete locked.flex;

							locked.setWidth(locked.headerCt.getWidth());
						}
						locked.addCls(me.lockedGridCls);
						locked.show();
					} else {


						locked.getView().refresh();
						locked.hide();
					}

					lockedView.el && lockedView.el.setStyle(lockedView.getOverflowStyle());

					me.ignoreMousewheel = lockedView.scrollFlags.y;
				} else {
					normal.hide();


					if (lockedViewEl) lockedViewEl.style.borderBottomWidth = '0';


					locked.flex = 1;
					delete locked.width;
					locked.removeCls(me.lockedGridCls);
					locked.show();


					lockedView.el && lockedView.el.setStyle(normal.view.getOverflowStyle());
					me.ignoreMousewheel = true;
				}
				Ext.resumeLayouts(true);
				return [lockedColCount, normalColCount];
			};
		}

		if (Ext.grid.column) {
			//Используется при рендере для автоопределения высоты с учетом поля фильтра
			if (Ext.grid.ColumnComponentLayout) {
				proto = Ext.grid.ColumnComponentLayout.prototype;
				proto.extPublish = proto.publishInnerHeight;
				proto.publishInnerHeight = function(ownerContext, outerHeight) {
					var items = ownerContext.target.items;

					if (['actioncolumn', 'actionimg', 'treecolumn', 'rks-grid-column-rownumberer'].indexOf(ownerContext.target.xtype) === -1) {
						if (items && items.items[0] && items.items[0].xtype === 'textfield') {
							ownerContext.hasRawContent = !items.items[0].isVisible();
						}
					}


					return this.extPublish(ownerContext, outerHeight);
				};
			}

			if (Ext.grid.column.Column) {
				proto = Ext.grid.column.Column.prototype;
				
				proto.ksFilter = function(val, comboVal) {
					let grid = this.up('tablepanel'),
						bl = grid.ownerCt?.dict ?? grid.ownerCt?.ownerCt?.dict,
						filterVal = this.filterInput.getValue() || val,
						filterProp = this.property || this.dataIndex,
						store = grid.store,
						miscTypeName = this.xtype === "misccolumn" ? this.typeName : null,
						stringCompare = function(val, filterVal) {
							return (val ?? '').toString().toLowerCase().indexOf(filterVal.toLowerCase());
						};
					
					let filterFn = Ext.emptyFn;
					if (val === '') {
						this.titleEl?.removeCls('ks-filterCol');//убрала this.removeCls. см.ниже					
						store.removeFilter(this.dataIndex);
					} else {
						this.titleEl?.addCls('ks-filterCol'); //убрала this.addCls. мешает в случае, когда titleEl еще не отренедерился
						let editDistance = function (s1, s2) {
							s1 = s1.toLowerCase();
							s2 = s2.toLowerCase();

							var costs = new Array();
							for (var i = 0; i <= s1.length; i++) {
								var lastValue = i;
								for (var j = 0; j <= s2.length; j++) {
									if (i == 0)
										costs[j] = j;
									else {
										if (j > 0) {
											var newValue = costs[j - 1];
											if (s1.charAt(i - 1) != s2.charAt(j - 1))
												newValue = Math.min(Math.min(newValue, lastValue),
													costs[j]) +
													1;
											costs[j - 1] = lastValue;
											lastValue = newValue;
										}
									}
								}
								if (i > 0)
									costs[s2.length] = lastValue;
							}
							return costs[s2.length];
						},
							similarity = function (s1, s2) {
								let longer = s1 || '',
									shorter = s2 || '';
								if (s1.length < s2.length) {
									longer = s2;
									shorter = s1;
								}
								let longerLength = longer.length;
								if (longerLength === 0) {
									return 1.0;
								}
								return (longerLength - editDistance(longer, shorter)) / parseFloat(longerLength);
							},
							getValue = (item) => {
								let value = item.get(filterProp);
								if (miscTypeName) value = miscTypes[miscTypeName][value];
								return value || '';
							};

						switch (comboVal) {
							case 'equals':
								filterFn = item => getValue(item) == filterVal;
								break;
							case 'notequals':
								filterFn = item => getValue(item) != filterVal;
								break;
							case 'like':
								filterFn = function (item) {
									//0.7 - процент "похожести"
									return similarity(getValue(item), filterVal) > 0.7;
								};
								break;
							case 'starts':
								filterFn = (item) => stringCompare(getValue(item), filterVal) === 0;
								break;
							case 'match':
							case 'contains':
								filterFn = (item) => {
									let ind = stringCompare(getValue(item), filterVal);
									return (Ext.isNumber(ind) && ind !== -1);
								};
								break;
							case 'ends':
								filterFn = (item) => {
									let str = (getValue(item) ?? '').toString().toLowerCase().trim();
									return str.indexOf(filterVal, str.length - filterVal.length) >= 0;
								};
								break;
							case 'notstart':
								filterFn = item => stringCompare(getValue(item), filterVal) !== 0;
								break;
							case 'notend':
								filterFn = (item) => {
									let str = getValue(item);//.toString().toLowerCase().trim()
									return !(str.indexOf(filterVal, str.length - filterVal.length) >= 0);
								};
								break;
							case 'notcontain':
							case 'notmatch':
								filterFn = (item) => {
									let ind = stringCompare(getValue(item), filterVal);
									return Ext.isNumber(ind) && ind === -1;
								};
								break;
							case 'notlike':
								//0.8 - процент "похожести"
								filterFn = item => similarity(getValue(item), filterVal) < 0.7;
								break;
							case 'equalsDT':
								filterFn = (item) => {
									let date = moment(filterVal, 'DD.MM.YYYY');
									let cellValue = moment(item.get(filterProp), 'YYYY/MM/DD)');
									if (cellValue.isValid() && date.isValid()) {
										return cellValue.toDate().getTime() === date.toDate().getTime();
									} else {
										return true;
									}
								};
								break;
							case 'notEqualsDT':
								filterFn = (item) => {
									let date = moment(filterVal, 'DD.MM.YYYY');
									let cellValue = moment(item.get(filterProp), 'YYYY/MM/DD)');
									if (cellValue.isValid() && date.isValid()) {
										return cellValue.toDate().getTime() !== date.toDate().getTime();
									} else {
										return true;
									}
								};
								break;
							case 'greaterDT':
								filterFn = (item) => {
									let date = moment(filterVal, 'DD.MM.YYYY');
									let cellValue = moment(item.get(filterProp), 'YYYY/MM/DD)');
									if (cellValue.isValid() && date.isValid()) {
										return cellValue.toDate().getTime() > date.toDate().getTime();
									} else {
										return true;
									}
								}
								break;
							case 'lessDT':
								filterFn = (item) => {
									let date = moment(filterVal, 'DD.MM.YYYY');
									let cellValue = moment(item.get(filterProp), 'YYYY/MM/DD)');
									if (cellValue.isValid() && date.isValid()) {
										return cellValue.toDate().getTime() < date.toDate().getTime();
									} else {
										return true;
									}
								};
								break;
							case 'greaterEqDT':
								filterFn = (item) => {
									let date = moment(filterVal, 'DD.MM.YYYY');
									let cellValue = moment(item.get(filterProp), 'YYYY/MM/DD)');
									if (cellValue.isValid() && date.isValid()) {
										return cellValue.toDate().getTime() >= date.toDate().getTime();
									} else {
										return true;
									}
								};
								break;
							case 'lessEqDT':
								filterFn = (item) => {
									let date = moment(filterVal, 'DD.MM.YYYY');
									let cellValue = moment(item.get(filterProp), 'YYYY/MM/DD)');
									if (cellValue.isValid() && date.isValid()) {
										return cellValue.toDate().getTime() <= date.toDate().getTime();
									} else {
										return true;
									}
								}
								break;
							case 'equalsBool':
								filterFn = (item) => {
									let val = item.get(filterProp);
									if (val === undefined) val = false;
									return val === filterVal;
								}
								break;
						}

						store.filter([
							{
								property: filterProp,
								value: filterVal,
								comboVal: comboVal,
								filterFn: filterFn
							}
						]);
					}

					//Применяем только для линейных, у древовидных свое
					if (!store.root && bl && grid.getSelectionModel()) {
						//сбросим выделение для строк, непопадающих под фильтр
						let selFiltered = bl.selectLinks.filter(rec => store.getDataExt().filter(r => r.LINK === (rec.get ? rec.get('LINK') : rec.LINK)).length);
						if (selFiltered.length !== bl.selectLinks.length) {
							bl.selectLinks = selFiltered;
							if (bl.selectLinks.length)
								bl.Grid.getSelectionModel().select(bl.selectLinks);
							else
								bl.Grid.getSelectionModel().deselectAll();
						}
						bl.setSBText(bl.dataCount,
							grid.getSelectionModel().getSelection().length,
							bl.checkList.length,
							val?.length ? store.data.length : false);
					}

					store.visibleCount = store.data.length;
				};
				proto.addKsInputEl = function(col) {
					col.filterable = true;
					
					let getDefaultOperatorByXType = function (xtype) {
						switch(xtype) {
							case "datecolumn":
								return 'equalsDT';
							default:
								return 'contains';
						}
					};
					let grid = this.up('tablepanel'),
						pnlFilter;
					if (col.xtype === 'checkcolumn' || col.xtype === 'checkcolumnextra') {
						pnlFilter = Ext.create('Ext.panel.Panel', {
							layout: 'center',
							hidden: true,
							userCls: 'rks-filter rks-filter__clearfilter',
							minWidth: 40,
							items: [
								col.filterInput = Ext.create('Ext.form.field.Checkbox', {
									height: 22,
									width: '100%',
									listeners: {
										change: function (th1, newValue) {
											col.ksFilter(newValue, 'equalsBool');
											//col.items.items[0].items.items[1].el.setStyle('display', 'inline-block !important');													
										}
									}
								}),
								
								//тут div нужен, чтобы  размер кнопки удаления сужался с колонкой, сейчас inline a и span, с фикс шириной
								// col.delBtn = Ext.create('Ext.Button', {
								// 	cls: 'x-form-arrow-trigger x-form-trigger x-dict-trigger x_btn_delete_note_def btn-check-delete',									
								// 	width: '22px',
								// 	border: 0,
								// 	hidden: true,
								// 	handler: function () {
								// 		col.ksFilter('', '');
								// 	}
								// })
							],
							getValue: Ext.emptyFn,
							setValue: Ext.emptyFn,
						});
					}
					else if (col.xtype === 'rks-grid-column-rownumberer' || (col.xtype === 'treecolumn' && col.hasColumnChooser)) {						
						pnlFilter = Ext.create('Ext.panel.Panel', {
							layout: {type: 'hbox', align: 'stretch'},
							hidden: true,
							userCls: 'rks-filter rks-filter__clearfilter',
							minWidth: col.xtype === 'treecolumn' ? 40 : 30,
							minHeight: 25,
							items:
								[
									Ext.create('Ext.button.Button', {
										height: 24,
										width: '100%',
										flex: 1,
										border: 0,
										iconCls: 'x_btn_clear_filter',
										userCls: 'btn_clear_filter',
										tooltip: 'Очистить фильтр',
										tooltipType: 'title',
										handler: function () {
											col.up('tablepanel')?.clearColumnFilter();
										}
									})
								]
						});
					}
					else {
						let allowedConditions;
						let conditionMappings;
						if (col.xtype === 'datecolumn') {
							allowedConditions = [0, 1, 2, 3, 4, 5];
							conditionMappings = {
								0: {'value': 'equalsDT'},
								1: {'value': 'notequalsDT'},
								2: {'value': 'greaterDT'},
								3: {'value': 'greaterEqDT'},
								4: {'value': 'lessDT'},
								5: {'value': 'lessEqDT'}
							}
						} else {
							//10 - похож, 11 - подходит, 12 - не начинается, 13 - не оканчивается, 14 - не подходит, 15 - не похож
							allowedConditions = [0, 1, 10, 11, 8, 6, 9, 12, 7, 13, 14, 15];
							conditionMappings = {
								0: {'value': 'equals'},
								1: {'value': 'notequals'},
								10: {'name': 'похож', 'icon': 'x_btn_FilterOp_Like', 'value': 'like'},
								11: {'name': 'подходит', 'icon': 'x_btn_FilterOp_Match', 'value': 'match'},
								8: {'value': 'starts'},
								6: {'value': 'contains'},
								9: {'value': 'ends'},
								12: {
									'name': 'не начинается с',
									'icon': 'x_btn_FilterOp_DoesNotStartWith',
									'value': 'notstart'
								},
								7: {'value': 'notcontain'},
								13: {
									'name': 'не оканчивается на',
									'icon': 'x_btn_FilterOp_DoesNotEndWith',
									'value': 'notend'
								},
								14: {
									'name': 'не подходит',
									'icon': 'x_btn_FilterOp_DoesNotMatch',
									'value': 'notmatch'
								},
								15: {'name': 'не похож', 'icon': 'x_btn_FilterOp_NotLike', 'value': 'notlike'}
							}
						}
						pnlFilter = Ext.create('Ext.panel.Panel', {
							layout: 'center',
							border: 0,
							hidden: true,
							userCls: 'rks-filter',
							items: [
								col.filterInput = Ext.create('Keysystems.Controls.FilterOperator',
									{
										flex: 1,
										width: 60,
										value: getDefaultOperatorByXType(col.xtype),
										conditionMappings: conditionMappings,
										allowedConditions: allowedConditions,
										selectOnFocus: true,
										editable: true,
										listeners: {
											change: {
												buffer: 500,
												fn: function (th, newVal) {
													if (col.defVal) {
														col.defVal = false;
														return _;
													}
													if (newVal === null) {
														newVal = '';
													}
													//if (Ext.isDate(newVal)) newVal = newVal.toLocaleDateString();
													var contains = Ext.each(th.store.data.items,
														function (d) {
															if (d.get('value') == newVal) {
																return false;
															}
														});

													if (!Ext.isNumber(contains) && newVal !== th.ksLastValue) {
														col.ksFilter(newVal, th.ksComboValue || getDefaultOperatorByXType(col.xtype));
														th.ksLastValue = newVal;
													}

													if (newVal === '') {
														// возвращаем дефолтное значение
														col.defVal = true;
														let comboData = th.store.getDataExt(),
															value = getDefaultOperatorByXType(col.xtype);
														let changedValue = comboData.filter(d => d.value === th.ksComboValue)[0];
														if (changedValue) value = changedValue;
														th.setValue(value);
														th.selectText();
													}
												}
											},
											select: function (th, val) {
												var contains = Ext.each(th.store.data.items,
													function (d) {
														if (d.get('value') == th.ksLastValue) {
															return false;
														}
													});

												th.ksComboValue = val.data.value;
												if (!Ext.isNumber(contains) && th.ksLastValue) {
													th.setValue(th.ksLastValue);
													col.ksFilter(th.ksLastValue, th.ksComboValue);
												}
												th.selectText();
											},
											afterrender: function (th) {
												th.addCls('rks-filter');
											}
										}
									})
							]
						});
					}
					col.items.add(pnlFilter);
					//col.items = [col.iconCombo];
					return pnlFilter;
				};
				proto.addKsSummaryTriggerEl = function(col) {
					col.filterable = true;
					col.items = []
				};
				proto.baseInitComponent = proto.initComponent;
				proto.initComponent = function() {
					let me = this,
						groupColumn = me.columns && me.columns.length;

					//зануление  width и dataIndex для групповых колонок (иначе ломается список с ошибкой extjs) 
					if (groupColumn) {
						me.width = me.dataIndex = null;
					}

					//подмена текста пункта меню по настройке столбцов грида для actioncolumn 
					//если не заполнено св-во menuText, extjs по умолчанию добавляет текст <i>Actions</i> 
					if (me.xtype === 'actioncolumn' || me.xtype === 'actionimg') {
						if (!me.iconCls && me.menuText.indexOf('Actions') >= 0)
							me.menuText = me.text;
					}

					this.baseInitComponent.apply(this, arguments);

					//добавление поля фильтра в колонку 
					if (['actioncolumn', 'actionimg'].indexOf(me.xtype) === -1 && !groupColumn) {
						me.addKsInputEl(me);
					}
				};
			}

			if (Ext.grid.feature.Summary){
				//по умолчанию строка с итогами показывается при изменении данных в store, даже в случае, если она отключена в конфиге (showSummaryRow=false)
				Ext.grid.feature.Summary.prototype.onStoreUpdateBase = Ext.grid.feature.Summary.prototype.onStoreUpdate;
				Ext.grid.feature.Summary.prototype.onStoreUpdate = function() {
					if (!this.showSummaryRow) return;
					this.onStoreUpdateBase();
				}
				Ext.grid.feature.Summary.prototype.doRefresh = function() {
					this.onStoreUpdate();
				}
			}
			if (Ext.grid.column.Date) {
				Ext.grid.column.Date.prototype.defaultRenderer = function(v) {
					if (v && !Ext.isDate(v)) v = new Date(v);
					return Ext.util.Format.date(v, this.format);
				};
			}

			if (Ext.grid.column.Action) {
				Ext.grid.column.Action.prototype.addCls = function(cls) {
					var me = this,
						el = me.rendered ? me.el : me.protoEl;

					el && el.addCls.apply(el, arguments);
					return me;
				};
				/*var addClsExt = Ext.grid.column.Action.prototype.addCls;
				*/
			}
		}


		if (Ext.grid.header.Container) {
			proto = Ext.grid.header.Container.prototype;
			//скрывает пункт меню хэдера колонки - Столбцы
			//proto.enableColumnHide = false;

			//перегрузка для дополнения меню своими пунктами и скрытия пунктов "Сортировать.." 
			proto.baseGetMenuItems = proto.getMenuItems;
			proto.getMenuItems = function() {
				const menuItems = this.baseGetMenuItems();

				//скрываем ненужные пункты "Сортировать по.."
				menuItems.filter(item => ['ascItem', 'descItem', 'columnItemSeparator'].indexOf(item.itemId) >= 0)
					.forEach(item => item.hidden = true);

				//дополняем своими пунктами
				return menuItems.concat([
					'-',
					{
						text: 'Вид фильтра',
						iconCls: 'x_btn_filter_empty',
						handler: function (ct) {
							ct.up('tablepanel')?.showFilterRow();
						},
					},
					{
						text: 'Очистить фильтр',
						iconCls: 'x_btn_filter_off',
						handler: function (ct) {
							setTimeout(function () {
								ct.up('tablepanel')?.clearColumnFilter();
							}, 20);
						},
					},
					{
						text: 'Автоподбор ширины колонок',
						iconCls: 'x_btn_flex',
						handler: function (ct) {
							ct.ownerCt.activeHeader.autoSize();
						}
					},
					{
						text: 'Скрыть колонку',
						iconCls: 'x_btn_hide_column',
						handler: function (ct) {
							ct.ownerCt.activeHeader.hide();
						},
					}
				]);

				//раскомментить после 22.2, убрав GridColumnManager.appendHeaderMenu (в текущей реализации всегда создается меню хэдера в конструкторе GCM)
				//const grid = me.up('tablepanel');
				// const list = grid?.ownerCt?.dict ?? grid?.ownerCt?.ownerCt?.dict;
				// if (list && list.columnManager) {
				// 	menuItems.push('-');
				// 	menuItems.push({
				// 		itemId: 'settItem',
				// 		text: 'Настроить список',
				// 		iconCls: 'x_btn_settings',
				// 		handler: function () {
				// 			list.showColumnManager();
				// 		},
				// 	})
				// }
			};

			//перегрузка для скрытия сепаратора между пунктами "Сортировать.." (скрыты) и "Столбцы" (видим)
			proto.baseBeforeMenuShow = proto.beforeMenuShow;
			proto.beforeMenuShow = function(menu) {
				this.baseBeforeMenuShow(menu);
				//разделитель columnItemSeparator между пунктами "Сортировать" и "Столбцы" пересоздается, если ранее был вызван reconfigure (ext-all-debug.js, стр 231711)
				const separator = menu.child('#columnItemSeparator');
				if (separator) separator.hidden = true;
			}

			//перегрузка для getColumnMenu, для отображения иконок в списке колонок
			//работает для колонок ['actioncolumn', 'actionimg'] при задании iconCls 
			proto.baseGetColumnMenu = proto.getColumnMenu;
			proto.getColumnMenu = function(headerContainer) {
				let menu = this.baseGetColumnMenu(headerContainer),
					actionColumns = headerContainer.query('>gridcolumn[hideable]')
						.filter(col => col.iconCls && ['actioncolumn', 'actionimg'].indexOf(col.xtype) >= 0);
				
				//перебор колонок, поиск нужного пункта меню, подмена вывода элемента при рендере
				actionColumns.forEach(col => {
					let menuItem = menu.filter(item => col.id === item.headerId)[0];
					if (!menuItem) return;
					
					menuItem.on('render', (comp) => {
						Ext.DomHelper.overwrite(comp.getEl().down(".x-menu-item-text"), {
							tag: 'div',
							class: "rks-menu-item",
							children: [
								{
									tag: 'div',
									class: "rks-menu-item-icon " + col.iconCls,
								},
								{
									tag: 'span',
									class: 'x-menu-item-text x-menu-item-text-default x-menu-item-indent-right-arrow',
									html: col.text || "&nbsp;"
								}
							]
						});

					});
				})
				return menu;
			}
		}

		if (Ext.grid.feature.Grouping) {
			proto = Ext.grid.feature.Grouping.prototype;
			proto.extInit = proto.init;
			proto.init = function(grid) {
				this.groupRowTpl = this.groupRowTpl.concat();
				return this.extInit(grid);
			};
		}
	}

	Ext.override(Ext.panel.Table, {
		config: {
			defaults: {
				contextMenuHidden: false
			}
		},
		
		initComponent: function () {
			this.callParent(arguments);

			// добавление контекстного меню грида
			const showContextMenuFn = function (grid, e) {
				if (!grid || grid.contextMenuHidden) return;
				e.stopEvent();
				
				if (!grid.contextMenu) grid.createContextMenu();
				grid.adaptContextMenu();
				grid.contextMenu.showAt(e.getXY());
				return false;
			}
			this.on('itemcontextmenu', (ct, record, item, index, e) => showContextMenuFn(ct.ownerGrid, e));
			this.on('headercontextmenu', (ct, column, e) => showContextMenuFn(ct.ownerCt, e));
			this.on('containercontextmenu', (ct, e) => showContextMenuFn(ct.ownerGrid, e));			

			//дополнение меню хэдера колонок
			// let menu = this.headerCt.getMenu();
			// this.appendHeaderMenu(menu);
		},

		/**
		 * Получить контекстное меню грида
		 * @returns {Ext.menu.Menu}
		 */
		getContextMenu: function () {
			if (!this.contextMenu) this.createContextMenu();
			return this.contextMenu;
		},

		/**
		 * Создать контекстное меню грида (пункты по умолчанию + кнопки тулбара). 
		 * Вызывается один раз при первом вызове контекстного меню.
		 * @returns {Ext.menu.Menu}
		 */
		createContextMenu: function () {
			const me = this,
				contextMenu = Ext.create('Ext.menu.Menu',
					{
						items: [
							{
								text: 'Автоподбор ширины колонок',
								iconCls: 'x_btn_flex',
								handler: function () {
									me.getVisibleColumns().forEach(col => col.autoSize());
								},
								scope: me
							},
							Ext.create('Ext.Action',
								{
									code: 'selectionMode',
									text: 'Выделить ячейку',
									iconCls: 'x_btn_cell',
									handler: function () {
										let oldMode = me.getSelectionModelName();
										me.changeSelectionModel(oldMode === 'row' ? 'cell' : 'row');
										const cmModeItem = me.contextMenu.items.items.filter(item => item.code === "selectionMode")[0];
										if (cmModeItem) {
											cmModeItem.setText(oldMode === 'row' ? 'Выделить строку' : 'Выделить ячейку');
											cmModeItem.setIconCls(oldMode === 'row' ? 'x_btn_row' : 'x_btn_cell');
										}
									}
								}),
							Ext.create('Ext.Action',
								{
									text: 'Вид фильтра',
									iconCls: 'x_btn_filter_empty',
									handler: function () {
										me.showFilterRow();
									}
								}),
							Ext.create('Ext.Action',
								{
									iconCls: 'x_btn_filter_off',
									text: 'Очистить фильтр',
									handler: function () {
										me.clearColumnFilter();
									}
								}),

						]
					});

			//дополним кнопками тулбара, если есть
			const toolbar = me.dockedItems?.items?.filter(item => item.xtype === 'toolbar')[0];
			const cmToolbarItems = Keysystems.ToolbarBuilder.prototype.buildContextMenuByToolbar(toolbar?.items?.items);
			if (cmToolbarItems.length > 0) {
				contextMenu.add('-');
				cmToolbarItems.forEach(cmItem => {
					contextMenu.add(cmItem);
				})
			}
			return me.contextMenu = contextMenu;
		},

		/**
		 * Синхронизировать контекстное меню с тулбаром.
		 * Вызывается при каждом вызове контекстного меню
		 */
		adaptContextMenu: function(){
			const me = this;
			const toolbar = me.dockedItems?.items?.filter(item=>item.xtype === 'toolbar')[0];
			if (!toolbar) return;

			toolbar.items.items.forEach(tool => {
				const cmItem = me.contextMenu?.items.items.filter(item=>item.code && item.code === (tool.code ?? tool.key ?? tool.iconCls ?? ''))[0];
				if (cmItem){
					if (cmItem.text !== tool.tooltip) cmItem.setText(tool.tooltip);
					if (cmItem.iconCls !== tool.iconCls) cmItem.setIconCls(tool.iconCls);
					if (cmItem.disabled !== tool.disabled) cmItem.setDisabled(tool.disabled);
				}
			});
		},

		appendHeaderMenu: function (menu) {
			const me = this;
			menu.add(
				{
					text: 'Вид фильтра',
					iconCls: 'x_btn_filter_empty',
					handler: function () {
						me.showFilterRow();
					},
					scope: me
				},
				{
					text: 'Очистить фильтр',
					iconCls: 'x_btn_filter_off',
					handler: function () {
						setTimeout(function () {
							me.clearColumnFilter();
						}, 20);
					},
					scope: me
				},
				'-',
				{
					text: 'Растянуть',
					iconCls: 'x_btn_flex',
					handler: function (ct) {
						ct.ownerCt.activeHeader.autoSize();
					}
				})
		},

		onDestroy: function(){
			const me = this;
			me.ownerGrid?.contextMenu?.destroy();
			me.callParent(arguments);
		}
	});

	if (Ext.ZIndexManager) {
		Ext.ZIndexManager.prototype._showModalMask = function(comp) {
			var me = this,
				zIndex = comp.el.getStyle('zIndex') - 4,
				maskTarget = comp.floatParent
					? comp.floatParent.getTargetEl()
					: (comp.animateTarget && comp.animateTarget.getEl())
						? comp.animateTarget
						: comp.container,
				mask = me.mask,
				shim = me.maskShim,
				viewSize;

			if (!mask) {
				if (Ext.isIE6) {
					shim = me.maskShim = Ext.getBody().createChild({
						tag: 'iframe',
						cls: Ext.baseCSSPrefix + 'shim ' + Ext.baseCSSPrefix + 'mask-shim'
					});
					shim.setVisibilityMode(Ext.Element.DISPLAY);
				}


				mask = me.mask = Ext.getBody().createChild({
					cls: Ext.baseCSSPrefix + 'mask',
					style: 'height:0;width:0'
				});
				mask.setVisibilityMode(Ext.Element.DISPLAY);
				//todo EXTJS71 _onMaskClick теперь нет в ZIndexManager
				mask.on('click', function(e, target, options){
					if (me._onMaskClick) me._onMaskClick(e, target, options);
				}, me);
			}

			mask.maskTarget = maskTarget;
			viewSize = me.getMaskBox();

			if (shim) {
				shim.setStyle('zIndex', zIndex);
				shim.show();
				shim.setBox(viewSize);
			}
			mask.setStyle('zIndex', zIndex);


			mask.show();
			mask.setBox(viewSize);
		};
	}

	if (Ext.view.Table) {
		Ext.view.Table.prototype.dirtyCls = '';

		//todo не поняла, для чего этот метод. если необходимо - нужно исправить, ибо неработоспособен
		// Ext.view.Table.prototype.indexInStore = function(node) {
		// 	var me = this;
		// 	node = node.isCollapsedPlaceholder ? me.getNode(node) : me.getNode(node, false);
		// 	if ((!node && node !== 0) || !node.getAttribute) {
		// 		return -1;
		// 	}
		// 	var recordIndex = node.getAttribute('data-recordIndex');
		// 	if (recordIndex) {
		// 		return parseInt(recordIndex, 10);
		// 	}
		// 	return me.dataSource.indexOf(me.getRecord(node));
		// };
	}

	if (Ext.data) {
		if (Ext.data.Store) {
			proto = Ext.data.Store.prototype;
			proto.getLinks = function (fieldName) {
				return this.getDataExt().map(r => r[fieldName || 'LINK']);
			};

			/**
			Получить данные Store. В отличие от getData() по дефолту вернет все записи (даже если ранее был наложен фильтр)
			* @param  {function} [fn=null]  ф-ия доп. обработки
			* @param  {boolean} [isJson=false] в формате JSON
			* @param  {boolean} [filterOnly=false] учитывать фильтр
			 */
			proto.getDataExt = function (fn, isJson, filterOnly) {
				var result = [];

				const data = this.getData();
				//если на store наложен фильтр, то data.items вернет только записи попадающие под фильтр 
				const items = data.getSource && data.getSource() && !filterOnly
							? data.getSource().getRange()
							: data.items;
				items.forEach(function (rec) {
					var d = rec.getData();
					delete d.id;
					if (Ext.isFunction(fn)) d = fn(d, rec);
					if (d) result.push(d);
				})
				if (isJson) result = JSON.stringify(result);
				return result;
			};

			proto.getRecord = function (value, field) {
				return this.findRecord(field || 'LINK', value);
			};
		}

		if (Ext.data.TreeStore) {
			proto = Ext.data.TreeStore.prototype;
			proto.each = function (fn, scope, reverse, node) {
				if (!node) node = this.getRootNode();
				if (node) {
					var i,
						array = node.childNodes,
						len = array.length;
					if (reverse) {
						for (i = len - 1; i > -1; i--) {
							if ((fn.call(scope || array[i], array[i], i, array) === false) ||
								(this.each(fn, scope, reverse, array[i]) === false)) {
								return false;
							}
						}
					} else {
						for (i = 0; i < len; i++) {
							if ((fn.call(scope || array[i], array[i], i, array) === false) ||
								(this.each(fn, scope, reverse, array[i]) === false)) {
								return false;
							}
						}
					}
				}
				return true;
			};

			proto.getLinks = function(fieldName){
				let links = [];
				this.getRootNode().cascadeBy((node) => {
					if (node.id === "root") return;
					links.push(node.get(fieldName || 'LINK'));
				});	
				return links;
			};
			proto.getData = Ext.data.Store.prototype.getData;

			proto.getNodeBy = function (value, field) {
				if (!field) field = 'link';
				return this.findNode(field, value);
			};
			proto.clearFilter = function () {
				let me = this,
					owner = me.ownerTree,
					root = me.getRootNode();
				this.suspendEvents();
				root.cascadeBy((node) => {
					node.set('visible', true);
					node.match = null;
				});
				this.treeFilters = [];
				this.resumeEvents();
				let list = owner.ownerCt?.dict ?? owner.ownerCt?.ownerCt?.dict;
				if (list) {
					list.setSBText(list.dataCount, owner.getSelectionModel().getSelection().length, 
						list.checkList.length, false);
				}
				owner.store.fireEvent('filterchange');
				owner.view.features?.filter(f => f.ftype === 'summary')[0]?.doRefresh();
				owner.view.refresh();
			};
			proto.getTreeFilters = function () {
				if (!this.treeFilters) this.treeFilters = [];
				return this.treeFilters;
			};
			proto.removeFilter = function(filterID) {
				this.treeFilters = this.treeFilters.filter(f => f.property !== filterID);
				console.log(this.treeFilters);
				if (this.treeFilters.length)
					this.filter(this.treeFilters);
				else
					this.clearFilter();
			},
			//перегрузка метода фильтрации иерархического store
			//в отличие от native метода, при наложении отобразит всю иерархию до попадающего под фильтр нода
			//записи из иерархии, не попадающие под фильтр, будут помечены свойством match='ks-textgray' - требуется обработать в интерфейсе
			proto.filter = function (filters) {
				let me = this,
					grid = me.ownerTree,
					allNodesCount = 0,
					hiddenCount = 0,
					bl = grid.ownerCt?.dict ?? grid.ownerCt?.ownerCt?.dict,
					root = me.getRootNode(),
					compareFn = function (node) {
						let match = 0;
						Ext.each(treeFilters, function (filter) {
							let val = node.get(filter.property);
							if (!val) val = false;

							let strVal;
							try {
								strVal = val.toString();
							} catch (e) {
								return false;
							}

							let propVal = Ext.isDate(val) ? val.toLocaleDateString() : strVal.toLowerCase(),
								filterVal = filter.value?.toString().toLowerCase();

							if (filter.filterFn) {
								if (filter.filterFn(node, true)) match++;
							} else {
								if (propVal.indexOf(filterVal) !== -1) match++;
							}
						});
						return match === len;
					},
					filterCompound = function (node) {
						let hasValidChilds = false;
						for (let i = 0; i < node.childNodes.length; i++) {
							let valid = filterCompound(node.childNodes[i]);
							if (!valid) {
								node.childNodes[i].set('visible', false);
							}
							hasValidChilds |= valid;
						}
						let res = compareFn(node);
						if (hasValidChilds) {
							if (!res)
								node.match = 'ks-textgray';
							return true;
						} else {
							if (!res) {
								node.set('visible', false);
								hiddenCount++;
								return false;
							}
							return true;
						}
					}

				this.suspendEvents();

				let treeFilters = me.getTreeFilters();
				Ext.each(filters, function (filter) {
						let index = ArrayLib.find(treeFilters, ['property'], filter.property);
						if (index >= 0) treeFilters.splice(index, 1);

						if (Ext.isString(filter.value) && filter.value === '' ||
							Ext.isArray(filter.value) && !filter.value.length)
							return;

						treeFilters.push(filter);
					}	
				);
				let len = treeFilters.length;
				root.cascadeBy((node) => {
					node.set('visible', true);
					node.match = null;
					if (node.id !== "root") allNodesCount++;
				});
				if (len) {
					root.childNodes.forEach(node => {
						filterCompound(node);
					});
				}
				this.resumeEvents();

				let visibleCount = allNodesCount - hiddenCount;
				if (bl) {
					//сбросим выделение для строк, непопадающих под фильтр
					let selFiltered = bl.selectLinks.filter(rec => grid.store.getDataExt()
						.filter(r => r.LINK === rec.get('LINK')).length);
					if (selFiltered.length !== bl.selectLinks.length) {
						bl.selectLinks = selFiltered;
						if (bl.selectLinks.length)
							bl.Grid.getSelectionModel().select(bl.selectLinks);
						else
							bl.Grid.getSelectionModel().deselectAll();
					}

					bl.setSBText(bl.dataCount,
						grid.getSelectionModel().getSelection().length,
						bl.checkList.length, len ? visibleCount : false);
				}
				grid.store.visibleCount = visibleCount;
				root.expandChildren(true);
				grid.store.fireEvent('filterchange');
				grid.view.features?.filter(f => f.ftype === 'summary')[0]?.doRefresh();
				grid.view.refresh();
			};

			proto.getRecord = function (value, field) {
				return this.findNode(field || 'LINK', value);
			};
		}
	}

	if (Ext.Date) {
		Ext.Date.isEqualDh = function(d1, d2) {
			return Ext.Date.isEqual(d1.dh1, d2.dh1) && Ext.Date.isEqual(d1.dh2, d2.dh2);
		};
	}	

	if (Ext.container && Ext.container.Container) {
		proto = Ext.container.Container.prototype;
		var lookupComponent = proto.lookupComponent;

		proto.ksShortcuts = { '->': { xtype: 'fieldcontainer', flex: 1 } };
		proto.lookupComponent = function(comp) {
			var me = this;
			if (Ext.isArray(comp))
				comp = { xtype: 'fieldcontainer', layout: { type: 'hbox', align: 'stretch' }, items: comp };
			if (me.ksShortcuts[comp]) comp = me.ksShortcuts[comp];
			return lookupComponent.call(me, comp);
		};
	}

	if (Ext.toolbar?.Toolbar) {
		proto = Ext.toolbar.Toolbar.prototype;

		/**Восстановить тултипы на кнопках.
		 * По умолчанию если кнопка изначально задизейблена, extjs не устанавливает тултип не ней*/
		proto.restoreTooltips = function(){
			const me = this;
			me.items.items.forEach(item=>{
				Ext.get(item.el)?.set({title: item.tooltip});
			})
		};
	}

	if (Ext.window) {
		if (Ext.window.Window) {
			proto = Ext.window.Window.prototype;
			proto.constrain = true;
			
			var show = proto.show;
			proto.show = function() {
				var res = show.apply(this, arguments);
				this.on('move',
					function(th, x, y) {
						if (x < 0 || y < 0) {
							if (x < 0) x = 0;
							if (y < 0) y = 0;
							th.setXY([x, y]);
						}
					},
					{ buffer: 250 });
				return res;
			};
		}

		if (Ext.window.MessageBox) {
			proto = Ext.window.MessageBox.prototype;

			proto.INFO = 'x_btn_warning_blue32 ks-msg-icon';
			proto.WARNING = 'x_btn_warning32 ks-msg-icon';
			//proto.QUESTION = 'x_btn_question32 ks-msg-icon';
			proto.ERROR = 'x_btn_valid_error32 ks-msg-icon';

			Ext.MessageBox.promptContainer.add(Ext.MessageBox.checkQuestion = Ext.create('Ext.form.field.Checkbox',
				{
					padding: '0 5 0 0',
					boxLabel: 'Больше не спрашивать',
					hidden: true
				}));

			Ext.MessageBox.oldShow = Ext.MessageBox.show;

			proto.show = function(cfg) {
				var me = this,
					checkItem = me.checkQuestion;

				checkItem.setVisible(cfg.checkVisible);

				if (cfg.checkVisible && checkItem.boxLabelEl) {
					checkItem.setBoxLabel(cfg.checkboxLabel || 'Больше не спрашивать');
					checkItem.handler = cfg.checkHandler;
					checkItem.setValue(false);
				}

				return me.oldShow(cfg);
			};
		}
	}
});