﻿Ext.define('InputEditDict', {
	config: {
		lock: true,
		name: '',
		data: []
	},
	constructor: function(cfg) { this.initConfig(cfg); }
});
Ext.define('Keysystems.Base.Edit', {
	mixins: ['Keysystems.Base.Abstract'],
	objs: {},
	lstTitle: 'создание',
	fstTitle: '',
	dx: 10,
	dy: 10,
	GateCode: 'edit',
	profileKey: 'EditExtra',
	f: 'new', // 'new'/'copy'/'edit'/'readOnly'
	title: '',
	code: '',
	linkCode: 'Data',
	inputDicts: [],
	dictArr: [],
	labelWidth: 150,
	width: 700,
	bodyPadding: 10,
	saveChanges: true, //вызов функции подтверждения закрытия окна
	isFileBtn: false,
	fieldExt: 'TEMP_EXT',
	fieldFile: 'FILES',
	fieldName: 'NAME',
	fieldLink: 'LINK',
	readOnly: false,
	readOnlyList: [],
	viewMinSize: [720, 100],
	editIcon: 'x_btn_edit',
	keyEdit: 'edit',
	dictArrKeys: ['key', 'code', 'mode', 'tableName', 'whereField', 'ksAllowEmpty'],
	isCopy: function() { return this.f === 'copy'; },
	isVfa: false,
	onlyMainFile: false,
	hidePrintBtn: true,
	basePanelCls: 'rks-panel-edit',
	basePanelBodyCls: 'rks-panel-edit-body',
	tabMode: false,
	tabMappings:{
		'COMMON':'General'
	},	
	invalidControls: [],	//коллекция невалидных контролов
	warningMessages: [],	//предупреждающие сообщения для отображения в протоколе
	errorMessages: [],		//сообщения об ошибках для отображения в протоколе
	hideControlBtn: false, //скрывать кнопку Контроль
	ignoreCheckStamp: false,  //не проверять конкурирующие изменения
	needRemoveBusy: false,	  //данные редактирования тянутся с сервера

	constructor: function(cfg) {
		var me = this;
		Ext.apply(me, cfg);
		me.beforeInitComponent();
		me.fstTitle = me.title + ' - ';
		if (me.f === 'edit') {
			me.lstTitle = 'редактирование';
		}

		Log.sendLog(wmc.get('createForm', me.fstTitle + me.lstTitle, me.code, me.linkCode, me.GateCode));
		me.createListeners();
		me.createView();
		me.createEditToolbar();
		me.addViewEvents();
		me.doShow();
	},

	getReadOnly: function() { return this.readOnly || this.f === 'readOnly'; },

	addViewEvents: function() {
		let me = this,
			view = me.objs.view || me.getKsControl('view') || me;

		view.on('beforeclose', function() {
			if (me.saveChanges) {
				var newData = me.saveChangesFn();
				if (newData) {
					//Параметр указывающий что идёт закрытие формы
					newData.isClosed = true;
					me.changeMsgShow({
						yes: function () {
							me.checkFilled(res => {
								if (!res) return;
								me.saveData(function () {
									me.saveChanges = false;
									view.close();
								}, newData);
							});
						},
						no: function() {
							me.saveChanges = false;
							view.close();
						}
					});
					return false;
				}
			}
			return true;
		});

		view.on('close', function() {
			Log.sendLog(wmc.get('closeForm', me.fstTitle + me.lstTitle, me.code, me.linkCode, me.GateCode))			
			me.afterClose();
			me.onDestroy();
			me.cancel();
			if (me.checkStampIntervalId) clearInterval(me.checkStampIntervalId);
		});
		view.on(view instanceof Ext.window.Window ? 'show' : 'afterrender', me.loadData.bind(me));		
	},

	cancel: function() {
		let me = this,
			params = {};

		if (me.needRemoveBusy && me.ksData.link) {
			var paramsForCancel = me.getParamsForCancel();
			Ext.apply(params, paramsForCancel);
			//в случае, если к серверу уже выполнили запрос на получение данных, положим линк в отмененные, чтобы запись не пометилась как занятая после получения данных	
			if (me.ridGetExtra){
				params.addToCanceled = true;
			}
		}

		if (me.f !== 'edit' && me.ksData.link === 0 && me.ksData.hasOwnProperty('rollbackNumLink'))
		{
			params.code = me.code;
			params.rollbackNumLink = me.gksd('rollbackNumLink');
			params.rollbackNumVal = me.gksd('rollbackNumVal');
			params.rollbackMissed = me.gksd('rollbackMissed');
		}

		if (Object.keys(params).length) {
			ajaxRequest({
				url: me.linkCode + '/Cancel_A',
				params: {data: JSON.stringify(params)},
				success: function (result) {
					if (result.error) {
						showError(`Ошибка при выходе из формы: ${result.error}`);
					}
				}
			})
		}
	},

	// параметры для очищения записи из m_editLinks
	getParamsForCancel: function() {
		let me = this;

		return {link: me.ksData.link};
	},

	onDestroy: function() {

	},

	getViewTitle: function() {
		var me = this;
		return me.title + ' - ' + ((me.readOnly || me.f === 'readOnly') ? 'только просмотр' : (me.f === 'edit' ? 'редактирование' : 'создание'));
	},

	changeIconCls: function(view) {
		var me = this,
			icon = me.f === 'edit' ? me.editIcon : 'x_btn_new',
			v = view || me.gksc('view');

		v.setIconCls(icon);
	},

	getViewIconCls: function() {
		var me = this;
		return me.f === 'new' ? 'x_btn_new' : me.editIcon;
	},

	/**
	 * Конфиг окна редактирования. 
	 * Применяется в зависимости от настройки "Модальные окна ред-ия" в Ext.window.Window (ДА) либо Ext.panel.Panel (НЕТ)
	 * @returns {{code: string, link: number, owner: Keysystems.Base.Edit}}
	 * */
	viewCfg: function() {
		var me = this,
			objs = me.objs;

		var w = me.viewMinSize[0],
			h = me.viewMinSize[1];

		if (w > 1024) w = 1024; //соглашение о минимальных размерах
		if (h > 768) h = 768;
		
		//минимальная высота панели с элементами - высота окна минус (высота заголовка окна + высота тулбара)
		//необходимо задавать, чтобы при отображении панели не валидных контролов на основной панели появлялась прокрутка
		const cfgCommonPanel = {
			minHeight: h - 55,
			items: me.createItems(),
		};
		objs.viewCfg = {
			modal: true,
			minButtonWidth: 23,
			defaultFocus: 'CODE',
			title: me.getViewTitle(),
			iconCls: me.getViewIconCls(),
			border: 0,
			layout: { type: 'vbox', align: 'stretch' },
			resizable: false,
			items: me.createCommonPanel(cfgCommonPanel),
			width: w,
			minWidth: w,
			minHeight: h,
			buttons: me.createBtns(),
			listeners: objs.listeners,
			constrain: true,
			scrollable: true,
			code: me.code,
			link: me.data?.data?.LINK ?? 0,
			owner: me
		};
		return objs.viewCfg;
	},
	createBtns: Ext.emptyFn,
	createView: function() {
		var me = this;

		me.viewCfg();
		me.setInputDict();
		if (me.tabMode) {
			me.objs.viewCfg.border = 0;
			me.objs.viewCfg.closable = true;
			me.objs.view = Ext.create('Ext.panel.Panel', me.objs.viewCfg);
		}
		else {
			me.objs.view = Ext.create('Ext.window.Window', me.objs.viewCfg);
		}
	},

	createItems: function(items) {
		var me = this,
			result = [];

		if (me.isCodeEdit) result.push(me.createCodeEdit(me.codeEditCfg));
		if (me.isNameEdit) result.push(me.createNameEdit(me.nameEditCfg));
		if (me.isSNameEdit) result.push(me.createSNameEdit(me.snameEditCfg));

		Ext.each(me.dictArr, function(d) {
			result.push(me.createDictEdit({
				key: d.key,
				ksAllowEmpty: d.ksAllowEmpty,
				whereArgs: d.whereArgs,
				code: d.code,
				fieldLabel: d.fieldLabel,
				mode: d.mode.toUpperCase()
			}));
		});

		if (items) {
			if (Ext.isFunction(items)) {
				result = result.concat(items());
			} else {
				if (Ext.isArray(items)) {
					result = result.concat(items);
				} else {
					result.push(items);
				}
			}
		}

		if (me.isDHEdit) result.push(me.createDHEdit(me.dhEditCfg));
		if (me.isParentEdit) result.push(me.createParentEdit(me.parentEditCfg));

		return me.objs.items = result;
	},
	/** Создать основную панель, на которой размещаются все элементы окна редактирования и структуру тулбара 
	 * Панель является контейнером для отображения лоадера
	 * @returns {Ext.panel.Panel}
	 * */
	createCommonPanel: function(cfg) {
		//todo если тулбар лежит на editHostPanel, то dock тулбара не работает в случае маленьких размеров окна, 
		//по идее нужна еще одна панель, на которой лежат dock-тулбар и scroll-панель
		const me = this;
		me.createTBar();
		let defCfg = {
			flex: 1,
			//todo в некоторых браузерах всегда показывается скролл у этой панели. уберу пока, на самой вьюхе вообщем-то тоже есть скролл
			//scrollable: true,
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: me.bodyPadding,
			userCls: 'rks-panel-edit',
			split: true
		};
		if (cfg) Ext.apply(defCfg, cfg);
		return me.editHostPanel = Ext.create('Ext.panel.Panel', defCfg);
	},
	createListeners: function() { this.objs.listeners = {}; },
	createTBar: function() {
		var me = this,
			objs = me.objs,
			res = objs.tbar = [
				me.sksc('saveBtn', objs.saveBtn = Ext.create('Ext.Button', {
					tooltip: 'Сохранить',
					tooltipType: 'title',
					iconCls: 'x_btn_save',
					//disabled: me.getReadOnly(),
					handler: function() {
						me.checkFilled(res => {
							if (!res) return;
							me.saveData();
						});
					}
				})),
				me.sksc('controlBtn', objs.controlBtn = Ext.create('Ext.Button', {
					tooltip: 'Проверить',
					tooltipType: 'title',
					iconCls: 'x_btn_control',
					hidden: me.hideControlBtn,
					handler: function() {
						me.checkFilled(res => {
							if (!res) return;
							me.checkData();
						});
					}
				})),
				me.sksc('printBtn', objs.printBtn = Ext.create('Ext.button.Split', {
					tooltip: 'Печать',
					tooltipType: 'title',
					iconCls: 'x_btn_print',
					hidden: me.hidePrintBtn,
					handler: function() {
						let th = this,
							menu = th.getMenu(),
							items = [];

						if (menu && menu.items.items.length) {
							items = menu.items.items;
						} else {
							return;
						}

						if (th.defReport) {
							me.openReport(items.filter(i => { return i.link === th.defReport})[0]);
						} else {
							th.defReport = items[0].link;
							me.openReport(items[0]);
						}
					}
				})),
				me.sksc('exitBtn', objs.exitBtn = Ext.create('Ext.Button', {
					tooltip: 'Выйти',
					tooltipType: 'title',
					iconCls: 'x_btn_exit',
					handler: function() {
						if (me.ksControls) var view = me.getKsControl('view');
						(view || objs.view).close();
					}
				}))
			];
		if (me.isFileBtn) {
			res.push('-', objs.btnFile = me.sksc('btnFile', Ext.create('Ext.Button', {
				text: me.fileBtnTitle || 'Файл',
				width: 75,
				handler: function() { me.fileEdit(me.data); },
				listeners: {
					afterrender: function(th) {
						UploaderLib.bind(th.el.dom, function(link, ext, callback) {
							me.updFileRecord({ id: link, ext: ext });
							callback();
						});
					}
				},
				setKsReadOnly: function(v) {
					//кнопку с файлом дизейблим в случае, если нет файла. если файл есть, то работаем с readOnly
					if (!this.iconCls){
						this.setDisabled(v);
					}
					this.readOnly = v;
				}
			})));
		}
		return res;
	},
	getHistTable: function() {
		var objs = this.objs,
			table = [];
		(objs.History_Grid || objs.gridHistory).store.each(function(rec) {
			table.push({
				LINK: rec.get('LINK'),
				DH1: rec.get('DH1').toDateString(),
				DH2: rec.get('DH2').toDateString()
			});
		});
		return table;
	},

	saveChangesFn: function() {
		var me = this,
			newData = me.dataCollector();
		//условие для новых и копируемых записей добавлено по аналогии с вином
		return (me.saveChanges && (me.oldData !== JSON.stringify(newData) || ['new', 'copy'].indexOf(me.f) >= 0 || me.forceHasChanges)) ? newData : _;
	},

	//сообщение о наличии несохраненных данных
	changeMsgShow: function(cfg) {
		Ext.Msg.show({
			title: KS.L10n.attention,
			msg: wmc.get('SaveChanges'),
			buttons: Ext.MessageBox.YESNOCANCEL,
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.QUESTION
		});
	},

	/**
	 * Контроль заполнения полей с обработкой результата
	 * Вызывает перегруженные в наследниках isFilled() и асинхронный isFilledAsync(), где необходимо заполнить invalidControls, warningMessage и errorMessages	
	 * @returns {boolean}  
	 * Если есть незаполненные - отобразит панель с перечнем контролов
	 * Иначе если есть предупреждающие сообщения или сообщения об ошибках  - отобразит протокол с ними
	 * При успешном прохождении контролей - вызовет callback
	 */
	checkFilled: async function(callback) {
		const me = this;
		me.invalidControls = [];
		me.warningMessages = [];
		me.errorMessages = [];
		let res = me.isFilled();
		res &= await me.isFilledAsync();
		
		if (!res && me.invalidControls.filter(ic => !ic.optional).length) {		
			me.showInvalidControls();
			me.setStatus(KS.L10n.do_check_empty_fields);
			callback(false);
			return;
		} 
		me.hideInvalidControls();
		me.hideStatus();
		
		//в случае, если клиентский контроль не пройден либо нет серверного контроля - формируем и показываем протокол сразу
		//иначе протокол формируем после прохождения серверного контроля с учетом ранее полученных клиентских warningMessages и errorMessages 
		if (!res || !me.needRemoveBusy) {
			const params = {};
			if (me.warningMessages.length) params.warningMessages = JSON.stringify(me.warningMessages);
			if (me.errorMessages.length) params.errorMessages = JSON.stringify(me.errorMessages);

			if (Object.keys(params).length) {
				me.showLoadMask({
					msg: "Формирование протокола...",
					target: me.getLoadMaskTarget(),
					rid: ajaxRequest({
						url: 'Data/GetProtocol_A',
						params: {gzipData: SignalR.pack(params)},
						success: function (result) {
							me.hideLoadMask();
							me.parseCheckSaveResult(result, function () {
								me.warningMessages = [];
								me.errorMessages = [];
								callback(true);
							});
						},
						failure: function () {
							me.hideLoadMask();
						}
					})
				});
				return;
			}	
		}
		callback(res);
	},

	checkFilledAsync: async function(){
		const me = this;
		return new Ext.Promise(function (resolve) {
			me.checkFilled((res) => {
				resolve(res);
			});
		});
	},
	
	/** 
	 * Базовая реализация контроля заполнения полей
	 * Контроль полей КОД и НАИМЕНОВАНИЕ из ksControls или objs	 
	 * Контроль полей с флагом ksAllowEmpty из dictArr
	 * Контроль полей с флагом ksAllowEmpty из ksControls
	 * */
	isFilled() { 
		var me = this,
			ksControls = me.ksControls,
			res = true;

		Ext.each(['CODE', 'NAME'], function(k) {
			var c = me.gksc(k) || objs[k];
			if (c && !c.isHidden() && c.ksAllowEmpty && !c.getValue()) {
				me.addToInvalidControls(c);
				res = false;
			}
		});

		Ext.each(me.dictArr, function(d) {
			var c = me.gksc(d.key);
			if (!c.isHidden() && c.ksAllowEmpty && c.isEmpty()) {
				me.addToInvalidControls(c);
				res = false;
			}
		});

		for(const key in ksControls){
			if (key === 'CODE' || key === 'NAME' || me.dictArr.filter(d=>d.key === key).length)
				continue;
			const c = ksControls[key];
			if (c && c.ksAllowEmpty && !c.isHidden() && !c.getValue()){
				me.addToInvalidControls(c);
				res = false;
			}
		}

		
		return res;
	},
	/**
	 * Базовая реализация асинхронного контроля заполнения полей
	 */
	async isFilledAsync() { 
		return true;
	},
	doShow: function() {
		const me = this,
			view = me.getKsControl('view', true);

		if (view) {
			view.code = me.code;
			if (me.tabMode) {
				const tab = me.parentView.add(view);
				if (tab && me.parentView.setActiveTab) me.parentView.setActiveTab(tab);
			}
			view.show(me.parentView, function () {
				Log.sendLog(wmc.get('showForm', me.fstTitle + me.lstTitle, me.code, me.linkCode, me.GateCode));
				window.adaptDialogSize(view, me.viewMinSize);
				me.afterShow();
			})
		} else
			me.show();

	},
	afterGetExtra: function() {
		var me = this,
			view = me.getKsControl('view', true);

		me.isLoaded = false;
		if (me.ownerCt) me.ownerCt.isLoaded = false;
		
		me.oldData = JSON.stringify(me.dataCollector());
		
		if (me.gksd('oldData')) me.sksd('oldData', null);
		if (me.gksd('newData')) me.sksd('newData', null);

		me.updateProfileListeners();
		window.adaptDialogSize(view, me.viewMinSize);
		if (me.getReadOnly()) me.setReadOnly(true, me.gksd('readOnlyReason'));
		
		me.hideLoadMask();

		if (window.checkStampInterval && !me.ignoreCheckStamp && me.needRemoveBusy) {
			setTimeout(()=> me.checkStamp(), 2000);
			me.checkStampIntervalId = setInterval(()=> me.checkStamp(), window.checkStampInterval * 1000);
			if (me.ownerCt) me.ownerCt.checkStampIntervalId = me.checkStampIntervalId;
		}

		KsDictBadLib.wait(0);
	},
	
	/** Текущее окно 
	 * @returns {Ext.window.Window} */	
	getWindow: function(){
		return this.getKsControl('view', true) ?? this.objs.view ?? this;
	},
	getLoadMaskTarget: function () {
		const me = this;
		//попробуем блокировать view. если блокировать только editHostPanel, то надо еще и дизейблить тулбар
		//if (me.editHostPanel) return me.editHostPanel;

		const view = me.gksc('view', true, true) ?? me.objs.view ?? me;

		//в случае, если модальное окно - берем первого наследника-панель. если открыто в табе, то view и есть панель 
		return view instanceof Ext.window.Window
			? view.items.items.filter(item => item instanceof Ext.panel.Panel)[0]
			: view;
	},
	
	loadData: function() {
		const me = this;

		/** Признак, что форма в процессе загрузки */
		me.isLoaded = true;
		if (me.ownerCt) me.ownerCt.isLoaded = true;
		KsDictBadLib.wait(1);

		const cfg = me.initLoadingMaskCfg();
		me.showLoadMask(cfg);

		if (me.f !== 'new') {
			me.loadCopyEditData();
			me.getExtra(me.afterGetExtra.bind(me), me.getLink());
		} else {
			me.loadNewData();
			me.getExtraNew(function () {
				if (me.data) {
					var data = me.data.data;
					me.sksd('LINK_SELF', data.LINK);
					me.isParentEdit && me.objs.PARENT.setValue({LINK: data.LINK, CODE: data.CODE, NAME: data.NAME});
				}
				me.afterGetExtra();
			});
		}

		if (['edit', 'readOnly'].indexOf(me.f) === -1) me.loadNewCopyData();
	},

	initLoadingMaskCfg: function() {
		const me = this,
			cfg = {
				msg: KS.L10n.loading_data,
				target: me.getLoadMaskTarget(),
				iconCt: me.tabMode ? (me.gksc('view') ?? me.objs.view ?? me) : null,
				opaque: true,
				cancelFn: function () {
					me.isExit = true;
					//удалим запись из отмененных, для случая, когда uc.Edit выполняется после uc.Cancel
					//в случае, если к серверу уже выполнили запрос на получение данных, при получении ответа с сервера уберем запись из отмененных
					if (me.ridGetExtra && SignalR.callBackStorage[me.ridGetExtra] && me.needRemoveBusy && me.ksData?.link) {
						let params = {};
						Ext.apply(params, me.getParamsForCancel());
						params.removeFromCanceled = true;

						SignalR.callBackStorage[me.ridGetExtra].callback = () => {
							ajaxRequest({
								url: me.linkCode + '/Cancel_A',
								params: {data: JSON.stringify(params)}
							});
						}
					}
					me.afterCancelLoad();
				}
			}
		return cfg;
	},
	loadCopyEditData: function() {
		var me = this,
			data = me.data.data;

		me.setLink(data.LINK);
		me.autoFillControl(data);
	},
	autoFillControl: function(data) {
		var me = this;
		if (me.isCodeEdit) me.setCodeValue(data.CODE);
		if (me.isNameEdit) (me.gksc('NAME') || me.objs.NAME).setValue(data.NAME);
		if (me.isSNameEdit) (me.gksc('SNAME') || me.objs.SNAME).setValue(data.SNAME);
		if (me.isDHEdit) (me.gksc('DH') || me.objs.DH).setValue(data.DH1, data.DH2);
		if (data.LINK_SELF) me.sksd('LINK_SELF', data.LINK_SELF);
		//if (me.isFileBtn) {}
	},
	loadNewData: function() {
		var me = this;
		this.setLink(0);
		if (me.data && me.data.data)
			this.setLinkSelf(me.data.data.LINK);
	},
	loadNewCopyData: function() { this.setLink(0); },
	getExtra: function(callBack, link) {
		var me = this;
		me.baseGetExtra(me.getExtraParams(link),
			function(v) {
				me.autoFillControl(v.row);
				Ext.each(me.dictArr, function(d) { me.gksc(d.key).setValue(v[d.key]); });
				KsLib.tryRun(callBack);
			});
	},
	getExtraNew: function (callBack) { this.getExtra(callBack, 0); },
	getExtraParams: function(link) {
		let me = this;
		if (link === _) link = me.data ? (me.data.data || me.data).LINK : 0;		
		return { link: link, dictList: JSON.stringify(ArrayLib.copyListByKeys(me.dictArrKeys, me.dictArr, [])) };
	},
	getSaveUrl: function() { return this.linkCode + '/Save_A'; },

	/**
	 * Проверка данных на сервере. Вызовет CheckSave модели.
	 * @param inputParams
	 * @returns {void} Отобразит протокол с результатами проверки.
	 */
	checkData: function(inputParams) {
		const me = this;
		if (me.needRemoveBusy) {
			let params = inputParams || me.dataCollector(); 
			params.checkSaveOptions = 1 | 4 | 8;
			params.checkSaveOnly = true;
			me.baseSaveData(params, (result)=>{
				if (result) result.hasIgnoreButton = false; 
				me.parseCheckSaveResult(result);
			});
		} else {
			const csr = {State: 0, Message: 'Контроль пройден успешно'};
			me.parseCheckSaveResult(csr);
		}
	},
	/**
	 * Базовый механизм отправки данных на сохранение
	 * @param params
	 * @param params.processCheckSave {boolean} - до сохранения выполнять CheckSave (true или null) или нет (false)
	 * @param params.checkSaveOnly {boolean} - выполнять только CheckSave
	 * @param endFunc
	 */
	baseSaveData: function(params, endFunc) {
		const me = this;

		params.dictList = JSON.stringify(ArrayLib.copyListByKeys(me.dictArrKeys, me.dictArr, []));
		if (!params.stamp) params.STAMP = me.gksd('STAMP') ?? "";
		if (params.forceAdd == null && me.gksd('forceAdd')) params.forceAdd = true;
		if (params.processCheckSave == null) params.processCheckSave = true;
		if (params.processCheckSave || params.checkSaveOnly){
			if (me.warningMessages.length) params.checkSaveClientWarnings = JSON.stringify(me.warningMessages);
			if (me.errorMessages.length) params.checkSaveClientErrors = JSON.stringify(me.errorMessages);
		}
		
		me.showLoadMask({
			msg: params.processCheckSave === false ? KS.L10n.saving : `${KS.L10n.Проверка_данных}...`,
			target: me.getLoadMaskTarget(),
			rid: ajaxRequest({
				url: me.getSaveUrl(),
				params: { gzipData: SignalR.pack(params) },
				success: function(result) {
					me.hideLoadMask();
					if (params.checkSaveOnly){
						if (endFunc) endFunc(result.CheckSaveResult);
						return;
					}
					me.successSaveFunc(result, endFunc, params);
				},
				failure: function(val) {
					me.hideLoadMask();
					if (endFunc) endFunc(val);

					QuickMsgs.notSave();
					Log.sendLog(wmc.get('SavingError'));
					failureShow(val, wmc.get('SavingError'));
				},
				progress: function (response) {
					me.loadMask.setMsg(response);
				}
			})
		});
	},
	baseGetExtra: function(params, endFunc, url) {
		var me = this;
		if (me.isExit) return;
		if (!params) params = {};
		if (!params.link === _) params.link = params.LINK = me.getLink();		
		if (!params.linkSelf) params.linkSelf = me.getLinkSelf();
		if (!params.copy) params.copy = me.isCopy();
		if (!params.isVfa) params.isVfa = me.isVfa;
		if (!params.whereArgs && me.whereArgs) params.whereArgs = JSON.stringify(me.whereArgs);
		if (me.gksd('oldData')) params.oldData = me.gksd('oldData');
		if (me.gksd('newData')) params.newData = me.gksd('newData');
		
		if (window.cachedResources["EDIT_" + me.code])
			delete params.needResource;
		else
			params.needResource = true;

		me.needRemoveBusy = true;

		me.ridGetExtra = ajaxRequest({
			url: url || (me.linkCode + '/GetSExtra_A'),
			params: { gzipData: SignalR.pack(params) },
			callback: function(val) {
				//исправление плавающих ошибок
				if (val === true) return;
				if (!val || !val.value) {
					me.loadMask.setErrorState();
					return;
				}

				if (val.value.ErrorMsg) {
					me.loadMask.setErrorState(val.value.ErrorMsg);
					return;
				}

				delete me.ridGetExtra;
				if (me.ownerCt) delete me.ownerCt?.ridGetExtra;

				if (val.value.resource) {
					window.cachedResources["EDIT_" + me.code] = true;
					Ext.apply(KS.L10n, val.value.resource);
				}

				if (val.value.rollBackData) {
					me.sksd('rollbackNumLink', val.value.rollBackData.rollbackNumLink);
					me.sksd('rollbackNumVal', val.value.rollBackData.rollbackNumVal);
					me.sksd('rollbackMissed', val.value.rollBackData.rollbackMissed);
				}

				if (val.value.readOnly) {
					me.readOnly = true;
					me.sksd('readOnlyReason', val.value.readOnlyReason);
					if (val.value.readOnlyReasonExt) me.sksd('readOnlyReasonExt', val.value.readOnlyReasonExt);
				}

				if (val.EditProfile !== _) {
					//console.log('Загрузка профиля окна редактирования (Начало)');
					for(let key in val.EditProfile){
						//console.log(key);
						if (key === "EditExtra")
							me.loadProfile(val.EditProfile.EditExtra);
						else
							LocalStorage.set(key, val.EditProfile[key], true);
					}
					val = val.value;
					//console.log('Загрузка профиля окна редактирования (Конец)');
				}

				me.sksd('STAMP', val.row?.STAMP ? val.row.STAMP : val.STAMP);
				
				//Иногда в getExtra падает ошибка. надо её ловить
				try {
					endFunc(val);
				} catch (e) {
					console.error(e);
					window.failureShow({statusText: e.stack}, "Внимание");
					me.hideLoadMask();
				}


			}
		});
	},	
	//Собиралка всех данных с формы
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = { link: me.getLink(), LINK_SELF: me.gksd('LINK_SELF') || 0, STAMP: me.gksd('STAMP') };

		if (me.isCodeEdit) data.code = data.CODE = (me.gksc('CODE') || objs.CODE).getValue();
		if (me.isNameEdit) data.name = data.NAME = (me.gksc('NAME') || objs.NAME).getValue();
		if (me.isSNameEdit) data.sname = data.SNAME = (me.gksc('SNAME') || objs.SNAME).getValue();

		Ext.each(me.dictArr, function(d) {
			var c = me.gksc(d.key);
			if (!c.isHidden()) data[d.key] = d.mode.toUpperCase() === 'MULTI' ? c.getLinks(1) : c.getLink();
		});

		if (me.isDHEdit) {
			var dh = (me.gksc('DH') || objs.DH).getValue();
			data.dh1 = data.DH1 = dh.dh1.toDateString();
			data.dh2 = data.DH2 = dh.dh2.toDateString();
		}

		if (me.isParentEdit) data.linkSelf = data.LINK_SELF = (me.gksc('PARENT') || objs.PARENT).getLink();
		data.isVfa = me.isVfa;

		return data;
	},

	saveData: function(endFunc, inputParams) {
		var me = this;
		me.baseSaveData(inputParams || me.dataCollector(), endFunc);
	},

	updRecord: function(row) {
		var me = this;
		if (row) {
			if (me.getLink() && me.data) {
				me.setRecord(row, me);
			} else {
				me.data = me.addRecord(row);
			}
		}

		me.selectRecord(me.data);
	},

	//by override
	addRecord: Ext.nullFn,

	//by override
	setRecord: Ext.emptyFn,

	//by override
	selectRecord: Ext.emptyFn,

	//by override
	afterShow: Ext.emptyFn,

	//by override
	afterClose: Ext.emptyFn,

	successSaveFunc: function(result, endFunc, params) {
		var me = this,
			res = result.result;

		if (result.CheckSaveResult) {
			me.parseCheckSaveResult(result.CheckSaveResult, function (checkSaveResult) {
				params = me.dataCollector();
				params.processCheckSave = false;
				params.checkSaveResult = checkSaveResult;
				me.saveData(endFunc, params);
			})
			return;
		}

		if (res) {
			var view = me.objs.view || me.gksc('view');

			me.f = 'edit';

			if (view) {
				me.title = view.title = view.title.split(' - ')[0];
				if (view.rendered) {
					view.setTitle(me.getViewTitle());
					me.changeIconCls(view);
				}
			}

			me.updRecord(result.row);
			me.setLink(result.SavedLink);
			if (result.SavedStamp) {
				me.sksd('STAMP', result.SavedStamp);
				//если запись открыта в других окнах, выведем сообщение о неактуальности
				if (me.tabMode && result.SavedLink){
					let sameTabs = window.tabView.items.items.filter(tab => tab.code === me.code && tab.link === result.SavedLink);
					sameTabs.forEach(tab=>{
						if (!tab.owner || !tab.owner.checkStamp || tab.owner === me) return;
						tab.owner.checkStamp();
					})
				}
				
			}
			me.oldData = JSON.stringify(me.dataCollector());
			delete me.forceHasChanges;

			if (me.data)
				me.data.data.LINK = result.SavedLink;

			Log.sendLog(wmc.get('SavingSuccess'));
			QuickMsgs.save();

			if (endFunc) endFunc(result);
		} else {
			if (result.ErrorMsg) {
				showError(result.ErrorMsg);
			}
			Log.sendLog(wmc.get('SavingError'));
			QuickMsgs.notSave();
		}
	},

	/**
	 * Обработать результата контроля сохранения.
	 * Протокол отображаем всегда 
	 * Чузбокс по проверки [checkSaveResult.CheckCodeResults] кодов отображаем только при отсутствии конкурирующих изменения и (при отсутствии протокола либо при наличии неблокирующего протокола после выбора варианта "Продолжить") 
	 * Порядок отображения: 
	 * 1) протокол, затем запросы проверки кодов (если есть)
	 * 2) протокол, проверка актуальности
	 * В случае, если есть текст протокола - отображаем как протокол (если State != 0, контроль не пройден) либо как модалку (State == 0, контроль пройден)
	 * @param checkSaveResult
	 * @param checkSaveResult.CheckCodeResults
	 * @param callback
	 */
	parseCheckSaveResult: function(checkSaveResult, callback){
		const me = this;
		const funcCheckCodes = function(){
			if (checkSaveResult.CheckCodeResults && checkSaveResult.CheckCodeResults.length){
				ChooseBox.ShowCheckCodeMessage(checkSaveResult.CheckCodeResults[0], (checkCodeResult)=>{
					if (checkCodeResult.Action === 7) //отмена 
						return;
					checkSaveResult.CheckCodeResults = [checkCodeResult];
					if (callback) callback(checkSaveResult);
				})
			}
			else
			if (callback) callback(checkSaveResult);
		}		
		const funcCheckStamp = function(){
			if (checkSaveResult.CheckStampResults && checkSaveResult.CheckStampResults.length) {
				const csr = checkSaveResult.CheckStampResults[0];
				//если запись изменена другим пользователем (RestoreAction.Заменить) отображаем сообщение в строке статуса, чтобы была возможно просмотреть смерженные данные 
				if (csr.Info.Actions.indexOf(3) >= 0) {
					me.setStatusStamp(csr.Info.Text, me.getButtonsForStatusStamp());
				}
				else {
					ChooseBox.ShowCheckStampMessage(checkSaveResult.CheckStampResults[0], (checkStampResult) => {
						if (checkStampResult.Action === 9) //отмена 
							return;
						checkSaveResult.CheckStampResults = [];//[checkStampResult]
						if (checkStampResult.Action === 1)
							me.sksd('forceAdd', true);
						if (callback) callback(checkSaveResult);
					})
				}
			}
			else
				funcCheckCodes();
		}

		if (checkSaveResult) {
			if (checkSaveResult.Message) {
				const hasIgnoreButton = checkSaveResult.hasIgnoreButton != null ? checkSaveResult.hasIgnoreButton : checkSaveResult.State === 1;
				const cfg = {
					text: checkSaveResult.Message,
					title: 'Протокол контроля',
					hasIgnoreButton: hasIgnoreButton,
					noPreStyle: true,
					nextFn: function () {
						funcCheckStamp(checkSaveResult);
					}
				};
				if (checkSaveResult.State === 0){
					cfg.icon = Ext.MessageBox.INFO;
					ChooseBox.ShowHTML(cfg);
				}
				else
					ChooseBox.ShowHTMLLog(cfg);
			}
			else {
				funcCheckStamp(checkSaveResult);
			}
		}
		else
			callback(checkSaveResult);
	},
	setInputDict: function() {
		var me = this;
		if (!me.inputDicts) return;
		for (var i = 0, len = me.inputDicts.length; i < len; i++) {
			var dict = me.inputDicts[i];
			if (dict && me.objs[dict._name]) {
				me.objs[dict._name].setValue(dict._data);
				me.objs[dict._name].setLock(dict._lock);
			}
		}
	},
	show: function() {
		var me = this,
			view = me.objs.view;
		if (me.isExit) return;

		if (me.tabMode) {
			view.code = me.code;
			const tab = me.parentView.add(view);
			if (tab && me.parentView.setActiveTab) me.parentView.setActiveTab(tab);
		}

		view.show(me.parentView, function() {
			Log.sendLog(wmc.get('showForm', me.fstTitle + me.lstTitle, me.code, me.linkCode, me.GateCode));

			if (view.getX() < 0) view.setX(0);
			if (view.getY() < 0) view.setY(0);

			window.adaptDialogSize(view, me.viewMinSize);
			me.afterShow();
		});


	},

	createCodeEdit: function(cfg) {
		var me = this,
			o = {
				labelWidth: me.labelWidth,
				fieldLabel: 'Код',
				ksAllowEmpty: true,
				maxLength: 20,
				maxWidth: 300
			};
		Ext.apply(o, cfg);

		var res = me.sksc('CODE', me.objs.CODE = Ext.create(o.className || 'Ext.form.field.Text', o));

		res.on('blur', function() {
			if (!me.gksd('IgnoreNewAutoNumber') && ['edit', 'readOnly'].indexOf(me.f) === -1) {
				var v = this.getValue();
				if (v !== me.gksd('ORIGIN_CODE')) me.checkAutoNumer(v);
			}
		});

		return res;
	},

	setCodeValue: function(v) {
		var me = this;
		me.sksd('ORIGIN_CODE', v);
		return (me.gksc('CODE') || me.objs.CODE).setValue(v);
	},

	getCodeValue: function() {
		var me = this;
		return (me.gksc('CODE') || me.objs.CODE).getValue();
	},

	checkAutoNumer: function(v) {
		var me = this;

		ajaxRequest({
			url: me.linkCode + '/CheckAutoNumer_A',
			params: { strNumber: v },
			success: function(res) {
				if (res && v === me.getCodeValue()) {
					selectDialogShow(KS.L10n.attention, wmc.get('SaveNewAutoNumber', v), function() {
						ajaxRequest({ url: me.linkCode + '/SaveNewAutoNumber_A', params: { strNumber: v } });
					}, function() {
						me.sksd('IgnoreNewAutoNumber', true);
					});
				}
			}
		});
	},

	createNameEdit: function(cfg) {
		var me = this,
			o = {
				fieldLabel: 'Наименование',
				labelWidth: me.labelWidth,
				ksAllowEmpty: true,				
				maxLength: 500				
			};
		Ext.apply(o, cfg);
		return me.sksc('NAME', me.objs.NAME = Ext.create(o.className || 'Ext.form.field.Text', o));
	},

	createSNameEdit: function(cfg) {
		var me = this,
			o = {
				fieldLabel: 'Краткое наименование',
				emptyText: 'Введите Краткое Наименование',
				labelWidth: me.labelWidth
			};
		Ext.apply(o, cfg);
		me.readOnlyList.push('SNAME');
		return me.sksc('SNAME', me.objs.SNAME = Ext.create(o.className || 'Ext.form.field.Text', o));
	},

	createDHEdit: function(cfg) {
		var me = this,
			o = {
				labelWidth: me.labelWidth,
				maxWidth: 450,
				isSwap: true
			};
		Ext.apply(o, cfg);
		me.readOnlyList.push('DH');
		return me.sksc('DH', me.objs.DH = Ext.create(o.className || 'Keysystems.Controls.PeriodEdit', o));
	},

	createParentEdit: function(cfg) {
		var me = this,
			objs = me.objs,
			o = {
				labelWidth: this.labelWidth,
				fieldLabel: 'Родительский "' + me.title + '"',
				width: me.width,
				handler: function() {
					var notLinks = [];
					if (me.data) {
						var fn = function(node) {
							notLinks.push(node.data.LINK);
							node.eachChild(function(rec) { fn(rec); });
						};
						fn(me.data);
					} else {
						notLinks.push(me.getLink());
					}
					dictFunc({
						mode: 'SINGL',
						parentView: objs.view,
						selectLinks: objs.PARENT.getValue(),
						readOnly: objs.PARENT.ksReadOnly,
						whereArgs: { NotInLinks: { value: JSON.stringify(notLinks), type: 'List_int' } },
						code: me.code,
						control: objs.PARENT,
						contextSearch: objs.PARENT.contextSearch
					}, { ok: function(value) { objs.PARENT.setValue(value); } });
				}
			};
		Ext.apply(o, cfg);
		me.readOnlyList.push('PARENT');
		return me.sksc('PARENT', objs.PARENT = Ext.create('Keysystems.Controls.Dict.Edit', o));
	},

	getTabKey: function(type) { return 'tab' + type; },

	getTab: function(type) {
		var me = this,
			key = me.getTabKey(type);

		//если таб создан ранее, то возвращаем его
		if ((me.ksControls || me.objs)[key]) return (me.ksControls || me.objs)[key];

		//иначе создаем новый таб
		var fn = me['createTab' + type];

		//если есть конструктор, то запускаем его
		if (fn) {
			var res = (me.ksControls || me.objs)[key] = fn.call(me);
			me.updateProfileListeners();
			return res;
		}

		return null;
	},

	setTabVisible: function(type, visible) {
		var me = this,
			objs = me.ksControls || me.objs;

		if (visible) {
			if (objs.allTab) {
				objs.allTab.changeTab(me.getTab(type), true);
			} else {
				me.getTab(type).show();
			}
		} else {
			var tab = objs[me.getTabKey(type)];
			if (tab) {
				if (objs.allTab) {
					objs.allTab.changeTab(tab, false);
				} else {
					tab.hide();
				}
			}
		}
	},

	getTabVisible: function(type) {
		var me = this,
			objs = me.objs,
			tabKey = me.getTabKey(type),
			tab = me.gksc(tabKey)||objs[tabKey];

		if (tab) {
			var allTab = me.gksc('allTab') || objs.allTab;
			if (allTab) {
				return allTab.items.items.indexOf(tab) !== -1;
			} else {
				return !tab.isHidden();
			}
		}
		return false;
	},

	_setDh: function(cmp, d1, d2) {
		d1 = d1 ? new Date(d1) : longPeriod.begin;
		d2 = d2 ? new Date(d2) : longPeriod.end;

		/*if (Ext.Date.isEqual(longPeriod.begin, d1)) d1 = null;
		if (Ext.Date.isEqual(longPeriod.end, d2)) d2 = null;*/

		cmp.dh1.setValue(d1);
		cmp.dh2.setValue(d2);
	},

	getTabAccess: function(tabs, key, link) {
		return tabs[key]
			? tabs[key][1][link] ? ObjAccessMask.BAN : tabs[key][0]
			: ObjAccessMask.ALL;
	},

	isTabReadOnly: function(tabs, key) {
		return (this.getTabAccess(tabs, key) & ObjAccessMask.EDIT) === 0;
	},

	setObjsValues: function(values, keys) {
		var me = this,
			objs = me.objs;
		Ext.each(keys, function(key) {
			var c = me.gksc(key) || objs[key], fn = c.ksSetValue || c.setValue;
			fn.call(c, values[key]);
		});
	},

	setFullObjsAccess: function(access, keys) {
		var me = this,
			objs = me.objs;

		Ext.each(keys, function(key) {
			var c = me.gksc(key) || objs[key],
				accessMask = miscTypes.ObjAccessMask[access[key]];

			if (c && accessMask) {
				var func = accessMask[0],
					params = accessMask[1] == 'true';

				KsLib.tryRun(c[func], c, params);
			}
			//c && c.setVisible((access[key] || access[key] === _));//c.ksAccessEdit = 
		});
	},

	setObjsAccess: function(access, keys) {
		var me = this,
			objs = me.objs;

		Ext.each(keys, function(key) {
			var c = me.gksc(key) || objs[key];
			c && c.setVisible(c.ksAccessEdit = (access[key] || access[key] === _));
		});
	},

	setObjsAllow: function(allow, keys) {
		var me = this,
			objs = me.objs;
		Ext.each(keys, function(key) { (me.gksc(key) || objs[key]).setKsAllowEmpty(allow[key] === false); });
	},

	setObjsValuesAndAccess: function(values, access, keys) {
		this.setObjsAccess(access, keys);
		this.setObjsValues(values, keys);
	},

	/**
	 * Выставить доступ на вкладки.
	 * Соответствие кода вкладки из модели коду вкладки клиента берется из tabMappings либо firstLetterToUpper
	 * @param tabs {object} словарь вид код вкладки (из модели) - значение маски доступа
	 * @param link {number}
	 */
	setTabsAccess: function (tabs, link) {
		let me = this;
		for (let tabKey in tabs) {
			let val = tabs[tabKey];
			let access = val[1][link] ? ObjAccessMask.BAN : val[0];
			if ((access & ObjAccessMask.READ) && !(access & ObjAccessMask.EDIT)) {
				me.setTabReadOnly(this.tabMappings[tabKey] || tabKey.capitalize());
			}
		}
	},

	/**
	 * Выставить доступ на чтение на вкладку.
	 * @param tabKey {string}
	 */
	setTabReadOnly: function(tabKey){
		let tab = this.getTab(tabKey);
		tab && tab.setKsReadOnly(true);
	},

	getDateOrToday: function(d) { return d ? new Date(d) : new Date(new Date().toDateString()); },

	getDateOrLong: function(d, begin) { return d ? new Date(d) : longPeriod[begin ? 'begin' : 'end']; },

	getReadOnlyTitle: function() { return this.title + ' - только просмотр'; },

	bindData: function(oldList, newList, outObj, posFn, newFn, setFn) {
		setFn = setFn || Ext.emptyFn;
		Ext.each(newList, function(m) {
			var d = (m.data || m),
				pos = posFn(oldList, d),
				r;
			if (pos === -1) {
				outObj.push(r = newFn(d));
			} else {
				r = oldList[pos];
				oldList.splice(pos, 1);
			}
			setFn(r, d);
		});

		ArrayLib.removeList(outObj, oldList);

		return outObj;
	},

	//#region таб История

	//линк новой записи
	histLink: -1,

	histColumns: [
		{
			hidden: true,
			text: 'Совмещение',
			dataIndex: 'MIX',
			sortable: true,
			width: 80,
			xtype: 'checkcolumn'
		},
		{
			text: 'Период действия',
			dataIndex: 'DH',
			sortable: true,
			columns: [
				{
					text: 'с',
					dataIndex: 'DH1',
					sortable: true,
					xtype: 'datecolumn',
					format: 'd.m.Y',
					flex: true,
					editor: { xtype: 'datefield', format: 'd.m.Y' }
				},
				{
					text: 'по',
					dataIndex: 'DH2',
					sortable: true,
					xtype: 'datecolumn',
					format: 'd.m.Y',
					flex: true,
					editor: { xtype: 'datefield', format: 'd.m.Y' }
				}
			],
			flex: true
		}
	],

	//наличие колонки MIX
	histMixColumnEnaeble: true,

	histMixColumnFn: function() {
		var me = this,
			objs = me.objs,
			store = objs.storeHistory;

		if (store && me.histMixColumnEnaeble) {
			if (store.data.items.length > 1) {
				objs.gridHistory.mixColumn.show();
			} else {
				objs.gridHistory.mixColumn.hide();
				store.each(function(rec) { rec.set('MIX', false); });
			}
		}
	},

	histUpdActivRec: function(th, rec) {
		if (rec) {
			var p = this.getHistEditPanel();

			if (rec.get) {
				if (rec.get('DH1') === null) {
					rec.set('DH1', longPeriod.begin);
				}

				if (rec.get('DH2') === null) {
					rec.set('DH2', longPeriod.end);
				}
			}

			if (rec === p.activRec) p.setRecord(rec);
		}
	},

	getHistChangeList: function() { return this.objs.histOnChangeList || (this.objs.histOnChangeList = []); },

	onHistChangeAdd: function(fn) {
		var me = this,
			list = me.getHistChangeList();
		if (Ext.isFunction(fn) && list.indexOf(fn) === -1) list.push(fn);
	},

	onHistChangeRemove: function(fn) {
		var me = this,
			list = me.getHistChangeList();
		if (Ext.isFunction(fn)) {
			ArrayLib.remove(list, fn);
			return;
		};
		if (Ext.isNumeric(fn)) list.splice(fn * 1, 1);
	},

	onHistChange: function(args) {
		var me = this,
			list = me.getHistChangeList();
		Ext.each(list, function(fn) { fn.apply(me, args); });
	},

	createHistEditPanel: function(items, setRecord) {
		var me = this,
			objs = me.objs;

		return objs.histEditPanel = Ext.create('Ext.panel.Panel', {
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: me.bodyPadding,
			hidden: true,
			setRecord: function(rec) {
				this.activRec = rec;
				if (Ext.isFunction(setRecord)) setRecord(rec);
			},
			items: items
		});
	},

	getHistEditPanel: function() {
		var me = this,
			objs = me.objs;
		if (!objs.histEditPanel) objs.histEditPanel = me.createHistEditPanel();
		return objs.histEditPanel;
	},

	//конструктор таба История
	createTabHistory: function() {
		var me = this,
			objs = me.objs;

		me.onHistChangeAdd(me.histMixColumnFn);
		me.onHistChangeAdd(me.histUpdActivRec);

		objs.tabHistory = Ext.create('Ext.panel.Panel', {
			title: 'История',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			getData: function(isJson, fn) {
				var res = objs.storeHistory.getData(fn);
				return (isJson) ? JSON.stringify(res) : res;
			},
			items: [
				objs.gridHistory = Ext.create('Ext.grid.Panel', {
					flex: 1,
					border: 0,
					store: objs.storeHistory = Ext.create('Ext.data.Store', {
						getNowHist: function() {
							var res;
							this.each(function(rec) {
								if (rec.get('DH1') <= now && rec.get('DH2') >= now) {
									res = rec;
									return false;
								}
								return true;
							});
							return res;
						},
						fields: [],
						data: [],
						proxy: 'memory',
						listeners: {
							update: function() { if (objs.gridHistory) me.onHistChange(arguments); },
							datachanged: function() { if (objs.gridHistory) me.onHistChange(arguments); }
						}
					}),
					columns: me.histColumns,
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1,
							isDhSwap: true
						})
					],
					tbar: [
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_new',
							handler: function() {
								addHist(me.getHistTable(), function(hist) {
									var store = objs.storeHistory;
									store.each(function(rec) {
										var pos = ArrayLib.find(hist, ['LINK'], rec.data.LINK);
										if (pos !== -1) {
											rec.set('DH1', hist[pos].DH1);
											rec.set('DH2', hist[pos].DH2);
											hist.splice(pos, 1);
										}
									});

									var sel;
									Ext.each(hist, function(h) {
										h.LINK = me.histLink--;
										sel = store.add(h);
									});
									if (sel) objs.gridHistory.getSelectionModel().select(sel);
								});
							}
						}),
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_copy',
							handler: function() {
								var r = me.getHistEditPanel().activRec;
								if (r) {
									addHist(me.getHistTable(), function(hist) {
										var store = objs.storeHistory;
										store.each(function(rec) {
											var pos = ArrayLib.find(hist, ['LINK'], rec.data.LINK);
											if (pos !== -1) {
												rec.set('DH1', hist[pos].DH1);
												rec.set('DH2', hist[pos].DH2);
												hist.splice(pos, 1);
											}
										});
										var sel;
										Ext.each(hist, function(h) {
											var d = r.getData();
											d.LINK = me.histLink--;
											d.DH1 = h.DH1;
											d.DH2 = h.DH2;

											sel = store.add(d);
										});
										if (sel) objs.gridHistory.getSelectionModel().select(sel);
									});
								}
							}
						}),
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_delete',
							handler: function() { objs.gridHistory.removeSelection(); }
						})
					],
					columnLines: true,
					listeners: {
						selectionchange: function(th, sels) { me.getHistEditPanel().setVisible(!!sels.length); },
						select: function(th, rec) { me.getHistEditPanel().setRecord(rec); }
					}
				}),
				me.getHistEditPanel()
			],
			listeners: { activate: function() { me.getHistEditPanel().setRecord(objs.gridHistory.getFrstSelect()); } }
		});

		Ext.each(objs.gridHistory.columnManager.headerCt.items.items, function(i) {
			if (i.dataIndex === 'MIX') {
				objs.gridHistory.mixColumn = i;
			} else {
				i.flex = 1;
			}
		});

		return objs.tabHistory;
	},

	//#endregion таб История

	//#region редактирование файла

	fileEdit: function() {
		var me = this;

		Ext.create('Keysystems.File', {
			iconCls: getExtStyle(me.data.data[me.fieldExt]),
			readOnly: me.readOnly,
			createFile: function(callback) { me.createFile(me.data.data[me.fieldLink], callback); },
			updRecord: function(fileObj) { me.updFileRecord(fileObj); },
			getFileId: function() { return me.data.data[me.fieldFile]; },
			downloadFile: function() { me.downloadFile(); },
			downloadFileForEditor: function() { me.downloadFileForEditor(); },
			clearFile: function() { me.clearFile(); },
			disableBtnSend: me.onlyMainFile
		});
	},
	createFile: function(link, callback) { UploaderLib.newFile(this.code, link, 0, -1, 0, this.getLoadMaskTarget(), callback); },
	clearFile: function() {
		var me = this,
			d = me.data.data;

		d[me.fieldFile] = 0;
		me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = ''));
	},
	updFileRecord: function(fileObj) {
		var me = this,
			d = me.data.data;
		d[me.fieldFile] = fileObj.id;
		me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = fileObj.ext));
	},
	getFileName: function() {
		return (this.objs[this.fieldName] || this.getKsControl(this.fieldName)).getValue();
	},
	downloadFile: function() {
		var me = this,
			d = me.data.data;
		UploaderLib.getFile(d[me.fieldFile], me.getFileName());
	},
	downloadFileForEditor: function() {
		var me = this,
			d = me.data.data;
		UploaderLib.getFileForEditor(me.code, d.CODE, d.FILES, d.NAME, false);
	},

	//#region grid

	fileGridEdit: function(rec, readOnly) {
		var me = this;
		Ext.create('Keysystems.File', {
			readOnly: me.readOnly || me.ksReadOnly || readOnly,
			iconCls: getExtStyle(rec.get(me.fieldExt)),
			createFile: null, //function() { me.createGridFile(rec.get(fieldLink)); },
			updRecord: function(fileObj) { me.updGridFileRecord(fileObj, rec); },
			getFileId: function() { return rec.get(me.fieldFile); },
			downloadFile: function() { me.downloadGridFile(rec); },
			clearFile: function() { me.clearGridFile(rec); }
		});
	},
	createGridFile: function(link) { UploaderLib.newFile(this.code, link, 0, -1, 0, this.getLoadMaskTarget()); },
	clearGridFile: function(rec) {
		rec.set(this.fieldFile, 0);
		rec.set(this.fieldExt, '');
	},
	updGridFileRecord: function(fileObj, rec) {
		rec.set(this.fieldFile, fileObj.id);
		rec.set(this.fieldExt, fileObj.ext);
	},
	downloadGridFile: function(rec, name) { UploaderLib.getFile(rec.get(this.fieldFile), name ??''); },

	//#endregion grid

	//#endregion редактирование файла

	convertListToDictList: function(inList, prefix, fields) {
		var me = this,
			res = [];
		Ext.each(inList, function(r) { res.push(me.convertToDictRec(r, prefix, fields)); });
		return res;
	},

	convertToDictRec: function(inRec, prefix, fields) {
		prefix = prefix || '';
		fields = fields || ['CODE', 'NAME'];
		var d = inRec.data || inRec,
			res = { LINK: d[prefix || 'LINK'] };
		Ext.each(fields, function(f) { res[f] = d[prefix + '_' + f]; });
		return res;
	},

	afterInitComponent: function() {
		var me = this;

		if (me.isWindow) {
			me.createWindow();
		} else {
			if (me.f === 'edit') {
				me.iconCls = 'x_btn_edit';
				me.title += '- редактирование';
			} else {
				me.iconCls = 'x_btn_new';
				me.title += '- создание';
			}
		}

		me.createEditToolbar();
		me.addViewEvents();
		me.doShow();
	},

	baseInitComponent: function() {
		var me = this;
		if (!me.isWindow) me.tbar = me.createTBar();
		me.items = me.createItems();
	},

	//Конструктор окна для вьюхи
	getWindowCfg: function() {
		var me = this,
			title = me.getViewTitle();

		me.setTitle();		
		var w = me.viewMinSize[0],
			h = me.viewMinSize[1];

		if (w > 1024) w = 1024; //соглашение о минимальных размерах
		if (h > 768) h = 768;

		delete me.iconCls; //если справочнику назначить другую иконки на форме лишний хендл

		const cfgCommonPanel = {
			bodyPadding: 0,
			minHeight: h - 55,
			items: me,
			buttons: me.createBtns(),
		};
		
		return {
			modal: true,
			//autoShow: true,
			minButtonWidth: 23,
			title: title,
			iconCls: me.f === 'edit' ? 'x_btn_edit' : 'x_btn_new',
			border: 0,
			layout: { type: 'vbox', align: 'stretch' },
			resizable: true,			
			width: w,
			minWidth: w,
			minHeight: h,
			maximizable: true,
			/** Основная панель, на которой размещаются все элементы окна редактирования */
			items: me.createCommonPanel(cfgCommonPanel),
			constrain: true

		};
	},

	/** Добавить тулбар на форму */
	createEditToolbar: function() {
		const me = this;
		if (me.objs.tbar && !me.toolbar) {
			me.toolbar = Ext.create('Ext.toolbar.Toolbar', {items: me.objs.tbar});
						
			//добавим тулбар на основную панель окна. в этом случае окно ожидания захватывает и тулбар в случае загрузки в модальном окна			
			me.editHostPanel.addDocked(me.toolbar);
			//me.getWindow().addDocked(me.toolbar);
		}
	},

	createWindow: function() {
		var me = this,
			cfg = me.getWindowCfg();
		if (me.tabMode) {
			cfg.border = 0;
			cfg.closable = true;
			me.objs.view = Ext.create('Ext.panel.Panel', cfg);
		} else {
			me.objs.view = Ext.create('Ext.window.Window', cfg);
		}
		me.setKsControl('view', me.objs.view);
	},

	getLink: function() { return this.gksd('link') || this.objs.link; },

	setLink: function (link) {
		if (this.objs.view) this.objs.view.link = link;
		return this.sksd('link', this.objs.link = link);
	},

	setLinkSelf: function (link) { return this.sksd('link_self', link); },

	getLinkSelf: function () { return this.gksd('link_self'); },

	setReadOnly: function(v, reason,  fake) {
		var me = this,
			view = me.objs.view || me.gksc('view');

		if (view) {
			if (view.title)
				me.title = view.title = view.title.split(' - ')[0];
			view.setTitle(me.getViewTitle());
			delete me.title;
			me.setTitle && me.setTitle();
			view.setKsReadOnly(v);
		}

		if (fake) {
			me.gksc('saveBtn')?.setKsReadOnly(false);
			me.gksc('controlBtn')?.setKsReadOnly(false);
			me.setStatusReadOnly();
		} else {
			me.readOnly = v;
			me.setStatusReadOnly(v, reason);
		}
		me.gksc('exitBtn')?.setKsReadOnly(false);
	},

	/**
	 * Установить доступность кнопок тулбара  ['copy', 'same', 'edit', 'delete']
	 * в зависимости от выделения строки в гриде
	 * @param grid {Ext.grid.Panel}
	 * @param sels {Array}
	 * @param readOnly {boolean}
	 */
	enableToolsGrid: function(grid, sels, readOnly) {
		let me = this,
			toolbar = grid.getToolbar(),
			tBarItems = toolbar ? toolbar.items.items : null;
		if (!toolbar || !tBarItems) return;

		tBarItems.filter(item => ['copy', 'same', 'edit', 'open', 'delete'].indexOf(item.key) >= 0)
			.forEach(item => item.setDisabled(me.readOnly || readOnly || !sels.length));
	},

	openReport: function(item) {
		let me = this;

		if (item.noNeedForm) {
			const loadMask = new Ext.LoadMask({
				msg: `${KS.L10n.report_generate}...`,
				target: me.objs.view,
				autoShow: true,
				rid: ajaxRequest({
					url: 'Report/CreateReportWeb_A',
					params: {
						code: item.code,
						link_var: item.link,
						title: item.text,
						sysCode: item.sysCode,
						mode: item.mode,
						parentLink: item.parentLink || 0,
						parametrs: '',
						paramsOtbor: item.paramsOtbor || '',
						paramsNastr: item.paramsNastr || '',
						noNeedForm: true
					},
					success: function(res) {
						if (!res.error.length) {
							getReportFile.call(me, res.guid, item.code);
						}
					},
					callback: function() {
						loadMask.destroy();
					}
				})
			});
		} else {
			Ext.create('Revizor.ReportView', {
				parentView: me,
				tabMode: false,
				title: item.text,
				link_var: item.link,
				code: item.code,
				id: item.code + '-' + Ext.id(),
				mode: item.mode,
				parentData: {
					link: item.parentLink || 0,
					code: me.code,
					data: {
						LINK: me.objs.link || me.link
					}
				}
			});
		}
	},

	/**
	 * Проверить обязательность заполнения контролов
	 * @param objs коллекция с контролами
	 * @param names контролы, которые нужно проверить
	 * @returns {boolean}
	 */
	checkForEmpty: function(objs, ...names) {
		const me = this;
		let res = true;
		names.forEach(key => {
			const c = objs[key];
			if (c && c.ksAllowEmpty && !c.isHidden()) {
				let emptyValue;
				if (c instanceof Keysystems.Controls.Dict.Edit)
					emptyValue = c.isEmpty();
				else
					emptyValue = !c.getValue();
				if (emptyValue) {
					me.addToInvalidControls(c);
					res = false;
				}
			}
		});
		return res;
	},


	/**
	 * Добавить контрол в коллекцию невалидных
	 * @param c {Ext.Component} - контрол
	 * @param cfg {object} - конфиг
	 * @param cfg.title {string} - отображаемый текст (по умолчанию c.fieldLabel)
	 * @param cfg.parent {Ext.Component} - ссылка на форму (для случая многовкладочной формы) 
	 * @param cfg.tab {Ext.tab.Panel} - ссылка на таб (для случая многовкладочной формы)
	 * @param cfg.optional {boolean}- значение опционально	  
	 */
	addToInvalidControls: function(c, cfg) {
		const me = this;

		let defaultCfg = {title: c.fieldLabel, control: c};
		if (cfg) Ext.apply(defaultCfg, cfg);
		me.invalidControls.push(defaultCfg);
		if (c.validate) c.validate();
	},
	/** Отобразить панель невалидных контролов */
	showInvalidControls: function(){
		const me = this;
		const { invalidControls, objs } = this;
		const { invalidControlsPanel } = objs;

		if (invalidControlsPanel && !invalidControlsPanel.destroyed) {
			invalidControlsPanel.setInvalidControls(invalidControls);
			invalidControlsPanel.show();
		} else {
			const panel = Ext.create('Keysystems.Controls.InvalidControlsPanel', {
				dock: 'bottom',
				closeAction: 'hide',
				closable: true,
				maxHeight: 500,
				document: this,
				resizable: {
					handles: 'n'
				},
				style: {
					borderTop: '1px solid #cecece!important'
				},
				invalidControls
			});

			me.getWindow().addDocked(panel);
			objs.invalidControlsPanel = panel;
		}
	},
	/** Скрыть панель невалидных контролов */
	hideInvalidControls: function(){
		const { objs  } = this;
		const { invalidControlsPanel } = objs;

		if (invalidControlsPanel && !invalidControlsPanel.destroyed) {
			invalidControlsPanel.hide();
		}
	},
	/** Отобразить статусную строку */ 
	setStatus: function(text, buttons){
		const me = this;
		this.hideStatus();
		
		me.editHostPanel.addDocked({
			xtype: 'rks-documentstatusbar',
			statusText: text,
			type: 'info',
			buttons: buttons,
			buttonOnClick: function (btn) {
				if (me.statusBtnOnClick) me.statusBtnOnClick(btn);
			}
		}, 5);
	},
	/** Скрыть статусную строку */
	hideStatus: function() {
		const me = this;
		const statusPanel = me.editHostPanel?.dockedItems?.items?.filter(item => item.xtype === 'rks-documentstatusbar')[0];
		if (statusPanel) {
			me.editHostPanel.removeDocked(statusPanel);
		}
	},

	/** Отобразить статусную строку с сообщением о проверки актуальности данных */
	setStatusStamp: function(text, buttons) {
		const me = this;
		this.hideStatusStamp();
		this.statusStampPanel = me.editHostPanel.addDocked({
			xtype: 'rks-documentstatusbar',
			statusText: text,
			type: 'info',
			buttons: buttons,
			buttonOnClick: function (btn) {
				me.hideStatusStamp();
				switch (btn.id) {
					//Заменить
					case 3:
						me.forceHasChanges = true;
						me.sksd('oldData', me.oldData);
						me.sksd('newData', JSON.stringify(me.dataCollector()));
						me.loadData();
						break;
					//Оставить
					case 7:
						me.loadData();
						break;
				}
			}
		}, 5)[0];
	},
	/** Скрыть статусную строку с сообщением о проверки актуальности данных */
	hideStatusStamp: function() {
		const me = this;
		if (this.statusStampPanel) {
			if (this.statusStampPanel.rendered)
				me.editHostPanel.removeDocked(this.statusStampPanel);
			this.statusStampPanel = null;
		}
	},
	/** Отобразить/скрыть статусную строку с сообщением о причине блокировки */
	setStatusReadOnly: function(readOnly, reason, buttons){
		const me = this;
		if (readOnly){
			me.setStatus(KS.L10n.Только_для_чтения + (reason ? ` - ${reason}` : ''), buttons);
		}
		else{
			me.hideStatus();
		}
	},

	/** Проверить данные на актуальность. 
	 *  Функция обращается к серверу, если STAMP не актуален, отобразит статусную строку 
	 */
	checkStamp: function(){
		const me = this;
		if (!me.needRemoveBusy || !me.ksData || !me.getLink()) return;
		
		ajaxRequest({
			url: me.linkCode + '/GetStampByLink_A',
			params: {link: me.getLink()},
			success: function (result) {
				if (!result || result.error) {
					result && console.log(result.error);
					return;
				}
				if (me.gksd('STAMP') != result) {
					me.setStatusStamp(KS.L10n.CheckState_Изменяемая_запись_изменена_другим_пользователем,
						me.getButtonsForStatusStamp());
				}
				else
					me.hideStatusStamp();
			}
		});
	},
	
	getButtonsForStatusStamp: function() {
		return [
			{id: 3, text: "Объединить", tooltip: "Обновление данных с учетом внесенных изменений"},
			{id: 7, text: "Обновить", tooltip: "Обновление данных без учета внесенных изменений" }
		]
	},

	/**
	 * Вывести сообщение о необходимости сохранения данных и сохранить данные
	 * @param message
	 * @param callBack
	 */
	saveMessageShow: function (message, callBack) {
		const me = this;
		Ext.Msg.show({
			title: KS.L10n.attention,
			msg: message ?? "Для продолжения необходимо сохранить данные.",
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: {ok: 'Сохранить',},
			fn: function (buttonId) {
				if (buttonId !== "ok") return;

				const newData = me.saveChangesFn();
				if (newData) {
					me.checkFilled(res => {
						if (!res) return;
						me.saveData(callBack, newData);
					});
				}
			},
			icon: Ext.MessageBox.INFO
		});
	},

	/**
	 * Вывод сообщения о сохранении при необходимости + сохранение
	 * @returns {Promise<boolean>}
	 */
	saveMessageShowAsync: async function (cfg) {
		const me = this;
		if (!me.getLink() || me.saveChangesFn()) {
			const dialogResult = await dialogShowAsync({
				msg: cfg?.msg ?? "Для продолжения необходимо сохранить данные.",
				title: KS.L10n.attention,
				buttons: Ext.MessageBox.OKCANCEL,
				buttonText: {
					ok: 'Сохранить'
				},
			});

			if (dialogResult !== "ok") return false;

			const checkSaveResult = await me.checkFilledAsync();
			if (!checkSaveResult) return false;

			const saved = await me.saveDataAsync();
			if (!saved) return false;
		}
		return true;
	},
});