﻿Ext.define('Keysystems.Base.Edit.Store', {
	constructor: function() {
		var me = this;
		me.events = [];
		me.rawStore = {}; //изначальные значения
		me.dataStore = {}; //конечные значения
		me.countEdit = 0; //счетчик изменений
		me.lastChanged = false;
	},
	jsonFns: {
		date: function(v) {
			return v ? new Date(v).toDateString() : v;
		},
		dict: function(v) {
			if (!v) v = [];
			if (!Ext.isArray(v)) v = [v];
			var res = [];
			for (var i = 0, len = v.length; i < len; i++) {
				var link = v[i].data ? v[i].data.LINK : v[i].LINK;
				if (link) res.push(link);
			}
			return JSON.stringify(res);
		}
	},
	compareFns: {
		def: function(v1, v2) {
			return v1 == v2;
		},
		dict: function(v1, v2) {
			if (!v1) v1 = [];
			if (!Ext.isArray(v1)) v1 = [v1];
			if (!v2) v2 = [];
			if (Ext.isArray(v2)) {
				v2 = ArrayLib.copy(v2);
			} else {
				v2 = [v2];
			}
			for (var i = 0, len = v1.length; i < len; i++) {
				var link = v1.data ? v1.data.LINK : v1.LINK,
					pos = ArrayLib.find(v2, ['data', 'LINK'], link);
				if (pos === -1) pos = ArrayLib.find(v2, ['LINK'], link);
				if (pos === -1) {
					return false;
				} else {
					v2.splice(pos, 1);
				}
			}
			return !v2.length;
		},
		date: function(v1, v2) {
			return (v1 ? new Date(v1).toDateString() : v1) == (v2 ? new Date(v2).toDateString() : v2);
		}
	},
	set: function(key, value, base, compare, jsonFn) {
		var me = this;
		if (base || !me.rawStore[key]) {
			if (me.dataStore[key] && me.dataStore[key].changed) {
				me.countEdit--;
			}
			me.rawStore[key] = {
				value: value,
				compare: compare || me.compareFns.def,
				jsonFn: jsonFn
			};
			me.dataStore[key] = {
				value: value,
				changed: false
			};
		} else {
			if (me.rawStore[key].compare(me.rawStore[key].value, value)) {
				if (me.dataStore[key].changed) {
					me.dataStore[key].changed = false;
					me.countEdit--;
					me.fireEvent();
				}
			} else {
				if (!me.dataStore[key].changed) {
					me.dataStore[key].changed = true;
					me.countEdit++;
					me.fireEvent();
				}
			}
			me.dataStore[key].value = value;
		}
	},
	get: function(key) {
		return this.dataStore[key] ? this.dataStore[key].value : undefined;
	},
	fireEvent: function() {
		var me = this,
			changed = !!me.countEdit;
		if (me.lastChanged !== changed) {
			me.lastChanged = changed;
			for (var i = 0, len = me.events.length; i < len; i++) {
				me.events[i](changed);
			}
		}
	},
	getJSON: function() {
		var me = this,
			res = {};
		for (var key in me.dataStore) {
			res[key] = me.rawStore[key].jsonFn ? me.rawStore[key].jsonFn(me.dataStore[key].value) : me.dataStore[key].value;
		}
		return JSON.stringify(res);
	}
});