﻿Ext.define('Keysystems.Base.Abstract', {
	extend: 'Ext.container.Container',

	profileKey: 'extraProfile',

	beforeInitComponent: function() {
		var me = this;
		//todo: УБРАТЬ
		me.objs = {};

		if (!me.hasListeners) me.hasListeners = new me.HasListeners();

		me.initKsControls(me.ksControls = {});
		me.initKsData(me.ksData = {});
		me.initKsMethods(me.ksMethods = {});

		me.profileManager = Ext.create('Keysystems.Profile.Manager', { ownerCt: me, profileListeners: me.profileListeners });
	},

	updateProfileListeners: function(withoutDelay) { this.profileManager.updateProfileListeners(withoutDelay); },
	getProfileMethod: Ext.emptyFn,

	initKsControls: Ext.emptyFn,
	initKsData: Ext.emptyFn,
	initKsMethods: Ext.emptyFn,

	//#region KsControls

	setKsControl: function(key, control) { return this.ksControls[key] = control; },

	//Возвращает ksControl key-ключ, inParent-искать в родителе ,inChild-в дочерних
	getKsControl: function(key, inParent, inChild) {
		var me = this,
			control;

		if (!me.ksControls) return _;

		if (me.ksControls[key]) return me.ksControls[key];

		if (inParent && (control = me.ownerCt && me.ownerCt.ksControls && me.ownerCt.ksControls[key])) return control;

		if (inChild && me.items) {
			Ext.Array.each(me.items.items || me.items, function(item) {
				if (control = item.ksControls && item.ksControls[key]) return false;
			});
		}

		return control;
	},

	sksc: function() { return this.setKsControl.apply(this, arguments); },

	gksc: function() { return this.getKsControl.apply(this, arguments); },

	//#endregion KsControls

	loadProfile: function(v) { this.profileManager.setProfile(v); },

	//#region KsData

	setKsData: function(key, v) { return this.ksData[key] = v; },

	getKsData: function(key, toJson) {
		var res = this.ksData[key];
		if (toJson) res = JSON.stringify(res);
		return res;
	},

	sksd: function() { return this.setKsData.apply(this, arguments); },

	gksd: function() { return this.getKsData.apply(this, arguments); },

	//#endregion KsData

	//#region KsMethod

	callKsMethod: function() {
		var ksMethods = this.ksMethods,
			me = arguments[0] || this,
			method = ksMethods[arguments[1]];
		if (method) method.apply(me, Array.prototype.slice.call(arguments, 2));
	},

	setKsMethod: function(key, v) { return this.ksMethods[key] = v; },

	getKsMethod: function(key) { return this.ksMethods[key]; },

	cksm: function() { return this.callKsMethod.apply(this, arguments); },

	sksm: function() { return this.setKsMethod.apply(this, arguments); },

	gksm: function() { return this.getKsMethod.apply(this, arguments); },

	//#endregion KsMethod

	createDictEdit: function(cfg, beforeCreateFn) {
		var me = this,
			okFn = function(value) {
				var c = me.gksc(cfg.key),
					profileValues = [],
					fn = c.ksSetValue || c.setValue;

				//Событие для ProfileManager
				Ext.each(value, function(v) {
					profileValues.push({
						data: {
						    LINK: [v.data? v.data: v][c.fieldLink],
						    CODE: [v.data ? v.data : v][c.codeField],
						    NAME: [v.data ? v.data : v][c.nameField]
						}
					});
				});

				c.fireEvent('ksDictChange', me, profileValues);
				fn.call(c, value);
			},
			listCfg = {
			    mode: cfg.mode,
				parentView: me.gksc('view') || me.objs.view,
				mainColumn: cfg.mainColumn,
				mainColumnName: cfg.mainColumnName,
				// опция применяется в связке с getRevizOneMain для реализации 
				// блокировки разметки основного объекта КМ/Планирования
				onlyOneMain: cfg.onlyOneMain,
				// опция задет режим отметки только одной основной записи из справочника, используется в противовес
				// onlyOneMain, похорошему нужно объеденить эти свойства, 
				// добавив другой механизм блокировки разметки основного объекта КМ/Планирования 
				mainColumnSingleCheck: cfg.mainColumnSingleCheck,
				getRevizOneMain: cfg.getRevizOneMain, // || Ext.emptyFn,
				initWhereArgs: cfg.initWhereArgs || function() { return cfg.whereArgs; },
				getInputDicts: cfg.getInputDicts || function() { return cfg.inputDicts; },
				code: cfg.code,
				readOnly: cfg.readOnly,
				checkListeners: cfg.checkListeners,
				checkRenderer: cfg.checkRenderer,
				//RWEB-1222
				controlName: cfg.controlName,
				colorizeBad: function(v) {
					var c = me.gksc(cfg.key);
					v = !!v;
					c.fieldCode && c.fieldCode.inputEl && c.fieldCode.inputEl[v ? 'addCls' : 'removeCls']('ks-holiday');
					c.fieldName && c.fieldName.inputEl && c.fieldName.inputEl[v ? 'addCls' : 'removeCls']('ks-holiday');
				}
			};
		
		if (cfg.getSOrg) listCfg.getSOrg = cfg.getSOrg;
		if (cfg.getRowClass) listCfg.getRowClass = cfg.getRowClass;
		if (cfg.getWhereArgs) listCfg.getWhereArgs = cfg.getWhereArgs;

		Ext.apply(listCfg, cfg.listCfg);
		var o = {
			labelWidth: me.labelWidth,
			clear: function() { okFn([]); },
			ksAutoCreate: true,
			createContextMenu: function() {
				var c = this,
					result = c.callParent(arguments);
				if (false && window.isDebug && !(c.readOnly || c.ksReadOnly)) {
					result.add(Ext.create('Ext.Action', {
						text: 'Заполнить первым',
						handler: function() {
							var dict = dictListController[listCfg.code];
							if (!dict) return;
							dict = getDictParent(dict);
							var params = {
								    whereArgs: JSON.stringify(listCfg.initWhereArgs()),
								    GateCode: listCfg.GateCode,
								    controlName: listCfg.controlName,
								    linkCode: dict.linkCode,
								    page: 1,
								    pageSize: 1
							    },
								callback = function(data) {
									if (data.data.length) c.setValue(data.data);
									//LoadMask.hide();
								};

							//LoadMask.show({ msg: wmc.getMask('GetDataList'), view: listCfg.parentView });

							if (listCfg.functions && listCfg.functions.refresh) {
								listCfg.functions.refresh.call(listCfg, callback, params);
							} else {
								PageDataLib.get(params, callback);
							}
						}
					}));
				}
				return result;
			},
			handler: function() {
				var c = me.gksc(cfg.key);
				listCfg.selectLinks = (c.ksGetValue || c.getValue).call(c);
				listCfg.whereArgs = listCfg.initWhereArgs();
				listCfg.inputDicts = listCfg.getInputDicts();
				listCfg.readOnly = c.readOnly;
				listCfg.accessReadOnly = c.accessReadOnly != null ? c.accessReadOnly : c.readOnly;
				listCfg.mainColumnEditable = !listCfg.readOnly;
				listCfg.isVfa = me.isVfa;
				listCfg.btnsHide = c.btnsHide || listCfg.btnsHide;
				listCfg.mode = c.dictMode || listCfg.mode;
				listCfg.control = me.gksc(cfg.key);
				listCfg.contextSearch = me.gksc(cfg.key).contextSearch;

				dictFunc(listCfg, { ok: okFn });
			}
		};

		Ext.apply(o, cfg);

		if (beforeCreateFn && Ext.isFunction(beforeCreateFn)) o = beforeCreateFn(o);

		return me.sksc(cfg.key, me.objs[cfg.key] = Ext.create(cfg.className || 'Keysystems.Controls.Dict.Edit', o));
	},

	getLoadMaskTarget: function () {
		let me = this;
		if (!me.objs.view || !me.objs.view.rendered) return null;
		return me.objs.view;
	},

	/** Отобразить окно  ожидания
	 * @param cfg - см. конфиг метода LoadMask.show
	 */
	showLoadMask: function(cfg){
		let me = this;
		if (me.loadMask){
			me.loadMask.setMsg(cfg.msg);
			me.loadMask.show();
			return;
		}
		if (!cfg.target) cfg.target = cfg.view ?? me.getLoadMaskTarget();
		if (!cfg.target || !cfg.target.rendered) return;
			
		me.loadMask = new Ext.LoadMask(cfg);
		me.loadMask.show();
	},

	/** Скрыть окно ожидания */
	hideLoadMask: function(){
		this.loadMask?.destroy();
		this.loadMask = null;
	},
	
	/** Выполнить в случае отмены загрузки данных */
	afterCancelLoad: function() {
		const me = this,
			view = me.gksc('view') ?? me.objs.view;
		me.saveChanges = false;
		if (view && (view instanceof Ext.window.Window || me.tabMode)) view.close();
	},

	/**
	 * Базовый конфиг колонки для отображения иерархии
	 */
	getTreeColumnCfg: function() {
		return {
			dataIndex: 'tree',
			width: 30,
			draggable: false,
			locked: true,
			sortable: false,
			iconCls: 'ks-tree-icon',
			cls: 'rks-tree-column',
			tdCls: 'rks-tree-cell',
			xtype: 'treecolumn',
			hasColumnChooser: true,
			index: -3,
			ignoreExport: true,
			renderer: function (value, metaData, rec) {
				if (rec.childNodes.length || !rec.get('LINK_SELF')){
					metaData.tdCls += 'ks-tree-icon-empty';
				}
				return value;
			},
			listeners: {
				afterrender: function () {
					//автоподбор ширины колонки после рендера
					try { this.autoSize(); } 
					catch {}
					//картинку columnchooser добавим после render, чтоб extjs не рассчитывал заново высоту хэдера
					this.ownerCt?.getHeaderAtIndex(0)?.textInnerEl?.addCls('ks-column-header-icon x_btn_grid_menu');
				}
			}
		}
	},

	/** 
	 * Отобразить окно ожидания для долгих команд, используется XMLHttpRequest
	 * @param cfg - конфиг метода
	 * cfg.msg - сообщение для вывода в плажке ожидания
	 * cfg.target - объект в разрезе которог овыводить плажку ожидания
	 * cfg.url - url с методом контроллера
	 * cfg.params - cправочник с параметрами 
	 * cfg.success - метод вызываемый после выполнения метода из url 	  
	 */
	showLoadMaskLong: function(cfg){
		let me = this;

		let loadMask = me != null ? new Ext.LoadMask({
			msg: cfg.msg ?? KS.L10n.loading_data,
			target: cfg.target ?? me,
			autoShow: true,
			cancelFn: function () {
				if (xhr) xhr.abort();
			}
		}) : null;

		let xhr = new XMLHttpRequest();
		xhr.open('POST', cfg.url, true);
		xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
		xhr.onreadystatechange = function () {
			if (xhr.readyState !== 4) return;
			if (xhr.status === 200) {
				// Обработка ответа				
				var result = Ext.JSON.decode(xhr.response, true);				
				if (cfg.success) cfg.success(result);
				if (loadMask) loadMask.destroy();
			}
			else
			{
				console.error(`$Ошибка при выполнении метода ${url}, status = ${xhr.status}, response = ${xhr.response}`);
				if (loadMask) loadMask.destroy();
			}
		}
		// Подготовка параметров
		let encodedData = [];
		if (cfg.params){
			for (let key in cfg.params) {
				encodedData.push(`${encodeURIComponent(key)}=${encodeURIComponent(cfg.params[key])}`);
			}			
		}
		xhr.send(encodedData.join('&'));
	}
});