﻿var AutoTestLib = {
	softTestAllDict: function(inList, ignorList, restart, indx) {
		if (!inList) {
			inList = [];
			for (var key in dictListController) inList.push(key);
		}
		if (!ignorList) ignorList = [];

		AutoTestLib.infoWinShow(inList.length, function() {
			AutoTestLib.runLine(inList, indx || 0, function(code, callBack, i) {
				AutoTestLib.lastCallBack = callBack;
				AutoTestLib.progressUpd(i);
				if (ignorList.indexOf(code) === -1) {
					AutoTestLib.softTestDict(code, callBack);
				} else {
					callBack();
				}
			}, function() {
				info(AutoTestLib.msgs.end);
				AutoTestLib.info(AutoTestLib.msgs.end);
				AutoTestLib.infoWinClose();

				if (restart)
					setTimeout(function() {
						if (Ext.isFunction(restart)) restart();
						else AutoTestLib.softTestAllDict(inList, ignorList, restart);
					}, 50);
			});
		});
	},

	softTestDict: function(code, callBack) {
		AutoTestLib.lastCallBack = callBack;
		var link = 0,
			cfg = {
				f: 'new',
				data: null,
				code: code,
				parentView: tabView,
				addRecord: function(row) { return { data: row, raw: row }; },
				createTBar: function() {
					var res = this.__createTBar();
					res.push(
						'-', Ext.create('Ext.Button', {
							iconCls: 'x_btn_dict',
							handler: function() { dictFunc({ parentView: tabView, code: code }); }
						}),
						Ext.create('Ext.form.field.Text', { value: code, readOnly: true }),
						'-', Ext.create('Ext.Button', {
							text: 'Next',
							handler: function() { AutoTestLib.lastCallBack(); }
						})
					);
					return res;
				},
				addViewEvents: function() {
					var me = this,
						view = me.objs.view || me.getKsControl('view') || me;

					view.on('show', function() { AutoTestLib.fillView(me, code, function() { AutoTestLib.saveView(me, code, function(l) { link = l; }); }); });

					return me.callParent(arguments);
				},
				afterClose: function() { if (link) AutoTestLib.removeDict(code, link, function() { if (callBack) callBack(); }); }
			};

		Ext.apply(cfg, getDictParent(dictListController[code]));

		cfg.title += '[' + code + ': ' + cfg.linkCode + ': ' + cfg.editClass + ']';

		AutoTestLib.createEditView(code, cfg, callBack);
	},

	createEditView: function(code, cfg, runNext) {
		AutoTestLib.info(cfg.title + '\n' + AutoTestLib.msgs.create);

		if (AutoTests.get(code, 'create')) {
			AutoTests.get(code, 'create')(code, cfg, runNext);
		} else {
			if (cfg.editClass) {
				Ext.create(cfg.editClass, cfg);
			} else {
				AutoTestLib.infoAppEnd(AutoTestLib.msgs.notEditClass);
				if (runNext) runNext();
			}
		}
	},

	saveView: function(me, code, setLink) {
		var afterSave = function() {
			AutoTestLib.infoAppEnd(AutoTestLib.msgs.saveEnd);
			setLink(me.getLink());
			(me.gksc('view') || me.objs.view).close();
		};
		if (AutoTests.get(code, 'save')) {
			AutoTests.get(code, 'save')(me, code, afterSave);
		} else {
			if (me.isFilled()) {
				AutoTestLib.infoAppEnd(AutoTestLib.msgs.saveStart);

				me.on('CheckCodeMessage', function(msg) {
					msg.hide();
					msg.userCallback('ok');
				});

				me.saveData(afterSave);
			} else {
				AutoTestLib.infoAppEnd(AutoTestLib.msgs.allow);
				warning(AutoTestLib.msgs.allow);
			}
		}
	},

	removeDict: function(code, link, callBack) {
		AutoTestLib.lastCallBack = callBack;
		AutoTestLib.infoAppEnd(AutoTestLib.msgs.deleteStart);

		if (AutoTests.get(code, 'delete')) {
			AutoTests.get(code, 'delete')(code, link, callBack);
		} else {
			LoadMask.show({
				msg: wmc.getMask('Deleting'),
				rid: ajaxRequest({
					params: { code: code, links: [link], recursive: false },
					url: 'data/DelSDictionary_A',
					success: function(value) {
						var notDel = value.notDel;
						if (notDel && (notDel.length)) {
							AutoTestLib.infoAppEnd(AutoTestLib.msgs.notDelete);
							relationsMsg(code, notDel, value.notDelLinks, false, window.tabView);
						} else {
							AutoTestLib.infoAppEnd(AutoTestLib.msgs.deleteEnd);
							callBack();
						}
					},
					failure: function() { AutoTestLib.infoAppEnd(AutoTestLib.msgs.deleteError); },
					callback: function() { LoadMask.hide(); }
				})
			});
		}
	},

	isEmpty: function(c) {
		switch (c.$className) {
		case 'Ext.form.field.Text':
		case 'Ext.form.field.Date':
		case 'Ext.form.field.Number':
		case 'Ext.form.field.ComboBox':
		case 'Keysystems.form.field.Trigger.TextEditor':
		case 'Keysystems.Controls.DocVid.Type':
			return !c.getValue();
		case 'Keysystems.Controls.CalcField':
			return !c.getNumValue();
		case 'Keysystems.Controls.Dict.Edit':
		case 'Keysystems.Controls.DictCode.Edit':
		case 'Keysystems.Controls.PeriodEdit':
			return c.isEmpty();
		}
		Log.sendLog('------------>>>>>>' + c.$className);
		AutoTestLib.infoAppEnd(AutoTestLib.msgs.notInfo + '\n' + c.$className);
		return true;
	},

	_setDictValue: function(callBack) {
		AutoTestLib.lastCallBack = callBack;
		var dictList = window.lastDictListShow;
		delete window.lastDictListShow;
		if (dictList) {
			if (dictList.functions && dictList.functions.ok) {
				var rec = dictList.getFrstRecord(),
					fn = function() {
						dictList.checkRecord(rec);
						dictList.functions.ok(rec);
						dictList.afterClose = callBack;
						dictList.objs.view.close();
					};
				if (rec) {
					fn();
				} else {
					var link;
					dictList.edit('new', null, {
						updRecord: function (r) {
							rec = dictList.Grid.store.getRecord(r.LINK);
							if (!rec) {
								if (dictList.Grid.store.root) {
									rec = dictList.Grid.store.root.appendChild(r);
								} else {
									rec = dictList.Grid.store.add(r)[0];
								}
							}
						},
						addViewEvents: function() {
							var me = this,
								view = me.objs.view || me.getKsControl('view') || me;

							view.on('show', function() {
								AutoTestLib.fillView(me, me.code, function() {
									AutoTestLib.saveView(me, me.code, function(l) { link = l; });
								});
							});

							view.on('close', function() { fn(); });

							return me.callParent(arguments);
						}
					});
				}
			} else {
				callBack();
			}
		} else {
			setTimeout(function() { AutoTestLib._setDictValue(callBack); }, 500);
		}
	},

	setRandomValue: function(c, callBack) {
		AutoTestLib.lastCallBack = callBack;
		switch (c.$className) {
		case 'Keysystems.form.field.Trigger.TextEditor':
		case 'Ext.form.field.Text':
			var v = 'tmp_' + Date.now();
			if (c.maxLength) v = v.substr(0, c.maxLength);
			c.setValue(v);
			callBack();
			return;
		case 'Ext.form.field.ComboBox':
			c.setValueSelectOrFrst();
			callBack();
			return;
		case 'Keysystems.Controls.DocVid.Type':
			for (var t in c.DocType) {
				c.setValue(c.DocType[t]);
				callBack();
				return;
			}
		case 'Ext.form.field.Date':
			c.setValue(new Date());
			callBack();
			return;
		case 'Ext.form.field.Number':
		case 'Keysystems.Controls.CalcField':
			var v1 = (Math.random() * 1000 | 0) + 500;
			if (c.maxLength) v1 = (v1 + '').substr(0, c.maxLength) * 1;
			c.setValue(v1);
			callBack();
			return;
		case 'Keysystems.Controls.Dict.Edit':
		case 'Keysystems.Controls.DictCode.Edit':
			if (c.ksAutoCreate1) {

			} else {
				if (Ext.isFunction(c.handler)) {
					c.handler();
				} else {
					if (Ext.isArray(c.handler)) {
						Ext.each(c.handler, function(h) {
							if (Ext.isFunction(h)) h();
							else h.handler();
						});
					}
				}
				delete window.lastDictListShow;
				AutoTestLib._setDictValue(callBack);
			}
			return;
		case 'Keysystems.Controls.PeriodEdit':
			c.setValue(longPeriod.begin, longPeriod.end);
			callBack();
			return;
		default:
			callBack();
		}
	},

	runLine: function(line, i, metod, callBack) {
		AutoTestLib.lastCallBack = callBack;
		if (i >= line.length) {
			callBack();
			return;
		}
		setTimeout(function() { metod(line[i], function() { AutoTestLib.runLine(line, i + 1, metod, callBack); }, i); }, 20);
	},

	runFillTest: function(me, test, callBack) {
		ArrayLib.runLine(test.fillArr, 0, function(t, next, i) {
			AutoTestLib.lastCallBack = next;
			t.apply(test, [me, next]);
		}, callBack);
	},

	fillView: function(me, code, callBack) {
		if (AutoTests.get(code, 'fillArr')) {
			AutoTestLib.runFillTest(me, AutoTests.get(code), callBack);
		} else {
			var objs = {};
			Ext.apply(objs, me.ksControls, me.objs);
			AutoTestLib.setAllowControls(objs, callBack);
		}
	},

	setAllowControls: function(objs, callBack) {
		AutoTestLib.lastCallBack = callBack;
		AutoTestLib.infoAppEnd(AutoTestLib.msgs.setValues);
		var cList = [];
		for (var key in objs) {
			var c = objs[key];
			if (c && c.ksAllowEmpty && AutoTestLib.isEmpty(c) && !c.isHidden()) {
				cList.push(c);
			}
		}

		AutoTestLib.runLine(cList, 0, function(control, callBack1) { AutoTestLib.setRandomValue(control, callBack1); }, callBack);
	},

	nextBtnShow: function(callBack) {
		AutoTestLib.lastCallBack = callBack;
		var w = Ext.create('Ext.window.Window', {
			width: 500,
			height: 500,
			bodyPadding: 10,
			layout: { type: 'vbox', align: 'stretch' },
			items: [
				Ext.create('Ext.Button', {
					text: 'Next',
					flex: 1,
					handler: function() {
						w.close();
						callBack();
					}
				})
			]
		});
		w.show();
	},

	infoWinShow: function(progressCount, callBack) {
		AutoTestLib.infoWin = Ext.create('Ext.window.Window', {
			title: 'AutoTest',
			y: 0,
			width: 500,
			height: 250,
			bodyPadding: 10,
			modal: true,
			layout: { type: 'vbox', align: 'stretch' },
			items: [
				AutoTestLib.infoTextArea = Ext.create('Ext.form.field.TextArea', {
					flex: 1,
					readOnly: true,
					value: AutoTestLib.msgs.start
				}),
				Ext.create('Ext.Button', {
					text: 'Next',
					handler: function() { if (AutoTestLib.lastCallBack) AutoTestLib.lastCallBack(); }
				}),
				AutoTestLib.progressBar = Ext.create('Ext.ProgressBar', { length: progressCount })
			]
		});
		AutoTestLib.infoWin.show(window.tabView, callBack);
	},

	infoWinClose: function() { AutoTestLib.infoWin.close(); },

	info: function(text) { AutoTestLib.infoTextArea.setValue(text); },

	infoAppEnd: function(text) { AutoTestLib.infoTextArea.setValue(AutoTestLib.infoTextArea.getValue() + '\n' + text); },

	progressUpd: function(i) {
		var len = AutoTestLib.progressBar.length;
		AutoTestLib.progressBar.updateProgress(i / len, i + '/' + len, true);
	},

	msgs: {
		start: 'Старт автоматического тестирования',
		end: 'Тест завершен успешно',
		create: 'Создание формы...',
		notEditClass: 'Отсутствует класс редактирования',
		saveStart: 'Сохранение...',
		saveEnd: 'Сохранено',
		close: 'Закрытие формы...',
		allow: 'Не все обязательные поля заполнены',
		deleteStart: 'Удаление...',
		deleteEnd: 'Удалено',
		deleteError: 'Ошибка при удалении',
		notDelete: 'Не удалось удалить',
		notInfo: 'Неизвестное поле',
		setValues: 'Заполнение полей...'
	},

	runDefault: function(i, callback) {
		Log(1);
		AutoTestLib.softTestAllDict(_, [
			'DOCUMENT_DOCREVIZ_REPORT',
			'DOCUMENT_DOCREVIZ_REPORT_VFA',
			'DICTIONARY_IFC_S_PROB_RISK_L',
			'DICTIONARY_IFC_S_IMPL_RISK_L',
			'DOCUMENT_IFC_REGISTER',
			'DOCUMENT_FACTNAR',
			'DOCUMENT_FACTNAR_VFA',
			'DICTIONARY_IFC_RISK_L_VALUE',
		    'DICTIONARY_SPLANPROJ',
		    'DICTIONARY_SPLANPROJ_VFA'
		], callback, i);
	},

	throw500Error: function() {
		ajaxRequest({
			url: 'data/ThrowError_A'
		});
	}
};