require "css_parser"
require "cssminify"
require "base64"
require 'fileutils'

include CssParser

def convert(folder, file, out_folder)
	FileUtils.mkdir_p(out_folder + '/' + folder) 

	parser = CssParser::Parser.new
	parser.load_file!(folder + '/' + file)

	out_parser = CssParser::Parser.new

	parser.each_selector(:all) do |sel, dec, spec|
		rs = RuleSet.new(sel,dec)

		if !rs['background-image'].empty?
			file_path = rs['background-image'][4..rs['background-image'].length-3]
			format = file_path[file_path.length - 3 .. file_path.length - 1]

			if (format == "gif") or (format == "png") 
				bin = File.binread(folder + '/' + file_path)
				contents = Base64.strict_encode64(bin)
				url = "url(\"data:image/#{format};base64,#{contents}\")"
				rs['background-image'] = url
			end
		end

		if !rs['background'].empty?
			if rs['background'].include?("gif") || rs['background'].include?("png")
				url = rs['background'][/url\(.+\)/]

				file_path = url[4..url.length-2]
				format = file_path[file_path.length - 3 .. file_path.length - 1]

				if (format == "gif") or (format == "png")
					bin = File.binread(folder + '/' + file_path)
					contents = Base64.strict_encode64(bin)

					url = "url(\"data:image/#{format};base64,#{contents}\")"
					rs['background'] = rs['background'].gsub(/url\(.+\)/, url)
				end
			end
		end

		if rs['background-image'].include? "gradient"
			str = rs['background-image'].clone

			str.chomp! ";"
			params = str[/\(.*?\)/]

			out_parser.add_rule_set! RuleSet.new sel, "background-image: -webkit-linear-gradient" + params + ';'
			out_parser.add_rule_set! RuleSet.new sel, "background-image: -moz-linear-gradient" + params + ';'
			out_parser.add_rule_set! RuleSet.new sel, "background-image: -o-linear-gradient" + params + ';'
			out_parser.add_rule_set! RuleSet.new sel, "background-image: -ms-linear-gradient" + params + ';'
		end

		out_parser.add_rule_set! rs
	end
	File.open(out_folder + '/' + folder + '/' + file, "w") do |f| 
		if file.include? "debug"
			f.write out_parser.to_s
		else
			f.write CSSminify.compress( out_parser.to_s) 
		end
	end
end

def gen_hash_css_files
	files_hash = {}

	files = Dir['**/*'].select{ |i| i[/\.css$/] }
	files.each do |file_path|
		file_arr_path = file_path.split("/")

		file_folder = file_arr_path[0..-2].join "/"
		file_name = file_arr_path.last

		if files_hash[file_folder] == nil
			files_hash[file_folder] = [file_name]
		else
			files_hash[file_folder] << file_name	
		end
	end

	files_hash
end

out_folder = "out"
FileUtils.rm_rf(out_folder) if File.directory? out_folder

files =  gen_hash_css_files

files.each do |folder, name_files|
	name_files.each do |name_file|
		p "write " + out_folder + '/' + folder  + '/' + name_file
		convert folder, name_file, out_folder
	end
end