!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports):"function"==typeof define&&define.amd?define(["exports"],factory):factory(global.d3=global.d3||{})}(this,(function(exports){"use strict";var ascending=function(a,b){return a<b?-1:a>b?1:a>=b?0:NaN},bisector=function(compare){return 1===compare.length&&(compare=function ascendingComparator(f){return function(d,x){return ascending(f(d),x)}}(compare)),{left:function(a,x,lo,hi){for(null==lo&&(lo=0),null==hi&&(hi=a.length);lo<hi;){var mid=lo+hi>>>1;compare(a[mid],x)<0?lo=mid+1:hi=mid}return lo},right:function(a,x,lo,hi){for(null==lo&&(lo=0),null==hi&&(hi=a.length);lo<hi;){var mid=lo+hi>>>1;compare(a[mid],x)>0?hi=mid:lo=mid+1}return lo}}};var ascendingBisect=bisector(ascending),bisectRight=ascendingBisect.right,bisectLeft=ascendingBisect.left;function pair(a,b){return[a,b]}var number=function(x){return null===x?NaN:+x},variance=function(array,f){var a,d,n=array.length,m=0,s=0,i=-1,j=0;if(null==f)for(;++i<n;)isNaN(a=number(array[i]))||(s+=(d=a-m)*(a-(m+=d/++j)));else for(;++i<n;)isNaN(a=number(f(array[i],i,array)))||(s+=(d=a-m)*(a-(m+=d/++j)));if(j>1)return s/(j-1)},deviation=function(array,f){var v=variance(array,f);return v?Math.sqrt(v):v},extent=function(array,f){var a,b,c,i=-1,n=array.length;if(null==f){for(;++i<n;)if(null!=(b=array[i])&&b>=b){a=c=b;break}for(;++i<n;)null!=(b=array[i])&&(a>b&&(a=b),c<b&&(c=b))}else{for(;++i<n;)if(null!=(b=f(array[i],i,array))&&b>=b){a=c=b;break}for(;++i<n;)null!=(b=f(array[i],i,array))&&(a>b&&(a=b),c<b&&(c=b))}return[a,c]},array=Array.prototype,slice=array.slice,map=array.map,constant=function(x){return function(){return x}},identity=function(x){return x},sequence=function(start,stop,step){start=+start,stop=+stop,step=(n=arguments.length)<2?(stop=start,start=0,1):n<3?1:+step;for(var i=-1,n=0|Math.max(0,Math.ceil((stop-start)/step)),range=new Array(n);++i<n;)range[i]=start+i*step;return range},e10=Math.sqrt(50),e5=Math.sqrt(10),e2=Math.sqrt(2),ticks=function(start,stop,count){var step=tickStep(start,stop,count);return sequence(Math.ceil(start/step)*step,Math.floor(stop/step)*step+step/2,step)};function tickStep(start,stop,count){var step0=Math.abs(stop-start)/Math.max(0,count),step1=Math.pow(10,Math.floor(Math.log(step0)/Math.LN10)),error=step0/step1;return error>=e10?step1*=10:error>=e5?step1*=5:error>=e2&&(step1*=2),stop<start?-step1:step1}var sturges=function(values){return Math.ceil(Math.log(values.length)/Math.LN2)+1},threshold=function(array,p,f){if(null==f&&(f=number),n=array.length){if((p=+p)<=0||n<2)return+f(array[0],0,array);if(p>=1)return+f(array[n-1],n-1,array);var n,h=(n-1)*p,i=Math.floor(h),a=+f(array[i],i,array);return a+(+f(array[i+1],i+1,array)-a)*(h-i)}},merge=function(arrays){for(var m,merged,array,n=arrays.length,i=-1,j=0;++i<n;)j+=arrays[i].length;for(merged=new Array(j);--n>=0;)for(m=(array=arrays[n]).length;--m>=0;)merged[--j]=array[m];return merged},min=function(array,f){var a,b,i=-1,n=array.length;if(null==f){for(;++i<n;)if(null!=(b=array[i])&&b>=b){a=b;break}for(;++i<n;)null!=(b=array[i])&&a>b&&(a=b)}else{for(;++i<n;)if(null!=(b=f(array[i],i,array))&&b>=b){a=b;break}for(;++i<n;)null!=(b=f(array[i],i,array))&&a>b&&(a=b)}return a},transpose=function(matrix){if(!(n=matrix.length))return[];for(var i=-1,m=min(matrix,length),transpose=new Array(m);++i<m;)for(var n,j=-1,row=transpose[i]=new Array(n);++j<n;)row[j]=matrix[j][i];return transpose};function length(d){return d.length}var slice$1=Array.prototype.slice,identity$1=function(x){return x};function translateX(x){return"translate("+x+",0)"}function translateY(y){return"translate(0,"+y+")"}function center(scale){var offset=scale.bandwidth()/2;return scale.round()&&(offset=Math.round(offset)),function(d){return scale(d)+offset}}function entering(){return!this.__axis}function axis(orient,scale){var x,tickArguments=[],tickValues=null,tickFormat=null,tickSizeInner=6,tickSizeOuter=6,tickPadding=3,k=1===orient||4===orient?-1:1,y=4===orient||2===orient?(x="x","y"):(x="y","x"),transform=1===orient||3===orient?translateX:translateY;function axis(context){var values=null==tickValues?scale.ticks?scale.ticks.apply(scale,tickArguments):scale.domain():tickValues,format=null==tickFormat?scale.tickFormat?scale.tickFormat.apply(scale,tickArguments):identity$1:tickFormat,spacing=Math.max(tickSizeInner,0)+tickPadding,range=scale.range(),range0=range[0]+.5,range1=range[range.length-1]+.5,position=(scale.bandwidth?center:identity$1)(scale.copy()),selection=context.selection?context.selection():context,path=selection.selectAll(".domain").data([null]),tick=selection.selectAll(".tick").data(values,scale).order(),tickExit=tick.exit(),tickEnter=tick.enter().append("g").attr("class","tick"),line=tick.select("line"),text=tick.select("text");path=path.merge(path.enter().insert("path",".tick").attr("class","domain").attr("stroke","#000")),tick=tick.merge(tickEnter),line=line.merge(tickEnter.append("line").attr("stroke","#000").attr(x+"2",k*tickSizeInner).attr(y+"1",.5).attr(y+"2",.5)),text=text.merge(tickEnter.append("text").attr("fill","#000").attr(x,k*spacing).attr(y,.5).attr("dy",1===orient?"0em":3===orient?"0.71em":"0.32em")),context!==selection&&(path=path.transition(context),tick=tick.transition(context),line=line.transition(context),text=text.transition(context),tickExit=tickExit.transition(context).attr("opacity",1e-6).attr("transform",(function(d){return isFinite(d=position(d))?transform(d):this.getAttribute("transform")})),tickEnter.attr("opacity",1e-6).attr("transform",(function(d){var p=this.parentNode.__axis;return transform(p&&isFinite(p=p(d))?p:position(d))}))),tickExit.remove(),path.attr("d",4===orient||2==orient?"M"+k*tickSizeOuter+","+range0+"H0.5V"+range1+"H"+k*tickSizeOuter:"M"+range0+","+k*tickSizeOuter+"V0.5H"+range1+"V"+k*tickSizeOuter),tick.attr("opacity",1).attr("transform",(function(d){return transform(position(d))})),line.attr(x+"2",k*tickSizeInner),text.attr(x,k*spacing).text(format),selection.filter(entering).attr("fill","none").attr("font-size",10).attr("font-family","sans-serif").attr("text-anchor",2===orient?"start":4===orient?"end":"middle"),selection.each((function(){this.__axis=position}))}return axis.scale=function(_){return arguments.length?(scale=_,axis):scale},axis.ticks=function(){return tickArguments=slice$1.call(arguments),axis},axis.tickArguments=function(_){return arguments.length?(tickArguments=null==_?[]:slice$1.call(_),axis):tickArguments.slice()},axis.tickValues=function(_){return arguments.length?(tickValues=null==_?null:slice$1.call(_),axis):tickValues&&tickValues.slice()},axis.tickFormat=function(_){return arguments.length?(tickFormat=_,axis):tickFormat},axis.tickSize=function(_){return arguments.length?(tickSizeInner=tickSizeOuter=+_,axis):tickSizeInner},axis.tickSizeInner=function(_){return arguments.length?(tickSizeInner=+_,axis):tickSizeInner},axis.tickSizeOuter=function(_){return arguments.length?(tickSizeOuter=+_,axis):tickSizeOuter},axis.tickPadding=function(_){return arguments.length?(tickPadding=+_,axis):tickPadding},axis}var noop={value:function(){}};function dispatch(){for(var t,i=0,n=arguments.length,_={};i<n;++i){if(!(t=arguments[i]+"")||t in _)throw new Error("illegal type: "+t);_[t]=[]}return new Dispatch(_)}function Dispatch(_){this._=_}function parseTypenames(typenames,types){return typenames.trim().split(/^|\s+/).map((function(t){var name="",i=t.indexOf(".");if(i>=0&&(name=t.slice(i+1),t=t.slice(0,i)),t&&!types.hasOwnProperty(t))throw new Error("unknown type: "+t);return{type:t,name:name}}))}function get(type,name){for(var c,i=0,n=type.length;i<n;++i)if((c=type[i]).name===name)return c.value}function set(type,name,callback){for(var i=0,n=type.length;i<n;++i)if(type[i].name===name){type[i]=noop,type=type.slice(0,i).concat(type.slice(i+1));break}return null!=callback&&type.push({name:name,value:callback}),type}Dispatch.prototype=dispatch.prototype={constructor:Dispatch,on:function(typename,callback){var t,_=this._,T=parseTypenames(typename+"",_),i=-1,n=T.length;if(!(arguments.length<2)){if(null!=callback&&"function"!=typeof callback)throw new Error("invalid callback: "+callback);for(;++i<n;)if(t=(typename=T[i]).type)_[t]=set(_[t],typename.name,callback);else if(null==callback)for(t in _)_[t]=set(_[t],typename.name,null);return this}for(;++i<n;)if((t=(typename=T[i]).type)&&(t=get(_[t],typename.name)))return t},copy:function(){var copy={},_=this._;for(var t in _)copy[t]=_[t].slice();return new Dispatch(copy)},call:function(type,that){if((n=arguments.length-2)>0)for(var n,t,args=new Array(n),i=0;i<n;++i)args[i]=arguments[i+2];if(!this._.hasOwnProperty(type))throw new Error("unknown type: "+type);for(i=0,n=(t=this._[type]).length;i<n;++i)t[i].value.apply(that,args)},apply:function(type,that,args){if(!this._.hasOwnProperty(type))throw new Error("unknown type: "+type);for(var t=this._[type],i=0,n=t.length;i<n;++i)t[i].value.apply(that,args)}};var xhtml="http://www.w3.org/1999/xhtml",namespaces={svg:"http://www.w3.org/2000/svg",xhtml:xhtml,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"},namespace=function(name){var prefix=name+="",i=prefix.indexOf(":");return i>=0&&"xmlns"!==(prefix=name.slice(0,i))&&(name=name.slice(i+1)),namespaces.hasOwnProperty(prefix)?{space:namespaces[prefix],local:name}:name};function creatorInherit(name){return function(){var document=this.ownerDocument,uri=this.namespaceURI;return uri===xhtml&&document.documentElement.namespaceURI===xhtml?document.createElement(name):document.createElementNS(uri,name)}}function creatorFixed(fullname){return function(){return this.ownerDocument.createElementNS(fullname.space,fullname.local)}}var creator=function(name){var fullname=namespace(name);return(fullname.local?creatorFixed:creatorInherit)(fullname)},nextId=0;function local$1(){return new Local}function Local(){this._="@"+(++nextId).toString(36)}Local.prototype=local$1.prototype={constructor:Local,get:function(node){for(var id=this._;!(id in node);)if(!(node=node.parentNode))return;return node[id]},set:function(node,value){return node[this._]=value},remove:function(node){return this._ in node&&delete node[this._]},toString:function(){return this._}};var matcher=function(selector){return function(){return this.matches(selector)}};if("undefined"!=typeof document){var element=document.documentElement;if(!element.matches){var vendorMatches=element.webkitMatchesSelector||element.msMatchesSelector||element.mozMatchesSelector||element.oMatchesSelector;matcher=function(selector){return function(){return vendorMatches.call(this,selector)}}}}var matcher$1=matcher,filterEvents={};(exports.event=null,"undefined"!=typeof document)&&("onmouseenter"in document.documentElement||(filterEvents={mouseenter:"mouseover",mouseleave:"mouseout"}));function filterContextListener(listener,index,group){return listener=contextListener(listener,index,group),function(event){var related=event.relatedTarget;related&&(related===this||8&related.compareDocumentPosition(this))||listener.call(this,event)}}function contextListener(listener,index,group){return function(event1){var event0=exports.event;exports.event=event1;try{listener.call(this,this.__data__,index,group)}finally{exports.event=event0}}}function parseTypenames$1(typenames){return typenames.trim().split(/^|\s+/).map((function(t){var name="",i=t.indexOf(".");return i>=0&&(name=t.slice(i+1),t=t.slice(0,i)),{type:t,name:name}}))}function onRemove(typename){return function(){var on=this.__on;if(on){for(var o,j=0,i=-1,m=on.length;j<m;++j)o=on[j],typename.type&&o.type!==typename.type||o.name!==typename.name?on[++i]=o:this.removeEventListener(o.type,o.listener,o.capture);++i?on.length=i:delete this.__on}}}function onAdd(typename,value,capture){var wrap=filterEvents.hasOwnProperty(typename.type)?filterContextListener:contextListener;return function(d,i,group){var o,on=this.__on,listener=wrap(value,i,group);if(on)for(var j=0,m=on.length;j<m;++j)if((o=on[j]).type===typename.type&&o.name===typename.name)return this.removeEventListener(o.type,o.listener,o.capture),this.addEventListener(o.type,o.listener=listener,o.capture=capture),void(o.value=value);this.addEventListener(typename.type,listener,capture),o={type:typename.type,name:typename.name,value:value,listener:listener,capture:capture},on?on.push(o):this.__on=[o]}}function customEvent(event1,listener,that,args){var event0=exports.event;event1.sourceEvent=exports.event,exports.event=event1;try{return listener.apply(that,args)}finally{exports.event=event0}}var sourceEvent=function(){for(var source,current=exports.event;source=current.sourceEvent;)current=source;return current},point=function(node,event){var svg=node.ownerSVGElement||node;if(svg.createSVGPoint){var point=svg.createSVGPoint();return point.x=event.clientX,point.y=event.clientY,[(point=point.matrixTransform(node.getScreenCTM().inverse())).x,point.y]}var rect=node.getBoundingClientRect();return[event.clientX-rect.left-node.clientLeft,event.clientY-rect.top-node.clientTop]},mouse=function(node){var event=sourceEvent();return event.changedTouches&&(event=event.changedTouches[0]),point(node,event)};function none(){}var selector=function(selector){return null==selector?none:function(){return this.querySelector(selector)}};function empty$1(){return[]}var selectorAll=function(selector){return null==selector?empty$1:function(){return this.querySelectorAll(selector)}},sparse=function(update){return new Array(update.length)};function EnterNode(parent,datum){this.ownerDocument=parent.ownerDocument,this.namespaceURI=parent.namespaceURI,this._next=null,this._parent=parent,this.__data__=datum}EnterNode.prototype={constructor:EnterNode,appendChild:function(child){return this._parent.insertBefore(child,this._next)},insertBefore:function(child,next){return this._parent.insertBefore(child,next)},querySelector:function(selector){return this._parent.querySelector(selector)},querySelectorAll:function(selector){return this._parent.querySelectorAll(selector)}};function bindIndex(parent,group,enter,update,exit,data){for(var node,i=0,groupLength=group.length,dataLength=data.length;i<dataLength;++i)(node=group[i])?(node.__data__=data[i],update[i]=node):enter[i]=new EnterNode(parent,data[i]);for(;i<groupLength;++i)(node=group[i])&&(exit[i]=node)}function bindKey(parent,group,enter,update,exit,data,key){var i,node,keyValue,nodeByKeyValue={},groupLength=group.length,dataLength=data.length,keyValues=new Array(groupLength);for(i=0;i<groupLength;++i)(node=group[i])&&(keyValues[i]=keyValue="$"+key.call(node,node.__data__,i,group),keyValue in nodeByKeyValue?exit[i]=node:nodeByKeyValue[keyValue]=node);for(i=0;i<dataLength;++i)(node=nodeByKeyValue[keyValue="$"+key.call(parent,data[i],i,data)])?(update[i]=node,node.__data__=data[i],nodeByKeyValue[keyValue]=null):enter[i]=new EnterNode(parent,data[i]);for(i=0;i<groupLength;++i)(node=group[i])&&nodeByKeyValue[keyValues[i]]===node&&(exit[i]=node)}function ascending$1(a,b){return a<b?-1:a>b?1:a>=b?0:NaN}function attrRemove(name){return function(){this.removeAttribute(name)}}function attrRemoveNS(fullname){return function(){this.removeAttributeNS(fullname.space,fullname.local)}}function attrConstant(name,value){return function(){this.setAttribute(name,value)}}function attrConstantNS(fullname,value){return function(){this.setAttributeNS(fullname.space,fullname.local,value)}}function attrFunction(name,value){return function(){var v=value.apply(this,arguments);null==v?this.removeAttribute(name):this.setAttribute(name,v)}}function attrFunctionNS(fullname,value){return function(){var v=value.apply(this,arguments);null==v?this.removeAttributeNS(fullname.space,fullname.local):this.setAttributeNS(fullname.space,fullname.local,v)}}var window=function(node){return node.ownerDocument&&node.ownerDocument.defaultView||node.document&&node||node.defaultView};function styleRemove(name){return function(){this.style.removeProperty(name)}}function styleConstant(name,value,priority){return function(){this.style.setProperty(name,value,priority)}}function styleFunction(name,value,priority){return function(){var v=value.apply(this,arguments);null==v?this.style.removeProperty(name):this.style.setProperty(name,v,priority)}}function propertyRemove(name){return function(){delete this[name]}}function propertyConstant(name,value){return function(){this[name]=value}}function propertyFunction(name,value){return function(){var v=value.apply(this,arguments);null==v?delete this[name]:this[name]=v}}function classArray(string){return string.trim().split(/^|\s+/)}function classList(node){return node.classList||new ClassList(node)}function ClassList(node){this._node=node,this._names=classArray(node.getAttribute("class")||"")}function classedAdd(node,names){for(var list=classList(node),i=-1,n=names.length;++i<n;)list.add(names[i])}function classedRemove(node,names){for(var list=classList(node),i=-1,n=names.length;++i<n;)list.remove(names[i])}function classedTrue(names){return function(){classedAdd(this,names)}}function classedFalse(names){return function(){classedRemove(this,names)}}function classedFunction(names,value){return function(){(value.apply(this,arguments)?classedAdd:classedRemove)(this,names)}}ClassList.prototype={add:function(name){this._names.indexOf(name)<0&&(this._names.push(name),this._node.setAttribute("class",this._names.join(" ")))},remove:function(name){var i=this._names.indexOf(name);i>=0&&(this._names.splice(i,1),this._node.setAttribute("class",this._names.join(" ")))},contains:function(name){return this._names.indexOf(name)>=0}};function textRemove(){this.textContent=""}function textConstant(value){return function(){this.textContent=value}}function textFunction(value){return function(){var v=value.apply(this,arguments);this.textContent=null==v?"":v}}function htmlRemove(){this.innerHTML=""}function htmlConstant(value){return function(){this.innerHTML=value}}function htmlFunction(value){return function(){var v=value.apply(this,arguments);this.innerHTML=null==v?"":v}}function raise(){this.nextSibling&&this.parentNode.appendChild(this)}function lower(){this.previousSibling&&this.parentNode.insertBefore(this,this.parentNode.firstChild)}function constantNull(){return null}function remove(){var parent=this.parentNode;parent&&parent.removeChild(this)}function dispatchEvent(node,type,params){var window$$1=window(node),event=window$$1.CustomEvent;event?event=new event(type,params):(event=window$$1.document.createEvent("Event"),params?(event.initEvent(type,params.bubbles,params.cancelable),event.detail=params.detail):event.initEvent(type,!1,!1)),node.dispatchEvent(event)}function dispatchConstant(type,params){return function(){return dispatchEvent(this,type,params)}}function dispatchFunction(type,params){return function(){return dispatchEvent(this,type,params.apply(this,arguments))}}var root=[null];function Selection(groups,parents){this._groups=groups,this._parents=parents}function selection(){return new Selection([[document.documentElement]],root)}Selection.prototype=selection.prototype={constructor:Selection,select:function(select){"function"!=typeof select&&(select=selector(select));for(var groups=this._groups,m=groups.length,subgroups=new Array(m),j=0;j<m;++j)for(var node,subnode,group=groups[j],n=group.length,subgroup=subgroups[j]=new Array(n),i=0;i<n;++i)(node=group[i])&&(subnode=select.call(node,node.__data__,i,group))&&("__data__"in node&&(subnode.__data__=node.__data__),subgroup[i]=subnode);return new Selection(subgroups,this._parents)},selectAll:function(select){"function"!=typeof select&&(select=selectorAll(select));for(var groups=this._groups,m=groups.length,subgroups=[],parents=[],j=0;j<m;++j)for(var node,group=groups[j],n=group.length,i=0;i<n;++i)(node=group[i])&&(subgroups.push(select.call(node,node.__data__,i,group)),parents.push(node));return new Selection(subgroups,parents)},filter:function(match){"function"!=typeof match&&(match=matcher$1(match));for(var groups=this._groups,m=groups.length,subgroups=new Array(m),j=0;j<m;++j)for(var node,group=groups[j],n=group.length,subgroup=subgroups[j]=[],i=0;i<n;++i)(node=group[i])&&match.call(node,node.__data__,i,group)&&subgroup.push(node);return new Selection(subgroups,this._parents)},data:function(value,key){if(!value)return data=new Array(this.size()),j=-1,this.each((function(d){data[++j]=d})),data;var bind=key?bindKey:bindIndex,parents=this._parents,groups=this._groups;"function"!=typeof value&&(value=function(x){return function(){return x}}(value));for(var m=groups.length,update=new Array(m),enter=new Array(m),exit=new Array(m),j=0;j<m;++j){var parent=parents[j],group=groups[j],groupLength=group.length,data=value.call(parent,parent&&parent.__data__,j,parents),dataLength=data.length,enterGroup=enter[j]=new Array(dataLength),updateGroup=update[j]=new Array(dataLength);bind(parent,group,enterGroup,updateGroup,exit[j]=new Array(groupLength),data,key);for(var previous,next,i0=0,i1=0;i0<dataLength;++i0)if(previous=enterGroup[i0]){for(i0>=i1&&(i1=i0+1);!(next=updateGroup[i1])&&++i1<dataLength;);previous._next=next||null}}return(update=new Selection(update,parents))._enter=enter,update._exit=exit,update},enter:function(){return new Selection(this._enter||this._groups.map(sparse),this._parents)},exit:function(){return new Selection(this._exit||this._groups.map(sparse),this._parents)},merge:function(selection){for(var groups0=this._groups,groups1=selection._groups,m0=groups0.length,m1=groups1.length,m=Math.min(m0,m1),merges=new Array(m0),j=0;j<m;++j)for(var node,group0=groups0[j],group1=groups1[j],n=group0.length,merge=merges[j]=new Array(n),i=0;i<n;++i)(node=group0[i]||group1[i])&&(merge[i]=node);for(;j<m0;++j)merges[j]=groups0[j];return new Selection(merges,this._parents)},order:function(){for(var groups=this._groups,j=-1,m=groups.length;++j<m;)for(var node,group=groups[j],i=group.length-1,next=group[i];--i>=0;)(node=group[i])&&(next&&next!==node.nextSibling&&next.parentNode.insertBefore(node,next),next=node);return this},sort:function(compare){function compareNode(a,b){return a&&b?compare(a.__data__,b.__data__):!a-!b}compare||(compare=ascending$1);for(var groups=this._groups,m=groups.length,sortgroups=new Array(m),j=0;j<m;++j){for(var node,group=groups[j],n=group.length,sortgroup=sortgroups[j]=new Array(n),i=0;i<n;++i)(node=group[i])&&(sortgroup[i]=node);sortgroup.sort(compareNode)}return new Selection(sortgroups,this._parents).order()},call:function(){var callback=arguments[0];return arguments[0]=this,callback.apply(null,arguments),this},nodes:function(){var nodes=new Array(this.size()),i=-1;return this.each((function(){nodes[++i]=this})),nodes},node:function(){for(var groups=this._groups,j=0,m=groups.length;j<m;++j)for(var group=groups[j],i=0,n=group.length;i<n;++i){var node=group[i];if(node)return node}return null},size:function(){var size=0;return this.each((function(){++size})),size},empty:function(){return!this.node()},each:function(callback){for(var groups=this._groups,j=0,m=groups.length;j<m;++j)for(var node,group=groups[j],i=0,n=group.length;i<n;++i)(node=group[i])&&callback.call(node,node.__data__,i,group);return this},attr:function(name,value){var fullname=namespace(name);if(arguments.length<2){var node=this.node();return fullname.local?node.getAttributeNS(fullname.space,fullname.local):node.getAttribute(fullname)}return this.each((null==value?fullname.local?attrRemoveNS:attrRemove:"function"==typeof value?fullname.local?attrFunctionNS:attrFunction:fullname.local?attrConstantNS:attrConstant)(fullname,value))},style:function(name,value,priority){var node;return arguments.length>1?this.each((null==value?styleRemove:"function"==typeof value?styleFunction:styleConstant)(name,value,null==priority?"":priority)):window(node=this.node()).getComputedStyle(node,null).getPropertyValue(name)},property:function(name,value){return arguments.length>1?this.each((null==value?propertyRemove:"function"==typeof value?propertyFunction:propertyConstant)(name,value)):this.node()[name]},classed:function(name,value){var names=classArray(name+"");if(arguments.length<2){for(var list=classList(this.node()),i=-1,n=names.length;++i<n;)if(!list.contains(names[i]))return!1;return!0}return this.each(("function"==typeof value?classedFunction:value?classedTrue:classedFalse)(names,value))},text:function(value){return arguments.length?this.each(null==value?textRemove:("function"==typeof value?textFunction:textConstant)(value)):this.node().textContent},html:function(value){return arguments.length?this.each(null==value?htmlRemove:("function"==typeof value?htmlFunction:htmlConstant)(value)):this.node().innerHTML},raise:function(){return this.each(raise)},lower:function(){return this.each(lower)},append:function(name){var create="function"==typeof name?name:creator(name);return this.select((function(){return this.appendChild(create.apply(this,arguments))}))},insert:function(name,before){var create="function"==typeof name?name:creator(name),select=null==before?constantNull:"function"==typeof before?before:selector(before);return this.select((function(){return this.insertBefore(create.apply(this,arguments),select.apply(this,arguments)||null)}))},remove:function(){return this.each(remove)},datum:function(value){return arguments.length?this.property("__data__",value):this.node().__data__},on:function(typename,value,capture){var i,t,typenames=parseTypenames$1(typename+""),n=typenames.length;if(!(arguments.length<2)){for(on=value?onAdd:onRemove,null==capture&&(capture=!1),i=0;i<n;++i)this.each(on(typenames[i],value,capture));return this}var on=this.node().__on;if(on)for(var o,j=0,m=on.length;j<m;++j)for(i=0,o=on[j];i<n;++i)if((t=typenames[i]).type===o.type&&t.name===o.name)return o.value},dispatch:function(type,params){return this.each(("function"==typeof params?dispatchFunction:dispatchConstant)(type,params))}};var select=function(selector){return"string"==typeof selector?new Selection([[document.querySelector(selector)]],[document.documentElement]):new Selection([[selector]],root)},touch=function(node,touches,identifier){arguments.length<3&&(identifier=touches,touches=sourceEvent().changedTouches);for(var touch,i=0,n=touches?touches.length:0;i<n;++i)if((touch=touches[i]).identifier===identifier)return point(node,touch);return null};function nopropagation(){exports.event.stopImmediatePropagation()}var noevent=function(){exports.event.preventDefault(),exports.event.stopImmediatePropagation()},dragDisable=function(view){var root=view.document.documentElement,selection$$1=select(view).on("dragstart.drag",noevent,!0);"onselectstart"in root?selection$$1.on("selectstart.drag",noevent,!0):(root.__noselect=root.style.MozUserSelect,root.style.MozUserSelect="none")};function yesdrag(view,noclick){var root=view.document.documentElement,selection$$1=select(view).on("dragstart.drag",null);noclick&&(selection$$1.on("click.drag",noevent,!0),setTimeout((function(){selection$$1.on("click.drag",null)}),0)),"onselectstart"in root?selection$$1.on("selectstart.drag",null):(root.style.MozUserSelect=root.__noselect,delete root.__noselect)}var constant$2=function(x){return function(){return x}};function DragEvent(target,type,subject,id,active,x,y,dx,dy,dispatch){this.target=target,this.type=type,this.subject=subject,this.identifier=id,this.active=active,this.x=x,this.y=y,this.dx=dx,this.dy=dy,this._=dispatch}function defaultFilter$1(){return!exports.event.button}function defaultContainer(){return this.parentNode}function defaultSubject(d){return null==d?{x:exports.event.x,y:exports.event.y}:d}DragEvent.prototype.on=function(){var value=this._.on.apply(this._,arguments);return value===this._?this:value};var define=function(constructor,factory,prototype){constructor.prototype=factory.prototype=prototype,prototype.constructor=constructor};function extend(parent,definition){var prototype=Object.create(parent.prototype);for(var key in definition)prototype[key]=definition[key];return prototype}function Color(){}var reI="\\s*([+-]?\\d+)\\s*",reN="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",reP="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",reHex3=/^#([0-9a-f]{3})$/,reHex6=/^#([0-9a-f]{6})$/,reRgbInteger=new RegExp("^rgb\\("+[reI,reI,reI]+"\\)$"),reRgbPercent=new RegExp("^rgb\\("+[reP,reP,reP]+"\\)$"),reRgbaInteger=new RegExp("^rgba\\("+[reI,reI,reI,reN]+"\\)$"),reRgbaPercent=new RegExp("^rgba\\("+[reP,reP,reP,reN]+"\\)$"),reHslPercent=new RegExp("^hsl\\("+[reN,reP,reP]+"\\)$"),reHslaPercent=new RegExp("^hsla\\("+[reN,reP,reP,reN]+"\\)$"),named={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};function color(format){var m;return format=(format+"").trim().toLowerCase(),(m=reHex3.exec(format))?new Rgb((m=parseInt(m[1],16))>>8&15|m>>4&240,m>>4&15|240&m,(15&m)<<4|15&m,1):(m=reHex6.exec(format))?rgbn(parseInt(m[1],16)):(m=reRgbInteger.exec(format))?new Rgb(m[1],m[2],m[3],1):(m=reRgbPercent.exec(format))?new Rgb(255*m[1]/100,255*m[2]/100,255*m[3]/100,1):(m=reRgbaInteger.exec(format))?rgba(m[1],m[2],m[3],m[4]):(m=reRgbaPercent.exec(format))?rgba(255*m[1]/100,255*m[2]/100,255*m[3]/100,m[4]):(m=reHslPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,1):(m=reHslaPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,m[4]):named.hasOwnProperty(format)?rgbn(named[format]):"transparent"===format?new Rgb(NaN,NaN,NaN,0):null}function rgbn(n){return new Rgb(n>>16&255,n>>8&255,255&n,1)}function rgba(r,g,b,a){return a<=0&&(r=g=b=NaN),new Rgb(r,g,b,a)}function rgbConvert(o){return o instanceof Color||(o=color(o)),o?new Rgb((o=o.rgb()).r,o.g,o.b,o.opacity):new Rgb}function rgb(r,g,b,opacity){return 1===arguments.length?rgbConvert(r):new Rgb(r,g,b,null==opacity?1:opacity)}function Rgb(r,g,b,opacity){this.r=+r,this.g=+g,this.b=+b,this.opacity=+opacity}function hsla(h,s,l,a){return a<=0?h=s=l=NaN:l<=0||l>=1?h=s=NaN:s<=0&&(h=NaN),new Hsl(h,s,l,a)}function hslConvert(o){if(o instanceof Hsl)return new Hsl(o.h,o.s,o.l,o.opacity);if(o instanceof Color||(o=color(o)),!o)return new Hsl;if(o instanceof Hsl)return o;var r=(o=o.rgb()).r/255,g=o.g/255,b=o.b/255,min=Math.min(r,g,b),max=Math.max(r,g,b),h=NaN,s=max-min,l=(max+min)/2;return s?(h=r===max?(g-b)/s+6*(g<b):g===max?(b-r)/s+2:(r-g)/s+4,s/=l<.5?max+min:2-max-min,h*=60):s=l>0&&l<1?0:h,new Hsl(h,s,l,o.opacity)}function hsl(h,s,l,opacity){return 1===arguments.length?hslConvert(h):new Hsl(h,s,l,null==opacity?1:opacity)}function Hsl(h,s,l,opacity){this.h=+h,this.s=+s,this.l=+l,this.opacity=+opacity}function hsl2rgb(h,m1,m2){return 255*(h<60?m1+(m2-m1)*h/60:h<180?m2:h<240?m1+(m2-m1)*(240-h)/60:m1)}define(Color,color,{displayable:function(){return this.rgb().displayable()},toString:function(){return this.rgb()+""}}),define(Rgb,rgb,extend(Color,{brighter:function(k){return k=null==k?1/.7:Math.pow(1/.7,k),new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},darker:function(k){return k=null==k?.7:Math.pow(.7,k),new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},rgb:function(){return this},displayable:function(){return 0<=this.r&&this.r<=255&&0<=this.g&&this.g<=255&&0<=this.b&&this.b<=255&&0<=this.opacity&&this.opacity<=1},toString:function(){var a=this.opacity;return(1===(a=isNaN(a)?1:Math.max(0,Math.min(1,a)))?"rgb(":"rgba(")+Math.max(0,Math.min(255,Math.round(this.r)||0))+", "+Math.max(0,Math.min(255,Math.round(this.g)||0))+", "+Math.max(0,Math.min(255,Math.round(this.b)||0))+(1===a?")":", "+a+")")}})),define(Hsl,hsl,extend(Color,{brighter:function(k){return k=null==k?1/.7:Math.pow(1/.7,k),new Hsl(this.h,this.s,this.l*k,this.opacity)},darker:function(k){return k=null==k?.7:Math.pow(.7,k),new Hsl(this.h,this.s,this.l*k,this.opacity)},rgb:function(){var h=this.h%360+360*(this.h<0),s=isNaN(h)||isNaN(this.s)?0:this.s,l=this.l,m2=l+(l<.5?l:1-l)*s,m1=2*l-m2;return new Rgb(hsl2rgb(h>=240?h-240:h+120,m1,m2),hsl2rgb(h,m1,m2),hsl2rgb(h<120?h+240:h-120,m1,m2),this.opacity)},displayable:function(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&0<=this.l&&this.l<=1&&0<=this.opacity&&this.opacity<=1}}));var deg2rad=Math.PI/180,rad2deg=180/Math.PI,t1=6/29,t2=3*t1*t1;function labConvert(o){if(o instanceof Lab)return new Lab(o.l,o.a,o.b,o.opacity);if(o instanceof Hcl){var h=o.h*deg2rad;return new Lab(o.l,Math.cos(h)*o.c,Math.sin(h)*o.c,o.opacity)}o instanceof Rgb||(o=rgbConvert(o));var b=rgb2xyz(o.r),a=rgb2xyz(o.g),l=rgb2xyz(o.b),x=xyz2lab((.4124564*b+.3575761*a+.1804375*l)/.95047),y=xyz2lab((.2126729*b+.7151522*a+.072175*l)/1);return new Lab(116*y-16,500*(x-y),200*(y-xyz2lab((.0193339*b+.119192*a+.9503041*l)/1.08883)),o.opacity)}function lab(l,a,b,opacity){return 1===arguments.length?labConvert(l):new Lab(l,a,b,null==opacity?1:opacity)}function Lab(l,a,b,opacity){this.l=+l,this.a=+a,this.b=+b,this.opacity=+opacity}function xyz2lab(t){return t>.008856451679035631?Math.pow(t,1/3):t/t2+4/29}function lab2xyz(t){return t>t1?t*t*t:t2*(t-4/29)}function xyz2rgb(x){return 255*(x<=.0031308?12.92*x:1.055*Math.pow(x,1/2.4)-.055)}function rgb2xyz(x){return(x/=255)<=.04045?x/12.92:Math.pow((x+.055)/1.055,2.4)}function hclConvert(o){if(o instanceof Hcl)return new Hcl(o.h,o.c,o.l,o.opacity);o instanceof Lab||(o=labConvert(o));var h=Math.atan2(o.b,o.a)*rad2deg;return new Hcl(h<0?h+360:h,Math.sqrt(o.a*o.a+o.b*o.b),o.l,o.opacity)}function hcl(h,c,l,opacity){return 1===arguments.length?hclConvert(h):new Hcl(h,c,l,null==opacity?1:opacity)}function Hcl(h,c,l,opacity){this.h=+h,this.c=+c,this.l=+l,this.opacity=+opacity}define(Lab,lab,extend(Color,{brighter:function(k){return new Lab(this.l+18*(null==k?1:k),this.a,this.b,this.opacity)},darker:function(k){return new Lab(this.l-18*(null==k?1:k),this.a,this.b,this.opacity)},rgb:function(){var y=(this.l+16)/116,x=isNaN(this.a)?y:y+this.a/500,z=isNaN(this.b)?y:y-this.b/200;return y=1*lab2xyz(y),new Rgb(xyz2rgb(3.2404542*(x=.95047*lab2xyz(x))-1.5371385*y-.4985314*(z=1.08883*lab2xyz(z))),xyz2rgb(-.969266*x+1.8760108*y+.041556*z),xyz2rgb(.0556434*x-.2040259*y+1.0572252*z),this.opacity)}})),define(Hcl,hcl,extend(Color,{brighter:function(k){return new Hcl(this.h,this.c,this.l+18*(null==k?1:k),this.opacity)},darker:function(k){return new Hcl(this.h,this.c,this.l-18*(null==k?1:k),this.opacity)},rgb:function(){return labConvert(this).rgb()}}));var A=-.14861,B=1.78277,C=-.29227,D=-.90649,E=1.97294,ED=E*D,EB=E*B,BC_DA=B*C-D*A;function cubehelixConvert(o){if(o instanceof Cubehelix)return new Cubehelix(o.h,o.s,o.l,o.opacity);o instanceof Rgb||(o=rgbConvert(o));var r=o.r/255,g=o.g/255,b=o.b/255,l=(BC_DA*b+ED*r-EB*g)/(BC_DA+ED-EB),bl=b-l,k=(E*(g-l)-C*bl)/D,s=Math.sqrt(k*k+bl*bl)/(E*l*(1-l)),h=s?Math.atan2(k,bl)*rad2deg-120:NaN;return new Cubehelix(h<0?h+360:h,s,l,o.opacity)}function cubehelix(h,s,l,opacity){return 1===arguments.length?cubehelixConvert(h):new Cubehelix(h,s,l,null==opacity?1:opacity)}function Cubehelix(h,s,l,opacity){this.h=+h,this.s=+s,this.l=+l,this.opacity=+opacity}function basis(t1,v0,v1,v2,v3){var t2=t1*t1,t3=t2*t1;return((1-3*t1+3*t2-t3)*v0+(4-6*t2+3*t3)*v1+(1+3*t1+3*t2-3*t3)*v2+t3*v3)/6}define(Cubehelix,cubehelix,extend(Color,{brighter:function(k){return k=null==k?1/.7:Math.pow(1/.7,k),new Cubehelix(this.h,this.s,this.l*k,this.opacity)},darker:function(k){return k=null==k?.7:Math.pow(.7,k),new Cubehelix(this.h,this.s,this.l*k,this.opacity)},rgb:function(){var h=isNaN(this.h)?0:(this.h+120)*deg2rad,l=+this.l,a=isNaN(this.s)?0:this.s*l*(1-l),cosh=Math.cos(h),sinh=Math.sin(h);return new Rgb(255*(l+a*(A*cosh+B*sinh)),255*(l+a*(C*cosh+D*sinh)),255*(l+a*(E*cosh)),this.opacity)}}));var basis$1=function(values){var n=values.length-1;return function(t){var i=t<=0?t=0:t>=1?(t=1,n-1):Math.floor(t*n),v1=values[i],v2=values[i+1],v0=i>0?values[i-1]:2*v1-v2,v3=i<n-1?values[i+2]:2*v2-v1;return basis((t-i/n)*n,v0,v1,v2,v3)}},basisClosed=function(values){var n=values.length;return function(t){var i=Math.floor(((t%=1)<0?++t:t)*n),v0=values[(i+n-1)%n],v1=values[i%n],v2=values[(i+1)%n],v3=values[(i+2)%n];return basis((t-i/n)*n,v0,v1,v2,v3)}},constant$3=function(x){return function(){return x}};function linear(a,d){return function(t){return a+t*d}}function hue(a,b){var d=b-a;return d?linear(a,d>180||d<-180?d-360*Math.round(d/360):d):constant$3(isNaN(a)?b:a)}function gamma(y){return 1==(y=+y)?nogamma:function(a,b){return b-a?function exponential(a,b,y){return a=Math.pow(a,y),b=Math.pow(b,y)-a,y=1/y,function(t){return Math.pow(a+t*b,y)}}(a,b,y):constant$3(isNaN(a)?b:a)}}function nogamma(a,b){var d=b-a;return d?linear(a,d):constant$3(isNaN(a)?b:a)}var interpolateRgb=function rgbGamma(y){var color$$1=gamma(y);function rgb$$1(start,end){var r=color$$1((start=rgb(start)).r,(end=rgb(end)).r),g=color$$1(start.g,end.g),b=color$$1(start.b,end.b),opacity=nogamma(start.opacity,end.opacity);return function(t){return start.r=r(t),start.g=g(t),start.b=b(t),start.opacity=opacity(t),start+""}}return rgb$$1.gamma=rgbGamma,rgb$$1}(1);function rgbSpline(spline){return function(colors){var i,color$$1,n=colors.length,r=new Array(n),g=new Array(n),b=new Array(n);for(i=0;i<n;++i)color$$1=rgb(colors[i]),r[i]=color$$1.r||0,g[i]=color$$1.g||0,b[i]=color$$1.b||0;return r=spline(r),g=spline(g),b=spline(b),color$$1.opacity=1,function(t){return color$$1.r=r(t),color$$1.g=g(t),color$$1.b=b(t),color$$1+""}}}var rgbBasis=rgbSpline(basis$1),rgbBasisClosed=rgbSpline(basisClosed),array$1=function(a,b){var i,nb=b?b.length:0,na=a?Math.min(nb,a.length):0,x=new Array(nb),c=new Array(nb);for(i=0;i<na;++i)x[i]=interpolateValue(a[i],b[i]);for(;i<nb;++i)c[i]=b[i];return function(t){for(i=0;i<na;++i)c[i]=x[i](t);return c}},date=function(a,b){var d=new Date;return b-=a=+a,function(t){return d.setTime(a+b*t),d}},reinterpolate=function(a,b){return b-=a=+a,function(t){return a+b*t}},object=function(a,b){var k,i={},c={};for(k in null!==a&&"object"==typeof a||(a={}),null!==b&&"object"==typeof b||(b={}),b)k in a?i[k]=interpolateValue(a[k],b[k]):c[k]=b[k];return function(t){for(k in i)c[k]=i[k](t);return c}},reA=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,reB=new RegExp(reA.source,"g");var cssNode,cssRoot,cssView,svgNode,interpolateString=function(a,b){var am,bm,bs,bi=reA.lastIndex=reB.lastIndex=0,i=-1,s=[],q=[];for(a+="",b+="";(am=reA.exec(a))&&(bm=reB.exec(b));)(bs=bm.index)>bi&&(bs=b.slice(bi,bs),s[i]?s[i]+=bs:s[++i]=bs),(am=am[0])===(bm=bm[0])?s[i]?s[i]+=bm:s[++i]=bm:(s[++i]=null,q.push({i:i,x:reinterpolate(am,bm)})),bi=reB.lastIndex;return bi<b.length&&(bs=b.slice(bi),s[i]?s[i]+=bs:s[++i]=bs),s.length<2?q[0]?function one(b){return function(t){return b(t)+""}}(q[0].x):function zero(b){return function(){return b}}(b):(b=q.length,function(t){for(var o,i=0;i<b;++i)s[(o=q[i]).i]=o.x(t);return s.join("")})},interpolateValue=function(a,b){var c,t=typeof b;return null==b||"boolean"===t?constant$3(b):("number"===t?reinterpolate:"string"===t?(c=color(b))?(b=c,interpolateRgb):interpolateString:b instanceof color?interpolateRgb:b instanceof Date?date:Array.isArray(b)?array$1:isNaN(b)?object:reinterpolate)(a,b)},interpolateRound=function(a,b){return b-=a=+a,function(t){return Math.round(a+b*t)}},degrees=180/Math.PI,identity$2={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1},decompose=function(a,b,c,d,e,f){var scaleX,scaleY,skewX;return(scaleX=Math.sqrt(a*a+b*b))&&(a/=scaleX,b/=scaleX),(skewX=a*c+b*d)&&(c-=a*skewX,d-=b*skewX),(scaleY=Math.sqrt(c*c+d*d))&&(c/=scaleY,d/=scaleY,skewX/=scaleY),a*d<b*c&&(a=-a,b=-b,skewX=-skewX,scaleX=-scaleX),{translateX:e,translateY:f,rotate:Math.atan2(b,a)*degrees,skewX:Math.atan(skewX)*degrees,scaleX:scaleX,scaleY:scaleY}};function interpolateTransform(parse,pxComma,pxParen,degParen){function pop(s){return s.length?s.pop()+" ":""}return function(a,b){var s=[],q=[];return a=parse(a),b=parse(b),function translate(xa,ya,xb,yb,s,q){if(xa!==xb||ya!==yb){var i=s.push("translate(",null,pxComma,null,pxParen);q.push({i:i-4,x:reinterpolate(xa,xb)},{i:i-2,x:reinterpolate(ya,yb)})}else(xb||yb)&&s.push("translate("+xb+pxComma+yb+pxParen)}(a.translateX,a.translateY,b.translateX,b.translateY,s,q),function rotate(a,b,s,q){a!==b?(a-b>180?b+=360:b-a>180&&(a+=360),q.push({i:s.push(pop(s)+"rotate(",null,degParen)-2,x:reinterpolate(a,b)})):b&&s.push(pop(s)+"rotate("+b+degParen)}(a.rotate,b.rotate,s,q),function skewX(a,b,s,q){a!==b?q.push({i:s.push(pop(s)+"skewX(",null,degParen)-2,x:reinterpolate(a,b)}):b&&s.push(pop(s)+"skewX("+b+degParen)}(a.skewX,b.skewX,s,q),function scale(xa,ya,xb,yb,s,q){if(xa!==xb||ya!==yb){var i=s.push(pop(s)+"scale(",null,",",null,")");q.push({i:i-4,x:reinterpolate(xa,xb)},{i:i-2,x:reinterpolate(ya,yb)})}else 1===xb&&1===yb||s.push(pop(s)+"scale("+xb+","+yb+")")}(a.scaleX,a.scaleY,b.scaleX,b.scaleY,s,q),a=b=null,function(t){for(var o,i=-1,n=q.length;++i<n;)s[(o=q[i]).i]=o.x(t);return s.join("")}}}var interpolateTransformCss=interpolateTransform((function parseCss(value){return"none"===value?identity$2:(cssNode||(cssNode=document.createElement("DIV"),cssRoot=document.documentElement,cssView=document.defaultView),cssNode.style.transform=value,value=cssView.getComputedStyle(cssRoot.appendChild(cssNode),null).getPropertyValue("transform"),cssRoot.removeChild(cssNode),value=value.slice(7,-1).split(","),decompose(+value[0],+value[1],+value[2],+value[3],+value[4],+value[5]))}),"px, ","px)","deg)"),interpolateTransformSvg=interpolateTransform((function parseSvg(value){return null==value?identity$2:(svgNode||(svgNode=document.createElementNS("http://www.w3.org/2000/svg","g")),svgNode.setAttribute("transform",value),(value=svgNode.transform.baseVal.consolidate())?(value=value.matrix,decompose(value.a,value.b,value.c,value.d,value.e,value.f)):identity$2)}),", ",")",")"),rho=Math.SQRT2;function cosh(x){return((x=Math.exp(x))+1/x)/2}var interpolateZoom=function(p0,p1){var i,S,ux0=p0[0],uy0=p0[1],w0=p0[2],ux1=p1[0],uy1=p1[1],w1=p1[2],dx=ux1-ux0,dy=uy1-uy0,d2=dx*dx+dy*dy;if(d2<1e-12)S=Math.log(w1/w0)/rho,i=function(t){return[ux0+t*dx,uy0+t*dy,w0*Math.exp(rho*t*S)]};else{var d1=Math.sqrt(d2),b0=(w1*w1-w0*w0+4*d2)/(2*w0*2*d1),b1=(w1*w1-w0*w0-4*d2)/(2*w1*2*d1),r0=Math.log(Math.sqrt(b0*b0+1)-b0),r1=Math.log(Math.sqrt(b1*b1+1)-b1);S=(r1-r0)/rho,i=function(t){var s=t*S,coshr0=cosh(r0),u=w0/(2*d1)*(coshr0*function tanh(x){return((x=Math.exp(2*x))-1)/(x+1)}(rho*s+r0)-function sinh(x){return((x=Math.exp(x))-1/x)/2}(r0));return[ux0+u*dx,uy0+u*dy,w0*coshr0/cosh(rho*s+r0)]}}return i.duration=1e3*S,i};function hsl$1(hue$$1){return function(start,end){var h=hue$$1((start=hsl(start)).h,(end=hsl(end)).h),s=nogamma(start.s,end.s),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){return start.h=h(t),start.s=s(t),start.l=l(t),start.opacity=opacity(t),start+""}}}var hsl$2=hsl$1(hue),hslLong=hsl$1(nogamma);function hcl$1(hue$$1){return function(start,end){var h=hue$$1((start=hcl(start)).h,(end=hcl(end)).h),c=nogamma(start.c,end.c),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){return start.h=h(t),start.c=c(t),start.l=l(t),start.opacity=opacity(t),start+""}}}var hcl$2=hcl$1(hue),hclLong=hcl$1(nogamma);function cubehelix$1(hue$$1){return function cubehelixGamma(y){function cubehelix$$1(start,end){var h=hue$$1((start=cubehelix(start)).h,(end=cubehelix(end)).h),s=nogamma(start.s,end.s),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){return start.h=h(t),start.s=s(t),start.l=l(Math.pow(t,y)),start.opacity=opacity(t),start+""}}return y=+y,cubehelix$$1.gamma=cubehelixGamma,cubehelix$$1}(1)}var taskHead,taskTail,cubehelix$2=cubehelix$1(hue),cubehelixLong=cubehelix$1(nogamma),frame=0,timeout=0,interval=0,clockLast=0,clockNow=0,clockSkew=0,clock="object"==typeof performance&&performance.now?performance:Date,setFrame="function"==typeof requestAnimationFrame?requestAnimationFrame:function(f){setTimeout(f,17)};function now(){return clockNow||(setFrame(clearNow),clockNow=clock.now()+clockSkew)}function clearNow(){clockNow=0}function Timer(){this._call=this._time=this._next=null}function timer(callback,delay,time){var t=new Timer;return t.restart(callback,delay,time),t}function timerFlush(){now(),++frame;for(var e,t=taskHead;t;)(e=clockNow-t._time)>=0&&t._call.call(null,e),t=t._next;--frame}function wake(){clockNow=(clockLast=clock.now())+clockSkew,frame=timeout=0;try{timerFlush()}finally{frame=0,function nap(){var t0,t2,t1=taskHead,time=1/0;for(;t1;)t1._call?(time>t1._time&&(time=t1._time),t0=t1,t1=t1._next):(t2=t1._next,t1._next=null,t1=t0?t0._next=t2:taskHead=t2);taskTail=t0,sleep(time)}(),clockNow=0}}function poke(){var now=clock.now(),delay=now-clockLast;delay>1e3&&(clockSkew-=delay,clockLast=now)}function sleep(time){if(!frame){timeout&&(timeout=clearTimeout(timeout));var delay=time-clockNow;delay>24?(time<1/0&&(timeout=setTimeout(wake,delay)),interval&&(interval=clearInterval(interval))):(interval||(clockLast=clockNow,interval=setInterval(poke,1e3)),frame=1,setFrame(wake))}}Timer.prototype=timer.prototype={constructor:Timer,restart:function(callback,delay,time){if("function"!=typeof callback)throw new TypeError("callback is not a function");time=(null==time?now():+time)+(null==delay?0:+delay),this._next||taskTail===this||(taskTail?taskTail._next=this:taskHead=this,taskTail=this),this._call=callback,this._time=time,sleep()},stop:function(){this._call&&(this._call=null,this._time=1/0,sleep())}};var timeout$1=function(callback,delay,time){var t=new Timer;return delay=null==delay?0:+delay,t.restart((function(elapsed){t.stop(),callback(elapsed+delay)}),delay,time),t},emptyOn=dispatch("start","end","interrupt"),emptyTween=[],schedule=function(node,name,id,index,group,timing){var schedules=node.__transition;if(schedules){if(id in schedules)return}else node.__transition={};!function create(node,id,self){var tween,schedules=node.__transition;function start(elapsed){var i,j,n,o;if(1!==self.state)return stop();for(i in schedules)if((o=schedules[i]).name===self.name){if(3===o.state)return timeout$1(start);4===o.state?(o.state=6,o.timer.stop(),o.on.call("interrupt",node,node.__data__,o.index,o.group),delete schedules[i]):+i<id&&(o.state=6,o.timer.stop(),delete schedules[i])}if(timeout$1((function(){3===self.state&&(self.state=4,self.timer.restart(tick,self.delay,self.time),tick(elapsed))})),self.state=2,self.on.call("start",node,node.__data__,self.index,self.group),2===self.state){for(self.state=3,tween=new Array(n=self.tween.length),i=0,j=-1;i<n;++i)(o=self.tween[i].value.call(node,node.__data__,self.index,self.group))&&(tween[++j]=o);tween.length=j+1}}function tick(elapsed){for(var t=elapsed<self.duration?self.ease.call(null,elapsed/self.duration):(self.timer.restart(stop),self.state=5,1),i=-1,n=tween.length;++i<n;)tween[i].call(null,t);5===self.state&&(self.on.call("end",node,node.__data__,self.index,self.group),stop())}function stop(){for(var i in self.state=6,self.timer.stop(),delete schedules[id],schedules)return;delete node.__transition}schedules[id]=self,self.timer=timer((function schedule(elapsed){self.state=1,self.timer.restart(start,self.delay,self.time),self.delay<=elapsed&&start(elapsed-self.delay)}),0,self.time)}(node,id,{name:name,index:index,group:group,on:emptyOn,tween:emptyTween,time:timing.time,delay:timing.delay,duration:timing.duration,ease:timing.ease,timer:null,state:0})};function init(node,id){var schedule=node.__transition;if(!schedule||!(schedule=schedule[id])||schedule.state>0)throw new Error("too late");return schedule}function set$1(node,id){var schedule=node.__transition;if(!schedule||!(schedule=schedule[id])||schedule.state>2)throw new Error("too late");return schedule}function get$1(node,id){var schedule=node.__transition;if(!schedule||!(schedule=schedule[id]))throw new Error("too late");return schedule}var interrupt=function(node,name){var schedule,active,i,schedules=node.__transition,empty=!0;if(schedules){for(i in name=null==name?null:name+"",schedules)(schedule=schedules[i]).name===name?(active=schedule.state>2&&schedule.state<5,schedule.state=6,schedule.timer.stop(),active&&schedule.on.call("interrupt",node,node.__data__,schedule.index,schedule.group),delete schedules[i]):empty=!1;empty&&delete node.__transition}};function tweenRemove(id,name){var tween0,tween1;return function(){var schedule=set$1(this,id),tween=schedule.tween;if(tween!==tween0)for(var i=0,n=(tween1=tween0=tween).length;i<n;++i)if(tween1[i].name===name){(tween1=tween1.slice()).splice(i,1);break}schedule.tween=tween1}}function tweenFunction(id,name,value){var tween0,tween1;if("function"!=typeof value)throw new Error;return function(){var schedule=set$1(this,id),tween=schedule.tween;if(tween!==tween0){tween1=(tween0=tween).slice();for(var t={name:name,value:value},i=0,n=tween1.length;i<n;++i)if(tween1[i].name===name){tween1[i]=t;break}i===n&&tween1.push(t)}schedule.tween=tween1}}function tweenValue(transition,name,value){var id=transition._id;return transition.each((function(){var schedule=set$1(this,id);(schedule.value||(schedule.value={}))[name]=value.apply(this,arguments)})),function(node){return get$1(node,id).value[name]}}var interpolate$$1=function(a,b){var c;return("number"==typeof b?reinterpolate:b instanceof color?interpolateRgb:(c=color(b))?(b=c,interpolateRgb):interpolateString)(a,b)};function attrRemove$1(name){return function(){this.removeAttribute(name)}}function attrRemoveNS$1(fullname){return function(){this.removeAttributeNS(fullname.space,fullname.local)}}function attrConstant$1(name,interpolate$$1,value1){var value00,interpolate0;return function(){var value0=this.getAttribute(name);return value0===value1?null:value0===value00?interpolate0:interpolate0=interpolate$$1(value00=value0,value1)}}function attrConstantNS$1(fullname,interpolate$$1,value1){var value00,interpolate0;return function(){var value0=this.getAttributeNS(fullname.space,fullname.local);return value0===value1?null:value0===value00?interpolate0:interpolate0=interpolate$$1(value00=value0,value1)}}function attrFunction$1(name,interpolate$$1,value){var value00,value10,interpolate0;return function(){var value0,value1=value(this);if(null!=value1)return(value0=this.getAttribute(name))===value1?null:value0===value00&&value1===value10?interpolate0:interpolate0=interpolate$$1(value00=value0,value10=value1);this.removeAttribute(name)}}function attrFunctionNS$1(fullname,interpolate$$1,value){var value00,value10,interpolate0;return function(){var value0,value1=value(this);if(null!=value1)return(value0=this.getAttributeNS(fullname.space,fullname.local))===value1?null:value0===value00&&value1===value10?interpolate0:interpolate0=interpolate$$1(value00=value0,value10=value1);this.removeAttributeNS(fullname.space,fullname.local)}}function attrTweenNS(fullname,value){function tween(){var node=this,i=value.apply(node,arguments);return i&&function(t){node.setAttributeNS(fullname.space,fullname.local,i(t))}}return tween._value=value,tween}function attrTween(name,value){function tween(){var node=this,i=value.apply(node,arguments);return i&&function(t){node.setAttribute(name,i(t))}}return tween._value=value,tween}function delayFunction(id,value){return function(){init(this,id).delay=+value.apply(this,arguments)}}function delayConstant(id,value){return value=+value,function(){init(this,id).delay=value}}function durationFunction(id,value){return function(){set$1(this,id).duration=+value.apply(this,arguments)}}function durationConstant(id,value){return value=+value,function(){set$1(this,id).duration=value}}function easeConstant(id,value){if("function"!=typeof value)throw new Error;return function(){set$1(this,id).ease=value}}function onFunction(id,name,listener){var on0,on1,sit=function start(name){return(name+"").trim().split(/^|\s+/).every((function(t){var i=t.indexOf(".");return i>=0&&(t=t.slice(0,i)),!t||"start"===t}))}(name)?init:set$1;return function(){var schedule=sit(this,id),on=schedule.on;on!==on0&&(on1=(on0=on).copy()).on(name,listener),schedule.on=on1}}var Selection$1=selection.prototype.constructor;function styleTween(name,value,priority){function tween(){var node=this,i=value.apply(node,arguments);return i&&function(t){node.style.setProperty(name,i(t),priority)}}return tween._value=value,tween}var id=0;function Transition(groups,parents,name,id){this._groups=groups,this._parents=parents,this._name=name,this._id=id}function transition(name){return selection().transition(name)}function newId(){return++id}var selection_prototype=selection.prototype;function quadInOut(t){return((t*=2)<=1?t*t:--t*(2-t)+1)/2}function cubicInOut(t){return((t*=2)<=1?t*t*t:(t-=2)*t*t+2)/2}Transition.prototype=transition.prototype={constructor:Transition,select:function(select$$1){var name=this._name,id=this._id;"function"!=typeof select$$1&&(select$$1=selector(select$$1));for(var groups=this._groups,m=groups.length,subgroups=new Array(m),j=0;j<m;++j)for(var node,subnode,group=groups[j],n=group.length,subgroup=subgroups[j]=new Array(n),i=0;i<n;++i)(node=group[i])&&(subnode=select$$1.call(node,node.__data__,i,group))&&("__data__"in node&&(subnode.__data__=node.__data__),subgroup[i]=subnode,schedule(subgroup[i],name,id,i,subgroup,get$1(node,id)));return new Transition(subgroups,this._parents,name,id)},selectAll:function(select$$1){var name=this._name,id=this._id;"function"!=typeof select$$1&&(select$$1=selectorAll(select$$1));for(var groups=this._groups,m=groups.length,subgroups=[],parents=[],j=0;j<m;++j)for(var node,group=groups[j],n=group.length,i=0;i<n;++i)if(node=group[i]){for(var child,children=select$$1.call(node,node.__data__,i,group),inherit=get$1(node,id),k=0,l=children.length;k<l;++k)(child=children[k])&&schedule(child,name,id,k,children,inherit);subgroups.push(children),parents.push(node)}return new Transition(subgroups,parents,name,id)},filter:function(match){"function"!=typeof match&&(match=matcher$1(match));for(var groups=this._groups,m=groups.length,subgroups=new Array(m),j=0;j<m;++j)for(var node,group=groups[j],n=group.length,subgroup=subgroups[j]=[],i=0;i<n;++i)(node=group[i])&&match.call(node,node.__data__,i,group)&&subgroup.push(node);return new Transition(subgroups,this._parents,this._name,this._id)},merge:function(transition){if(transition._id!==this._id)throw new Error;for(var groups0=this._groups,groups1=transition._groups,m0=groups0.length,m1=groups1.length,m=Math.min(m0,m1),merges=new Array(m0),j=0;j<m;++j)for(var node,group0=groups0[j],group1=groups1[j],n=group0.length,merge=merges[j]=new Array(n),i=0;i<n;++i)(node=group0[i]||group1[i])&&(merge[i]=node);for(;j<m0;++j)merges[j]=groups0[j];return new Transition(merges,this._parents,this._name,this._id)},selection:function(){return new Selection$1(this._groups,this._parents)},transition:function(){for(var name=this._name,id0=this._id,id1=newId(),groups=this._groups,m=groups.length,j=0;j<m;++j)for(var node,group=groups[j],n=group.length,i=0;i<n;++i)if(node=group[i]){var inherit=get$1(node,id0);schedule(node,name,id1,i,group,{time:inherit.time+inherit.delay+inherit.duration,delay:0,duration:inherit.duration,ease:inherit.ease})}return new Transition(groups,this._parents,name,id1)},call:selection_prototype.call,nodes:selection_prototype.nodes,node:selection_prototype.node,size:selection_prototype.size,empty:selection_prototype.empty,each:selection_prototype.each,on:function(name,listener){var id=this._id;return arguments.length<2?get$1(this.node(),id).on.on(name):this.each(onFunction(id,name,listener))},attr:function(name,value){var fullname=namespace(name),i="transform"===fullname?interpolateTransformSvg:interpolate$$1;return this.attrTween(name,"function"==typeof value?(fullname.local?attrFunctionNS$1:attrFunction$1)(fullname,i,tweenValue(this,"attr."+name,value)):null==value?(fullname.local?attrRemoveNS$1:attrRemove$1)(fullname):(fullname.local?attrConstantNS$1:attrConstant$1)(fullname,i,value+""))},attrTween:function(name,value){var key="attr."+name;if(arguments.length<2)return(key=this.tween(key))&&key._value;if(null==value)return this.tween(key,null);if("function"!=typeof value)throw new Error;var fullname=namespace(name);return this.tween(key,(fullname.local?attrTweenNS:attrTween)(fullname,value))},style:function(name,value,priority){var i="transform"==(name+="")?interpolateTransformCss:interpolate$$1;return null==value?this.styleTween(name,function styleRemove$1(name,interpolate$$2){var value00,value10,interpolate0;return function(){var style=window(this).getComputedStyle(this,null),value0=style.getPropertyValue(name),value1=(this.style.removeProperty(name),style.getPropertyValue(name));return value0===value1?null:value0===value00&&value1===value10?interpolate0:interpolate0=interpolate$$2(value00=value0,value10=value1)}}(name,i)).on("end.style."+name,function styleRemoveEnd(name){return function(){this.style.removeProperty(name)}}(name)):this.styleTween(name,"function"==typeof value?function styleFunction$1(name,interpolate$$2,value){var value00,value10,interpolate0;return function(){var style=window(this).getComputedStyle(this,null),value0=style.getPropertyValue(name),value1=value(this);return null==value1&&(this.style.removeProperty(name),value1=style.getPropertyValue(name)),value0===value1?null:value0===value00&&value1===value10?interpolate0:interpolate0=interpolate$$2(value00=value0,value10=value1)}}(name,i,tweenValue(this,"style."+name,value)):function styleConstant$1(name,interpolate$$2,value1){var value00,interpolate0;return function(){var value0=window(this).getComputedStyle(this,null).getPropertyValue(name);return value0===value1?null:value0===value00?interpolate0:interpolate0=interpolate$$2(value00=value0,value1)}}(name,i,value+""),priority)},styleTween:function(name,value,priority){var key="style."+(name+="");if(arguments.length<2)return(key=this.tween(key))&&key._value;if(null==value)return this.tween(key,null);if("function"!=typeof value)throw new Error;return this.tween(key,styleTween(name,value,null==priority?"":priority))},text:function(value){return this.tween("text","function"==typeof value?function textFunction$1(value){return function(){var value1=value(this);this.textContent=null==value1?"":value1}}(tweenValue(this,"text",value)):function textConstant$1(value){return function(){this.textContent=value}}(null==value?"":value+""))},remove:function(){return this.on("end.remove",function removeFunction(id){return function(){var parent=this.parentNode;for(var i in this.__transition)if(+i!==id)return;parent&&parent.removeChild(this)}}(this._id))},tween:function(name,value){var id=this._id;if(name+="",arguments.length<2){for(var t,tween=get$1(this.node(),id).tween,i=0,n=tween.length;i<n;++i)if((t=tween[i]).name===name)return t.value;return null}return this.each((null==value?tweenRemove:tweenFunction)(id,name,value))},delay:function(value){var id=this._id;return arguments.length?this.each(("function"==typeof value?delayFunction:delayConstant)(id,value)):get$1(this.node(),id).delay},duration:function(value){var id=this._id;return arguments.length?this.each(("function"==typeof value?durationFunction:durationConstant)(id,value)):get$1(this.node(),id).duration},ease:function(value){var id=this._id;return arguments.length?this.each(easeConstant(id,value)):get$1(this.node(),id).ease}};var polyIn=function custom(e){function polyIn(t){return Math.pow(t,e)}return e=+e,polyIn.exponent=custom,polyIn}(3),polyOut=function custom(e){function polyOut(t){return 1-Math.pow(1-t,e)}return e=+e,polyOut.exponent=custom,polyOut}(3),polyInOut=function custom(e){function polyInOut(t){return((t*=2)<=1?Math.pow(t,e):2-Math.pow(2-t,e))/2}return e=+e,polyInOut.exponent=custom,polyInOut}(3),pi=Math.PI,halfPi=pi/2;function sinInOut(t){return(1-Math.cos(pi*t))/2}function expInOut(t){return((t*=2)<=1?Math.pow(2,10*t-10):2-Math.pow(2,10-10*t))/2}function circleInOut(t){return((t*=2)<=1?1-Math.sqrt(1-t*t):Math.sqrt(1-(t-=2)*t)+1)/2}var b0=7.5625;function bounceOut(t){return(t=+t)<4/11?b0*t*t:t<8/11?b0*(t-=6/11)*t+3/4:t<10/11?b0*(t-=9/11)*t+15/16:b0*(t-=21/22)*t+63/64}var backIn=function custom(s){function backIn(t){return t*t*((s+1)*t-s)}return s=+s,backIn.overshoot=custom,backIn}(1.70158),backOut=function custom(s){function backOut(t){return--t*t*((s+1)*t+s)+1}return s=+s,backOut.overshoot=custom,backOut}(1.70158),backInOut=function custom(s){function backInOut(t){return((t*=2)<1?t*t*((s+1)*t-s):(t-=2)*t*((s+1)*t+s)+2)/2}return s=+s,backInOut.overshoot=custom,backInOut}(1.70158),tau=2*Math.PI,elasticIn=function custom(a,p){var s=Math.asin(1/(a=Math.max(1,a)))*(p/=tau);function elasticIn(t){return a*Math.pow(2,10*--t)*Math.sin((s-t)/p)}return elasticIn.amplitude=function(a){return custom(a,p*tau)},elasticIn.period=function(p){return custom(a,p)},elasticIn}(1,.3),elasticOut=function custom(a,p){var s=Math.asin(1/(a=Math.max(1,a)))*(p/=tau);function elasticOut(t){return 1-a*Math.pow(2,-10*(t=+t))*Math.sin((t+s)/p)}return elasticOut.amplitude=function(a){return custom(a,p*tau)},elasticOut.period=function(p){return custom(a,p)},elasticOut}(1,.3),elasticInOut=function custom(a,p){var s=Math.asin(1/(a=Math.max(1,a)))*(p/=tau);function elasticInOut(t){return((t=2*t-1)<0?a*Math.pow(2,10*t)*Math.sin((s-t)/p):2-a*Math.pow(2,-10*t)*Math.sin((s+t)/p))/2}return elasticInOut.amplitude=function(a){return custom(a,p*tau)},elasticInOut.period=function(p){return custom(a,p)},elasticInOut}(1,.3),defaultTiming={time:null,delay:0,duration:250,ease:cubicInOut};function inherit(node,id){for(var timing;!(timing=node.__transition)||!(timing=timing[id]);)if(!(node=node.parentNode))return defaultTiming.time=now(),defaultTiming;return timing}selection.prototype.interrupt=function(name){return this.each((function(){interrupt(this,name)}))},selection.prototype.transition=function(name){var id,timing;name instanceof Transition?(id=name._id,name=name._name):(id=newId(),(timing=defaultTiming).time=now(),name=null==name?null:name+"");for(var groups=this._groups,m=groups.length,j=0;j<m;++j)for(var node,group=groups[j],n=group.length,i=0;i<n;++i)(node=group[i])&&schedule(node,name,id,i,group,timing||inherit(node,id));return new Transition(groups,this._parents,name,id)};var root$1=[null],constant$4=function(x){return function(){return x}},BrushEvent=function(target,type,selection){this.target=target,this.type=type,this.selection=selection};function nopropagation$1(){exports.event.stopImmediatePropagation()}var noevent$1=function(){exports.event.preventDefault(),exports.event.stopImmediatePropagation()},MODE_DRAG={name:"drag"},MODE_SPACE={name:"space"},MODE_HANDLE={name:"handle"},MODE_CENTER={name:"center"},X={name:"x",handles:["e","w"].map(type),input:function(x,e){return x&&[[x[0],e[0][1]],[x[1],e[1][1]]]},output:function(xy){return xy&&[xy[0][0],xy[1][0]]}},Y={name:"y",handles:["n","s"].map(type),input:function(y,e){return y&&[[e[0][0],y[0]],[e[1][0],y[1]]]},output:function(xy){return xy&&[xy[0][1],xy[1][1]]}},XY={name:"xy",handles:["n","e","s","w","nw","ne","se","sw"].map(type),input:function(xy){return xy},output:function(xy){return xy}},cursors={overlay:"crosshair",selection:"move",n:"ns-resize",e:"ew-resize",s:"ns-resize",w:"ew-resize",nw:"nwse-resize",ne:"nesw-resize",se:"nwse-resize",sw:"nesw-resize"},flipX={e:"w",w:"e",nw:"ne",ne:"nw",se:"sw",sw:"se"},flipY={n:"s",s:"n",nw:"sw",ne:"se",se:"ne",sw:"nw"},signsX={overlay:1,selection:1,n:null,e:1,s:null,w:-1,nw:-1,ne:1,se:1,sw:-1},signsY={overlay:1,selection:1,n:-1,e:null,s:1,w:null,nw:-1,ne:-1,se:1,sw:1};function type(t){return{type:t}}function defaultFilter(){return!exports.event.button}function defaultExtent(){var svg=this.ownerSVGElement||this;return[[0,0],[svg.width.baseVal.value,svg.height.baseVal.value]]}function local$$1(node){for(;!node.__brush;)if(!(node=node.parentNode))return;return node.__brush}function empty(extent){return extent[0][0]===extent[1][0]||extent[0][1]===extent[1][1]}function brush$1(dim){var touchending,extent=defaultExtent,filter=defaultFilter,listeners=dispatch(brush,"start","brush","end"),handleSize=6;function brush(group){var overlay=group.property("__brush",initialize).selectAll(".overlay").data([type("overlay")]);overlay.enter().append("rect").attr("class","overlay").attr("pointer-events","all").attr("cursor",cursors.overlay).merge(overlay).each((function(){var extent=local$$1(this).extent;select(this).attr("x",extent[0][0]).attr("y",extent[0][1]).attr("width",extent[1][0]-extent[0][0]).attr("height",extent[1][1]-extent[0][1])})),group.selectAll(".selection").data([type("selection")]).enter().append("rect").attr("class","selection").attr("cursor",cursors.selection).attr("fill","#777").attr("fill-opacity",.3).attr("stroke","#fff").attr("shape-rendering","crispEdges");var handle=group.selectAll(".handle").data(dim.handles,(function(d){return d.type}));handle.exit().remove(),handle.enter().append("rect").attr("class",(function(d){return"handle handle--"+d.type})).attr("cursor",(function(d){return cursors[d.type]})),group.each(redraw).attr("fill","none").attr("pointer-events","all").style("-webkit-tap-highlight-color","rgba(0,0,0,0)").on("mousedown.brush touchstart.brush",started)}function redraw(){var group=select(this),selection$$1=local$$1(this).selection;selection$$1?(group.selectAll(".selection").style("display",null).attr("x",selection$$1[0][0]).attr("y",selection$$1[0][1]).attr("width",selection$$1[1][0]-selection$$1[0][0]).attr("height",selection$$1[1][1]-selection$$1[0][1]),group.selectAll(".handle").style("display",null).attr("x",(function(d){return"e"===d.type[d.type.length-1]?selection$$1[1][0]-handleSize/2:selection$$1[0][0]-handleSize/2})).attr("y",(function(d){return"s"===d.type[0]?selection$$1[1][1]-handleSize/2:selection$$1[0][1]-handleSize/2})).attr("width",(function(d){return"n"===d.type||"s"===d.type?selection$$1[1][0]-selection$$1[0][0]+handleSize:handleSize})).attr("height",(function(d){return"e"===d.type||"w"===d.type?selection$$1[1][1]-selection$$1[0][1]+handleSize:handleSize}))):group.selectAll(".selection,.handle").style("display","none").attr("x",null).attr("y",null).attr("width",null).attr("height",null)}function emitter(that,args){return that.__brush.emitter||new Emitter(that,args)}function Emitter(that,args){this.that=that,this.args=args,this.state=that.__brush,this.active=0}function started(){if(exports.event.touches){if(exports.event.changedTouches.length<exports.event.touches.length)return noevent$1()}else if(touchending)return;if(filter.apply(this,arguments)){var w0,w1,n0,n1,e0,e1,s0,s1,dx,dy,moving,lockX,lockY,that=this,type=exports.event.target.__data__.type,mode="selection"===(exports.event.metaKey?type="overlay":type)?MODE_DRAG:exports.event.altKey?MODE_CENTER:MODE_HANDLE,signX=dim===Y?null:signsX[type],signY=dim===X?null:signsY[type],state=local$$1(that),extent=state.extent,selection$$1=state.selection,W=extent[0][0],N=extent[0][1],E=extent[1][0],S=extent[1][1],shifting=signX&&signY&&exports.event.shiftKey,point0=mouse(that),point=point0,emit=emitter(that,arguments).beforestart();"overlay"===type?state.selection=selection$$1=[[w0=dim===Y?W:point0[0],n0=dim===X?N:point0[1]],[e0=dim===Y?E:w0,s0=dim===X?S:n0]]:(w0=selection$$1[0][0],n0=selection$$1[0][1],e0=selection$$1[1][0],s0=selection$$1[1][1]),w1=w0,n1=n0,e1=e0,s1=s0;var group=select(that).attr("pointer-events","none"),overlay=group.selectAll(".overlay").attr("cursor",cursors[type]);if(exports.event.touches)group.on("touchmove.brush",moved,!0).on("touchend.brush touchcancel.brush",ended,!0);else{var view=select(exports.event.view).on("keydown.brush",keydowned,!0).on("keyup.brush",keyupped,!0).on("mousemove.brush",moved,!0).on("mouseup.brush",ended,!0);dragDisable(exports.event.view)}nopropagation$1(),interrupt(that),redraw.call(that),emit.start()}function moved(){var point1=mouse(that);!shifting||lockX||lockY||(Math.abs(point1[0]-point[0])>Math.abs(point1[1]-point[1])?lockY=!0:lockX=!0),point=point1,moving=!0,noevent$1(),move()}function move(){var t;switch(dx=point[0]-point0[0],dy=point[1]-point0[1],mode){case MODE_SPACE:case MODE_DRAG:signX&&(dx=Math.max(W-w0,Math.min(E-e0,dx)),w1=w0+dx,e1=e0+dx),signY&&(dy=Math.max(N-n0,Math.min(S-s0,dy)),n1=n0+dy,s1=s0+dy);break;case MODE_HANDLE:signX<0?(dx=Math.max(W-w0,Math.min(E-w0,dx)),w1=w0+dx,e1=e0):signX>0&&(dx=Math.max(W-e0,Math.min(E-e0,dx)),w1=w0,e1=e0+dx),signY<0?(dy=Math.max(N-n0,Math.min(S-n0,dy)),n1=n0+dy,s1=s0):signY>0&&(dy=Math.max(N-s0,Math.min(S-s0,dy)),n1=n0,s1=s0+dy);break;case MODE_CENTER:signX&&(w1=Math.max(W,Math.min(E,w0-dx*signX)),e1=Math.max(W,Math.min(E,e0+dx*signX))),signY&&(n1=Math.max(N,Math.min(S,n0-dy*signY)),s1=Math.max(N,Math.min(S,s0+dy*signY)))}e1<w1&&(signX*=-1,t=w0,w0=e0,e0=t,t=w1,w1=e1,e1=t,type in flipX&&overlay.attr("cursor",cursors[type=flipX[type]])),s1<n1&&(signY*=-1,t=n0,n0=s0,s0=t,t=n1,n1=s1,s1=t,type in flipY&&overlay.attr("cursor",cursors[type=flipY[type]])),state.selection&&(selection$$1=state.selection),lockX&&(w1=selection$$1[0][0],e1=selection$$1[1][0]),lockY&&(n1=selection$$1[0][1],s1=selection$$1[1][1]),selection$$1[0][0]===w1&&selection$$1[0][1]===n1&&selection$$1[1][0]===e1&&selection$$1[1][1]===s1||(state.selection=[[w1,n1],[e1,s1]],redraw.call(that),emit.brush())}function ended(){if(nopropagation$1(),exports.event.touches){if(exports.event.touches.length)return;touchending&&clearTimeout(touchending),touchending=setTimeout((function(){touchending=null}),500),group.on("touchmove.brush touchend.brush touchcancel.brush",null)}else yesdrag(exports.event.view,moving),view.on("keydown.brush keyup.brush mousemove.brush mouseup.brush",null);group.attr("pointer-events","all"),overlay.attr("cursor",cursors.overlay),state.selection&&(selection$$1=state.selection),empty(selection$$1)&&(state.selection=null,redraw.call(that)),emit.end()}function keydowned(){switch(exports.event.keyCode){case 16:shifting=signX&&signY;break;case 18:mode===MODE_HANDLE&&(signX&&(e0=e1-dx*signX,w0=w1+dx*signX),signY&&(s0=s1-dy*signY,n0=n1+dy*signY),mode=MODE_CENTER,move());break;case 32:mode!==MODE_HANDLE&&mode!==MODE_CENTER||(signX<0?e0=e1-dx:signX>0&&(w0=w1-dx),signY<0?s0=s1-dy:signY>0&&(n0=n1-dy),mode=MODE_SPACE,overlay.attr("cursor",cursors.selection),move());break;default:return}noevent$1()}function keyupped(){switch(exports.event.keyCode){case 16:shifting&&(lockX=lockY=shifting=!1,move());break;case 18:mode===MODE_CENTER&&(signX<0?e0=e1:signX>0&&(w0=w1),signY<0?s0=s1:signY>0&&(n0=n1),mode=MODE_HANDLE,move());break;case 32:mode===MODE_SPACE&&(exports.event.altKey?(signX&&(e0=e1-dx*signX,w0=w1+dx*signX),signY&&(s0=s1-dy*signY,n0=n1+dy*signY),mode=MODE_CENTER):(signX<0?e0=e1:signX>0&&(w0=w1),signY<0?s0=s1:signY>0&&(n0=n1),mode=MODE_HANDLE),overlay.attr("cursor",cursors[type]),move());break;default:return}noevent$1()}}function initialize(){var state=this.__brush||{selection:null};return state.extent=extent.apply(this,arguments),state.dim=dim,state}return brush.move=function(group,selection$$1){group.selection?group.on("start.brush",(function(){emitter(this,arguments).beforestart().start()})).on("interrupt.brush end.brush",(function(){emitter(this,arguments).end()})).tween("brush",(function(){var that=this,state=that.__brush,emit=emitter(that,arguments),selection0=state.selection,selection1=dim.input("function"==typeof selection$$1?selection$$1.apply(this,arguments):selection$$1,state.extent),i=interpolateValue(selection0,selection1);function tween(t){state.selection=1===t&&empty(selection1)?null:i(t),redraw.call(that),emit.brush()}return selection0&&selection1?tween:tween(1)})):group.each((function(){var that=this,args=arguments,state=that.__brush,selection1=dim.input("function"==typeof selection$$1?selection$$1.apply(that,args):selection$$1,state.extent),emit=emitter(that,args).beforestart();interrupt(that),state.selection=null==selection1||empty(selection1)?null:selection1,redraw.call(that),emit.start().brush().end()}))},Emitter.prototype={beforestart:function(){return 1==++this.active&&(this.state.emitter=this,this.starting=!0),this},start:function(){return this.starting&&(this.starting=!1,this.emit("start")),this},brush:function(){return this.emit("brush"),this},end:function(){return 0==--this.active&&(delete this.state.emitter,this.emit("end")),this},emit:function(type){customEvent(new BrushEvent(brush,type,dim.output(this.state.selection)),listeners.apply,listeners,[type,this.that,this.args])}},brush.extent=function(_){return arguments.length?(extent="function"==typeof _?_:constant$4([[+_[0][0],+_[0][1]],[+_[1][0],+_[1][1]]]),brush):extent},brush.filter=function(_){return arguments.length?(filter="function"==typeof _?_:constant$4(!!_),brush):filter},brush.handleSize=function(_){return arguments.length?(handleSize=+_,brush):handleSize},brush.on=function(){var value=listeners.on.apply(listeners,arguments);return value===listeners?brush:value},brush}var cos=Math.cos,sin=Math.sin,pi$1=Math.PI,halfPi$1=pi$1/2,tau$1=2*pi$1,max$1=Math.max;function compareValue(compare){return function(a,b){return compare(a.source.value+a.target.value,b.source.value+b.target.value)}}var slice$2=Array.prototype.slice,constant$5=function(x){return function(){return x}},pi$2=Math.PI,tau$2=2*pi$2,tauEpsilon=tau$2-1e-6;function Path(){this._x0=this._y0=this._x1=this._y1=null,this._=""}function path(){return new Path}function defaultSource(d){return d.source}function defaultTarget(d){return d.target}function defaultRadius(d){return d.radius}function defaultStartAngle(d){return d.startAngle}function defaultEndAngle(d){return d.endAngle}Path.prototype=path.prototype={constructor:Path,moveTo:function(x,y){this._+="M"+(this._x0=this._x1=+x)+","+(this._y0=this._y1=+y)},closePath:function(){null!==this._x1&&(this._x1=this._x0,this._y1=this._y0,this._+="Z")},lineTo:function(x,y){this._+="L"+(this._x1=+x)+","+(this._y1=+y)},quadraticCurveTo:function(x1,y1,x,y){this._+="Q"+ +x1+","+ +y1+","+(this._x1=+x)+","+(this._y1=+y)},bezierCurveTo:function(x1,y1,x2,y2,x,y){this._+="C"+ +x1+","+ +y1+","+ +x2+","+ +y2+","+(this._x1=+x)+","+(this._y1=+y)},arcTo:function(x1,y1,x2,y2,r){x1=+x1,y1=+y1,x2=+x2,y2=+y2,r=+r;var x0=this._x1,y0=this._y1,x21=x2-x1,y21=y2-y1,x01=x0-x1,y01=y0-y1,l01_2=x01*x01+y01*y01;if(r<0)throw new Error("negative radius: "+r);if(null===this._x1)this._+="M"+(this._x1=x1)+","+(this._y1=y1);else if(l01_2>1e-6)if(Math.abs(y01*x21-y21*x01)>1e-6&&r){var x20=x2-x0,y20=y2-y0,l21_2=x21*x21+y21*y21,l20_2=x20*x20+y20*y20,l21=Math.sqrt(l21_2),l01=Math.sqrt(l01_2),l=r*Math.tan((pi$2-Math.acos((l21_2+l01_2-l20_2)/(2*l21*l01)))/2),t01=l/l01,t21=l/l21;Math.abs(t01-1)>1e-6&&(this._+="L"+(x1+t01*x01)+","+(y1+t01*y01)),this._+="A"+r+","+r+",0,0,"+ +(y01*x20>x01*y20)+","+(this._x1=x1+t21*x21)+","+(this._y1=y1+t21*y21)}else this._+="L"+(this._x1=x1)+","+(this._y1=y1);else;},arc:function(x,y,r,a0,a1,ccw){x=+x,y=+y;var dx=(r=+r)*Math.cos(a0),dy=r*Math.sin(a0),x0=x+dx,y0=y+dy,cw=1^ccw,da=ccw?a0-a1:a1-a0;if(r<0)throw new Error("negative radius: "+r);null===this._x1?this._+="M"+x0+","+y0:(Math.abs(this._x1-x0)>1e-6||Math.abs(this._y1-y0)>1e-6)&&(this._+="L"+x0+","+y0),r&&(da<0&&(da=da%tau$2+tau$2),da>tauEpsilon?this._+="A"+r+","+r+",0,1,"+cw+","+(x-dx)+","+(y-dy)+"A"+r+","+r+",0,1,"+cw+","+(this._x1=x0)+","+(this._y1=y0):da>1e-6&&(this._+="A"+r+","+r+",0,"+ +(da>=pi$2)+","+cw+","+(this._x1=x+r*Math.cos(a1))+","+(this._y1=y+r*Math.sin(a1))))},rect:function(x,y,w,h){this._+="M"+(this._x0=this._x1=+x)+","+(this._y0=this._y1=+y)+"h"+ +w+"v"+ +h+"h"+-w+"Z"},toString:function(){return this._}};function Map(){}function map$1(object,f){var map=new Map;if(object instanceof Map)object.each((function(value,key){map.set(key,value)}));else if(Array.isArray(object)){var o,i=-1,n=object.length;if(null==f)for(;++i<n;)map.set(i,object[i]);else for(;++i<n;)map.set(f(o=object[i],i,object),o)}else if(object)for(var key in object)map.set(key,object[key]);return map}Map.prototype=map$1.prototype={constructor:Map,has:function(key){return"$"+key in this},get:function(key){return this["$"+key]},set:function(key,value){return this["$"+key]=value,this},remove:function(key){var property="$"+key;return property in this&&delete this[property]},clear:function(){for(var property in this)"$"===property[0]&&delete this[property]},keys:function(){var keys=[];for(var property in this)"$"===property[0]&&keys.push(property.slice(1));return keys},values:function(){var values=[];for(var property in this)"$"===property[0]&&values.push(this[property]);return values},entries:function(){var entries=[];for(var property in this)"$"===property[0]&&entries.push({key:property.slice(1),value:this[property]});return entries},size:function(){var size=0;for(var property in this)"$"===property[0]&&++size;return size},empty:function(){for(var property in this)if("$"===property[0])return!1;return!0},each:function(f){for(var property in this)"$"===property[0]&&f(this[property],property.slice(1),this)}};function createObject(){return{}}function setObject(object,key,value){object[key]=value}function createMap(){return map$1()}function setMap(map,key,value){map.set(key,value)}function Set(){}var proto=map$1.prototype;function set$2(object,f){var set=new Set;if(object instanceof Set)object.each((function(value){set.add(value)}));else if(object){var i=-1,n=object.length;if(null==f)for(;++i<n;)set.add(object[i]);else for(;++i<n;)set.add(f(object[i],i,object))}return set}Set.prototype=set$2.prototype={constructor:Set,has:proto.has,add:function(value){return this["$"+(value+="")]=value,this},remove:proto.remove,clear:proto.clear,values:proto.keys,size:proto.size,empty:proto.empty,each:proto.each};function objectConverter(columns){return new Function("d","return {"+columns.map((function(name,i){return JSON.stringify(name)+": d["+i+"]"})).join(",")+"}")}var dsv=function(delimiter){var reFormat=new RegExp('["'+delimiter+"\n\r]"),delimiterCode=delimiter.charCodeAt(0);function parseRows(text,f){var t,eol,EOL={},EOF={},rows=[],N=text.length,I=0,n=0;function token(){if(I>=N)return EOF;if(eol)return eol=!1,EOL;var c,j=I;if(34===text.charCodeAt(j)){for(var i=j;i++<N;)if(34===text.charCodeAt(i)){if(34!==text.charCodeAt(i+1))break;++i}return I=i+2,13===(c=text.charCodeAt(i+1))?(eol=!0,10===text.charCodeAt(i+2)&&++I):10===c&&(eol=!0),text.slice(j+1,i).replace(/""/g,'"')}for(;I<N;){var k=1;if(10===(c=text.charCodeAt(I++)))eol=!0;else if(13===c)eol=!0,10===text.charCodeAt(I)&&(++I,++k);else if(c!==delimiterCode)continue;return text.slice(j,I-k)}return text.slice(j)}for(;(t=token())!==EOF;){for(var a=[];t!==EOL&&t!==EOF;)a.push(t),t=token();f&&null==(a=f(a,n++))||rows.push(a)}return rows}function formatRow(row){return row.map(formatValue).join(delimiter)}function formatValue(text){return null==text?"":reFormat.test(text+="")?'"'+text.replace(/\"/g,'""')+'"':text}return{parse:function parse(text,f){var convert,columns,rows=parseRows(text,(function(row,i){if(convert)return convert(row,i-1);columns=row,convert=f?function customConverter(columns,f){var object=objectConverter(columns);return function(row,i){return f(object(row),i,columns)}}(row,f):objectConverter(row)}));return rows.columns=columns,rows},parseRows:parseRows,format:function format(rows,columns){return null==columns&&(columns=function inferColumns(rows){var columnSet=Object.create(null),columns=[];return rows.forEach((function(row){for(var column in row)column in columnSet||columns.push(columnSet[column]=column)})),columns}(rows)),[columns.map(formatValue).join(delimiter)].concat(rows.map((function(row){return columns.map((function(column){return formatValue(row[column])})).join(delimiter)}))).join("\n")},formatRows:function formatRows(rows){return rows.map(formatRow).join("\n")}}},csv=dsv(","),csvParse=csv.parse,csvParseRows=csv.parseRows,csvFormat=csv.format,csvFormatRows=csv.formatRows,tsv=dsv("\t"),tsvParse=tsv.parse,tsvParseRows=tsv.parseRows,tsvFormat=tsv.format,tsvFormatRows=tsv.formatRows,constant$6=function(x){return function(){return x}},jiggle=function(){return 1e-6*(Math.random()-.5)};function add(tree,x,y,d){if(isNaN(x)||isNaN(y))return tree;var parent,xm,ym,xp,yp,right,bottom,i,j,node=tree._root,leaf={data:d},x0=tree._x0,y0=tree._y0,x1=tree._x1,y1=tree._y1;if(!node)return tree._root=leaf,tree;for(;node.length;)if((right=x>=(xm=(x0+x1)/2))?x0=xm:x1=xm,(bottom=y>=(ym=(y0+y1)/2))?y0=ym:y1=ym,parent=node,!(node=node[i=bottom<<1|right]))return parent[i]=leaf,tree;if(xp=+tree._x.call(null,node.data),yp=+tree._y.call(null,node.data),x===xp&&y===yp)return leaf.next=node,parent?parent[i]=leaf:tree._root=leaf,tree;do{parent=parent?parent[i]=new Array(4):tree._root=new Array(4),(right=x>=(xm=(x0+x1)/2))?x0=xm:x1=xm,(bottom=y>=(ym=(y0+y1)/2))?y0=ym:y1=ym}while((i=bottom<<1|right)==(j=(yp>=ym)<<1|xp>=xm));return parent[j]=node,parent[i]=leaf,tree}var Quad=function(node,x0,y0,x1,y1){this.node=node,this.x0=x0,this.y0=y0,this.x1=x1,this.y1=y1};function defaultX(d){return d[0]}function defaultY(d){return d[1]}function quadtree(nodes,x,y){var tree=new Quadtree(null==x?defaultX:x,null==y?defaultY:y,NaN,NaN,NaN,NaN);return null==nodes?tree:tree.addAll(nodes)}function Quadtree(x,y,x0,y0,x1,y1){this._x=x,this._y=y,this._x0=x0,this._y0=y0,this._x1=x1,this._y1=y1,this._root=void 0}function leaf_copy(leaf){for(var copy={data:leaf.data},next=copy;leaf=leaf.next;)next=next.next={data:leaf.data};return copy}var treeProto=quadtree.prototype=Quadtree.prototype;function x(d){return d.x+d.vx}function y(d){return d.y+d.vy}treeProto.copy=function(){var nodes,child,copy=new Quadtree(this._x,this._y,this._x0,this._y0,this._x1,this._y1),node=this._root;if(!node)return copy;if(!node.length)return copy._root=leaf_copy(node),copy;for(nodes=[{source:node,target:copy._root=new Array(4)}];node=nodes.pop();)for(var i=0;i<4;++i)(child=node.source[i])&&(child.length?nodes.push({source:child,target:node.target[i]=new Array(4)}):node.target[i]=leaf_copy(child));return copy},treeProto.add=function(d){var x=+this._x.call(null,d),y=+this._y.call(null,d);return add(this.cover(x,y),x,y,d)},treeProto.addAll=function addAll(data){var d,i,x,y,n=data.length,xz=new Array(n),yz=new Array(n),x0=1/0,y0=1/0,x1=-1/0,y1=-1/0;for(i=0;i<n;++i)isNaN(x=+this._x.call(null,d=data[i]))||isNaN(y=+this._y.call(null,d))||(xz[i]=x,yz[i]=y,x<x0&&(x0=x),x>x1&&(x1=x),y<y0&&(y0=y),y>y1&&(y1=y));for(x1<x0&&(x0=this._x0,x1=this._x1),y1<y0&&(y0=this._y0,y1=this._y1),this.cover(x0,y0).cover(x1,y1),i=0;i<n;++i)add(this,xz[i],yz[i],data[i]);return this},treeProto.cover=function(x,y){if(isNaN(x=+x)||isNaN(y=+y))return this;var x0=this._x0,y0=this._y0,x1=this._x1,y1=this._y1;if(isNaN(x0))x1=(x0=Math.floor(x))+1,y1=(y0=Math.floor(y))+1;else{if(!(x0>x||x>x1||y0>y||y>y1))return this;var parent,i,z=x1-x0,node=this._root;switch(i=(y<(y0+y1)/2)<<1|x<(x0+x1)/2){case 0:do{(parent=new Array(4))[i]=node,node=parent}while(y1=y0+(z*=2),x>(x1=x0+z)||y>y1);break;case 1:do{(parent=new Array(4))[i]=node,node=parent}while(y1=y0+(z*=2),(x0=x1-z)>x||y>y1);break;case 2:do{(parent=new Array(4))[i]=node,node=parent}while(y0=y1-(z*=2),x>(x1=x0+z)||y0>y);break;case 3:do{(parent=new Array(4))[i]=node,node=parent}while(y0=y1-(z*=2),(x0=x1-z)>x||y0>y)}this._root&&this._root.length&&(this._root=node)}return this._x0=x0,this._y0=y0,this._x1=x1,this._y1=y1,this},treeProto.data=function(){var data=[];return this.visit((function(node){if(!node.length)do{data.push(node.data)}while(node=node.next)})),data},treeProto.extent=function(_){return arguments.length?this.cover(+_[0][0],+_[0][1]).cover(+_[1][0],+_[1][1]):isNaN(this._x0)?void 0:[[this._x0,this._y0],[this._x1,this._y1]]},treeProto.find=function(x,y,radius){var data,x1,y1,x2,y2,q,i,x0=this._x0,y0=this._y0,x3=this._x1,y3=this._y1,quads=[],node=this._root;for(node&&quads.push(new Quad(node,x0,y0,x3,y3)),null==radius?radius=1/0:(x0=x-radius,y0=y-radius,x3=x+radius,y3=y+radius,radius*=radius);q=quads.pop();)if(!(!(node=q.node)||(x1=q.x0)>x3||(y1=q.y0)>y3||(x2=q.x1)<x0||(y2=q.y1)<y0))if(node.length){var xm=(x1+x2)/2,ym=(y1+y2)/2;quads.push(new Quad(node[3],xm,ym,x2,y2),new Quad(node[2],x1,ym,xm,y2),new Quad(node[1],xm,y1,x2,ym),new Quad(node[0],x1,y1,xm,ym)),(i=(y>=ym)<<1|x>=xm)&&(q=quads[quads.length-1],quads[quads.length-1]=quads[quads.length-1-i],quads[quads.length-1-i]=q)}else{var dx=x-+this._x.call(null,node.data),dy=y-+this._y.call(null,node.data),d2=dx*dx+dy*dy;if(d2<radius){var d=Math.sqrt(radius=d2);x0=x-d,y0=y-d,x3=x+d,y3=y+d,data=node.data}}return data},treeProto.remove=function(d){if(isNaN(x=+this._x.call(null,d))||isNaN(y=+this._y.call(null,d)))return this;var parent,retainer,previous,next,x,y,xm,ym,right,bottom,i,j,node=this._root,x0=this._x0,y0=this._y0,x1=this._x1,y1=this._y1;if(!node)return this;if(node.length)for(;;){if((right=x>=(xm=(x0+x1)/2))?x0=xm:x1=xm,(bottom=y>=(ym=(y0+y1)/2))?y0=ym:y1=ym,parent=node,!(node=node[i=bottom<<1|right]))return this;if(!node.length)break;(parent[i+1&3]||parent[i+2&3]||parent[i+3&3])&&(retainer=parent,j=i)}for(;node.data!==d;)if(previous=node,!(node=node.next))return this;return(next=node.next)&&delete node.next,previous?(next?previous.next=next:delete previous.next,this):parent?(next?parent[i]=next:delete parent[i],(node=parent[0]||parent[1]||parent[2]||parent[3])&&node===(parent[3]||parent[2]||parent[1]||parent[0])&&!node.length&&(retainer?retainer[j]=node:this._root=node),this):(this._root=next,this)},treeProto.removeAll=function removeAll(data){for(var i=0,n=data.length;i<n;++i)this.remove(data[i]);return this},treeProto.root=function(){return this._root},treeProto.size=function(){var size=0;return this.visit((function(node){if(!node.length)do{++size}while(node=node.next)})),size},treeProto.visit=function(callback){var q,child,x0,y0,x1,y1,quads=[],node=this._root;for(node&&quads.push(new Quad(node,this._x0,this._y0,this._x1,this._y1));q=quads.pop();)if(!callback(node=q.node,x0=q.x0,y0=q.y0,x1=q.x1,y1=q.y1)&&node.length){var xm=(x0+x1)/2,ym=(y0+y1)/2;(child=node[3])&&quads.push(new Quad(child,xm,ym,x1,y1)),(child=node[2])&&quads.push(new Quad(child,x0,ym,xm,y1)),(child=node[1])&&quads.push(new Quad(child,xm,y0,x1,ym)),(child=node[0])&&quads.push(new Quad(child,x0,y0,xm,ym))}return this},treeProto.visitAfter=function(callback){var q,quads=[],next=[];for(this._root&&quads.push(new Quad(this._root,this._x0,this._y0,this._x1,this._y1));q=quads.pop();){var node=q.node;if(node.length){var child,x0=q.x0,y0=q.y0,x1=q.x1,y1=q.y1,xm=(x0+x1)/2,ym=(y0+y1)/2;(child=node[0])&&quads.push(new Quad(child,x0,y0,xm,ym)),(child=node[1])&&quads.push(new Quad(child,xm,y0,x1,ym)),(child=node[2])&&quads.push(new Quad(child,x0,ym,xm,y1)),(child=node[3])&&quads.push(new Quad(child,xm,ym,x1,y1))}next.push(q)}for(;q=next.pop();)callback(q.node,q.x0,q.y0,q.x1,q.y1);return this},treeProto.x=function(_){return arguments.length?(this._x=_,this):this._x},treeProto.y=function(_){return arguments.length?(this._y=_,this):this._y};function index(d){return d.index}function find(nodeById,nodeId){var node=nodeById.get(nodeId);if(!node)throw new Error("missing: "+nodeId);return node}function x$1(d){return d.x}function y$1(d){return d.y}var prefixExponent,initialAngle=Math.PI*(3-Math.sqrt(5)),formatDecimal=function(x,p){if((i=(x=p?x.toExponential(p-1):x.toExponential()).indexOf("e"))<0)return null;var i,coefficient=x.slice(0,i);return[coefficient.length>1?coefficient[0]+coefficient.slice(2):coefficient,+x.slice(i+1)]},exponent$1=function(x){return(x=formatDecimal(Math.abs(x)))?x[1]:NaN},formatRounded=function(x,p){var d=formatDecimal(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1];return exponent<0?"0."+new Array(-exponent).join("0")+coefficient:coefficient.length>exponent+1?coefficient.slice(0,exponent+1)+"."+coefficient.slice(exponent+1):coefficient+new Array(exponent-coefficient.length+2).join("0")},formatTypes={"":function(x,p){out:for(var i1,n=(x=x.toPrecision(p)).length,i=1,i0=-1;i<n;++i)switch(x[i]){case".":i0=i1=i;break;case"0":0===i0&&(i0=i),i1=i;break;case"e":break out;default:i0>0&&(i0=0)}return i0>0?x.slice(0,i0)+x.slice(i1+1):x},"%":function(x,p){return(100*x).toFixed(p)},b:function(x){return Math.round(x).toString(2)},c:function(x){return x+""},d:function(x){return Math.round(x).toString(10)},e:function(x,p){return x.toExponential(p)},f:function(x,p){return x.toFixed(p)},g:function(x,p){return x.toPrecision(p)},o:function(x){return Math.round(x).toString(8)},p:function(x,p){return formatRounded(100*x,p)},r:formatRounded,s:function(x,p){var d=formatDecimal(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1],i=exponent-(prefixExponent=3*Math.max(-8,Math.min(8,Math.floor(exponent/3))))+1,n=coefficient.length;return i===n?coefficient:i>n?coefficient+new Array(i-n+1).join("0"):i>0?coefficient.slice(0,i)+"."+coefficient.slice(i):"0."+new Array(1-i).join("0")+formatDecimal(x,Math.max(0,p+i-1))[0]},X:function(x){return Math.round(x).toString(16).toUpperCase()},x:function(x){return Math.round(x).toString(16)}},re=/^(?:(.)?([<>=^]))?([+\-\( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?([a-z%])?$/i;function formatSpecifier(specifier){return new FormatSpecifier(specifier)}function FormatSpecifier(specifier){if(!(match=re.exec(specifier)))throw new Error("invalid format: "+specifier);var match,fill=match[1]||" ",align=match[2]||">",sign=match[3]||"-",symbol=match[4]||"",zero=!!match[5],width=match[6]&&+match[6],comma=!!match[7],precision=match[8]&&+match[8].slice(1),type=match[9]||"";"n"===type?(comma=!0,type="g"):formatTypes[type]||(type=""),(zero||"0"===fill&&"="===align)&&(zero=!0,fill="0",align="="),this.fill=fill,this.align=align,this.sign=sign,this.symbol=symbol,this.zero=zero,this.width=width,this.comma=comma,this.precision=precision,this.type=type}formatSpecifier.prototype=FormatSpecifier.prototype,FormatSpecifier.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(null==this.width?"":Math.max(1,0|this.width))+(this.comma?",":"")+(null==this.precision?"":"."+Math.max(0,0|this.precision))+this.type};var locale$1,identity$3=function(x){return x},prefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"],formatLocale=function(locale){var grouping,thousands,group=locale.grouping&&locale.thousands?(grouping=locale.grouping,thousands=locale.thousands,function(value,width){for(var i=value.length,t=[],j=0,g=grouping[0],length=0;i>0&&g>0&&(length+g+1>width&&(g=Math.max(1,width-length)),t.push(value.substring(i-=g,i+g)),!((length+=g+1)>width));)g=grouping[j=(j+1)%grouping.length];return t.reverse().join(thousands)}):identity$3,currency=locale.currency,decimal=locale.decimal,numerals=locale.numerals?function(numerals){return function(value){return value.replace(/[0-9]/g,(function(i){return numerals[+i]}))}}(locale.numerals):identity$3;function newFormat(specifier){var fill=(specifier=formatSpecifier(specifier)).fill,align=specifier.align,sign=specifier.sign,symbol=specifier.symbol,zero=specifier.zero,width=specifier.width,comma=specifier.comma,precision=specifier.precision,type=specifier.type,prefix="$"===symbol?currency[0]:"#"===symbol&&/[boxX]/.test(type)?"0"+type.toLowerCase():"",suffix="$"===symbol?currency[1]:/[%p]/.test(type)?"%":"",formatType=formatTypes[type],maybeSuffix=!type||/[defgprs%]/.test(type);function format(value){var i,n,c,valuePrefix=prefix,valueSuffix=suffix;if("c"===type)valueSuffix=formatType(value)+valueSuffix,value="";else{var valueNegative=(value=+value)<0;if(value=formatType(Math.abs(value),precision),valueNegative&&0==+value&&(valueNegative=!1),valuePrefix=(valueNegative?"("===sign?sign:"-":"-"===sign||"("===sign?"":sign)+valuePrefix,valueSuffix=valueSuffix+("s"===type?prefixes[8+prefixExponent/3]:"")+(valueNegative&&"("===sign?")":""),maybeSuffix)for(i=-1,n=value.length;++i<n;)if(48>(c=value.charCodeAt(i))||c>57){valueSuffix=(46===c?decimal+value.slice(i+1):value.slice(i))+valueSuffix,value=value.slice(0,i);break}}comma&&!zero&&(value=group(value,1/0));var length=valuePrefix.length+value.length+valueSuffix.length,padding=length<width?new Array(width-length+1).join(fill):"";switch(comma&&zero&&(value=group(padding+value,padding.length?width-valueSuffix.length:1/0),padding=""),align){case"<":value=valuePrefix+value+valueSuffix+padding;break;case"=":value=valuePrefix+padding+value+valueSuffix;break;case"^":value=padding.slice(0,length=padding.length>>1)+valuePrefix+value+valueSuffix+padding.slice(length);break;default:value=padding+valuePrefix+value+valueSuffix}return numerals(value)}return precision=null==precision?type?6:12:/[gprs]/.test(type)?Math.max(1,Math.min(21,precision)):Math.max(0,Math.min(20,precision)),format.toString=function(){return specifier+""},format}return{format:newFormat,formatPrefix:function formatPrefix(specifier,value){var f=newFormat(((specifier=formatSpecifier(specifier)).type="f",specifier)),e=3*Math.max(-8,Math.min(8,Math.floor(exponent$1(value)/3))),k=Math.pow(10,-e),prefix=prefixes[8+e/3];return function(value){return f(k*value)+prefix}}}};function defaultLocale(definition){return locale$1=formatLocale(definition),exports.format=locale$1.format,exports.formatPrefix=locale$1.formatPrefix,locale$1}defaultLocale({decimal:".",thousands:",",grouping:[3],currency:["$",""]});var precisionFixed=function(step){return Math.max(0,-exponent$1(Math.abs(step)))},precisionPrefix=function(step,value){return Math.max(0,3*Math.max(-8,Math.min(8,Math.floor(exponent$1(value)/3)))-exponent$1(Math.abs(step)))},precisionRound=function(step,max){return step=Math.abs(step),max=Math.abs(max)-step,Math.max(0,exponent$1(max)-exponent$1(step))+1},adder=function(){return new Adder};function Adder(){this.reset()}Adder.prototype={constructor:Adder,reset:function(){this.s=this.t=0},add:function(y){add$1(temp,y,this.t),add$1(this,temp.s,this.s),this.s?this.t+=temp.t:this.s=temp.t},valueOf:function(){return this.s}};var temp=new Adder;function add$1(adder,a,b){var x=adder.s=a+b,bv=x-a,av=x-bv;adder.t=a-av+(b-bv)}var pi$3=Math.PI,halfPi$2=pi$3/2,quarterPi=pi$3/4,tau$3=2*pi$3,degrees$1=180/pi$3,radians=pi$3/180,abs=Math.abs,atan=Math.atan,atan2=Math.atan2,cos$1=Math.cos,ceil=Math.ceil,exp=Math.exp,log=Math.log,pow=Math.pow,sin$1=Math.sin,sign=Math.sign||function(x){return x>0?1:x<0?-1:0},sqrt=Math.sqrt,tan=Math.tan;function acos(x){return x>1?0:x<-1?pi$3:Math.acos(x)}function asin(x){return x>1?halfPi$2:x<-1?-halfPi$2:Math.asin(x)}function haversin(x){return(x=sin$1(x/2))*x}function noop$1(){}function streamGeometry(geometry,stream){geometry&&streamGeometryType.hasOwnProperty(geometry.type)&&streamGeometryType[geometry.type](geometry,stream)}var streamObjectType={Feature:function(object,stream){streamGeometry(object.geometry,stream)},FeatureCollection:function(object,stream){for(var features=object.features,i=-1,n=features.length;++i<n;)streamGeometry(features[i].geometry,stream)}},streamGeometryType={Sphere:function(object,stream){stream.sphere()},Point:function(object,stream){object=object.coordinates,stream.point(object[0],object[1],object[2])},MultiPoint:function(object,stream){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)object=coordinates[i],stream.point(object[0],object[1],object[2])},LineString:function(object,stream){streamLine(object.coordinates,stream,0)},MultiLineString:function(object,stream){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)streamLine(coordinates[i],stream,0)},Polygon:function(object,stream){streamPolygon(object.coordinates,stream)},MultiPolygon:function(object,stream){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)streamPolygon(coordinates[i],stream)},GeometryCollection:function(object,stream){for(var geometries=object.geometries,i=-1,n=geometries.length;++i<n;)streamGeometry(geometries[i],stream)}};function streamLine(coordinates,stream,closed){var coordinate,i=-1,n=coordinates.length-closed;for(stream.lineStart();++i<n;)coordinate=coordinates[i],stream.point(coordinate[0],coordinate[1],coordinate[2]);stream.lineEnd()}function streamPolygon(coordinates,stream){var i=-1,n=coordinates.length;for(stream.polygonStart();++i<n;)streamLine(coordinates[i],stream,1);stream.polygonEnd()}var lambda00,phi00,lambda0,cosPhi0,sinPhi0,geoStream=function(object,stream){object&&streamObjectType.hasOwnProperty(object.type)?streamObjectType[object.type](object,stream):streamGeometry(object,stream)},areaRingSum=adder(),areaSum=adder(),areaStream={point:noop$1,lineStart:noop$1,lineEnd:noop$1,polygonStart:function(){areaRingSum.reset(),areaStream.lineStart=areaRingStart,areaStream.lineEnd=areaRingEnd},polygonEnd:function(){var areaRing=+areaRingSum;areaSum.add(areaRing<0?tau$3+areaRing:areaRing),this.lineStart=this.lineEnd=this.point=noop$1},sphere:function(){areaSum.add(tau$3)}};function areaRingStart(){areaStream.point=areaPointFirst}function areaRingEnd(){areaPoint(lambda00,phi00)}function areaPointFirst(lambda,phi){areaStream.point=areaPoint,lambda00=lambda,phi00=phi,lambda0=lambda*=radians,cosPhi0=cos$1(phi=(phi*=radians)/2+quarterPi),sinPhi0=sin$1(phi)}function areaPoint(lambda,phi){var dLambda=(lambda*=radians)-lambda0,sdLambda=dLambda>=0?1:-1,adLambda=sdLambda*dLambda,cosPhi=cos$1(phi=(phi*=radians)/2+quarterPi),sinPhi=sin$1(phi),k=sinPhi0*sinPhi,u=cosPhi0*cosPhi+k*cos$1(adLambda),v=k*sdLambda*sin$1(adLambda);areaRingSum.add(atan2(v,u)),lambda0=lambda,cosPhi0=cosPhi,sinPhi0=sinPhi}var lambda0$1,phi0,lambda1,phi1,lambda2,lambda00$1,phi00$1,p0;function spherical(cartesian){return[atan2(cartesian[1],cartesian[0]),asin(cartesian[2])]}function cartesian(spherical){var lambda=spherical[0],phi=spherical[1],cosPhi=cos$1(phi);return[cosPhi*cos$1(lambda),cosPhi*sin$1(lambda),sin$1(phi)]}function cartesianDot(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]}function cartesianCross(a,b){return[a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]]}function cartesianAddInPlace(a,b){a[0]+=b[0],a[1]+=b[1],a[2]+=b[2]}function cartesianScale(vector,k){return[vector[0]*k,vector[1]*k,vector[2]*k]}function cartesianNormalizeInPlace(d){var l=sqrt(d[0]*d[0]+d[1]*d[1]+d[2]*d[2]);d[0]/=l,d[1]/=l,d[2]/=l}var ranges,range,deltaSum=adder(),boundsStream={point:boundsPoint,lineStart:boundsLineStart,lineEnd:boundsLineEnd,polygonStart:function(){boundsStream.point=boundsRingPoint,boundsStream.lineStart=boundsRingStart,boundsStream.lineEnd=boundsRingEnd,deltaSum.reset(),areaStream.polygonStart()},polygonEnd:function(){areaStream.polygonEnd(),boundsStream.point=boundsPoint,boundsStream.lineStart=boundsLineStart,boundsStream.lineEnd=boundsLineEnd,areaRingSum<0?(lambda0$1=-(lambda1=180),phi0=-(phi1=90)):deltaSum>1e-6?phi1=90:deltaSum<-1e-6&&(phi0=-90),range[0]=lambda0$1,range[1]=lambda1}};function boundsPoint(lambda,phi){ranges.push(range=[lambda0$1=lambda,lambda1=lambda]),phi<phi0&&(phi0=phi),phi>phi1&&(phi1=phi)}function linePoint(lambda,phi){var p=cartesian([lambda*radians,phi*radians]);if(p0){var normal=cartesianCross(p0,p),inflection=cartesianCross([normal[1],-normal[0],0],normal);cartesianNormalizeInPlace(inflection),inflection=spherical(inflection);var phii,delta=lambda-lambda2,sign$$1=delta>0?1:-1,lambdai=inflection[0]*degrees$1*sign$$1,antimeridian=abs(delta)>180;antimeridian^(sign$$1*lambda2<lambdai&&lambdai<sign$$1*lambda)?(phii=inflection[1]*degrees$1)>phi1&&(phi1=phii):antimeridian^(sign$$1*lambda2<(lambdai=(lambdai+360)%360-180)&&lambdai<sign$$1*lambda)?(phii=-inflection[1]*degrees$1)<phi0&&(phi0=phii):(phi<phi0&&(phi0=phi),phi>phi1&&(phi1=phi)),antimeridian?lambda<lambda2?angle(lambda0$1,lambda)>angle(lambda0$1,lambda1)&&(lambda1=lambda):angle(lambda,lambda1)>angle(lambda0$1,lambda1)&&(lambda0$1=lambda):lambda1>=lambda0$1?(lambda<lambda0$1&&(lambda0$1=lambda),lambda>lambda1&&(lambda1=lambda)):lambda>lambda2?angle(lambda0$1,lambda)>angle(lambda0$1,lambda1)&&(lambda1=lambda):angle(lambda,lambda1)>angle(lambda0$1,lambda1)&&(lambda0$1=lambda)}else ranges.push(range=[lambda0$1=lambda,lambda1=lambda]);phi<phi0&&(phi0=phi),phi>phi1&&(phi1=phi),p0=p,lambda2=lambda}function boundsLineStart(){boundsStream.point=linePoint}function boundsLineEnd(){range[0]=lambda0$1,range[1]=lambda1,boundsStream.point=boundsPoint,p0=null}function boundsRingPoint(lambda,phi){if(p0){var delta=lambda-lambda2;deltaSum.add(abs(delta)>180?delta+(delta>0?360:-360):delta)}else lambda00$1=lambda,phi00$1=phi;areaStream.point(lambda,phi),linePoint(lambda,phi)}function boundsRingStart(){areaStream.lineStart()}function boundsRingEnd(){boundsRingPoint(lambda00$1,phi00$1),areaStream.lineEnd(),abs(deltaSum)>1e-6&&(lambda0$1=-(lambda1=180)),range[0]=lambda0$1,range[1]=lambda1,p0=null}function angle(lambda0,lambda1){return(lambda1-=lambda0)<0?lambda1+360:lambda1}function rangeCompare(a,b){return a[0]-b[0]}function rangeContains(range,x){return range[0]<=range[1]?range[0]<=x&&x<=range[1]:x<range[0]||range[1]<x}var W0,W1,X0,Y0,Z0,X1,Y1,Z1,X2,Y2,Z2,lambda00$2,phi00$2,x0,y0,z0,centroidStream={sphere:noop$1,point:centroidPoint,lineStart:centroidLineStart,lineEnd:centroidLineEnd,polygonStart:function(){centroidStream.lineStart=centroidRingStart,centroidStream.lineEnd=centroidRingEnd},polygonEnd:function(){centroidStream.lineStart=centroidLineStart,centroidStream.lineEnd=centroidLineEnd}};function centroidPoint(lambda,phi){lambda*=radians;var cosPhi=cos$1(phi*=radians);centroidPointCartesian(cosPhi*cos$1(lambda),cosPhi*sin$1(lambda),sin$1(phi))}function centroidPointCartesian(x,y,z){++W0,X0+=(x-X0)/W0,Y0+=(y-Y0)/W0,Z0+=(z-Z0)/W0}function centroidLineStart(){centroidStream.point=centroidLinePointFirst}function centroidLinePointFirst(lambda,phi){lambda*=radians;var cosPhi=cos$1(phi*=radians);x0=cosPhi*cos$1(lambda),y0=cosPhi*sin$1(lambda),z0=sin$1(phi),centroidStream.point=centroidLinePoint,centroidPointCartesian(x0,y0,z0)}function centroidLinePoint(lambda,phi){lambda*=radians;var cosPhi=cos$1(phi*=radians),x=cosPhi*cos$1(lambda),y=cosPhi*sin$1(lambda),z=sin$1(phi),w=atan2(sqrt((w=y0*z-z0*y)*w+(w=z0*x-x0*z)*w+(w=x0*y-y0*x)*w),x0*x+y0*y+z0*z);W1+=w,X1+=w*(x0+(x0=x)),Y1+=w*(y0+(y0=y)),Z1+=w*(z0+(z0=z)),centroidPointCartesian(x0,y0,z0)}function centroidLineEnd(){centroidStream.point=centroidPoint}function centroidRingStart(){centroidStream.point=centroidRingPointFirst}function centroidRingEnd(){centroidRingPoint(lambda00$2,phi00$2),centroidStream.point=centroidPoint}function centroidRingPointFirst(lambda,phi){lambda00$2=lambda,phi00$2=phi,lambda*=radians,phi*=radians,centroidStream.point=centroidRingPoint;var cosPhi=cos$1(phi);x0=cosPhi*cos$1(lambda),y0=cosPhi*sin$1(lambda),z0=sin$1(phi),centroidPointCartesian(x0,y0,z0)}function centroidRingPoint(lambda,phi){lambda*=radians;var cosPhi=cos$1(phi*=radians),x=cosPhi*cos$1(lambda),y=cosPhi*sin$1(lambda),z=sin$1(phi),cx=y0*z-z0*y,cy=z0*x-x0*z,cz=x0*y-y0*x,m=sqrt(cx*cx+cy*cy+cz*cz),w=asin(m),v=m&&-w/m;X2+=v*cx,Y2+=v*cy,Z2+=v*cz,W1+=w,X1+=w*(x0+(x0=x)),Y1+=w*(y0+(y0=y)),Z1+=w*(z0+(z0=z)),centroidPointCartesian(x0,y0,z0)}var constant$7=function(x){return function(){return x}},compose=function(a,b){function compose(x,y){return x=a(x,y),b(x[0],x[1])}return a.invert&&b.invert&&(compose.invert=function(x,y){return(x=b.invert(x,y))&&a.invert(x[0],x[1])}),compose};function rotationIdentity(lambda,phi){return[lambda>pi$3?lambda-tau$3:lambda<-pi$3?lambda+tau$3:lambda,phi]}function rotateRadians(deltaLambda,deltaPhi,deltaGamma){return(deltaLambda%=tau$3)?deltaPhi||deltaGamma?compose(rotationLambda(deltaLambda),rotationPhiGamma(deltaPhi,deltaGamma)):rotationLambda(deltaLambda):deltaPhi||deltaGamma?rotationPhiGamma(deltaPhi,deltaGamma):rotationIdentity}function forwardRotationLambda(deltaLambda){return function(lambda,phi){return[(lambda+=deltaLambda)>pi$3?lambda-tau$3:lambda<-pi$3?lambda+tau$3:lambda,phi]}}function rotationLambda(deltaLambda){var rotation=forwardRotationLambda(deltaLambda);return rotation.invert=forwardRotationLambda(-deltaLambda),rotation}function rotationPhiGamma(deltaPhi,deltaGamma){var cosDeltaPhi=cos$1(deltaPhi),sinDeltaPhi=sin$1(deltaPhi),cosDeltaGamma=cos$1(deltaGamma),sinDeltaGamma=sin$1(deltaGamma);function rotation(lambda,phi){var cosPhi=cos$1(phi),x=cos$1(lambda)*cosPhi,y=sin$1(lambda)*cosPhi,z=sin$1(phi),k=z*cosDeltaPhi+x*sinDeltaPhi;return[atan2(y*cosDeltaGamma-k*sinDeltaGamma,x*cosDeltaPhi-z*sinDeltaPhi),asin(k*cosDeltaGamma+y*sinDeltaGamma)]}return rotation.invert=function(lambda,phi){var cosPhi=cos$1(phi),x=cos$1(lambda)*cosPhi,y=sin$1(lambda)*cosPhi,z=sin$1(phi),k=z*cosDeltaGamma-y*sinDeltaGamma;return[atan2(y*cosDeltaGamma+z*sinDeltaGamma,x*cosDeltaPhi+k*sinDeltaPhi),asin(k*cosDeltaPhi-x*sinDeltaPhi)]},rotation}rotationIdentity.invert=rotationIdentity;var rotation=function(rotate){function forward(coordinates){return(coordinates=rotate(coordinates[0]*radians,coordinates[1]*radians))[0]*=degrees$1,coordinates[1]*=degrees$1,coordinates}return rotate=rotateRadians(rotate[0]*radians,rotate[1]*radians,rotate.length>2?rotate[2]*radians:0),forward.invert=function(coordinates){return(coordinates=rotate.invert(coordinates[0]*radians,coordinates[1]*radians))[0]*=degrees$1,coordinates[1]*=degrees$1,coordinates},forward};function circleStream(stream,radius,delta,direction,t0,t1){if(delta){var cosRadius=cos$1(radius),sinRadius=sin$1(radius),step=direction*delta;null==t0?(t0=radius+direction*tau$3,t1=radius-step/2):(t0=circleRadius(cosRadius,t0),t1=circleRadius(cosRadius,t1),(direction>0?t0<t1:t0>t1)&&(t0+=direction*tau$3));for(var point,t=t0;direction>0?t>t1:t<t1;t-=step)point=spherical([cosRadius,-sinRadius*cos$1(t),-sinRadius*sin$1(t)]),stream.point(point[0],point[1])}}function circleRadius(cosRadius,point){(point=cartesian(point))[0]-=cosRadius,cartesianNormalizeInPlace(point);var radius=acos(-point[1]);return((-point[2]<0?-radius:radius)+tau$3-1e-6)%tau$3}var clipBuffer=function(){var line,lines=[];return{point:function(x,y){line.push([x,y])},lineStart:function(){lines.push(line=[])},lineEnd:noop$1,rejoin:function(){lines.length>1&&lines.push(lines.pop().concat(lines.shift()))},result:function(){var result=lines;return lines=[],line=null,result}}},pointEqual=function(a,b){return abs(a[0]-b[0])<1e-6&&abs(a[1]-b[1])<1e-6};function Intersection(point,points,other,entry){this.x=point,this.z=points,this.o=other,this.e=entry,this.v=!1,this.n=this.p=null}var clipPolygon=function(segments,compareIntersection,startInside,interpolate,stream){var i,n,subject=[],clip=[];if(segments.forEach((function(segment){if(!((n=segment.length-1)<=0)){var n,x,p0=segment[0],p1=segment[n];if(pointEqual(p0,p1)){for(stream.lineStart(),i=0;i<n;++i)stream.point((p0=segment[i])[0],p0[1]);stream.lineEnd()}else subject.push(x=new Intersection(p0,segment,null,!0)),clip.push(x.o=new Intersection(p0,null,x,!1)),subject.push(x=new Intersection(p1,segment,null,!1)),clip.push(x.o=new Intersection(p1,null,x,!0))}})),subject.length){for(clip.sort(compareIntersection),link$1(subject),link$1(clip),i=0,n=clip.length;i<n;++i)clip[i].e=startInside=!startInside;for(var points,point,start=subject[0];;){for(var current=start,isSubject=!0;current.v;)if((current=current.n)===start)return;points=current.z,stream.lineStart();do{if(current.v=current.o.v=!0,current.e){if(isSubject)for(i=0,n=points.length;i<n;++i)stream.point((point=points[i])[0],point[1]);else interpolate(current.x,current.n.x,1,stream);current=current.n}else{if(isSubject)for(points=current.p.z,i=points.length-1;i>=0;--i)stream.point((point=points[i])[0],point[1]);else interpolate(current.x,current.p.x,-1,stream);current=current.p}points=(current=current.o).z,isSubject=!isSubject}while(!current.v);stream.lineEnd()}}};function link$1(array){if(n=array.length){for(var n,b,i=0,a=array[0];++i<n;)a.n=b=array[i],b.p=a,a=b;a.n=b=array[0],b.p=a}}function clipExtent(x0,y0,x1,y1){function visible(x,y){return x0<=x&&x<=x1&&y0<=y&&y<=y1}function interpolate(from,to,direction,stream){var a=0,a1=0;if(null==from||(a=corner(from,direction))!==(a1=corner(to,direction))||comparePoint(from,to)<0^direction>0)do{stream.point(0===a||3===a?x0:x1,a>1?y1:y0)}while((a=(a+direction+4)%4)!==a1);else stream.point(to[0],to[1])}function corner(p,direction){return abs(p[0]-x0)<1e-6?direction>0?0:3:abs(p[0]-x1)<1e-6?direction>0?2:1:abs(p[1]-y0)<1e-6?direction>0?1:0:direction>0?3:2}function compareIntersection(a,b){return comparePoint(a.x,b.x)}function comparePoint(a,b){var ca=corner(a,1),cb=corner(b,1);return ca!==cb?ca-cb:0===ca?b[1]-a[1]:1===ca?a[0]-b[0]:2===ca?a[1]-b[1]:b[0]-a[0]}return function(stream){var segments,polygon,ring,x__,y__,v__,x_,y_,v_,first,clean,activeStream=stream,bufferStream=clipBuffer(),clipStream={point:point,lineStart:function lineStart(){clipStream.point=linePoint,polygon&&polygon.push(ring=[]);first=!0,v_=!1,x_=y_=NaN},lineEnd:function lineEnd(){segments&&(linePoint(x__,y__),v__&&v_&&bufferStream.rejoin(),segments.push(bufferStream.result()));clipStream.point=point,v_&&activeStream.lineEnd()},polygonStart:function polygonStart(){activeStream=bufferStream,segments=[],polygon=[],clean=!0},polygonEnd:function polygonEnd(){var startInside=function polygonInside(){for(var winding=0,i=0,n=polygon.length;i<n;++i)for(var a0,a1,ring=polygon[i],j=1,m=ring.length,point=ring[0],b0=point[0],b1=point[1];j<m;++j)a0=b0,a1=b1,point=ring[j],b0=point[0],b1=point[1],a1<=y1?b1>y1&&(b0-a0)*(y1-a1)>(b1-a1)*(x0-a0)&&++winding:b1<=y1&&(b0-a0)*(y1-a1)<(b1-a1)*(x0-a0)&&--winding;return winding}(),cleanInside=clean&&startInside,visible=(segments=merge(segments)).length;(cleanInside||visible)&&(stream.polygonStart(),cleanInside&&(stream.lineStart(),interpolate(null,null,1,stream),stream.lineEnd()),visible&&clipPolygon(segments,compareIntersection,startInside,interpolate,stream),stream.polygonEnd());activeStream=stream,segments=polygon=ring=null}};function point(x,y){visible(x,y)&&activeStream.point(x,y)}function linePoint(x,y){var v=visible(x,y);if(polygon&&ring.push([x,y]),first)x__=x,y__=y,v__=v,first=!1,v&&(activeStream.lineStart(),activeStream.point(x,y));else if(v&&v_)activeStream.point(x,y);else{var a=[x_=Math.max(-1e9,Math.min(1e9,x_)),y_=Math.max(-1e9,Math.min(1e9,y_))],b=[x=Math.max(-1e9,Math.min(1e9,x)),y=Math.max(-1e9,Math.min(1e9,y))];!function(a,b,x0,y0,x1,y1){var r,ax=a[0],ay=a[1],t0=0,t1=1,dx=b[0]-ax,dy=b[1]-ay;if(r=x0-ax,dx||!(r>0)){if(r/=dx,dx<0){if(r<t0)return;r<t1&&(t1=r)}else if(dx>0){if(r>t1)return;r>t0&&(t0=r)}if(r=x1-ax,dx||!(r<0)){if(r/=dx,dx<0){if(r>t1)return;r>t0&&(t0=r)}else if(dx>0){if(r<t0)return;r<t1&&(t1=r)}if(r=y0-ay,dy||!(r>0)){if(r/=dy,dy<0){if(r<t0)return;r<t1&&(t1=r)}else if(dy>0){if(r>t1)return;r>t0&&(t0=r)}if(r=y1-ay,dy||!(r<0)){if(r/=dy,dy<0){if(r>t1)return;r>t0&&(t0=r)}else if(dy>0){if(r<t0)return;r<t1&&(t1=r)}return t0>0&&(a[0]=ax+t0*dx,a[1]=ay+t0*dy),t1<1&&(b[0]=ax+t1*dx,b[1]=ay+t1*dy),!0}}}}}(a,b,x0,y0,x1,y1)?v&&(activeStream.lineStart(),activeStream.point(x,y),clean=!1):(v_||(activeStream.lineStart(),activeStream.point(a[0],a[1])),activeStream.point(b[0],b[1]),v||activeStream.lineEnd(),clean=!1)}x_=x,y_=y,v_=v}return clipStream}}var lambda0$2,sinPhi0$1,cosPhi0$1,sum$1=adder(),polygonContains=function(polygon,point){var lambda=point[0],phi=point[1],normal=[sin$1(lambda),-cos$1(lambda),0],angle=0,winding=0;sum$1.reset();for(var i=0,n=polygon.length;i<n;++i)if(m=(ring=polygon[i]).length)for(var ring,m,point0=ring[m-1],lambda0=point0[0],phi0=point0[1]/2+quarterPi,sinPhi0=sin$1(phi0),cosPhi0=cos$1(phi0),j=0;j<m;++j,lambda0=lambda1,sinPhi0=sinPhi1,cosPhi0=cosPhi1,point0=point1){var point1=ring[j],lambda1=point1[0],phi1=point1[1]/2+quarterPi,sinPhi1=sin$1(phi1),cosPhi1=cos$1(phi1),delta=lambda1-lambda0,sign$$1=delta>=0?1:-1,absDelta=sign$$1*delta,antimeridian=absDelta>pi$3,k=sinPhi0*sinPhi1;if(sum$1.add(atan2(k*sign$$1*sin$1(absDelta),cosPhi0*cosPhi1+k*cos$1(absDelta))),angle+=antimeridian?delta+sign$$1*tau$3:delta,antimeridian^lambda0>=lambda^lambda1>=lambda){var arc=cartesianCross(cartesian(point0),cartesian(point1));cartesianNormalizeInPlace(arc);var intersection=cartesianCross(normal,arc);cartesianNormalizeInPlace(intersection);var phiArc=(antimeridian^delta>=0?-1:1)*asin(intersection[2]);(phi>phiArc||phi===phiArc&&(arc[0]||arc[1]))&&(winding+=antimeridian^delta>=0?1:-1)}}return(angle<-1e-6||angle<1e-6&&sum$1<-1e-6)^1&winding},lengthSum=adder(),lengthStream={sphere:noop$1,point:noop$1,lineStart:function lengthLineStart(){lengthStream.point=lengthPointFirst,lengthStream.lineEnd=lengthLineEnd},lineEnd:noop$1,polygonStart:noop$1,polygonEnd:noop$1};function lengthLineEnd(){lengthStream.point=lengthStream.lineEnd=noop$1}function lengthPointFirst(lambda,phi){lambda0$2=lambda*=radians,sinPhi0$1=sin$1(phi*=radians),cosPhi0$1=cos$1(phi),lengthStream.point=lengthPoint}function lengthPoint(lambda,phi){lambda*=radians;var sinPhi=sin$1(phi*=radians),cosPhi=cos$1(phi),delta=abs(lambda-lambda0$2),cosDelta=cos$1(delta),x=cosPhi*sin$1(delta),y=cosPhi0$1*sinPhi-sinPhi0$1*cosPhi*cosDelta,z=sinPhi0$1*sinPhi+cosPhi0$1*cosPhi*cosDelta;lengthSum.add(atan2(sqrt(x*x+y*y),z)),lambda0$2=lambda,sinPhi0$1=sinPhi,cosPhi0$1=cosPhi}var length$1=function(object){return lengthSum.reset(),geoStream(object,lengthStream),+lengthSum},coordinates=[null,null],object$1={type:"LineString",coordinates:coordinates},distance=function(a,b){return coordinates[0]=a,coordinates[1]=b,length$1(object$1)},containsObjectType={Feature:function(object,point){return containsGeometry(object.geometry,point)},FeatureCollection:function(object,point){for(var features=object.features,i=-1,n=features.length;++i<n;)if(containsGeometry(features[i].geometry,point))return!0;return!1}},containsGeometryType={Sphere:function(){return!0},Point:function(object,point){return containsPoint(object.coordinates,point)},MultiPoint:function(object,point){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)if(containsPoint(coordinates[i],point))return!0;return!1},LineString:function(object,point){return containsLine(object.coordinates,point)},MultiLineString:function(object,point){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)if(containsLine(coordinates[i],point))return!0;return!1},Polygon:function(object,point){return containsPolygon(object.coordinates,point)},MultiPolygon:function(object,point){for(var coordinates=object.coordinates,i=-1,n=coordinates.length;++i<n;)if(containsPolygon(coordinates[i],point))return!0;return!1},GeometryCollection:function(object,point){for(var geometries=object.geometries,i=-1,n=geometries.length;++i<n;)if(containsGeometry(geometries[i],point))return!0;return!1}};function containsGeometry(geometry,point){return!(!geometry||!containsGeometryType.hasOwnProperty(geometry.type))&&containsGeometryType[geometry.type](geometry,point)}function containsPoint(coordinates,point){return 0===distance(coordinates,point)}function containsLine(coordinates,point){var ab=distance(coordinates[0],coordinates[1]);return distance(coordinates[0],point)+distance(point,coordinates[1])<=ab+1e-6}function containsPolygon(coordinates,point){return!!polygonContains(coordinates.map(ringRadians),pointRadians(point))}function ringRadians(ring){return(ring=ring.map(pointRadians)).pop(),ring}function pointRadians(point){return[point[0]*radians,point[1]*radians]}function graticuleX(y0,y1,dy){var y=sequence(y0,y1-1e-6,dy).concat(y1);return function(x){return y.map((function(y){return[x,y]}))}}function graticuleY(x0,x1,dx){var x=sequence(x0,x1-1e-6,dx).concat(x1);return function(y){return x.map((function(x){return[x,y]}))}}function graticule(){var x1,x0,X1,X0,y1,y0,Y1,Y0,x,y,X,Y,dx=10,dy=dx,DX=90,DY=360,precision=2.5;function graticule(){return{type:"MultiLineString",coordinates:lines()}}function lines(){return sequence(ceil(X0/DX)*DX,X1,DX).map(X).concat(sequence(ceil(Y0/DY)*DY,Y1,DY).map(Y)).concat(sequence(ceil(x0/dx)*dx,x1,dx).filter((function(x){return abs(x%DX)>1e-6})).map(x)).concat(sequence(ceil(y0/dy)*dy,y1,dy).filter((function(y){return abs(y%DY)>1e-6})).map(y))}return graticule.lines=function(){return lines().map((function(coordinates){return{type:"LineString",coordinates:coordinates}}))},graticule.outline=function(){return{type:"Polygon",coordinates:[X(X0).concat(Y(Y1).slice(1),X(X1).reverse().slice(1),Y(Y0).reverse().slice(1))]}},graticule.extent=function(_){return arguments.length?graticule.extentMajor(_).extentMinor(_):graticule.extentMinor()},graticule.extentMajor=function(_){return arguments.length?(X0=+_[0][0],X1=+_[1][0],Y0=+_[0][1],Y1=+_[1][1],X0>X1&&(_=X0,X0=X1,X1=_),Y0>Y1&&(_=Y0,Y0=Y1,Y1=_),graticule.precision(precision)):[[X0,Y0],[X1,Y1]]},graticule.extentMinor=function(_){return arguments.length?(x0=+_[0][0],x1=+_[1][0],y0=+_[0][1],y1=+_[1][1],x0>x1&&(_=x0,x0=x1,x1=_),y0>y1&&(_=y0,y0=y1,y1=_),graticule.precision(precision)):[[x0,y0],[x1,y1]]},graticule.step=function(_){return arguments.length?graticule.stepMajor(_).stepMinor(_):graticule.stepMinor()},graticule.stepMajor=function(_){return arguments.length?(DX=+_[0],DY=+_[1],graticule):[DX,DY]},graticule.stepMinor=function(_){return arguments.length?(dx=+_[0],dy=+_[1],graticule):[dx,dy]},graticule.precision=function(_){return arguments.length?(precision=+_,x=graticuleX(y0,y1,90),y=graticuleY(x0,x1,precision),X=graticuleX(Y0,Y1,90),Y=graticuleY(X0,X1,precision),graticule):precision},graticule.extentMajor([[-180,-89.999999],[180,89.999999]]).extentMinor([[-180,-80.000001],[180,80.000001]])}var x00,y00,x0$1,y0$1,identity$4=function(x){return x},areaSum$1=adder(),areaRingSum$1=adder(),areaStream$1={point:noop$1,lineStart:noop$1,lineEnd:noop$1,polygonStart:function(){areaStream$1.lineStart=areaRingStart$1,areaStream$1.lineEnd=areaRingEnd$1},polygonEnd:function(){areaStream$1.lineStart=areaStream$1.lineEnd=areaStream$1.point=noop$1,areaSum$1.add(abs(areaRingSum$1)),areaRingSum$1.reset()},result:function(){var area=areaSum$1/2;return areaSum$1.reset(),area}};function areaRingStart$1(){areaStream$1.point=areaPointFirst$1}function areaPointFirst$1(x,y){areaStream$1.point=areaPoint$1,x00=x0$1=x,y00=y0$1=y}function areaPoint$1(x,y){areaRingSum$1.add(y0$1*x-x0$1*y),x0$1=x,y0$1=y}function areaRingEnd$1(){areaPoint$1(x00,y00)}var x0$2=1/0,y0$2=x0$2,x1=-x0$2,y1=x1,boundsStream$1={point:function boundsPoint$1(x,y){x<x0$2&&(x0$2=x);x>x1&&(x1=x);y<y0$2&&(y0$2=y);y>y1&&(y1=y)},lineStart:noop$1,lineEnd:noop$1,polygonStart:noop$1,polygonEnd:noop$1,result:function(){var bounds=[[x0$2,y0$2],[x1,y1]];return x1=y1=-(y0$2=x0$2=1/0),bounds}};var x00$1,y00$1,x0$3,y0$3,X0$1=0,Y0$1=0,Z0$1=0,X1$1=0,Y1$1=0,Z1$1=0,X2$1=0,Y2$1=0,Z2$1=0,centroidStream$1={point:centroidPoint$1,lineStart:centroidLineStart$1,lineEnd:centroidLineEnd$1,polygonStart:function(){centroidStream$1.lineStart=centroidRingStart$1,centroidStream$1.lineEnd=centroidRingEnd$1},polygonEnd:function(){centroidStream$1.point=centroidPoint$1,centroidStream$1.lineStart=centroidLineStart$1,centroidStream$1.lineEnd=centroidLineEnd$1},result:function(){var centroid=Z2$1?[X2$1/Z2$1,Y2$1/Z2$1]:Z1$1?[X1$1/Z1$1,Y1$1/Z1$1]:Z0$1?[X0$1/Z0$1,Y0$1/Z0$1]:[NaN,NaN];return X0$1=Y0$1=Z0$1=X1$1=Y1$1=Z1$1=X2$1=Y2$1=Z2$1=0,centroid}};function centroidPoint$1(x,y){X0$1+=x,Y0$1+=y,++Z0$1}function centroidLineStart$1(){centroidStream$1.point=centroidPointFirstLine}function centroidPointFirstLine(x,y){centroidStream$1.point=centroidPointLine,centroidPoint$1(x0$3=x,y0$3=y)}function centroidPointLine(x,y){var dx=x-x0$3,dy=y-y0$3,z=sqrt(dx*dx+dy*dy);X1$1+=z*(x0$3+x)/2,Y1$1+=z*(y0$3+y)/2,Z1$1+=z,centroidPoint$1(x0$3=x,y0$3=y)}function centroidLineEnd$1(){centroidStream$1.point=centroidPoint$1}function centroidRingStart$1(){centroidStream$1.point=centroidPointFirstRing}function centroidRingEnd$1(){centroidPointRing(x00$1,y00$1)}function centroidPointFirstRing(x,y){centroidStream$1.point=centroidPointRing,centroidPoint$1(x00$1=x0$3=x,y00$1=y0$3=y)}function centroidPointRing(x,y){var dx=x-x0$3,dy=y-y0$3,z=sqrt(dx*dx+dy*dy);X1$1+=z*(x0$3+x)/2,Y1$1+=z*(y0$3+y)/2,Z1$1+=z,X2$1+=(z=y0$3*x-x0$3*y)*(x0$3+x),Y2$1+=z*(y0$3+y),Z2$1+=3*z,centroidPoint$1(x0$3=x,y0$3=y)}function PathContext(context){this._context=context}PathContext.prototype={_radius:4.5,pointRadius:function(_){return this._radius=_,this},polygonStart:function(){this._line=0},polygonEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){0===this._line&&this._context.closePath(),this._point=NaN},point:function(x,y){switch(this._point){case 0:this._context.moveTo(x,y),this._point=1;break;case 1:this._context.lineTo(x,y);break;default:this._context.moveTo(x+this._radius,y),this._context.arc(x,y,this._radius,0,tau$3)}},result:noop$1};var lengthRing,x00$2,y00$2,x0$4,y0$4,lengthSum$1=adder(),lengthStream$1={point:noop$1,lineStart:function(){lengthStream$1.point=lengthPointFirst$1},lineEnd:function(){lengthRing&&lengthPoint$1(x00$2,y00$2),lengthStream$1.point=noop$1},polygonStart:function(){lengthRing=!0},polygonEnd:function(){lengthRing=null},result:function(){var length=+lengthSum$1;return lengthSum$1.reset(),length}};function lengthPointFirst$1(x,y){lengthStream$1.point=lengthPoint$1,x00$2=x0$4=x,y00$2=y0$4=y}function lengthPoint$1(x,y){x0$4-=x,y0$4-=y,lengthSum$1.add(sqrt(x0$4*x0$4+y0$4*y0$4)),x0$4=x,y0$4=y}function PathString(){this._string=[]}function circle$1(radius){return"m0,"+radius+"a"+radius+","+radius+" 0 1,1 0,"+-2*radius+"a"+radius+","+radius+" 0 1,1 0,"+2*radius+"z"}PathString.prototype={_circle:circle$1(4.5),pointRadius:function(_){return this._circle=circle$1(_),this},polygonStart:function(){this._line=0},polygonEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){0===this._line&&this._string.push("Z"),this._point=NaN},point:function(x,y){switch(this._point){case 0:this._string.push("M",x,",",y),this._point=1;break;case 1:this._string.push("L",x,",",y);break;default:this._string.push("M",x,",",y,this._circle)}},result:function(){if(this._string.length){var result=this._string.join("");return this._string=[],result}}};var clip=function(pointVisible,clipLine,interpolate,start){return function(rotate,sink){var polygon,segments,ring,line=clipLine(sink),rotatedStart=rotate.invert(start[0],start[1]),ringBuffer=clipBuffer(),ringSink=clipLine(ringBuffer),polygonStarted=!1,clip={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){clip.point=pointRing,clip.lineStart=ringStart,clip.lineEnd=ringEnd,segments=[],polygon=[]},polygonEnd:function(){clip.point=point,clip.lineStart=lineStart,clip.lineEnd=lineEnd,segments=merge(segments);var startInside=polygonContains(polygon,rotatedStart);segments.length?(polygonStarted||(sink.polygonStart(),polygonStarted=!0),clipPolygon(segments,compareIntersection,startInside,interpolate,sink)):startInside&&(polygonStarted||(sink.polygonStart(),polygonStarted=!0),sink.lineStart(),interpolate(null,null,1,sink),sink.lineEnd()),polygonStarted&&(sink.polygonEnd(),polygonStarted=!1),segments=polygon=null},sphere:function(){sink.polygonStart(),sink.lineStart(),interpolate(null,null,1,sink),sink.lineEnd(),sink.polygonEnd()}};function point(lambda,phi){var point=rotate(lambda,phi);pointVisible(lambda=point[0],phi=point[1])&&sink.point(lambda,phi)}function pointLine(lambda,phi){var point=rotate(lambda,phi);line.point(point[0],point[1])}function lineStart(){clip.point=pointLine,line.lineStart()}function lineEnd(){clip.point=point,line.lineEnd()}function pointRing(lambda,phi){ring.push([lambda,phi]);var point=rotate(lambda,phi);ringSink.point(point[0],point[1])}function ringStart(){ringSink.lineStart(),ring=[]}function ringEnd(){pointRing(ring[0][0],ring[0][1]),ringSink.lineEnd();var i,m,segment,point,clean=ringSink.clean(),ringSegments=ringBuffer.result(),n=ringSegments.length;if(ring.pop(),polygon.push(ring),ring=null,n)if(1&clean){if((m=(segment=ringSegments[0]).length-1)>0){for(polygonStarted||(sink.polygonStart(),polygonStarted=!0),sink.lineStart(),i=0;i<m;++i)sink.point((point=segment[i])[0],point[1]);sink.lineEnd()}}else n>1&&2&clean&&ringSegments.push(ringSegments.pop().concat(ringSegments.shift())),segments.push(ringSegments.filter(validSegment))}return clip}};function validSegment(segment){return segment.length>1}function compareIntersection(a,b){return((a=a.x)[0]<0?a[1]-halfPi$2-1e-6:halfPi$2-a[1])-((b=b.x)[0]<0?b[1]-halfPi$2-1e-6:halfPi$2-b[1])}var clipAntimeridian=clip((function(){return!0}),(function clipAntimeridianLine(stream){var clean,lambda0=NaN,phi0=NaN,sign0=NaN;return{lineStart:function(){stream.lineStart(),clean=1},point:function(lambda1,phi1){var sign1=lambda1>0?pi$3:-pi$3,delta=abs(lambda1-lambda0);abs(delta-pi$3)<1e-6?(stream.point(lambda0,phi0=(phi0+phi1)/2>0?halfPi$2:-halfPi$2),stream.point(sign0,phi0),stream.lineEnd(),stream.lineStart(),stream.point(sign1,phi0),stream.point(lambda1,phi0),clean=0):sign0!==sign1&&delta>=pi$3&&(abs(lambda0-sign0)<1e-6&&(lambda0-=1e-6*sign0),abs(lambda1-sign1)<1e-6&&(lambda1-=1e-6*sign1),phi0=function clipAntimeridianIntersect(lambda0,phi0,lambda1,phi1){var cosPhi0,cosPhi1,sinLambda0Lambda1=sin$1(lambda0-lambda1);return abs(sinLambda0Lambda1)>1e-6?atan((sin$1(phi0)*(cosPhi1=cos$1(phi1))*sin$1(lambda1)-sin$1(phi1)*(cosPhi0=cos$1(phi0))*sin$1(lambda0))/(cosPhi0*cosPhi1*sinLambda0Lambda1)):(phi0+phi1)/2}(lambda0,phi0,lambda1,phi1),stream.point(sign0,phi0),stream.lineEnd(),stream.lineStart(),stream.point(sign1,phi0),clean=0),stream.point(lambda0=lambda1,phi0=phi1),sign0=sign1},lineEnd:function(){stream.lineEnd(),lambda0=phi0=NaN},clean:function(){return 2-clean}}}),(function clipAntimeridianInterpolate(from,to,direction,stream){var phi;if(null==from)phi=direction*halfPi$2,stream.point(-pi$3,phi),stream.point(0,phi),stream.point(pi$3,phi),stream.point(pi$3,0),stream.point(pi$3,-phi),stream.point(0,-phi),stream.point(-pi$3,-phi),stream.point(-pi$3,0),stream.point(-pi$3,phi);else if(abs(from[0]-to[0])>1e-6){var lambda=from[0]<to[0]?pi$3:-pi$3;phi=direction*lambda/2,stream.point(-lambda,phi),stream.point(0,phi),stream.point(lambda,phi)}else stream.point(to[0],to[1])}),[-pi$3,-halfPi$2]);var clipCircle=function(radius,delta){var cr=cos$1(radius),smallRadius=cr>0,notHemisphere=abs(cr)>1e-6;function visible(lambda,phi){return cos$1(lambda)*cos$1(phi)>cr}function intersect(a,b,two){var n1=[1,0,0],n2=cartesianCross(cartesian(a),cartesian(b)),n2n2=cartesianDot(n2,n2),n1n2=n2[0],determinant=n2n2-n1n2*n1n2;if(!determinant)return!two&&a;var c1=cr*n2n2/determinant,c2=-cr*n1n2/determinant,n1xn2=cartesianCross(n1,n2),A=cartesianScale(n1,c1);cartesianAddInPlace(A,cartesianScale(n2,c2));var u=n1xn2,w=cartesianDot(A,u),uu=cartesianDot(u,u),t2=w*w-uu*(cartesianDot(A,A)-1);if(!(t2<0)){var t=sqrt(t2),q=cartesianScale(u,(-w-t)/uu);if(cartesianAddInPlace(q,A),q=spherical(q),!two)return q;var z,lambda0=a[0],lambda1=b[0],phi0=a[1],phi1=b[1];lambda1<lambda0&&(z=lambda0,lambda0=lambda1,lambda1=z);var delta=lambda1-lambda0,polar=abs(delta-pi$3)<1e-6;if(!polar&&phi1<phi0&&(z=phi0,phi0=phi1,phi1=z),polar||delta<1e-6?polar?phi0+phi1>0^q[1]<(abs(q[0]-lambda0)<1e-6?phi0:phi1):phi0<=q[1]&&q[1]<=phi1:delta>pi$3^(lambda0<=q[0]&&q[0]<=lambda1)){var q1=cartesianScale(u,(-w+t)/uu);return cartesianAddInPlace(q1,A),[q,spherical(q1)]}}}function code(lambda,phi){var r=smallRadius?radius:pi$3-radius,code=0;return lambda<-r?code|=1:lambda>r&&(code|=2),phi<-r?code|=4:phi>r&&(code|=8),code}return clip(visible,(function clipLine(stream){var point0,c0,v0,v00,clean;return{lineStart:function(){v00=v0=!1,clean=1},point:function(lambda,phi){var point2,point1=[lambda,phi],v=visible(lambda,phi),c=smallRadius?v?0:code(lambda,phi):v?code(lambda+(lambda<0?pi$3:-pi$3),phi):0;if(!point0&&(v00=v0=v)&&stream.lineStart(),v!==v0&&(point2=intersect(point0,point1),(pointEqual(point0,point2)||pointEqual(point1,point2))&&(point1[0]+=1e-6,point1[1]+=1e-6,v=visible(point1[0],point1[1]))),v!==v0)clean=0,v?(stream.lineStart(),point2=intersect(point1,point0),stream.point(point2[0],point2[1])):(point2=intersect(point0,point1),stream.point(point2[0],point2[1]),stream.lineEnd()),point0=point2;else if(notHemisphere&&point0&&smallRadius^v){var t;c&c0||!(t=intersect(point1,point0,!0))||(clean=0,smallRadius?(stream.lineStart(),stream.point(t[0][0],t[0][1]),stream.point(t[1][0],t[1][1]),stream.lineEnd()):(stream.point(t[1][0],t[1][1]),stream.lineEnd(),stream.lineStart(),stream.point(t[0][0],t[0][1])))}!v||point0&&pointEqual(point0,point1)||stream.point(point1[0],point1[1]),point0=point1,v0=v,c0=c},lineEnd:function(){v0&&stream.lineEnd(),point0=null},clean:function(){return clean|(v00&&v0)<<1}}}),(function interpolate(from,to,direction,stream){circleStream(stream,radius,delta,direction,from,to)}),smallRadius?[0,-radius]:[-pi$3,radius-pi$3])};function transformer(methods){return function(stream){var s=new TransformStream;for(var key in methods)s[key]=methods[key];return s.stream=stream,s}}function TransformStream(){}function fitExtent(projection,extent,object){var w=extent[1][0]-extent[0][0],h=extent[1][1]-extent[0][1],clip=projection.clipExtent&&projection.clipExtent();projection.scale(150).translate([0,0]),null!=clip&&projection.clipExtent(null),geoStream(object,projection.stream(boundsStream$1));var b=boundsStream$1.result(),k=Math.min(w/(b[1][0]-b[0][0]),h/(b[1][1]-b[0][1])),x=+extent[0][0]+(w-k*(b[1][0]+b[0][0]))/2,y=+extent[0][1]+(h-k*(b[1][1]+b[0][1]))/2;return null!=clip&&projection.clipExtent(clip),projection.scale(150*k).translate([x,y])}function fitSize(projection,size,object){return fitExtent(projection,[[0,0],size],object)}TransformStream.prototype={constructor:TransformStream,point:function(x,y){this.stream.point(x,y)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}};var cosMinDistance=cos$1(30*radians),resample=function(project,delta2){return+delta2?function resample$1(project,delta2){function resampleLineTo(x0,y0,lambda0,a0,b0,c0,x1,y1,lambda1,a1,b1,c1,depth,stream){var dx=x1-x0,dy=y1-y0,d2=dx*dx+dy*dy;if(d2>4*delta2&&depth--){var a=a0+a1,b=b0+b1,c=c0+c1,m=sqrt(a*a+b*b+c*c),phi2=asin(c/=m),lambda2=abs(abs(c)-1)<1e-6||abs(lambda0-lambda1)<1e-6?(lambda0+lambda1)/2:atan2(b,a),p=project(lambda2,phi2),x2=p[0],y2=p[1],dx2=x2-x0,dy2=y2-y0,dz=dy*dx2-dx*dy2;(dz*dz/d2>delta2||abs((dx*dx2+dy*dy2)/d2-.5)>.3||a0*a1+b0*b1+c0*c1<cosMinDistance)&&(resampleLineTo(x0,y0,lambda0,a0,b0,c0,x2,y2,lambda2,a/=m,b/=m,c,depth,stream),stream.point(x2,y2),resampleLineTo(x2,y2,lambda2,a,b,c,x1,y1,lambda1,a1,b1,c1,depth,stream))}}return function(stream){var lambda00,x00,y00,a00,b00,c00,lambda0,x0,y0,a0,b0,c0,resampleStream={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){stream.polygonStart(),resampleStream.lineStart=ringStart},polygonEnd:function(){stream.polygonEnd(),resampleStream.lineStart=lineStart}};function point(x,y){x=project(x,y),stream.point(x[0],x[1])}function lineStart(){x0=NaN,resampleStream.point=linePoint,stream.lineStart()}function linePoint(lambda,phi){var c=cartesian([lambda,phi]),p=project(lambda,phi);resampleLineTo(x0,y0,lambda0,a0,b0,c0,x0=p[0],y0=p[1],lambda0=lambda,a0=c[0],b0=c[1],c0=c[2],16,stream),stream.point(x0,y0)}function lineEnd(){resampleStream.point=point,stream.lineEnd()}function ringStart(){lineStart(),resampleStream.point=ringPoint,resampleStream.lineEnd=ringEnd}function ringPoint(lambda,phi){linePoint(lambda00=lambda,phi),x00=x0,y00=y0,a00=a0,b00=b0,c00=c0,resampleStream.point=linePoint}function ringEnd(){resampleLineTo(x0,y0,lambda0,a0,b0,c0,x00,y00,lambda00,a00,b00,c00,16,stream),resampleStream.lineEnd=lineEnd,lineEnd()}return resampleStream}}(project,delta2):function resampleNone(project){return transformer({point:function(x,y){x=project(x,y),this.stream.point(x[0],x[1])}})}(project)};var transformRadians=transformer({point:function(x,y){this.stream.point(x*radians,y*radians)}});function projection(project){return projectionMutator((function(){return project}))()}function projectionMutator(projectAt){var project,dx,dy,rotate,projectRotate,y0,x1,y1,cache,cacheStream,k=150,x=480,y=250,lambda=0,phi=0,deltaLambda=0,deltaPhi=0,deltaGamma=0,theta=null,preclip=clipAntimeridian,x0=null,postclip=identity$4,delta2=.5,projectResample=resample(projectTransform,delta2);function projection(point){return[(point=projectRotate(point[0]*radians,point[1]*radians))[0]*k+dx,dy-point[1]*k]}function invert(point){return(point=projectRotate.invert((point[0]-dx)/k,(dy-point[1])/k))&&[point[0]*degrees$1,point[1]*degrees$1]}function projectTransform(x,y){return[(x=project(x,y))[0]*k+dx,dy-x[1]*k]}function recenter(){projectRotate=compose(rotate=rotateRadians(deltaLambda,deltaPhi,deltaGamma),project);var center=project(lambda,phi);return dx=x-center[0]*k,dy=y+center[1]*k,reset()}function reset(){return cache=cacheStream=null,projection}return projection.stream=function(stream){return cache&&cacheStream===stream?cache:cache=transformRadians(preclip(rotate,projectResample(postclip(cacheStream=stream))))},projection.clipAngle=function(_){return arguments.length?(preclip=+_?clipCircle(theta=_*radians,6*radians):(theta=null,clipAntimeridian),reset()):theta*degrees$1},projection.clipExtent=function(_){return arguments.length?(postclip=null==_?(x0=y0=x1=y1=null,identity$4):clipExtent(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reset()):null==x0?null:[[x0,y0],[x1,y1]]},projection.scale=function(_){return arguments.length?(k=+_,recenter()):k},projection.translate=function(_){return arguments.length?(x=+_[0],y=+_[1],recenter()):[x,y]},projection.center=function(_){return arguments.length?(lambda=_[0]%360*radians,phi=_[1]%360*radians,recenter()):[lambda*degrees$1,phi*degrees$1]},projection.rotate=function(_){return arguments.length?(deltaLambda=_[0]%360*radians,deltaPhi=_[1]%360*radians,deltaGamma=_.length>2?_[2]%360*radians:0,recenter()):[deltaLambda*degrees$1,deltaPhi*degrees$1,deltaGamma*degrees$1]},projection.precision=function(_){return arguments.length?(projectResample=resample(projectTransform,delta2=_*_),reset()):sqrt(delta2)},projection.fitExtent=function(extent,object){return fitExtent(projection,extent,object)},projection.fitSize=function(size,object){return fitSize(projection,size,object)},function(){return project=projectAt.apply(this,arguments),projection.invert=project.invert&&invert,recenter()}}function conicProjection(projectAt){var phi0=0,phi1=pi$3/3,m=projectionMutator(projectAt),p=m(phi0,phi1);return p.parallels=function(_){return arguments.length?m(phi0=_[0]*radians,phi1=_[1]*radians):[phi0*degrees$1,phi1*degrees$1]},p}function conicEqualAreaRaw(y0,y1){var sy0=sin$1(y0),n=(sy0+sin$1(y1))/2;if(abs(n)<1e-6)return function cylindricalEqualAreaRaw(phi0){var cosPhi0=cos$1(phi0);function forward(lambda,phi){return[lambda*cosPhi0,sin$1(phi)/cosPhi0]}return forward.invert=function(x,y){return[x/cosPhi0,asin(y*cosPhi0)]},forward}(y0);var c=1+sy0*(2*n-sy0),r0=sqrt(c)/n;function project(x,y){var r=sqrt(c-2*n*sin$1(y))/n;return[r*sin$1(x*=n),r0-r*cos$1(x)]}return project.invert=function(x,y){var r0y=r0-y;return[atan2(x,abs(r0y))/n*sign(r0y),asin((c-(x*x+r0y*r0y)*n*n)/(2*n))]},project}var conicEqualArea=function(){return conicProjection(conicEqualAreaRaw).scale(155.424).center([0,33.6442])},albers=function(){return conicEqualArea().parallels([29.5,45.5]).scale(1070).translate([480,250]).rotate([96,0]).center([-.6,38.7])};function azimuthalRaw(scale){return function(x,y){var cx=cos$1(x),cy=cos$1(y),k=scale(cx*cy);return[k*cy*sin$1(x),k*sin$1(y)]}}function azimuthalInvert(angle){return function(x,y){var z=sqrt(x*x+y*y),c=angle(z),sc=sin$1(c),cc=cos$1(c);return[atan2(x*sc,z*cc),asin(z&&y*sc/z)]}}var azimuthalEqualAreaRaw=azimuthalRaw((function(cxcy){return sqrt(2/(1+cxcy))}));azimuthalEqualAreaRaw.invert=azimuthalInvert((function(z){return 2*asin(z/2)}));var azimuthalEquidistantRaw=azimuthalRaw((function(c){return(c=acos(c))&&c/sin$1(c)}));azimuthalEquidistantRaw.invert=azimuthalInvert((function(z){return z}));function mercatorRaw(lambda,phi){return[lambda,log(tan((halfPi$2+phi)/2))]}mercatorRaw.invert=function(x,y){return[x,2*atan(exp(y))-halfPi$2]};function mercatorProjection(project){var y0,x1,y1,m=projection(project),center=m.center,scale=m.scale,translate=m.translate,clipExtent=m.clipExtent,x0=null;function reclip(){var k=pi$3*scale(),t=m(rotation(m.rotate()).invert([0,0]));return clipExtent(null==x0?[[t[0]-k,t[1]-k],[t[0]+k,t[1]+k]]:project===mercatorRaw?[[Math.max(t[0]-k,x0),y0],[Math.min(t[0]+k,x1),y1]]:[[x0,Math.max(t[1]-k,y0)],[x1,Math.min(t[1]+k,y1)]])}return m.scale=function(_){return arguments.length?(scale(_),reclip()):scale()},m.translate=function(_){return arguments.length?(translate(_),reclip()):translate()},m.center=function(_){return arguments.length?(center(_),reclip()):center()},m.clipExtent=function(_){return arguments.length?(null==_?x0=y0=x1=y1=null:(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reclip()):null==x0?null:[[x0,y0],[x1,y1]]},reclip()}function tany(y){return tan((halfPi$2+y)/2)}function conicConformalRaw(y0,y1){var cy0=cos$1(y0),n=y0===y1?sin$1(y0):log(cy0/cos$1(y1))/log(tany(y1)/tany(y0)),f=cy0*pow(tany(y0),n)/n;if(!n)return mercatorRaw;function project(x,y){f>0?y<1e-6-halfPi$2&&(y=1e-6-halfPi$2):y>halfPi$2-1e-6&&(y=halfPi$2-1e-6);var r=f/pow(tany(y),n);return[r*sin$1(n*x),f-r*cos$1(n*x)]}return project.invert=function(x,y){var fy=f-y,r=sign(n)*sqrt(x*x+fy*fy);return[atan2(x,abs(fy))/n*sign(fy),2*atan(pow(f/r,1/n))-halfPi$2]},project}function equirectangularRaw(lambda,phi){return[lambda,phi]}equirectangularRaw.invert=equirectangularRaw;function conicEquidistantRaw(y0,y1){var cy0=cos$1(y0),n=y0===y1?sin$1(y0):(cy0-cos$1(y1))/(y1-y0),g=cy0/n+y0;if(abs(n)<1e-6)return equirectangularRaw;function project(x,y){var gy=g-y,nx=n*x;return[gy*sin$1(nx),g-gy*cos$1(nx)]}return project.invert=function(x,y){var gy=g-y;return[atan2(x,abs(gy))/n*sign(gy),g-sign(n)*sqrt(x*x+gy*gy)]},project}function gnomonicRaw(x,y){var cy=cos$1(y),k=cos$1(x)*cy;return[cy*sin$1(x)/k,sin$1(y)/k]}gnomonicRaw.invert=azimuthalInvert(atan);function scaleTranslate(kx,ky,tx,ty){return 1===kx&&1===ky&&0===tx&&0===ty?identity$4:transformer({point:function(x,y){this.stream.point(x*kx+tx,y*ky+ty)}})}function orthographicRaw(x,y){return[cos$1(y)*sin$1(x),sin$1(y)]}orthographicRaw.invert=azimuthalInvert(asin);function stereographicRaw(x,y){var cy=cos$1(y),k=1+cos$1(x)*cy;return[cy*sin$1(x)/k,sin$1(y)/k]}stereographicRaw.invert=azimuthalInvert((function(z){return 2*atan(z)}));function transverseMercatorRaw(lambda,phi){return[log(tan((halfPi$2+phi)/2)),-lambda]}transverseMercatorRaw.invert=function(x,y){return[-y,2*atan(exp(x))-halfPi$2]};function defaultSeparation(a,b){return a.parent===b.parent?1:2}function meanXReduce(x,c){return x+c.x}function maxYReduce(y,c){return Math.max(y,c.y)}function count(node){var sum=0,children=node.children,i=children&&children.length;if(i)for(;--i>=0;)sum+=children[i].value;else sum=1;node.value=sum}function hierarchy(data,children){var node,child,childs,i,n,root=new Node(data),valued=+data.value&&(root.value=data.value),nodes=[root];for(null==children&&(children=defaultChildren);node=nodes.pop();)if(valued&&(node.value=+node.data.value),(childs=children(node.data))&&(n=childs.length))for(node.children=new Array(n),i=n-1;i>=0;--i)nodes.push(child=node.children[i]=new Node(childs[i])),child.parent=node,child.depth=node.depth+1;return root.eachBefore(computeHeight)}function defaultChildren(d){return d.children}function copyData(node){node.data=node.data.data}function computeHeight(node){var height=0;do{node.height=height}while((node=node.parent)&&node.height<++height)}function Node(data){this.data=data,this.depth=this.height=0,this.parent=null}function Node$2(value){this._=value,this.next=null}Node.prototype=hierarchy.prototype={constructor:Node,count:function(){return this.eachAfter(count)},each:function(callback){var current,children,i,n,node=this,next=[node];do{for(current=next.reverse(),next=[];node=current.pop();)if(callback(node),children=node.children)for(i=0,n=children.length;i<n;++i)next.push(children[i])}while(next.length);return this},eachAfter:function(callback){for(var children,i,n,node=this,nodes=[node],next=[];node=nodes.pop();)if(next.push(node),children=node.children)for(i=0,n=children.length;i<n;++i)nodes.push(children[i]);for(;node=next.pop();)callback(node);return this},eachBefore:function(callback){for(var children,i,node=this,nodes=[node];node=nodes.pop();)if(callback(node),children=node.children)for(i=children.length-1;i>=0;--i)nodes.push(children[i]);return this},sum:function(value){return this.eachAfter((function(node){for(var sum=+value(node.data)||0,children=node.children,i=children&&children.length;--i>=0;)sum+=children[i].value;node.value=sum}))},sort:function(compare){return this.eachBefore((function(node){node.children&&node.children.sort(compare)}))},path:function(end){for(var start=this,ancestor=function leastCommonAncestor(a,b){if(a===b)return a;var aNodes=a.ancestors(),bNodes=b.ancestors(),c=null;a=aNodes.pop(),b=bNodes.pop();for(;a===b;)c=a,a=aNodes.pop(),b=bNodes.pop();return c}(start,end),nodes=[start];start!==ancestor;)start=start.parent,nodes.push(start);for(var k=nodes.length;end!==ancestor;)nodes.splice(k,0,end),end=end.parent;return nodes},ancestors:function(){for(var node=this,nodes=[node];node=node.parent;)nodes.push(node);return nodes},descendants:function(){var nodes=[];return this.each((function(node){nodes.push(node)})),nodes},leaves:function(){var leaves=[];return this.eachBefore((function(node){node.children||leaves.push(node)})),leaves},links:function(){var root=this,links=[];return root.each((function(node){node!==root&&links.push({source:node.parent,target:node})})),links},copy:function node_copy(){return hierarchy(this).eachBefore(copyData)}};var enclose=function(circles){return function encloseN(L,B){var circle,l2,p1,l0=null,l1=L.head;switch(B.length){case 1:circle=function enclose1(a){return{x:a.x,y:a.y,r:a.r}}(B[0]);break;case 2:circle=function enclose2(a,b){var x1=a.x,y1=a.y,r1=a.r,x2=b.x,y2=b.y,r2=b.r,x21=x2-x1,y21=y2-y1,r21=r2-r1,l=Math.sqrt(x21*x21+y21*y21);return{x:(x1+x2+x21/l*r21)/2,y:(y1+y2+y21/l*r21)/2,r:(l+r1+r2)/2}}(B[0],B[1]);break;case 3:circle=function enclose3(a,b,c){var x1=a.x,y1=a.y,r1=a.r,x2=b.x,y2=b.y,r2=b.r,x3=c.x,y3=c.y,r3=c.r,a2=2*(x1-x2),b2=2*(y1-y2),c2=2*(r2-r1),d2=x1*x1+y1*y1-r1*r1-x2*x2-y2*y2+r2*r2,a3=2*(x1-x3),b3=2*(y1-y3),c3=2*(r3-r1),d3=x1*x1+y1*y1-r1*r1-x3*x3-y3*y3+r3*r3,ab=a3*b2-a2*b3,xa=(b2*d3-b3*d2)/ab-x1,xb=(b3*c2-b2*c3)/ab,ya=(a3*d2-a2*d3)/ab-y1,yb=(a2*c3-a3*c2)/ab,A=xb*xb+yb*yb-1,B=2*(xa*xb+ya*yb+r1),C=xa*xa+ya*ya-r1*r1,r=(-B-Math.sqrt(B*B-4*A*C))/(2*A);return{x:xa+xb*r+x1,y:ya+yb*r+y1,r:r}}(B[0],B[1],B[2])}for(;l1;)p1=l1._,l2=l1.next,circle&&encloses(circle,p1)?l0=l1:(l0?(L.tail=l0,l0.next=null):L.head=L.tail=null,B.push(p1),circle=encloseN(L,B),B.pop(),L.head?(l1.next=L.head,L.head=l1):(l1.next=null,L.head=L.tail=l1),(l0=L.tail).next=l2),l1=l2;return L.tail=l0,circle}(function(array){for(var n=(array=array.slice()).length,head=null,node=head;n;){var next=new Node$2(array[n-1]);node=node?node.next=next:head=next,array[void 0]=array[--n]}return{head:head,tail:node}}(circles),[])};function encloses(a,b){var dx=b.x-a.x,dy=b.y-a.y,dr=a.r-b.r;return dr*dr+1e-6>dx*dx+dy*dy}function place(a,b,c){var ax=a.x,ay=a.y,da=b.r+c.r,db=a.r+c.r,dx=b.x-ax,dy=b.y-ay,dc=dx*dx+dy*dy;if(dc){var x=.5+((db*=db)-(da*=da))/(2*dc),y=Math.sqrt(Math.max(0,2*da*(db+dc)-(db-=dc)*db-da*da))/(2*dc);c.x=ax+x*dx+y*dy,c.y=ay+x*dy-y*dx}else c.x=ax+db,c.y=ay}function intersects(a,b){var dx=b.x-a.x,dy=b.y-a.y,dr=a.r+b.r;return dr*dr-1e-6>dx*dx+dy*dy}function distance2(node,x,y){var a=node._,b=node.next._,ab=a.r+b.r,dx=(a.x*b.r+b.x*a.r)/ab-x,dy=(a.y*b.r+b.y*a.r)/ab-y;return dx*dx+dy*dy}function Node$1(circle){this._=circle,this.next=null,this.previous=null}function packEnclose(circles){if(!(n=circles.length))return 0;var a,b,c,n;if((a=circles[0]).x=0,a.y=0,!(n>1))return a.r;if(b=circles[1],a.x=-b.r,b.x=a.r,b.y=0,!(n>2))return a.r+b.r;place(b,a,c=circles[2]);var cx,cy,i,j,k,sj,sk,aa=a.r*a.r,ba=b.r*b.r,ca=c.r*c.r,oa=aa+ba+ca,ox=aa*a.x+ba*b.x+ca*c.x,oy=aa*a.y+ba*b.y+ca*c.y;a=new Node$1(a),b=new Node$1(b),c=new Node$1(c),a.next=c.previous=b,b.next=a.previous=c,c.next=b.previous=a;pack:for(i=3;i<n;++i){place(a._,b._,c=circles[i]),c=new Node$1(c),j=b.next,k=a.previous,sj=b._.r,sk=a._.r;do{if(sj<=sk){if(intersects(j._,c._)){b=j,a.next=b,b.previous=a,--i;continue pack}sj+=j._.r,j=j.next}else{if(intersects(k._,c._)){(a=k).next=b,b.previous=a,--i;continue pack}sk+=k._.r,k=k.previous}}while(j!==k.next);for(c.previous=a,c.next=b,a.next=b.previous=b=c,oa+=ca=c._.r*c._.r,aa=distance2(a,cx=(ox+=ca*c._.x)/oa,cy=(oy+=ca*c._.y)/oa);(c=c.next)!==b;)(ca=distance2(c,cx,cy))<aa&&(a=c,aa=ca);b=a.next}for(a=[b._],c=b;(c=c.next)!==b;)a.push(c._);for(c=enclose(a),i=0;i<n;++i)(a=circles[i]).x-=c.x,a.y-=c.y;return c.r}function optional(f){return null==f?null:required(f)}function required(f){if("function"!=typeof f)throw new Error;return f}function constantZero(){return 0}var constant$8=function(x){return function(){return x}};function defaultRadius$1(d){return Math.sqrt(d.value)}function radiusLeaf(radius){return function(node){node.children||(node.r=Math.max(0,+radius(node)||0))}}function packChildren(padding,k){return function(node){if(children=node.children){var children,i,e,n=children.length,r=padding(node)*k||0;if(r)for(i=0;i<n;++i)children[i].r+=r;if(e=packEnclose(children),r)for(i=0;i<n;++i)children[i].r-=r;node.r=e+r}}}function translateChild(k){return function(node){var parent=node.parent;node.r*=k,parent&&(node.x=parent.x+k*node.x,node.y=parent.y+k*node.y)}}var roundNode=function(node){node.x0=Math.round(node.x0),node.y0=Math.round(node.y0),node.x1=Math.round(node.x1),node.y1=Math.round(node.y1)},treemapDice=function(parent,x0,y0,x1,y1){for(var node,nodes=parent.children,i=-1,n=nodes.length,k=parent.value&&(x1-x0)/parent.value;++i<n;)(node=nodes[i]).y0=y0,node.y1=y1,node.x0=x0,node.x1=x0+=node.value*k},preroot={depth:-1},ambiguous={};function defaultId(d){return d.id}function defaultParentId(d){return d.parentId}function defaultSeparation$1(a,b){return a.parent===b.parent?1:2}function nextLeft(v){var children=v.children;return children?children[0]:v.t}function nextRight(v){var children=v.children;return children?children[children.length-1]:v.t}function moveSubtree(wm,wp,shift){var change=shift/(wp.i-wm.i);wp.c-=change,wp.s+=shift,wm.c+=change,wp.z+=shift,wp.m+=shift}function nextAncestor(vim,v,ancestor){return vim.a.parent===v.parent?vim.a:ancestor}function TreeNode(node,i){this._=node,this.parent=null,this.children=null,this.A=null,this.a=this,this.z=0,this.m=0,this.c=0,this.s=0,this.t=null,this.i=i}TreeNode.prototype=Object.create(Node.prototype);var treemapSlice=function(parent,x0,y0,x1,y1){for(var node,nodes=parent.children,i=-1,n=nodes.length,k=parent.value&&(y1-y0)/parent.value;++i<n;)(node=nodes[i]).x0=x0,node.x1=x1,node.y0=y0,node.y1=y0+=node.value*k},phi=(1+Math.sqrt(5))/2;function squarifyRatio(ratio,parent,x0,y0,x1,y1){for(var row,nodeValue,dx,dy,sumValue,minValue,maxValue,newRatio,minRatio,alpha,beta,rows=[],nodes=parent.children,i0=0,i1=0,n=nodes.length,value=parent.value;i0<n;){dx=x1-x0,dy=y1-y0;do{sumValue=nodes[i1++].value}while(!sumValue&&i1<n);for(minValue=maxValue=sumValue,beta=sumValue*sumValue*(alpha=Math.max(dy/dx,dx/dy)/(value*ratio)),minRatio=Math.max(maxValue/beta,beta/minValue);i1<n;++i1){if(sumValue+=nodeValue=nodes[i1].value,nodeValue<minValue&&(minValue=nodeValue),nodeValue>maxValue&&(maxValue=nodeValue),beta=sumValue*sumValue*alpha,(newRatio=Math.max(maxValue/beta,beta/minValue))>minRatio){sumValue-=nodeValue;break}minRatio=newRatio}rows.push(row={value:sumValue,dice:dx<dy,children:nodes.slice(i0,i1)}),row.dice?treemapDice(row,x0,y0,x1,value?y0+=dy*sumValue/value:y1):treemapSlice(row,x0,y0,value?x0+=dx*sumValue/value:x1,y1),value-=sumValue,i0=i1}return rows}var squarify=function custom(ratio){function squarify(parent,x0,y0,x1,y1){squarifyRatio(ratio,parent,x0,y0,x1,y1)}return squarify.ratio=function(x){return custom((x=+x)>1?x:1)},squarify}(phi),resquarify=function custom(ratio){function resquarify(parent,x0,y0,x1,y1){if((rows=parent._squarify)&&rows.ratio===ratio)for(var rows,row,nodes,i,n,j=-1,m=rows.length,value=parent.value;++j<m;){for(nodes=(row=rows[j]).children,i=row.value=0,n=nodes.length;i<n;++i)row.value+=nodes[i].value;row.dice?treemapDice(row,x0,y0,x1,y0+=(y1-y0)*row.value/value):treemapSlice(row,x0,y0,x0+=(x1-x0)*row.value/value,y1),value-=row.value}else parent._squarify=rows=squarifyRatio(ratio,parent,x0,y0,x1,y1),rows.ratio=ratio}return resquarify.ratio=function(x){return custom((x=+x)>1?x:1)},resquarify}(phi),cross$1=function(a,b,c){return(b[0]-a[0])*(c[1]-a[1])-(b[1]-a[1])*(c[0]-a[0])};function lexicographicOrder(a,b){return a[0]-b[0]||a[1]-b[1]}function computeUpperHullIndexes(points){for(var n=points.length,indexes=[0,1],size=2,i=2;i<n;++i){for(;size>1&&cross$1(points[indexes[size-2]],points[indexes[size-1]],points[i])<=0;)--size;indexes[size++]=i}return indexes.slice(0,size)}var slice$3=[].slice,noabort={};function Queue(size){if(!(size>=1))throw new Error;this._size=size,this._call=this._error=null,this._tasks=[],this._data=[],this._waiting=this._active=this._ended=this._start=0}function poke$1(q){if(!q._start)try{!function start$1(q){for(;q._start=q._waiting&&q._active<q._size;){var i=q._ended+q._active,t=q._tasks[i],j=t.length-1,c=t[j];t[j]=end(q,i),--q._waiting,++q._active,t=c.apply(null,t),q._tasks[i]&&(q._tasks[i]=t||noabort)}}(q)}catch(e){if(q._tasks[q._ended+q._active-1])abort(q,e);else if(!q._data)throw e}}function end(q,i){return function(e,r){q._tasks[i]&&(--q._active,++q._ended,q._tasks[i]=null,null==q._error&&(null!=e?abort(q,e):(q._data[i]=r,q._waiting?poke$1(q):maybeNotify(q))))}}function abort(q,e){var t,i=q._tasks.length;for(q._error=e,q._data=void 0,q._waiting=NaN;--i>=0;)if((t=q._tasks[i])&&(q._tasks[i]=null,t.abort))try{t.abort()}catch(e){}q._active=NaN,maybeNotify(q)}function maybeNotify(q){if(!q._active&&q._call){var d=q._data;q._data=void 0,q._call(q._error,d)}}function queue(concurrency){return new Queue(arguments.length?+concurrency:1/0)}Queue.prototype=queue.prototype={constructor:Queue,defer:function(callback){if("function"!=typeof callback||this._call)throw new Error;if(null!=this._error)return this;var t=slice$3.call(arguments,1);return t.push(callback),++this._waiting,this._tasks.push(t),poke$1(this),this},abort:function(){return null==this._error&&abort(this,new Error("abort")),this},await:function(callback){if("function"!=typeof callback||this._call)throw new Error;return this._call=function(error,results){callback.apply(null,[error].concat(results))},maybeNotify(this),this},awaitAll:function(callback){if("function"!=typeof callback||this._call)throw new Error;return this._call=callback,maybeNotify(this),this}};var normal=function(mu,sigma){var x,r;return mu=null==mu?0:+mu,sigma=null==sigma?1:+sigma,function(){var y;if(null!=x)y=x,x=null;else do{x=2*Math.random()-1,y=2*Math.random()-1,r=x*x+y*y}while(!r||r>1);return mu+sigma*y*Math.sqrt(-2*Math.log(r)/r)}},irwinHall=function(n){return function(){for(var sum=0,i=0;i<n;++i)sum+=Math.random();return sum}},request=function(url,callback){var request,mimeType,response,responseType,event=dispatch("beforesend","progress","load","error"),headers=map$1(),xhr=new XMLHttpRequest,user=null,password=null,timeout=0;function respond(o){var result,status=xhr.status;if(!status&&function hasResponse(xhr){var type=xhr.responseType;return type&&"text"!==type?xhr.response:xhr.responseText}(xhr)||status>=200&&status<300||304===status){if(response)try{result=response.call(request,xhr)}catch(e){return void event.call("error",request,e)}else result=xhr;event.call("load",request,result)}else event.call("error",request,o)}if("undefined"!=typeof XDomainRequest&&!("withCredentials"in xhr)&&/^(http(s)?:)?\/\//.test(url)&&(xhr=new XDomainRequest),"onload"in xhr?xhr.onload=xhr.onerror=xhr.ontimeout=respond:xhr.onreadystatechange=function(o){xhr.readyState>3&&respond(o)},xhr.onprogress=function(e){event.call("progress",request,e)},request={header:function(name,value){return name=(name+"").toLowerCase(),arguments.length<2?headers.get(name):(null==value?headers.remove(name):headers.set(name,value+""),request)},mimeType:function(value){return arguments.length?(mimeType=null==value?null:value+"",request):mimeType},responseType:function(value){return arguments.length?(responseType=value,request):responseType},timeout:function(value){return arguments.length?(timeout=+value,request):timeout},user:function(value){return arguments.length<1?user:(user=null==value?null:value+"",request)},password:function(value){return arguments.length<1?password:(password=null==value?null:value+"",request)},response:function(value){return response=value,request},get:function(data,callback){return request.send("GET",data,callback)},post:function(data,callback){return request.send("POST",data,callback)},send:function(method,data,callback){return xhr.open(method,url,!0,user,password),null==mimeType||headers.has("accept")||headers.set("accept",mimeType+",*/*"),xhr.setRequestHeader&&headers.each((function(value,name){xhr.setRequestHeader(name,value)})),null!=mimeType&&xhr.overrideMimeType&&xhr.overrideMimeType(mimeType),null!=responseType&&(xhr.responseType=responseType),timeout>0&&(xhr.timeout=timeout),null==callback&&"function"==typeof data&&(callback=data,data=null),null!=callback&&1===callback.length&&(callback=function fixCallback(callback){return function(error,xhr){callback(null==error?xhr:null)}}(callback)),null!=callback&&request.on("error",callback).on("load",(function(xhr){callback(null,xhr)})),event.call("beforesend",request,xhr),xhr.send(null==data?null:data),request},abort:function(){return xhr.abort(),request},on:function(){var value=event.on.apply(event,arguments);return value===event?request:value}},null!=callback){if("function"!=typeof callback)throw new Error("invalid callback: "+callback);return request.get(callback)}return request};var type$1=function(defaultMimeType,response){return function(url,callback){var r=request(url).mimeType(defaultMimeType).response(response);if(null!=callback){if("function"!=typeof callback)throw new Error("invalid callback: "+callback);return r.get(callback)}return r}},html=type$1("text/html",(function(xhr){return document.createRange().createContextualFragment(xhr.responseText)})),json=type$1("application/json",(function(xhr){return JSON.parse(xhr.responseText)})),text=type$1("text/plain",(function(xhr){return xhr.responseText})),xml=type$1("application/xml",(function(xhr){var xml=xhr.responseXML;if(!xml)throw new Error("parse error");return xml})),dsv$1=function(defaultMimeType,parse){return function(url,row,callback){arguments.length<3&&(callback=row,row=null);var r=request(url).mimeType(defaultMimeType);return r.row=function(_){return arguments.length?r.response(responseOf(parse,row=_)):row},r.row(row),callback?r.get(callback):r}};function responseOf(parse,row){return function(request$$1){return parse(request$$1.responseText,row)}}var csv$1=dsv$1("text/csv",csvParse),tsv$1=dsv$1("text/tab-separated-values",tsvParse),array$2=Array.prototype,map$3=array$2.map,slice$4=array$2.slice,implicit={name:"implicit"};function ordinal(range){var index=map$1(),domain=[],unknown=implicit;function scale(d){var key=d+"",i=index.get(key);if(!i){if(unknown!==implicit)return unknown;index.set(key,i=domain.push(d))}return range[(i-1)%range.length]}return range=null==range?[]:slice$4.call(range),scale.domain=function(_){if(!arguments.length)return domain.slice();domain=[],index=map$1();for(var d,key,i=-1,n=_.length;++i<n;)index.has(key=(d=_[i])+"")||index.set(key,domain.push(d));return scale},scale.range=function(_){return arguments.length?(range=slice$4.call(_),scale):range.slice()},scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown},scale.copy=function(){return ordinal().domain(domain).range(range).unknown(unknown)},scale}function band(){var step,bandwidth,scale=ordinal().unknown(void 0),domain=scale.domain,ordinalRange=scale.range,range$$1=[0,1],round=!1,paddingInner=0,paddingOuter=0,align=.5;function rescale(){var n=domain().length,reverse=range$$1[1]<range$$1[0],start=range$$1[reverse-0],stop=range$$1[1-reverse];step=(stop-start)/Math.max(1,n-paddingInner+2*paddingOuter),round&&(step=Math.floor(step)),start+=(stop-start-step*(n-paddingInner))*align,bandwidth=step*(1-paddingInner),round&&(start=Math.round(start),bandwidth=Math.round(bandwidth));var values=sequence(n).map((function(i){return start+step*i}));return ordinalRange(reverse?values.reverse():values)}return delete scale.unknown,scale.domain=function(_){return arguments.length?(domain(_),rescale()):domain()},scale.range=function(_){return arguments.length?(range$$1=[+_[0],+_[1]],rescale()):range$$1.slice()},scale.rangeRound=function(_){return range$$1=[+_[0],+_[1]],round=!0,rescale()},scale.bandwidth=function(){return bandwidth},scale.step=function(){return step},scale.round=function(_){return arguments.length?(round=!!_,rescale()):round},scale.padding=function(_){return arguments.length?(paddingInner=paddingOuter=Math.max(0,Math.min(1,_)),rescale()):paddingInner},scale.paddingInner=function(_){return arguments.length?(paddingInner=Math.max(0,Math.min(1,_)),rescale()):paddingInner},scale.paddingOuter=function(_){return arguments.length?(paddingOuter=Math.max(0,Math.min(1,_)),rescale()):paddingOuter},scale.align=function(_){return arguments.length?(align=Math.max(0,Math.min(1,_)),rescale()):align},scale.copy=function(){return band().domain(domain()).range(range$$1).round(round).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align)},rescale()}var constant$9=function(x){return function(){return x}},number$1=function(x){return+x},unit=[0,1];function deinterpolateLinear(a,b){return(b-=a=+a)?function(x){return(x-a)/b}:constant$9(b)}function bimap(domain,range$$1,deinterpolate,reinterpolate){var d0=domain[0],d1=domain[1],r0=range$$1[0],r1=range$$1[1];return d1<d0?(d0=deinterpolate(d1,d0),r0=reinterpolate(r1,r0)):(d0=deinterpolate(d0,d1),r0=reinterpolate(r0,r1)),function(x){return r0(d0(x))}}function polymap(domain,range$$1,deinterpolate,reinterpolate){var j=Math.min(domain.length,range$$1.length)-1,d=new Array(j),r=new Array(j),i=-1;for(domain[j]<domain[0]&&(domain=domain.slice().reverse(),range$$1=range$$1.slice().reverse());++i<j;)d[i]=deinterpolate(domain[i],domain[i+1]),r[i]=reinterpolate(range$$1[i],range$$1[i+1]);return function(x){var i=bisectRight(domain,x,1,j)-1;return r[i](d[i](x))}}function copy(source,target){return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp())}function continuous(deinterpolate,reinterpolate){var piecewise,output,input,domain=unit,range$$1=unit,interpolate$$1=interpolateValue,clamp=!1;function rescale(){return piecewise=Math.min(domain.length,range$$1.length)>2?polymap:bimap,output=input=null,scale}function scale(x){return(output||(output=piecewise(domain,range$$1,clamp?function deinterpolateClamp(deinterpolate){return function(a,b){var d=deinterpolate(a=+a,b=+b);return function(x){return x<=a?0:x>=b?1:d(x)}}}(deinterpolate):deinterpolate,interpolate$$1)))(+x)}return scale.invert=function(y){return(input||(input=piecewise(range$$1,domain,deinterpolateLinear,clamp?function reinterpolateClamp(reinterpolate){return function(a,b){var r=reinterpolate(a=+a,b=+b);return function(t){return t<=0?a:t>=1?b:r(t)}}}(reinterpolate):reinterpolate)))(+y)},scale.domain=function(_){return arguments.length?(domain=map$3.call(_,number$1),rescale()):domain.slice()},scale.range=function(_){return arguments.length?(range$$1=slice$4.call(_),rescale()):range$$1.slice()},scale.rangeRound=function(_){return range$$1=slice$4.call(_),interpolate$$1=interpolateRound,rescale()},scale.clamp=function(_){return arguments.length?(clamp=!!_,rescale()):clamp},scale.interpolate=function(_){return arguments.length?(interpolate$$1=_,rescale()):interpolate$$1},rescale()}function linearish(scale){var domain=scale.domain;return scale.ticks=function(count){var d=domain();return ticks(d[0],d[d.length-1],null==count?10:count)},scale.tickFormat=function(count,specifier){return function(domain,count,specifier){var precision,start=domain[0],stop=domain[domain.length-1],step=tickStep(start,stop,null==count?10:count);switch((specifier=formatSpecifier(null==specifier?",f":specifier)).type){case"s":var value=Math.max(Math.abs(start),Math.abs(stop));return null!=specifier.precision||isNaN(precision=precisionPrefix(step,value))||(specifier.precision=precision),exports.formatPrefix(specifier,value);case"":case"e":case"g":case"p":case"r":null!=specifier.precision||isNaN(precision=precisionRound(step,Math.max(Math.abs(start),Math.abs(stop))))||(specifier.precision=precision-("e"===specifier.type));break;case"f":case"%":null!=specifier.precision||isNaN(precision=precisionFixed(step))||(specifier.precision=precision-2*("%"===specifier.type))}return exports.format(specifier)}(domain(),count,specifier)},scale.nice=function(count){var d=domain(),i=d.length-1,n=null==count?10:count,start=d[0],stop=d[i],step=tickStep(start,stop,n);return step&&(step=tickStep(Math.floor(start/step)*step,Math.ceil(stop/step)*step,n),d[0]=Math.floor(start/step)*step,d[i]=Math.ceil(stop/step)*step,domain(d)),scale},scale}var nice=function(domain,interval){var t,i0=0,i1=(domain=domain.slice()).length-1,x0=domain[i0],x1=domain[i1];return x1<x0&&(t=i0,i0=i1,i1=t,t=x0,x0=x1,x1=t),domain[i0]=interval.floor(x0),domain[i1]=interval.ceil(x1),domain};function deinterpolate(a,b){return(b=Math.log(b/a))?function(x){return Math.log(x/a)/b}:constant$9(b)}function reinterpolate$1(a,b){return a<0?function(t){return-Math.pow(-b,t)*Math.pow(-a,1-t)}:function(t){return Math.pow(b,t)*Math.pow(a,1-t)}}function pow10(x){return isFinite(x)?+("1e"+x):x<0?0:x}function powp(base){return 10===base?pow10:base===Math.E?Math.exp:function(x){return Math.pow(base,x)}}function logp(base){return base===Math.E?Math.log:10===base&&Math.log10||2===base&&Math.log2||(base=Math.log(base),function(x){return Math.log(x)/base})}function reflect(f){return function(x){return-f(-x)}}function raise$1(x,exponent){return x<0?-Math.pow(-x,exponent):Math.pow(x,exponent)}function pow$1(){var exponent=1,scale=continuous((function deinterpolate(a,b){return(b=raise$1(b,exponent)-(a=raise$1(a,exponent)))?function(x){return(raise$1(x,exponent)-a)/b}:constant$9(b)}),(function reinterpolate(a,b){return b=raise$1(b,exponent)-(a=raise$1(a,exponent)),function(t){return raise$1(a+b*t,1/exponent)}})),domain=scale.domain;return scale.exponent=function(_){return arguments.length?(exponent=+_,domain(domain())):exponent},scale.copy=function(){return copy(scale,pow$1().exponent(exponent))},linearish(scale)}var t0$1=new Date,t1$1=new Date;function newInterval(floori,offseti,count,field){function interval(date){return floori(date=new Date(+date)),date}return interval.floor=interval,interval.ceil=function(date){return floori(date=new Date(date-1)),offseti(date,1),floori(date),date},interval.round=function(date){var d0=interval(date),d1=interval.ceil(date);return date-d0<d1-date?d0:d1},interval.offset=function(date,step){return offseti(date=new Date(+date),null==step?1:Math.floor(step)),date},interval.range=function(start,stop,step){var range=[];if(start=interval.ceil(start),step=null==step?1:Math.floor(step),!(start<stop&&step>0))return range;do{range.push(new Date(+start))}while(offseti(start,step),floori(start),start<stop);return range},interval.filter=function(test){return newInterval((function(date){if(date>=date)for(;floori(date),!test(date);)date.setTime(date-1)}),(function(date,step){if(date>=date)for(;--step>=0;)for(;offseti(date,1),!test(date););}))},count&&(interval.count=function(start,end){return t0$1.setTime(+start),t1$1.setTime(+end),floori(t0$1),floori(t1$1),Math.floor(count(t0$1,t1$1))},interval.every=function(step){return step=Math.floor(step),isFinite(step)&&step>0?step>1?interval.filter(field?function(d){return field(d)%step==0}:function(d){return interval.count(0,d)%step==0}):interval:null}),interval}var millisecond=newInterval((function(){}),(function(date,step){date.setTime(+date+step)}),(function(start,end){return end-start}));millisecond.every=function(k){return k=Math.floor(k),isFinite(k)&&k>0?k>1?newInterval((function(date){date.setTime(Math.floor(date/k)*k)}),(function(date,step){date.setTime(+date+step*k)}),(function(start,end){return(end-start)/k})):millisecond:null};var milliseconds=millisecond.range,second=newInterval((function(date){date.setTime(1e3*Math.floor(date/1e3))}),(function(date,step){date.setTime(+date+1e3*step)}),(function(start,end){return(end-start)/1e3}),(function(date){return date.getUTCSeconds()})),seconds=second.range,minute=newInterval((function(date){date.setTime(6e4*Math.floor(date/6e4))}),(function(date,step){date.setTime(+date+6e4*step)}),(function(start,end){return(end-start)/6e4}),(function(date){return date.getMinutes()})),minutes=minute.range,hour=newInterval((function(date){var offset=6e4*date.getTimezoneOffset()%36e5;offset<0&&(offset+=36e5),date.setTime(36e5*Math.floor((+date-offset)/36e5)+offset)}),(function(date,step){date.setTime(+date+36e5*step)}),(function(start,end){return(end-start)/36e5}),(function(date){return date.getHours()})),hours=hour.range,day=newInterval((function(date){date.setHours(0,0,0,0)}),(function(date,step){date.setDate(date.getDate()+step)}),(function(start,end){return(end-start-6e4*(end.getTimezoneOffset()-start.getTimezoneOffset()))/864e5}),(function(date){return date.getDate()-1})),days=day.range;function weekday(i){return newInterval((function(date){date.setDate(date.getDate()-(date.getDay()+7-i)%7),date.setHours(0,0,0,0)}),(function(date,step){date.setDate(date.getDate()+7*step)}),(function(start,end){return(end-start-6e4*(end.getTimezoneOffset()-start.getTimezoneOffset()))/6048e5}))}var sunday=weekday(0),monday=weekday(1),tuesday=weekday(2),wednesday=weekday(3),thursday=weekday(4),friday=weekday(5),saturday=weekday(6),sundays=sunday.range,mondays=monday.range,tuesdays=tuesday.range,wednesdays=wednesday.range,thursdays=thursday.range,fridays=friday.range,saturdays=saturday.range,month=newInterval((function(date){date.setDate(1),date.setHours(0,0,0,0)}),(function(date,step){date.setMonth(date.getMonth()+step)}),(function(start,end){return end.getMonth()-start.getMonth()+12*(end.getFullYear()-start.getFullYear())}),(function(date){return date.getMonth()})),months=month.range,year=newInterval((function(date){date.setMonth(0,1),date.setHours(0,0,0,0)}),(function(date,step){date.setFullYear(date.getFullYear()+step)}),(function(start,end){return end.getFullYear()-start.getFullYear()}),(function(date){return date.getFullYear()}));year.every=function(k){return isFinite(k=Math.floor(k))&&k>0?newInterval((function(date){date.setFullYear(Math.floor(date.getFullYear()/k)*k),date.setMonth(0,1),date.setHours(0,0,0,0)}),(function(date,step){date.setFullYear(date.getFullYear()+step*k)})):null};var years=year.range,utcMinute=newInterval((function(date){date.setUTCSeconds(0,0)}),(function(date,step){date.setTime(+date+6e4*step)}),(function(start,end){return(end-start)/6e4}),(function(date){return date.getUTCMinutes()})),utcMinutes=utcMinute.range,utcHour=newInterval((function(date){date.setUTCMinutes(0,0,0)}),(function(date,step){date.setTime(+date+36e5*step)}),(function(start,end){return(end-start)/36e5}),(function(date){return date.getUTCHours()})),utcHours=utcHour.range,utcDay=newInterval((function(date){date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCDate(date.getUTCDate()+step)}),(function(start,end){return(end-start)/864e5}),(function(date){return date.getUTCDate()-1})),utcDays=utcDay.range;function utcWeekday(i){return newInterval((function(date){date.setUTCDate(date.getUTCDate()-(date.getUTCDay()+7-i)%7),date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCDate(date.getUTCDate()+7*step)}),(function(start,end){return(end-start)/6048e5}))}var utcSunday=utcWeekday(0),utcMonday=utcWeekday(1),utcTuesday=utcWeekday(2),utcWednesday=utcWeekday(3),utcThursday=utcWeekday(4),utcFriday=utcWeekday(5),utcSaturday=utcWeekday(6),utcSundays=utcSunday.range,utcMondays=utcMonday.range,utcTuesdays=utcTuesday.range,utcWednesdays=utcWednesday.range,utcThursdays=utcThursday.range,utcFridays=utcFriday.range,utcSaturdays=utcSaturday.range,utcMonth=newInterval((function(date){date.setUTCDate(1),date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCMonth(date.getUTCMonth()+step)}),(function(start,end){return end.getUTCMonth()-start.getUTCMonth()+12*(end.getUTCFullYear()-start.getUTCFullYear())}),(function(date){return date.getUTCMonth()})),utcMonths=utcMonth.range,utcYear=newInterval((function(date){date.setUTCMonth(0,1),date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCFullYear(date.getUTCFullYear()+step)}),(function(start,end){return end.getUTCFullYear()-start.getUTCFullYear()}),(function(date){return date.getUTCFullYear()}));utcYear.every=function(k){return isFinite(k=Math.floor(k))&&k>0?newInterval((function(date){date.setUTCFullYear(Math.floor(date.getUTCFullYear()/k)*k),date.setUTCMonth(0,1),date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCFullYear(date.getUTCFullYear()+step*k)})):null};var utcYears=utcYear.range;function localDate(d){if(0<=d.y&&d.y<100){var date=new Date(-1,d.m,d.d,d.H,d.M,d.S,d.L);return date.setFullYear(d.y),date}return new Date(d.y,d.m,d.d,d.H,d.M,d.S,d.L)}function utcDate(d){if(0<=d.y&&d.y<100){var date=new Date(Date.UTC(-1,d.m,d.d,d.H,d.M,d.S,d.L));return date.setUTCFullYear(d.y),date}return new Date(Date.UTC(d.y,d.m,d.d,d.H,d.M,d.S,d.L))}function newYear(y){return{y:y,m:0,d:1,H:0,M:0,S:0,L:0}}function formatLocale$1(locale){var locale_dateTime=locale.dateTime,locale_date=locale.date,locale_time=locale.time,locale_periods=locale.periods,locale_weekdays=locale.days,locale_shortWeekdays=locale.shortDays,locale_months=locale.months,locale_shortMonths=locale.shortMonths,periodRe=formatRe(locale_periods),periodLookup=formatLookup(locale_periods),weekdayRe=formatRe(locale_weekdays),weekdayLookup=formatLookup(locale_weekdays),shortWeekdayRe=formatRe(locale_shortWeekdays),shortWeekdayLookup=formatLookup(locale_shortWeekdays),monthRe=formatRe(locale_months),monthLookup=formatLookup(locale_months),shortMonthRe=formatRe(locale_shortMonths),shortMonthLookup=formatLookup(locale_shortMonths),formats={a:function formatShortWeekday(d){return locale_shortWeekdays[d.getDay()]},A:function formatWeekday(d){return locale_weekdays[d.getDay()]},b:function formatShortMonth(d){return locale_shortMonths[d.getMonth()]},B:function formatMonth(d){return locale_months[d.getMonth()]},c:null,d:formatDayOfMonth,e:formatDayOfMonth,H:formatHour24,I:formatHour12,j:formatDayOfYear,L:formatMilliseconds,m:formatMonthNumber,M:formatMinutes,p:function formatPeriod(d){return locale_periods[+(d.getHours()>=12)]},S:formatSeconds,U:formatWeekNumberSunday,w:formatWeekdayNumber,W:formatWeekNumberMonday,x:null,X:null,y:formatYear,Y:formatFullYear,Z:formatZone,"%":formatLiteralPercent},utcFormats={a:function formatUTCShortWeekday(d){return locale_shortWeekdays[d.getUTCDay()]},A:function formatUTCWeekday(d){return locale_weekdays[d.getUTCDay()]},b:function formatUTCShortMonth(d){return locale_shortMonths[d.getUTCMonth()]},B:function formatUTCMonth(d){return locale_months[d.getUTCMonth()]},c:null,d:formatUTCDayOfMonth,e:formatUTCDayOfMonth,H:formatUTCHour24,I:formatUTCHour12,j:formatUTCDayOfYear,L:formatUTCMilliseconds,m:formatUTCMonthNumber,M:formatUTCMinutes,p:function formatUTCPeriod(d){return locale_periods[+(d.getUTCHours()>=12)]},S:formatUTCSeconds,U:formatUTCWeekNumberSunday,w:formatUTCWeekdayNumber,W:formatUTCWeekNumberMonday,x:null,X:null,y:formatUTCYear,Y:formatUTCFullYear,Z:formatUTCZone,"%":formatLiteralPercent},parses={a:function parseShortWeekday(d,string,i){var n=shortWeekdayRe.exec(string.slice(i));return n?(d.w=shortWeekdayLookup[n[0].toLowerCase()],i+n[0].length):-1},A:function parseWeekday(d,string,i){var n=weekdayRe.exec(string.slice(i));return n?(d.w=weekdayLookup[n[0].toLowerCase()],i+n[0].length):-1},b:function parseShortMonth(d,string,i){var n=shortMonthRe.exec(string.slice(i));return n?(d.m=shortMonthLookup[n[0].toLowerCase()],i+n[0].length):-1},B:function parseMonth(d,string,i){var n=monthRe.exec(string.slice(i));return n?(d.m=monthLookup[n[0].toLowerCase()],i+n[0].length):-1},c:function parseLocaleDateTime(d,string,i){return parseSpecifier(d,locale_dateTime,string,i)},d:parseDayOfMonth,e:parseDayOfMonth,H:parseHour24,I:parseHour24,j:parseDayOfYear,L:parseMilliseconds,m:parseMonthNumber,M:parseMinutes,p:function parsePeriod(d,string,i){var n=periodRe.exec(string.slice(i));return n?(d.p=periodLookup[n[0].toLowerCase()],i+n[0].length):-1},S:parseSeconds,U:parseWeekNumberSunday,w:parseWeekdayNumber,W:parseWeekNumberMonday,x:function parseLocaleDate(d,string,i){return parseSpecifier(d,locale_date,string,i)},X:function parseLocaleTime(d,string,i){return parseSpecifier(d,locale_time,string,i)},y:parseYear,Y:parseFullYear,Z:parseZone,"%":parseLiteralPercent};function newFormat(specifier,formats){return function(date){var c,pad,format,string=[],i=-1,j=0,n=specifier.length;for(date instanceof Date||(date=new Date(+date));++i<n;)37===specifier.charCodeAt(i)&&(string.push(specifier.slice(j,i)),null!=(pad=pads[c=specifier.charAt(++i)])?c=specifier.charAt(++i):pad="e"===c?" ":"0",(format=formats[c])&&(c=format(date,pad)),string.push(c),j=i+1);return string.push(specifier.slice(j,i)),string.join("")}}function newParse(specifier,newDate){return function(string){var d=newYear(1900);if(parseSpecifier(d,specifier,string+="",0)!=string.length)return null;if("p"in d&&(d.H=d.H%12+12*d.p),"W"in d||"U"in d){"w"in d||(d.w="W"in d?1:0);var day$$1="Z"in d?utcDate(newYear(d.y)).getUTCDay():newDate(newYear(d.y)).getDay();d.m=0,d.d="W"in d?(d.w+6)%7+7*d.W-(day$$1+5)%7:d.w+7*d.U-(day$$1+6)%7}return"Z"in d?(d.H+=d.Z/100|0,d.M+=d.Z%100,utcDate(d)):newDate(d)}}function parseSpecifier(d,specifier,string,j){for(var c,parse,i=0,n=specifier.length,m=string.length;i<n;){if(j>=m)return-1;if(37===(c=specifier.charCodeAt(i++))){if(c=specifier.charAt(i++),!(parse=parses[c in pads?specifier.charAt(i++):c])||(j=parse(d,string,j))<0)return-1}else if(c!=string.charCodeAt(j++))return-1}return j}return formats.x=newFormat(locale_date,formats),formats.X=newFormat(locale_time,formats),formats.c=newFormat(locale_dateTime,formats),utcFormats.x=newFormat(locale_date,utcFormats),utcFormats.X=newFormat(locale_time,utcFormats),utcFormats.c=newFormat(locale_dateTime,utcFormats),{format:function(specifier){var f=newFormat(specifier+="",formats);return f.toString=function(){return specifier},f},parse:function(specifier){var p=newParse(specifier+="",localDate);return p.toString=function(){return specifier},p},utcFormat:function(specifier){var f=newFormat(specifier+="",utcFormats);return f.toString=function(){return specifier},f},utcParse:function(specifier){var p=newParse(specifier,utcDate);return p.toString=function(){return specifier},p}}}var locale$2,pads={"-":"",_:" ",0:"0"},numberRe=/^\s*\d+/,percentRe=/^%/,requoteRe=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;function pad(value,fill,width){var sign=value<0?"-":"",string=(sign?-value:value)+"",length=string.length;return sign+(length<width?new Array(width-length+1).join(fill)+string:string)}function requote(s){return s.replace(requoteRe,"\\$&")}function formatRe(names){return new RegExp("^(?:"+names.map(requote).join("|")+")","i")}function formatLookup(names){for(var map={},i=-1,n=names.length;++i<n;)map[names[i].toLowerCase()]=i;return map}function parseWeekdayNumber(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.w=+n[0],i+n[0].length):-1}function parseWeekNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.U=+n[0],i+n[0].length):-1}function parseWeekNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.W=+n[0],i+n[0].length):-1}function parseFullYear(d,string,i){var n=numberRe.exec(string.slice(i,i+4));return n?(d.y=+n[0],i+n[0].length):-1}function parseYear(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.y=+n[0]+(+n[0]>68?1900:2e3),i+n[0].length):-1}function parseZone(d,string,i){var n=/^(Z)|([+-]\d\d)(?:\:?(\d\d))?/.exec(string.slice(i,i+6));return n?(d.Z=n[1]?0:-(n[2]+(n[3]||"00")),i+n[0].length):-1}function parseMonthNumber(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.m=n[0]-1,i+n[0].length):-1}function parseDayOfMonth(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.d=+n[0],i+n[0].length):-1}function parseDayOfYear(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.m=0,d.d=+n[0],i+n[0].length):-1}function parseHour24(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.H=+n[0],i+n[0].length):-1}function parseMinutes(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.M=+n[0],i+n[0].length):-1}function parseSeconds(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.S=+n[0],i+n[0].length):-1}function parseMilliseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.L=+n[0],i+n[0].length):-1}function parseLiteralPercent(d,string,i){var n=percentRe.exec(string.slice(i,i+1));return n?i+n[0].length:-1}function formatDayOfMonth(d,p){return pad(d.getDate(),p,2)}function formatHour24(d,p){return pad(d.getHours(),p,2)}function formatHour12(d,p){return pad(d.getHours()%12||12,p,2)}function formatDayOfYear(d,p){return pad(1+day.count(year(d),d),p,3)}function formatMilliseconds(d,p){return pad(d.getMilliseconds(),p,3)}function formatMonthNumber(d,p){return pad(d.getMonth()+1,p,2)}function formatMinutes(d,p){return pad(d.getMinutes(),p,2)}function formatSeconds(d,p){return pad(d.getSeconds(),p,2)}function formatWeekNumberSunday(d,p){return pad(sunday.count(year(d),d),p,2)}function formatWeekdayNumber(d){return d.getDay()}function formatWeekNumberMonday(d,p){return pad(monday.count(year(d),d),p,2)}function formatYear(d,p){return pad(d.getFullYear()%100,p,2)}function formatFullYear(d,p){return pad(d.getFullYear()%1e4,p,4)}function formatZone(d){var z=d.getTimezoneOffset();return(z>0?"-":(z*=-1,"+"))+pad(z/60|0,"0",2)+pad(z%60,"0",2)}function formatUTCDayOfMonth(d,p){return pad(d.getUTCDate(),p,2)}function formatUTCHour24(d,p){return pad(d.getUTCHours(),p,2)}function formatUTCHour12(d,p){return pad(d.getUTCHours()%12||12,p,2)}function formatUTCDayOfYear(d,p){return pad(1+utcDay.count(utcYear(d),d),p,3)}function formatUTCMilliseconds(d,p){return pad(d.getUTCMilliseconds(),p,3)}function formatUTCMonthNumber(d,p){return pad(d.getUTCMonth()+1,p,2)}function formatUTCMinutes(d,p){return pad(d.getUTCMinutes(),p,2)}function formatUTCSeconds(d,p){return pad(d.getUTCSeconds(),p,2)}function formatUTCWeekNumberSunday(d,p){return pad(utcSunday.count(utcYear(d),d),p,2)}function formatUTCWeekdayNumber(d){return d.getUTCDay()}function formatUTCWeekNumberMonday(d,p){return pad(utcMonday.count(utcYear(d),d),p,2)}function formatUTCYear(d,p){return pad(d.getUTCFullYear()%100,p,2)}function formatUTCFullYear(d,p){return pad(d.getUTCFullYear()%1e4,p,4)}function formatUTCZone(){return"+0000"}function formatLiteralPercent(){return"%"}function defaultLocale$1(definition){return locale$2=formatLocale$1(definition),exports.timeFormat=locale$2.format,exports.timeParse=locale$2.parse,exports.utcFormat=locale$2.utcFormat,exports.utcParse=locale$2.utcParse,locale$2}defaultLocale$1({dateTime:"%x, %X",date:"%-m/%-d/%Y",time:"%-I:%M:%S %p",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});var formatIso=Date.prototype.toISOString?function formatIsoNative(date){return date.toISOString()}:exports.utcFormat("%Y-%m-%dT%H:%M:%S.%LZ");var parseIso=+new Date("2000-01-01T00:00:00.000Z")?function parseIsoNative(string){var date=new Date(string);return isNaN(date)?null:date}:exports.utcParse("%Y-%m-%dT%H:%M:%S.%LZ");function date$1(t){return new Date(t)}function number$2(t){return t instanceof Date?+t:+new Date(+t)}function calendar(year$$1,month$$1,week,day$$1,hour$$1,minute$$1,second$$1,millisecond$$1,format){var scale=continuous(deinterpolateLinear,reinterpolate),invert=scale.invert,domain=scale.domain,formatMillisecond=format(".%L"),formatSecond=format(":%S"),formatMinute=format("%I:%M"),formatHour=format("%I %p"),formatDay=format("%a %d"),formatWeek=format("%b %d"),formatMonth=format("%B"),formatYear=format("%Y"),tickIntervals=[[second$$1,1,1e3],[second$$1,5,5e3],[second$$1,15,15e3],[second$$1,30,3e4],[minute$$1,1,6e4],[minute$$1,5,3e5],[minute$$1,15,9e5],[minute$$1,30,18e5],[hour$$1,1,36e5],[hour$$1,3,108e5],[hour$$1,6,216e5],[hour$$1,12,432e5],[day$$1,1,864e5],[day$$1,2,1728e5],[week,1,6048e5],[month$$1,1,2592e6],[month$$1,3,7776e6],[year$$1,1,31536e6]];function tickFormat(date){return(second$$1(date)<date?formatMillisecond:minute$$1(date)<date?formatSecond:hour$$1(date)<date?formatMinute:day$$1(date)<date?formatHour:month$$1(date)<date?week(date)<date?formatDay:formatWeek:year$$1(date)<date?formatMonth:formatYear)(date)}function tickInterval(interval,start,stop,step){if(null==interval&&(interval=10),"number"==typeof interval){var target=Math.abs(stop-start)/interval,i=bisector((function(i){return i[2]})).right(tickIntervals,target);i===tickIntervals.length?(step=tickStep(start/31536e6,stop/31536e6,interval),interval=year$$1):i?(step=(i=tickIntervals[target/tickIntervals[i-1][2]<tickIntervals[i][2]/target?i-1:i])[1],interval=i[0]):(step=tickStep(start,stop,interval),interval=millisecond$$1)}return null==step?interval:interval.every(step)}return scale.invert=function(y){return new Date(invert(y))},scale.domain=function(_){return arguments.length?domain(map$3.call(_,number$2)):domain().map(date$1)},scale.ticks=function(interval,step){var t,d=domain(),t0=d[0],t1=d[d.length-1],r=t1<t0;return r&&(t=t0,t0=t1,t1=t),t=(t=tickInterval(interval,t0,t1,step))?t.range(t0,t1+1):[],r?t.reverse():t},scale.tickFormat=function(count,specifier){return null==specifier?tickFormat:format(specifier)},scale.nice=function(interval,step){var d=domain();return(interval=tickInterval(interval,d[0],d[d.length-1],step))?domain(nice(d,interval)):scale},scale.copy=function(){return copy(scale,calendar(year$$1,month$$1,week,day$$1,hour$$1,minute$$1,second$$1,millisecond$$1,format))},scale}var colors=function(s){return s.match(/.{6}/g).map((function(x){return"#"+x}))},category10=colors("1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"),category20b=colors("393b795254a36b6ecf9c9ede6379398ca252b5cf6bcedb9c8c6d31bd9e39e7ba52e7cb94843c39ad494ad6616be7969c7b4173a55194ce6dbdde9ed6"),category20c=colors("3182bd6baed69ecae1c6dbefe6550dfd8d3cfdae6bfdd0a231a35474c476a1d99bc7e9c0756bb19e9ac8bcbddcdadaeb636363969696bdbdbdd9d9d9"),category20=colors("1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5"),cubehelix$3=cubehelixLong(cubehelix(300,.5,0),cubehelix(-240,.5,1)),warm=cubehelixLong(cubehelix(-100,.75,.35),cubehelix(80,1.5,.8)),cool=cubehelixLong(cubehelix(260,.75,.35),cubehelix(80,1.5,.8)),rainbow=cubehelix();function ramp(range){var n=range.length;return function(t){return range[Math.max(0,Math.min(n-1,Math.floor(t*n)))]}}var viridis=ramp(colors("44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725")),magma=ramp(colors("00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf")),inferno=ramp(colors("00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4")),plasma=ramp(colors("0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"));var constant$10=function(x){return function constant(){return x}},abs$1=Math.abs,atan2$1=Math.atan2,cos$2=Math.cos,max$2=Math.max,min$1=Math.min,sin$2=Math.sin,sqrt$2=Math.sqrt,pi$4=Math.PI,halfPi$3=pi$4/2,tau$4=2*pi$4;function acos$1(x){return x>1?0:x<-1?pi$4:Math.acos(x)}function asin$1(x){return x>=1?halfPi$3:x<=-1?-halfPi$3:Math.asin(x)}function arcInnerRadius(d){return d.innerRadius}function arcOuterRadius(d){return d.outerRadius}function arcStartAngle(d){return d.startAngle}function arcEndAngle(d){return d.endAngle}function arcPadAngle(d){return d&&d.padAngle}function intersect(x0,y0,x1,y1,x2,y2,x3,y3){var x10=x1-x0,y10=y1-y0,x32=x3-x2,y32=y3-y2,t=(x32*(y0-y2)-y32*(x0-x2))/(y32*x10-x32*y10);return[x0+t*x10,y0+t*y10]}function cornerTangents(x0,y0,x1,y1,r1,rc,cw){var x01=x0-x1,y01=y0-y1,lo=(cw?rc:-rc)/sqrt$2(x01*x01+y01*y01),ox=lo*y01,oy=-lo*x01,x11=x0+ox,y11=y0+oy,x10=x1+ox,y10=y1+oy,x00=(x11+x10)/2,y00=(y11+y10)/2,dx=x10-x11,dy=y10-y11,d2=dx*dx+dy*dy,r=r1-rc,D=x11*y10-x10*y11,d=(dy<0?-1:1)*sqrt$2(max$2(0,r*r*d2-D*D)),cx0=(D*dy-dx*d)/d2,cy0=(-D*dx-dy*d)/d2,cx1=(D*dy+dx*d)/d2,cy1=(-D*dx+dy*d)/d2,dx0=cx0-x00,dy0=cy0-y00,dx1=cx1-x00,dy1=cy1-y00;return dx0*dx0+dy0*dy0>dx1*dx1+dy1*dy1&&(cx0=cx1,cy0=cy1),{cx:cx0,cy:cy0,x01:-ox,y01:-oy,x11:cx0*(r1/r-1),y11:cy0*(r1/r-1)}}function Linear(context){this._context=context}Linear.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(x,y){switch(x=+x,y=+y,this._point){case 0:this._point=1,this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;default:this._context.lineTo(x,y)}}};var curveLinear=function(context){return new Linear(context)};function x$3(p){return p[0]}function y$3(p){return p[1]}var line=function(){var x$$1=x$3,y$$1=y$3,defined=constant$10(!0),context=null,curve=curveLinear,output=null;function line(data){var i,d,buffer,n=data.length,defined0=!1;for(null==context&&(output=curve(buffer=path())),i=0;i<=n;++i)!(i<n&&defined(d=data[i],i,data))===defined0&&((defined0=!defined0)?output.lineStart():output.lineEnd()),defined0&&output.point(+x$$1(d,i,data),+y$$1(d,i,data));if(buffer)return output=null,buffer+""||null}return line.x=function(_){return arguments.length?(x$$1="function"==typeof _?_:constant$10(+_),line):x$$1},line.y=function(_){return arguments.length?(y$$1="function"==typeof _?_:constant$10(+_),line):y$$1},line.defined=function(_){return arguments.length?(defined="function"==typeof _?_:constant$10(!!_),line):defined},line.curve=function(_){return arguments.length?(curve=_,null!=context&&(output=curve(context)),line):curve},line.context=function(_){return arguments.length?(null==_?context=output=null:output=curve(context=_),line):context},line},area$2=function(){var x0=x$3,x1=null,y0=constant$10(0),y1=y$3,defined=constant$10(!0),context=null,curve=curveLinear,output=null;function area(data){var i,j,k,d,buffer,n=data.length,defined0=!1,x0z=new Array(n),y0z=new Array(n);for(null==context&&(output=curve(buffer=path())),i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0)if(defined0=!defined0)j=i,output.areaStart(),output.lineStart();else{for(output.lineEnd(),output.lineStart(),k=i-1;k>=j;--k)output.point(x0z[k],y0z[k]);output.lineEnd(),output.areaEnd()}defined0&&(x0z[i]=+x0(d,i,data),y0z[i]=+y0(d,i,data),output.point(x1?+x1(d,i,data):x0z[i],y1?+y1(d,i,data):y0z[i]))}if(buffer)return output=null,buffer+""||null}function arealine(){return line().defined(defined).curve(curve).context(context)}return area.x=function(_){return arguments.length?(x0="function"==typeof _?_:constant$10(+_),x1=null,area):x0},area.x0=function(_){return arguments.length?(x0="function"==typeof _?_:constant$10(+_),area):x0},area.x1=function(_){return arguments.length?(x1=null==_?null:"function"==typeof _?_:constant$10(+_),area):x1},area.y=function(_){return arguments.length?(y0="function"==typeof _?_:constant$10(+_),y1=null,area):y0},area.y0=function(_){return arguments.length?(y0="function"==typeof _?_:constant$10(+_),area):y0},area.y1=function(_){return arguments.length?(y1=null==_?null:"function"==typeof _?_:constant$10(+_),area):y1},area.lineX0=area.lineY0=function(){return arealine().x(x0).y(y0)},area.lineY1=function(){return arealine().x(x0).y(y1)},area.lineX1=function(){return arealine().x(x1).y(y0)},area.defined=function(_){return arguments.length?(defined="function"==typeof _?_:constant$10(!!_),area):defined},area.curve=function(_){return arguments.length?(curve=_,null!=context&&(output=curve(context)),area):curve},area.context=function(_){return arguments.length?(null==_?context=output=null:output=curve(context=_),area):context},area},descending$1=function(a,b){return b<a?-1:b>a?1:b>=a?0:NaN},identity$7=function(d){return d},curveRadialLinear=curveRadial(curveLinear);function Radial(curve){this._curve=curve}function curveRadial(curve){function radial(context){return new Radial(curve(context))}return radial._curve=curve,radial}function radialLine(l){var c=l.curve;return l.angle=l.x,delete l.x,l.radius=l.y,delete l.y,l.curve=function(_){return arguments.length?c(curveRadial(_)):c()._curve},l}Radial.prototype={areaStart:function(){this._curve.areaStart()},areaEnd:function(){this._curve.areaEnd()},lineStart:function(){this._curve.lineStart()},lineEnd:function(){this._curve.lineEnd()},point:function(a,r){this._curve.point(r*Math.sin(a),r*-Math.cos(a))}};var circle$2={draw:function(context,size){var r=Math.sqrt(size/pi$4);context.moveTo(r,0),context.arc(0,0,r,0,tau$4)}},cross$2={draw:function(context,size){var r=Math.sqrt(size/5)/2;context.moveTo(-3*r,-r),context.lineTo(-r,-r),context.lineTo(-r,-3*r),context.lineTo(r,-3*r),context.lineTo(r,-r),context.lineTo(3*r,-r),context.lineTo(3*r,r),context.lineTo(r,r),context.lineTo(r,3*r),context.lineTo(-r,3*r),context.lineTo(-r,r),context.lineTo(-3*r,r),context.closePath()}},tan30=Math.sqrt(1/3),tan30_2=2*tan30,diamond={draw:function(context,size){var y=Math.sqrt(size/tan30_2),x=y*tan30;context.moveTo(0,-y),context.lineTo(x,0),context.lineTo(0,y),context.lineTo(-x,0),context.closePath()}},kr=Math.sin(pi$4/10)/Math.sin(7*pi$4/10),kx=Math.sin(tau$4/10)*kr,ky=-Math.cos(tau$4/10)*kr,star={draw:function(context,size){var r=Math.sqrt(.8908130915292852*size),x=kx*r,y=ky*r;context.moveTo(0,-r),context.lineTo(x,y);for(var i=1;i<5;++i){var a=tau$4*i/5,c=Math.cos(a),s=Math.sin(a);context.lineTo(s*r,-c*r),context.lineTo(c*x-s*y,s*x+c*y)}context.closePath()}},square={draw:function(context,size){var w=Math.sqrt(size),x=-w/2;context.rect(x,x,w,w)}},sqrt3=Math.sqrt(3),triangle={draw:function(context,size){var y=-Math.sqrt(size/(3*sqrt3));context.moveTo(0,2*y),context.lineTo(-sqrt3*y,-y),context.lineTo(sqrt3*y,-y),context.closePath()}},c=-.5,s=Math.sqrt(3)/2,k=1/Math.sqrt(12),a=3*(k/2+1),wye={draw:function(context,size){var r=Math.sqrt(size/a),x0=r/2,y0=r*k,x1=x0,y1=r*k+r,x2=-x1,y2=y1;context.moveTo(x0,y0),context.lineTo(x1,y1),context.lineTo(x2,y2),context.lineTo(c*x0-s*y0,s*x0+c*y0),context.lineTo(c*x1-s*y1,s*x1+c*y1),context.lineTo(c*x2-s*y2,s*x2+c*y2),context.lineTo(c*x0+s*y0,c*y0-s*x0),context.lineTo(c*x1+s*y1,c*y1-s*x1),context.lineTo(c*x2+s*y2,c*y2-s*x2),context.closePath()}},symbols=[circle$2,cross$2,diamond,square,star,triangle,wye],noop$2=function(){};function point$2(that,x,y){that._context.bezierCurveTo((2*that._x0+that._x1)/3,(2*that._y0+that._y1)/3,(that._x0+2*that._x1)/3,(that._y0+2*that._y1)/3,(that._x0+4*that._x1+x)/6,(that._y0+4*that._y1+y)/6)}function Basis(context){this._context=context}Basis.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN,this._point=0},lineEnd:function(){switch(this._point){case 3:point$2(this,this._x1,this._y1);case 2:this._context.lineTo(this._x1,this._y1)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(x,y){switch(x=+x,y=+y,this._point){case 0:this._point=1,this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3,this._context.lineTo((5*this._x0+this._x1)/6,(5*this._y0+this._y1)/6);default:point$2(this,x,y)}this._x0=this._x1,this._x1=x,this._y0=this._y1,this._y1=y}};function BasisClosed(context){this._context=context}BasisClosed.prototype={areaStart:noop$2,areaEnd:noop$2,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._y0=this._y1=this._y2=this._y3=this._y4=NaN,this._point=0},lineEnd:function(){switch(this._point){case 1:this._context.moveTo(this._x2,this._y2),this._context.closePath();break;case 2:this._context.moveTo((this._x2+2*this._x3)/3,(this._y2+2*this._y3)/3),this._context.lineTo((this._x3+2*this._x2)/3,(this._y3+2*this._y2)/3),this._context.closePath();break;case 3:this.point(this._x2,this._y2),this.point(this._x3,this._y3),this.point(this._x4,this._y4)}},point:function(x,y){switch(x=+x,y=+y,this._point){case 0:this._point=1,this._x2=x,this._y2=y;break;case 1:this._point=2,this._x3=x,this._y3=y;break;case 2:this._point=3,this._x4=x,this._y4=y,this._context.moveTo((this._x0+4*this._x1+x)/6,(this._y0+4*this._y1+y)/6);break;default:point$2(this,x,y)}this._x0=this._x1,this._x1=x,this._y0=this._y1,this._y1=y}};function BasisOpen(context){this._context=context}BasisOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN,this._point=0},lineEnd:function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(x,y){switch(x=+x,y=+y,this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;var x0=(this._x0+4*this._x1+x)/6,y0=(this._y0+4*this._y1+y)/6;this._line?this._context.lineTo(x0,y0):this._context.moveTo(x0,y0);break;case 3:this._point=4;default:point$2(this,x,y)}this._x0=this._x1,this._x1=x,this._y0=this._y1,this._y1=y}};function Bundle(context,beta){this._basis=new Basis(context),this._beta=beta}Bundle.prototype={lineStart:function(){this._x=[],this._y=[],this._basis.lineStart()},lineEnd:function(){var x=this._x,y=this._y,j=x.length-1;if(j>0)for(var t,x0=x[0],y0=y[0],dx=x[j]-x0,dy=y[j]-y0,i=-1;++i<=j;)t=i/j,this._basis.point(this._beta*x[i]+(1-this._beta)*(x0+t*dx),this._beta*y[i]+(1-this._beta)*(y0+t*dy));this._x=this._y=null,this._basis.lineEnd()},point:function(x,y){this._x.push(+x),this._y.push(+y)}};var bundle=function custom(beta){function bundle(context){return 1===beta?new Basis(context):new Bundle(context,beta)}return bundle.beta=function(beta){return custom(+beta)},bundle}(.85);function point$3(that,x,y){that._context.bezierCurveTo(that._x1+that._k*(that._x2-that._x0),that._y1+that._k*(that._y2-that._y0),that._x2+that._k*(that._x1-x),that._y2+that._k*(that._y1-y),that._x2,that._y2)}function Cardinal(context,tension){this._context=context,this._k=(1-tension)/6}Cardinal.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:point$3(this,this._x1,this._y1)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(x,y){switch(x=+x,y=+y,this._point){case 0:this._point=1,this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2,this._x1=x,this._y1=y;break;case 2:this._point=3;default:point$3(this,x,y)}this._x0=this._x1,this._x1=this._x2,this._x2=x,this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinal=function custom(tension){function cardinal(context){return new Cardinal(context,tension)}return cardinal.tension=function(tension){return custom(+tension)},cardinal}(0);function CardinalClosed(context,tension){this._context=context,this._k=(1-tension)/6}CardinalClosed.prototype={areaStart:noop$2,areaEnd:noop$2,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN,this._point=0},lineEnd:function(){switch(this._point){case 1:this._context.moveTo(this._x3,this._y3),this._context.closePath();break;case 2:this._context.lineTo(this._x3,this._y3),this._context.closePath();break;case 3:this.point(this._x3,this._y3),this.point(this._x4,this._y4),this.point(this._x5,this._y5)}},point:function(x,y){switch(x=+x,y=+y,this._point){case 0:this._point=1,this._x3=x,this._y3=y;break;case 1:this._point=2,this._context.moveTo(this._x4=x,this._y4=y);break;case 2:this._point=3,this._x5=x,this._y5=y;break;default:point$3(this,x,y)}this._x0=this._x1,this._x1=this._x2,this._x2=x,this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinalClosed=function custom(tension){function cardinal(context){return new CardinalClosed(context,tension)}return cardinal.tension=function(tension){return custom(+tension)},cardinal}(0);function CardinalOpen(context,tension){this._context=context,this._k=(1-tension)/6}CardinalOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._point=0},lineEnd:function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(x,y){switch(x=+x,y=+y,this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3,this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:point$3(this,x,y)}this._x0=this._x1,this._x1=this._x2,this._x2=x,this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinalOpen=function custom(tension){function cardinal(context){return new CardinalOpen(context,tension)}return cardinal.tension=function(tension){return custom(+tension)},cardinal}(0);function point$4(that,x,y){var x1=that._x1,y1=that._y1,x2=that._x2,y2=that._y2;if(that._l01_a>1e-12){var a=2*that._l01_2a+3*that._l01_a*that._l12_a+that._l12_2a,n=3*that._l01_a*(that._l01_a+that._l12_a);x1=(x1*a-that._x0*that._l12_2a+that._x2*that._l01_2a)/n,y1=(y1*a-that._y0*that._l12_2a+that._y2*that._l01_2a)/n}if(that._l23_a>1e-12){var b=2*that._l23_2a+3*that._l23_a*that._l12_a+that._l12_2a,m=3*that._l23_a*(that._l23_a+that._l12_a);x2=(x2*b+that._x1*that._l23_2a-x*that._l12_2a)/m,y2=(y2*b+that._y1*that._l23_2a-y*that._l12_2a)/m}that._context.bezierCurveTo(x1,y1,x2,y2,that._x2,that._y2)}function CatmullRom(context,alpha){this._context=context,this._alpha=alpha}CatmullRom.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:this.point(this._x2,this._y2)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(x,y){if(x=+x,y=+y,this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;default:point$4(this,x,y)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=x,this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRom=function custom(alpha){function catmullRom(context){return alpha?new CatmullRom(context,alpha):new Cardinal(context,0)}return catmullRom.alpha=function(alpha){return custom(+alpha)},catmullRom}(.5);function CatmullRomClosed(context,alpha){this._context=context,this._alpha=alpha}CatmullRomClosed.prototype={areaStart:noop$2,areaEnd:noop$2,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 1:this._context.moveTo(this._x3,this._y3),this._context.closePath();break;case 2:this._context.lineTo(this._x3,this._y3),this._context.closePath();break;case 3:this.point(this._x3,this._y3),this.point(this._x4,this._y4),this.point(this._x5,this._y5)}},point:function(x,y){if(x=+x,y=+y,this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1,this._x3=x,this._y3=y;break;case 1:this._point=2,this._context.moveTo(this._x4=x,this._y4=y);break;case 2:this._point=3,this._x5=x,this._y5=y;break;default:point$4(this,x,y)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=x,this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRomClosed=function custom(alpha){function catmullRom(context){return alpha?new CatmullRomClosed(context,alpha):new CardinalClosed(context,0)}return catmullRom.alpha=function(alpha){return custom(+alpha)},catmullRom}(.5);function CatmullRomOpen(context,alpha){this._context=context,this._alpha=alpha}CatmullRomOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(x,y){if(x=+x,y=+y,this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3,this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:point$4(this,x,y)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=x,this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRomOpen=function custom(alpha){function catmullRom(context){return alpha?new CatmullRomOpen(context,alpha):new CardinalOpen(context,0)}return catmullRom.alpha=function(alpha){return custom(+alpha)},catmullRom}(.5);function LinearClosed(context){this._context=context}LinearClosed.prototype={areaStart:noop$2,areaEnd:noop$2,lineStart:function(){this._point=0},lineEnd:function(){this._point&&this._context.closePath()},point:function(x,y){x=+x,y=+y,this._point?this._context.lineTo(x,y):(this._point=1,this._context.moveTo(x,y))}};function sign$1(x){return x<0?-1:1}function slope3(that,x2,y2){var h0=that._x1-that._x0,h1=x2-that._x1,s0=(that._y1-that._y0)/(h0||h1<0&&-0),s1=(y2-that._y1)/(h1||h0<0&&-0),p=(s0*h1+s1*h0)/(h0+h1);return(sign$1(s0)+sign$1(s1))*Math.min(Math.abs(s0),Math.abs(s1),.5*Math.abs(p))||0}function slope2(that,t){var h=that._x1-that._x0;return h?(3*(that._y1-that._y0)/h-t)/2:t}function point$5(that,t0,t1){var x0=that._x0,y0=that._y0,x1=that._x1,y1=that._y1,dx=(x1-x0)/3;that._context.bezierCurveTo(x0+dx,y0+dx*t0,x1-dx,y1-dx*t1,x1,y1)}function MonotoneX(context){this._context=context}function MonotoneY(context){this._context=new ReflectContext(context)}function ReflectContext(context){this._context=context}function Natural(context){this._context=context}function controlPoints(x){var i,m,n=x.length-1,a=new Array(n),b=new Array(n),r=new Array(n);for(a[0]=0,b[0]=2,r[0]=x[0]+2*x[1],i=1;i<n-1;++i)a[i]=1,b[i]=4,r[i]=4*x[i]+2*x[i+1];for(a[n-1]=2,b[n-1]=7,r[n-1]=8*x[n-1]+x[n],i=1;i<n;++i)m=a[i]/b[i-1],b[i]-=m,r[i]-=m*r[i-1];for(a[n-1]=r[n-1]/b[n-1],i=n-2;i>=0;--i)a[i]=(r[i]-a[i+1])/b[i];for(b[n-1]=(x[n]+a[n-1])/2,i=0;i<n-1;++i)b[i]=2*x[i+1]-a[i+1];return[a,b]}MonotoneX.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=this._t0=NaN,this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x1,this._y1);break;case 3:point$5(this,this._t0,slope2(this,this._t0))}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(x,y){var t1=NaN;if(y=+y,(x=+x)!==this._x1||y!==this._y1){switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3,point$5(this,slope2(this,t1=slope3(this,x,y)),t1);break;default:point$5(this,this._t0,t1=slope3(this,x,y))}this._x0=this._x1,this._x1=x,this._y0=this._y1,this._y1=y,this._t0=t1}}},(MonotoneY.prototype=Object.create(MonotoneX.prototype)).point=function(x,y){MonotoneX.prototype.point.call(this,y,x)},ReflectContext.prototype={moveTo:function(x,y){this._context.moveTo(y,x)},closePath:function(){this._context.closePath()},lineTo:function(x,y){this._context.lineTo(y,x)},bezierCurveTo:function(x1,y1,x2,y2,x,y){this._context.bezierCurveTo(y1,x1,y2,x2,y,x)}},Natural.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=[],this._y=[]},lineEnd:function(){var x=this._x,y=this._y,n=x.length;if(n)if(this._line?this._context.lineTo(x[0],y[0]):this._context.moveTo(x[0],y[0]),2===n)this._context.lineTo(x[1],y[1]);else for(var px=controlPoints(x),py=controlPoints(y),i0=0,i1=1;i1<n;++i0,++i1)this._context.bezierCurveTo(px[0][i0],py[0][i0],px[1][i0],py[1][i0],x[i1],y[i1]);(this._line||0!==this._line&&1===n)&&this._context.closePath(),this._line=1-this._line,this._x=this._y=null},point:function(x,y){this._x.push(+x),this._y.push(+y)}};function Step(context,t){this._context=context,this._t=t}Step.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=this._y=NaN,this._point=0},lineEnd:function(){0<this._t&&this._t<1&&2===this._point&&this._context.lineTo(this._x,this._y),(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line>=0&&(this._t=1-this._t,this._line=1-this._line)},point:function(x,y){switch(x=+x,y=+y,this._point){case 0:this._point=1,this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;default:if(this._t<=0)this._context.lineTo(this._x,y),this._context.lineTo(x,y);else{var x1=this._x*(1-this._t)+x*this._t;this._context.lineTo(x1,this._y),this._context.lineTo(x1,y)}}this._x=x,this._y=y}};var slice$5=Array.prototype.slice,none$1=function(series,order){if((n=series.length)>1)for(var s0,n,i=1,s1=series[order[0]],m=s1.length;i<n;++i){s0=s1,s1=series[order[i]];for(var j=0;j<m;++j)s1[j][1]+=s1[j][0]=isNaN(s0[j][1])?s0[j][0]:s0[j][1]}},none$2=function(series){for(var n=series.length,o=new Array(n);--n>=0;)o[n]=n;return o};function stackValue(d,key){return d[key]}var ascending$2=function(series){var sums=series.map(sum$2);return none$2(series).sort((function(a,b){return sums[a]-sums[b]}))};function sum$2(series){for(var v,s=0,i=-1,n=series.length;++i<n;)(v=+series[i][1])&&(s+=v);return s}var constant$11=function(x){return function(){return x}};function x$4(d){return d[0]}function y$4(d){return d[1]}function RedBlackTree(){this._=null}function RedBlackNode(node){node.U=node.C=node.L=node.R=node.P=node.N=null}function RedBlackRotateLeft(tree,node){var p=node,q=node.R,parent=p.U;parent?parent.L===p?parent.L=q:parent.R=q:tree._=q,q.U=parent,p.U=q,p.R=q.L,p.R&&(p.R.U=p),q.L=p}function RedBlackRotateRight(tree,node){var p=node,q=node.L,parent=p.U;parent?parent.L===p?parent.L=q:parent.R=q:tree._=q,q.U=parent,p.U=q,p.L=q.R,p.L&&(p.L.U=p),q.R=p}function RedBlackFirst(node){for(;node.L;)node=node.L;return node}function createEdge(left,right,v0,v1){var edge=[null,null],index=edges.push(edge)-1;return edge.left=left,edge.right=right,v0&&setEdgeEnd(edge,left,right,v0),v1&&setEdgeEnd(edge,right,left,v1),cells[left.index].halfedges.push(index),cells[right.index].halfedges.push(index),edge}function createBorderEdge(left,v0,v1){var edge=[v0,v1];return edge.left=left,edge}function setEdgeEnd(edge,left,right,vertex){edge[0]||edge[1]?edge.left===right?edge[1]=vertex:edge[0]=vertex:(edge[0]=vertex,edge.left=left,edge.right=right)}function clipEdge(edge,x0,y0,x1,y1){var r,a=edge[0],b=edge[1],ax=a[0],ay=a[1],t0=0,t1=1,dx=b[0]-ax,dy=b[1]-ay;if(r=x0-ax,dx||!(r>0)){if(r/=dx,dx<0){if(r<t0)return;r<t1&&(t1=r)}else if(dx>0){if(r>t1)return;r>t0&&(t0=r)}if(r=x1-ax,dx||!(r<0)){if(r/=dx,dx<0){if(r>t1)return;r>t0&&(t0=r)}else if(dx>0){if(r<t0)return;r<t1&&(t1=r)}if(r=y0-ay,dy||!(r>0)){if(r/=dy,dy<0){if(r<t0)return;r<t1&&(t1=r)}else if(dy>0){if(r>t1)return;r>t0&&(t0=r)}if(r=y1-ay,dy||!(r<0)){if(r/=dy,dy<0){if(r>t1)return;r>t0&&(t0=r)}else if(dy>0){if(r<t0)return;r<t1&&(t1=r)}return!(t0>0||t1<1)||(t0>0&&(edge[0]=[ax+t0*dx,ay+t0*dy]),t1<1&&(edge[1]=[ax+t1*dx,ay+t1*dy]),!0)}}}}}function connectEdge(edge,x0,y0,x1,y1){var v1=edge[1];if(v1)return!0;var fm,fb,v0=edge[0],left=edge.left,right=edge.right,lx=left[0],ly=left[1],rx=right[0],ry=right[1],fx=(lx+rx)/2,fy=(ly+ry)/2;if(ry===ly){if(fx<x0||fx>=x1)return;if(lx>rx){if(v0){if(v0[1]>=y1)return}else v0=[fx,y0];v1=[fx,y1]}else{if(v0){if(v0[1]<y0)return}else v0=[fx,y1];v1=[fx,y0]}}else if(fb=fy-(fm=(lx-rx)/(ry-ly))*fx,fm<-1||fm>1)if(lx>rx){if(v0){if(v0[1]>=y1)return}else v0=[(y0-fb)/fm,y0];v1=[(y1-fb)/fm,y1]}else{if(v0){if(v0[1]<y0)return}else v0=[(y1-fb)/fm,y1];v1=[(y0-fb)/fm,y0]}else if(ly<ry){if(v0){if(v0[0]>=x1)return}else v0=[x0,fm*x0+fb];v1=[x1,fm*x1+fb]}else{if(v0){if(v0[0]<x0)return}else v0=[x1,fm*x1+fb];v1=[x0,fm*x0+fb]}return edge[0]=v0,edge[1]=v1,!0}function cellHalfedgeAngle(cell,edge){var site=cell.site,va=edge.left,vb=edge.right;return site===vb&&(vb=va,va=site),vb?Math.atan2(vb[1]-va[1],vb[0]-va[0]):(site===va?(va=edge[1],vb=edge[0]):(va=edge[0],vb=edge[1]),Math.atan2(va[0]-vb[0],vb[1]-va[1]))}function cellHalfedgeStart(cell,edge){return edge[+(edge.left!==cell.site)]}function cellHalfedgeEnd(cell,edge){return edge[+(edge.left===cell.site)]}RedBlackTree.prototype={constructor:RedBlackTree,insert:function(after,node){var parent,grandpa,uncle;if(after){if(node.P=after,node.N=after.N,after.N&&(after.N.P=node),after.N=node,after.R){for(after=after.R;after.L;)after=after.L;after.L=node}else after.R=node;parent=after}else this._?(after=RedBlackFirst(this._),node.P=null,node.N=after,after.P=after.L=node,parent=after):(node.P=node.N=null,this._=node,parent=null);for(node.L=node.R=null,node.U=parent,node.C=!0,after=node;parent&&parent.C;)parent===(grandpa=parent.U).L?(uncle=grandpa.R)&&uncle.C?(parent.C=uncle.C=!1,grandpa.C=!0,after=grandpa):(after===parent.R&&(RedBlackRotateLeft(this,parent),parent=(after=parent).U),parent.C=!1,grandpa.C=!0,RedBlackRotateRight(this,grandpa)):(uncle=grandpa.L)&&uncle.C?(parent.C=uncle.C=!1,grandpa.C=!0,after=grandpa):(after===parent.L&&(RedBlackRotateRight(this,parent),parent=(after=parent).U),parent.C=!1,grandpa.C=!0,RedBlackRotateLeft(this,grandpa)),parent=after.U;this._.C=!1},remove:function(node){node.N&&(node.N.P=node.P),node.P&&(node.P.N=node.N),node.N=node.P=null;var sibling,next,red,parent=node.U,left=node.L,right=node.R;if(next=left?right?RedBlackFirst(right):left:right,parent?parent.L===node?parent.L=next:parent.R=next:this._=next,left&&right?(red=next.C,next.C=node.C,next.L=left,left.U=next,next!==right?(parent=next.U,next.U=node.U,node=next.R,parent.L=node,next.R=right,right.U=next):(next.U=parent,parent=next,node=next.R)):(red=node.C,node=next),node&&(node.U=parent),!red)if(node&&node.C)node.C=!1;else{do{if(node===this._)break;if(node===parent.L){if((sibling=parent.R).C&&(sibling.C=!1,parent.C=!0,RedBlackRotateLeft(this,parent),sibling=parent.R),sibling.L&&sibling.L.C||sibling.R&&sibling.R.C){sibling.R&&sibling.R.C||(sibling.L.C=!1,sibling.C=!0,RedBlackRotateRight(this,sibling),sibling=parent.R),sibling.C=parent.C,parent.C=sibling.R.C=!1,RedBlackRotateLeft(this,parent),node=this._;break}}else if((sibling=parent.L).C&&(sibling.C=!1,parent.C=!0,RedBlackRotateRight(this,parent),sibling=parent.L),sibling.L&&sibling.L.C||sibling.R&&sibling.R.C){sibling.L&&sibling.L.C||(sibling.R.C=!1,sibling.C=!0,RedBlackRotateLeft(this,sibling),sibling=parent.L),sibling.C=parent.C,parent.C=sibling.L.C=!1,RedBlackRotateRight(this,parent),node=this._;break}sibling.C=!0,node=parent,parent=parent.U}while(!node.C);node&&(node.C=!1)}}};var firstCircle,circlePool=[];function Circle(){RedBlackNode(this),this.x=this.y=this.arc=this.site=this.cy=null}function attachCircle(arc){var lArc=arc.P,rArc=arc.N;if(lArc&&rArc){var lSite=lArc.site,cSite=arc.site,rSite=rArc.site;if(lSite!==rSite){var bx=cSite[0],by=cSite[1],ax=lSite[0]-bx,ay=lSite[1]-by,cx=rSite[0]-bx,cy=rSite[1]-by,d=2*(ax*cy-ay*cx);if(!(d>=-epsilon2$2)){var ha=ax*ax+ay*ay,hc=cx*cx+cy*cy,x=(cy*ha-ay*hc)/d,y=(ax*hc-cx*ha)/d,circle=circlePool.pop()||new Circle;circle.arc=arc,circle.site=cSite,circle.x=x+bx,circle.y=(circle.cy=y+by)+Math.sqrt(x*x+y*y),arc.circle=circle;for(var before=null,node=circles._;node;)if(circle.y<node.y||circle.y===node.y&&circle.x<=node.x){if(!node.L){before=node.P;break}node=node.L}else{if(!node.R){before=node;break}node=node.R}circles.insert(before,circle),before||(firstCircle=circle)}}}}function detachCircle(arc){var circle=arc.circle;circle&&(circle.P||(firstCircle=circle.N),circles.remove(circle),circlePool.push(circle),RedBlackNode(circle),arc.circle=null)}var beachPool=[];function Beach(){RedBlackNode(this),this.edge=this.site=this.circle=null}function createBeach(site){var beach=beachPool.pop()||new Beach;return beach.site=site,beach}function detachBeach(beach){detachCircle(beach),beaches.remove(beach),beachPool.push(beach),RedBlackNode(beach)}function removeBeach(beach){var circle=beach.circle,x=circle.x,y=circle.cy,vertex=[x,y],previous=beach.P,next=beach.N,disappearing=[beach];detachBeach(beach);for(var lArc=previous;lArc.circle&&Math.abs(x-lArc.circle.x)<epsilon$4&&Math.abs(y-lArc.circle.cy)<epsilon$4;)previous=lArc.P,disappearing.unshift(lArc),detachBeach(lArc),lArc=previous;disappearing.unshift(lArc),detachCircle(lArc);for(var rArc=next;rArc.circle&&Math.abs(x-rArc.circle.x)<epsilon$4&&Math.abs(y-rArc.circle.cy)<epsilon$4;)next=rArc.N,disappearing.push(rArc),detachBeach(rArc),rArc=next;disappearing.push(rArc),detachCircle(rArc);var iArc,nArcs=disappearing.length;for(iArc=1;iArc<nArcs;++iArc)rArc=disappearing[iArc],lArc=disappearing[iArc-1],setEdgeEnd(rArc.edge,lArc.site,rArc.site,vertex);lArc=disappearing[0],(rArc=disappearing[nArcs-1]).edge=createEdge(lArc.site,rArc.site,null,vertex),attachCircle(lArc),attachCircle(rArc)}function addBeach(site){for(var lArc,rArc,dxl,dxr,x=site[0],directrix=site[1],node=beaches._;node;)if((dxl=leftBreakPoint(node,directrix)-x)>epsilon$4)node=node.L;else{if(!((dxr=x-rightBreakPoint(node,directrix))>epsilon$4)){dxl>-epsilon$4?(lArc=node.P,rArc=node):dxr>-epsilon$4?(lArc=node,rArc=node.N):lArc=rArc=node;break}if(!node.R){lArc=node;break}node=node.R}!function createCell(site){return cells[site.index]={site:site,halfedges:[]}}(site);var newArc=createBeach(site);if(beaches.insert(lArc,newArc),lArc||rArc){if(lArc===rArc)return detachCircle(lArc),rArc=createBeach(lArc.site),beaches.insert(newArc,rArc),newArc.edge=rArc.edge=createEdge(lArc.site,newArc.site),attachCircle(lArc),void attachCircle(rArc);if(rArc){detachCircle(lArc),detachCircle(rArc);var lSite=lArc.site,ax=lSite[0],ay=lSite[1],bx=site[0]-ax,by=site[1]-ay,rSite=rArc.site,cx=rSite[0]-ax,cy=rSite[1]-ay,d=2*(bx*cy-by*cx),hb=bx*bx+by*by,hc=cx*cx+cy*cy,vertex=[(cy*hb-by*hc)/d+ax,(bx*hc-cx*hb)/d+ay];setEdgeEnd(rArc.edge,lSite,rSite,vertex),newArc.edge=createEdge(lSite,site,null,vertex),rArc.edge=createEdge(site,rSite,null,vertex),attachCircle(lArc),attachCircle(rArc)}else newArc.edge=createEdge(lArc.site,newArc.site)}}function leftBreakPoint(arc,directrix){var site=arc.site,rfocx=site[0],rfocy=site[1],pby2=rfocy-directrix;if(!pby2)return rfocx;var lArc=arc.P;if(!lArc)return-1/0;var lfocx=(site=lArc.site)[0],lfocy=site[1],plby2=lfocy-directrix;if(!plby2)return lfocx;var hl=lfocx-rfocx,aby2=1/pby2-1/plby2,b=hl/plby2;return aby2?(-b+Math.sqrt(b*b-2*aby2*(hl*hl/(-2*plby2)-lfocy+plby2/2+rfocy-pby2/2)))/aby2+rfocx:(rfocx+lfocx)/2}function rightBreakPoint(arc,directrix){var rArc=arc.N;if(rArc)return leftBreakPoint(rArc,directrix);var site=arc.site;return site[1]===directrix?site[0]:1/0}var beaches,cells,circles,edges,epsilon$4=1e-6,epsilon2$2=1e-12;function triangleArea(a,b,c){return(a[0]-c[0])*(b[1]-a[1])-(a[0]-b[0])*(c[1]-a[1])}function lexicographic(a,b){return b[1]-a[1]||b[0]-a[0]}function Diagram(sites,extent){var x,y,circle,site=sites.sort(lexicographic).pop();for(edges=[],cells=new Array(sites.length),beaches=new RedBlackTree,circles=new RedBlackTree;;)if(circle=firstCircle,site&&(!circle||site[1]<circle.y||site[1]===circle.y&&site[0]<circle.x))site[0]===x&&site[1]===y||(addBeach(site),x=site[0],y=site[1]),site=sites.pop();else{if(!circle)break;removeBeach(circle.arc)}if(function sortCellHalfedges(){for(var cell,halfedges,j,m,i=0,n=cells.length;i<n;++i)if((cell=cells[i])&&(m=(halfedges=cell.halfedges).length)){var index=new Array(m),array=new Array(m);for(j=0;j<m;++j)index[j]=j,array[j]=cellHalfedgeAngle(cell,edges[halfedges[j]]);for(index.sort((function(i,j){return array[j]-array[i]})),j=0;j<m;++j)array[j]=halfedges[index[j]];for(j=0;j<m;++j)halfedges[j]=array[j]}}(),extent){var x0=+extent[0][0],y0=+extent[0][1],x1=+extent[1][0],y1=+extent[1][1];!function clipEdges(x0,y0,x1,y1){for(var edge,i=edges.length;i--;)connectEdge(edge=edges[i],x0,y0,x1,y1)&&clipEdge(edge,x0,y0,x1,y1)&&(Math.abs(edge[0][0]-edge[1][0])>epsilon$4||Math.abs(edge[0][1]-edge[1][1])>epsilon$4)||delete edges[i]}(x0,y0,x1,y1),function clipCells(x0,y0,x1,y1){var iCell,cell,site,iHalfedge,halfedges,nHalfedges,start,startX,startY,end,endX,endY,nCells=cells.length,cover=!0;for(iCell=0;iCell<nCells;++iCell)if(cell=cells[iCell]){for(site=cell.site,iHalfedge=(halfedges=cell.halfedges).length;iHalfedge--;)edges[halfedges[iHalfedge]]||halfedges.splice(iHalfedge,1);for(iHalfedge=0,nHalfedges=halfedges.length;iHalfedge<nHalfedges;)endX=(end=cellHalfedgeEnd(cell,edges[halfedges[iHalfedge]]))[0],endY=end[1],startX=(start=cellHalfedgeStart(cell,edges[halfedges[++iHalfedge%nHalfedges]]))[0],startY=start[1],(Math.abs(endX-startX)>epsilon$4||Math.abs(endY-startY)>epsilon$4)&&(halfedges.splice(iHalfedge,0,edges.push(createBorderEdge(site,end,Math.abs(endX-x0)<epsilon$4&&y1-endY>epsilon$4?[x0,Math.abs(startX-x0)<epsilon$4?startY:y1]:Math.abs(endY-y1)<epsilon$4&&x1-endX>epsilon$4?[Math.abs(startY-y1)<epsilon$4?startX:x1,y1]:Math.abs(endX-x1)<epsilon$4&&endY-y0>epsilon$4?[x1,Math.abs(startX-x1)<epsilon$4?startY:y0]:Math.abs(endY-y0)<epsilon$4&&endX-x0>epsilon$4?[Math.abs(startY-y0)<epsilon$4?startX:x0,y0]:null))-1),++nHalfedges);nHalfedges&&(cover=!1)}if(cover){var dx,dy,d2,dc=1/0;for(iCell=0,cover=null;iCell<nCells;++iCell)(cell=cells[iCell])&&(d2=(dx=(site=cell.site)[0]-x0)*dx+(dy=site[1]-y0)*dy)<dc&&(dc=d2,cover=cell);if(cover){var v00=[x0,y0],v01=[x0,y1],v11=[x1,y1],v10=[x1,y0];cover.halfedges.push(edges.push(createBorderEdge(site=cover.site,v00,v01))-1,edges.push(createBorderEdge(site,v01,v11))-1,edges.push(createBorderEdge(site,v11,v10))-1,edges.push(createBorderEdge(site,v10,v00))-1)}}for(iCell=0;iCell<nCells;++iCell)(cell=cells[iCell])&&(cell.halfedges.length||delete cells[iCell])}(x0,y0,x1,y1)}this.edges=edges,this.cells=cells,beaches=circles=edges=cells=null}Diagram.prototype={constructor:Diagram,polygons:function(){var edges=this.edges;return this.cells.map((function(cell){var polygon=cell.halfedges.map((function(i){return cellHalfedgeStart(cell,edges[i])}));return polygon.data=cell.site.data,polygon}))},triangles:function(){var triangles=[],edges=this.edges;return this.cells.forEach((function(cell,i){if(m=(halfedges=cell.halfedges).length)for(var halfedges,m,s0,site=cell.site,j=-1,e1=edges[halfedges[m-1]],s1=e1.left===site?e1.right:e1.left;++j<m;)s0=s1,s1=(e1=edges[halfedges[j]]).left===site?e1.right:e1.left,s0&&s1&&i<s0.index&&i<s1.index&&triangleArea(site,s0,s1)<0&&triangles.push([site.data,s0.data,s1.data])})),triangles},links:function(){return this.edges.filter((function(edge){return edge.right})).map((function(edge){return{source:edge.left.data,target:edge.right.data}}))},find:function(x,y,radius){for(var i0,cell,that=this,i1=that._found||0,n=that.cells.length;!(cell=that.cells[i1]);)if(++i1>=n)return null;var dx=x-cell.site[0],dy=y-cell.site[1],d2=dx*dx+dy*dy;do{cell=that.cells[i0=i1],i1=null,cell.halfedges.forEach((function(e){var edge=that.edges[e],v=edge.left;if(v!==cell.site&&v||(v=edge.right)){var vx=x-v[0],vy=y-v[1],v2=vx*vx+vy*vy;v2<d2&&(d2=v2,i1=v.index)}}))}while(null!==i1);return that._found=i0,null==radius||d2<=radius*radius?cell.site:null}};var constant$12=function(x){return function(){return x}};function ZoomEvent(target,type,transform){this.target=target,this.type=type,this.transform=transform}function Transform(k,x,y){this.k=k,this.x=x,this.y=y}Transform.prototype={constructor:Transform,scale:function(k){return 1===k?this:new Transform(this.k*k,this.x,this.y)},translate:function(x,y){return 0===x&0===y?this:new Transform(this.k,this.x+this.k*x,this.y+this.k*y)},apply:function(point){return[point[0]*this.k+this.x,point[1]*this.k+this.y]},applyX:function(x){return x*this.k+this.x},applyY:function(y){return y*this.k+this.y},invert:function(location){return[(location[0]-this.x)/this.k,(location[1]-this.y)/this.k]},invertX:function(x){return(x-this.x)/this.k},invertY:function(y){return(y-this.y)/this.k},rescaleX:function(x){return x.copy().domain(x.range().map(this.invertX,this).map(x.invert,x))},rescaleY:function(y){return y.copy().domain(y.range().map(this.invertY,this).map(y.invert,y))},toString:function(){return"translate("+this.x+","+this.y+") scale("+this.k+")"}};var identity$8=new Transform(1,0,0);function transform$1(node){return node.__zoom||identity$8}function nopropagation$2(){exports.event.stopImmediatePropagation()}transform$1.prototype=Transform.prototype;var noevent$2=function(){exports.event.preventDefault(),exports.event.stopImmediatePropagation()};function defaultFilter$2(){return!exports.event.button}function defaultExtent$1(){var w,h,e=this;return e instanceof SVGElement?(w=(e=e.ownerSVGElement||e).width.baseVal.value,h=e.height.baseVal.value):(w=e.clientWidth,h=e.clientHeight),[[0,0],[w,h]]}function defaultTransform(){return this.__zoom||identity$8}exports.version="4.7.4",exports.bisect=bisectRight,exports.bisectRight=bisectRight,exports.bisectLeft=bisectLeft,exports.ascending=ascending,exports.bisector=bisector,exports.cross=function(a,b,f){var ia,ib,ic,va,na=a.length,nb=b.length,c=new Array(na*nb);for(null==f&&(f=pair),ia=ic=0;ia<na;++ia)for(va=a[ia],ib=0;ib<nb;++ib,++ic)c[ic]=f(va,b[ib]);return c},exports.descending=function(a,b){return b<a?-1:b>a?1:b>=a?0:NaN},exports.deviation=deviation,exports.extent=extent,exports.histogram=function(){var value=identity,domain=extent,threshold=sturges;function histogram(data){var i,x,n=data.length,values=new Array(n);for(i=0;i<n;++i)values[i]=value(data[i],i,data);var xz=domain(values),x0=xz[0],x1=xz[1],tz=threshold(values,x0,x1);Array.isArray(tz)||(tz=ticks(x0,x1,tz));for(var m=tz.length;tz[0]<=x0;)tz.shift(),--m;for(;tz[m-1]>=x1;)tz.pop(),--m;var bin,bins=new Array(m+1);for(i=0;i<=m;++i)(bin=bins[i]=[]).x0=i>0?tz[i-1]:x0,bin.x1=i<m?tz[i]:x1;for(i=0;i<n;++i)x0<=(x=values[i])&&x<=x1&&bins[bisectRight(tz,x,0,m)].push(data[i]);return bins}return histogram.value=function(_){return arguments.length?(value="function"==typeof _?_:constant(_),histogram):value},histogram.domain=function(_){return arguments.length?(domain="function"==typeof _?_:constant([_[0],_[1]]),histogram):domain},histogram.thresholds=function(_){return arguments.length?(threshold="function"==typeof _?_:Array.isArray(_)?constant(slice.call(_)):constant(_),histogram):threshold},histogram},exports.thresholdFreedmanDiaconis=function(values,min,max){return values=map.call(values,number).sort(ascending),Math.ceil((max-min)/(2*(threshold(values,.75)-threshold(values,.25))*Math.pow(values.length,-1/3)))},exports.thresholdScott=function(values,min,max){return Math.ceil((max-min)/(3.5*deviation(values)*Math.pow(values.length,-1/3)))},exports.thresholdSturges=sturges,exports.max=function(array,f){var a,b,i=-1,n=array.length;if(null==f){for(;++i<n;)if(null!=(b=array[i])&&b>=b){a=b;break}for(;++i<n;)null!=(b=array[i])&&b>a&&(a=b)}else{for(;++i<n;)if(null!=(b=f(array[i],i,array))&&b>=b){a=b;break}for(;++i<n;)null!=(b=f(array[i],i,array))&&b>a&&(a=b)}return a},exports.mean=function(array,f){var a,s=0,n=array.length,i=-1,j=n;if(null==f)for(;++i<n;)isNaN(a=number(array[i]))?--j:s+=a;else for(;++i<n;)isNaN(a=number(f(array[i],i,array)))?--j:s+=a;if(j)return s/j},exports.median=function(array,f){var a,numbers=[],n=array.length,i=-1;if(null==f)for(;++i<n;)isNaN(a=number(array[i]))||numbers.push(a);else for(;++i<n;)isNaN(a=number(f(array[i],i,array)))||numbers.push(a);return threshold(numbers.sort(ascending),.5)},exports.merge=merge,exports.min=min,exports.pairs=function(array,f){null==f&&(f=pair);for(var i=0,n=array.length-1,p=array[0],pairs=new Array(n<0?0:n);i<n;)pairs[i]=f(p,p=array[++i]);return pairs},exports.permute=function(array,indexes){for(var i=indexes.length,permutes=new Array(i);i--;)permutes[i]=array[indexes[i]];return permutes},exports.quantile=threshold,exports.range=sequence,exports.scan=function(array,compare){if(n=array.length){var n,xi,i=0,j=0,xj=array[j];for(compare||(compare=ascending);++i<n;)(compare(xi=array[i],xj)<0||0!==compare(xj,xj))&&(xj=xi,j=i);return 0===compare(xj,xj)?j:void 0}},exports.shuffle=function(array,i0,i1){for(var t,i,m=(null==i1?array.length:i1)-(i0=null==i0?0:+i0);m;)i=Math.random()*m--|0,t=array[m+i0],array[m+i0]=array[i+i0],array[i+i0]=t;return array},exports.sum=function(array,f){var a,s=0,n=array.length,i=-1;if(null==f)for(;++i<n;)(a=+array[i])&&(s+=a);else for(;++i<n;)(a=+f(array[i],i,array))&&(s+=a);return s},exports.ticks=ticks,exports.tickStep=tickStep,exports.transpose=transpose,exports.variance=variance,exports.zip=function(){return transpose(arguments)},exports.axisTop=function axisTop(scale){return axis(1,scale)},exports.axisRight=function axisRight(scale){return axis(2,scale)},exports.axisBottom=function axisBottom(scale){return axis(3,scale)},exports.axisLeft=function axisLeft(scale){return axis(4,scale)},exports.brush=function(){return brush$1(XY)},exports.brushX=function brushX(){return brush$1(X)},exports.brushY=function brushY(){return brush$1(Y)},exports.brushSelection=function brushSelection(node){var state=node.__brush;return state?state.dim.output(state.selection):null},exports.chord=function(){var padAngle=0,sortGroups=null,sortSubgroups=null,sortChords=null;function chord(matrix){var k,x,x0,dx,i,j,n=matrix.length,groupSums=[],groupIndex=sequence(n),subgroupIndex=[],chords=[],groups=chords.groups=new Array(n),subgroups=new Array(n*n);for(k=0,i=-1;++i<n;){for(x=0,j=-1;++j<n;)x+=matrix[i][j];groupSums.push(x),subgroupIndex.push(sequence(n)),k+=x}for(sortGroups&&groupIndex.sort((function(a,b){return sortGroups(groupSums[a],groupSums[b])})),sortSubgroups&&subgroupIndex.forEach((function(d,i){d.sort((function(a,b){return sortSubgroups(matrix[i][a],matrix[i][b])}))})),dx=(k=max$1(0,tau$1-padAngle*n)/k)?padAngle:tau$1/n,x=0,i=-1;++i<n;){for(x0=x,j=-1;++j<n;){var di=groupIndex[i],dj=subgroupIndex[di][j],v=matrix[di][dj],a0=x,a1=x+=v*k;subgroups[dj*n+di]={index:di,subindex:dj,startAngle:a0,endAngle:a1,value:v}}groups[di]={index:di,startAngle:x0,endAngle:x,value:groupSums[di]},x+=dx}for(i=-1;++i<n;)for(j=i-1;++j<n;){var source=subgroups[j*n+i],target=subgroups[i*n+j];(source.value||target.value)&&chords.push(source.value<target.value?{source:target,target:source}:{source:source,target:target})}return sortChords?chords.sort(sortChords):chords}return chord.padAngle=function(_){return arguments.length?(padAngle=max$1(0,_),chord):padAngle},chord.sortGroups=function(_){return arguments.length?(sortGroups=_,chord):sortGroups},chord.sortSubgroups=function(_){return arguments.length?(sortSubgroups=_,chord):sortSubgroups},chord.sortChords=function(_){return arguments.length?(null==_?sortChords=null:(sortChords=compareValue(_))._=_,chord):sortChords&&sortChords._},chord},exports.ribbon=function(){var source=defaultSource,target=defaultTarget,radius=defaultRadius,startAngle=defaultStartAngle,endAngle=defaultEndAngle,context=null;function ribbon(){var buffer,argv=slice$2.call(arguments),s=source.apply(this,argv),t=target.apply(this,argv),sr=+radius.apply(this,(argv[0]=s,argv)),sa0=startAngle.apply(this,argv)-halfPi$1,sa1=endAngle.apply(this,argv)-halfPi$1,sx0=sr*cos(sa0),sy0=sr*sin(sa0),tr=+radius.apply(this,(argv[0]=t,argv)),ta0=startAngle.apply(this,argv)-halfPi$1,ta1=endAngle.apply(this,argv)-halfPi$1;if(context||(context=buffer=path()),context.moveTo(sx0,sy0),context.arc(0,0,sr,sa0,sa1),sa0===ta0&&sa1===ta1||(context.quadraticCurveTo(0,0,tr*cos(ta0),tr*sin(ta0)),context.arc(0,0,tr,ta0,ta1)),context.quadraticCurveTo(0,0,sx0,sy0),context.closePath(),buffer)return context=null,buffer+""||null}return ribbon.radius=function(_){return arguments.length?(radius="function"==typeof _?_:constant$5(+_),ribbon):radius},ribbon.startAngle=function(_){return arguments.length?(startAngle="function"==typeof _?_:constant$5(+_),ribbon):startAngle},ribbon.endAngle=function(_){return arguments.length?(endAngle="function"==typeof _?_:constant$5(+_),ribbon):endAngle},ribbon.source=function(_){return arguments.length?(source=_,ribbon):source},ribbon.target=function(_){return arguments.length?(target=_,ribbon):target},ribbon.context=function(_){return arguments.length?(context=null==_?null:_,ribbon):context},ribbon},exports.nest=function(){var sortValues,rollup,nest,keys=[],sortKeys=[];function apply(array,depth,createResult,setResult){if(depth>=keys.length)return null!=rollup?rollup(array):null!=sortValues?array.sort(sortValues):array;for(var keyValue,value,values,i=-1,n=array.length,key=keys[depth++],valuesByKey=map$1(),result=createResult();++i<n;)(values=valuesByKey.get(keyValue=key(value=array[i])+""))?values.push(value):valuesByKey.set(keyValue,[value]);return valuesByKey.each((function(values,key){setResult(result,key,apply(values,depth,createResult,setResult))})),result}return nest={object:function(array){return apply(array,0,createObject,setObject)},map:function(array){return apply(array,0,createMap,setMap)},entries:function(array){return function entries(map,depth){if(++depth>keys.length)return map;var array,sortKey=sortKeys[depth-1];return null!=rollup&&depth>=keys.length?array=map.entries():(array=[],map.each((function(v,k){array.push({key:k,values:entries(v,depth)})}))),null!=sortKey?array.sort((function(a,b){return sortKey(a.key,b.key)})):array}(apply(array,0,createMap,setMap),0)},key:function(d){return keys.push(d),nest},sortKeys:function(order){return sortKeys[keys.length-1]=order,nest},sortValues:function(order){return sortValues=order,nest},rollup:function(f){return rollup=f,nest}}},exports.set=set$2,exports.map=map$1,exports.keys=function(map){var keys=[];for(var key in map)keys.push(key);return keys},exports.values=function(map){var values=[];for(var key in map)values.push(map[key]);return values},exports.entries=function(map){var entries=[];for(var key in map)entries.push({key:key,value:map[key]});return entries},exports.color=color,exports.rgb=rgb,exports.hsl=hsl,exports.lab=lab,exports.hcl=hcl,exports.cubehelix=cubehelix,exports.dispatch=dispatch,exports.drag=function(){var mousemoving,touchending,filter=defaultFilter$1,container=defaultContainer,subject=defaultSubject,gestures={},listeners=dispatch("start","drag","end"),active=0;function drag(selection$$1){selection$$1.on("mousedown.drag",mousedowned).on("touchstart.drag",touchstarted).on("touchmove.drag",touchmoved).on("touchend.drag touchcancel.drag",touchended).style("-webkit-tap-highlight-color","rgba(0,0,0,0)")}function mousedowned(){if(!touchending&&filter.apply(this,arguments)){var gesture=beforestart("mouse",container.apply(this,arguments),mouse,this,arguments);gesture&&(select(exports.event.view).on("mousemove.drag",mousemoved,!0).on("mouseup.drag",mouseupped,!0),dragDisable(exports.event.view),nopropagation(),mousemoving=!1,gesture("start"))}}function mousemoved(){noevent(),mousemoving=!0,gestures.mouse("drag")}function mouseupped(){select(exports.event.view).on("mousemove.drag mouseup.drag",null),yesdrag(exports.event.view,mousemoving),noevent(),gestures.mouse("end")}function touchstarted(){if(filter.apply(this,arguments)){var i,gesture,touches$$1=exports.event.changedTouches,c=container.apply(this,arguments),n=touches$$1.length;for(i=0;i<n;++i)(gesture=beforestart(touches$$1[i].identifier,c,touch,this,arguments))&&(nopropagation(),gesture("start"))}}function touchmoved(){var i,gesture,touches$$1=exports.event.changedTouches,n=touches$$1.length;for(i=0;i<n;++i)(gesture=gestures[touches$$1[i].identifier])&&(noevent(),gesture("drag"))}function touchended(){var i,gesture,touches$$1=exports.event.changedTouches,n=touches$$1.length;for(touchending&&clearTimeout(touchending),touchending=setTimeout((function(){touchending=null}),500),i=0;i<n;++i)(gesture=gestures[touches$$1[i].identifier])&&(nopropagation(),gesture("end"))}function beforestart(id,container,point,that,args){var s,dx,dy,p=point(container,id),sublisteners=listeners.copy();if(customEvent(new DragEvent(drag,"beforestart",s,id,active,p[0],p[1],0,0,sublisteners),(function(){return null!=(exports.event.subject=s=subject.apply(that,args))&&(dx=s.x-p[0]||0,dy=s.y-p[1]||0,!0)})))return function gesture(type){var n,p0=p;switch(type){case"start":gestures[id]=gesture,n=active++;break;case"end":delete gestures[id],--active;case"drag":p=point(container,id),n=active}customEvent(new DragEvent(drag,type,s,id,n,p[0]+dx,p[1]+dy,p[0]-p0[0],p[1]-p0[1],sublisteners),sublisteners.apply,sublisteners,[type,that,args])}}return drag.filter=function(_){return arguments.length?(filter="function"==typeof _?_:constant$2(!!_),drag):filter},drag.container=function(_){return arguments.length?(container="function"==typeof _?_:constant$2(_),drag):container},drag.subject=function(_){return arguments.length?(subject="function"==typeof _?_:constant$2(_),drag):subject},drag.on=function(){var value=listeners.on.apply(listeners,arguments);return value===listeners?drag:value},drag},exports.dragDisable=dragDisable,exports.dragEnable=yesdrag,exports.dsvFormat=dsv,exports.csvParse=csvParse,exports.csvParseRows=csvParseRows,exports.csvFormat=csvFormat,exports.csvFormatRows=csvFormatRows,exports.tsvParse=tsvParse,exports.tsvParseRows=tsvParseRows,exports.tsvFormat=tsvFormat,exports.tsvFormatRows=tsvFormatRows,exports.easeLinear=function linear$1(t){return+t},exports.easeQuad=quadInOut,exports.easeQuadIn=function quadIn(t){return t*t},exports.easeQuadOut=function quadOut(t){return t*(2-t)},exports.easeQuadInOut=quadInOut,exports.easeCubic=cubicInOut,exports.easeCubicIn=function cubicIn(t){return t*t*t},exports.easeCubicOut=function cubicOut(t){return--t*t*t+1},exports.easeCubicInOut=cubicInOut,exports.easePoly=polyInOut,exports.easePolyIn=polyIn,exports.easePolyOut=polyOut,exports.easePolyInOut=polyInOut,exports.easeSin=sinInOut,exports.easeSinIn=function sinIn(t){return 1-Math.cos(t*halfPi)},exports.easeSinOut=function sinOut(t){return Math.sin(t*halfPi)},exports.easeSinInOut=sinInOut,exports.easeExp=expInOut,exports.easeExpIn=function expIn(t){return Math.pow(2,10*t-10)},exports.easeExpOut=function expOut(t){return 1-Math.pow(2,-10*t)},exports.easeExpInOut=expInOut,exports.easeCircle=circleInOut,exports.easeCircleIn=function circleIn(t){return 1-Math.sqrt(1-t*t)},exports.easeCircleOut=function circleOut(t){return Math.sqrt(1- --t*t)},exports.easeCircleInOut=circleInOut,exports.easeBounce=bounceOut,exports.easeBounceIn=function bounceIn(t){return 1-bounceOut(1-t)},exports.easeBounceOut=bounceOut,exports.easeBounceInOut=function bounceInOut(t){return((t*=2)<=1?1-bounceOut(1-t):bounceOut(t-1)+1)/2},exports.easeBack=backInOut,exports.easeBackIn=backIn,exports.easeBackOut=backOut,exports.easeBackInOut=backInOut,exports.easeElastic=elasticOut,exports.easeElasticIn=elasticIn,exports.easeElasticOut=elasticOut,exports.easeElasticInOut=elasticInOut,exports.forceCenter=function(x,y){var nodes;function force(){var i,node,n=nodes.length,sx=0,sy=0;for(i=0;i<n;++i)sx+=(node=nodes[i]).x,sy+=node.y;for(sx=sx/n-x,sy=sy/n-y,i=0;i<n;++i)(node=nodes[i]).x-=sx,node.y-=sy}return null==x&&(x=0),null==y&&(y=0),force.initialize=function(_){nodes=_},force.x=function(_){return arguments.length?(x=+_,force):x},force.y=function(_){return arguments.length?(y=+_,force):y},force},exports.forceCollide=function(radius){var nodes,radii,strength=1,iterations=1;function force(){for(var i,tree,node,xi,yi,ri,ri2,n=nodes.length,k=0;k<iterations;++k)for(tree=quadtree(nodes,x,y).visitAfter(prepare),i=0;i<n;++i)node=nodes[i],ri=radii[node.index],ri2=ri*ri,xi=node.x+node.vx,yi=node.y+node.vy,tree.visit(apply);function apply(quad,x0,y0,x1,y1){var data=quad.data,rj=quad.r,r=ri+rj;if(!data)return x0>xi+r||x1<xi-r||y0>yi+r||y1<yi-r;if(data.index>node.index){var x=xi-data.x-data.vx,y=yi-data.y-data.vy,l=x*x+y*y;l<r*r&&(0===x&&(l+=(x=jiggle())*x),0===y&&(l+=(y=jiggle())*y),l=(r-(l=Math.sqrt(l)))/l*strength,node.vx+=(x*=l)*(r=(rj*=rj)/(ri2+rj)),node.vy+=(y*=l)*r,data.vx-=x*(r=1-r),data.vy-=y*r)}}}function prepare(quad){if(quad.data)return quad.r=radii[quad.data.index];for(var i=quad.r=0;i<4;++i)quad[i]&&quad[i].r>quad.r&&(quad.r=quad[i].r)}function initialize(){if(nodes){var i,node,n=nodes.length;for(radii=new Array(n),i=0;i<n;++i)node=nodes[i],radii[node.index]=+radius(node,i,nodes)}}return"function"!=typeof radius&&(radius=constant$6(null==radius?1:+radius)),force.initialize=function(_){nodes=_,initialize()},force.iterations=function(_){return arguments.length?(iterations=+_,force):iterations},force.strength=function(_){return arguments.length?(strength=+_,force):strength},force.radius=function(_){return arguments.length?(radius="function"==typeof _?_:constant$6(+_),initialize(),force):radius},force},exports.forceLink=function(links){var strengths,distances,nodes,count,bias,id=index,strength=function defaultStrength(link){return 1/Math.min(count[link.source.index],count[link.target.index])},distance=constant$6(30),iterations=1;function force(alpha){for(var k=0,n=links.length;k<iterations;++k)for(var link,source,target,x,y,l,b,i=0;i<n;++i)source=(link=links[i]).source,x=(target=link.target).x+target.vx-source.x-source.vx||jiggle(),y=target.y+target.vy-source.y-source.vy||jiggle(),x*=l=((l=Math.sqrt(x*x+y*y))-distances[i])/l*alpha*strengths[i],y*=l,target.vx-=x*(b=bias[i]),target.vy-=y*b,source.vx+=x*(b=1-b),source.vy+=y*b}function initialize(){if(nodes){var i,link,n=nodes.length,m=links.length,nodeById=map$1(nodes,id);for(i=0,count=new Array(n);i<m;++i)(link=links[i]).index=i,"object"!=typeof link.source&&(link.source=find(nodeById,link.source)),"object"!=typeof link.target&&(link.target=find(nodeById,link.target)),count[link.source.index]=(count[link.source.index]||0)+1,count[link.target.index]=(count[link.target.index]||0)+1;for(i=0,bias=new Array(m);i<m;++i)link=links[i],bias[i]=count[link.source.index]/(count[link.source.index]+count[link.target.index]);strengths=new Array(m),initializeStrength(),distances=new Array(m),initializeDistance()}}function initializeStrength(){if(nodes)for(var i=0,n=links.length;i<n;++i)strengths[i]=+strength(links[i],i,links)}function initializeDistance(){if(nodes)for(var i=0,n=links.length;i<n;++i)distances[i]=+distance(links[i],i,links)}return null==links&&(links=[]),force.initialize=function(_){nodes=_,initialize()},force.links=function(_){return arguments.length?(links=_,initialize(),force):links},force.id=function(_){return arguments.length?(id=_,force):id},force.iterations=function(_){return arguments.length?(iterations=+_,force):iterations},force.strength=function(_){return arguments.length?(strength="function"==typeof _?_:constant$6(+_),initializeStrength(),force):strength},force.distance=function(_){return arguments.length?(distance="function"==typeof _?_:constant$6(+_),initializeDistance(),force):distance},force},exports.forceManyBody=function(){var nodes,node,alpha,strengths,strength=constant$6(-30),distanceMin2=1,distanceMax2=1/0,theta2=.81;function force(_){var i,n=nodes.length,tree=quadtree(nodes,x$1,y$1).visitAfter(accumulate);for(alpha=_,i=0;i<n;++i)node=nodes[i],tree.visit(apply)}function initialize(){if(nodes){var i,node,n=nodes.length;for(strengths=new Array(n),i=0;i<n;++i)node=nodes[i],strengths[node.index]=+strength(node,i,nodes)}}function accumulate(quad){var q,c,x$$1,y$$1,i,strength=0;if(quad.length){for(x$$1=y$$1=i=0;i<4;++i)(q=quad[i])&&(c=q.value)&&(strength+=c,x$$1+=c*q.x,y$$1+=c*q.y);quad.x=x$$1/strength,quad.y=y$$1/strength}else{(q=quad).x=q.data.x,q.y=q.data.y;do{strength+=strengths[q.data.index]}while(q=q.next)}quad.value=strength}function apply(quad,x1,_,x2){if(!quad.value)return!0;var x$$1=quad.x-node.x,y$$1=quad.y-node.y,w=x2-x1,l=x$$1*x$$1+y$$1*y$$1;if(w*w/theta2<l)return l<distanceMax2&&(0===x$$1&&(l+=(x$$1=jiggle())*x$$1),0===y$$1&&(l+=(y$$1=jiggle())*y$$1),l<distanceMin2&&(l=Math.sqrt(distanceMin2*l)),node.vx+=x$$1*quad.value*alpha/l,node.vy+=y$$1*quad.value*alpha/l),!0;if(!(quad.length||l>=distanceMax2)){(quad.data!==node||quad.next)&&(0===x$$1&&(l+=(x$$1=jiggle())*x$$1),0===y$$1&&(l+=(y$$1=jiggle())*y$$1),l<distanceMin2&&(l=Math.sqrt(distanceMin2*l)));do{quad.data!==node&&(w=strengths[quad.data.index]*alpha/l,node.vx+=x$$1*w,node.vy+=y$$1*w)}while(quad=quad.next)}}return force.initialize=function(_){nodes=_,initialize()},force.strength=function(_){return arguments.length?(strength="function"==typeof _?_:constant$6(+_),initialize(),force):strength},force.distanceMin=function(_){return arguments.length?(distanceMin2=_*_,force):Math.sqrt(distanceMin2)},force.distanceMax=function(_){return arguments.length?(distanceMax2=_*_,force):Math.sqrt(distanceMax2)},force.theta=function(_){return arguments.length?(theta2=_*_,force):Math.sqrt(theta2)},force},exports.forceSimulation=function(nodes){var simulation,alpha=1,alphaMin=.001,alphaDecay=1-Math.pow(alphaMin,1/300),alphaTarget=0,velocityDecay=.6,forces=map$1(),stepper=timer(step),event=dispatch("tick","end");function step(){tick(),event.call("tick",simulation),alpha<alphaMin&&(stepper.stop(),event.call("end",simulation))}function tick(){var i,node,n=nodes.length;for(alpha+=(alphaTarget-alpha)*alphaDecay,forces.each((function(force){force(alpha)})),i=0;i<n;++i)null==(node=nodes[i]).fx?node.x+=node.vx*=velocityDecay:(node.x=node.fx,node.vx=0),null==node.fy?node.y+=node.vy*=velocityDecay:(node.y=node.fy,node.vy=0)}function initializeNodes(){for(var node,i=0,n=nodes.length;i<n;++i){if((node=nodes[i]).index=i,isNaN(node.x)||isNaN(node.y)){var radius=10*Math.sqrt(i),angle=i*initialAngle;node.x=radius*Math.cos(angle),node.y=radius*Math.sin(angle)}(isNaN(node.vx)||isNaN(node.vy))&&(node.vx=node.vy=0)}}function initializeForce(force){return force.initialize&&force.initialize(nodes),force}return null==nodes&&(nodes=[]),initializeNodes(),simulation={tick:tick,restart:function(){return stepper.restart(step),simulation},stop:function(){return stepper.stop(),simulation},nodes:function(_){return arguments.length?(nodes=_,initializeNodes(),forces.each(initializeForce),simulation):nodes},alpha:function(_){return arguments.length?(alpha=+_,simulation):alpha},alphaMin:function(_){return arguments.length?(alphaMin=+_,simulation):alphaMin},alphaDecay:function(_){return arguments.length?(alphaDecay=+_,simulation):+alphaDecay},alphaTarget:function(_){return arguments.length?(alphaTarget=+_,simulation):alphaTarget},velocityDecay:function(_){return arguments.length?(velocityDecay=1-_,simulation):1-velocityDecay},force:function(name,_){return arguments.length>1?(null==_?forces.remove(name):forces.set(name,initializeForce(_)),simulation):forces.get(name)},find:function(x,y,radius){var dx,dy,d2,node,closest,i=0,n=nodes.length;for(null==radius?radius=1/0:radius*=radius,i=0;i<n;++i)(d2=(dx=x-(node=nodes[i]).x)*dx+(dy=y-node.y)*dy)<radius&&(closest=node,radius=d2);return closest},on:function(name,_){return arguments.length>1?(event.on(name,_),simulation):event.on(name)}}},exports.forceX=function(x){var nodes,strengths,xz,strength=constant$6(.1);function force(alpha){for(var node,i=0,n=nodes.length;i<n;++i)(node=nodes[i]).vx+=(xz[i]-node.x)*strengths[i]*alpha}function initialize(){if(nodes){var i,n=nodes.length;for(strengths=new Array(n),xz=new Array(n),i=0;i<n;++i)strengths[i]=isNaN(xz[i]=+x(nodes[i],i,nodes))?0:+strength(nodes[i],i,nodes)}}return"function"!=typeof x&&(x=constant$6(null==x?0:+x)),force.initialize=function(_){nodes=_,initialize()},force.strength=function(_){return arguments.length?(strength="function"==typeof _?_:constant$6(+_),initialize(),force):strength},force.x=function(_){return arguments.length?(x="function"==typeof _?_:constant$6(+_),initialize(),force):x},force},exports.forceY=function(y){var nodes,strengths,yz,strength=constant$6(.1);function force(alpha){for(var node,i=0,n=nodes.length;i<n;++i)(node=nodes[i]).vy+=(yz[i]-node.y)*strengths[i]*alpha}function initialize(){if(nodes){var i,n=nodes.length;for(strengths=new Array(n),yz=new Array(n),i=0;i<n;++i)strengths[i]=isNaN(yz[i]=+y(nodes[i],i,nodes))?0:+strength(nodes[i],i,nodes)}}return"function"!=typeof y&&(y=constant$6(null==y?0:+y)),force.initialize=function(_){nodes=_,initialize()},force.strength=function(_){return arguments.length?(strength="function"==typeof _?_:constant$6(+_),initialize(),force):strength},force.y=function(_){return arguments.length?(y="function"==typeof _?_:constant$6(+_),initialize(),force):y},force},exports.formatDefaultLocale=defaultLocale,exports.formatLocale=formatLocale,exports.formatSpecifier=formatSpecifier,exports.precisionFixed=precisionFixed,exports.precisionPrefix=precisionPrefix,exports.precisionRound=precisionRound,exports.geoArea=function(object){return areaSum.reset(),geoStream(object,areaStream),2*areaSum},exports.geoBounds=function(feature){var i,n,a,b,merged,deltaMax,delta;if(phi1=lambda1=-(lambda0$1=phi0=1/0),ranges=[],geoStream(feature,boundsStream),n=ranges.length){for(ranges.sort(rangeCompare),i=1,merged=[a=ranges[0]];i<n;++i)rangeContains(a,(b=ranges[i])[0])||rangeContains(a,b[1])?(angle(a[0],b[1])>angle(a[0],a[1])&&(a[1]=b[1]),angle(b[0],a[1])>angle(a[0],a[1])&&(a[0]=b[0])):merged.push(a=b);for(deltaMax=-1/0,i=0,a=merged[n=merged.length-1];i<=n;a=b,++i)b=merged[i],(delta=angle(a[1],b[0]))>deltaMax&&(deltaMax=delta,lambda0$1=b[0],lambda1=a[1])}return ranges=range=null,lambda0$1===1/0||phi0===1/0?[[NaN,NaN],[NaN,NaN]]:[[lambda0$1,phi0],[lambda1,phi1]]},exports.geoCentroid=function(object){W0=W1=X0=Y0=Z0=X1=Y1=Z1=X2=Y2=Z2=0,geoStream(object,centroidStream);var x=X2,y=Y2,z=Z2,m=x*x+y*y+z*z;return m<1e-12&&(x=X1,y=Y1,z=Z1,W1<1e-6&&(x=X0,y=Y0,z=Z0),(m=x*x+y*y+z*z)<1e-12)?[NaN,NaN]:[atan2(y,x)*degrees$1,asin(z/sqrt(m))*degrees$1]},exports.geoCircle=function(){var ring,rotate,center=constant$7([0,0]),radius=constant$7(90),precision=constant$7(6),stream={point:function point(x,y){ring.push(x=rotate(x,y)),x[0]*=degrees$1,x[1]*=degrees$1}};function circle(){var c=center.apply(this,arguments),r=radius.apply(this,arguments)*radians,p=precision.apply(this,arguments)*radians;return ring=[],rotate=rotateRadians(-c[0]*radians,-c[1]*radians,0).invert,circleStream(stream,r,p,1),c={type:"Polygon",coordinates:[ring]},ring=rotate=null,c}return circle.center=function(_){return arguments.length?(center="function"==typeof _?_:constant$7([+_[0],+_[1]]),circle):center},circle.radius=function(_){return arguments.length?(radius="function"==typeof _?_:constant$7(+_),circle):radius},circle.precision=function(_){return arguments.length?(precision="function"==typeof _?_:constant$7(+_),circle):precision},circle},exports.geoClipExtent=function(){var cache,cacheStream,clip,x0=0,y0=0,x1=960,y1=500;return clip={stream:function(stream){return cache&&cacheStream===stream?cache:cache=clipExtent(x0,y0,x1,y1)(cacheStream=stream)},extent:function(_){return arguments.length?(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1],cache=cacheStream=null,clip):[[x0,y0],[x1,y1]]}}},exports.geoContains=function(object,point){return(object&&containsObjectType.hasOwnProperty(object.type)?containsObjectType[object.type]:containsGeometry)(object,point)},exports.geoDistance=distance,exports.geoGraticule=graticule,exports.geoGraticule10=function graticule10(){return graticule()()},exports.geoInterpolate=function(a,b){var x0=a[0]*radians,y0=a[1]*radians,x1=b[0]*radians,y1=b[1]*radians,cy0=cos$1(y0),sy0=sin$1(y0),cy1=cos$1(y1),sy1=sin$1(y1),kx0=cy0*cos$1(x0),ky0=cy0*sin$1(x0),kx1=cy1*cos$1(x1),ky1=cy1*sin$1(x1),d=2*asin(sqrt(haversin(y1-y0)+cy0*cy1*haversin(x1-x0))),k=sin$1(d),interpolate=d?function(t){var B=sin$1(t*=d)/k,A=sin$1(d-t)/k,x=A*kx0+B*kx1,y=A*ky0+B*ky1,z=A*sy0+B*sy1;return[atan2(y,x)*degrees$1,atan2(z,sqrt(x*x+y*y))*degrees$1]}:function(){return[x0*degrees$1,y0*degrees$1]};return interpolate.distance=d,interpolate},exports.geoLength=length$1,exports.geoPath=function(projection,context){var projectionStream,contextStream,pointRadius=4.5;function path(object){return object&&("function"==typeof pointRadius&&contextStream.pointRadius(+pointRadius.apply(this,arguments)),geoStream(object,projectionStream(contextStream))),contextStream.result()}return path.area=function(object){return geoStream(object,projectionStream(areaStream$1)),areaStream$1.result()},path.measure=function(object){return geoStream(object,projectionStream(lengthStream$1)),lengthStream$1.result()},path.bounds=function(object){return geoStream(object,projectionStream(boundsStream$1)),boundsStream$1.result()},path.centroid=function(object){return geoStream(object,projectionStream(centroidStream$1)),centroidStream$1.result()},path.projection=function(_){return arguments.length?(projectionStream=null==_?(projection=null,identity$4):(projection=_).stream,path):projection},path.context=function(_){return arguments.length?(contextStream=null==_?(context=null,new PathString):new PathContext(context=_),"function"!=typeof pointRadius&&contextStream.pointRadius(pointRadius),path):context},path.pointRadius=function(_){return arguments.length?(pointRadius="function"==typeof _?_:(contextStream.pointRadius(+_),+_),path):pointRadius},path.projection(projection).context(context)},exports.geoAlbers=albers,exports.geoAlbersUsa=function(){var cache,cacheStream,lower48Point,alaskaPoint,hawaiiPoint,point,lower48=albers(),alaska=conicEqualArea().rotate([154,0]).center([-2,58.5]).parallels([55,65]),hawaii=conicEqualArea().rotate([157,0]).center([-3,19.9]).parallels([8,18]),pointStream={point:function(x,y){point=[x,y]}};function albersUsa(coordinates){var x=coordinates[0],y=coordinates[1];return point=null,lower48Point.point(x,y),point||(alaskaPoint.point(x,y),point)||(hawaiiPoint.point(x,y),point)}function reset(){return cache=cacheStream=null,albersUsa}return albersUsa.invert=function(coordinates){var k=lower48.scale(),t=lower48.translate(),x=(coordinates[0]-t[0])/k,y=(coordinates[1]-t[1])/k;return(y>=.12&&y<.234&&x>=-.425&&x<-.214?alaska:y>=.166&&y<.234&&x>=-.214&&x<-.115?hawaii:lower48).invert(coordinates)},albersUsa.stream=function(stream){return cache&&cacheStream===stream?cache:cache=function multiplex(streams){var n=streams.length;return{point:function(x,y){for(var i=-1;++i<n;)streams[i].point(x,y)},sphere:function(){for(var i=-1;++i<n;)streams[i].sphere()},lineStart:function(){for(var i=-1;++i<n;)streams[i].lineStart()},lineEnd:function(){for(var i=-1;++i<n;)streams[i].lineEnd()},polygonStart:function(){for(var i=-1;++i<n;)streams[i].polygonStart()},polygonEnd:function(){for(var i=-1;++i<n;)streams[i].polygonEnd()}}}([lower48.stream(cacheStream=stream),alaska.stream(stream),hawaii.stream(stream)])},albersUsa.precision=function(_){return arguments.length?(lower48.precision(_),alaska.precision(_),hawaii.precision(_),reset()):lower48.precision()},albersUsa.scale=function(_){return arguments.length?(lower48.scale(_),alaska.scale(.35*_),hawaii.scale(_),albersUsa.translate(lower48.translate())):lower48.scale()},albersUsa.translate=function(_){if(!arguments.length)return lower48.translate();var k=lower48.scale(),x=+_[0],y=+_[1];return lower48Point=lower48.translate(_).clipExtent([[x-.455*k,y-.238*k],[x+.455*k,y+.238*k]]).stream(pointStream),alaskaPoint=alaska.translate([x-.307*k,y+.201*k]).clipExtent([[x-.425*k+1e-6,y+.12*k+1e-6],[x-.214*k-1e-6,y+.234*k-1e-6]]).stream(pointStream),hawaiiPoint=hawaii.translate([x-.205*k,y+.212*k]).clipExtent([[x-.214*k+1e-6,y+.166*k+1e-6],[x-.115*k-1e-6,y+.234*k-1e-6]]).stream(pointStream),reset()},albersUsa.fitExtent=function(extent,object){return fitExtent(albersUsa,extent,object)},albersUsa.fitSize=function(size,object){return fitSize(albersUsa,size,object)},albersUsa.scale(1070)},exports.geoAzimuthalEqualArea=function(){return projection(azimuthalEqualAreaRaw).scale(124.75).clipAngle(179.999)},exports.geoAzimuthalEqualAreaRaw=azimuthalEqualAreaRaw,exports.geoAzimuthalEquidistant=function(){return projection(azimuthalEquidistantRaw).scale(79.4188).clipAngle(179.999)},exports.geoAzimuthalEquidistantRaw=azimuthalEquidistantRaw,exports.geoConicConformal=function(){return conicProjection(conicConformalRaw).scale(109.5).parallels([30,30])},exports.geoConicConformalRaw=conicConformalRaw,exports.geoConicEqualArea=conicEqualArea,exports.geoConicEqualAreaRaw=conicEqualAreaRaw,exports.geoConicEquidistant=function(){return conicProjection(conicEquidistantRaw).scale(131.154).center([0,13.9389])},exports.geoConicEquidistantRaw=conicEquidistantRaw,exports.geoEquirectangular=function(){return projection(equirectangularRaw).scale(152.63)},exports.geoEquirectangularRaw=equirectangularRaw,exports.geoGnomonic=function(){return projection(gnomonicRaw).scale(144.049).clipAngle(60)},exports.geoGnomonicRaw=gnomonicRaw,exports.geoIdentity=function(){var y0,x1,y1,cache,cacheStream,projection,k=1,tx=0,ty=0,sx=1,sy=1,transform=identity$4,x0=null,clip=identity$4;function reset(){return cache=cacheStream=null,projection}return projection={stream:function(stream){return cache&&cacheStream===stream?cache:cache=transform(clip(cacheStream=stream))},clipExtent:function(_){return arguments.length?(clip=null==_?(x0=y0=x1=y1=null,identity$4):clipExtent(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]),reset()):null==x0?null:[[x0,y0],[x1,y1]]},scale:function(_){return arguments.length?(transform=scaleTranslate((k=+_)*sx,k*sy,tx,ty),reset()):k},translate:function(_){return arguments.length?(transform=scaleTranslate(k*sx,k*sy,tx=+_[0],ty=+_[1]),reset()):[tx,ty]},reflectX:function(_){return arguments.length?(transform=scaleTranslate(k*(sx=_?-1:1),k*sy,tx,ty),reset()):sx<0},reflectY:function(_){return arguments.length?(transform=scaleTranslate(k*sx,k*(sy=_?-1:1),tx,ty),reset()):sy<0},fitExtent:function(extent,object){return fitExtent(projection,extent,object)},fitSize:function(size,object){return fitSize(projection,size,object)}}},exports.geoProjection=projection,exports.geoProjectionMutator=projectionMutator,exports.geoMercator=function(){return mercatorProjection(mercatorRaw).scale(961/tau$3)},exports.geoMercatorRaw=mercatorRaw,exports.geoOrthographic=function(){return projection(orthographicRaw).scale(249.5).clipAngle(90.000001)},exports.geoOrthographicRaw=orthographicRaw,exports.geoStereographic=function(){return projection(stereographicRaw).scale(250).clipAngle(142)},exports.geoStereographicRaw=stereographicRaw,exports.geoTransverseMercator=function(){var m=mercatorProjection(transverseMercatorRaw),center=m.center,rotate=m.rotate;return m.center=function(_){return arguments.length?center([-_[1],_[0]]):[(_=center())[1],-_[0]]},m.rotate=function(_){return arguments.length?rotate([_[0],_[1],_.length>2?_[2]+90:90]):[(_=rotate())[0],_[1],_[2]-90]},rotate([0,0,90]).scale(159.155)},exports.geoTransverseMercatorRaw=transverseMercatorRaw,exports.geoRotation=rotation,exports.geoStream=geoStream,exports.geoTransform=function(methods){return{stream:transformer(methods)}},exports.cluster=function(){var separation=defaultSeparation,dx=1,dy=1,nodeSize=!1;function cluster(root){var previousNode,x=0;root.eachAfter((function(node){var children=node.children;children?(node.x=function meanX(children){return children.reduce(meanXReduce,0)/children.length}(children),node.y=function maxY(children){return 1+children.reduce(maxYReduce,0)}(children)):(node.x=previousNode?x+=separation(node,previousNode):0,node.y=0,previousNode=node)}));var left=function leafLeft(node){for(var children;children=node.children;)node=children[0];return node}(root),right=function leafRight(node){for(var children;children=node.children;)node=children[children.length-1];return node}(root),x0=left.x-separation(left,right)/2,x1=right.x+separation(right,left)/2;return root.eachAfter(nodeSize?function(node){node.x=(node.x-root.x)*dx,node.y=(root.y-node.y)*dy}:function(node){node.x=(node.x-x0)/(x1-x0)*dx,node.y=(1-(root.y?node.y/root.y:1))*dy})}return cluster.separation=function(x){return arguments.length?(separation=x,cluster):separation},cluster.size=function(x){return arguments.length?(nodeSize=!1,dx=+x[0],dy=+x[1],cluster):nodeSize?null:[dx,dy]},cluster.nodeSize=function(x){return arguments.length?(nodeSize=!0,dx=+x[0],dy=+x[1],cluster):nodeSize?[dx,dy]:null},cluster},exports.hierarchy=hierarchy,exports.pack=function(){var radius=null,dx=1,dy=1,padding=constantZero;function pack(root){return root.x=dx/2,root.y=dy/2,radius?root.eachBefore(radiusLeaf(radius)).eachAfter(packChildren(padding,.5)).eachBefore(translateChild(1)):root.eachBefore(radiusLeaf(defaultRadius$1)).eachAfter(packChildren(constantZero,1)).eachAfter(packChildren(padding,root.r/Math.min(dx,dy))).eachBefore(translateChild(Math.min(dx,dy)/(2*root.r))),root}return pack.radius=function(x){return arguments.length?(radius=optional(x),pack):radius},pack.size=function(x){return arguments.length?(dx=+x[0],dy=+x[1],pack):[dx,dy]},pack.padding=function(x){return arguments.length?(padding="function"==typeof x?x:constant$8(+x),pack):padding},pack},exports.packSiblings=function(circles){return packEnclose(circles),circles},exports.packEnclose=enclose,exports.partition=function(){var dx=1,dy=1,padding=0,round=!1;function partition(root){var n=root.height+1;return root.x0=root.y0=padding,root.x1=dx,root.y1=dy/n,root.eachBefore(function positionNode(dy,n){return function(node){node.children&&treemapDice(node,node.x0,dy*(node.depth+1)/n,node.x1,dy*(node.depth+2)/n);var x0=node.x0,y0=node.y0,x1=node.x1-padding,y1=node.y1-padding;x1<x0&&(x0=x1=(x0+x1)/2),y1<y0&&(y0=y1=(y0+y1)/2),node.x0=x0,node.y0=y0,node.x1=x1,node.y1=y1}}(dy,n)),round&&root.eachBefore(roundNode),root}return partition.round=function(x){return arguments.length?(round=!!x,partition):round},partition.size=function(x){return arguments.length?(dx=+x[0],dy=+x[1],partition):[dx,dy]},partition.padding=function(x){return arguments.length?(padding=+x,partition):padding},partition},exports.stratify=function(){var id=defaultId,parentId=defaultParentId;function stratify(data){var d,i,root,parent,node,nodeId,nodeKey,n=data.length,nodes=new Array(n),nodeByKey={};for(i=0;i<n;++i)d=data[i],node=nodes[i]=new Node(d),null!=(nodeId=id(d,i,data))&&(nodeId+="")&&(nodeByKey[nodeKey="$"+(node.id=nodeId)]=nodeKey in nodeByKey?ambiguous:node);for(i=0;i<n;++i)if(node=nodes[i],null!=(nodeId=parentId(data[i],i,data))&&(nodeId+="")){if(!(parent=nodeByKey["$"+nodeId]))throw new Error("missing: "+nodeId);if(parent===ambiguous)throw new Error("ambiguous: "+nodeId);parent.children?parent.children.push(node):parent.children=[node],node.parent=parent}else{if(root)throw new Error("multiple roots");root=node}if(!root)throw new Error("no root");if(root.parent=preroot,root.eachBefore((function(node){node.depth=node.parent.depth+1,--n})).eachBefore(computeHeight),root.parent=null,n>0)throw new Error("cycle");return root}return stratify.id=function(x){return arguments.length?(id=required(x),stratify):id},stratify.parentId=function(x){return arguments.length?(parentId=required(x),stratify):parentId},stratify},exports.tree=function(){var separation=defaultSeparation$1,dx=1,dy=1,nodeSize=null;function tree(root){var t=function treeRoot(root){for(var node,child,children,i,n,tree=new TreeNode(root,0),nodes=[tree];node=nodes.pop();)if(children=node._.children)for(node.children=new Array(n=children.length),i=n-1;i>=0;--i)nodes.push(child=node.children[i]=new TreeNode(children[i],i)),child.parent=node;return(tree.parent=new TreeNode(null,0)).children=[tree],tree}(root);if(t.eachAfter(firstWalk),t.parent.m=-t.z,t.eachBefore(secondWalk),nodeSize)root.eachBefore(sizeNode);else{var left=root,right=root,bottom=root;root.eachBefore((function(node){node.x<left.x&&(left=node),node.x>right.x&&(right=node),node.depth>bottom.depth&&(bottom=node)}));var s=left===right?1:separation(left,right)/2,tx=s-left.x,kx=dx/(right.x+s+tx),ky=dy/(bottom.depth||1);root.eachBefore((function(node){node.x=(node.x+tx)*kx,node.y=node.depth*ky}))}return root}function firstWalk(v){var children=v.children,siblings=v.parent.children,w=v.i?siblings[v.i-1]:null;if(children){!function executeShifts(v){for(var w,shift=0,change=0,children=v.children,i=children.length;--i>=0;)(w=children[i]).z+=shift,w.m+=shift,shift+=w.s+(change+=w.c)}(v);var midpoint=(children[0].z+children[children.length-1].z)/2;w?(v.z=w.z+separation(v._,w._),v.m=v.z-midpoint):v.z=midpoint}else w&&(v.z=w.z+separation(v._,w._));v.parent.A=function apportion(v,w,ancestor){if(w){for(var shift,vip=v,vop=v,vim=w,vom=vip.parent.children[0],sip=vip.m,sop=vop.m,sim=vim.m,som=vom.m;vim=nextRight(vim),vip=nextLeft(vip),vim&&vip;)vom=nextLeft(vom),(vop=nextRight(vop)).a=v,(shift=vim.z+sim-vip.z-sip+separation(vim._,vip._))>0&&(moveSubtree(nextAncestor(vim,v,ancestor),v,shift),sip+=shift,sop+=shift),sim+=vim.m,sip+=vip.m,som+=vom.m,sop+=vop.m;vim&&!nextRight(vop)&&(vop.t=vim,vop.m+=sim-sop),vip&&!nextLeft(vom)&&(vom.t=vip,vom.m+=sip-som,ancestor=v)}return ancestor}(v,w,v.parent.A||siblings[0])}function secondWalk(v){v._.x=v.z+v.parent.m,v.m+=v.parent.m}function sizeNode(node){node.x*=dx,node.y=node.depth*dy}return tree.separation=function(x){return arguments.length?(separation=x,tree):separation},tree.size=function(x){return arguments.length?(nodeSize=!1,dx=+x[0],dy=+x[1],tree):nodeSize?null:[dx,dy]},tree.nodeSize=function(x){return arguments.length?(nodeSize=!0,dx=+x[0],dy=+x[1],tree):nodeSize?[dx,dy]:null},tree},exports.treemap=function(){var tile=squarify,round=!1,dx=1,dy=1,paddingStack=[0],paddingInner=constantZero,paddingTop=constantZero,paddingRight=constantZero,paddingBottom=constantZero,paddingLeft=constantZero;function treemap(root){return root.x0=root.y0=0,root.x1=dx,root.y1=dy,root.eachBefore(positionNode),paddingStack=[0],round&&root.eachBefore(roundNode),root}function positionNode(node){var p=paddingStack[node.depth],x0=node.x0+p,y0=node.y0+p,x1=node.x1-p,y1=node.y1-p;x1<x0&&(x0=x1=(x0+x1)/2),y1<y0&&(y0=y1=(y0+y1)/2),node.x0=x0,node.y0=y0,node.x1=x1,node.y1=y1,node.children&&(p=paddingStack[node.depth+1]=paddingInner(node)/2,x0+=paddingLeft(node)-p,y0+=paddingTop(node)-p,(x1-=paddingRight(node)-p)<x0&&(x0=x1=(x0+x1)/2),(y1-=paddingBottom(node)-p)<y0&&(y0=y1=(y0+y1)/2),tile(node,x0,y0,x1,y1))}return treemap.round=function(x){return arguments.length?(round=!!x,treemap):round},treemap.size=function(x){return arguments.length?(dx=+x[0],dy=+x[1],treemap):[dx,dy]},treemap.tile=function(x){return arguments.length?(tile=required(x),treemap):tile},treemap.padding=function(x){return arguments.length?treemap.paddingInner(x).paddingOuter(x):treemap.paddingInner()},treemap.paddingInner=function(x){return arguments.length?(paddingInner="function"==typeof x?x:constant$8(+x),treemap):paddingInner},treemap.paddingOuter=function(x){return arguments.length?treemap.paddingTop(x).paddingRight(x).paddingBottom(x).paddingLeft(x):treemap.paddingTop()},treemap.paddingTop=function(x){return arguments.length?(paddingTop="function"==typeof x?x:constant$8(+x),treemap):paddingTop},treemap.paddingRight=function(x){return arguments.length?(paddingRight="function"==typeof x?x:constant$8(+x),treemap):paddingRight},treemap.paddingBottom=function(x){return arguments.length?(paddingBottom="function"==typeof x?x:constant$8(+x),treemap):paddingBottom},treemap.paddingLeft=function(x){return arguments.length?(paddingLeft="function"==typeof x?x:constant$8(+x),treemap):paddingLeft},treemap},exports.treemapBinary=function(parent,x0,y0,x1,y1){var i,sum,nodes=parent.children,n=nodes.length,sums=new Array(n+1);for(sums[0]=sum=i=0;i<n;++i)sums[i+1]=sum+=nodes[i].value;!function partition(i,j,value,x0,y0,x1,y1){if(i>=j-1){var node=nodes[i];return node.x0=x0,node.y0=y0,node.x1=x1,void(node.y1=y1)}var valueOffset=sums[i],valueTarget=value/2+valueOffset,k=i+1,hi=j-1;for(;k<hi;){var mid=k+hi>>>1;sums[mid]<valueTarget?k=mid+1:hi=mid}valueTarget-sums[k-1]<sums[k]-valueTarget&&i+1<k&&--k;var valueLeft=sums[k]-valueOffset,valueRight=value-valueLeft;if(x1-x0>y1-y0){var xk=(x0*valueRight+x1*valueLeft)/value;partition(i,k,valueLeft,x0,y0,xk,y1),partition(k,j,valueRight,xk,y0,x1,y1)}else{var yk=(y0*valueRight+y1*valueLeft)/value;partition(i,k,valueLeft,x0,y0,x1,yk),partition(k,j,valueRight,x0,yk,x1,y1)}}(0,n,parent.value,x0,y0,x1,y1)},exports.treemapDice=treemapDice,exports.treemapSlice=treemapSlice,exports.treemapSliceDice=function(parent,x0,y0,x1,y1){(1&parent.depth?treemapSlice:treemapDice)(parent,x0,y0,x1,y1)},exports.treemapSquarify=squarify,exports.treemapResquarify=resquarify,exports.interpolate=interpolateValue,exports.interpolateArray=array$1,exports.interpolateBasis=basis$1,exports.interpolateBasisClosed=basisClosed,exports.interpolateDate=date,exports.interpolateNumber=reinterpolate,exports.interpolateObject=object,exports.interpolateRound=interpolateRound,exports.interpolateString=interpolateString,exports.interpolateTransformCss=interpolateTransformCss,exports.interpolateTransformSvg=interpolateTransformSvg,exports.interpolateZoom=interpolateZoom,exports.interpolateRgb=interpolateRgb,exports.interpolateRgbBasis=rgbBasis,exports.interpolateRgbBasisClosed=rgbBasisClosed,exports.interpolateHsl=hsl$2,exports.interpolateHslLong=hslLong,exports.interpolateLab=function lab$1(start,end){var l=nogamma((start=lab(start)).l,(end=lab(end)).l),a=nogamma(start.a,end.a),b=nogamma(start.b,end.b),opacity=nogamma(start.opacity,end.opacity);return function(t){return start.l=l(t),start.a=a(t),start.b=b(t),start.opacity=opacity(t),start+""}},exports.interpolateHcl=hcl$2,exports.interpolateHclLong=hclLong,exports.interpolateCubehelix=cubehelix$2,exports.interpolateCubehelixLong=cubehelixLong,exports.quantize=function(interpolator,n){for(var samples=new Array(n),i=0;i<n;++i)samples[i]=interpolator(i/(n-1));return samples},exports.path=path,exports.polygonArea=function(polygon){for(var a,i=-1,n=polygon.length,b=polygon[n-1],area=0;++i<n;)a=b,b=polygon[i],area+=a[1]*b[0]-a[0]*b[1];return area/2},exports.polygonCentroid=function(polygon){for(var a,c,i=-1,n=polygon.length,x=0,y=0,b=polygon[n-1],k=0;++i<n;)a=b,b=polygon[i],k+=c=a[0]*b[1]-b[0]*a[1],x+=(a[0]+b[0])*c,y+=(a[1]+b[1])*c;return[x/(k*=3),y/k]},exports.polygonHull=function(points){if((n=points.length)<3)return null;var i,n,sortedPoints=new Array(n),flippedPoints=new Array(n);for(i=0;i<n;++i)sortedPoints[i]=[+points[i][0],+points[i][1],i];for(sortedPoints.sort(lexicographicOrder),i=0;i<n;++i)flippedPoints[i]=[sortedPoints[i][0],-sortedPoints[i][1]];var upperIndexes=computeUpperHullIndexes(sortedPoints),lowerIndexes=computeUpperHullIndexes(flippedPoints),skipLeft=lowerIndexes[0]===upperIndexes[0],skipRight=lowerIndexes[lowerIndexes.length-1]===upperIndexes[upperIndexes.length-1],hull=[];for(i=upperIndexes.length-1;i>=0;--i)hull.push(points[sortedPoints[upperIndexes[i]][2]]);for(i=+skipLeft;i<lowerIndexes.length-skipRight;++i)hull.push(points[sortedPoints[lowerIndexes[i]][2]]);return hull},exports.polygonContains=function(polygon,point){for(var x1,y1,n=polygon.length,p=polygon[n-1],x=point[0],y=point[1],x0=p[0],y0=p[1],inside=!1,i=0;i<n;++i)x1=(p=polygon[i])[0],(y1=p[1])>y!=y0>y&&x<(x0-x1)*(y-y1)/(y0-y1)+x1&&(inside=!inside),x0=x1,y0=y1;return inside},exports.polygonLength=function(polygon){for(var xa,ya,i=-1,n=polygon.length,b=polygon[n-1],xb=b[0],yb=b[1],perimeter=0;++i<n;)xa=xb,ya=yb,xa-=xb=(b=polygon[i])[0],ya-=yb=b[1],perimeter+=Math.sqrt(xa*xa+ya*ya);return perimeter},exports.quadtree=quadtree,exports.queue=queue,exports.randomUniform=function(min,max){return min=null==min?0:+min,max=null==max?1:+max,1===arguments.length?(max=min,min=0):max-=min,function(){return Math.random()*max+min}},exports.randomNormal=normal,exports.randomLogNormal=function(){var randomNormal=normal.apply(this,arguments);return function(){return Math.exp(randomNormal())}},exports.randomBates=function(n){var randomIrwinHall=irwinHall(n);return function(){return randomIrwinHall()/n}},exports.randomIrwinHall=irwinHall,exports.randomExponential=function(lambda){return function(){return-Math.log(1-Math.random())/lambda}},exports.request=request,exports.html=html,exports.json=json,exports.text=text,exports.xml=xml,exports.csv=csv$1,exports.tsv=tsv$1,exports.scaleBand=band,exports.scalePoint=function point$1(){return function pointish(scale){var copy=scale.copy;return scale.padding=scale.paddingOuter,delete scale.paddingInner,delete scale.paddingOuter,scale.copy=function(){return pointish(copy())},scale}(band().paddingInner(1))},exports.scaleIdentity=function identity$6(){var domain=[0,1];function scale(x){return+x}return scale.invert=scale,scale.domain=scale.range=function(_){return arguments.length?(domain=map$3.call(_,number$1),scale):domain.slice()},scale.copy=function(){return identity$6().domain(domain)},linearish(scale)},exports.scaleLinear=function linear$2(){var scale=continuous(deinterpolateLinear,reinterpolate);return scale.copy=function(){return copy(scale,linear$2())},linearish(scale)},exports.scaleLog=function log$1(){var scale=continuous(deinterpolate,reinterpolate$1).domain([1,10]),domain=scale.domain,base=10,logs=logp(10),pows=powp(10);function rescale(){return logs=logp(base),pows=powp(base),domain()[0]<0&&(logs=reflect(logs),pows=reflect(pows)),scale}return scale.base=function(_){return arguments.length?(base=+_,rescale()):base},scale.domain=function(_){return arguments.length?(domain(_),rescale()):domain()},scale.ticks=function(count){var r,d=domain(),u=d[0],v=d[d.length-1];(r=v<u)&&(i=u,u=v,v=i);var p,k,t,i=logs(u),j=logs(v),n=null==count?10:+count,z=[];if(!(base%1)&&j-i<n){if(i=Math.round(i)-1,j=Math.round(j)+1,u>0){for(;i<j;++i)for(k=1,p=pows(i);k<base;++k)if(!((t=p*k)<u)){if(t>v)break;z.push(t)}}else for(;i<j;++i)for(k=base-1,p=pows(i);k>=1;--k)if(!((t=p*k)<u)){if(t>v)break;z.push(t)}}else z=ticks(i,j,Math.min(j-i,n)).map(pows);return r?z.reverse():z},scale.tickFormat=function(count,specifier){if(null==specifier&&(specifier=10===base?".0e":","),"function"!=typeof specifier&&(specifier=exports.format(specifier)),count===1/0)return specifier;null==count&&(count=10);var k=Math.max(1,base*count/scale.ticks().length);return function(d){var i=d/pows(Math.round(logs(d)));return i*base<base-.5&&(i*=base),i<=k?specifier(d):""}},scale.nice=function(){return domain(nice(domain(),{floor:function(x){return pows(Math.floor(logs(x)))},ceil:function(x){return pows(Math.ceil(logs(x)))}}))},scale.copy=function(){return copy(scale,log$1().base(base))},scale},exports.scaleOrdinal=ordinal,exports.scaleImplicit=implicit,exports.scalePow=pow$1,exports.scaleSqrt=function sqrt$1(){return pow$1().exponent(.5)},exports.scaleQuantile=function quantile$$1(){var domain=[],range$$1=[],thresholds=[];function rescale(){var i=0,n=Math.max(1,range$$1.length);for(thresholds=new Array(n-1);++i<n;)thresholds[i-1]=threshold(domain,i/n);return scale}function scale(x){if(!isNaN(x=+x))return range$$1[bisectRight(thresholds,x)]}return scale.invertExtent=function(y){var i=range$$1.indexOf(y);return i<0?[NaN,NaN]:[i>0?thresholds[i-1]:domain[0],i<thresholds.length?thresholds[i]:domain[domain.length-1]]},scale.domain=function(_){if(!arguments.length)return domain.slice();domain=[];for(var d,i=0,n=_.length;i<n;++i)null==(d=_[i])||isNaN(d=+d)||domain.push(d);return domain.sort(ascending),rescale()},scale.range=function(_){return arguments.length?(range$$1=slice$4.call(_),rescale()):range$$1.slice()},scale.quantiles=function(){return thresholds.slice()},scale.copy=function(){return quantile$$1().domain(domain).range(range$$1)},scale},exports.scaleQuantize=function quantize$1(){var x0=0,x1=1,n=1,domain=[.5],range$$1=[0,1];function scale(x){if(x<=x)return range$$1[bisectRight(domain,x,0,n)]}function rescale(){var i=-1;for(domain=new Array(n);++i<n;)domain[i]=((i+1)*x1-(i-n)*x0)/(n+1);return scale}return scale.domain=function(_){return arguments.length?(x0=+_[0],x1=+_[1],rescale()):[x0,x1]},scale.range=function(_){return arguments.length?(n=(range$$1=slice$4.call(_)).length-1,rescale()):range$$1.slice()},scale.invertExtent=function(y){var i=range$$1.indexOf(y);return i<0?[NaN,NaN]:i<1?[x0,domain[0]]:i>=n?[domain[n-1],x1]:[domain[i-1],domain[i]]},scale.copy=function(){return quantize$1().domain([x0,x1]).range(range$$1)},linearish(scale)},exports.scaleThreshold=function threshold$1(){var domain=[.5],range$$1=[0,1],n=1;function scale(x){if(x<=x)return range$$1[bisectRight(domain,x,0,n)]}return scale.domain=function(_){return arguments.length?(domain=slice$4.call(_),n=Math.min(domain.length,range$$1.length-1),scale):domain.slice()},scale.range=function(_){return arguments.length?(range$$1=slice$4.call(_),n=Math.min(domain.length,range$$1.length-1),scale):range$$1.slice()},scale.invertExtent=function(y){var i=range$$1.indexOf(y);return[domain[i-1],domain[i]]},scale.copy=function(){return threshold$1().domain(domain).range(range$$1)},scale},exports.scaleTime=function(){return calendar(year,month,sunday,day,hour,minute,second,millisecond,exports.timeFormat).domain([new Date(2e3,0,1),new Date(2e3,0,2)])},exports.scaleUtc=function(){return calendar(utcYear,utcMonth,utcSunday,utcDay,utcHour,utcMinute,second,millisecond,exports.utcFormat).domain([Date.UTC(2e3,0,1),Date.UTC(2e3,0,2)])},exports.schemeCategory10=category10,exports.schemeCategory20b=category20b,exports.schemeCategory20c=category20c,exports.schemeCategory20=category20,exports.interpolateCubehelixDefault=cubehelix$3,exports.interpolateRainbow=function(t){(t<0||t>1)&&(t-=Math.floor(t));var ts=Math.abs(t-.5);return rainbow.h=360*t-100,rainbow.s=1.5-1.5*ts,rainbow.l=.8-.9*ts,rainbow+""},exports.interpolateWarm=warm,exports.interpolateCool=cool,exports.interpolateViridis=viridis,exports.interpolateMagma=magma,exports.interpolateInferno=inferno,exports.interpolatePlasma=plasma,exports.scaleSequential=function sequential(interpolator){var x0=0,x1=1,clamp=!1;function scale(x){var t=(x-x0)/(x1-x0);return interpolator(clamp?Math.max(0,Math.min(1,t)):t)}return scale.domain=function(_){return arguments.length?(x0=+_[0],x1=+_[1],scale):[x0,x1]},scale.clamp=function(_){return arguments.length?(clamp=!!_,scale):clamp},scale.interpolator=function(_){return arguments.length?(interpolator=_,scale):interpolator},scale.copy=function(){return sequential(interpolator).domain([x0,x1]).clamp(clamp)},linearish(scale)},exports.creator=creator,exports.local=local$1,exports.matcher=matcher$1,exports.mouse=mouse,exports.namespace=namespace,exports.namespaces=namespaces,exports.select=select,exports.selectAll=function(selector){return"string"==typeof selector?new Selection([document.querySelectorAll(selector)],[document.documentElement]):new Selection([null==selector?[]:selector],root)},exports.selection=selection,exports.selector=selector,exports.selectorAll=selectorAll,exports.touch=touch,exports.touches=function(node,touches){null==touches&&(touches=sourceEvent().touches);for(var i=0,n=touches?touches.length:0,points=new Array(n);i<n;++i)points[i]=point(node,touches[i]);return points},exports.window=window,exports.customEvent=customEvent,exports.arc=function(){var innerRadius=arcInnerRadius,outerRadius=arcOuterRadius,cornerRadius=constant$10(0),padRadius=null,startAngle=arcStartAngle,endAngle=arcEndAngle,padAngle=arcPadAngle,context=null;function arc(){var buffer,r,r0=+innerRadius.apply(this,arguments),r1=+outerRadius.apply(this,arguments),a0=startAngle.apply(this,arguments)-halfPi$3,a1=endAngle.apply(this,arguments)-halfPi$3,da=abs$1(a1-a0),cw=a1>a0;if(context||(context=buffer=path()),r1<r0&&(r=r1,r1=r0,r0=r),r1>1e-12)if(da>tau$4-1e-12)context.moveTo(r1*cos$2(a0),r1*sin$2(a0)),context.arc(0,0,r1,a0,a1,!cw),r0>1e-12&&(context.moveTo(r0*cos$2(a1),r0*sin$2(a1)),context.arc(0,0,r0,a1,a0,cw));else{var t0,t1,a01=a0,a11=a1,a00=a0,a10=a1,da0=da,da1=da,ap=padAngle.apply(this,arguments)/2,rp=ap>1e-12&&(padRadius?+padRadius.apply(this,arguments):sqrt$2(r0*r0+r1*r1)),rc=min$1(abs$1(r1-r0)/2,+cornerRadius.apply(this,arguments)),rc0=rc,rc1=rc;if(rp>1e-12){var p0=asin$1(rp/r0*sin$2(ap)),p1=asin$1(rp/r1*sin$2(ap));(da0-=2*p0)>1e-12?(a00+=p0*=cw?1:-1,a10-=p0):(da0=0,a00=a10=(a0+a1)/2),(da1-=2*p1)>1e-12?(a01+=p1*=cw?1:-1,a11-=p1):(da1=0,a01=a11=(a0+a1)/2)}var x01=r1*cos$2(a01),y01=r1*sin$2(a01),x10=r0*cos$2(a10),y10=r0*sin$2(a10);if(rc>1e-12){var x11=r1*cos$2(a11),y11=r1*sin$2(a11),x00=r0*cos$2(a00),y00=r0*sin$2(a00);if(da<pi$4){var oc=da0>1e-12?intersect(x01,y01,x00,y00,x11,y11,x10,y10):[x10,y10],ax=x01-oc[0],ay=y01-oc[1],bx=x11-oc[0],by=y11-oc[1],kc=1/sin$2(acos$1((ax*bx+ay*by)/(sqrt$2(ax*ax+ay*ay)*sqrt$2(bx*bx+by*by)))/2),lc=sqrt$2(oc[0]*oc[0]+oc[1]*oc[1]);rc0=min$1(rc,(r0-lc)/(kc-1)),rc1=min$1(rc,(r1-lc)/(kc+1))}}da1>1e-12?rc1>1e-12?(t0=cornerTangents(x00,y00,x01,y01,r1,rc1,cw),t1=cornerTangents(x11,y11,x10,y10,r1,rc1,cw),context.moveTo(t0.cx+t0.x01,t0.cy+t0.y01),rc1<rc?context.arc(t0.cx,t0.cy,rc1,atan2$1(t0.y01,t0.x01),atan2$1(t1.y01,t1.x01),!cw):(context.arc(t0.cx,t0.cy,rc1,atan2$1(t0.y01,t0.x01),atan2$1(t0.y11,t0.x11),!cw),context.arc(0,0,r1,atan2$1(t0.cy+t0.y11,t0.cx+t0.x11),atan2$1(t1.cy+t1.y11,t1.cx+t1.x11),!cw),context.arc(t1.cx,t1.cy,rc1,atan2$1(t1.y11,t1.x11),atan2$1(t1.y01,t1.x01),!cw))):(context.moveTo(x01,y01),context.arc(0,0,r1,a01,a11,!cw)):context.moveTo(x01,y01),r0>1e-12&&da0>1e-12?rc0>1e-12?(t0=cornerTangents(x10,y10,x11,y11,r0,-rc0,cw),t1=cornerTangents(x01,y01,x00,y00,r0,-rc0,cw),context.lineTo(t0.cx+t0.x01,t0.cy+t0.y01),rc0<rc?context.arc(t0.cx,t0.cy,rc0,atan2$1(t0.y01,t0.x01),atan2$1(t1.y01,t1.x01),!cw):(context.arc(t0.cx,t0.cy,rc0,atan2$1(t0.y01,t0.x01),atan2$1(t0.y11,t0.x11),!cw),context.arc(0,0,r0,atan2$1(t0.cy+t0.y11,t0.cx+t0.x11),atan2$1(t1.cy+t1.y11,t1.cx+t1.x11),cw),context.arc(t1.cx,t1.cy,rc0,atan2$1(t1.y11,t1.x11),atan2$1(t1.y01,t1.x01),!cw))):context.arc(0,0,r0,a10,a00,cw):context.lineTo(x10,y10)}else context.moveTo(0,0);if(context.closePath(),buffer)return context=null,buffer+""||null}return arc.centroid=function(){var r=(+innerRadius.apply(this,arguments)+ +outerRadius.apply(this,arguments))/2,a=(+startAngle.apply(this,arguments)+ +endAngle.apply(this,arguments))/2-pi$4/2;return[cos$2(a)*r,sin$2(a)*r]},arc.innerRadius=function(_){return arguments.length?(innerRadius="function"==typeof _?_:constant$10(+_),arc):innerRadius},arc.outerRadius=function(_){return arguments.length?(outerRadius="function"==typeof _?_:constant$10(+_),arc):outerRadius},arc.cornerRadius=function(_){return arguments.length?(cornerRadius="function"==typeof _?_:constant$10(+_),arc):cornerRadius},arc.padRadius=function(_){return arguments.length?(padRadius=null==_?null:"function"==typeof _?_:constant$10(+_),arc):padRadius},arc.startAngle=function(_){return arguments.length?(startAngle="function"==typeof _?_:constant$10(+_),arc):startAngle},arc.endAngle=function(_){return arguments.length?(endAngle="function"==typeof _?_:constant$10(+_),arc):endAngle},arc.padAngle=function(_){return arguments.length?(padAngle="function"==typeof _?_:constant$10(+_),arc):padAngle},arc.context=function(_){return arguments.length?(context=null==_?null:_,arc):context},arc},exports.area=area$2,exports.line=line,exports.pie=function(){var value=identity$7,sortValues=descending$1,sort=null,startAngle=constant$10(0),endAngle=constant$10(tau$4),padAngle=constant$10(0);function pie(data){var i,j,k,a1,v,n=data.length,sum=0,index=new Array(n),arcs=new Array(n),a0=+startAngle.apply(this,arguments),da=Math.min(tau$4,Math.max(-tau$4,endAngle.apply(this,arguments)-a0)),p=Math.min(Math.abs(da)/n,padAngle.apply(this,arguments)),pa=p*(da<0?-1:1);for(i=0;i<n;++i)(v=arcs[index[i]=i]=+value(data[i],i,data))>0&&(sum+=v);for(null!=sortValues?index.sort((function(i,j){return sortValues(arcs[i],arcs[j])})):null!=sort&&index.sort((function(i,j){return sort(data[i],data[j])})),i=0,k=sum?(da-n*pa)/sum:0;i<n;++i,a0=a1)j=index[i],a1=a0+((v=arcs[j])>0?v*k:0)+pa,arcs[j]={data:data[j],index:i,value:v,startAngle:a0,endAngle:a1,padAngle:p};return arcs}return pie.value=function(_){return arguments.length?(value="function"==typeof _?_:constant$10(+_),pie):value},pie.sortValues=function(_){return arguments.length?(sortValues=_,sort=null,pie):sortValues},pie.sort=function(_){return arguments.length?(sort=_,sortValues=null,pie):sort},pie.startAngle=function(_){return arguments.length?(startAngle="function"==typeof _?_:constant$10(+_),pie):startAngle},pie.endAngle=function(_){return arguments.length?(endAngle="function"==typeof _?_:constant$10(+_),pie):endAngle},pie.padAngle=function(_){return arguments.length?(padAngle="function"==typeof _?_:constant$10(+_),pie):padAngle},pie},exports.radialArea=function(){var a=area$2().curve(curveRadialLinear),c=a.curve,x0=a.lineX0,x1=a.lineX1,y0=a.lineY0,y1=a.lineY1;return a.angle=a.x,delete a.x,a.startAngle=a.x0,delete a.x0,a.endAngle=a.x1,delete a.x1,a.radius=a.y,delete a.y,a.innerRadius=a.y0,delete a.y0,a.outerRadius=a.y1,delete a.y1,a.lineStartAngle=function(){return radialLine(x0())},delete a.lineX0,a.lineEndAngle=function(){return radialLine(x1())},delete a.lineX1,a.lineInnerRadius=function(){return radialLine(y0())},delete a.lineY0,a.lineOuterRadius=function(){return radialLine(y1())},delete a.lineY1,a.curve=function(_){return arguments.length?c(curveRadial(_)):c()._curve},a},exports.radialLine=function(){return radialLine(line().curve(curveRadialLinear))},exports.symbol=function(){var type=constant$10(circle$2),size=constant$10(64),context=null;function symbol(){var buffer;if(context||(context=buffer=path()),type.apply(this,arguments).draw(context,+size.apply(this,arguments)),buffer)return context=null,buffer+""||null}return symbol.type=function(_){return arguments.length?(type="function"==typeof _?_:constant$10(_),symbol):type},symbol.size=function(_){return arguments.length?(size="function"==typeof _?_:constant$10(+_),symbol):size},symbol.context=function(_){return arguments.length?(context=null==_?null:_,symbol):context},symbol},exports.symbols=symbols,exports.symbolCircle=circle$2,exports.symbolCross=cross$2,exports.symbolDiamond=diamond,exports.symbolSquare=square,exports.symbolStar=star,exports.symbolTriangle=triangle,exports.symbolWye=wye,exports.curveBasisClosed=function(context){return new BasisClosed(context)},exports.curveBasisOpen=function(context){return new BasisOpen(context)},exports.curveBasis=function(context){return new Basis(context)},exports.curveBundle=bundle,exports.curveCardinalClosed=cardinalClosed,exports.curveCardinalOpen=cardinalOpen,exports.curveCardinal=cardinal,exports.curveCatmullRomClosed=catmullRomClosed,exports.curveCatmullRomOpen=catmullRomOpen,exports.curveCatmullRom=catmullRom,exports.curveLinearClosed=function(context){return new LinearClosed(context)},exports.curveLinear=curveLinear,exports.curveMonotoneX=function monotoneX(context){return new MonotoneX(context)},exports.curveMonotoneY=function monotoneY(context){return new MonotoneY(context)},exports.curveNatural=function(context){return new Natural(context)},exports.curveStep=function(context){return new Step(context,.5)},exports.curveStepAfter=function stepAfter(context){return new Step(context,1)},exports.curveStepBefore=function stepBefore(context){return new Step(context,0)},exports.stack=function(){var keys=constant$10([]),order=none$2,offset=none$1,value=stackValue;function stack(data){var i,oz,kz=keys.apply(this,arguments),m=data.length,n=kz.length,sz=new Array(n);for(i=0;i<n;++i){for(var sij,ki=kz[i],si=sz[i]=new Array(m),j=0;j<m;++j)si[j]=sij=[0,+value(data[j],ki,j,data)],sij.data=data[j];si.key=ki}for(i=0,oz=order(sz);i<n;++i)sz[oz[i]].index=i;return offset(sz,oz),sz}return stack.keys=function(_){return arguments.length?(keys="function"==typeof _?_:constant$10(slice$5.call(_)),stack):keys},stack.value=function(_){return arguments.length?(value="function"==typeof _?_:constant$10(+_),stack):value},stack.order=function(_){return arguments.length?(order=null==_?none$2:"function"==typeof _?_:constant$10(slice$5.call(_)),stack):order},stack.offset=function(_){return arguments.length?(offset=null==_?none$1:_,stack):offset},stack},exports.stackOffsetExpand=function(series,order){if((n=series.length)>0){for(var i,n,y,j=0,m=series[0].length;j<m;++j){for(y=i=0;i<n;++i)y+=series[i][j][1]||0;if(y)for(i=0;i<n;++i)series[i][j][1]/=y}none$1(series,order)}},exports.stackOffsetNone=none$1,exports.stackOffsetSilhouette=function(series,order){if((n=series.length)>0){for(var n,j=0,s0=series[order[0]],m=s0.length;j<m;++j){for(var i=0,y=0;i<n;++i)y+=series[i][j][1]||0;s0[j][1]+=s0[j][0]=-y/2}none$1(series,order)}},exports.stackOffsetWiggle=function(series,order){if((n=series.length)>0&&(m=(s0=series[order[0]]).length)>0){for(var s0,m,n,y=0,j=1;j<m;++j){for(var i=0,s1=0,s2=0;i<n;++i){for(var si=series[order[i]],sij0=si[j][1]||0,s3=(sij0-(si[j-1][1]||0))/2,k=0;k<i;++k){var sk=series[order[k]];s3+=(sk[j][1]||0)-(sk[j-1][1]||0)}s1+=sij0,s2+=s3*sij0}s0[j-1][1]+=s0[j-1][0]=y,s1&&(y-=s2/s1)}s0[j-1][1]+=s0[j-1][0]=y,none$1(series,order)}},exports.stackOrderAscending=ascending$2,exports.stackOrderDescending=function(series){return ascending$2(series).reverse()},exports.stackOrderInsideOut=function(series){var i,j,n=series.length,sums=series.map(sum$2),order=none$2(series).sort((function(a,b){return sums[b]-sums[a]})),top=0,bottom=0,tops=[],bottoms=[];for(i=0;i<n;++i)j=order[i],top<bottom?(top+=sums[j],tops.push(j)):(bottom+=sums[j],bottoms.push(j));return bottoms.reverse().concat(tops)},exports.stackOrderNone=none$2,exports.stackOrderReverse=function(series){return none$2(series).reverse()},exports.timeInterval=newInterval,exports.timeMillisecond=millisecond,exports.timeMilliseconds=milliseconds,exports.utcMillisecond=millisecond,exports.utcMilliseconds=milliseconds,exports.timeSecond=second,exports.timeSeconds=seconds,exports.utcSecond=second,exports.utcSeconds=seconds,exports.timeMinute=minute,exports.timeMinutes=minutes,exports.timeHour=hour,exports.timeHours=hours,exports.timeDay=day,exports.timeDays=days,exports.timeWeek=sunday,exports.timeWeeks=sundays,exports.timeSunday=sunday,exports.timeSundays=sundays,exports.timeMonday=monday,exports.timeMondays=mondays,exports.timeTuesday=tuesday,exports.timeTuesdays=tuesdays,exports.timeWednesday=wednesday,exports.timeWednesdays=wednesdays,exports.timeThursday=thursday,exports.timeThursdays=thursdays,exports.timeFriday=friday,exports.timeFridays=fridays,exports.timeSaturday=saturday,exports.timeSaturdays=saturdays,exports.timeMonth=month,exports.timeMonths=months,exports.timeYear=year,exports.timeYears=years,exports.utcMinute=utcMinute,exports.utcMinutes=utcMinutes,exports.utcHour=utcHour,exports.utcHours=utcHours,exports.utcDay=utcDay,exports.utcDays=utcDays,exports.utcWeek=utcSunday,exports.utcWeeks=utcSundays,exports.utcSunday=utcSunday,exports.utcSundays=utcSundays,exports.utcMonday=utcMonday,exports.utcMondays=utcMondays,exports.utcTuesday=utcTuesday,exports.utcTuesdays=utcTuesdays,exports.utcWednesday=utcWednesday,exports.utcWednesdays=utcWednesdays,exports.utcThursday=utcThursday,exports.utcThursdays=utcThursdays,exports.utcFriday=utcFriday,exports.utcFridays=utcFridays,exports.utcSaturday=utcSaturday,exports.utcSaturdays=utcSaturdays,exports.utcMonth=utcMonth,exports.utcMonths=utcMonths,exports.utcYear=utcYear,exports.utcYears=utcYears,exports.timeFormatDefaultLocale=defaultLocale$1,exports.timeFormatLocale=formatLocale$1,exports.isoFormat=formatIso,exports.isoParse=parseIso,exports.now=now,exports.timer=timer,exports.timerFlush=timerFlush,exports.timeout=timeout$1,exports.interval=function(callback,delay,time){var t=new Timer,total=delay;return null==delay?(t.restart(callback,delay,time),t):(delay=+delay,time=null==time?now():+time,t.restart((function tick(elapsed){elapsed+=total,t.restart(tick,total+=delay,time),callback(elapsed)}),delay,time),t)},exports.transition=transition,exports.active=function(node,name){var schedule,i,schedules=node.__transition;if(schedules)for(i in name=null==name?null:name+"",schedules)if((schedule=schedules[i]).state>1&&schedule.name===name)return new Transition([[node]],root$1,name,+i);return null},exports.interrupt=interrupt,exports.voronoi=function(){var x$$1=x$4,y$$1=y$4,extent=null;function voronoi(data){return new Diagram(data.map((function(d,i){var s=[Math.round(x$$1(d,i,data)/epsilon$4)*epsilon$4,Math.round(y$$1(d,i,data)/epsilon$4)*epsilon$4];return s.index=i,s.data=d,s})),extent)}return voronoi.polygons=function(data){return voronoi(data).polygons()},voronoi.links=function(data){return voronoi(data).links()},voronoi.triangles=function(data){return voronoi(data).triangles()},voronoi.x=function(_){return arguments.length?(x$$1="function"==typeof _?_:constant$11(+_),voronoi):x$$1},voronoi.y=function(_){return arguments.length?(y$$1="function"==typeof _?_:constant$11(+_),voronoi):y$$1},voronoi.extent=function(_){return arguments.length?(extent=null==_?null:[[+_[0][0],+_[0][1]],[+_[1][0],+_[1][1]]],voronoi):extent&&[[extent[0][0],extent[0][1]],[extent[1][0],extent[1][1]]]},voronoi.size=function(_){return arguments.length?(extent=null==_?null:[[0,0],[+_[0],+_[1]]],voronoi):extent&&[extent[1][0]-extent[0][0],extent[1][1]-extent[0][1]]},voronoi},exports.zoom=function(){var touchstarting,touchending,filter=defaultFilter$2,extent=defaultExtent$1,k0=0,k1=1/0,x0=-k1,x1=k1,y0=x0,y1=x1,duration=250,interpolate$$1=interpolateZoom,gestures=[],listeners=dispatch("start","zoom","end");function zoom(selection$$1){selection$$1.on("wheel.zoom",wheeled).on("mousedown.zoom",mousedowned).on("dblclick.zoom",dblclicked).on("touchstart.zoom",touchstarted).on("touchmove.zoom",touchmoved).on("touchend.zoom touchcancel.zoom",touchended).style("-webkit-tap-highlight-color","rgba(0,0,0,0)").property("__zoom",defaultTransform)}function scale(transform,k){return(k=Math.max(k0,Math.min(k1,k)))===transform.k?transform:new Transform(k,transform.x,transform.y)}function translate(transform,p0,p1){var x=p0[0]-p1[0]*transform.k,y=p0[1]-p1[1]*transform.k;return x===transform.x&&y===transform.y?transform:new Transform(transform.k,x,y)}function constrain(transform,extent){var dx0=transform.invertX(extent[0][0])-x0,dx1=transform.invertX(extent[1][0])-x1,dy0=transform.invertY(extent[0][1])-y0,dy1=transform.invertY(extent[1][1])-y1;return transform.translate(dx1>dx0?(dx0+dx1)/2:Math.min(0,dx0)||Math.max(0,dx1),dy1>dy0?(dy0+dy1)/2:Math.min(0,dy0)||Math.max(0,dy1))}function centroid(extent){return[(+extent[0][0]+ +extent[1][0])/2,(+extent[0][1]+ +extent[1][1])/2]}function schedule(transition$$1,transform,center){transition$$1.on("start.zoom",(function(){gesture(this,arguments).start()})).on("interrupt.zoom end.zoom",(function(){gesture(this,arguments).end()})).tween("zoom",(function(){var that=this,args=arguments,g=gesture(that,args),e=extent.apply(that,args),p=center||centroid(e),w=Math.max(e[1][0]-e[0][0],e[1][1]-e[0][1]),a=that.__zoom,b="function"==typeof transform?transform.apply(that,args):transform,i=interpolate$$1(a.invert(p).concat(w/a.k),b.invert(p).concat(w/b.k));return function(t){if(1===t)t=b;else{var l=i(t),k=w/l[2];t=new Transform(k,p[0]-l[0]*k,p[1]-l[1]*k)}g.zoom(null,t)}}))}function gesture(that,args){for(var g,i=0,n=gestures.length;i<n;++i)if((g=gestures[i]).that===that)return g;return new Gesture(that,args)}function Gesture(that,args){this.that=that,this.args=args,this.index=-1,this.active=0,this.extent=extent.apply(that,args)}function wheeled(){if(filter.apply(this,arguments)){var g=gesture(this,arguments),t=this.__zoom,k=Math.max(k0,Math.min(k1,t.k*Math.pow(2,-exports.event.deltaY*(exports.event.deltaMode?120:1)/500))),p=mouse(this);if(g.wheel)g.mouse[0][0]===p[0]&&g.mouse[0][1]===p[1]||(g.mouse[1]=t.invert(g.mouse[0]=p)),clearTimeout(g.wheel);else{if(t.k===k)return;g.mouse=[p,t.invert(p)],interrupt(this),g.start()}noevent$2(),g.wheel=setTimeout(wheelidled,150),g.zoom("mouse",constrain(translate(scale(t,k),g.mouse[0],g.mouse[1]),g.extent))}function wheelidled(){g.wheel=null,g.end()}}function mousedowned(){if(!touchending&&filter.apply(this,arguments)){var g=gesture(this,arguments),v=select(exports.event.view).on("mousemove.zoom",mousemoved,!0).on("mouseup.zoom",mouseupped,!0),p=mouse(this);dragDisable(exports.event.view),nopropagation$2(),g.mouse=[p,this.__zoom.invert(p)],interrupt(this),g.start()}function mousemoved(){noevent$2(),g.moved=!0,g.zoom("mouse",constrain(translate(g.that.__zoom,g.mouse[0]=mouse(g.that),g.mouse[1]),g.extent))}function mouseupped(){v.on("mousemove.zoom mouseup.zoom",null),yesdrag(exports.event.view,g.moved),noevent$2(),g.end()}}function dblclicked(){if(filter.apply(this,arguments)){var t0=this.__zoom,p0=mouse(this),p1=t0.invert(p0),k1=t0.k*(exports.event.shiftKey?.5:2),t1=constrain(translate(scale(t0,k1),p0,p1),extent.apply(this,arguments));noevent$2(),duration>0?select(this).transition().duration(duration).call(schedule,t1,p0):select(this).call(zoom.transform,t1)}}function touchstarted(){if(filter.apply(this,arguments)){var started,i,t,p,g=gesture(this,arguments),touches$$1=exports.event.changedTouches,n=touches$$1.length;for(nopropagation$2(),i=0;i<n;++i)t=touches$$1[i],p=[p=touch(this,touches$$1,t.identifier),this.__zoom.invert(p),t.identifier],g.touch0?g.touch1||(g.touch1=p):(g.touch0=p,started=!0);if(touchstarting&&(touchstarting=clearTimeout(touchstarting),!g.touch1))return g.end(),void((p=select(this).on("dblclick.zoom"))&&p.apply(this,arguments));started&&(touchstarting=setTimeout((function(){touchstarting=null}),500),interrupt(this),g.start())}}function touchmoved(){var i,t,p,l,g=gesture(this,arguments),touches$$1=exports.event.changedTouches,n=touches$$1.length;for(noevent$2(),touchstarting&&(touchstarting=clearTimeout(touchstarting)),i=0;i<n;++i)t=touches$$1[i],p=touch(this,touches$$1,t.identifier),g.touch0&&g.touch0[2]===t.identifier?g.touch0[0]=p:g.touch1&&g.touch1[2]===t.identifier&&(g.touch1[0]=p);if(t=g.that.__zoom,g.touch1){var p0=g.touch0[0],l0=g.touch0[1],p1=g.touch1[0],l1=g.touch1[1],dp=(dp=p1[0]-p0[0])*dp+(dp=p1[1]-p0[1])*dp,dl=(dl=l1[0]-l0[0])*dl+(dl=l1[1]-l0[1])*dl;t=scale(t,Math.sqrt(dp/dl)),p=[(p0[0]+p1[0])/2,(p0[1]+p1[1])/2],l=[(l0[0]+l1[0])/2,(l0[1]+l1[1])/2]}else{if(!g.touch0)return;p=g.touch0[0],l=g.touch0[1]}g.zoom("touch",constrain(translate(t,p,l),g.extent))}function touchended(){var i,t,g=gesture(this,arguments),touches$$1=exports.event.changedTouches,n=touches$$1.length;for(nopropagation$2(),touchending&&clearTimeout(touchending),touchending=setTimeout((function(){touchending=null}),500),i=0;i<n;++i)t=touches$$1[i],g.touch0&&g.touch0[2]===t.identifier?delete g.touch0:g.touch1&&g.touch1[2]===t.identifier&&delete g.touch1;g.touch1&&!g.touch0&&(g.touch0=g.touch1,delete g.touch1),g.touch0?g.touch0[1]=this.__zoom.invert(g.touch0[0]):g.end()}return zoom.transform=function(collection,transform){var selection$$1=collection.selection?collection.selection():collection;selection$$1.property("__zoom",defaultTransform),collection!==selection$$1?schedule(collection,transform):selection$$1.interrupt().each((function(){gesture(this,arguments).start().zoom(null,"function"==typeof transform?transform.apply(this,arguments):transform).end()}))},zoom.scaleBy=function(selection$$1,k){zoom.scaleTo(selection$$1,(function(){var k0=this.__zoom.k,k1="function"==typeof k?k.apply(this,arguments):k;return k0*k1}))},zoom.scaleTo=function(selection$$1,k){zoom.transform(selection$$1,(function(){var e=extent.apply(this,arguments),t0=this.__zoom,p0=centroid(e),p1=t0.invert(p0),k1="function"==typeof k?k.apply(this,arguments):k;return constrain(translate(scale(t0,k1),p0,p1),e)}))},zoom.translateBy=function(selection$$1,x,y){zoom.transform(selection$$1,(function(){return constrain(this.__zoom.translate("function"==typeof x?x.apply(this,arguments):x,"function"==typeof y?y.apply(this,arguments):y),extent.apply(this,arguments))}))},Gesture.prototype={start:function(){return 1==++this.active&&(this.index=gestures.push(this)-1,this.emit("start")),this},zoom:function(key,transform){return this.mouse&&"mouse"!==key&&(this.mouse[1]=transform.invert(this.mouse[0])),this.touch0&&"touch"!==key&&(this.touch0[1]=transform.invert(this.touch0[0])),this.touch1&&"touch"!==key&&(this.touch1[1]=transform.invert(this.touch1[0])),this.that.__zoom=transform,this.emit("zoom"),this},end:function(){return 0==--this.active&&(gestures.splice(this.index,1),this.index=-1,this.emit("end")),this},emit:function(type){customEvent(new ZoomEvent(zoom,type,this.that.__zoom),listeners.apply,listeners,[type,this.that,this.args])}},zoom.filter=function(_){return arguments.length?(filter="function"==typeof _?_:constant$12(!!_),zoom):filter},zoom.extent=function(_){return arguments.length?(extent="function"==typeof _?_:constant$12([[+_[0][0],+_[0][1]],[+_[1][0],+_[1][1]]]),zoom):extent},zoom.scaleExtent=function(_){return arguments.length?(k0=+_[0],k1=+_[1],zoom):[k0,k1]},zoom.translateExtent=function(_){return arguments.length?(x0=+_[0][0],x1=+_[1][0],y0=+_[0][1],y1=+_[1][1],zoom):[[x0,y0],[x1,y1]]},zoom.duration=function(_){return arguments.length?(duration=+_,zoom):duration},zoom.interpolate=function(_){return arguments.length?(interpolate$$1=_,zoom):interpolate$$1},zoom.on=function(){var value=listeners.on.apply(listeners,arguments);return value===listeners?zoom:value},zoom},exports.zoomTransform=transform$1,exports.zoomIdentity=identity$8,Object.defineProperty(exports,"__esModule",{value:!0})})),Ext.define("Ext.d3.ComponentBase",{extend:"Ext.Widget",onElementResize:function(element,size){this.handleResize(size)},destroy:function(){this.hasListeners.destroy&&this.fireEvent("destroy",this),this.callParent()}}),Ext.namespace("Ext.d3.lib").d3=!0,Ext.define("Ext.d3.Component",{extend:"Ext.d3.ComponentBase",requires:["Ext.d3.lib.d3"],isD3:!0,config:{store:null,componentCls:"",interactions:[],transitions:{none:{name:void 0,duration:0,ease:Ext.identityFn}},touchAction:{panX:!1,panY:!1,pinchZoom:!1,doubleTapZoom:!1}},baseCls:Ext.baseCSSPrefix+"d3",defaultBindProperty:"store",isInitializing:!0,refreshDelay:100,resizeDelay:250,resizeTimerId:0,size:null,d3Components:null,constructor:function(config){var me=this;me.d3Components={},me.callParent(arguments),me.isInitializing=!1,me.on("resize","onElementResize",me)},destroy:function(){var me=this;me.resizeTimerId&&clearTimeout(me.resizeTimerId),me.un("resize","onElementResize",me),me.setInteractions(),me.callParent()},updateComponentCls:function(componentCls,oldComponentCls){var baseCls=this.baseCls,el=this.element;componentCls&&Ext.isString(componentCls)&&(el.addCls(componentCls,baseCls),oldComponentCls&&el.removeCls(oldComponentCls,baseCls))},register:function(component){var map=this.d3Components,id=component.getId();void 0===id&&Ext.raise("Attempting to register a component with no ID."),id in map&&Ext.raise('Component with ID "'+id+'" is already registered.'),map[id]=component},unregister:function(component){delete this.d3Components[component.getId()]},applyInteractions:function(interactions,oldInteractions){oldInteractions||((oldInteractions=[]).map={});var i,ln,interaction,id,result=[],oldMap=oldInteractions.map;for(result.map={},i=0,ln=(interactions=Ext.Array.from(interactions,!0)).length;i<ln;i++)(interaction=interactions[i])&&(interaction.isInteraction?id=interaction.getId():(id=interaction.id,interaction.element=this.element),(interaction=Ext.factory(interaction,null,oldMap[id],"d3.interaction"))&&(interaction.setComponent(this),this.addInteraction(interaction),result.push(interaction),result.map[interaction.getId()]=interaction));for(i in oldMap)result.map[i]||(interaction=oldMap[i]).destroy();return result},applyTransitions:function(transitions){var name,transition,ease,ret={};for(name in transitions)!0===(transition=transitions[name])&&Ext.raise("'true' is not a valid transition value (should be an object or 'false')."),ret[name]=transition=Ext.apply({},transition||transitions.none),"string"==typeof(ease=transition.ease)&&(transition.ease=d3["ease"+ease.charAt(0).toUpperCase()+ease.substr(1)]),"name"in transition||(transition.name=this.getId()+"-"+name);return ret},createTransition:function(name,selection){var transition=this.getTransitions()[name];return transition||Ext.raise('No transition named "'+name+'"'),selection||(selection=d3),selection.transition(transition.name).ease(transition.ease).duration(transition.duration)},panZoom:null,onPanZoom:Ext.emptyFn,getContentRect:Ext.emptyFn,getViewportRect:Ext.emptyFn,addInteraction:function(interaction){var me=this;interaction.isPanZoom&&(interaction.setContentRect(me.getContentRect.bind(me)),interaction.setViewportRect(me.getViewportRect.bind(me)),me.panZoom=interaction,interaction.on("panzoom",me.onPanZoom,me)),interaction.on("destroy",me.onInteractionDestroy,me)},removeInteraction:function(interaction){interaction.isPanZoom&&(interaction.setContentRect(null),interaction.setViewportRect(null),this.panZoom=null,interaction.un("panzoom",this.onPanZoom,this))},onInteractionDestroy:function(interaction){interaction.un("destroy",this.onInteractionDestroy,this),this.removeInteraction(interaction)},applyStore:function(store){return store&&Ext.StoreManager.lookup(store)},updateStore:function(store,oldStore){var root,storeEvents={datachanged:"onDataChange",buffer:this.refreshDelay,scope:this,order:"after"};oldStore&&(oldStore.un(storeEvents),oldStore.getAutoDestroy()&&oldStore.destroy()),store&&(store.on(storeEvents),store.isTreeStore&&((root=store.getRoot()).isExpanded()||(store.suspendEvent("datachanged"),root.on({expand:function(){store.resumeEvent("datachanged"),store.fireEvent("datachanged",store)},single:!0})))),this.onDataChange(store)},onDataChange:function(store){this.isInitializing||this.processDataChange(store)},onDataUpdate:function(store,record,operation,modifiedFieldNames,details){this.isInitializing||this.processDataUpdate(store,record,operation,modifiedFieldNames,details)},onDataLoad:function(store,records,successful,operation){this.processDataLoad(store,records,successful,operation)},processDataChange:Ext.emptyFn,processDataUpdate:Ext.emptyFn,processDataLoad:Ext.emptyFn,maskEl:null,showMask:function(msg){this.maskEl?(this.maskEl.dom.firstChild.textContent=msg,this.maskEl.setStyle("display","flex")):this.maskEl=this.element.createChild({style:{position:"absolute",display:"flex",alignItems:"center",justifyContent:"center",left:0,top:0,bottom:0,right:0,background:"rgba(0,0,0,0.5)"},children:[{html:msg,style:{background:"rgba(0,0,0,0.8)",color:"white",fontWeight:"bold",borderRadius:"10px",padding:"10px"}}]})},hideMask:function(){this.maskEl&&this.maskEl.setStyle("display","none")},handleResize:function(size,instantly){var me=this,el=me.element;(size=size||el&&el.getSize())&&size.width&&size.height&&(clearTimeout(me.resizeTimerId),instantly?(me.resizeTimerId=0,me.resizeHandler(size),me.panZoom&&me.panZoom.updateIndicator&&me.panZoom.updateIndicator(),me.size=size):me.resizeTimerId=Ext.defer(me.handleResize,me.resizeDelay,me,[size,!0]))},resizeHandler:Ext.emptyFn,toLocalXY:function(event,view){var pageXY=event.getXY(),viewXY=view?view.getXY():this.element.getXY();return[pageXY[0]-viewXY[0],pageXY[1]-viewXY[1]]}}),Ext.define("Ext.d3.svg.Svg",{extend:"Ext.d3.Component",xtype:["d3-svg","d3"],isSvg:!0,config:{padding:{top:0,left:0,right:0,bottom:0},clipScene:!1},defaultCls:{wrapper:Ext.baseCSSPrefix+"d3-wrapper",scene:Ext.baseCSSPrefix+"d3-scene",hidden:Ext.baseCSSPrefix+"d3-hidden",invisible:Ext.baseCSSPrefix+"d3-invisible"},defs:null,wrapper:null,wrapperClipRect:null,wrapperClipId:"wrapper-clip",scene:null,sceneRect:null,svg:null,onClassExtended:function(subClass,data){Ext.applyIf(data.defaultCls,subClass.superclass.defaultCls)},applyPadding:function(padding,oldPadding){return Ext.isObject(padding)?oldPadding?Ext.apply(oldPadding,padding):padding:Ext.util.Format.parseBox(padding)},getSvg:function(){return this.svg||(this.svg=d3.select(this.element.dom).append("svg").attr("version","1.1"))},resizeHandler:function(size){var rect,me=this,svg=me.getSvg(),paddingCfg=me.getPadding(),isRtl=me.getInherited().rtl,wrapper=me.getWrapper(),wrapperClipRect=me.getWrapperClipRect(),scene=me.getScene(),width=size&&size.width,height=size&&size.height;width&&height&&(svg.attr("width",width).attr("height",height),(rect=me.sceneRect||(me.sceneRect={})).x=isRtl?paddingCfg.right:paddingCfg.left,rect.y=paddingCfg.top,rect.width=width-paddingCfg.left-paddingCfg.right,rect.height=height-paddingCfg.top-paddingCfg.bottom,wrapper.attr("transform","translate("+rect.x+","+rect.y+")"),wrapperClipRect.attr("width",rect.width).attr("height",rect.height),me.onSceneResize(scene,rect),me.fireEvent("sceneresize",me,scene,rect))},updatePadding:function(){this.isConfiguring||this.resizeHandler(this.getSize())},getSceneRect:function(){return this.sceneRect},getContentRect:function(){return this.scene&&this.scene.node().getBBox()},getViewportRect:function(){return this.sceneRect},scaleRe:/scale\((.+),(.+)\)/i,alignContentTransitionName:null,alignMap:{c:"cc",t:"ct",b:"cb",l:"lc",r:"rc",lc:"lc",cl:"lc",rc:"rc",cr:"rc",ct:"ct",tc:"ct",cb:"cb",bc:"cb",rt:"rt",tr:"rt",rb:"rb",br:"rb",lt:"lt",tl:"lt",lb:"lb",bl:"lb"},alignContent:function(options,transition){var tx,ty,translation,transform,scaleMatch,xy,x,y,me=this,scale="",sx=1,sy=1,sceneRect=me.getSceneRect(),contentRect=me.getContentRect(),scene=me.scene.interrupt(me.alignContentTransitionName);if(sceneRect&&contentRect){switch((transform=scene.attr("transform"))&&(scaleMatch=transform.match(me.scaleRe))&&(scale=scaleMatch[0],sx=scaleMatch[1],sy=scaleMatch[2]),(xy=me.alignMap[options])||Ext.raise("Invalid content align options."),x=xy[0],y=xy[1],x){case"c":tx=sceneRect.width/2-(contentRect.x+contentRect.width/2)*sx;break;case"l":tx=-contentRect.x*sx;break;case"r":tx=sceneRect.width-(contentRect.x+contentRect.width)*sx}switch(y){case"c":ty=sceneRect.height/2-(contentRect.y+contentRect.height/2)*sy;break;case"t":ty=-contentRect.y*sy;break;case"b":ty=sceneRect.height-(contentRect.y+contentRect.height)*sy}}Ext.isNumber(tx)&&Ext.isNumber(ty)&&(translation=[tx,ty],transition&&("string"==typeof transition&&(transition=me.createTransition(transition)),me.alignContentTransitionName=transition._name,scene=scene.transition(transition)),scene.attr("transform","translate("+translation+")"+scale),me.panZoom&&me.panZoom.setPanZoomSilently(translation))},onSceneResize:Ext.emptyFn,getScene:function(){var me=this,padding=me.getWrapper(),scene=me.scene;return scene||(me.scene=scene=padding.append("g").classed(me.defaultCls.scene,!0),me.setupScene(scene),me.fireEvent("scenesetup",me,scene)),scene},clearScene:function(){var scene=this.scene,defs=this.defs;if(scene)for((scene=scene.node()).removeAttribute("transform");scene.firstChild;)scene.removeChild(scene.firstChild);if(defs)for(defs=defs.node();defs.firstChild;)defs.removeChild(defs.firstChild)},showScene:function(){var scene=this.scene;scene&&scene.classed(this.defaultCls.invisible,!1)},hideScene:function(){var scene=this.scene;scene&&scene.classed(this.defaultCls.invisible,!0)},setupScene:Ext.emptyFn,onPanZoom:function(interaction,scaling,translation){this.scene.attr("transform","translate("+translation+")scale("+scaling+")")},removeInteraction:function(interaction){interaction.isPanZoom&&this.scene.attr("transform",null),this.callParent([interaction])},getWrapper:function(){var padding=this.wrapper;return padding||(padding=this.wrapper=this.getSvg().append("g").classed(this.defaultCls.wrapper,!0)),padding},getWrapperClipRect:function(){var rect=this.wrapperClipRect;return rect||(rect=this.wrapperClipRect=this.getDefs().append("clipPath").attr("id",this.wrapperClipId).append("rect").attr("fill","white")),rect},updateClipScene:function(clipScene){this.getWrapper().attr("clip-path",clipScene?"url(#"+this.wrapperClipId+")":"")},getDefs:function(){var defs=this.defs;return defs||(defs=this.defs=this.getSvg().append("defs")),defs},destroy:function(){this.getSvg().remove(),this.callParent()}}),Ext.define("Ext.d3.Helpers",{singleton:!0,makeScale:function(config){var Type,scale,type=config.type;return type||Ext.raise("The type of scale is not specified."),Type=type.charAt(0).toUpperCase()+type.substr(1),scale=this.make("scale"+Type,config),"nice"in config&&scale.nice&&scale.nice(this.eval(config.nice)),scale._type=type,scale},makeAxis:function(config){var Type,axis,type=config.orient;return type||Ext.raise('The position of the axis ("orient" property) is not specified.'),Type=type.charAt(0).toUpperCase()+type.substr(1),(axis=this.make("axis"+Type,config))._type=type,axis},make:function(name,config){return this.configure(d3[name](),config)},configure:function(thing,config){var key,arrayArgs,param;for(key in config)(arrayArgs="$"===key.charAt(0))&&(key=key.substr(1)),"function"==typeof thing[key]&&(arrayArgs?(param=config["$"+key].map((function(param){return"string"!=typeof param||param.search("d3.")||(param=new Function("return "+param)()),param})),thing[key].apply(thing,param),arrayArgs=!1):(param=this.eval(config[key]),thing[key](param)));return thing},eval:function(param){return"string"!=typeof param||param.search("d3.")||(param=new Function("return "+param)()),param},isBBoxable:function(selection){return!Ext.isFirefox||!selection||(selection instanceof Element&&(selection=d3.select(selection)),document.contains(selection.node())&&"none"!==selection.style("display")&&"hidden"!==selection.attr("visibility"))},getBBox:function(selection){if("none"!==selection.style("display"))return selection.node().getBBox()},setDominantBaseline:function(element,baseline){element.setAttribute("dominant-baseline",baseline),this.fakeDominantBaseline(element,baseline),Ext.isSafari&&"text-after-edge"===baseline&&element.setAttribute("baseline-shift","super")},noDominantBaseline:function(){return Ext.isIE||Ext.isEdge},fakeDominantBaselineMap:{alphabetic:"0em",ideographic:"-.24em",hanging:".72em",mathematical:".46em",middle:".22em",central:".33em","text-after-edge":"-.26em","text-before-edge":".91em"},fakeDominantBaseline:function(element,baseline,force){var dy;(force||this.noDominantBaseline())&&(dy=this.fakeDominantBaselineMap[baseline])&&element.setAttribute("dy",dy)},fakeDominantBaselines:function(config){var selector,baseline,dy,nodeList,i,ln,map=this.fakeDominantBaselineMap;if(this.noDominantBaseline())if(arguments.length>1){if(selector=arguments[0],baseline=arguments[1],nodeList=document.querySelectorAll(selector),dy=map[baseline])for(i=0,ln=nodeList.length;i<ln;i++)nodeList[i].setAttribute("dy",dy)}else for(selector in config)if(dy=map[baseline=config[selector]])for(i=0,ln=(nodeList=document.querySelectorAll(selector)).length;i<ln;i++)nodeList[i].setAttribute("dy",dy)},unitMath:function(string,operation,number){var value=parseFloat(string),unit=string.substr(value.toString().length);switch(operation){case"*":value*=number;break;case"+":value+=number;break;case"/":value/=number;break;case"-":value-=number}return value.toString()+unit},getLinkId:function(link){var pos=link.search("#");return link.substr(pos,link.length-pos-1)},alignRect:function(x,y,inner,outer,selection){var tx,ty,translation;if(outer&&inner){switch(x){case"center":tx=outer.width/2-(inner.x+inner.width/2);break;case"left":tx=-inner.x;break;case"right":tx=outer.width-(inner.x+inner.width);break;default:Ext.raise("Invalid value. Valid `x` values are: center, left, right.")}switch(y){case"center":ty=outer.height/2-(inner.y+inner.height/2);break;case"top":ty=-inner.y;break;case"bottom":ty=outer.height-(inner.y+inner.height);break;default:Ext.raise("Invalid value. Valid `y` values are: center, top, bottom.")}}Ext.isNumber(tx)&&Ext.isNumber(ty)&&(translation=[tx+=outer.x,ty+=outer.y],selection.attr("transform","translate("+translation+")"))},commasRe:/,+/g,getTransformComponent:function(transform,name){var start,end,str,values,pos=transform.indexOf(name);if(pos>=0&&(start=transform.indexOf("(",pos)+1,end=transform.indexOf(")",start),start>=0&&end>=0&&(str=(str=(str=transform.substr(start,end-start)).replace(" ",",")).replace(this.commasRe,","))),str)return(values=str.split(",")).length>1?[parseFloat(values[0]),parseFloat(values[1])]:[parseFloat(values[0])]},parseTransform:function(str){var scale=this.getTransformComponent(str,"scale"),rotate=this.getTransformComponent(str,"rotate"),translate=this.getTransformComponent(str,"translate");return scale?scale.length<2&&scale.push(scale[0]):scale=[0,0],rotate=rotate?rotate[0]:0,translate?translate.length<2&&translate.push(0):translate=[0,0],{scale:scale,rotate:rotate,translate:translate}}}),Ext.define("Ext.d3.mixin.Detached",{extend:"Ext.Mixin",detached:null,constructor:function(config){this.detached=d3.select("body").append("svg").remove().attr("version","1.1")},getDetached:function(){return this.detached},isDetached:function(selection){return selection&&selection.node().parentElement===this.detached.node()},attach:function(parent,child){parent instanceof d3.selection&&(parent=parent.node()),parent instanceof SVGElement||Ext.raise("The `parent` must either be a D3 selection or an SVG element."),child instanceof d3.selection?parent.appendChild(child.node()):child instanceof SVGElement?parent.appendChild(child):Ext.raise("The `child` must either be a D3 selection or an SVG element.")},detach:function(child){this.attach(this.detached,child)},destroy:function(){var node=this.detached.node();node&&node.parentNode&&node.parentNode.removeChild(node),this.callParent()}}),Ext.define("Ext.d3.axis.Axis",{requires:["Ext.d3.Helpers"],mixins:{observable:"Ext.mixin.Observable",detached:"Ext.d3.mixin.Detached"},config:{axis:{orient:"top"},scale:{type:"linear"},title:null,parent:null,component:null},defaultCls:{self:Ext.baseCSSPrefix+"d3-axis",title:Ext.baseCSSPrefix+"d3-axis-title"},title:null,group:null,domain:null,constructor:function(config){var id,me=this;id="id"in(config=config||{})?config.id:"id"in me.config?me.config.id:me.getId(),me.setId(id),me.mixins.detached.constructor.call(me,config),me.group=me.getDetached().append("g").classed(me.defaultCls.self,!0).attr("id",me.getId()),me.mixins.observable.constructor.call(me,config)},getGroup:function(){return this.group},getBox:function(){return this.group.node().getBBox()},applyScale:function(scale,oldScale){var axis=this.getAxis();return scale&&(Ext.isFunction(scale)||(scale=Ext.d3.Helpers.makeScale(scale)),axis&&axis.scale(scale)),scale||oldScale},applyAxis:function(axis,oldAxis){var scale=this.getScale();return axis&&(Ext.isFunction(axis)||(axis=Ext.d3.Helpers.makeAxis(axis)),scale&&axis.scale(scale)),axis||oldAxis},updateParent:function(parent){var me=this;parent?(me.attach(parent,me.group),me.render()):me.detach(me.group)},updateTitle:function(title){var me=this;title?(me.title?me.isDetached(me.title)&&me.attach(me.group,me.title):me.title=me.group.append("text").classed(me.defaultCls.title,!0),me.title.text(title.text||""),me.title.attr(title.attr),me.positionTitle(title)):me.title&&me.detach(me.title)},getAxisLine:function(){var domain=this.domain;return domain||(domain=this.group.select("path.domain")),domain.empty()?null:this.domain=domain},getTicksBBox:function(){var groupNode,temp,tempNode,ticks,bbox,group=this.group;return(ticks=group.selectAll(".tick")).size()&&(temp=group.append("g"),tempNode=temp.node(),groupNode=group.node(),ticks.each((function(){tempNode.appendChild(this)})),bbox=tempNode.getBBox(),ticks.each((function(){groupNode.appendChild(this)})),temp.remove()),bbox},positionTitle:function(cfg){var alignment,padding,textAnchor,isOutside,lineBBox,ticksBBox,me=this,title=me.title,axis=me.getAxis(),line=me.getAxisLine(),type=axis._type,isVertical="left"===type||"right"===type,Helpers=Ext.d3.Helpers,beforeEdge="text-before-edge",afterEdge="text-after-edge",x=0,y=0;if(line&&title&&Ext.d3.Helpers.isBBoxable(me.getParent())){switch(cfg=cfg||me.getTitle(),lineBBox=line.node().getBBox(),ticksBBox=me.getTicksBBox(),alignment=cfg.alignment||"middle",isOutside="outside"===(cfg.position||"outside"),padding=cfg.padding||"0.5em",alignment){case"start":case"left":textAnchor="start",isVertical?y=lineBBox.y+lineBBox.height:x=lineBBox.x;break;case"end":case"right":textAnchor="end",isVertical?y=lineBBox.y:x=lineBBox.x+lineBBox.width;break;case"middle":case"center":textAnchor="middle",isVertical?y=lineBBox.y+lineBBox.height/2:x=lineBBox.x+lineBBox.width/2}switch(type){case"top":isOutside&&(title.attr("y",ticksBBox?ticksBBox.y:0),padding=Helpers.unitMath(padding,"*",-1)),Helpers.setDominantBaseline(title.node(),isOutside?afterEdge:beforeEdge),title.attr("text-anchor",textAnchor).attr("x",x);break;case"bottom":isOutside?title.attr("y",ticksBBox?ticksBBox.y+ticksBBox.height:0):padding=Helpers.unitMath(padding,"*",-1),Helpers.setDominantBaseline(title.node(),isOutside?beforeEdge:afterEdge),title.attr("text-anchor",textAnchor).attr("x",x);break;case"left":isOutside&&(x=ticksBBox?ticksBBox.x:0,padding=Helpers.unitMath(padding,"*",-1)),Helpers.setDominantBaseline(title.node(),isOutside?afterEdge:beforeEdge),title.attr("text-anchor",textAnchor).attr("transform","translate("+x+", "+y+")rotate(-90)");break;case"right":isOutside?x=ticksBBox?ticksBBox.x+ticksBBox.width:0:padding=Helpers.unitMath(padding,"*",-1),Helpers.setDominantBaseline(title.node(),isOutside?beforeEdge:afterEdge),title.attr("text-anchor",textAnchor).attr("transform","translate("+x+", "+y+")rotate(-90)")}title.attr("dy",padding)}},render:function(transition){var me=this,axis=me.getAxis(),type=axis._type,scale=me.getScale();scale.domain().length&&scale.range().length&&(transition?me.group.transition(transition).call(axis):me.group.call(axis),me.group.attr("data-orient",type),me.positionTitle())},destroy:function(){this.mixins.detached.destroy.call(this)}}),Ext.define("Ext.d3.axis.Data",{extend:"Ext.d3.axis.Axis",config:{field:null,step:null},applyAxis:function(axis,oldAxis){var isRtl=this.getComponent().getInherited().rtl;return axis&&isRtl&&("left"===(axis=Ext.Object.chain(axis)).orient?axis.orient="right":"right"===axis.orient&&(axis.orient="left")),this.callParent([axis,oldAxis])}}),Ext.define("Ext.d3.axis.Color",{requires:["Ext.d3.Helpers"],mixins:{observable:"Ext.mixin.Observable"},isColorAxis:!0,config:{scale:{merge:function(value,baseValue){return value&&value.type&&baseValue&&baseValue.type===value.type&&(value=Ext.Object.merge(baseValue,value)),value},$value:{type:"linear",range:["white","maroon"]}},field:null,processor:null,minimum:null,maximum:null},constructor:function(config){this.mixins.observable.constructor.call(this,config)},applyScale:function(scale,oldScale){return scale&&(Ext.isFunction(scale)||(this.isUserSetDomain=!!scale.domain,scale=Ext.d3.Helpers.makeScale(scale))),scale||oldScale},updateScale:function(scale){this.scale=scale},updateField:function(field){this.field=field},updateProcessor:function(processor){this.processor=processor},getColor:function(value){var scale=this.scale,field=this.field,processor=this.processor;return processor?processor(this,scale,value,field):value&&value.data&&value.data.isModel&&field?scale(value.data.data[field]):scale(value)},updateMinimum:function(){this.setDomain()},updateMaximum:function(){this.setDomain()},findDataDomain:function(records){var domain,field=this.field,min=d3.min(records,(function(record){return record.data[field]})),max=d3.max(records,(function(record){return record.data[field]}));return field&&(domain=Ext.isNumber(min)&&Ext.isNumber(max)?[min,max]:records.map((function(record){return record.data[field]})).sort().filter((function(item,index,array){return!index||item!==array[index-1]}))),domain},setDomainFromData:function(models){this.isUserSetDomain||this.setDomain(this.findDataDomain(models))},setDomain:function(domain){var step,start,end,i,me=this,scale=me.getScale(),rangeLength=scale.range().length,minimum=me.getMinimum(),maximum=me.getMaximum();if(scale&&!me.isUserSetDomain){if(domain||(domain=scale.domain()),domain=domain.slice(),Ext.isNumber(minimum)&&(domain[0]=minimum),Ext.isNumber(maximum)&&(domain[domain.length-1]=maximum),scale.ticks&&domain.length!==rangeLength){for(start=domain[0],step=((end=domain[domain.length-1])-start)/(rangeLength-1),domain=[],i=0;i<rangeLength-1;i++)domain.push(start+i*step);domain.push(end)}scale.domain(domain),me.fireEvent("scalechange",me,scale)}}}),Ext.define("Ext.d3.legend.Legend",{mixins:{observable:"Ext.mixin.Observable",detached:"Ext.d3.mixin.Detached"},config:{docked:"bottom",padding:30,hidden:!1,component:null},defaultCls:{self:Ext.baseCSSPrefix+"d3-legend",item:Ext.baseCSSPrefix+"d3-legend-item",label:Ext.baseCSSPrefix+"d3-legend-label",hidden:Ext.baseCSSPrefix+"d3-hidden"},constructor:function(config){var me=this;me.mixins.detached.constructor.call(me,config),me.group=me.getDetached().append("g").classed(me.defaultCls.self,!0),me.mixins.observable.constructor.call(me,config)},getGroup:function(){return this.group},applyDocked:function(docked){return this.getComponent().getInherited().rtl&&("left"===docked?docked="right":"right"===docked&&(docked="left")),docked},getBox:function(){var me=this,hidden=me.getHidden(),docked=me.getDocked(),padding=me.getPadding(),bbox=me.group.node().getBBox(),box=me.box||(me.box={});if(hidden)return{x:0,y:0,width:0,height:0};switch(box.x=bbox.x,box.y=bbox.y,box.width=bbox.width,box.height=bbox.height,docked){case"right":box.x-=padding;case"left":box.width+=padding;break;case"bottom":box.y-=padding;case"top":box.height+=padding}return box},updateHidden:function(hidden){this[hidden?"hide":"show"]()},show:function(){var me=this;me.group.classed(me.defaultCls.hidden,!1),me.setHidden(!1),me.fireEvent("show",me)},hide:function(){var me=this;me.group.classed(me.defaultCls.hidden,!0),me.setHidden(!0),me.fireEvent("hide",me)},updateComponent:function(component,oldComponent){oldComponent&&this.detach(this.group),component&&this.attach(component.getScene(),this.group)},destroy:function(){this.mixins.detached.destroy.call(this)}}),Ext.define("Ext.d3.legend.Color",{extend:"Ext.d3.legend.Legend",requires:["Ext.d3.Helpers"],config:{axis:null,items:{count:5,slice:null,reverse:!1,size:{x:30,y:30}}},getScale:function(){return this.getAxis().getScale()},updateAxis:function(axis,oldAxis){oldAxis&&oldAxis.un("scalechange",this.onScaleChange,this),axis&&axis.on("scalechange",this.onScaleChange,this)},onScaleChange:function(axis,scale){this.renderItems()},updateItems:function(){this.isConfiguring||this.renderItems()},renderItems:function(){var ticks,updateSelection,me=this,scale=me.getScale(),items=me.getItems(),itemSelection=me.getRenderedItems();items.count>0&&scale.ticks?(ticks=scale.ticks(items.count),items.slice&&(ticks=ticks.slice.apply(ticks,items.slice)),items.reverse&&(ticks=ticks.reverse())):ticks=scale.domain(),ticks&&(updateSelection=itemSelection.data(ticks),me.onAddItems(updateSelection.enter()),me.onUpdateItems(updateSelection),me.onRemoveItems(updateSelection.exit()))},getRenderedItems:function(){return this.group.selectAll("."+this.defaultCls.item)},onAddItems:function(selection){(selection=selection.append("g").classed(this.defaultCls.item,!0)).append("rect"),selection.append("text"),this.onUpdateItems(selection)},onUpdateItems:function(selection){var blocks,labels,items=this.getItems(),docked=this.getDocked(),scale=this.getScale();switch(blocks=selection.select("rect").attr("width",items.size.x).attr("height",items.size.y).style("fill",scale),labels=selection.select("text").each((function(){Ext.d3.Helpers.setDominantBaseline(this,"middle")})).attr("text-anchor","middle").text(String),docked){case"left":case"right":blocks.attr("transform",(function(data,index){return"translate(0,"+index*items.size.y+")"})),labels.attr("x",items.size.x+10).attr("y",(function(data,index){return(index+.5)*items.size.y})).attr("dx",10);break;case"top":case"bottom":blocks.attr("transform",(function(data,index){return"translate("+index*items.size.x+",0)"})),labels.attr("x",(function(data,index){return(index+.5)*items.size.x})).attr("y",items.size.y).attr("dy","1em")}},onRemoveItems:function(selection){selection.remove()}}),Ext.define("Ext.d3.mixin.ToolTip",{extend:"Ext.Mixin",mixinConfig:{id:"d3tooltip",before:{destroy:"destroyTooltip"}},requires:["Ext.tip.ToolTip"],config:{tooltip:null},applyTooltip:function(tooltip,oldTooltip){return Ext.destroy(oldTooltip),tooltip&&(tooltip=new Ext.tip.ToolTip(Ext.merge({renderer:Ext.emptyFn,target:this.el,constrainPosition:!0,shrinkWrapDock:!0,autoHide:!0,trackMouse:!0,showOnTap:!0},tooltip))).on("hovertarget","onTargetHover",this),tooltip},onTargetHover:function(tooltip,element){element.dom&&Ext.callback(tooltip.renderer,tooltip.scope,[this,tooltip,element.dom.__data__,element],0,this)},destroyTooltip:function(){this.setTooltip(null)}}),Ext.define("Ext.d3.HeatMap",{extend:"Ext.d3.svg.Svg",xtype:"d3-heatmap",requires:["Ext.d3.axis.Data","Ext.d3.axis.Color","Ext.d3.legend.Color","Ext.d3.Helpers"],mixins:["Ext.d3.mixin.ToolTip"],config:{componentCls:"heatmap",xAxis:{axis:{orient:"bottom"},scale:{type:"linear"}},yAxis:{axis:{orient:"left"},scale:{type:"linear"}},colorAxis:{},legend:!1,tiles:null,labels:!0,transitions:{layout:{duration:500,ease:"cubicInOut",delay:10}}},data:null,tiles:null,tilesGroup:null,tilesRect:null,legendRect:null,defaultCls:{tiles:Ext.baseCSSPrefix+"d3-tiles",tile:Ext.baseCSSPrefix+"d3-tile"},constructor:function(config){this.callParent([config]),this.mixins.d3tooltip.constructor.call(this,config)},applyTooltip:function(tooltip,oldTooltip){return tooltip&&(tooltip.delegate="g."+this.defaultCls.tile),this.mixins.d3tooltip.applyTooltip.call(this,tooltip,oldTooltip)},updateTooltip:null,applyAxis:function(axis,oldAxis){return axis&&(axis=new Ext.d3.axis.Data(Ext.merge({parent:this.getScene(),component:this},axis))),axis||oldAxis},updateAxis:function(axis,oldAxis){this.isConfiguring||(this.processData(),this.renderScene())},applyXAxis:function(xAxis,oldXAxis){return this.applyAxis(xAxis,oldXAxis)},updateXAxis:function(){this.updateAxis()},applyYAxis:function(yAxis,oldYAxis){return this.applyAxis(yAxis,oldYAxis)},updateYAxis:function(){this.updateAxis()},applyLegend:function(legend,oldLegend){return legend&&(legend.axis=this.getColorAxis(),legend=new Ext.d3.legend.Color(Ext.merge({component:this},legend))),legend||oldLegend},updateLegend:function(legend,oldLegend){var events={show:"onLegendVisibility",hide:"onLegendVisibility",scope:this};oldLegend&&oldLegend.un(events),legend&&legend.on(events),this.isConfiguring||this.performLayout()},onLegendVisibility:function(){this.performLayout()},applyColorAxis:function(colorAxis,oldColorAxis){return colorAxis&&(colorAxis=new Ext.d3.axis.Color(colorAxis)),colorAxis||oldColorAxis},updateColorAxis:function(){this.isConfiguring||(this.processData(),this.renderScene())},getStoreData:function(store){return store?store.getData().items:[]},processData:function(store){var me=this,items=me.data=me.getStoreData(store||me.getStore()),xAxis=me.getXAxis(),yAxis=me.getYAxis(),colorAxis=me.getColorAxis(),xScale=xAxis.getScale(),yScale=yAxis.getScale(),xField=xAxis.getField(),yField=yAxis.getField(),xStep=xAxis.getStep(),yStep=yAxis.getStep();me.setDomainFromData(items,xField,xScale,xStep),me.setDomainFromData(items,yField,yScale,yStep),colorAxis.setDomainFromData(items)},setDomainFromData:function(items,field,scale,step){var domain,categories;scale.bandwidth?(categories=items.map((function(item){return item.data[field]})).filter((function(element,index,array){return array.indexOf(element)===index})),scale.domain(categories)):(domain=d3.extent(items,(function(item){return item.data[field]})),scale.domain([+domain[0],+domain[1]+step]))},isDataProcessed:!1,processDataChange:function(store){this.processData(store),this.isDataProcessed=!0,this.isConfiguring||this.performLayout()},onSceneResize:function(scene,rect){var me=this;me.callParent([scene,rect]),me.isDataProcessed||me.processData(),me.isOldSize=!1,me.performLayout(rect)},performLayout:function(rect){var me=this;if(rect=rect||me.getSceneRect()){me.showScene();var legendRect,legendBox,legendDocked,tilesRect,shrinkRect,xRange,legend=me.getLegend(),xAxis=me.getXAxis(),yAxis=me.getYAxis(),xAxisGroup=xAxis.getGroup(),yAxisGroup=yAxis.getGroup(),xD3Axis=xAxis.getAxis(),yD3Axis=yAxis.getAxis(),xScale=xAxis.getScale(),yScale=yAxis.getScale(),isRtl=me.getInherited().rtl;if(shrinkRect={x:0,y:0,width:rect.width,height:rect.height},me.tilesRect=tilesRect=Ext.Object.chain(shrinkRect),legend){switch(legendBox=legend.getBox(),legendDocked=legend.getDocked(),me.legendRect=legendRect=Ext.Object.chain(shrinkRect),legendDocked){case"right":tilesRect.width-=legendBox.width,legendRect.width=legendBox.width,legendRect.x=rect.width-legendBox.width;break;case"left":tilesRect.width-=legendBox.width,legendRect.width=legendBox.width,tilesRect.x+=legendBox.width;break;case"bottom":tilesRect.height-=legendBox.height,legendRect.height=legendBox.height,legendRect.y=rect.height-legendBox.height;break;case"top":tilesRect.height-=legendBox.height,legendRect.height=legendBox.height,tilesRect.y+=legendBox.height}Ext.d3.Helpers.alignRect("center","center",legendBox,legendRect,legend.getGroup())}xRange=[tilesRect.x,tilesRect.x+tilesRect.width],isRtl&&xRange.reverse(),xScale.range(xRange),yScale.range([tilesRect.y+tilesRect.height,tilesRect.y]),xAxisGroup.attr("transform","translate(0,"+("top"===xD3Axis._type?tilesRect.y:tilesRect.y+tilesRect.height)+")"),yAxisGroup.attr("transform","translate("+("left"===yD3Axis._type?tilesRect.x:tilesRect.x+tilesRect.width)+",0)"),me.renderScene()}},setupScene:function(scene){this.callParent([scene]),this.tilesGroup=scene.append("g").classed(this.defaultCls.tiles,!0),this.hideScene()},getRenderedTiles:function(){return this.tilesGroup.selectAll("."+this.defaultCls.tile)},renderScene:function(data){var tiles,enter,me=this,xAxis=me.getXAxis(),yAxis=me.getYAxis(),xField=xAxis.getField(),yField=yAxis.getField(),transitionName=me.hasFirstRender&&me.isOldSize?"layout":"none";data=data||me.data||me.getStoreData(me.getStore()),tiles=me.getRenderedTiles().data(data,(function(record){var x=record.data[xField],y=record.data[yField];return x instanceof Date&&(x=+x),y instanceof Date&&(y=+y),String(x)+"-"+String(y)})),me.layoutTransition=me.createTransition(transitionName).on("end",(function(){me.layoutTransition=null})),enter=me.onAddTiles(tiles.enter()),me.onUpdateTiles(tiles.merge(enter)),me.onRemoveTiles(tiles.exit()),xAxis.render(),yAxis.render(),me.hasFirstRender=!0,me.isOldSize=!0},onAddTiles:function(selection){var groups,rects,texts,name,tiles=this.getTiles(),labels=this.getLabels();if(selection.empty())return selection;if(rects=(groups=selection.append("g").classed(this.defaultCls.tile,!0)).append("rect").attr("fill","white"),tiles){for(name in tiles.attr)rects.attr(name,tiles.attr[name]);if(groups.classed(tiles.cls,!!tiles.cls),labels){for(name in texts=groups.append("text").attr("opacity",0),labels.attr)texts.attr(name,labels.attr[name]);texts.classed(labels.cls,!!labels.cls),Ext.d3.Helpers.noDominantBaseline()&&texts.each((function(){Ext.d3.Helpers.fakeDominantBaseline(this,"central",!0)}))}}return groups},onUpdateTiles:function(selection){var me=this,isRtl=me.getInherited().rtl,xAxis=me.getXAxis(),yAxis=me.getYAxis(),colorAxis=me.getColorAxis(),xScale=xAxis.getScale(),yScale=yAxis.getScale(),colorScale=colorAxis.getScale(),xStep=xAxis.getStep(),yStep=yAxis.getStep(),xBand=xScale.bandwidth?xScale.bandwidth():xScale(xStep)-xScale(0),yBand=yScale.bandwidth?yScale.bandwidth():yScale(yStep)-yScale(0),xField=xAxis.getField(),yField=yAxis.getField(),colorField=colorAxis.getField(),delay=me.hasFirstRender&&me.isOldSize&&me.getTransitions().layout.delay||0,delayFn=function(d,i){return i*delay},transition=me.layoutTransition;selection.select("rect").transition(transition).delay(delayFn).attr("x",(function(item){var x=xScale(item.data[xField]);return isRtl&&!xScale.bandwidth&&(x+=xBand),x+.5})).attr("y",(function(item){var y=yScale(item.data[yField]);return yScale.bandwidth||(y+=yBand),y+.5})).attrTween("width",(function(){var a=+this.getAttribute("width"),b=Math.abs(xBand);return function(t){return Math.max(a*(1-t)+b*t,0)}})).attrTween("height",(function(){var a=+this.getAttribute("height"),b=Math.abs(yBand);return function(t){return Math.max(a*(1-t)+b*t,0)}})).style("fill",(function(item){return colorScale(item.data[colorField])})),selection.select("text").text((function(item){return item.data[colorField]})).transition(transition).delay(delayFn).attr("opacity",1).attr("x",(function(item){return xScale(item.data[xField])+xBand/2})).attr("y",(function(item){return yScale(item.data[yField])+yBand/2})).on("end",(function(){this.removeAttribute("opacity")}))},onRemoveTiles:function(selection){selection.remove()},destroy:function(){var me=this,xAxis=me.getXAxis(),yAxis=me.getYAxis(),colorAxis=me.getColorAxis(),legend=me.getLegend();Ext.destroy(xAxis,yAxis,colorAxis,legend),me.callParent()}}),Ext.define("Ext.d3.canvas.HiDPI",{singleton:!0,relFontSizeRegEx:/(^[0-9])*(\d+(?:\.\d+)?)(px|%|em|pt)/,absFontSizeRegEx:/(xx-small)|(x-small)|(small)|(medium)|(large)|(x-large)|(xx-large)/,fillStroke:function(ctx,ratio,method){var scaledFont,font=ctx.font,fontChanged=font!==ctx.$oldFont,shadowOffsetX=ctx.shadowOffsetX,shadowOffsetY=ctx.shadowOffsetY,lineDashOffset=ctx.lineDashOffset,lineWidth=ctx.lineWidth;fontChanged?(scaledFont=(scaledFont=font.replace(this.relFontSizeRegEx,(function(match,p1,p2){return parseFloat(p2)*ratio}))).replace(this.absFontSizeRegEx,(function(match,p1,p2,p3,p4,p5,p6,p7){return p1?9*ratio+"px":p2?10*ratio+"px":p3?13*ratio+"px":p4?16*ratio+"px":p5?18*ratio+"px":p6?24*ratio+"px":p7?32*ratio+"px":void 0})),ctx.font=scaledFont,ctx.$oldFont=font,ctx.$scaledFont=scaledFont):ctx.font=ctx.$scaledFont,ctx.shadowOffsetX=shadowOffsetX*ratio,ctx.shadowOffsetY=shadowOffsetY*ratio,ctx.lineDashOffset=lineDashOffset*ratio,ctx.lineWidth=lineWidth*ratio,arguments.length>3?ctx[method].apply(ctx,Array.prototype.slice.call(arguments,3)):ctx[method](),ctx.font=font,ctx.shadowOffsetX=shadowOffsetX,ctx.shadowOffsetY=shadowOffsetY,ctx.lineDashOffset=lineDashOffset,ctx.lineWidth=lineWidth},getOverrides:function(){var me=this,ratio=me.getDevicePixelRatio();return this.overrides||(this.overrides={fill:function(){me.fillStroke(this,ratio,"$fill")},stroke:function(){me.fillStroke(this,ratio,"$stroke")},moveTo:function(x,y){this.$moveTo(x*ratio,y*ratio)},lineTo:function(x,y){this.$lineTo(x*ratio,y*ratio)},quadraticCurveTo:function(cpx,cpy,x,y){this.$quadraticCurveTo(cpx*ratio,cpy*ratio,x*ratio,y*ratio)},bezierCurveTo:function(cp1x,cp1y,cp2x,cp2y,x,y){this.$bezierCurveTo(cp1x*ratio,cp1y*ratio,cp2x*ratio,cp2y*ratio,x*ratio,y*ratio)},arcTo:function(x1,y1,x2,y2,radius){this.$arcTo(x1*ratio,y1*ratio,x2*ratio,y2*ratio,radius*ratio)},arc:function(x,y,radius,startAngle,endAngle,counterclockwise){this.$arc(x*ratio,y*ratio,radius*ratio,startAngle,endAngle,counterclockwise)},rect:function(x,y,width,height){this.$rect(x*ratio,y*ratio,width*ratio,height*ratio)},clearRect:function(x,y,width,height){this.$clearRect(x*ratio,y*ratio,width*ratio,height*ratio)},fillRect:function(x,y,width,height){me.fillStroke(this,ratio,"$fillRect",x*ratio,y*ratio,width*ratio,height*ratio)},strokeRect:function(x,y,width,height){me.fillStroke(this,ratio,"$strokeRect",x*ratio,y*ratio,width*ratio,height*ratio)},translate:function(x,y){this.$translate(x*ratio,y*ratio)},transform:function(xx,yx,xy,yy,dx,dy){this.$transform(xx,yx,xy,yy,dx*ratio,dy*ratio)},setTransform:function(xx,yx,xy,yy,dx,dy){this.$setTransform(xx,yx,xy,yy,dx*ratio,dy*ratio)},isPointInPath:function(path,x,y,fillRule){var n=arguments.length;return n>3?this.$isPointInPath(path,x*ratio,y*ratio,fillRule):n>2?this.$isPointInPath(path*ratio,x*ratio,y):this.$isPointInPath(path*ratio,x*ratio)},isPointInStroke:function(path,x,y){var n=arguments.length;return n>2?this.$isPointInStroke(path,x*ratio,y*ratio):this.$isPointInStroke(path*ratio,x*ratio)},drawImage:function(image,sx,sy,sWidth,sHeight,dx,dy,dWidth,dHeight){var n=arguments.length;n>5?this.$drawImage(image,sx,sy,sWidth,sHeight,dx*ratio,dy*ratio,dWidth*ratio,dHeight*ratio):n>3?this.$drawImage(image,sx*ratio,sy*ratio,sWidth*ratio,sHeight*ratio):this.$drawImage(image,sx*ratio,sy*ratio)},putImageData:function(imagedata,dx,dy,dirtyX,dirtyY,dirtyWidth,dirtyHeight){this.$putImageData(imagedata,dx*ratio,dy*ratio,dirtyX,dirtyY,dirtyWidth,dirtyHeight)},setLineDash:function(segments){segments instanceof Array||(segments=Array.prototype.slice.call(segments)),this.$setLineDash(segments.map((function(v){return v*ratio})))},fillText:function(text,x,y,maxWidth){this.$fillText(text,x*ratio,y*ratio,maxWidth*ratio)},strokeText:function(text,x,y,maxWidth){this.$strokeText(text,x*ratio,y*ratio,maxWidth*ratio)},measureText:function(text){var result=this.$measureText(text);return result.width*=ratio,result},createLinearGradient:function(x0,y0,x1,y1){return this.$createLinearGradient(x0*ratio,y0*ratio,x1*ratio,y1*ratio)},createRadialGradient:function(x0,y0,r0,x1,y1,r1){return this.$createRadialGradient(x0*ratio,y0*ratio,r0*ratio,x1*ratio,y1*ratio,r1*ratio)}})},getDevicePixelRatio:function(canvas){return canvas?canvas.$devicePixelRatio||1:window.devicePixelRatio||window.screen&&window.screen.deviceXDPI/window.screen.logicalXDPI||1},applyOverrides:function(canvas){var name,ctx=canvas.getContext("2d"),ratio=this.getDevicePixelRatio(),overrides=this.getOverrides();if(!canvas.$devicePixelRatio&&1!==ratio){for(name in overrides)ctx["$"+name]=ctx[name];Ext.apply(ctx,overrides),canvas.$devicePixelRatio=ratio}return canvas},setSize:function(canvas,width,height){var ratio=this.getDevicePixelRatio(canvas);return canvas.width=Math.round(width*ratio),canvas.height=Math.round(height*ratio),canvas.style.width=Math.round(width)+"px",canvas.style.height=Math.round(height)+"px",canvas}}),Ext.define("Ext.d3.canvas.Canvas",{extend:"Ext.d3.Component",xtype:"d3-canvas",isCanvas:!0,config:{hdpi:!0},requires:["Ext.d3.canvas.HiDPI"],template:[{tag:"canvas",reference:"canvasElement",style:{position:"absolute"}}],canvas:null,context2D:null,renderScene:null,getCanvas:function(){var me=this,canvas=me.canvas;return canvas||(canvas=me.canvasElement.dom,me.getHdpi()&&(canvas=Ext.d3.canvas.HiDPI.applyOverrides(canvas)),me.canvas=canvas,me.context2D=canvas.getContext("2d")),canvas},resizeHandler:function(size){var me=this,canvas=me.canvas||me.getCanvas(),rect=me.sceneRect||(me.sceneRect={});rect.x=0,rect.y=0,rect.width=size.width,rect.height=size.height,Ext.d3.canvas.HiDPI.setSize(canvas,rect.width,rect.height),me.onSceneResize(canvas,rect),me.fireEvent("sceneresize",me,canvas,rect)},onSceneResize:Ext.emptyFn,onPanZoom:function(interaction,scaling,translation){var canvas=this.canvas,ctx=this.context2D;ctx&&this.renderScene&&(ctx.save(),ctx.clearRect(0,0,canvas.width,canvas.height),ctx.setTransform(scaling[0],0,0,scaling[1],translation[0],translation[1]),this.renderScene(ctx),ctx.restore())},getSceneRect:function(){return this.sceneRect}}),Ext.define("Ext.d3.hierarchy.Hierarchy",{extend:"Ext.d3.svg.Svg",requires:["Ext.d3.axis.Color","Ext.plugin.MouseEnter"],mixins:["Ext.d3.mixin.ToolTip"],config:{hierarchyCls:"hierarchy",selection:null,colorAxis:{scale:{type:"ordinal",range:"d3.schemeCategory20c.slice(0, -4)"},field:"name"},nodeChildren:function(record){return record.isExpanded()?record.childNodes:null},nodeClass:void 0,nodeText:["name","text"],sorter:null,nodeTransform:function(selection){selection.attr("transform",(function(node){return"translate("+node.x+","+node.y+")"}))},nodeValue:1,noParentValue:!1,nodeKey:function(node,index){return node.data.id},linkKey:function(link,index){return link.target.data.id},selectEventName:"click",expandEventName:"dblclick",rootVisible:!0,layout:void 0,noSizeLayout:!0,renderLinks:!1,transitions:{layout:{duration:500,ease:"cubicInOut"},select:{duration:150,ease:"cubicInOut",sourceScale:1,targetScale:1.07}}},publishes:"selection",root:null,nodes:null,links:null,defaultCls:{links:Ext.baseCSSPrefix+"d3-links",nodes:Ext.baseCSSPrefix+"d3-nodes",link:Ext.baseCSSPrefix+"d3-link",node:Ext.baseCSSPrefix+"d3-node",root:Ext.baseCSSPrefix+"d3-root",label:Ext.baseCSSPrefix+"d3-label",parent:Ext.baseCSSPrefix+"d3-parent",leaf:Ext.baseCSSPrefix+"d3-leaf",selected:Ext.baseCSSPrefix+"d3-selected",expanded:Ext.baseCSSPrefix+"d3-expanded"},nodeClassCfg:null,mouseEnterPlugin:null,constructor:function(config){this.callParent([config]),this.mixins.d3tooltip.constructor.call(this,config)},applyTooltip:function(tooltip,oldTooltip){return tooltip&&(tooltip.delegate="g."+this.defaultCls.node),this.mixins.d3tooltip.applyTooltip.call(this,tooltip,oldTooltip)},updateTooltip:null,defaultNodeClass:function(selection){var name,me=this,cls=me.defaultCls,config=me.nodeClassCfg;for(name in config||(me.nodeClassCfg=config={},config[cls.parent]=function(node){return!node.data.isLeaf()},config[cls.leaf]=function(node){return node.data.isLeaf()},config[cls.expanded]=function(node){return node.data.isExpanded()},config[cls.root]=function(node){return node===me.root}),config)selection.classed(name,config[name])},applyColorAxis:function(colorAxis,oldColorAxis){return colorAxis&&!colorAxis.isColorAxis&&(colorAxis=new Ext.d3.axis.Color(colorAxis)),colorAxis||oldColorAxis},applyNodeText:function(nodeText){var fn;return"function"==typeof nodeText?fn=nodeText:"string"==typeof nodeText?fn=function(component,node){var data=node&&node.data&&node.data.data;return data&&data[nodeText]||""}:Array.isArray(nodeText)?fn=function(component,node){var text,i,data=node&&node.data&&node.data.data;if(data)for(i=0;i<nodeText.length&&!text;i++)text=data[nodeText[i]];return text||""}:Ext.raise("nodeText must be a string, array of strings, or a function that returns a string."),fn},applyNodeClass:function(nodeClass,oldNodeClass){var result;return(result=Ext.isFunction(nodeClass)?nodeClass:oldNodeClass||this.defaultNodeClass)&&(result=result.bind(this)),result},applyNodeTransform:function(nodeTransform){return nodeTransform&&(nodeTransform=nodeTransform.bind(this)),nodeTransform},updateHierarchyCls:function(hierarchyCls,oldHierarchyCls){var baseCls=this.baseCls,el=this.element;hierarchyCls&&Ext.isString(hierarchyCls)&&(el.addCls(hierarchyCls,baseCls),oldHierarchyCls&&el.removeCls(oldHierarchyCls,baseCls))},applyStore:function(store,oldStore){var result=store&&Ext.StoreManager.lookup(store,"tree");return result&&!result.isTreeStore&&Ext.raise("The store must be a Ext.data.TreeStore."),result},applyNodeValue:function(nodeValue){var fn,result,noParentValue=this.getNoParentValue(),nodeChildren=this.getNodeChildren();return"string"==typeof nodeValue?fn=function(record){return record.data[nodeValue]}:Ext.isNumber(nodeValue)?fn=function(){return nodeValue}:"function"==typeof nodeValue&&(fn=nodeValue),fn&&(result=noParentValue?function(record){return nodeChildren(record)?0:fn.call(this,record)}:fn.bind(this)),result},updateNodeValue:function(){this.isConfiguring||this.performLayout()},updateNodeChildren:function(){this.isConfiguring||this.performLayout()},updateSorter:function(sorter){this.isConfiguring||this.performLayout()},findNode:function(node,selection){return(selection=selection||this.getRenderedNodes()).filter((function(d){return node&&(d.data.id===node.data.id||d===node)}))},nodeFromRecord:function(record){var selection=record&&this.selectionFromRecord(record);return selection&&!selection.empty()?selection.datum():null},selectionFromRecord:function(record){return record&&record.isModel||Ext.raise("Passed parameter should be a model instance."),this.scene.select('[data-id="'+record.id+'"]')},isRecordInStore:function(record){var store=this.getStore();return!(!(record&&record.isModel&&store)||store.isEmptyStore||record.store!==store&&store.getNodeById(record.id)!==record&&store.getRoot()!==record)},applySelection:function(record){return record&&!record.isModel&&Ext.raise("The 'record' should be a Ext.data.TreeModel instance."),this.isRecordInStore(record)?record:null},updateSelection:function(record,oldRecord){var recordSelection,oldRecordSelection,hasElement,me=this;me.hasFirstRender?(record&&((hasElement=!(recordSelection=me.selectionFromRecord(record)).empty())?me.onNodeSelect(record,recordSelection):(me[me.self.getConfigurator().configs.selection.names.internal]=null,Ext.log.warn('Selected record "'+record.id+'" does not have an associated element. E.g.:\n- record was selected before it was rendered;\n- record was selected in some other view, but is not supposed to be rendered by this D3 component (see "nodeChildren" config).'))),oldRecord&&((oldRecordSelection=me.selectionFromRecord(oldRecord)).empty()||me.onNodeDeselect(oldRecord,oldRecordSelection)),hasElement&&me.fireEvent("selectionchange",me,record,oldRecord)):record&&me.on({scenerender:me.updateSelection.bind(me,record,oldRecord),single:!0})},onNodeSelect:function(record,selection){selection.classed(this.defaultCls.selected,!0),this.fireEvent("select",this,record,selection)},onNodeDeselect:function(record,selection){selection.classed(this.defaultCls.selected,!1),this.fireEvent("deselect",this,record,selection)},onNodesAdd:function(selection){selection.attr("class",this.defaultCls.node).each((function(node){this.setAttribute("data-id",node.data.id)}))},addNodeListeners:function(){var i,len,me=this,selectEventName=Ext.Array.from(me.getSelectEventName()),expandEventName=Ext.Array.from(me.getExpandEventName());for(i=0,len=selectEventName.length;i<len;i++)me.addNodeListener(selectEventName[i],me.onSelectEvent);for(i=0,len=expandEventName.length;i<len;i++)me.addNodeListener(expandEventName[i],me.onExpandEvent)},updateEventName:function(name,oldName,handler){var i,ln,names=Ext.Array.from(name),oldNames=Ext.Array.from(oldName);for(i=0,ln=oldNames.length;i<ln;i++)this.removeNodeListener(oldNames[i],handler);for(i=0,ln=names.length;i<ln;i++)this.addNodeListener(names[i],handler)},updateSelectEventName:function(name,oldName){this.updateEventName(name,oldName,this.onSelectEvent)},updateExpandEventName:function(name,oldName){this.updateEventName(name,oldName,this.onExpandEvent)},addNodeListener:function(eventName,handler){var me=this,targetEl=me.el;"mouseenter"===eventName?me.mouseEnterPlugin=me.addPlugin({type:"mouseenter",element:targetEl,delegate:"g."+me.defaultCls.node,handler:handler}):eventName&&targetEl.on(eventName,handler,me,{delegate:"g."+me.defaultCls.node})},removeNodeListener:function(eventName,handler){var targetEl=this.el;"mouseenter"===eventName?Ext.destroy(this.mouseEnterPlugin):eventName&&targetEl.un(eventName,handler,this,{delegate:"g."+this.defaultCls.node})},onSelectEvent:function(event,target){var selection=d3.select(target),element=selection.node(),node=selection.datum();this.handleSelectEvent(event,node,element)},handleSelectEvent:function(event,node,element){this.setSelection(node.data)},onExpandEvent:function(event){var selection=d3.select(event.currentTarget),element=selection.node(),node=selection.datum();this.handleExpandEvent(event,node,element)},handleExpandEvent:function(event,node,element){var record=node.data;record.isExpanded()?record.collapse():record.expand()},setLayoutSize:function(size){this.getLayout().size(size)},getLayoutSize:function(){var layout=this.getLayout();return layout.size&&layout.size()},onSceneResize:function(scene,rect){this.callParent([scene,rect]),this.setLayoutSize([rect.width,rect.height]),this.performLayout()},hasFirstLayout:!1,hasFirstRender:!1,isLayoutTransitionSkipped:!1,oldLayoutSaving:!1,oldNodes:null,oldLinks:null,isLayoutBlocked:Ext.emptyFn,skipLayoutTransition:function(){this.isLayoutTransitionSkipped=!0},processDataChange:function(store){(this.getNoSizeLayout()||this.size)&&this.performLayout()},setupScene:function(scene){var me=this;me.callParent([scene]),me.linksGroup=scene.append("g").classed(me.defaultCls.links,!0),me.nodesGroup=scene.append("g").classed(me.defaultCls.nodes,!0)},performLayout:function(){var root,nodes,links,layoutRoot,sorter,renderLinks,nodeChildren,nodeValue,me=this,store=me.getStore(),storeRoot=store&&store.getRoot(),rootVisible=me.getRootVisible(),layout=me.getLayout();me.getScene(),storeRoot||(me.getRenderedNodes().remove(),me.getRenderedLinks().remove()),!storeRoot||store.isLoading()||me.isInitializing||me.isLayoutBlocked(layout)||(layoutRoot=!rootVisible&&storeRoot.data.autoRoot&&1===storeRoot.childNodes.length?storeRoot.firstChild:storeRoot,sorter=me.getSorter(),renderLinks=me.getRenderLinks(),nodeChildren=me.getNodeChildren(),nodeValue=me.getNodeValue(),me.oldLayoutSaving&&me.saveLayout(me.nodes,me.links),root=d3.hierarchy(layoutRoot,nodeChildren).sum(nodeValue),sorter&&(root=root.sort(sorter)),me.storeRoot=storeRoot,me.root=root=layout(root),nodes=me.nodes=root.descendants(),renderLinks&&(links=me.links=root.links()),me.hasFirstLayout=!0,me.renderScene(nodes,links))},saveLayout:function(nodes,links){var i,ln,node,map={};if(this.oldNodes=map,nodes)for(i=0,ln=nodes.length;i<ln;i++)map[(node=nodes[i]).data.id]=node;this.oldLinks=links},getOldNode:function(node){return node&&this.oldNodes&&this.oldNodes[node.data.id]},renderScene:function(nodes,links){var nodeSelection,linkSelection,me=this,nodeKey=me.getNodeKey(),linkKey=me.getLinkKey();me.hasFirstLayout||me.performLayout(),nodes=nodes||me.nodes,links=links||me.links,me.onBeforeRender(nodes,links),nodes&&(nodeSelection=me.getRenderedNodes().data(nodes,nodeKey),me.renderNodes(nodeSelection),links&&(linkSelection=me.getRenderedLinks().data(links,linkKey),me.renderLinks(linkSelection))),me.hideRoot(),me.hasFirstRender=!0,me.onAfterRender(nodeSelection,linkSelection),me.fireEvent("scenerender",me,nodeSelection,linkSelection)},getRenderedNodes:function(){return this.nodesGroup.selectAll("."+this.defaultCls.node)},getRenderedLinks:function(){return this.linksGroup.selectAll("."+this.defaultCls.link)},hideRoot:function(){var rootVisible=this.getRootVisible();this.nodesGroup.select("."+this.defaultCls.root).classed(this.defaultCls.invisible,!rootVisible)},renderLinks:function(update){this.updateLinks(update,this.addLinks(update.enter())),this.removeLinks(update.exit())},renderNodes:function(update){var me=this,nodeClass=me.getNodeClass(),enter=update.enter().append("g");enter.call(me.onNodesAdd.bind(me)),me.addNodes(enter),enter.call(nodeClass),update.call(nodeClass),me.updateNodes(update,enter),me.removeNodes(update.exit())},layoutTransition:null,onBeforeRender:function(){var me=this,useTransition=me.hasFirstRender&&!me.isLayoutTransitionSkipped,transition=me.createTransition(useTransition?"layout":"none");me.isLayoutTransitionSkipped=!1,me.layoutTransition=transition.on("end",(function(){me.layoutTransition=null,me.destroyed||me.destroying||me.onLayout()}))},onLayout:function(){this.panZoom&&this.panZoom.updateIndicator(),this.fireEvent("layout",this)},onAfterRender:Ext.emptyFn,updateLinks:Ext.emptyFn,addLinks:Ext.emptyFn,updateNodes:Ext.emptyFn,addNodes:Ext.emptyFn,removeLinks:function(selection){selection.remove()},removeNodes:function(selection){selection.remove()}}),Ext.define("Ext.d3.hierarchy.Pack",{extend:"Ext.d3.hierarchy.Hierarchy",xtype:"d3-pack",requires:["Ext.d3.Helpers"],config:{componentCls:"pack",textPadding:[3,3],nodeValue:function(record){return record.childNodes.length+1},clipText:!0,noSizeLayout:!1},applyLayout:function(){return d3.pack()},onNodeSelect:function(node,el){this.callParent(arguments),el.select("circle").style("fill",null)},onNodeDeselect:function(node,el){var me=this,colorAxis=me.getColorAxis();me.callParent(arguments),el.select("circle").style("fill",(function(node){return colorAxis.getColor(node)}))},updateColorAxis:function(colorAxis){this.isConfiguring||this.getRenderedNodes().select("circle").style("fill",(function(node){return colorAxis.getColor(node)}))},textVisibilityFn:function(selection){var textPadding=this.getTextPadding(),dx=2*parseFloat(textPadding[0]),dy=2*parseFloat(textPadding[1]);selection.classed(this.defaultCls.invisible,(function(node){var bbox=this.getBBox(),width=node.r-dx,height=node.r-dy;return bbox.width>width||bbox.height>height}))},addNodes:function(selection){var labels,me=this,nodeTransform=me.getNodeTransform(),clipText=me.getClipText();selection.call(me.onNodesAdd.bind(me)).call(nodeTransform).append("circle"),labels=selection.append("text").attr("class",me.defaultCls.label),clipText&&labels.call(me.textVisibilityFn.bind(me)),Ext.d3.Helpers.noDominantBaseline()&&labels.each((function(){Ext.d3.Helpers.fakeDominantBaseline(this,"central",!0)})),labels.attr("opacity",0)},updateNodes:function(update,enter){var text,me=this,colorAxis=me.getColorAxis(),nodeTransform=me.getNodeTransform(),selectionCfg=me.getSelection(),nodeText=me.getNodeText(),clipText=me.getClipText(),selection=update.merge(enter),transition=me.layoutTransition;selection.transition(transition).call(nodeTransform),selection.select("circle").transition(transition).attr("r",(function(node){return node.r})).style("fill",(function(node){return node.data===selectionCfg?null:colorAxis.getColor(node)})),text=selection.select("text").text((function(node){return nodeText(me,node)})),clipText&&text.call(me.textVisibilityFn.bind(me)),text.transition(transition).attr("opacity",1)},removeNodes:function(selection){selection.attr("opacity",1).transition(this.layoutTransition).attr("opacity",0).remove()}}),Ext.define("Ext.d3.hierarchy.TreeMap",{extend:"Ext.d3.hierarchy.Hierarchy",xtype:"d3-treemap",requires:["Ext.d3.Helpers"],config:{componentCls:"treemap",tiling:null,parentTile:{padding:4,label:{offset:[5,2],clipSize:[110,40]}},leafTile:{padding:0},nodeTransform:function(selection){selection.attr("transform",(function(node){return"translate("+node.x0+","+node.y0+")"}))},busyLayoutText:"Layout in progress...",noParentValue:!0,noSizeLayout:!1,scaleLabels:!1},labelQuantizer:null,constructor:function(config){this.labelQuantizer=this.createLabelQuantizer(),this.callParent([config])},createLabelQuantizer:function(){return d3.scaleQuantize().domain([8,27]).range(["8px","12px","18px","27px"])},labelSizer:function(node,element){return Math.min((node.x1-node.x0)/4,(node.y1-node.y0)/2)},applyTiling:function(tiling,oldTiling){return Ext.d3.Helpers.eval(tiling||oldTiling)},updateTiling:function(tiling){tiling&&(this.getLayout().tile(tiling),this.isConfiguring||this.performLayout())},updateLeafTile:function(leafTile){leafTile&&this.getLayout().paddingInner(leafTile.padding||0),this.isConfiguring||this.performLayout()},applyParentTile:function(parentTile){var padding,me=this;return parentTile&&(padding=parentTile.padding,Ext.isNumber(padding)&&(parentTile.padding=function(node){return me.getRootVisible()||node!==me.root?padding:0})),parentTile},updateParentTile:function(parentTile){var layout,padding;parentTile&&(layout=this.getLayout(),padding=parentTile.padding,layout.paddingRight(padding),layout.paddingBottom(padding),layout.paddingLeft(padding)),this.isConfiguring||this.performLayout()},applyLayout:function(){return d3.treemap().round(!0)},setLayoutSize:function(size){this.callParent([size])},deferredLayoutId:null,isLayoutBlocked:function(layout){var me=this,maskText=me.getBusyLayoutText(),blocked=!1;return me.deferredLayoutId?(clearTimeout(me.deferredLayoutId),me.deferredLayoutId=null):(me.showMask(maskText),me.deferredLayoutId=setTimeout(me.performLayout.bind(me),100),blocked=!0),blocked},setupScene:function(scene){this.callParent([scene]),this.getScaleLabels()},onAfterRender:function(){this.hideMask()},hiddenParentLabels:null,labelSizes:null,getContentRect:function(){var sceneRect=this.getSceneRect(),contentRect=this.contentRect||(this.contentRect={x:0,y:0});return sceneRect&&(contentRect.width=sceneRect.width,contentRect.height=sceneRect.height),sceneRect&&contentRect},onNodeSelect:function(node,el){this.callParent(arguments),el.select("rect").style("fill",null)},onNodeDeselect:function(node,el){var me=this,colorAxis=me.getColorAxis();me.callParent(arguments),el.select("rect").style("fill",(function(node){return colorAxis.getColor(node)}))},renderNodes:function(nodeElements){var nodes,me=this,root=me.root,layout=me.getLayout(),parentLabel=me.getParentTile().label,nodeTransform=me.getNodeTransform(),hiddenParentLabels=me.hiddenParentLabels={},labelSizes=me.labelSizes={};me.callParent([nodeElements]),layout.paddingTop((function(node){var padding,dx,dy,id=node.data.data.id,size=labelSizes[id],clipSize=parentLabel.clipSize;return me.getRootVisible()||node!==me.root?(padding=2*parentLabel.offset[1],dx=node.x1-node.x0,dy=node.y1-node.y0,size.width<dx&&size.height<dy&&dx>clipSize[0]&&dy>clipSize[1]?(padding+=size.height,hiddenParentLabels[id]=!1):hiddenParentLabels[id]=!0):(padding=0,hiddenParentLabels[id]=!0),padding})),me.root=root=layout(root),nodes=me.nodes=root.descendants(),layout.paddingTop(0),(nodeElements=me.getRenderedNodes().data(nodes,me.getNodeKey())).transition(me.layoutTransition).call(nodeTransform),nodeElements.select("rect").call(me.nodeSizeFn.bind(me)),nodeElements.select("text").call(me.textVisibilityFn.bind(me)).each((function(node){node.data.isLeaf()?(this.setAttribute("x",(node.x1-node.x0)/2),this.setAttribute("y",(node.y1-node.y0)/2)):(this.setAttribute("x",parentLabel.offset[0]),this.setAttribute("y",parentLabel.offset[1]))}))},addNodes:function(selection){var me=this,labelSizes=me.labelSizes,colorAxis=me.getColorAxis(),nodeText=me.getNodeText(),scaleLabels=me.getScaleLabels(),cls=me.defaultCls;selection.append("rect").style("fill",(function(node){return colorAxis.getColor(node)})),selection.append("text").style("font-size",(function(node){return scaleLabels?me.getLabelSize(node,this):null})).each((function(node){var text=nodeText(me,node);this.textContent=null==text?"":text,this.setAttribute("class",cls.label),Ext.d3.Helpers.fakeDominantBaseline(this,node.data.isLeaf()?"central":"text-before-edge"),labelSizes[node.data.id]=this.getBBox()}))},updateNodes:function(selection){var me=this,nodeText=me.getNodeText(),scaleLabels=me.getScaleLabels(),labelSizes=me.labelSizes;selection.select("rect").call(me.nodeSizeFn.bind(me)),selection.select("text").style("font-size",(function(node){return scaleLabels?me.getLabelSize(node,this):null})).each((function(node){var text=nodeText(me,node);this.textContent=null==text?"":text,labelSizes[node.data.id]=this.getBBox()}))},getLabelSize:function(node,element){return node.data.isLeaf()?this.labelQuantizer(this.labelSizer(node,element)):null},updateScaleLabels:function(){this.isConfiguring||this.performLayout()},updateNodeValue:function(nodeValue){this.callParent(arguments),this.isConfiguring||this.performLayout()},nodeSizeFn:function(selection){selection.attr("width",(function(node){return Math.max(0,node.x1-node.x0)})).attr("height",(function(node){return Math.max(0,node.y1-node.y0)}))},isLabelVisible:function(element,node){var bbox=element.getBBox(),width=node.x1-node.x0,height=node.y1-node.y0,isLeaf=node.data.isLeaf(),parentTile=this.getParentTile(),hiddenParentLabels=this.hiddenParentLabels,parentLabelOffset=parentTile.label.offset;return isLeaf?(width-=2,height-=2):(width-=2*parentLabelOffset[0],height-=2*parentLabelOffset[1]),isLeaf||!node.data.isExpanded()?bbox.width<width&&bbox.height<height:!hiddenParentLabels[node.data.id]},textVisibilityFn:function(selection){var me=this;selection.classed(me.defaultCls.invisible,(function(node){return!me.isLabelVisible(this,node)}))},destroy:function(){var colorAxis=this.getColorAxis();this.deferredLayoutId&&clearTimeout(this.deferredLayoutId),colorAxis.destroy(),this.callParent()}}),Ext.define("Ext.d3.hierarchy.partition.Partition",{extend:"Ext.d3.hierarchy.Hierarchy",xtype:"d3-partition",config:{partitionCls:"partition",nodeValue:function(record){return record.isExpanded()&&record.childNodes?0:1}},updatePartitionCls:function(partitionCls,oldPartitionCls){var baseCls=this.baseCls,el=this.element;partitionCls&&Ext.isString(partitionCls)&&(el.addCls(partitionCls,baseCls),oldPartitionCls&&el.removeCls(oldPartitionCls,baseCls))},applyLayout:function(){return d3.partition()},resetZoom:function(instantly){var store=this.getStore(),root=store&&store.getRoot();this.zoomInNode(root,instantly)}}),Ext.define("Ext.d3.hierarchy.partition.Sunburst",{extend:"Ext.d3.hierarchy.partition.Partition",xtype:"d3-sunburst",config:{componentCls:"sunburst",textPadding:[5,"0.35em"],zoomParentDotRadius:30,transitions:{zoom:{duration:1e3,ease:"cubicInOut"}}},setupScene:function(scene){this.callParent([scene]),this.setupScales(),this.setupArcGenerator()},scaleDefaults:{x:{domain:[0,1],range:[0,2*Math.PI]},y:{domain:[0,1]}},setupScales:function(){var defaults=this.scaleDefaults;this.xScale=d3.scaleLinear().domain(defaults.x.domain.slice()).range(defaults.x.range.slice()),this.yScale=d3.scaleSqrt().domain(defaults.y.domain.slice())},arc:null,defaultCls:{center:Ext.baseCSSPrefix+"d3-center"},setupArcGenerator:function(){var x=this.xScale,y=this.yScale;this.arc=d3.arc().startAngle((function(node){return Math.max(0,Math.min(2*Math.PI,x(node.x0)))})).endAngle((function(node){return Math.max(0,Math.min(2*Math.PI,x(node.x1)))})).innerRadius((function(node){return Math.max(0,y(node.y0))})).outerRadius((function(node){return Math.max(0,y(node.y1))}))},onSceneResize:function(scene,rect){var nodesGroup=this.nodesGroup,centerX=.5*rect.width,centerY=.5*rect.height,radius=Math.min(centerX,centerY);nodesGroup.attr("transform","translate("+centerX+","+centerY+")"),this.setRadius(radius)},radius:null,minRadius:1,setRadius:function(radius){radius=Math.max(this.minRadius,radius),this.radius=radius,this.yScale.range([0,radius]),this.renderScene()},zoomInNode:function(record,instantly){var node,nodes,me=this,scene=me.getScene(),parentRadius=me.getZoomParentDotRadius(),radius=me.radius,xScale=me.xScale,yScale=me.yScale,arc=me.arc;me.hasFirstLayout&&me.hasFirstRender&&me.size&&record&&record.isNode&&(node=me.nodeFromRecord(record)),node&&((nodes=me.createTransition(instantly?"none":"zoom",scene).tween("scale",(function(){var xDomain=d3.interpolate(xScale.domain(),[node.x0,node.x1]),yDomain=d3.interpolate(yScale.domain(),[node.y0,1]),yRange=d3.interpolate(yScale.range(),[node.y0?parentRadius:0,radius]);return function(t){xScale.domain(xDomain(t)),yScale.domain(yDomain(t)).range(yRange(t))}})).selectAll("."+me.defaultCls.node)).selectAll("path").attrTween("d",(function(node){return function(t){return arc(node)}})),nodes.selectAll("text").call(me.positionTextFn.bind(me)).call(me.textVisibilityFn.bind(me)),instantly&&(me.xScale.domain([node.x0,node.x1]),me.yScale.domain([node.y0,1]).range([node.y0?parentRadius:0,radius])))},onNodeSelect:function(node,el){var me=this,transitionCfg=me.getTransitions().select,to=transitionCfg.targetScale,from=transitionCfg.sourceScale,transition=me.createTransition("select");me.callParent(arguments),el.raise().select("path").style("fill",null),transition.duration()&&el.transition(transition).attr("transform","scale("+to+","+to+")").transition(transition).attr("transform","scale("+from+","+from+")")},onNodeDeselect:function(node,el){var me=this,colorAxis=me.getColorAxis();me.callParent(arguments),el.select("path").style("fill",(function(node){return colorAxis.getColor(node)}))},isBBoxInSlice:function(bbox,a1,a2,r1,r2,px,py){var a=Math.abs(a2-a1),width=Math.abs(r2-r1)-2*px,height=a<Math.PI?2*(r1+px)*Math.tan(.5*a)-2*py:.5*r2,isWider=bbox.width>width,isTaller=bbox.height>height;return!(isWider||isTaller)},textVisibilityFn:function(selection){var me=this,x=me.xScale,y=me.yScale,invisibleCls=me.defaultCls.invisible,textPadding=me.getTextPadding(),px=parseFloat(textPadding[0]),py=parseFloat(textPadding[1]);function isInvisible(el,node){me.isDestroyed&&Ext.log.warn("Component is destroyed, shouldn't have executed this.");var bbox=el._bbox||el.getBBox(),a1=x(node.x0),a2=x(node.x1),r1=y(node.y0),r2=y(node.y1),isBBoxInSlice=me.isBBoxInSlice(bbox,a1,a2,r1,r2,px,py),xDomain=x.domain(),yDomain=y.domain(),isOutOfX=xDomain[0]>node.x0||xDomain[1]<node.x1,isOutOfY=yDomain[0]>node.y0||yDomain[1]<node.y1;return!isBBoxInSlice||isOutOfX||isOutOfY}selection instanceof d3.transition?selection.tween("class.invisible",(function(node){var el=this;return function(){d3.select(el).classed(invisibleCls,isInvisible(el,node))}})):selection.classed(invisibleCls,(function(node){return isInvisible(this,node)}))},positionTextFn:function(selection){var xFn,transformFn,me=this,x=me.xScale,y=me.yScale,halfPi=Math.PI/2,degreesPerRadian=180/Math.PI,isTween=selection instanceof d3.transition,method=isTween?"attrTween":"attr";function getX(node){return y(node.y0)}function getTransform(node){return node===me.root?"":"rotate("+(x((node.x0+node.x1)/2)-halfPi)*degreesPerRadian+")"}isTween?(xFn=function(node){return function(){return getX(node)}},transformFn=function(node){return function(){return getTransform(node)}}):(xFn=function(node){return getX(node)},transformFn=function(node){return getTransform(node)}),selection[method]("x",xFn)[method]("transform",transformFn)},addNodes:function(selection){var me=this,textPadding=me.getTextPadding();selection.append("path").attr("d",me.arc),selection.append("text").attr("class",me.defaultCls.label).each((function(node){node!==me.root&&(this.setAttribute("dx",textPadding[0]),this.setAttribute("dy",textPadding[1]))}))},measureLabels:function(selection){selection instanceof d3.transition||selection.each((function(){this._bbox=this.getBBox()}))},updateNodes:function(update,enter){var me=this,colorAxis=me.getColorAxis(),nodeText=me.getNodeText(),selectionCfg=me.getSelection(),selection=update.merge(enter);selection.select("path").attr("d",me.arc).style("fill",(function(node){return node.data===selectionCfg?null:colorAxis.getColor(node)})),selection.select("text").text((function(node){return nodeText(me,node)})).call(me.measureLabels.bind(me)).call(me.positionTextFn.bind(me)).call(me.textVisibilityFn.bind(me)),me.nodesGroup.select("."+me.defaultCls.selected).raise()},updateColorAxis:function(colorAxis){this.isConfiguring||this.getRenderedNodes().select("path").style("fill",(function(node){return colorAxis.getColor(node)}))}}),Ext.define("Ext.d3.hierarchy.tree.Tree",{extend:"Ext.d3.hierarchy.Hierarchy",config:{treeCls:"tree",nodeTransform:null,depth:0,nodeRadius:5,nodeTransition:!0,nodeSize:null,noSizeLayout:!1,renderLinks:!0,transitions:{select:{targetScale:1.5}}},updateTreeCls:function(treeCls,oldTreeCls){var baseCls=this.baseCls,el=this.element;treeCls&&Ext.isString(treeCls)&&(el.addCls(treeCls,baseCls),oldTreeCls&&el.removeCls(oldTreeCls,baseCls))},applyLayout:function(){return d3.tree()},updateNodeSize:function(nodeSize){this.getLayout().nodeSize(nodeSize)},updateColorAxis:function(colorAxis){this.isConfiguring||this.getRenderedNodes().select("circle").style("fill",(function(node){return colorAxis.getColor(node)}))},hideRoot:function(){var rootVisible=this.getRootVisible();this.nodesGroup.select("."+this.defaultCls.root).classed(this.defaultCls.hidden,!rootVisible)},onNodeSelect:function(node,el){var me=this,transitionCfg=me.getTransitions().select,to=transitionCfg.targetScale,from=transitionCfg.sourceScale,transition=me.createTransition("select"),circle=el.select("circle");me.callParent(arguments),circle.style("fill",null),transition.duration()&&circle.transition(transition).attr("transform","scale("+to+","+to+")").transition(transition).attr("transform","scale("+from+","+from+")")},onNodeDeselect:function(node,el){var me=this,colorAxis=me.getColorAxis();me.callParent(arguments),el.select("circle").style("fill",(function(node){return colorAxis.getColor(node)}))}}),Ext.define("Ext.d3.hierarchy.tree.HorizontalTree",{extend:"Ext.d3.hierarchy.tree.Tree",xtype:["d3-tree","d3-horizontal-tree"],requires:["Ext.d3.Helpers"],config:{componentCls:"horizontal-tree",nodeTransform:function(selection){selection.attr("transform",(function(node){return"translate("+node.y+","+node.x+")"}))}},pendingTreeAlign:!1,oldLayoutSaving:!0,alignAfterLayout:function(){this.pendingTreeAlign=!0},onSceneResize:function(scene,rect){var me=this,layout=me.getLayout();me.alignAfterLayout(),layout.nodeSize()?me.size?this.alignTree():me.performLayout():me.callParent(arguments)},onLayout:function(){this.pendingTreeAlign&&(this.pendingTreeAlign=!1,this.alignTree()),this.callParent()},alignTree:function(){this.getNodeSize()&&this.alignContent("l")},updateNodeSize:function(nodeSize){var me=this;nodeSize?me.getLayout().nodeSize(nodeSize.slice().reverse()):(me.setLayoutSize([me.sceneRect.width,me.sceneRect.height]),me.panZoom&&Ext.log.warn("With no `nodeSize` set, the `panzoom` interaction is likely redundant. You can remove it with `component.panZoom.destroy()`. This will also remove any translation/scaling currently applied to the scene.")),me.isConfiguring||(me.skipLayoutTransition(),me.alignAfterLayout(),me.performLayout())},setLayoutSize:function(size){var _=size[0];size[0]=size[1],size[1]=_,this.callParent([size])},onNodesAdd:function(selection){var node;this.callParent([selection]),(node=this.getOldNode(this.nodeFromRecord(this.getSelection())))&&selection.attr("transform","translate("+node.y+","+node.x+")")},addNodes:function(selection){var labels,nodeRadius=this.getNodeRadius();selection.append("circle").attr("opacity",0),labels=selection.append("text").attr("class",this.defaultCls.label).each((function(node){var isLeaf=node.data.isLeaf();this.setAttribute("x",isLeaf?nodeRadius+5:-5-nodeRadius)})).attr("opacity",0),Ext.d3.Helpers.noDominantBaseline()&&labels.each((function(){Ext.d3.Helpers.fakeDominantBaseline(this,"central",!0)}))},updateNodes:function(update,enter){var me=this,selectionCfg=me.getSelection(),nodeTransform=me.getNodeTransform(),colorAxis=me.getColorAxis(),nodeRadius=me.getNodeRadius(),nodeText=me.getNodeText(),selection=update.merge(enter),transition=me.layoutTransition;selection.transition(transition).call(nodeTransform),selection.select("circle").style("fill",(function(node){return node.data===selectionCfg?null:colorAxis.getColor(node)})).attr("r",nodeRadius).transition(transition).attr("opacity",1),selection.select("text").text((function(node){return nodeText(me,node)})).transition(transition).attr("opacity",1)},removeNodes:function(selection){var me=this,selectedNode=me.nodeFromRecord(me.getSelection());selection.attr("opacity",1).transition(me.layoutTransition).attr("opacity",0).attr("transform",(function(node){var p=node.parent,d=selectedNode||p&&me.nodeFromRecord(p.data),x=d&&d.x||0;return"translate("+(d&&d.y||0)+","+x+")"})).remove()},getLinkPath:function(link){var midY=link.source.y+(link.target.y-link.source.y)/2;return"M"+link.source.y+","+link.source.x+"C"+midY+","+link.source.x+" "+midY+","+link.target.x+" "+link.target.y+","+link.target.x},addLinks:function(selection){var me=this,selectedNode=me.nodeFromRecord(me.getSelection());return selection.append("path").classed(me.defaultCls.link,!0).attr("d",(function(link){var source=selectedNode||link.source,xy=me.getOldNode(source),x=xy?xy.x:source.x,y=xy?xy.y:source.y;return"M"+y+","+x+"C"+y+","+x+" "+y+","+x+" "+y+","+x})).attr("opacity",0)},updateLinks:function(update,enter){var me=this,selection=update.merge(enter),transition=me.layoutTransition,isRootHidden=!me.getRootVisible();selection.classed(me.defaultCls.hidden,(function(link){return isRootHidden&&link.source.data===me.storeRoot})).transition(transition).attr("d",me.getLinkPath).attr("opacity",1)},removeLinks:function(selection){var me=this,selectedNode=me.nodeFromRecord(me.getSelection());selection.attr("opacity",1).transition(me.layoutTransition).attr("opacity",0).attr("d",(function(link){var s=link.source,node=selectedNode||s&&me.nodeFromRecord(s.data),x=node&&node.x||0,y=node&&node.y||0;return"M"+y+","+x+"C"+y+","+x+" "+y+","+x+" "+y+","+x})).remove()}}),Ext.define("Ext.d3.interaction.Abstract",{isInteraction:!0,mixins:{observable:"Ext.mixin.Observable"},statics:{lockedEvents:{}},config:{component:null,gestures:null,enabled:!0},supports:[],listeners:null,constructor:function(config){var id,me=this;id="id"in(config=config||{})?config.id:"id"in me.config?me.config.id:me.getId(),me.setId(id),me.mixins.observable.constructor.call(me,config)},resetComponent:function(){var me=this,component=me.getComponent();me.isConfiguring||(me.setComponent(null),me.setGestures(null),me.setComponent(component))},updateComponent:function(component,oldComponent){oldComponent!==component&&(oldComponent&&this.removeComponent(oldComponent),component&&this.addComponent(component))},addComponent:function(component){component.register(this),this.component=component,this.addElementListener(component.element)},removeComponent:function(component){this.removeElementListener(component.element),this.component=null,component.unregister(this)},updateEnabled:function(enabled){var component=this.getComponent();component&&(enabled?this.addElementListener(component.element):this.removeElementListener(component.element))},onGesture:Ext.emptyFn,addElementListener:function(element){var name,me=this,gestures=me.getGestures(),locks=me.getLocks();if(me.getEnabled())for(name in me.listeners=me.listeners||{},gestures)addGesture(name,gestures[name]);function addGesture(name,fn){Ext.isFunction(fn)||(fn=me[fn]),element.on(name,me.listeners[name]=function(e){var result;if(me.getEnabled()&&(!(name in locks)||locks[name]===me))return!1===(result=fn.apply(this,arguments))&&e&&e.stopPropagation&&e.stopPropagation(),result},me)}},removeElementListener:function(element){var name,me=this,gestures=me.getGestures();function removeGesture(name){var fn=me.listeners[name];fn&&(element.un(name,fn),delete me.listeners[name])}if(me.listeners)for(name in gestures)removeGesture(name)},lockEvents:function(){for(var me=this,locks=me.getLocks(),args=Array.prototype.slice.call(arguments),i=args.length;i--;)locks[args[i]]=me},unlockEvents:function(){for(var locks=this.getLocks(),args=Array.prototype.slice.call(arguments),i=args.length;i--;)delete locks[args[i]]},getLocks:function(){return this.statics().lockedEvents},destroy:function(){this.fireEvent("destroy",this),this.setComponent(null),this.listeners=null}}),Ext.define("Ext.d3.interaction.PanZoom",{extend:"Ext.d3.interaction.Abstract",type:"panzoom",alias:"d3.interaction.panzoom",isPanZoom:!0,config:{pan:{gesture:"drag",constrain:!0,momentum:{friction:1,spring:.2}},zoom:{gesture:"pinch",extent:[1,3],uniform:!0,mouseWheel:{factor:1.02},doubleTap:{factor:1.1}},contentRect:null,viewportRect:null,indicator:{parent:"element"}},panOrigin:null,startSpread:null,minSpread:50,scaling:null,oldScaling:null,oldScalingCenter:null,translation:null,oldTranslation:null,dx:0,dy:0,velocityX:0,velocityY:0,pan:null,viewportRect:null,contentRect:null,updatePan:function(pan){this.pan=pan,this.resetComponent()},updateZoom:function(){this.resetComponent()},updateContentRect:function(contentRect){this.contentRect=contentRect,this.constrainTranslation()},updateViewportRect:function(viewportRect){this.viewportRect=viewportRect,this.constrainTranslation()},constructor:function(config){var me=this;me.translation=config&&config.translation?config.translation.slice():[0,0],me.scaling=config&&config.scaling?config.scaling.slice():[1,1],me.callParent(arguments)},destroy:function(){this.destroyIndicator(),Ext.AnimationQueue.stop(this.panFxFrame,this),this.callParent()},toViewportXY:function(pageX,pageY){var elementXY=this.component.element.getXY(),viewportRect=this.viewportRect&&this.viewportRect();return[pageX-elementXY[0]-(viewportRect?viewportRect.x:0),pageY-elementXY[1]-(viewportRect?viewportRect.y:0)]},toRtlViewportXY:function(pageX,pageY){var xy=this.toViewportXY(pageX,pageY),component=this.component;return component.getInherited().rtl&&(xy[0]=component.getWidth()-xy[0]),xy},constrainRange:function(range,x,y){return y=y||x,range[0]=Math.max(x[0],Math.min(x[1],range[0])),range[1]=Math.max(y[0],Math.min(y[1],range[1])),range},constrainTranslation:function(translation){var constraints,offLimits,me=this,pan=me.pan,constrain=pan&&pan.constrain,momentum=pan&&pan.momentum,contentRect=constrain&&me.contentRect&&me.contentRect(),viewportRect=constrain&&me.viewportRect&&me.viewportRect();contentRect&&viewportRect&&(translation=translation||me.translation,constraints=me.getConstraints(contentRect,viewportRect),offLimits=me.getOffLimits(translation,constraints),me.constrainRange(translation,constraints.slice(0,2),constraints.slice(2)),offLimits&&momentum&&momentum.spring&&(translation[0]+=offLimits[0]*momentum.spring,translation[1]+=offLimits[1]*momentum.spring),me.updateIndicator(contentRect,viewportRect))},createInterpolator:function(multiplier){var interpolator,start=0,delta=1;return multiplier=multiplier||1,(interpolator=function(x){var result=0;return delta&&(result=(x-start)/delta,result=Math.max(0,result),result=Math.min(1,result),result*=multiplier),result}).domain=function(a,b){start=a,delta=b-a},interpolator},updateIndicator:function(contentRect,viewportRect){var contentX,contentY,contentWidth,contentHeight,h0,h1,v0,v1,sx,sy,me=this,hScale=me.hScrollScale,vScale=me.vScrollScale;contentRect=contentRect||me.contentRect&&me.contentRect(),viewportRect=viewportRect||me.viewportRect&&me.viewportRect(),me.hScroll&&contentRect&&viewportRect&&(sx=me.scaling[0],sy=me.scaling[1],contentX=contentRect.x*sx+me.translation[0],contentY=contentRect.y*sy+me.translation[1],contentWidth=contentRect.width*sx,contentHeight=contentRect.height*sy,contentWidth>viewportRect.width?(hScale.domain(contentX,contentX+contentWidth),h0=hScale(0),h1=hScale(viewportRect.width),me.hScrollBar.style.left=h0+"%",me.hScrollBar.style.width=h1-h0+"%",me.hScroll.dom.style.display="block"):me.hScroll.dom.style.display="none",contentHeight>viewportRect.height?(vScale.domain(contentY,contentY+contentHeight),v0=vScale(0),v1=vScale(viewportRect.height),me.vScrollBar.style.top=v0+"%",me.vScrollBar.style.height=v1-v0+"%",me.vScroll.dom.style.display="block"):me.vScroll.dom.style.display="none")},getConstraints:function(contentRect,viewportRect){var contentX,contentY,contentWidth,contentHeight,sx,sy,dx,dy,me=this,pan=me.pan,result=null;return contentRect=pan&&pan.constrain&&(contentRect||me.contentRect&&me.contentRect()),viewportRect=viewportRect||me.viewportRect&&me.viewportRect(),contentRect&&viewportRect&&(sx=me.scaling[0],sy=me.scaling[1],contentX=contentRect.x*sx,contentY=contentRect.y*sy,contentWidth=contentRect.width*sx,contentHeight=contentRect.height*sy,dx=viewportRect.width-contentWidth-contentX,dy=viewportRect.height-contentHeight-contentY,result=[Math.min(-contentX,dx),Math.max(-contentX,dx),Math.min(-contentY,dy),Math.max(-contentY,dy)]),result},getOffLimits:function(translation,constraints,minimum){var minX,minY,maxX,maxY,x,y,result=null;return minimum=minimum||.1,(constraints=constraints||this.getConstraints())&&(x=(translation=translation||this.translation)[0],y=translation[1],minX=constraints[0],maxX=constraints[1],minY=constraints[2],maxY=constraints[3],x<minX?x-=minX:x>maxX?x-=maxX:x=0,y<minY?y-=minY:y>maxY?y-=maxY:y=0,x&&Math.abs(x)<minimum&&(x=0),y&&Math.abs(y)<minimum&&(y=0),(x||y)&&(result=[x,y])),result},translate:function(x,y){var translation=this.translation;this.setTranslation(translation[0]+x,translation[1]+y)},setTranslation:function(x,y){var me=this,translation=me.translation;translation[0]=x,translation[1]=y,me.constrainTranslation(translation),me.fireEvent("panzoom",me,me.scaling,translation)},scale:function(sx,sy,center){var scaling=this.scaling;this.setScaling(scaling[0]*sx,scaling[1]*sy,center)},setScaling:function(sx,sy,center){var cx,cy,me=this,zoom=me.getZoom(),scaling=me.scaling,oldSx=scaling[0],oldSy=scaling[1],translation=me.translation,oldTranslation=me.oldTranslation;zoom&&(zoom.uniform&&(sx=sy=(sx+sy)/2),scaling[0]=sx,scaling[1]=sy,me.constrainRange(scaling,zoom.extent),sx=scaling[0]/oldSx,sy=scaling[1]/oldSy,cx=center&&center[0]||0,cy=center&&center[1]||0,translation[0]=cx+sx*(translation[0]-cx),translation[1]=cy+sy*(translation[1]-cy),oldTranslation&&(oldTranslation[0]=cx-(cx-oldTranslation[0])*sx,oldTranslation[1]=cy-(cy-oldTranslation[1])*sy),me.constrainTranslation(translation),me.fireEvent("panzoom",me,scaling,translation))},setPanZoomSilently:function(pan,zoom){this.suspendEvent("panzoom"),pan&&this.setTranslation(pan[0],pan[1]),zoom&&this.setScaling(zoom[0],zoom[1]),this.resumeEvent("panzoom")},setPanZoom:function(pan,zoom){var me=this;me.setPanZoomSilently(pan,zoom),me.fireEvent("panzoom",me,me.scaling,me.translation)},normalize:function(x,y,factor){var k=(factor||1)/this.magnitude(x,y);return[x*k,y*k]},magnitude:function(x,y){return Math.sqrt(x*x+y*y)},panFx:function(pan){if(pan.momentum){var friction,spring,me=this,momentum=pan.momentum,translation=me.translation,offLimits=me.getOffLimits(translation),velocityX=me.velocityX=me.dx,velocityY=me.velocityY=me.dy;offLimits&&(offLimits[0]&&(me.velocityX=0,velocityX=offLimits[0]),offLimits[1]&&(me.velocityY=0,velocityY=offLimits[1])),friction=me.normalize(velocityX,velocityY,-momentum.friction),me.frictionX=friction[0],me.frictionY=friction[1],spring=me.normalize(velocityX,velocityY,-momentum.spring),me.springX=spring[0],me.springY=spring[1],Ext.AnimationQueue.start(me.panFxFrame,me)}},incKeepSign:function(x,inc){return x?x*inc<0&&Math.abs(x)<Math.abs(inc)?0:x+inc:x},panFxFrame:function(){var springX,springY,me=this,translation=me.translation,offLimits=me.getOffLimits(translation),offX=offLimits&&offLimits[0],offY=offLimits&&offLimits[1],absOffX=0,absOffY=0,forceX=0,forceY=0;forceX+=me.velocityX=me.incKeepSign(me.velocityX,me.frictionX),forceY+=me.velocityY=me.incKeepSign(me.velocityY,me.frictionY),offX&&(absOffX=Math.abs(offX),springX=me.springX*absOffX,me.velocityX=me.incKeepSign(forceX,springX),forceX+=springX,Math.abs(forceX)<.1&&(forceX=.1*Ext.Number.sign(forceX)),me.velocityX||Math.abs(forceX)>1||me.incKeepSign(offX,forceX)||(forceX=-offX)),offY&&(absOffY=Math.abs(offY),springY=me.springY*absOffY,me.velocityY=me.incKeepSign(forceY,springY),forceY+=springY,Math.abs(forceY)<.1&&(forceY=.1*Ext.Number.sign(forceY)),me.velocityY||Math.abs(forceY)>1||me.incKeepSign(offY,forceY)||(forceY=-offY)),me.prevForceX=forceX,me.prevForceY=forceY,translation[0]+=forceX,translation[1]+=forceY,me.updateIndicator(),forceX||forceY||Ext.AnimationQueue.stop(me.panFxFrame,me),me.fireEvent("panzoom",me,me.scaling,translation)},getGestures:function(){var panGesture,zoomGesture,gestures=this.gestures,pan=this.getPan(),zoom=this.getZoom();return gestures||(this.gestures=gestures={},pan&&(gestures[panGesture=pan.gesture]="onPanGesture",gestures[panGesture+"start"]="onPanGestureStart",gestures[panGesture+"end"]="onPanGestureEnd",gestures[panGesture+"cancel"]="onPanGestureEnd"),zoom&&(gestures[zoomGesture=zoom.gesture]="onZoomGesture",gestures[zoomGesture+"start"]="onZoomGestureStart",gestures[zoomGesture+"end"]="onZoomGestureEnd",gestures[zoomGesture+"cancel"]="onZoomGestureEnd",zoom.doubleTap&&(gestures.doubletap="onDoubleTap"),zoom.mouseWheel&&(gestures.wheel="onMouseWheel"))),gestures},updateGestures:function(gestures){this.gestures=gestures},isPanning:function(pan){return(pan=pan||this.getPan())&&this.getLocks()[pan.gesture]===this},onPanGestureStart:function(e){var xy,me=this,touches=e&&e.event&&e.event.touches||e.touches,pan=me.getPan();if(pan&&(!touches||touches.length<2))return e.claimGesture(),Ext.AnimationQueue.stop(me.panFxFrame,me),me.lockEvents(pan.gesture),xy=e.getXY(),me.panOrigin=me.lastPanXY=me.toRtlViewportXY(xy[0],xy[1]),me.oldTranslation=me.translation.slice(),!1},onPanGesture:function(e){var xy,dx,dy,me=this,oldTranslation=me.oldTranslation,panOrigin=me.panOrigin;if(me.isPanning())return xy=e.getXY(),xy=me.toRtlViewportXY(xy[0],xy[1]),me.dx=xy[0]-me.lastPanXY[0],me.dy=xy[1]-me.lastPanXY[1],me.lastPanXY=xy,dx=xy[0]-panOrigin[0],dy=xy[1]-panOrigin[1],me.setTranslation(oldTranslation[0]+dx,oldTranslation[1]+dy),!1},onPanGestureEnd:function(){var me=this,pan=me.getPan();if(me.isPanning(pan))return me.panOrigin=null,me.oldTranslation=null,me.unlockEvents(pan.gesture),me.panFx(pan),!1},onZoomGestureStart:function(e){var point1,point2,xSpread,ySpread,touch1,touch2,me=this,zoom=me.getZoom(),touches=e&&e.event&&e.event.touches||e.touches;if(zoom&&touches&&2===touches.length)return e.claimGesture(),me.lockEvents(zoom.gesture),me.oldTranslation=me.translation.slice(),touch1=touches[0],touch2=touches[1],point1=me.toViewportXY(touch1.pageX,touch1.pageY),xSpread=(point2=me.toViewportXY(touch2.pageX,touch2.pageY))[0]-point1[0],ySpread=point2[1]-point1[1],me.startSpread=[Math.max(me.minSpread,Math.abs(xSpread)),Math.max(me.minSpread,Math.abs(ySpread))],me.oldScaling=me.scaling.slice(),me.oldScalingCenter=[point1[0]+.5*xSpread,point1[1]+.5*ySpread],!1},onZoomGesture:function(e){var point1,point2,xSpread,ySpread,xScale,yScale,touch1,touch2,scalingCenter,dx,dy,me=this,zoom=me.getZoom(),startSpread=me.startSpread,oldScaling=me.oldScaling,oldScalingCenter=me.oldScalingCenter,touches=e&&e.event&&e.event.touches||e.touches;if(zoom&&me.getLocks()[zoom.gesture]===me)return touch1=touches[0],touch2=touches[1],point1=me.toViewportXY(touch1.pageX,touch1.pageY),xSpread=(point2=me.toViewportXY(touch2.pageX,touch2.pageY))[0]-point1[0],ySpread=point2[1]-point1[1],dx=(scalingCenter=[point1[0]+.5*xSpread,point1[1]+.5*ySpread])[0]-oldScalingCenter[0],dy=scalingCenter[1]-oldScalingCenter[1],me.setTranslation(me.oldTranslation[0]+dx,me.oldTranslation[1]+dy),xSpread=Math.max(me.minSpread,Math.abs(xSpread)),ySpread=Math.max(me.minSpread,Math.abs(ySpread)),xScale=xSpread/startSpread[0],yScale=ySpread/startSpread[1],me.setScaling(xScale*oldScaling[0],yScale*oldScaling[1],scalingCenter),!1},onZoomGestureEnd:function(){var me=this,zoom=me.getZoom();if(zoom&&me.getLocks()[zoom.gesture]===me)return me.startSpread=null,me.oldScalingCenter=null,me.oldTranslation=null,me.unlockEvents(zoom.gesture),me.dx=0,me.dy=0,me.panFx(me.getPan()),!1},onMouseWheel:function(e){var factor,center,xy,delta=e.getWheelDelta(),zoom=this.getZoom();zoom&&zoom.mouseWheel&&(factor=zoom.mouseWheel.factor)&&(factor=Math.pow(factor,delta),xy=e.getXY(),center=this.toViewportXY(xy[0],xy[1]),this.scale(factor,factor,center),e.preventDefault())},onDoubleTap:function(e){var factor,center,xy,zoom=this.getZoom();zoom&&zoom.doubleTap&&(factor=zoom.doubleTap.factor)&&(xy=e.getXY(),center=this.toViewportXY(xy[0],xy[1]),this.scale(factor,factor,center))},createIndicator:function(){var me=this;me.hScroll||(me.hScroll=Ext.dom.Element.create({tag:"div",classList:[Ext.baseCSSPrefix+"d3-scroll",Ext.baseCSSPrefix+"d3-hscroll"],style:{},children:[{tag:"div",reference:"bar",classList:[Ext.baseCSSPrefix+"d3-scrollbar",Ext.baseCSSPrefix+"d3-hscrollbar"]}]}),me.hScrollBar=me.hScroll.dom.querySelector("[reference=bar]"),me.hScrollBar.removeAttribute("reference"),me.vScroll=Ext.dom.Element.create({tag:"div",classList:[Ext.baseCSSPrefix+"d3-scroll",Ext.baseCSSPrefix+"d3-vscroll"],style:{},children:[{tag:"div",reference:"bar",classList:[Ext.baseCSSPrefix+"d3-scrollbar",Ext.baseCSSPrefix+"d3-vscrollbar"]}]}),me.vScrollBar=me.vScroll.dom.querySelector("[reference=bar]"),me.vScrollBar.removeAttribute("reference"),me.hScrollScale=me.createInterpolator(100),me.vScrollScale=me.createInterpolator(100))},destroyIndicator:function(){var me=this;Ext.destroy(me.hScroll,me.vScroll),me.hScroll=me.vScroll=me.hScrollBar=me.vScrollBar=null},addIndicator:function(component){var me=this,indicator=me.getIndicator(),indicatorParent=me.indicatorParent;indicator&&!indicatorParent&&(me.createIndicator(),(indicatorParent=me.indicatorParent=component[indicator.parent])&&(indicatorParent.appendChild(me.hScroll),indicatorParent.appendChild(me.vScroll)))},removeIndicator:function(){var me=this,indicatorParent=me.indicatorParent;indicatorParent&&(me.hScroll&&indicatorParent.removeChild(me.hScroll),me.vScroll&&indicatorParent.removeChild(me.vScroll),me.indicatorParent=null)},addComponent:function(component){this.callParent([component]),this.addIndicator(component)},removeComponent:function(component){this.removeIndicator(),this.callParent([component])}}),Ext.define("Ext.d3.svg.Export",{singleton:!0,toSvg:function(dom){return'<?xml version="1.0" standalone="yes"?>'+this.serializeNode(dom)},download:function(filename,content){var blob=new Blob([content]),a=document.createElement("a");a.setAttribute("download",filename),a.setAttribute("href",URL.createObjectURL(blob)),a.click()},quotesRe:/"/g,serializeNode:function(node){var i,n,attr,child,style,rule,value,result="";if(node.nodeType===document.TEXT_NODE)return this.escapeText(node.nodeValue);if(result+="<"+node.nodeName,node.attributes.length)for(i=0,n=node.attributes.length;i<n;i++)"style"!==(attr=node.attributes[i]).name&&(result+=" "+attr.name+'="'+attr.value+'"');for(result+=' style="',i=0,n=(style=getComputedStyle(node)).length;i<n;i++)"string"==typeof(value=style[rule=style[i]])&&(result+=rule+":"+value.replace(this.quotesRe,"'")+";");if(result+='"',result+=">",node.childNodes&&node.childNodes.length)for(i=0,n=node.childNodes.length;i<n;i++)child=node.childNodes[i],result+=this.serializeNode(child);return result+="</"+node.nodeName+">"},escapeTextRe:[[/&/g,"&amp;"],[/"/g,"&quot;"],[/'/g,"&apos;"],[/</g,"&lt;"],[/>/g,"&gt;"]],escapeText:function(text){var i,item,list=this.escapeTextRe,ln=list.length;for(i=0;i<ln;i++)item=list[i],text=text.replace(item[0],item[1]);return text}});