Ext.define("KSWN.admin.trace.sql.model.Query",{extend:"Ext.data.Model",fields:[{name:"QueryNumber",type:"number"},{name:"CommandText",type:"string"},{name:"QueryText",type:"string"},{name:"AppName",type:"string"},{name:"ServerName",type:"string"},{name:"DataBaseName",type:"string"},{name:"ParameterValues",allowNull:!0},{name:"ReturnedDataSet",allowNull:!0},{name:"InfoMessages",type:"string",allowNull:!0},{name:"BeginUtcTime",type:"string"},{name:"EndUtcTime",type:"string"},{name:"ErrorMessage",type:"string",allowNull:!0},{name:"CallingMethodName",type:"string"},{name:"UserName",type:"string"},{name:"DataSourceType",type:"int"},{name:"beginDate",type:"date",mapping:"BeginUtcTime"},{name:"endDate",type:"date",mapping:"EndUtcTime"},{name:"duration",type:"number",depends:["beginDate","endDate"],calculate:_ref=>{let{beginDate:beginDate,endDate:endDate}=_ref;return beginDate&&endDate?endDate-beginDate:0}},{name:"shortCallingMethodName",type:"string",depends:["CallingMethodName"],calculate:data=>{const[firstRow]=data.CallingMethodName.replace(/\r\n/gi,"\n").split("\n");return firstRow}},{name:"formattedBeginDate",type:"string",depends:["beginDate"],calculate:_ref2=>{let{beginDate:beginDate}=_ref2;return beginDate?Ext.Date.format(beginDate,"d.m.Y H:i:s.u"):null}},{name:"parameters",depends:["ParameterValues"],calculate:function(_ref3){let{ParameterValues:values}=_ref3,parameters=[];for(let name in values){const value=values[name];parameters.push({type:typeof value,name:name,value:value})}return parameters}},{name:"resultTables",depends:["ReturnedDataSet"],calculate:_ref4=>{let{ReturnedDataSet:dataset}=_ref4;return dataset?dataset.Tables.map(table=>{const data=KSWN.util.DataUtils.GetDataFromTable(table);return{name:`${table.TableName} Rows:${data.length} `,columns:KSWN.util.DataUtils.GetGridColumnsFromTable(table),data:data}}):[]}},{name:"formattedQueryText",type:"string",depends:["QueryNumber","CommandText","DataSourceType","DataBaseName","UserName","ServerName","formattedBeginDate","shortCallingMethodName","AppName"],convert:(v,rec)=>rec.getQueryText()}],sniffedQueryFields:["QueryNumber","CommandText","AppName","ServerName","DataBaseName","ParameterValues","ReturnedValue","ReturnedDataSet","InfoMessages","Schema","BeginUtcTime","EndUtcTime","Exception","CallingMethodName"],hasReturnedDataSet:function(){return this.getReturnedDataSet().length>0},getParameters:function(){return this.get("parameters")},getReturnedDataSet:function(){return this.get("resultTables")},getSniffedQueryData:function(){const result={};return this.sniffedQueryFields.forEach(field=>{result[field]=this.get(field)}),result},getQueryText:function(){const{QueryNumber:QueryNumber,CommandText:CommandText,DataSourceType:DataSourceType}=this.data,msgBuilder=[];let commentText;return msgBuilder.push("-- "+QueryNumber),commentText=DataSourceType===KSWN.system.DataSourceType.PostgreSQL?this.getPgCommentText():DataSourceType===KSWN.system.DataSourceType.MSSQL?this.getMSSQLCommentText():this.getDefaultCommentText(),msgBuilder.push(commentText),msgBuilder.push(CommandText),msgBuilder.push("\r\n"),msgBuilder.join("\r\n")},getPgCommentText:function(){const{DataBaseName:DataBaseName,UserName:UserName,ServerName:ServerName,formattedBeginDate:formattedBeginDate,shortCallingMethodName:shortCallingMethodName,AppName:AppName}=this.data;return`-- set session authorization '${UserName}'; -- ${ServerName}.${DataBaseName} - (${formattedBeginDate}) [${shortCallingMethodName}] ${AppName}`},getMSSQLCommentText:function(){const{DataBaseName:DataBaseName,UserName:UserName,ServerName:ServerName,formattedBeginDate:formattedBeginDate,shortCallingMethodName:shortCallingMethodName,AppName:AppName}=this.data;return`-- use [${DataBaseName}]; execute as login='${UserName}'; -- ${ServerName} (${formattedBeginDate}) [${shortCallingMethodName}] ${AppName}`},getDefaultCommentText:function(){const{DataBaseName:DataBaseName,UserName:UserName,ServerName:ServerName,formattedBeginDate:formattedBeginDate,shortCallingMethodName:shortCallingMethodName,AppName:AppName}=this.data;return`--${ServerName}.${DataBaseName} - ${UserName} (${formattedBeginDate}) [${shortCallingMethodName}] ${AppName}`}}),Ext.define("KSWN.admin.trace.sql.store.Queries",{extend:"Ext.data.Store",alias:"store.ks-admin-trace-sql-queries",model:"KSWN.admin.trace.sql.model.Query",proxy:{type:"memory"},queriesAddQueue:[],constructor:function(){this.callParent(arguments),this.addQueriesFromQueue=_.debounce(()=>this._addQueriesFromQueue(),500)},addQueries:function(data){const queries=this.convertServerQueriesData(data);0!==queries.length&&(this.queriesAddQueue.push(...queries),this.addQueriesFromQueue())},_addQueriesFromQueue:function(){const queries=this.queriesAddQueue,result=this.getProxy().getReader().read(queries),records=result.getRecords(),success=result.getSuccess();success&&this.add(records),this.fireEvent("queriesadd",this,records,success),this.queriesAddQueue=[]},convertServerQueriesData:function(data){const queries=[];for(let number in data){const query=data[number],isValidEndDate=()=>{const endDate=!!(null==query?void 0:query.EndUtcTime)&&new Date(Date.parse(query.EndUtcTime));return!!endDate&&0!==endDate.getFullYear()};query&&!this.getById(number)&&isValidEndDate()&&(query.id=number,queries.push(query))}return queries},getQueriesDictionaryForSave:function(){return this.getRange().map(rec=>rec.getSniffedQueryData()).reduce((obj,query)=>(obj[query.QueryNumber]=query,obj),{})},getAllQueriesText:function(){return this.getRange().map(rec=>rec.getQueryText()).join("\r\n")}}),Ext.define("KSWN.admin.trace.sql.view.QueriesGrid",{extend:"KSWN.core.grid.Ext",xtype:"ks-admin-trace-sql-queriesgrid",showFilter:!0,filterRowVisible:!0,columns:{defaults:{sortable:!1},items:[{dataIndex:"QueryText",text:"Query Text",flex:5},{dataIndex:"shortCallingMethodName",text:"Calling Method",flex:3,renderer:(value,meta,rec)=>`<div data-qtip="${rec.get("CallingMethodName")}">${value}</div>`},{dataIndex:"beginDate",xtype:"datecolumn",text:"Begin Time",format:"d.m.Y H:i:s.u",flex:2},{dataIndex:"endDate",xtype:"datecolumn",text:"End Time",format:"d.m.Y H:i:s.u",flex:2},{dataIndex:"duration",text:"Duration (ms)",flex:1}]}}),Ext.define("KSWN.admin.trace.sql.view.QueriesTextGrid",{extend:"Ext.grid.Panel",xtype:"ks-admin-trace-sql-queriestextgrid",hideHeaders:!0,viewConfig:{enableTextSelection:!0,stripeRows:!1},columns:[{dataIndex:"formattedQueryText",flex:1,variableRowHeight:!0,allowHTML:!0,renderer:text=>KSWN.util.CodeMirror.formatText(text,{format:"text/x-mysql"})}],initComponent:function(){this.addCls("ks-admin-trace-sql-queriestextgrid"),this.callParent()}}),Ext.define("KSWN.admin.trace.sql.view.QueryParametersView",{extend:"Ext.Component",xtype:"ks-admin-trace-sql-queryparamsview",cls:"ks-admin-trace-sql-queryparamsview",tpl:['<div class="ks-admin-trace-sql-queryparamsview-list">','<tpl for=".">','<pre class="ks-admin-trace-sql-queryparamsview-list-item">{name} = {value} ({type})</pre>',"</tpl>","</div>"],scrollable:"y",renderConfig:{parameters:null},updateParameters:function(params){this.setData(params||null)}}),Ext.define("KSWN.admin.trace.sql.view.QueryResultsPanel",{extend:"Ext.tab.Panel",xtype:"ks-admin-trace-sql-queryresultspanel",renderConfig:{withResults:void 0,query:void 0},queryResultsTablesTabs:null,queryParametersView:null,updateWithResults:function(withResults){if(withResults){const query=this.getQuery();query&&this.showQueryResults(query)}else this.clearQueryResults();this.setVisible(withResults),this.setActiveTab(0)},updateQuery:function(query){this.getWithResults()&&query?this.showQueryResults(query):this.clearQueryResults()},showQueryResults:function(query){this.queryParametersView.setParameters(query.getParameters()),this.destroyQueryResultsTablesTabs();const tables=query.getReturnedDataSet();if(tables.length){const tabs=tables.map(table=>({xtype:"gridlist",title:table.name,showFilter:!0,readOnly:!0,columns:table.columns,store:new Ext.data.Store({data:table.data})}));this.queryResultsTablesTabs=this.add(tabs)}},clearQueryResults:function(){this.queryParametersView.setParameters(null),this.destroyQueryResultsTablesTabs()},destroyQueryResultsTablesTabs:function(){this.queryResultsTablesTabs&&this.queryResultsTablesTabs.length>0&&(Ext.destroy(this.queryResultsTablesTabs),this.queryResultsTablesTabs=null)},initComponent:function(){this.queryParametersView=new KSWN.admin.trace.sql.view.QueryParametersView,this.callParent(),this.queryParametersViewTab=this.add({title:KSWN.Locale.parametri,layout:"fit",items:this.queryParametersView})}}),Ext.define("KSWN.admin.trace.sql.view.Toolbar",{extend:"Ext.toolbar.Toolbar",xtype:"ks-admin-trace-sql-toolbar",defaults:{scale:"large"},items:[{iconCls:KSWN.Constant.iconClsPrefix+"start32",tooltip:KSWN.Locale.zapustittrassirovku,handler:"onStartBtnClick",bind:{disabled:"{started}"}},{iconCls:KSWN.Constant.iconClsPrefix+"stop32",tooltip:KSWN.Locale.ostanovittrassirovku,handler:"onStopBtnClick",bind:{disabled:"{!started}"}},"-",{xtype:"splitbutton",iconCls:KSWN.Constant.iconClsPrefix+"save32",tooltip:KSWN.Locale.sokhranit,menu:[{text:KSWN.Locale.sokhranitkaktekst,handler:"onSaveAsTextBtnClick"},{text:KSWN.Locale.sokhranitrezultatvxml,handler:"onSaveQueryResultAsXmlBtnClick",bind:{disabled:"{!selectedQuery}"}}],handler:"onSaveBtnClick",bind:{disabled:"{isQueriesStoreEmpty}"}},{iconCls:KSWN.Constant.iconClsPrefix+"folder_export32",tooltip:KSWN.Locale.zagruzit,disabled:!0},{iconCls:KSWN.Constant.iconClsPrefix+"clean32",tooltip:KSWN.Locale.ochistit,handler:"onClearBtnClick",bind:{disabled:"{isQueriesStoreEmpty}"}},"-",{xtype:"ks-ux-button",iconCls:KSWN.Constant.iconClsPrefix+"attachment32",tooltip:KSWN.Locale.pokazivatparametriirezultati,enableToggle:!0,toggleOnClick:!1,listeners:{click:"onWithResultsToggleClick"},bind:{pressed:"{withResults}",disabled:"{reconfiguring}"}},{xtype:"ks-ux-button",iconCls:KSWN.Constant.iconClsPrefix+"ghost32",tooltip:KSWN.Locale.pokazivatskritiezaprosi,enableToggle:!0,toggleOnClick:!1,listeners:{click:"onShowHiddenToggleClick"},bind:{pressed:"{showHidden}",disabled:"{reconfiguring}"}},{iconCls:KSWN.Constant.iconClsPrefix+"lock32",itemId:"btnLock",tooltip:KSWN.Locale.blokirovatperemeshcheniekursora,enableToggle:!0,bind:{pressed:"{selectionLocked}"}},"-",{iconCls:KSWN.Constant.iconClsPrefix+"heracly32",tooltip:KSWN.Locale.pokazatpolniistek,handler:"onShowFullStackBtnClick",bind:{disabled:"{!selectedQuery}"}}]}),Ext.define("KSWN.admin.trace.sql.view.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-admin-trace-sql",bindings:{onSelectedQueryChange:"{selectedQuery}"},sqlTracer:null,onStartBtnClick:function(){this.getSqlTracer().start()},onStopBtnClick:function(){this.getSqlTracer().stop()},onSaveBtnClick:function(){this.getSqlTracer().saveAsFile()},onSaveQueryResultAsXmlBtnClick:function(){const query=this.getViewModel().get("selectedQuery");query&&(query.hasReturnedDataSet()?this.getSqlTracer().saveResultToXmlFile(query.getSniffedQueryData()):KSWN.core.messageBox.MessageBox.alert({messageType:"msg",message:KSWN.Locale.dannikhdlyazaprosanet}))},onSaveAsTextBtnClick:function(){this.getSqlTracer().saveAsTextFile()},onClearBtnClick:function(){this.getViewModel().getQueriesStore().removeAll()},onWithResultsToggleClick:function(){this.reconfigureTraceModel({withResults:!this.getViewModel().get("withResults")})},onShowHiddenToggleClick:function(){this.reconfigureTraceModel({showHidden:!this.getViewModel().get("showHidden")})},reconfigureTraceModel:async function(params){const vm=this.getViewModel();vm.set("reconfiguring",!0),console.info("reconfiguring");const sniffMode=await this.getSqlTracer().reconfigure(params);vm.set("reconfiguring",!1),sniffMode&&vm.setSniffMode(sniffMode)},onShowFullStackBtnClick:function(){const query=this.getViewModel().getSelectedQuery();if(query){const text=query.get("CallingMethodName");KSWN.util.ExtUtils.ShowText(text)}},onQueriesStoreAdd:function(store,records,success){success&&!this.getViewModel().isSelectionLocked()&&this.selectQuery(_.last(records))},selectQuery:function(queryRec){const queriesGrid=this.lookup("queriesGrid");this.getViewModel().set("selectedQuery",queryRec),queriesGrid.ensureVisible(queryRec)},onSelectedQueryChange:function(queryRec){if(!queryRec)return;this.lookup("queriesTextGrid").ensureVisible(queryRec)},onQueriesGridRowKeyDown:function(grid,record,item,index,e){if(e.keyCode===Ext.event.Event.C&&e.ctrlKey){const text=record.getQueryText();KSWN.util.Utils.CopyTextToClipboard({text:text})}},getSqlTracer:function(){return this.sqlTracer||(this.sqlTracer=this.view.sqlTracer)}}),Ext.define("KSWN.admin.trace.sql.view.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-admin-trace-sql",data:{withResults:!1,showHidden:!1,started:!1,selectedQuery:null,selectionLocked:!1,reconfiguring:!1,isQueriesStoreEmpty:!1},formulas:{isQueriesStoreEmpty:{bind:{bindTo:"{queriesStore.count}"},get:count=>0===count}},stores:{queriesStore:{type:"ks-admin-trace-sql-queries",listeners:{queriesadd:"onQueriesStoreAdd"}}},setSniffMode:function(sniffMode){this.set({withResults:sniffMode.WithResults,showHidden:sniffMode.ShowHidden})},getQueriesStore:function(){return this.get("queriesStore")},getSelectedQuery:function(){return this.get("selectedQuery")},isSelectionLocked:function(){return this.get("selectionLocked")}}),Ext.define("KSWN.admin.trace.sql.view.View",{extend:"Ext.panel.Panel",xtype:"ks-admin-trace-sql",viewModel:"ks-admin-trace-sql",controller:"ks-admin-trace-sql",layout:{type:"vbox",align:"stretch"},tbar:{xtype:"ks-admin-trace-sql-toolbar"},items:[{xtype:"ks-admin-trace-sql-queriesgrid",flex:1,reference:"queriesGrid",listeners:{itemkeydown:"onQueriesGridRowKeyDown"},bind:{store:"{queriesStore}",selection:"{selectedQuery}"}},{xtype:"ks-ux-resizer-splitter"},{xtype:"ks-admin-trace-sql-queriestextgrid",flex:1,reference:"queriesTextGrid",bind:{store:"{queriesStore}",selection:"{selectedQuery}"}},{xtype:"ks-ux-resizer-splitter",bind:{hidden:"{!withResults}"}},{xtype:"ks-admin-trace-sql-queryresultspanel",flex:1,layout:"fit",bind:{withResults:"{withResults}",query:"{selectedQuery}"}}]}),Ext.define("KSWN.admin.trace.sql.SQLTraceManager",{singleton:!0,all:{},onSQLTraceConnectionCallback:function(id,data){const sqlTrace=this.getSQLTracer(id);sqlTrace&&sqlTrace.handleSniffedQueries(data)},register:function(sqlTrace){const id=sqlTrace.getId();this.all[id]=sqlTrace},unregister:function(sqlTrace){const id=sqlTrace.getId();delete this.all[id]},getSQLTracer:function(id){return this.all[id]}}),Ext.define("KSWN.admin.trace.sql.SQLTracer",{inheritableStatics:{objCode:"TRACE-SQL",title:KSWN.Locale.sqltrassirovshchik,iconCls:KSWN.Constant.iconClsPrefix+"sql",openSQLTracer:function(config){const SQLTracer=this,objxConfig={objCode:SQLTracer.objCode,title:SQLTracer.title,iconCls:SQLTracer.iconCls},objx=KSWN.core.dashboard.Starter.CustomTabOpen(objxConfig);if(objx)return config=Ext.apply({},config),new SQLTracer({...config,objx:objx})}},id:null,objx:null,initSqlTraceModelUrl:"/SQLTrace/Init",startUrl:"/SQLTrace/Start",stopUrl:"/SQLTrace/Stop",cleanUrl:"/SQLTrace/Clean",saveAsFileUrl:"/SQLTrace/Save/",autoInit:!0,sniffMode:null,modelInitialized:!1,constructor:function(config){config.objx||Ext.raise("SQLTracer - objx required"),this.initConfig(config),this.id=KSWN.util.Utils.guid(),KSWN.admin.trace.sql.SQLTraceManager.register(this),this.renderView(),this.autoInit&&this.init()},init:async function(){await this.initSqlTraceModel(),await this.start()},renderView:function(){const container=this.objx.containerMain;container.removeAll();const view=container.add({xtype:"ks-admin-trace-sql",sqlTracer:this});view.container=view,this.viewModel=view.getViewModel(),this.view=view,view.on("destroy",this.onViewDestroy,this)},initSqlTraceModel:async function(){const res=await KSWN.getConnection().Ajax({url:this.initSqlTraceModelUrl,params:{gid:this.getId()}});res?(this.modelInitialized=!0,this.viewModel.setSniffMode(res)):this.view.destroy()},onViewDestroy:function(){this.destroy()},start:async function(){if(this.isStarted()||!this.isModelInitialized())return;await KSWN.getConnection().Ajax({url:this.startUrl,params:{gid:this.getId()}})&&this.setStarted(!0)},stop:async function(){if(!this.isStarted()||!this.isModelInitialized())return;await KSWN.getConnection().Ajax({url:this.stopUrl,params:{gid:this.getId()}})&&this.setStarted(!1)},reconfigure:async function(_ref5){let{withResults:withResults=null,showHidden:showHidden=null}=_ref5;if(this.isModelInitialized())return KSWN.getConnection().Ajax({url:"/SQLTrace/Reconfigure",mask:{text:KSWN.Locale.rekonfiguratsiya,id:this.view},params:{gid:this.getId(),withResults:withResults,showHidden:showHidden}})},saveAsFile:function(){const trace=this.getQueriesStore().getQueriesDictionaryForSave(),params={gid:this.getId(),traceJson:Ext.encode(trace),fileName:KSWN.util.Utils.guid()+".trace"};KSWN.util.FileUtils.DownloadFile(this.saveAsFileUrl,params,null,!0,!0,KSWN.util.FileUtils.SaveBlob,"blob")},saveResultToXmlFile:function(queryData){const params={gid:this.getId(),traceJson:Ext.encode({0:queryData}),xml:!0,fileName:KSWN.util.Utils.guid()+".xml"};KSWN.util.FileUtils.DownloadFile(this.saveAsFileUrl,params,null,!0,!0,KSWN.util.FileUtils.SaveBlob,"blob")},saveAsTextFile:function(){const traceText=this.getQueriesStore().getAllQueriesText();KSWN.util.FileUtils.SaveText(traceText,KSWN.util.Utils.guid()+".sql")},handleSniffedQueries:function(data){this.getQueriesStore().addQueries(data)},isModelInitialized:function(){return this.modelInitialized},isStarted:function(){return this.getStarted()},getQueriesStore:function(){return this.viewModel.getQueriesStore()},getStarted:function(){return this.started},setStarted:function(started){var _this$viewModel;this.getStarted()!==started&&(this.appUnloadListener=Ext.destroy(this.appUnloadListener),started&&(this.appUnloadListener=KSWN.app.on({appunload:this.onAppUnload,scope:this,destroyable:!0})),this.started=started,this.viewModel&&!this.viewModel.destroyed&&(null===(_this$viewModel=this.viewModel)||void 0===_this$viewModel||_this$viewModel.set({started:started})))},onAppUnload:function(){this.clean()},clean:function(){return KSWN.getConnection().Ajax({url:this.cleanUrl,params:{gid:this.getId()}})},destroy:function(){this.clean(),KSWN.admin.trace.sql.SQLTraceManager.unregister(this),this.view&&!this.view.destroying&&Ext.destroy(this.objx),this.appUnloadListener=Ext.destroy(this.appUnloadListener),this.view=null,this.viewModel=null,this.objx=null,this.callParent()},getId:function(){return this.id}}),Ext.define("KSWN.admin.trace.sql.SQLCacheTracer",{extend:"KSWN.admin.trace.sql.SQLTracer",statics:{title:"DataCache",objectCode:"TRACE-SQL-CACHE"},initSqlTraceModelUrl:"/SQLTrace/InitCacheTrace"});