Ext.define("KSWN.core.dbManager.module.MailProfile",{createMailProfile:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();node.isAdminDbMailNode()?this.createDbMailProfile(node):node.isAdminDbMailProfileNode()&&this.editDbMailProfile(node)},createDbMailProfile:async function(node){try{await this.showFormWindow({xtype:"ks-core-dbmanager-form-mailprofile-window"})&&node.refreshBranch()}catch(err){this.handleOperationError(err)}},editDbMailProfile:async function(node){try{const profileData=await this.loadDbMailProfileData({node:node});if(!profileData)return;await this.showFormWindow({xtype:"ks-core-dbmanager-form-mailprofile-window",formValues:{profileData:profileData}})&&node.getDbNode().refreshBranch()}catch(err){this.handleOperationError(err)}},loadDbMailProfileData:async function(_ref){let{node:node}=_ref;const result=await this.executeDbListOperation({url:"DbList/GetMailProfileData",additionalRequestParams:{profileName:node.getDbMailProfileName()}});if(!result)throw new Error(KSWN.Locale.oshibka_zagruzki_pochtovogo_profilya);return result},saveDbMailProfile:async function(profile){const result=await this.executeDbListOperation({url:"DbList/SaveMailProfile",additionalRequestParams:{profileName:profile},sessionKey:this.getSessionKey()});if(!result)throw new Error(KSWN.Locale.erroshibkasozdaniyapochtovogoprofilya);return result.Fail&&KSWN.ExtAlert("KSWN.Locale.erroshibkasozdaniyapochtovogoprofilya <br> "+result.Message),!result.Fail},deleteMailProfile:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{if(!node.isAdminDbMailProfileNode())return;const L=KSWN.Locale,{profileName:profileName,accountName:accountName}=node.getDbMailProfileReqs(),result=await this.executeDbListOperation({url:"DbList/DeleteMailProfile",additionalRequestParams:{profileName:profileName,accountName:accountName},confirmStartMsg:L.formatString(L.vy_deistvitelno_hotite_udalit_profil_0_account_1,profileName,accountName),sessionKey:this.getSessionKey()});if(!result)throw new Error(L.erroshibkaudaleniyapochtovogoprofilya);result.Fail?KSWN.ExtUtils.Alert(L.erroshibkaudaleniyapochtovogoprofilya+res.Message||""):node.getDbNode().refreshBranch()}catch(err){this.handleOperationError(err)}},turnSwitchMailServer:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{if(!node.isAdminDbMailNode())return;const L=KSWN.Locale;if(!await this.executeDbListOperation({url:"DbList/TurnOnMailServer",addNodeDataToProxyCallParams:!1,taskName:L.vkluchenie_pochtovogo_servera,showFinishNotification:!0,node:node}))throw new Error(L.oshibka_vklucheniya_pochtovogo_servera);this.updateAdminDbMailState(node)}catch(err){this.handleOperationError(err)}},turnOffMailServer:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{if(!node.isAdminDbMailNode())return;const L=KSWN.Locale;if(!await this.executeDbListOperation({url:"DbList/TurnOffMailServer",addNodeDataToProxyCallParams:!1,taskName:L.vikluchenite_pochtovogo_servera,showFinishNotification:!0,node:node}))throw new Error(L.oshibka_viklucheniya_pochtovogo_servera);this.updateAdminDbMailState(node)}catch(err){this.handleOperationError(err)}},updateAdminDbMailState:async function(node){const L=KSWN.Locale,result=await this.executeDbListOperation({url:"DbList/CheckMailServerState",addNodeDataToProxyCallParams:!1,taskName:L.proverka_sostoyaniya_pochtovogo_servera,node:node});if(!result)throw new Error("#err#"+KSWN.Locale.oshibka_proverki_sostoyaniya_pochtovogo_servera);node[!result.Fail?"setAdminDbMailNodeTurnOn":"setAdminDbMailNodeTurnOff"](),await node.refreshBranch()}}),Ext.define("KSWN.core.dbManager.module.BackupDb",{backupDb:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const backupPath=await this.getDefaultBackupPath({node:node}),backupFileName=this.getDefaultBackupFileName({node:node}),isPgDataSource=this.isPgDataSourceType(),backupFormParams=await KSWN.core.dbManager.form.backupDb.Window.showWindow({formValues:{backupPathFieldDisabled:isPgDataSource,createDownloadUrlCheckboxVisible:!isPgDataSource,backupPath:backupPath,backupFileName:backupFileName},dbManager:this});if(!backupFormParams)return;const backupParams={dbName:node.getDbName(),backupFileName:backupFormParams.backupFileName,backupPath:backupFormParams.backupPath,saveOnServer:backupFormParams.saveOnServer};if(!await this.checkBackupSpace({node:node,backupParams:backupParams}))return;await this.doBackupDatabase({node:node,backupParams:backupParams})}catch(e){this.handleOperationError(e)}},getDefaultBackupPath:async function(_ref2){let{node:node}=_ref2;if(this.isMSSQLDataSourceType()){const result=await this.executeDbListOperation({modelMethod:"DefaultBackupPath",addNodeDataToProxyCallParams:!1,node:node});if(!result)throw new Error(KSWN.Locale.ne_udalos_opredelit_put_rezervnogo_kopirovaiya_po_umolchaniu);return result}return""},getDefaultBackupFileName:function(_ref3){let{node:node}=_ref3;const date=Ext.Date.format(new Date,"ymd_His");return`${node.getDbName()}_${date}.bak`},checkBackupSpace:async function(_ref4){let{node:node,backupParams:backupParams}=_ref4;const result=await this.executeDbListOperation({url:"DbList/CheckDataBaseBackupSpace",additionalRequestParams:{backupParams:backupParams},node:node});if(!result)throw new Error(KSWN.Locale.erroshibkaproverkisvobodnogomestanadiske);return this.processCheckSpaceResult(result)},doBackupDatabase:async function(_ref5){let{node:node,backupParams:backupParams}=_ref5;const L=KSWN.Locale,{dbName:dbName,backupFileName:backupFileName,saveOnServer:saveOnServer}=backupParams,result=await this.executeDbListOperation({url:"DbList/BackupDataBase",isLong:!0,showNotifications:!0,taskName:Ext.String.format(L.sozdanie_rezervnoy_kopii_bd_0,dbName),additionalRequestParams:{backupParams:backupParams},finishNotificationConfig:saveOnServer?{notSave:!0,description:"",events:{buttonclick:notify=>{KSWN.util.FileUtils.DownloadFile("DbList/DownloadErrorLogArchive",{fileName:backupFileName,key:this.getSessionKey()},!0,!0,!0,blob=>KSWN.util.FileUtils.SaveBlob(blob,backupFileName),"blob")}},buttonConfig:{text:KSWN.Locale.skachatfail},backupFileName:backupFileName}:null,node:node});if(result)return!result.Fail},copyDb:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const backupFilePath=await this.checkSourceDatabase({node:node}),dbFilesInfo=await this.getDbFilesInfo({node:node}),copyParams=await KSWN.core.dbManager.form.copyDb.Window.showWindow({formValues:{dbName:node.getDbName()+"_test",deleteTempFile:!0,backupFilePath:backupFilePath,dbFilesInfo:dbFilesInfo},dbManager:this});if(!copyParams)return;if(this.isMSSQLDataSourceType()){if(!await this.checkCopyDatabaseSpace({backupFilePath:copyParams.backupFilePath,filesInfoData:copyParams.filesInfoDataForCheck,node:node}))return}await this.doCopyDatabase({node:node,...copyParams}),this.refresh()}catch(e){this.handleOperationError(e)}},doCopyDatabase:async function(_ref6){let{node:node,dbName:dbName,deleteTempFile:deleteTempFile,filesInfoDataForCopy:filesInfoDataForCopy,backupFilePath:backupFilePath}=_ref6;const S=Ext.String,L=KSWN.Locale;if(!await this.executeDbListOperation({modelMethod:"CopyDataBase",isLong:!0,showNotifications:!0,taskName:Ext.String.format(L.sozdanie_testovoi_copii_bazi_danih_0,dbName),proxyCallParams:[dbName,deleteTempFile,null,filesInfoDataForCopy,backupFilePath],node:node}))throw new Error(S.format(L.oshibka_sozdaniya_testovoi_copii_bazi_danih_0,dbName))},checkSourceDatabase:async function(_ref7){let{node:node}=_ref7;const result=await this.executeDbListOperation({modelMethod:"CheckSourceDatabase",node:node});if(!result)throw new Error(KSWN.Locale.erroshibazaprosaraspolozheniyabazidannikh);return _.get(result,"Table[0].fd","")},getDbFilesInfo:async function(_ref8){let{node:node}=_ref8;const result=await this.executeDbListOperation({modelMethod:"GetDbFilesInfo",node:node});if(!result)throw new Error(KSWN.Locale.erroshibazaprosaraspolozheniyabazidannikh);return KSWN.util.DataUtils.GetDataFromTable(result.Tables[0]).map(item=>({path:item["имя файла"],name:item["логическое имя"],num:item.n,size:item["размер файла в мб"]}))},checkFilesExists:async function(_ref9){let{filesInfoData:filesInfoData,showFileExistError:showFileExistError=!1}=_ref9;const{size:size,get:get}=_,result=await this.executeDbListOperation({modelMethod:"CheckFilesExists",proxyCallParams:[filesInfoData],addNodeDataToProxyCallParams:!1});if(!result)throw new Error(KSWN.Locale.oshibka_proverki_sushestvovaniya_failov);let fileExist=!1,fileName="";return size(result.Table)>0&&(fileExist=!!get(result,"Table[0].column1"),fileName=get(result,"Table[0].column2")),fileExist&&showFileExistError&&KSWN.ExtUtils.Alert("#msg#"+Ext.String.format(KSWN.Locale.fail_0_uje_sushestvuet,fileName)),{fileExist:fileExist,fileName:fileName}},createBackupFilePath:async function(_ref10){let{dbName:dbName,backupFilePath:backupFilePath}=_ref10;const res=await Ajax({url:"DbList/CreateBackupFilePath",params:{backupFilePath:backupFilePath,dbName:dbName}});if(!res)throw new Error;return res},checkCopyDatabaseSpace:async function(_ref11){let{node:node,filesInfoData:filesInfoData,backupFilePath:backupFilePath}=_ref11;const result=await this.executeDbListOperation({modelMethod:"CheckCopyDatabaseSpace",proxyCallParams:[filesInfoData,backupFilePath],node:node});if(!result)throw new Error(KSWN.Locale.erroshibazaprosaraspolozheniyabazidannikh);return await this.processCheckSpaceResult(result)},restoreDb:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const backupsList=await this.getDbBackupsList({node:node}),isPgDataSourceType=this.isPgDataSourceType(),restoreDbParams=await this.showFormWindow({xtype:"ks-core-dbmanager-restoredb-window",formValues:{dbName:node.getDbName(),isPgDataSourceType:isPgDataSourceType,backupsList:backupsList}});if(!restoreDbParams)return;if(!isPgDataSourceType){if(await this.checkDbConnectionsExists({node:node}))return;if(!await this.checkRestoreDatabaseSpace({node:node,backupFileInfo:restoreDbParams.backupFileInfo}))return}this.doRestoreDb({node:node,restoreDbParams:restoreDbParams})}catch(err){this.handleOperationError(err)}},doRestoreDb:async function(_ref12){let{node:node,restoreDbParams:restoreDbParams}=_ref12;const L=KSWN.Locale,dbName=node.getDbName();if(!await this.executeDbListOperation({url:"DbList/RestoreDatabase",additionalRequestParams:{...restoreDbParams},addNodeDataToProxyCallParams:!1,isLong:!0,showNotifications:!0,notificationTaskName:L.formatString(L.vosstanovlenie_rezervnoy_kopii_bazi_danih_0,dbName),node:node}))throw new Error(L.formatString("#err#"+L.oshibka_vosstanovleniya_rezervnoy_kopii_bazi_danih_0,dbName));return!0},getDbBackupsList:async function(_ref13){let{node:node,dbName:dbName}=_ref13;const result=await this.executeDbListOperation({url:"DbList/GetDbBackupsList",additionalRequestParams:{dbName:node?node.getDbName():dbName},addNodeDataToProxyCallParams:!1,node:node});if(void 0===result)throw new Error(KSWN.Locale.erroshibkapolucheniyaspiskarezervnikhkopiibd);return result||[]},getBackupInfo:async function(_ref14){let{backupFilePath:backupFilePath}=_ref14;const result=await this.executeDbListOperation({url:"DbList/GetBackupInfo",additionalRequestParams:{backupFilePath:backupFilePath}});if(!result)throw new Error(KSWN.Locale.oshibka_zagruzki_informacii_backapa);return _.head(result)},getBackupFileInfo:async function(_ref15){let{backupFilePath:backupFilePath}=_ref15;const result=await this.executeDbListOperation({url:"DbList/GetBackupFileInfo",additionalRequestParams:{backupFilePath:backupFilePath}});if(!result)throw new Error(KSWN.Locale.oshibka_zagruzki_informacii_backapa);return result}}),Ext.define("KSWN.core.dbManager.module.BaseDbOperation",{renameDb:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName();let newDbName=await KSWN.util.ExtUtils.Prompt(L.pereimenovatbazudannikh,L.vveditenovoenaimenovanie,!1,dbName);if(!newDbName)return;if(newDbName=_.trim(newDbName),!newDbName||newDbName===dbName)return;if(await this.checkDbConnectionsExists({node:node}))return;await this.doDbRename({node:node,newDbName:newDbName}),await node.refreshSessionKey()}catch(err){this.handleOperationError(err)}},doDbRename:async function(_ref16){let{node:node,newDbName:newDbName}=_ref16;const L=KSWN.Locale,dbName=node.getDbName(),result=await this.executeDbListOperation({taskName:L.formatString(L.pereimenovanie_bazidanih_0,dbName),modelMethod:"RenameDatabase",proxyCallParams:[node.getDbName(),newDbName],addNodeDataToProxyCallParams:!1,showFinishNotification:!0});if(!result)throw new Error(L.formatString(L.oshibka_izmenenuya_imeni_bazi_dannih_0,dbName));if(result.Fail)throw new KSWN.util.ErrorInfo({Text:L.formatString(L.oshibka_izmenenuya_imeni_bazi_dannih_0,dbName),AddInfo:result.Message});node.setDbName(newDbName)},deleteDb:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName(),connectionsExists=await this.checkDbConnectionsExists({node:node});if(!await KSWN.core.CapchaForm.showWindow({message:L.formatString(L.vi_deystvitelno_hotite_udalit_bazu_0,dbName)}))return;if(connectionsExists)return;const result=await this.executeDbListOperation({modelMethod:"DeleteDatabase",taskName:L.formatString(L.udalenie_bd_0,dbName),showFinishNotification:!0,proxyCallParams:[dbName,null],addNodeDataToProxyCallParams:!1,useDbNodeSessionKey:!1,node:node});if(!result)throw new Error(L.formatString(L.oshbka_udaleniya_bazi_danih_0,dbName));if(result.Fail)throw new KSWN.util.ErrorInfo({Text:L.formatString(L.oshbka_udaleniya_bazi_danih_0,dbName),AddInfo:result.Message});this.refresh()}catch(err){this.handleOperationError(err)}},updateStatistic:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName();await this.executeDbListOperation({modelMethod:"UpdateStatisticDatabase",isLong:!0,taskName:L.formatString(L.obnovlenie_statistici_bazi_danih_0,dbName),confirmStartMsg:L.zapustit_proceduru_obnovleniya_statistici_bazi_danih,node:node})}catch(err){this.handleOperationError(err)}},indexDefragmentation:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName();if(!await this.executeDbListOperation({modelMethod:"IndexDefragmentation",taskName:L.formatString(L.defragmentaciya_indeksov_bazi_danih_0,dbName),isLong:!0,node:node}))throw new Error(L.formatString(L.oshibka_pri_defragmentacii_indeksov_bazy_dannyh_0,dbName))}catch(err){this.handleOperationError(err)}},reIndex:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName();if(!await this.executeDbListOperation({modelMethod:"ReindexDatabase",taskName:L.formatString(L.pereindeksacija_bazy_dannyh_0,dbName),isLong:!0,node:node}))throw new Error(L.formatString(L.oshibka_pereindeksacii_bazy_dannyh_0,dbName))}catch(err){this.handleOperationError(err)}},shrinkDatabase:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName();if(!await this.executeDbListOperation({modelMethod:"ShrinkDatabase",taskName:L.formatString(L.szhatie_bazy_dannyh_0,dbName),isLong:!0,confirmStartMsg:L.formatString(L.zapustit_proceduru_szhatija_bazy_dannyh_0,dbName),node:node}))throw new Error(L.formatString(L.oshibka_szhatija_bazy_dannyh_0,dbName))}catch(err){this.handleOperationError(err)}},checkDatabase:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName(),taskName=L.formatString(L.proverka_bazy_dannyh_0,dbName),result=await this.executeDbListOperation({modelMethod:"CheckDatabase",isLong:!0,confirmStartMsg:L.formatString(L.zapustit_proceduru_proverki_bazy_dannyh_0,dbName),finishNotificationConfig:{description:"",actions:{buttonclick:()=>KSWN.ExtUtils.ShowText(`<pre>${result.Message}</pre>`,{title:taskName})},buttonConfig:{text:KSWN.Locale.pokazatprotokol}},taskName:taskName,node:node});if(!result)throw new Error(L.formatString(L.oshibka_proverki_bazy_dannyh_0,dbName))}catch(err){this.handleOperationError(err)}},migrateDatabase:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName();if(!await this.executeDbListOperation({modelMethod:"CheckMigration",taskName:L.formatString(L.podgotovka_bazy_dannyh_k_migracii_0,dbName),isLong:!0,node:node}))throw new Error(L.formatString(L.oshibka_podgotovki_bazy_dannyh_k_migracii_0,dbName))}catch(err){this.handleOperationError(err)}},perfInformation:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName(),result=await this.executeDbListOperation({url:"DbList/GetPerformanceInformation",taskName:L.formatString(L.analiz_prizvoditelnosti_bd_0,dbName),finishNotificationConfig:{description:"",actions:{buttonclick:()=>{KSWN.util.FileUtils.SaveText(result,`performance-info-${dbName}_${(new Date).toLocaleString()}.xml`)}},buttonConfig:{text:KSWN.Locale.skachatrezultatanaliza}},node:node});if(!result)throw new Error(L.formatString(L.oshibka_pri_poluchenii_informacii_o_proizvoditelnosti_bazy_dannyh_0,dbName))}catch(err){this.handleOperationError(err)}},databaseProperties:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,dbName=node.getDbName(),taskName=L.formatString(L.analiz_svoistv_bd_0,dbName);let result=await this.executeDbListOperation({modelMethod:"ReadDatabaseProperty",proxyCallParams:["DataSource"],addNodeDataToProxyCallParams:!1,finishNotificationConfig:{description:"",actions:{buttonclick:()=>KSWN.ExtUtils.ShowText(result,{title:taskName})},buttonConfig:{text:KSWN.Locale.pokazatprotokol}},taskName:taskName,node:node});if(!result)throw new Error(L.formatString(L.oshibka_pri_poluchenii_svojstv_bazy_dannyh_0,dbName));const[beforeBody,body]=result.split("<body");result=beforeBody.replaceAll("\r\n","")+"<body"+body.replaceAll("\r\n","<br />")}catch(err){this.handleOperationError(err)}},setTraceStatus:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale;if(!node.isAdminServerNode())return;const traceStatus=node.getTraceStatus();if(null===traceStatus)return;const newTraceStatus=!traceStatus,confirmStartMsg=`${newTraceStatus?L.vklyuchit:L.viklyuchit} ${L.trassirovkuvzaimoblokirovok}`,res=await this.executeDbListOperation({modelMethod:"SetTraceStatus",taskName:L.perelyuchenietrassirovki,proxyCallParams:[newTraceStatus],addNodeDataToProxyCallParams:!1,confirmStartMsg:confirmStartMsg,node:node});res&&!res.Fail&&node.setMenuItemTraceStatus(newTraceStatus)}catch(err){this.handleOperationError(err)}}}),Ext.define("KSWN.core.dbManager.module.MessageServer",{createMessageServer:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{if(!node.isServerMessageNode())return;const dbNode=node.getDbNode(),dbName=dbNode.getDbName(),createParams=await this.showFormWindow({xtype:"ks-core-dbmanager-messageserver-create-window",formValues:{isPgDataSourceType:this.isPgDataSourceType(),dbName:dbName}});if(!createParams)return;const result=await this.doCreateMessageServer({createParams:createParams,node:dbNode});result&&(dbNode.refreshBranch(),!1===result.Fail&&await KSWN.meta.mail.Mail.enableMail(!0))}catch(err){this.handleOperationError(err)}},doCreateMessageServer:function(_ref17){let{node:node,createParams:createParams}=_ref17;const L=KSWN.Locale,dbName=node.getDbName();return this.executeDbListOperation({modelMethod:"CreateMessageServer",taskName:L.formatString(L.sozdanie_servera_soobsheniy_dlya_bazy_dannih_0,dbName),showFinishNotification:!0,proxyCallParams:[createParams.name,createParams.path,createParams.checkMessagesInterval,createParams.messageLifeTime],node:node})},detachMessageServer:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{const L=KSWN.Locale,messageServerName=node.getMessageServerName();if(!node.isServerMessageNode())return;if(!messageServerName)return KSWN.ExtUtils.Alert(L.errotsutstvuetserversoobshchenii);const dbNode=node.getDbNode(),dbName=dbNode.getDbName();dbNode.setMessageServerName(messageServerName);const result=await this.executeDbListOperation({modelMethod:"DetachMessageServer",taskName:L.formatString(L.otsoedinenie_servera_soobsheniy_dlya_bd_0,dbName),showFinishNotification:!0,node:dbNode});if(!result)return;!result.Fail&&node.isCurrentDb()&&KSWN.meta.mail.Mail.disableMail(),dbNode.refreshBranch()}catch(err){this.handleOperationError(err)}},attachMessageServer:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{if(!node.isServerMessageNode())return;const dbNode=node.getDbNode(),messageServersList=await this.searchMessageServers({node:dbNode}),messageServerName=await this.showFormWindow({xtype:"ks-core-dbmanager-form-messageserver-attach-window",formValues:{messageServersList:messageServersList}});if(!messageServerName)return;const result=await this.doAttachMessageServer({node:dbNode,messageServerName:messageServerName});result&&(dbNode.refreshBranch(),!1===result.Fail&&await KSWN.meta.mail.Mail.enableMail(!0))}catch(err){this.handleOperationError(err)}},doAttachMessageServer:async function(_ref18){let{node:node,messageServerName:messageServerName}=_ref18;const L=KSWN.Locale,dbName=node.getDbName(),result=await this.executeDbListOperation({modelMethod:"AttachMessageServer",taskName:L.formatString(L.podklyuchenie_servera_soobshchenii_k_baze_dannih_0,dbName),showFinishNotification:!0,proxyCallParams:[messageServerName],node:node});if(!result)throw new Error(L.formatString(L.oshibka_podklyucheniнф_servera_soobshchenii_k_baze_dannih_0,dbName));return result},searchMessageServers:async function(_ref19){let{node:node}=_ref19;const result=await this.executeDbListOperation({modelMethod:"SearchMessageServers",taskName:KSWN.Locale.zagruzkadostupnikhserverovsoobshchenii,node:node});if(!result)throw new Error(KSWN.Locale.oshibka_zagruzki_spiska_serverov_soobsheniy);return result.map(name=>({name:name}))},configMessageServer:async function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{if(!node.isServerMessageNode())return;const dbNode=node.getDbNode(),messageServerConfig=await this.loadMessageServerConfig({node:dbNode});if(!messageServerConfig)return;const editedMessageServerConfig=await this.showFormWindow({xtype:"ks-core-dbmanager-messageserver-config-window",formValues:{dbName:messageServerConfig.MessageServerName,messageLifeTime:messageServerConfig.MessageLifeDuration,checkMessagesInterval:messageServerConfig.ClientPollingInterval}});if(!editedMessageServerConfig)return;dbNode.setMessageServerName(node.getMessageServerName()),await this.updateMessageServerConfig({node:dbNode,messageServerConfig:editedMessageServerConfig})}catch(err){this.handleOperationError(err)}},loadMessageServerConfig:async function(_ref20){let{node:node}=_ref20;const L=KSWN.Locale,result=await this.executeDbListOperation({modelMethod:"LoadMessageServerConfig",taskName:L.zagruzkasvoistvoserverasoobshchenii,node:node});if(!result||!result.MessageServerName)throw new Error(L.oshibka_zagruzki_svoistv_servera_soobsheniy);return result},updateMessageServerConfig:async function(_ref21){let{node:node,messageServerConfig:messageServerConfig}=_ref21;const L=KSWN.Locale,dbName=node.getDbName(),result=await this.executeDbListOperation({modelMethod:"UpdateMessageServerConfig",taskName:L.formatString(L.obnovlenie_konfiguracii_servera_soobsheniy_0,dbName),showFinishNotification:!0,proxyCallParams:[messageServerConfig.checkMessagesInterval,messageServerConfig.messageLifeTime],node:node});if(!result)throw new Error(L.oshibka_pri_sohranenii_konfiguracii_servera_soobshhenij);return result}}),Ext.define("KSWN.core.dbManager.module.PrimaryDocumentServer",{createPrimaryDocumentServer:async function(_ref22){let{node:node=this.getSelectedDbListNode()}=_ref22;try{if(!node.isPrimaryDocumentServerNode())return;const dbNode=node.getDbNode(),createParams=await this.showFormWindow({xtype:"ks-core-dbmanager-form-primarydocumentserver-window",formValues:{dbName:dbNode.getDbName(),isPgDataSourceType:this.isPgDataSourceType()}});if(!createParams)return;await this.doCreatePrimaryDocumentServer({node:dbNode,createParams:createParams})&&dbNode.refreshBranch()}catch(err){this.handleOperationError(err)}},doCreatePrimaryDocumentServer:async function(_ref23){let{node:node,createParams:createParams}=_ref23;const L=KSWN.Locale,dbName=node.getDbName(),result=await this.executeDbListOperation({modelMethod:"CreatePrimaryDocumentsServer",taskName:L.formatString(L.sozdanie_hranilisha_pervichnih_documentov_dlya_bd_0,dbName),showFinishNotification:!0,proxyCallParams:[createParams.mode,createParams.serverName,createParams.primaryDocumentServerName,createParams.remoteUsername,createParams.remotePassword,createParams.primaryDocumentServerPath],node:node});if(!result)throw new Error(L.formatString(L.oshibka_sozdaniya_hranilisha_pervichnih_documentov_dlya_bd_0));return result},deletePrimaryDocumentServer:async function(_ref24){let{node:node=this.getSelectedDbListNode()}=_ref24;try{if(!node.isPrimaryDocumentServerNode())return;const L=KSWN.Locale,dbNode=node.getDbNode(),dbName=dbNode.getDbName();if(!await this.executeDbListOperation({modelMethod:"DeletePrimaryDocumentsServer",node:dbNode,taskName:L.formatString(L.udalenie_hranilisha_pervichnih_documentov_dlya_bd_0,dbName),showFinishNotification:!0,confirmStartMsg:L.deletePrimaryDocumentsServerMessage}))throw new Error(L.formatString(L.oshibka_udaleniya_hranilisha_pervichnih_documentov_dlya_bd_0,dbName));dbNode.refreshBranch()}catch(err){this.handleOperationError(err)}}}),Ext.define("KSWN.core.dbManager.module.ServerErrorLog",{serverErrorLog:function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();try{if(!node.isAdminServerNode())return;this.showFormWindow({xtype:"ks-core-dbmanager-form-servererrorlog-window"})}catch(err){this.handleOperationError(err)}},downloadCurrentServerErrorLog:async function(){const result=await this.executeDbListOperation({url:"DbList/GetCurrentServerErrorLog",sessionKey:this.getSessionKey()});if(!result)throw new Error(KSWN.Locale.oshibka_zagruzki_loga_oshibok_servera);return this.doDownloadErrorLogFile(result)},downloadAllServerErrorLog:async function(){const result=await this.executeDbListOperation({url:"DbList/GetServerAllErrorLogs",sessionKey:this.getSessionKey()});if(!result)throw new Error(KSWN.Locale.oshibka_zagruzki_loga_oshibok_servera);return this.doDownloadErrorLogFile(result)},doDownloadErrorLogFile:function(resultFileName){let fileName="ERRORLOG";return KSWN.util.FileUtils.DownloadFile("DbList/DownloadErrorLogArchive",{fileName:resultFileName,key:this.getSessionKey()},!0,!0,!0,blob=>{0!==Ext.firefoxVersion&&(fileName+=".zip"),KSWN.util.FileUtils.SaveBlob(blob,fileName)},"blob"),fileName}}),Ext.define("KSWN.core.dbManager.navigator.SqlAdminNodeType",{singleton:!0,NODE_NONE:0,NODE_SQL_ADMIN_SERVER:1e4,NODE_SQL_ADMIN_DATABASES:10001,NODE_SQL_ADMIN_DATABASE:10002,NODE_SQL_ADMIN_USERS:10003,NODE_SQL_ADMIN_USERGROUPS:10004,NODE_SQL_ADMIN_TASKS:10005,NODE_SQL_ADMIN_LOGIN_AUDIT:10006,NODE_SQL_ADMIN_LOGIN_BLOCKED_AUDIT:10007,NODE_SQL_ADMIN_SERVER_REPORT:10008,NODE_SQL_ADMIN_SERVER_MESSAGE:10009,NODE_SQL_ADMIN_SERVER_PRIMARYSTORAGE:10010,NODE_SQL_ADMIN_NOT_BKS_DATABASE:10011,NODE_SQL_ADMIN_DUMMY:10012,NODE_SQL_ADMIN_USER_DISABLED:10013,NODE_SQL_ADMIN_GROUPADMIN:10014,NODE_SQL_ADMIN_CONNECTIONPOOL:10015,NODE_SQL_ADMIN_ERROR_RESTORE_DATABASE:10017,NODE_SQL_ADMIN_DATABASE_MAIL:10018,NODE_SQL_ADMIN_DATABASE_MAIL_PROFILE:10019,NODE_SQL_ADMIN_DATABASE_MAIL_EMPTY:10020,NODE_SQL_ADMIN_DATABASE_MAIL_DEPRICATED:10021,NODE_SQL_ADMIN_DATABASE_OFFLINE:10022,NODE_SQL_ADMIN_MESSAGE_DATABASE:10023,NODE_SQL_ADMIN_WORKSCHEDULER:10024,NODE_SQL_ADMIN_OBJECT_EDITOR:10025}),Ext.define("KSWN.core.dbManager.dbListModelOperation.Collection",{extend:"Ext.util.Collection",keyFn:operation=>operation.getId(),createOperation:function(params){const operation=new KSWN.core.dbManager.dbListModelOperation.Operation(params);return this.add(operation),operation.source=this,operation},hasActiveOperations:function(){return this.count()>0},onOperationStart:function(operation){this.fireEvent("operationstart",this,operation)},onOperationFinish:function(operation){this.fireEvent("operationfinish",this,operation)},onOperationDestroy:function(operation){this.remove(operation),this.fireEvent("operationdestroy",this,operation)}}),Ext.define("KSWN.core.dbManager.dbListModelOperation.Operation",{source:null,isLong:!1,sessionKey:null,confirmStartMsg:null,node:null,modelMethod:null,taskName:"",startNotificationConfig:null,finishNotificationConfig:null,showFinishNotification:!1,errorMessage:"",addNodeDataToProxyCallParams:!0,additionalRequestParams:{},proxyCallParams:[],useDbNodeSessionKey:!0,url:"DbList/ModelProxy",constructor:function(config){return this.initConfig(config),this.isLong&&!this.confirmStartMsg&&(this.confirmStartMsg=KSWN.Locale.vipolnenieoperatsiimozhetzanyatprodolzhitelnoevremyaprodolzhit),this.node&&(this.nodeData=this.node.getData()),this},getId:function(){return this.id||(this.id=Ext.id(this,this.$className))},getDbName:function(){var _this$node;return null===(_this$node=this.node)||void 0===_this$node?void 0:_this$node.getDbName()},getNodeSessionKey:function(){var _this$node2;return(null===(_this$node2=this.node)||void 0===_this$node2?void 0:_this$node2.getDbSessionKey())||this.sessionKey},getExecuteParams:function(){const{node:node,additionalRequestParams:additionalRequestParams,useDbNodeSessionKey:useDbNodeSessionKey,sessionKey:sessionKey}=this;let paramsList=this.proxyCallParams;this.addNodeDataToProxyCallParams&&node&&(paramsList=[{stype:"SqlAdminParam",value:JSON.stringify(node.getData())}].concat(paramsList));const key=node&&useDbNodeSessionKey?this.getNodeSessionKey():sessionKey;return{task:this.modelMethod,paramsList:paramsList,key:key,...additionalRequestParams}},execute:function(){const{url:url}=this,params=this.getExecuteParams();return KSWN.getConnection().Ajax({url:url,params:params})},run:async function(){if(!1===await this.confirmStart())return null;this.onBeforeStart();const response=await this.execute();return this.onFinish(response),response},confirmStart:async function(){let confirm=!0;const{confirmStartMsg:confirmStartMsg}=this;return confirmStartMsg&&(confirm=await KSWN.ExtUtils.AsyncConfirm({title:KSWN.Locale.podtverzhdenie,message:confirmStartMsg})),confirm},onBeforeStart:function(){(this.startNotificationConfig||this.isLong)&&this.showNotification({title:this.getStartNotificationTitle(),...this.startNotificationConfig}),this.callSourceMethod("onOperationStart")},onFinish:function(result){(this.showFinishNotification||this.finishNotificationConfig||this.isLong)&&void 0!==result&&this.showNotification({title:this.getFinishNotificationTitle(),description:(null==result?void 0:result.Message)||"",...this.finishNotificationConfig}),this.callSourceMethod("onOperationFinish")},showNotification:function(params){params.type="database",params.savable=params.savable??!1,KSWN.app.showNotification(params)},getNodeId:function(){var _this$nodeData;return null===(_this$nodeData=this.nodeData)||void 0===_this$nodeData?void 0:_this$nodeData.id},getTaskName:function(){return this.taskName},destroy:function(){this.callSourceMethod("onOperationDestroy"),this.source=null,this.callParent()},callSourceMethod:function(methodName){const{source:source}=this;source&&!source.destroyed&&source[methodName](this)},getStartNotificationTitle:function(){const L=KSWN.Locale,{taskName:taskName}=this;return taskName?L.formatString(L.zapushena_operaciya_0,taskName):L.zapushchenaoperatsiya},getFinishNotificationTitle:function(){const L=KSWN.Locale,{taskName:taskName}=this;return taskName?L.formatString(L.zavershena_operaciya_0,taskName):L.zavershenaoperatsiya}}),Ext.define("KSWN.core.dbManager.form.base.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-core-dbmanager-form",formResolved:!1,init:function(){const{formValues:formValues}=this.getView();this.getViewModel().set(formValues)},onSaveBtnClick:function(){this.resolveForm()},onViewBeforeDestroy:function(){this.formResolved||this.callResolveFn(!1)},onCancelBtnClick:function(){this.view.destroy()},resolveForm:async function(){if(!1===await this.onBeforeFormResolve())return;const form=this.getForm();this.formResolved=!0;const formValues=await form.getFormValues();this.callResolveFn(formValues),this.view.close()},onBeforeFormResolve:function(){return this.getForm().isValid()},callResolveFn:function(result){this.view.resolveFn(result)},showServerExplorer:function(){let config=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return config.sessionKey=this.getSessionKey(),KSWN.core.serverExplorer.Window.showDbExplorerWindow(config)},getForm:function(){return this.lookupReference("form")},getSessionKey:function(){const session=this.getSession();return(null==session?void 0:session.key)??null},getSession:function(){const{dbManager:dbManager}=this.getView();return dbManager.getSession()}}),Ext.define("KSWN.core.dbManager.form.base.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-core-dbmanager-form",data:{saveBtnText:KSWN.Locale.cozdat,cancelBtnText:KSWN.Locale.otmena,saveBtnDisabled:!1,cancelBtnDisabled:!1,loading:!1},formulas:{},stores:{},getSession:function(){return this.getView().getSession()},getDbManager:function(){return this.getView().getDbManager()},setViewLoading:function(loading){this.set({loading:loading})}}),Ext.define("KSWN.core.dbManager.form.base.Form",{extend:"Ext.form.Panel",border:0,reference:"form",getFormValues:function(){return{}}}),Ext.define("KSWN.core.dbManager.form.base.Window",{extend:"Ext.window.Window",inheritableStatics:{showWindow:function(_ref25){let{formConfig:formConfig,formValues:formValues={},dbManager:dbManager}=_ref25;const Window=this,config={autoShow:!0,formValues:formValues,dbManager:dbManager};return formConfig&&(config.items=formConfig),new Promise(resolve=>(config.resolveFn=resolve,new Window(config)))}},viewModel:"ks-core-dbmanager-form",controller:"ks-core-dbmanager-form",closeAction:"destroy",modal:!0,bodyPadding:4,autoMaxHeight:!0,listeners:{beforedestroy:"onViewBeforeDestroy"},buttons:[{handler:"onSaveBtnClick",bind:{text:"{saveBtnText}",disabled:"{saveBtnDisabled}"}},{handler:"onCancelBtnClick",bind:{text:"{cancelBtnText}",disabled:"{cancelBtnDisabled}"}}],bind:{loading:"{loading}"},getSessionKey:function(){return this.dbManager.getSessionKey()},getSession:function(){return this.dbManager.session},getDbManager:function(){return this.dbManager}}),Ext.define("KSWN.core.dbManager.form.copyDb.store.FileInfo",{extend:"Ext.data.Model",fields:[{name:"path",type:"string"},{name:"name",type:"string"},{name:"size",type:"number"},{name:"num",type:"int"}],setDbName:function(dbName){const FU=KSWN.util.FileUtils;let path=this.get("path");path=`${FU.GetDirectoryName(path)}\\${dbName}.${FU.GetFileExtension(path)}`,this.set({path:path})},getFileInfo:function(){const d=this.data;return{path:d.path,name:d.name,size:d.size,n:d.num}}}),Ext.define("KSWN.core.dbManager.form.copyDb.store.FilesInfo",{extend:"Ext.data.Store",alias:"store.ks-core-dbmanager-copydb-store-filesinfo",model:"KSWN.core.dbManager.form.copyDb.store.FileInfo",getFilesInfo:function(){return this.getRange().map(rec=>rec.getFileInfo())},getFilesInfoDataForCheck:function(){const dict=this.getFilesInfo().reduce((obj,info)=>(obj[info.path]=info.size,obj),{});return{stype:"DBListFilesInfoForCheck",value:JSON.stringify(dict)}},getFilesInfoDataForCopy:function(){const dict=this.getFilesInfo().reduce((obj,info)=>(obj[info.name]=info.path,obj),{});return{stype:"DBListFilesInfoForCopy",value:JSON.stringify(dict)}},updateFilesPaths:function(dbName){this.getRange().forEach(fileInfo=>fileInfo.setDbName(dbName))},checkFilesPathsUniq:function(){const filesPaths=this.getFilesInfo().map(_ref26=>{let{path:path}=_ref26;return path.toLowerCase()});return KSWN.Utils.IsUniqArrayValues(filesPaths)}}),Ext.define("KSWN.core.dbManager.form.copyDb.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-copydb",onDbSourceTextfieldExplorerTriggerClick:async function(){const path=await this.showServerExplorer({showOnlyFolders:!0});!1!==path&&this.getViewModel().set("backupFilePath",path)},onFilesInfoGridRowClick:async function(grid,record){const path=await this.showServerExplorer();!1!==path&&record.set({path:path})},onBeforeFormResolve:async function(){return!this.getViewModel().getDbManager().isMSSQLDataSourceType()||(this.isFilesPathsUniq()?this.checkFilesExist():(KSWN.ExtUtils.Alert("#msg#"+KSWN.Locale.imena_failov_doljni_bit_unikalnimy),!1))},onDbNameFieldChange:function(field,dbName){var _this$getFilesInfoSto;null===(_this$getFilesInfoSto=this.getFilesInfoStore())||void 0===_this$getFilesInfoSto||_this$getFilesInfoSto.updateFilesPaths(dbName)},isFilesPathsUniq:function(){return this.getFilesInfoStore().checkFilesPathsUniq()},checkFilesExist:async function(){const dbManager=this.getViewModel().getDbManager(),filesInfoData=this.getFilesInfoStore().getFilesInfoDataForCheck();try{const{fileExist:fileExist}=await dbManager.checkFilesExists({filesInfoData:filesInfoData,showFileExistError:!0});return!fileExist}catch{return!1}},getFilesInfoStore:function(){return this.getViewModel().get("filesInfoStore")}}),Ext.define("KSWN.core.dbManager.form.copyDb.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-copydb",data:{backupFilePath:"",dbFilesInfo:[],deleteTempFile:!0},stores:{filesInfoStore:{type:"ks-core-dbmanager-copydb-store-filesinfo",data:"{dbFilesInfo}"}}}),Ext.define("KSWN.core.dbManager.form.copyDb.Form",{extend:"KSWN.core.dbManager.form.base.Form",xtype:"ks-core-dbmanager-copydb-form",reference:"form",width:600,layout:{type:"vbox",align:"stretch"},items:[{xtype:"fieldcontainer",flex:0,layout:{type:"vbox",align:"stretch"},defaultType:"textfield",defaults:{labelAlign:"top",labelSeparator:""},items:[{fieldLabel:KSWN.Locale.imyatestovoibazi,allowBlank:!1,listeners:{change:"onDbNameFieldChange"},bind:{value:"{dbName}"}},{fieldLabel:KSWN.Locale.putdlyarazmeshcheniyafailarezervnoikopiiotnositelnoserverabd,name:"backupFilePath",allowBlank:!1,bind:{value:"{backupFilePath}"},triggers:{explorer:{cls:"ks-icon-folder_open",handler:"onDbSourceTextfieldExplorerTriggerClick"}}}]},{xtype:"grid",reference:"filesInfoGrid",flex:0,height:200,title:KSWN.Locale.putdlyarazmeshcheniyafailovbdotnositelnoserverabd,viewConfig:{markDirty:!1},columns:[{dataIndex:"path",text:"Имя файла",flex:2},{dataIndex:"name",text:"Логическое имя",flex:1},{dataIndex:"size",text:"Размер файла в Мб",flex:1}],listeners:{rowclick:"onFilesInfoGridRowClick"},bind:{store:"{filesInfoStore}"}},{xtype:"container",flex:0,margin:"12 0 0 0",items:[{xtype:"checkbox",boxLabel:KSWN.Locale.udalitpromezhutochniifailrezervnoikopii,bind:{value:"{deleteTempFile}"}}]}],getFormValues:async function(){const vm=this.lookupViewModel(),dbManager=vm.getDbManager(),filesInfoDataForCheck=vm.get("filesInfoStore").getFilesInfoDataForCheck(),filesInfoDataForCopy=vm.get("filesInfoStore").getFilesInfoDataForCopy();let{dbName:dbName,backupFilePath:backupFilePath,deleteTempFile:deleteTempFile}=vm.getData();return backupFilePath=await dbManager.createBackupFilePath({dbName:dbName,backupFilePath:backupFilePath}),{filesInfoDataForCheck:filesInfoDataForCheck,filesInfoDataForCopy:filesInfoDataForCopy,dbName:dbName,deleteTempFile:deleteTempFile,backupFilePath:backupFilePath}}}),Ext.define("KSWN.core.dbManager.form.copyDb.Window",{extend:"KSWN.core.dbManager.form.base.Window",xtype:"ks-core-dbmanager-copydb-window",viewModel:"ks-core-dbmanager-copydb",controller:"ks-core-dbmanager-copydb",title:KSWN.Locale.sozdanietestovoikopiibazinaosnovevibrannoi,items:[{xtype:"ks-core-dbmanager-copydb-form"}]}),Ext.define("KSWN.core.dbManager.form.backupDb.Window",{extend:"KSWN.core.dbManager.form.base.Window",xtype:"ks-core-dbmanager-backupdb-window",viewModel:"ks-core-dbmanager-form-backupdb",controller:"ks-core-dbmanager-form-backupdb",title:KSWN.Locale.sozdanierezervnoikopiibazidannikh,items:[{xtype:"ks-core-dbmanager-backupdb-form"}]}),Ext.define("KSWN.core.dbManager.form.backupDb.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-form-backupdb",onBackupPathTextfieldExplorerTriggerClick:async function(){const path=await this.showServerExplorer({showOnlyFolders:!0});!1!==path&&this.getViewModel().set("backupPath",path)}}),Ext.define("KSWN.core.dbManager.form.backupDb.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-form-backupdb",data:{backupPath:"",backupPathFieldDisabled:!1,backupFileName:"",createDownloadUrl:!1,createDownloadUrlCheckboxVisible:!0}}),Ext.define("KSWN.core.dbManager.form.backupDb.Form",{extend:"KSWN.core.dbManager.form.base.Form",xtype:"ks-core-dbmanager-backupdb-form",reference:"form",width:600,layout:{type:"vbox",align:"stretch"},defaults:{labelAlign:"top",labelSeparator:""},items:[{xtype:"textfield",fieldLabel:KSWN.Locale.putdlyarazmeshcheniyafailarezervnoikopiiotnositelnoserverabd,allowBlank:!1,triggers:{explorer:{cls:"ks-icon-folder_open",handler:"onBackupPathTextfieldExplorerTriggerClick"}},bind:{value:"{backupPath}",disabled:"{backupPathFieldDisabled}"}},{xtype:"textfield",fieldLabel:KSWN.Locale.imyafailarezervnoikopii,allowBlank:!1,vtype:"dataBaseName",bind:{value:"{backupFileName}"}},{xtype:"container",flex:0,margin:"12 0 0 0",items:[{xtype:"checkbox",boxLabel:KSWN.Locale.sformirovat_ssilku_dlya_skachivaniya,bind:{value:"{createDownloadUrl}"}}],bind:{hidden:"{!createDownloadUrlCheckboxVisible}"}}],getFormValues:function(){const{backupPath:backupPath,backupFileName:backupFileName,createDownloadUrl:createDownloadUrl}=this.lookupViewModel().getData();return{saveOnServer:createDownloadUrl,backupPath:backupPath,backupFileName:backupFileName}}}),Ext.define("KSWN.core.dbManager.form.restoreDb.model.Backup",{extend:"Ext.data.Model",fields:[{name:"physical_device_name",type:"string"}],getBackupFilePath:function(){return this.data.physical_device_name}}),Ext.define("KSWN.core.dbManager.form.restoreDb.view.BackupFileInfoWindow",{extend:"Ext.window.Window",statics:{showBackupFileInfo:function(_ref27){let{backupFileInfo:backupFileInfo}=_ref27;return!!backupFileInfo&&new Promise(resolve=>{new KSWN.core.dbManager.form.restoreDb.view.BackupFileInfoWindow({closeAction:"destroy",resolveFn:resolve,backupFileInfo:backupFileInfo}).show()})}},title:KSWN.Locale.soderzhaniefaila,modal:!0,isResolved:!1,resolveFn:Ext.emptyFn,defaultListenerScope:!0,layout:"fit",width:600,height:370,items:[{xtype:"grid",header:!1,itemId:"grid",selModel:"cellmodel",plugins:{ptype:"cellediting",clicksToEdit:1},columns:[{text:KSWN.Locale.logicheskoeimya,dataIndex:"logicalname",flex:1,readOnly:!0},{text:KSWN.Locale.fizicheskoeimya,dataIndex:"physicalname",flex:3,editor:{completeOnEnter:!1,field:{xtype:"textfield",allowBlank:!1}}}]}],buttons:[{text:KSWN.Locale.ok,handler:"onOkBtnClick"},{text:KSWN.Locale.otmena,handler:"onCancelBtnClick"}],onOkBtnClick:function(){this.resolveBackupFile(this.getBackupFileInfoResult()),this.destroy()},onCancelBtnClick:function(){this.destroy()},initComponent:function(){this.callParent(),this.initBackupFileInfoGrid()},initBackupFileInfoGrid:function(){const{backupFileInfo:backupFileInfo}=this,grid=this.getGrid(),store=new Ext.data.Store({data:backupFileInfo});grid.setStore(store)},getGrid:function(){return this.getComponent("grid")},getStore:function(){return this.getGrid().getStore()},getBackupFileInfoResult:function(){return this.getStore().getRange().map(rec=>{const data=rec.getData();return delete data.id,data})},resolveBackupFile:function(result){this.resolveFn(result)},destroy:function(){this.isResolved||this.resolveBackupFile(!1),this.callParent()}}),Ext.define("KSWN.core.dbManager.form.restoreDb.view.BackupFileInfoPropertyGrid",{extend:"Ext.grid.property.Grid",xtype:"ks-core-dbmanager-form-restoredb-view-backupfileinfopropertygrid",title:KSWN.Locale.informatsiya,scrollable:"y",nameColumnWidth:250,source:{},sourceConfig:{collation:{displayName:KSWN.Locale.slicheniesollation},databasecreationdate:{displayName:KSWN.Locale.datasozdaniya,renderer:function(v){const date=new Date(v);return date&&date.getDate()?date.toLocaleString():""},editor:!1},recoverymodel:{displayName:KSWN.Locale.modelvosstanovleniya},servername:{displayName:KSWN.Locale.server},backupsize:{displayName:KSWN.Locale.razmer,renderer:v=>v>0?Ext.util.Format.fileSize(v):""}}}),Ext.define("KSWN.core.dbManager.form.restoreDb.view.LatestBackupFilesGrid",{extend:"Ext.grid.Panel",xtype:"ks-core-dbmanager-form-restoredb-view-latestbackupfilesgrid",scrollable:"y",title:KSWN.Locale.informatsiyaoposlednikhrezervnikhkopiyakh,header:!0,margin:0,padding:0,selModel:{selType:"rowmodel",mode:"SINGLE"},columns:[{text:KSWN.Locale.fizicheskoeimyafaila,dataIndex:"physical_device_name",flex:3},{text:KSWN.Locale.razmerb,xtype:"numbercolumn",format:"0,000",dataIndex:"backup_size",align:"right",flex:1},{text:KSWN.Locale.nachalnoevremya,dataIndex:"backup_start_date",flex:1},{text:KSWN.Locale.konechnoevremya,dataIndex:"backup_finish_date",flex:1}]}),Ext.define("KSWN.core.dbManager.form.restoreDb.Form",{extend:"KSWN.core.dbManager.form.base.Form",xtype:"ks-core-dbmanager-restoredb-form",reference:"form",width:"100%",layout:{type:"vbox",align:"stretch"},items:[{xtype:"fieldcontainer",layout:"vbox",defaultType:"textfield",defaults:{labelAlign:"top",labelSeparator:"",width:"100%"},flex:0,items:[{fieldLabel:KSWN.Locale.putiimyafailarezervnoikopiiotnositelnoserverabd,allowBlank:!1,editable:!1,triggers:{explorer:{cls:"ks-icon-folder_open",handler:"onBackupPathTextfieldExplorerTriggerClick"}},listeners:{change:"onBackupFilePathTextFieldChange"},bind:{value:"{backupFilePath}",disabled:"{isPgDataSourceType}"}},{fieldLabel:KSWN.Locale.vosstanovitbazudannikhkak,allowBlank:!1,bind:{value:"{dbName}"}},{xtype:"checkbox",boxLabel:KSWN.Locale.vosstanovitpolzovatelei,bind:{value:"{restoreUsers}"}}]},{xtype:"ks-core-dbmanager-form-restoredb-view-latestbackupfilesgrid",flex:1,minHeight:250,listeners:{select:"onBackupsListGridSelect"},bind:{selection:"{selectedBackup}",store:"{backupsListStore}"}},{xtype:"ks-core-dbmanager-form-restoredb-view-backupfileinfopropertygrid",flex:1,minHeight:100,bind:{source:"{backupInfoSource}"}}],getFormValues:function(){return this.lookupViewModel().getDbRestoreParams()}}),Ext.define("KSWN.core.dbManager.form.restoreDb.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-restoredb",onBackupPathTextfieldExplorerTriggerClick:async function(){const backupFilePath=await this.showServerExplorer();!1!==backupFilePath&&this.getViewModel().set({backupFilePath:backupFilePath})},onBackupsListGridSelect:function(grid,record){this.getViewModel().set({backupFilePath:(null==record?void 0:record.getBackupFilePath())||""})},onBackupFilePathTextFieldChange:function(){this.loadBackupInfo()},onBeforeFormResolve:async function(){const window=KSWN.core.dbManager.form.restoreDb.view.BackupFileInfoWindow,vm=this.getViewModel();if(!await this.confirmDbRestoreFromBackup())return!1;if(vm.getDbManager().isPgDataSourceType())return!0;await this.loadBackupFileInfo();const backupFilesInfo=await window.showBackupFileInfo({backupFileInfo:vm.getBackupFileInfo()});if(!backupFilesInfo)return!1;vm.setBackupFileInfo(backupFilesInfo)},confirmDbRestoreFromBackup:function(){const L=KSWN.Locale,S=Ext.String,EU=KSWN.util.ExtUtils,vm=this.getViewModel(),{dbName:dbName}=vm.getData();return vm.isEmptyBackupFilePath()?(EU.Alert("#msg#"+L.ne_ukazani_puti_i_fail_rezervnoy_kopii_dlya_vosstanovleniya),!1):EU.AsyncConfirm({title:L.vnimanie,message:S.format(L.proizvesti_vosstanovlenie_bazi_dannih_0_eto_dejstvie_mojet_perezapisat_sushestvuyushuu_bazy,dbName)})},loadBackupInfo:async function(){const vm=this.getViewModel(),dbManager=vm.getDbManager(),backupFilePath=vm.getBackupFilePath();if(backupFilePath)try{vm.setViewLoading(!0);const backupInfo=await dbManager.getBackupInfo({backupFilePath:backupFilePath});vm.setBackupInfo(backupInfo)}catch(e){dbManager.handleOperationError(e),vm.clearBackup()}finally{vm.setViewLoading(!1)}else vm.clearBackupInfo()},loadBackupFileInfo:async function(){const vm=this.getViewModel(),dbManager=vm.getDbManager(),backupFilePath=vm.getBackupFilePath();try{vm.setViewLoading(!0);const result=await dbManager.getBackupFileInfo({backupFilePath:backupFilePath});vm.setBackupFileInfo(result)}catch(err){dbManager.handleOperationError(err)}finally{vm.setViewLoading(!1)}}}),Ext.define("KSWN.core.dbManager.form.restoreDb.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-restoredb",data:{saveBtnText:"Восстановить",backupFilePath:"",dbName:"",restoreUsers:!1,isPgDataSourceType:!1,selectedBackup:null,backupsList:[],backupInfo:null,backupFileInfo:null},formulas:{backupInfoSource:{bind:{bindTo:"{backupInfo}"},get:function(backupInfo){return _.pick(backupInfo,["databasecreationdate","recoverymodel","servername","backupsize"])}},saveBtnDisabled:{bind:{bindTo:"{hasBackupForRestore}"},get:function(hasBackupForRestore){return!hasBackupForRestore}},hasBackupForRestore:{bind:{bindTo:"{backupInfo}"},get:function(backupInfo){return!!backupInfo}}},stores:{backupsListStore:{model:"KSWN.core.dbManager.form.restoreDb.model.Backup",data:"{backupsList}"}},getDbRestoreParams:function(){const data=this.getData();return{backupFileInfo:data.backupFileInfo,dbName:data.dbName,backupFilePath:data.backupFilePath,restoreUsers:data.restoreUsers}},clearBackup:function(){this.clearBackupFilePath(),this.clearBackupInfo(),this.clearBackupsListGridSelection()},clearBackupFilePath:function(){this.setBackupFilePath("")},isEmptyBackupFilePath:function(){return""===_.trim(this.getBackupFilePath())},getBackupFilePath:function(){return this.get("backupFilePath")},setBackupFilePath:function(backupFilePath){this.set({backupFilePath:backupFilePath})},clearBackupInfo:function(){this.setBackupInfo(null)},setBackupInfo:function(backupInfo){this.set({backupFileInfo:null,backupInfo:backupInfo})},clearBackupsListGridSelection:function(){this.set("selectedBackup",null)},getBackupFileInfo:function(){return this.get("backupFileInfo")},setBackupFileInfo:function(backupFileInfo){this.set({backupFileInfo:backupFileInfo})}}),Ext.define("KSWN.core.dbManager.form.restoreDb.Window",{extend:"KSWN.core.dbManager.form.base.Window",xtype:"ks-core-dbmanager-restoredb-window",viewModel:"ks-core-dbmanager-restoredb",controller:"ks-core-dbmanager-restoredb",title:KSWN.Locale.vosstanovlenierezervnoikopiibazidannikh,autoHeight:!0,layout:"fit",autoWidth:!0,items:[{xtype:"ks-core-dbmanager-restoredb-form"}]}),Ext.define("KSWN.core.dbManager.form.messageServer.ProLicenseOnlyLabel",{extend:"Ext.container.Container",xtype:"ks-core-dbmanager-form-messageserver-prolicenseonlylabel",layout:"fit",padding:"0 10",items:[{xtype:"displayfield",value:"*"+KSWN.Locale.rejim_dostupen_tolko_v_versii_pro}]}),Ext.define("KSWN.core.dbManager.form.messageServer.ConfigFieldset",{extend:"Ext.form.FieldSet",xtype:"ks-core-dbmanager-form-messageserver-configfieldset",title:KSWN.Locale.nastroikaserverasoobshchenii,layout:{type:"vbox",align:"stretch"},padding:10,items:[{xtype:"fieldcontainer",layout:{type:"hbox",align:"center"},items:[{xtype:"label",flex:1,maxWidth:250,text:KSWN.Locale.intervaloprosaagentaklientasek,forId:"queryInterval",margin:"0 8 0 0"},{xtype:"numberfield",inputId:"queryInterval",maxWidth:70,flex:1,minValue:60,maxValue:10800,step:10,cycle:!0,bind:{value:"{checkMessagesInterval}"}}]},{xtype:"fieldcontainer",layout:{type:"hbox",align:"center"},items:[{xtype:"label",flex:1,maxWidth:250,text:KSWN.Locale.vremya_jizni_soobsheniy_dney,forId:"lifetime",margin:"0 8 0 0"},{xtype:"numberfield",inputId:"lifetime",maxWidth:70,flex:1,minValue:1,maxValue:365,step:1,bind:{value:"{messageLifeTime}"}}]}]}),Ext.define("KSWN.core.dbManager.form.messageServer.config.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-messageserver-config"}),Ext.define("KSWN.core.dbManager.form.messageServer.config.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-messageserver-config",data:{saveBtnText:KSWN.Locale.sokhranit,dbName:"",messageLifeTime:180,checkMessagesInterval:300},getMessageServerConfigParams:function(){const data=this.getData();return{dbName:data.dbName,checkMessagesInterval:data.checkMessagesInterval,messageLifeTime:data.messageLifeTime}}}),Ext.define("KSWN.core.dbManager.form.messageServer.config.Form",{extend:"KSWN.core.dbManager.form.base.Form",xtype:"ks-core-dbmanager-messageserver-config-form",reference:"form",width:400,layout:{type:"vbox",align:"stretch"},items:[{xtype:"fieldset",padding:10,title:KSWN.Locale.naimenovaniebaziserverasoobshchenii,items:{xtype:"displayfield",bind:"{dbName}"}},{xtype:"ks-core-dbmanager-form-messageserver-configfieldset"},{xtype:"ks-core-dbmanager-form-messageserver-prolicenseonlylabel"}],getFormValues:function(){return this.lookupViewModel().getMessageServerConfigParams()}}),Ext.define("KSWN.core.dbManager.form.messageServer.config.Window",{extend:"KSWN.core.dbManager.form.base.Window",xtype:"ks-core-dbmanager-messageserver-config-window",viewModel:"ks-core-dbmanager-messageserver-config",controller:"ks-core-dbmanager-messageserver-config",minWidth:600,title:KSWN.Locale.konfiguratsiyaserverasoobshchenii,layout:"fit",items:[{xtype:"ks-core-dbmanager-messageserver-config-form"}]}),Ext.define("KSWN.core.dbManager.form.messageServer.create.Form",{extend:"KSWN.core.dbManager.form.base.Form",xtype:"ks-core-dbmanager-messageserver-create-form",reference:"form",width:400,layout:{type:"vbox",align:"stretch"},items:[{xtype:"fieldset",title:KSWN.Locale.viborbazidannikh,defaults:{width:"100%"},items:[{xtype:"radiogroup",layout:"vbox",simpleValue:!0,bind:{value:"{serverCreateType}"},items:[{boxLabel:KSWN.Locale.tekushchayabazadannikh,name:"selected",inputValue:"current"},{boxLabel:KSWN.Locale.otdelnayabdrekomenduetsya,name:"selected",inputValue:"other"}]},{xtype:"textfield",fieldLabel:KSWN.Locale.imyabazi,labelAlign:"top",allowBlank:!1,bind:{value:"{serverName}",disabled:"{isCurrentServerCreateType}"}},{xtype:"textfield",fieldLabel:KSWN.Locale.katalograzmeshcheniya,labelAlign:"top",allowBlank:!1,emptyText:KSWN.Locale.viberitekatalograzmeshcheniyanaservere,bind:{value:"{serverPath}",disabled:"{ isPgDataSourceType || isCurrentServerCreateType }"},triggers:{explorer:{cls:"ks-icon-folder_open",handler:"onDbPathServerExplorerTriggerClick"}}}]},{xtype:"ks-core-dbmanager-form-messageserver-configfieldset"},{xtype:"ks-core-dbmanager-form-messageserver-prolicenseonlylabel"}],getFormValues:function(){return this.lookupViewModel().getCreateMessageServerParams()}}),Ext.define("KSWN.core.dbManager.form.messageServer.create.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-messageserver-create",init:function(){this.callParent();const vm=this.getViewModel();vm.set({serverName:vm.get("dbName")+"_messages"})},onDbPathServerExplorerTriggerClick:async function(){const serverPath=await this.showServerExplorer({showOnlyFolders:!0});!1!==serverPath&&this.getViewModel().set({serverPath:serverPath})}}),Ext.define("KSWN.core.dbManager.form.messageServer.create.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-messageserver-create",data:{dbName:"",serverCreateType:"other",isPgDataSourceType:!1,serverName:"",serverPath:"",messageLifeTime:180,checkMessagesInterval:300},formulas:{isCurrentServerCreateType:{bind:{bindTo:"{serverCreateType}"},get:serverCreateType=>"current"===serverCreateType}},getCreateMessageServerParams:function(){const data=this.getData(),{isCurrentDbCreateType:isCurrentDbCreateType}=data;return{name:isCurrentDbCreateType?data.dbName:data.serverName,path:isCurrentDbCreateType?null:data.serverPath,checkMessagesInterval:data.checkMessagesInterval,messageLifeTime:data.messageLifeTime}}}),Ext.define("KSWN.core.dbManager.form.messageServer.create.Window",{extend:"KSWN.core.dbManager.form.base.Window",xtype:"ks-core-dbmanager-messageserver-create-window",viewModel:"ks-core-dbmanager-messageserver-create",controller:"ks-core-dbmanager-messageserver-create",minWidth:600,title:KSWN.Locale.sozdanieserverasoobshchenii,layout:"fit",items:[{xtype:"ks-core-dbmanager-messageserver-create-form"}]}),Ext.define("KSWN.core.dbManager.form.messageServer.attach.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-form-messageserver-attach",resolveForm:function(){const messageServerName=this.getViewModel().getSelectedMessageServerName();if(!messageServerName)return KSWN.ExtUtils.Alert(KSWN.Locale.msgviberiteserversoobshchenii);this.callResolveFn(messageServerName),this.view.close()},onMessageServerRowDblClick:function(){this.resolveForm()}}),Ext.define("KSWN.core.dbManager.form.messageServer.attach.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-form-messageserver-attach",data:{selectedMessageServer:null,saveBtnText:KSWN.Locale.prisoedinit,messageServersList:[]},formulas:{saveBtnDisabled:{bind:{bindTo:"{selectedMessageServer}"},get:selectedMessageServer=>!selectedMessageServer}},stores:{messageServersStore:{fields:["name"],data:"{messageServersList}"}},getSelectedMessageServerName:function(){var _this$data$selectedMe;return null===(_this$data$selectedMe=this.data.selectedMessageServer)||void 0===_this$data$selectedMe?void 0:_this$data$selectedMe.get("name")}}),Ext.define("KSWN.core.dbManager.form.messageServer.attach.Window",{extend:"KSWN.core.dbManager.form.base.Window",modal:!0,xtype:"ks-core-dbmanager-form-messageserver-attach-window",title:KSWN.Locale.spisokdostupnikhserverovsoobshchenii,width:480,height:340,padding:4,layout:"fit",viewModel:"ks-core-dbmanager-form-messageserver-attach",controller:"ks-core-dbmanager-form-messageserver-attach",items:[{xtype:"grid",scrollable:!0,hideHeaders:!0,allowDeselect:!1,border:1,viewConfig:{markDirty:!1,stripeRows:!0},columns:[{text:KSWN.Locale.nazvanie,dataIndex:"name",flex:1,sortable:!1,hideable:!1,menuDisabled:!0}],listeners:{itemdblclick:"onMessageServerRowDblClick"},bind:{selection:"{selectedMessageServer}",store:"{messageServersStore}"}}]}),Ext.define("KSWN.core.dbManager.form.primaryDocumentServer.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-form-primarydocumentserver",init:function(){this.callParent();const vm=this.getViewModel();vm.set("primaryDocumentServerName",vm.get("dbName")+"_primarydocs")},onBeforeFormResolve:function(){return this.getViewModel().get("isCreateParamsValid")},onDbPathServerExplorerTriggerClick:async function(){const primaryDocumentServerPath=await this.showServerExplorer({showOnlyFolders:!0});!1!==primaryDocumentServerPath&&this.getViewModel().set({primaryDocumentServerPath:primaryDocumentServerPath})}}),Ext.define("KSWN.core.dbManager.form.primaryDocumentServer.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-form-primarydocumentserver",data:{serverCreateType:"current",isPgDataSourceType:!1,isCurrentServerCreateType:!1,dbName:"",serverName:"",primaryDocumentServerName:"",primaryDocumentServerPath:"",remoteUsername:"",remotePassword:""},formulas:{isCurrentServerCreateType:{bind:{bindTo:"{serverCreateType}"},get:serverCreateType=>"current"===serverCreateType},isCreateParamsValid:{bind:{name:"{primaryDocumentServerName}",path:"{primaryDocumentServerPath}",isCurrentDb:"{isCurrentServerCreateType}"},get:_ref28=>{let{name:name,path:path,isCurrentDb:isCurrentDb}=_ref28;return isCurrentDb||name&&path}},saveBtnDisabled:{bind:{bindTo:"{isCreateParamsValid}"},get:isCreateParamsValid=>!isCreateParamsValid}},getPrimaryDocumentServerCreateParams:function(){const data=this.getData(),isCurrent=data.isCurrentServerCreateType;return{serverName:null,remoteUsername:null,remotePassword:null,primaryDocumentServerName:isCurrent?data.dbName:data.primaryDocumentServerName,primaryDocumentServerPath:isCurrent?null:data.primaryDocumentServerPath,mode:isCurrent?0:1}}}),Ext.define("KSWN.core.dbManager.form.primaryDocumentServer.Form",{extend:"KSWN.core.dbManager.form.base.Form",xtype:"ks-core-dbmanager-form-primarydocumentserver-form",border:0,defaultType:"textfield",width:600,bodyPadding:4,defaults:{padding:10},items:[{xtype:"fieldset",title:KSWN.Locale.viborbazidannikh,defaultType:"textfield",defaults:{width:"100%"},items:[{xtype:"radiogroup",layout:"vbox",simpleValue:!0,bind:{value:"{serverCreateType}"},items:[{boxLabel:KSWN.Locale.tekushchayabazadannikh,name:"serverCreateType",inputValue:"current"},{boxLabel:KSWN.Locale.otdelnayabd,name:"serverCreateType",inputValue:"other"}]}]},{xtype:"fieldset",title:KSWN.Locale.parametri,defaultType:"textfield",defaults:{labelWidth:140},layout:{type:"vbox",align:"stretch"},bind:{disabled:"{isCurrentServerCreateType}"},items:[{fieldLabel:KSWN.Locale.imyaservera,disabled:!0,bind:{value:"{remoteServer}"}},{fieldLabel:KSWN.Locale.imyabd,bind:{value:"{primaryDocumentServerName}"}},{fieldLabel:KSWN.Locale.polzovateludalennogodostupa,disabled:!0,bind:{value:"{remoteUsername}"}},{fieldLabel:KSWN.Locale.paroludalennogopolzovatelya,disabled:!0,bind:{value:"{remotePassword}"}},{fieldLabel:KSWN.Locale.katalograzmeshcheniya,editable:!1,triggers:{explorer:{cls:"ks-icon-folder_open",handler:"onDbPathServerExplorerTriggerClick"}},bind:{disabled:"{ isPgDataSourceType || isCurrentServerCreateType }",value:"{primaryDocumentServerPath}"}}]}],getFormValues:function(){return this.lookupViewModel().getPrimaryDocumentServerCreateParams()}}),Ext.define("KSWN.core.dbManager.form.primaryDocumentServer.Window",{extend:"KSWN.core.dbManager.form.base.Window",xtype:"ks-core-dbmanager-form-primarydocumentserver-window",title:KSWN.Locale.sozdaniekhranilishchapervichnikhdokumentov,width:600,viewModel:"ks-core-dbmanager-form-primarydocumentserver",controller:"ks-core-dbmanager-form-primarydocumentserver",items:[{xtype:"ks-core-dbmanager-form-primarydocumentserver-form"}]}),Ext.define("KSWN.core.dbManager.list.base.Panel",{extend:"Ext.panel.Panel",sessionKey:void 0,dbNode:void 0,bind:{loading:"{viewLoading}"}}),Ext.define("KSWN.core.dbManager.list.base.ViewController",{extend:"Ext.app.ViewController",init:function(){const{dbNode:dbNode}=this.getView();this.getViewModel().set({dbNode:dbNode}),this.initOutcomeStore(),this.refreshOutcomeStore()},initOutcomeStore:function(){const vm=this.getViewModel();vm.getOutcomeStore().setLoadParams(vm.getOutcomeStoreLoadParams())},refreshOutcomeStore:function(){this.getViewModel().getOutcomeStore().load()},onBeforeOutcomeStoreLoad:function(){this.getViewModel().setViewLoading(!0)},onOutcomeStoreLoad:function(){this.getViewModel().setViewLoading(!1)}}),Ext.define("KSWN.core.dbManager.list.base.ViewModel",{extend:"Ext.app.ViewModel",outcomeStoreType:void 0,data:{dbNode:null,sessionKey:null},stores:{},privates:{applyStores:function(stores){this.outcomeStoreType&&(stores={...stores,outcomeStore:{type:this.outcomeStoreType,listeners:{beginoutcomeload:"onBeforeOutcomeStoreLoad",outcomeload:"onOutcomeStoreLoad"}}}),this.callParent([stores])}},getDbName:function(){var _this$getDbNode;return(null===(_this$getDbNode=this.getDbNode())||void 0===_this$getDbNode?void 0:_this$getDbNode.getDbName())||""},getSessionKey:function(){return this.getDbNode().getDbSessionKey()},getDbNode:function(){return this.data.dbNode},getOutcomeStoreLoadParams:function(){return{key:this.getSessionKey()}},getOutcomeStore:function(){return this.getStore("outcomeStore")},getMessagesStore:function(){return this.getStore("messagesStore")},setViewLoading:function(viewLoading){this.set({viewLoading:viewLoading})}}),Ext.define("KSWN.core.dbManager.list.message.model.Message",{extend:"Ext.data.Model",fields:[{name:"ID",type:"int"},{name:"DbName",type:"string"},{name:"State"},{name:"isImportant",depends:["State"],type:"bool",calculate:function(data){return 2===data.State}},{name:"RelatedDocuments"},{name:"hasRealatedDocs",type:"bool",depends:["RelatedDocuments"],calculate:function(data){return!_.isEmpty(data.RelatedDocuments)}},{name:"AttachedFiles"},{name:"hasAttachedFiles",type:"bool",depends:["AttachedFiles"],calculate:function(data){return!_.isEmpty(data.AttachedFiles)}},{name:"Sender"},{name:"senderName",type:"string",depends:["Sender"],calculate:function(data){return _.get(data.Sender,"Value[0]","")}},{name:"SendTo"},{name:"recipient",depends:["SendTo"],calculate:function(data){return _.values(data.SendTo).map(sendTo=>sendTo[0]).join(", ")}},{name:"NotReadUsers"},{name:"notReadUsers",type:"string",depends:["NotReadUsers"],calculate:function(data){return _.join(data.NotReadUsers,", ")}},{name:"Theme",type:"string"},{name:"Date",type:"date"},{name:"IsRead",type:"bool"},{name:"Deleted",type:"bool"}],getMessageMailData:function(){return{ID:this.getMessageId()}},getMessageId:function(){return this.data.ID}}),Ext.define("KSWN.core.dbManager.list.message.store.MessagesStore",{extend:"KSWN.core.data.Store",alias:"store.ks-core-dbmanager-messagelist-messages",loadUrl:"DbList/LoadMessageListOutcome",model:"KSWN.core.dbManager.list.message.model.Message"}),Ext.define("KSWN.core.dbManager.list.message.view.MessagesGrid",{extend:"KSWN.core.grid.Base",xtype:"ks-core-dbmanager-messagelist-grid",showFilter:!0,showDetails:!1,showSettings:!0,showSearch:!1,columns:[{xtype:"ks-grid-column-rownumberer"},KSWN.core.grid.Ext.prototype.CheckColumnExtended(),{width:32,dataIndex:"isImportant",iconCls:KSWN.Constant.iconClsPrefix+"message_important",renderer:isImportant=>isImportant?`<div class="ks-core-grid__cell-icon ks-core-grid__cell-icon--centered ${KSWN.Constant.iconClsPrefix}message_important"></div>`:""},{dataIndex:"IsRead",width:32,iconCls:KSWN.Constant.iconClsPrefix+"message_read",renderer:isRead=>`\n                <div class="ks-core-grid__cell-icon ks-core-grid__cell-icon--centered ${KSWN.Constant.iconClsPrefix}${isRead?"message_read":"message"}">\n                </div>`},{dataIndex:"hasRealatedDocs",width:32,iconCls:KSWN.Constant.iconClsPrefix+"document",renderer:hasRealatesDocs=>hasRealatesDocs?`<div class="ks-core-grid__cell-icon ks-core-grid__cell-icon--centered ${KSWN.Constant.iconClsPrefix}document"></div>`:""},{dataIndex:"hasAttachedFiles",width:32,iconCls:KSWN.Constant.iconClsPrefix+"message_attach",renderer:hasAttachedFiles=>hasAttachedFiles?`<div class="ks-core-grid__cell-icon ks-core-grid__cell-icon--centered ${KSWN.Constant.iconClsPrefix}message_attach"></div>`:""},{dataIndex:"senderName",text:KSWN.Locale.ot},{dataIndex:"recipient",text:KSWN.Locale.komu},{dataIndex:"Date",text:KSWN.Locale.dataotpravki,xtype:"datecolumn",format:"d M Y h:i:s"},{dataIndex:"Theme",text:KSWN.Locale.tema},{dataIndex:"notReadUsers",text:KSWN.Locale.nedostavleno},{dataIndex:"Deleted",text:KSWN.Locale.pomechenonaudalenie,xtype:"checkcolumn",listeners:{beforecheckchange:()=>!1}},{dataIndex:"DbName",text:KSWN.Locale.naimenovaniebd}],getSelectedMessages:function(){return this.GetCheckedRows({columns:[],noDefault:!0})},getSelectedMessagesIds:function(){return this.GetCheckedRows({columns:["ID"],noDefault:!0})}}),Ext.define("KSWN.core.dbManager.list.message.ViewController",{extend:"KSWN.core.dbManager.list.base.ViewController",alias:"controller.ks-core-dbmanager-messagelist",onOpenMessageBtnClick:function(){this.showSelectedMessageContent()},onMessagesGridRowDblClick:function(grid,message){this.showMessageContent(message)},onMarkToDeleteMessageBtnClick:function(){this.markMessagesToDelete(this.getSelectedMessagesIds())},onDeleteMessageBtnClick:function(){this.deleteMessages(this.getSelectedMessagesIds())},onRefreshMessagesListBtnClick:function(){this.refreshOutcomeStore()},markMessagesToDelete:async function(ids){if(!ids)return;const vm=this.getViewModel();try{vm.setViewLoading(!0);if(!await Ajax({url:"DbList/MarkDbMailMessagesToDelete",params:{key:vm.getSessionKey(),messages:ids}}))return;this.refreshOutcomeStore()}catch(err){KSWN.ErrorHandler.handle(err)}finally{vm.setViewLoading(!1)}},deleteMessages:async function(ids){if(!ids)return;const vm=this.getViewModel();try{vm.setViewLoading(!0);if(!await Ajax({url:"DbList/DeleteDbMailMessages",params:{key:vm.getSessionKey(),messages:ids}}))return;this.refreshOutcomeStore()}catch(err){KSWN.ErrorHandler.handle(err)}finally{vm.setViewLoading(!1)}},showSelectedMessageContent:function(){const message=this.getViewModel().getSelectedMessage();message&&this.showMessageContent(message)},showMessageContent:async function(message){const vm=this.getViewModel();try{vm.setViewLoading(!0);const res=await Ajax({url:"Mail/GetMailData",params:{id:message.getMessageId()}});if(!res)return KSWN.ExtUtils.Alert(KSWN.Locale.erroshibkazagruzkipisma);this.doShowMailFormReadMessage(res)}catch(err){KSWN.ErrorHandler.handle(err)}finally{vm.setViewLoading(!1)}},doShowMailFormReadMessage:function(messageData){new KSWN.meta.mail.FormReadMessage({config:{data:messageData},listeners:{render:function(){this.Toolbar.hide()}}})},showEmptySelectedMessagesMsg:function(){KSWN.ExtUtils.Alert(KSWN.Locale.msgviberitesoobshcheniya)},getSelectedMessagesIds:function(){const messages=this.lookup("messages-grid").getSelectedMessagesIds();return 0===messages.length?(this.showEmptySelectedMessagesMsg(),null):messages}}),Ext.define("KSWN.core.dbManager.list.message.ViewModel",{extend:"KSWN.core.dbManager.list.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-messagelist",outcomeStoreType:"ks-core-dbmanager-messagelist-messages",data:{selectedMessage:null},formulas:{isMessageNotSelected:{bind:{bindTo:"{selectedMessage}"},get:message=>!message}},getSelectedMessage:function(){return this.data.selectedMessage}}),Ext.define("KSWN.core.dbManager.list.message.Panel",{alternateClassName:["KSWN.core.dbManager.MessageList"],statics:{openDbMessageList:function(_ref29){let{dbNode:dbNode}=_ref29;const serverName=dbNode.getServerName(),dbName=dbNode.getName(),objCode=`DbMessageList_${serverName}.${dbName}`;return KSWN.core.dashboard.Starter.CustomTabOpen({ObjectCode:objCode,title:`[${dbName}] ${KSWN.Locale.obshchiiprosmotrsoobshchenii}`},{xtype:"ks-core-dbmanager-messagelist-panel",dbNode:dbNode})}},extend:"KSWN.core.dbManager.list.base.Panel",xtype:"ks-core-dbmanager-messagelist-panel",viewModel:"ks-core-dbmanager-messagelist",controller:"ks-core-dbmanager-messagelist",layout:"fit",tbar:[{iconCls:"ks-icon-open",tooltip:KSWN.Locale.otkrit,handler:"onOpenMessageBtnClick",bind:{disabled:"{isMessageNotSelected}"}},{iconCls:"ks-icon-delete",tooltip:KSWN.Locale.pometitnaudalenie,handler:"onMarkToDeleteMessageBtnClick"},{iconCls:"ks-icon-delete_from_server",tooltip:KSWN.Locale.udalit,handler:"onDeleteMessageBtnClick"},{iconCls:"ks-icon-refresh",tooltip:KSWN.Locale.obnovit,handler:"onRefreshMessagesListBtnClick"}],items:{xtype:"ks-core-dbmanager-messagelist-grid",reference:"messages-grid",listeners:{rowdblclick:"onMessagesGridRowDblClick"},bind:{selection:"{selectedMessage}",store:"{outcomeStore}"}}}),Ext.define("KSWN.core.dbManager.list.process.model.Process",{extend:"Ext.data.Model",fields:[{name:"database_name",type:"string"},{name:"login_name",type:"string"},{name:"sql_text",type:"string"}],getSqlText:function(){return this.data.sql_text}}),Ext.define("KSWN.core.dbManager.list.process.store.ProcessesStore",{extend:"Ext.data.Store",alias:"store.ks-core-dbmanager-processlist-processes",model:"KSWN.core.dbManager.list.process.model.Process"}),Ext.define("KSWN.core.dbManager.list.process.store.OutcomeStore",{extend:"KSWN.core.data.Store",alias:"store.ks-core-dbmanager-processlist-outcome",loadUrl:"DbList/LoadDbProcessListOutcome",isMultiTableOutcome:!0}),Ext.define("KSWN.core.dbManager.list.process.view.ProcessesGrid",{extend:"KSWN.core.grid.Base",xtype:"ks-core-dbmanager-processlist-grid",showFilter:!0,showDetails:!1,showSettings:!0,showSearch:!1,bind:{store:"{processesStore}",selection:"{selectedProcess}"},ApplyColumns:function(){this.columns=[this.RowNumbererColumn(),this.CheckColumnExtended(),...this.columns.filter(col=>"checked"!==col.dataIndex)],this.callParent()},getSelectedProcesses:function(){return this.GetCheckedRows({columns:[],noDefault:!0})}}),Ext.define("KSWN.core.dbManager.list.process.ViewController",{extend:"KSWN.core.dbManager.list.base.ViewController",alias:"controller.ks-core-dbmanager-processlist",onOutcomeStoreLoad:function(outcomeStore){this.callParent();const processesStore=this.getViewModel().getProcessesStore(),table=outcomeStore.getTableByName("Table");processesStore.loadRawData(table.getTableData()),this.processesGridInited||this.initProcessesGrid(table.getGridColumns())},onKillSelectedProcessesBtnClick:function(){this.killSelectedProcesses()},onRefreshProcessListBtnClick:function(){this.refreshOutcomeStore()},initProcessesGrid:function(columns){const ct=this.lookupReference("processesListGridCt"),{processGridConfig:processGridConfig}=this.getView();ct.add({...processGridConfig,columns:columns}),this.processesGridInited=!0},killSelectedProcesses:function(){const processes=this.lookup("processListGrid").getSelectedProcesses();0!==processes.length&&this.killProcesses({processes:processes})},killProcesses:async function(_ref30){let{processes:processes}=_ref30;const vm=this.getViewModel();try{if(!await this.confirmKillProcess(processes))return;vm.set("viewLoading",KSWN.Locale.udalenieprotsessav);const res=await Ajax({url:"DbList/KillProcesses",params:{key:vm.getSessionKey(),processes:processes}});if(!res)return;res.Fail&&KSWN.ExtUtils.Alert(`${KSWN.Locale.erroshibkaudaleniyaprotsessov} ${res.Message||""}`),this.refreshProcessesListStore()}finally{vm.set("viewLoading",!1)}},confirmKillProcess:function(processes){const L=KSWN.Locale,count=processes.length;let message="";if(1===count){const{session_id:session_id,login_name:login_name}=processes[0];message=L.formatString(L.vy_dejstvitelno_hotite_zavershit_process_0_polzovatelja_1,session_id,login_name)}else message=L.formatString(L.vy_dejstvitelno_hotite_zavershit_vse_0_otobrannyh_processa_ov_,count);return KSWN.ExtUtils.AsyncConfirm({title:L.podtverzhdenie,message:message})}}),Ext.define("KSWN.core.dbManager.list.process.ViewModel",{extend:"KSWN.core.dbManager.list.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-processlist",outcomeStoreType:"ks-core-dbmanager-processlist-outcome",data:{selectedProcess:null,selectedProcessSqlText:"",viewLoading:!1},formulas:{selectedProcessSqlText:{bind:{bindTo:"{selectedProcess}"},get:process=>(null==process?void 0:process.getSqlText())||""}},stores:{processesStore:{type:"ks-core-dbmanager-processlist-processes"}},getProcessesStore:function(){return this.getStore("processesStore")},getOutcomeStoreLoadParams:function(){return{...this.callParent(),node:this.getDbNode().getData()}}}),Ext.define("KSWN.core.dbManager.list.process.Panel",{alternateClassName:["KSWN.core.dbManager.ProcessList"],statics:{openDbProcessList:function(_ref31){let{dbNode:dbNode}=_ref31;const dbName=dbNode.getName(),objCode=`DbProcessList_${dbName}_${dbNode.getServerName()}`;return KSWN.core.dashboard.Starter.CustomTabOpen({ObjectCode:objCode,title:`[${dbName}] ${KSWN.Locale.spisokprotsessov}`},{xtype:"ks-core-dbmanager-processlist-panel",dbNode:dbNode})}},extend:"KSWN.core.dbManager.list.base.Panel",xtype:"ks-core-dbmanager-processlist-panel",viewModel:"ks-core-dbmanager-processlist",controller:"ks-core-dbmanager-processlist",processGridConfig:{xtype:"ks-core-dbmanager-processlist-grid",reference:"processListGrid"},layout:{type:"vbox",align:"stretch"},tbar:[{iconCls:KSWN.Constant.iconClsPrefix+"delete",tooltip:KSWN.Locale.udalitprotsessi,handler:"onKillSelectedProcessesBtnClick"},{iconCls:KSWN.Constant.iconClsPrefix+"refresh",tooltip:KSWN.Locale.obnovit,handler:"onRefreshProcessListBtnClick"}],defaults:{flex:1},items:[{xtype:"panel",layout:"fit",reference:"processesListGridCt"},{xtype:"panel",layout:"fit",items:{xtype:"ks-ux-field-highlighttexteditor",highlightMode:"sql",readOnly:!0,bind:{value:"{selectedProcessSqlText}"}}}]}),Ext.define("KSWN.core.dbManager.form.serverErrorLog.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-form-servererrorlog",onSendErrorLogBtnClick:function(){this.sendAllErrorLogByMail()},onSaveErrorLogBtnClick:function(){this.saveAllErrorLogToFile()},onShowErrorLogBtnClick:function(){this.showCurrentErrorLog()},showCurrentErrorLog:async function(){const vm=this.getViewModel();try{vm.setViewLoading(KSWN.Locale.zagruzkazhurnala),await this.downloadCurrentServerErrorLog()}catch(err){KSWN.ErrorHandler.handle(err)}finally{vm.setViewLoading(!1)}},showErrorLogWindow:function(errorLog){KSWN.ExtUtils.ShowText(errorLog,{title:KSWN.Locale.zhurnaloshibok,style:{whiteSpace:"pre-wrap"},scrollable:"y",width:"auto",height:"auto"})},sendAllErrorLogByMail:async function(){try{if(!this.getForm().isValid())return;const filename=await this.downloadAllServerErrorLog();if(!filename)return;const{recipient:recipient,subject:subject,message:message}=this.getViewModel().getData();KSWN.core.messageBox.MessageBox.alert({message:Ext.String.format(KSWN.Locale.attachDbManagerServerErrorLogToMail,filename),messageType:"msg"}),KSWN.Utils.SilentAnchorClick(`mailto:${recipient}?subject=${subject}&body=${message}`)}catch(err){KSWN.ErrorHandler.handle(err)}},openSendMailDialog:function(){},saveAllErrorLogToFile:async function(){const vm=this.getViewModel();try{return vm.setViewLoading(KSWN.Locale.zagruzkazhurnala),await this.downloadAllServerErrorLog()}catch(err){KSWN.ErrorHandler.handle(err)}finally{vm.setViewLoading(!1)}},downloadCurrentServerErrorLog:function(){return this.getViewModel().getDbManager().downloadCurrentServerErrorLog()},downloadAllServerErrorLog:function(){return this.getViewModel().getDbManager().downloadAllServerErrorLog()}}),Ext.define("KSWN.core.dbManager.form.serverErrorLog.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-form-servererrorlog",data:{recipient:KSWN.Constant.keysystemsErrorLogRecipient,subject:KSWN.Locale.zhurnaloshibok,message:"",attachErrorLog:!0}}),Ext.define("KSWN.core.dbManager.form.serverErrorLog.Form",{extend:"KSWN.core.dbManager.form.base.Form",xtype:"ks-core-dbmanager-servererrorlog-form",width:550,height:"100%",layout:"fit",items:[{xtype:"fieldset",title:KSWN.Locale.otpravitotchetoboshibkakh,defaultType:"textfield",height:"100%",layout:{type:"vbox",align:"stretch"},defaults:{labelWidth:100,labelAlign:"left"},items:[{fieldLabel:KSWN.Locale.komu,allowBlank:!1,bind:"{recipient}"},{fieldLabel:KSWN.Locale.tema,allowBlank:!1,bind:"{subject}"},{xtype:"textarea",fieldLabel:KSWN.Locale.soobshchenie,allowBlank:!1,labelAlign:"top",flex:1,emptyText:KSWN.Locale.opishitesituatsiyuprikotoroivoznikaetoshibkachtobinashispetsialistismoglievosproizvesti,maxLength:2e3,bind:"{message}"},{xtype:"fieldcontainer",layout:{type:"hbox",align:"center"},items:[{xtype:"checkbox",boxLabel:KSWN.Locale.prikrepitzhurnalserverabd,bind:"{attachErrorLog}"},{xtype:"container",border:0,flex:1},{xtype:"button",text:KSWN.Locale.prosmotr,handler:"onShowErrorLogBtnClick"}]}]}]}),Ext.define("KSWN.core.dbManager.form.serverErrorLog.Window",{extend:"KSWN.core.dbManager.form.base.Window",xtype:"ks-core-dbmanager-form-servererrorlog-window",title:KSWN.Locale.zhurnaloshibok,viewModel:"ks-core-dbmanager-form-servererrorlog",controller:"ks-core-dbmanager-form-servererrorlog",layout:"fit",items:{xtype:"ks-core-dbmanager-servererrorlog-form"},buttons:[{xtype:"button",text:KSWN.Locale.otpravit,handler:"onSendErrorLogBtnClick",bind:{disabled:"{!attachErrorLog}"}},{xtype:"button",text:KSWN.Locale.sokhranit,handler:"onSaveErrorLogBtnClick",bind:{disabled:"{!attachErrorLog}"}},{handler:"onCancelBtnClick",bind:{text:"{cancelBtnText}",disabled:"{cancelBtnDisabled}"}}]}),Ext.define("KSWN.core.dbManager.form.mailProfile.model.Profile",{extend:"Ext.data.Model",idField:"ProfileId",fields:[{name:"ProfileId",type:"int",defaultValue:0},{name:"AccountId",type:"int",defaultValue:0},{name:"Profile",type:"string"},{name:"Description",type:"string"},{name:"Account",type:"string"},{name:"Email",type:"string"},{name:"Sender",type:"string"},{name:"Subject",type:"string"},{name:"Server",type:"string"},{name:"Port",type:"int",defaultValue:25},{name:"User",type:"string"},{name:"Password",type:"string"}]}),Ext.define("KSWN.core.dbManager.form.mailProfile.Form",{extend:"KSWN.core.dbManager.form.base.Form",xtype:"ks-core-dbmanager-form-mailprofile-form",width:500,items:{title:KSWN.Locale.parametriprofilya,bodyPadding:4,margin:0,xtype:"fieldset",defaultType:"textfield",layout:{type:"vbox",align:"stretch"},defaults:{labelWidth:100},items:[{fieldLabel:KSWN.Locale.profil,emptyText:KSWN.Locale.imyaprofilya,bind:{value:"{profile.Profile}",editable:"{!isEdit}"}},{fieldLabel:KSWN.Locale.opisanie,emptyText:KSWN.Locale.opisanieprofilya,bind:{value:"{profile.Description}"}},{fieldLabel:KSWN.Locale.akkaunt,emptyText:KSWN.Locale.pochtoviiakkaunt,bind:{value:"{profile.Account}",editable:"{isCreateMode}"}},{fieldLabel:"E-mail:",emptyText:KSWN.Locale.pochtoviiyashchikotpravki,bind:{value:"{profile.Email}"}},{fieldLabel:KSWN.Locale.otpravitel,emptyText:KSWN.Locale.naimenovanieotpravitelya,bind:{value:"{profile.Sender}"}},{fieldLabel:KSWN.Locale.tema,emptyText:KSWN.Locale.temasoobshchenii,bind:{value:"{profile.Subject}"}},{xtype:"fieldcontainer",layout:{type:"hbox",align:"center"},items:[{xtype:"textfield",fieldLabel:KSWN.Locale.server,emptyText:KSWN.Locale.adresservera,margin:"0 8 0 0",flex:2,bind:{value:"{profile.Server}"}},{fieldLabel:KSWN.Locale.port,xtype:"numberfield",labelWidth:!1,labelStyle:"width: auto",flex:1,minValue:1,maxValue:65535,stepValue:1,bind:{value:"{profile.Port}"}}]},{xtype:"fieldcontainer",layout:{type:"hbox",align:"center"},defaultType:"textfield",items:[{xtype:"textfield",fieldLabel:KSWN.Locale.smtppolzovatel,flex:1,margin:"0 8 0 0",bind:{value:"{profile.User}"}},{xtype:"textfield",inputType:"password",fieldLabel:KSWN.Locale.smtpparol,labelWidth:!1,labelStyle:"width: auto",flex:1,bind:{value:"{profile.Password}"}}]}]},getFormValues:function(){return this.lookupViewModel().profileData()}}),Ext.define("KSWN.core.dbManager.form.mailProfile.ViewController",{extend:"KSWN.core.dbManager.form.base.ViewController",alias:"controller.ks-core-dbmanager-form-mailprofile",init:function(){const{formValues:formValues}=this.getView(),profileData=(null==formValues?void 0:formValues.profileData)||{},profile=new KSWN.core.dbManager.form.mailProfile.model.Profile(profileData);this.getViewModel().set({profile:profile})},resolveForm:async function(){await this.saveDbMailProfile()&&(this.callResolveFn(!0),this.view.close())},saveDbMailProfile:async function(){const vm=this.getViewModel(),dbManger=vm.getDbManager();try{return vm.setViewLoading(KSWN.Locale.sohranenie),await dbManger.saveDbMailProfile(vm.getProfileData())}catch(err){KSWN.ErrorHandler.handle(err)}finally{vm.setViewLoading(!1)}}}),Ext.define("KSWN.core.dbManager.form.mailProfile.ViewModel",{extend:"KSWN.core.dbManager.form.base.ViewModel",alias:"viewmodel.ks-core-dbmanager-form-mailprofile",data:{isCreateMode:!1,windowTitle:"",profile:null},formulas:{isCreateMode:{bind:{bindTo:"{profile.ProfileId}"},get:id=>0===id},windowTitle:{bind:{bindTo:"{isCreateMode}"},get:isCreateMode=>{const L=KSWN.Locale;return`${isCreateMode?L.sozdanie:L.redaktirovanie} ${L.pochtovogoprofilya}`}},saveBtnText:{bind:{bindTo:"{isCreateMode}"},get:isCreateMode=>isCreateMode?KSWN.Locale.sozdat:KSWN.Locale.sokhranit}},getProfileData:function(){var _this$data$profile;return null===(_this$data$profile=this.data.profile)||void 0===_this$data$profile?void 0:_this$data$profile.getData()}}),Ext.define("KSWN.core.dbManager.form.mailProfile.Window",{extend:"KSWN.core.dbManager.form.base.Window",xtype:"ks-core-dbmanager-form-mailprofile-window",viewModel:"ks-core-dbmanager-form-mailprofile",controller:"ks-core-dbmanager-form-mailprofile",items:{xtype:"ks-core-dbmanager-form-mailprofile-form"},bind:{title:"{windowTitle}"}}),Ext.define("KSWN.core.dbManager.navigator.Menu",{extend:"KSWN.core.menu.DynamicItemsMenu",xtype:"ks-core-dbmanager-navigator-menu",statics:{buildExtMenuItemsFromServerMenu:(menu,defaults)=>menu.map(item=>KSWN.core.dbManager.navigator.Menu.buildMenuItem(item,defaults)),buildMenuItem:function(item,defaults){const{disabledNodeTypes:disabledNodeTypes,checkboxNodeTypes:checkboxNodeTypes,separatorNodeStyle:separatorNodeStyle}=KSWN.Constant,{Code:Code,Name:Name,NodeStyle:NodeStyle,Checked:Checked,PluginName:PluginName,Children:Children}=item;if(NodeStyle===separatorNodeStyle)return"-";const isDisabled=disabledNodeTypes.includes(NodeStyle),isMenuCheck=checkboxNodeTypes.includes(NodeStyle),cfg=Ext.apply({text:Name,disabled:isDisabled,code:Code,taskName:PluginName},defaults);return isMenuCheck?Ext.apply(cfg,{xtype:"menucheckitem",checked:Checked}):Children&&(cfg.menu=Children.map(item=>KSWN.core.dbManager.navigator.Menu.buildMenuItem(item,defaults))),cfg}},items:[],ignoreParentClicks:!0}),Ext.define("KSWN.core.dbManager.navigator.Model",{extend:"KSWN.core.data.TreeModel",fields:[{name:"DbName"},{name:"isCurrentDb",type:"boolean"},{name:"isDisabledDb",type:"boolean"},{name:"isLoadableBranch",type:"boolean"},{name:"branchIsLoaded",type:"boolean"},{name:"operationStarted",type:"boolean"},{name:"sessionKey",type:"string"},{name:"startedTaskName",type:"string"},{name:"name",depends:["INode"],calculate:function(data){var _data$INode;return null===(_data$INode=data.INode)||void 0===_data$INode?void 0:_data$INode.Name}}],contextMenuItems:void 0,collapseOnStartLoading:!0,getContextMenu:function(){let{contextMenuItems:contextMenuItems}=this;const menu=this.get("Menu");return!contextMenuItems&&menu&&(contextMenuItems=KSWN.core.dbManager.navigator.Menu.buildExtMenuItemsFromServerMenu(menu),this.contextMenuItems=contextMenuItems),contextMenuItems},getServerName:function(){return this.getServerNode().getName()},getDbName:function(){var _this$getDbNode2;return(null===(_this$getDbNode2=this.getDbNode())||void 0===_this$getDbNode2?void 0:_this$getDbNode2.getINodeValue("DbName"))||""},setDbName:function(dbName){const inode=this.getINode();inode&&inode.DbName&&(this.setINodeValue({DbName:dbName,Name:dbName}),this.set("text",dbName),this.commit())},getName:function(){return this.data.name},isCurrentDb:function(){return this.data.isCurrentDb},isDisabledDb:function(){return this.data.isDisabledDb},allowBranchLoad:function(){return this.isLoadableBranch()&&!this.isLoadedBranch()},isLoadableBranch:function(){return this.data.isLoadableBranch},isLoadedBranch:function(){return this.data.branchIsLoaded},refreshBranch:function(){return this.loadBranch()},refreshSessionKey:async function(){this.setLoading(!0);const res=await Ajax({url:"DbList/UpdateNodeSessionKey",params:{node:this.getData(),sessionKey:this.getSessionKey(),masterSessionKey:this.masterSessionKey}});if(this.setLoading(!1),!res)return;const{dbSessionKey:dbSessionKey}=res;this.setSessionKey(dbSessionKey)},loadBranch:async function(){let masterSessionKey=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.masterSessionKey;this.setLoading(!0);const res=await Ajax({url:"DbList/GetBranchData",params:{node:this.getData(),sessionKey:this.getSessionKey(),masterSessionKey:masterSessionKey}});if(this.setLoading(!1),!res)return!1;this.masterSessionKey=masterSessionKey;const{dbSessionKey:dbSessionKey,data:data}=res;this.setSessionKey(dbSessionKey),this.set("branchIsLoaded",!0);const{Menu:Menu,children:children}=_.first(data);return this.removeAll(),children&&this.appendChild(children),this.clearContextMenuItems(),this.set({Menu:Menu}),this.commit(),!0},clearContextMenuItems:function(){this.contextMenuItems=null},getDbSessionKey:function(){var _this$getDbNode3;return null===(_this$getDbNode3=this.getDbNode())||void 0===_this$getDbNode3?void 0:_this$getDbNode3.getSessionKey()},getSessionKey:function(){return this.get("sessionKey")},setSessionKey:function(sessionKey){this.set({sessionKey:sessionKey})},getTaskName:function(){var _this$data$INode;let taskName=null===(_this$data$INode=this.data.INode)||void 0===_this$data$INode?void 0:_this$data$INode.PluginName;return"Meta.GroupAdmin"===taskName&&(taskName+=".Init"),taskName},isOperationStartedNode:function(){return this.data.operationStarted},setOperationStarted:function(_ref32){let{started:started,taskName:taskName}=_ref32;this.set({operationStarted:started,startedTaskName:started?taskName:""}),this.setLoading(started)},getDbNode:function(){let dbNode,node=this;for(;!dbNode&&node;)dbNode=(node.isDbNode()||node.isAdminServerNode()||node.isAdminDbMailNode())&&node,node=node.parentNode;return dbNode},getServerNode:function(){let node=this;for(;node&&!node.isAdminServerNode();)node=node.parentNode;return node},isPrimaryDocumentServerNode:function(){return this.getSqlNodeType()===KSWN.core.dbManager.navigator.SqlAdminNodeType.NODE_SQL_ADMIN_SERVER_PRIMARYSTORAGE},isServerMessageNode:function(){return this.getSqlNodeType()===KSWN.core.dbManager.navigator.SqlAdminNodeType.NODE_SQL_ADMIN_SERVER_MESSAGE},isDbNode:function(){return this.getSqlNodeType()===KSWN.core.dbManager.navigator.SqlAdminNodeType.NODE_SQL_ADMIN_DATABASE},isMessageDbNode:function(){return this.getSqlNodeType()===KSWN.core.dbManager.navigator.SqlAdminNodeType.NODE_SQL_ADMIN_MESSAGE_DATABASE},isAdminServerNode:function(){return this.getSqlNodeType()===KSWN.core.dbManager.navigator.SqlAdminNodeType.NODE_SQL_ADMIN_SERVER},isAdminDbMailNode:function(){return this.getSqlNodeType()===KSWN.core.dbManager.navigator.SqlAdminNodeType.NODE_SQL_ADMIN_DATABASE_MAIL},isAdminDbMailProfileNode:function(){return this.getSqlNodeType()===KSWN.core.dbManager.navigator.SqlAdminNodeType.NODE_SQL_ADMIN_DATABASE_MAIL_PROFILE},getSqlNodeType:function(){return this.getINodeValue("SqlAdminNodeType")},getMessageServerName:function(){return this.getLinkedServer()},setMessageServerName:function(LinkedServer){this.setLinkedServer(LinkedServer)},getDbMailProfileName:function(){return _.chain(this.getLinkedServer()).split("|").head().value()},getDbMailProfileReqs:function(){const linkedServer=this.getLinkedServer(),[profileName,accountName]=_.split(linkedServer,"|");return{profileName:profileName,accountName:accountName}},getLinkedServer:function(){return this.getINodeValue("LinkedServer")},setLinkedServer:function(LinkedServer){this.setINodeValue({LinkedServer:LinkedServer})},setMenuItemTraceStatus:function(traceStatus){const menuItem=this.getTraceStatusMenuItem();menuItem&&(menuItem.checked=traceStatus)},getTraceStatus:function(){const menuItem=this.getTraceStatusMenuItem();return menuItem?menuItem.checked:null},getTraceStatusMenuItem:function(){return this.getContextMenu().find(item=>"Trace"===item.code)},setAdminDbMailNodeTurnOn:function(){this.set("text",KSWN.Locale.pochta_SUBD_vkluchena),this.setLinkedServer("•")},setAdminDbMailNodeTurnOff:function(){this.set("text",KSWN.Locale.pochta_SUBD_otkluchena),this.setLinkedServer(null)}}),Ext.define("KSWN.core.dbManager.navigator.Store",{extend:"KSWN.core.data.TreeStore",model:"KSWN.core.dbManager.navigator.Model",alias:"store.ks-core-dbmanager-navigator",operationStartedNodesIds:null,onBeforeLoadTree:function(){this.callParent(),this.saveLoadingNodesIds()},onAfterLoadTree:function(){this.applyLoadingNodesIds(),this.cleanLoadingNodesIds()},applyLoadingNodesIds:function(){const ids=this.operationStartedNodesIds;ids&&ids.map(id=>this.getNodeById(id)).filter(node=>null!==node).forEach(node=>node.setOperationStarted(!0))},cleanLoadingNodesIds:function(){this.operationStartedNodesIds=null},saveLoadingNodesIds:function(){this.operationStartedNodesIds=this.collectOperationStartedNodesIds()},collectOperationStartedNodesIds:function(){return this.queryBy(node=>node.isOperationStartedNode()).collect("id")},setAdminServerNodeSessionKey:function(sessionKey){this.getAdminServerNode().setSessionKey(sessionKey)},getAdminServerNode:function(){return this.getRoot().findChildBy(node=>node.isAdminServerNode())}}),Ext.define("KSWN.core.dbManager.navigator.Tree",{extend:"KSWN.core.tree.TreePanel",xtype:"ks-core-dbmanager-navigator-tree",cls:"ks-core-dbmanager-navigator-tree",border:!1,bodyBorder:!1,useArrows:!0,maskDisabled:!1,enableDrag:!1,rootVisible:!1,hasContextMenu:!1,columns:[{xtype:"ks-core-tree-column",dataIndex:"text",flex:1,renderer:function(value,metaData,record){return record.isDisabledDb()&&(metaData.tdCls+="disabled-db-node "),record.isCurrentDb()&&(metaData.tdCls+="current-db-node "),record.isOperationStartedNode()&&(value=`${value} - <b>${record.get("startedTaskName")}</b>`),value}}],setDbManager:function(dbManager){this.dbManager=dbManager,dbManager.on({operationstart:"onDbManagerOperationStart",operationfinish:"onDbManagerOperationFinish",scope:this})},onDbManagerOperationStart:function(collection,operation){this.setNodeLoadingByDbManagerOperation(operation,!0)},onDbManagerOperationFinish:function(collection,operation){this.setNodeLoadingByDbManagerOperation(operation,!1)},setNodeLoadingByDbManagerOperation:function(operation,started){const id=operation.getNodeId(),node=this.getStore().getNodeById(id);null==node||node.setOperationStarted({taskName:operation.getTaskName(),started:started})},loadDbList:function(tree){this.getStore().loadTree(tree),this.selectCurrentDBNode()},selectCurrentDBNode:function(){const store=this.getStore(),index=store.findBy(node=>node.isCurrentDb());if(index>0){const node=store.getAt(index);this.selectPath(node)}else this.collapseAll(),store.getRoot().expand()}}),Ext.define("KSWN.core.dbManager.navigator.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-core-dbmanager-navigator",getDbManager:function(){return this.view.dbManager},showNodeContextMenu:function(node,e){const menu=this.getView().getContextMenu();menu.showEvent=e;const id=node.internalId;if(!menu.hasMenuItems(id)){const menuItems=this.getNodeContextMenu(node);menuItems&&menu.registerMenuItems(id,menuItems)}menu.applyMenuItemsAndShowIf(id,e)},onBeforeDbListTreeNodeExpand:function(node){if(!node.isRoot()){if(node.isLoading())return!1;if(node.allowBranchLoad()){const key=this.getDbManager().getSessionKey();return node.loadBranch(key).then(success=>{success&&node.expand()}),!1}}},onDbListTreeNodeDblClick:function(tree,node){this.getDbManager().runNodeTask(node)},onContextMenuItemClick:function(item){if(!item)return;const node=this.getViewModel().get("selectedDbNode"),{taskName:taskName}=item;this.getDbManager().runContextMenuItemTask(node,taskName)},onDbListTreeBeforeItemContextMenu:function(view,node,item,index,e){if(e.stopEvent(),node.isLoading())return;const show=()=>this.showNodeContextMenu(node,e);if(node.allowBranchLoad()){const key=this.getDbManager().getSessionKey();node.loadBranch(key).then(success=>{success&&show()})}else show();return!1},getNodeContextMenu:function(node){const view=this.getView();let contextMenuItems=view.allNodeContextMenu[node.internalId];const menu=node.get("Menu");return!contextMenuItems&&menu&&(contextMenuItems=KSWN.core.dbManager.navigator.Menu.buildExtMenuItemsFromServerMenu(menu,{handler:this.onContextMenuItemClick.bind(this)}),view.allNodeContextMenu[node.internalId]=contextMenuItems),contextMenuItems}}),Ext.define("KSWN.core.dbManager.navigator.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-core-dbmanager-navigator",data:{selectedDbNode:null},stores:{dbTreeStore:{type:"ks-core-dbmanager-navigator",autoLoad:!1}}}),Ext.define("KSWN.core.dbManager.navigator.Panel",{extend:"Ext.panel.Panel",iconCls:"ks-icon-server24",closableNavigatorTab:!0,border:!1,layout:"fit",hasContextMenu:!1,viewModel:"ks-core-dbmanager-navigator",controller:"ks-core-dbmanager-navigator",allNodeContextMenu:{},dbManager:void 0,treeData:null,items:[{xtype:"ks-core-dbmanager-navigator-tree",itemId:"tree",reference:"dbListTree",listeners:{beforeitemexpand:"onBeforeDbListTreeNodeExpand",itemdblclick:"onDbListTreeNodeDblClick",beforeitemcontextmenu:"onDbListTreeBeforeItemContextMenu"},bind:{store:"{dbTreeStore}",selection:"{selectedDbNode}"}}],getTreeData:function(){return this.treeData},getTree:function(){return this.getComponent("tree")},getContextMenu:function(){return this.contextMenu||(this.contextMenu=this.createContextMenu())},createContextMenu:function(){return new KSWN.core.dbManager.navigator.Menu({xtype:"ks-core-dbmanager-navigator-menu",reference:"contextMenu"})},destroy:function(){Ext.destroy(this.allNodeContextMenu),this.allNodeContextMenu=null,this.callParent()}}),Ext.define("KSWN.core.dbManager.DbManager",{statics:{isAlreadyExistDbManager:function(id){return KSWN.ObjX.HasObjX(id)},init:function(connectionParams){const dashboard=KSWN.getDashboard(),manager=new KSWN.core.dbManager.DbManager({connectionParams:connectionParams});KSWN.core.dbManager.DbManager.isAlreadyExistDbManager(manager.id)?manager.destroy():(manager.initUI(),dashboard.AddNavTab(manager.mainPanel,!0))}},mixins:["Ext.mixin.Observable","KSWN.core.dbManager.module.BackupDb","KSWN.core.dbManager.module.BaseDbOperation","KSWN.core.dbManager.module.MessageServer","KSWN.core.dbManager.module.PrimaryDocumentServer","KSWN.core.dbManager.module.ServerErrorLog","KSWN.core.dbManager.module.MailProfile"],session:{},connectionParams:{},isDbManager:!0,constructor:function(config){this.connectionParams=config.connectionParams,this.getId(),this.mixins.observable.constructor.call(this),this.initConfig(),this.initOperationsCollection()},initUI:function(){this.initNavigator(),this.initObjX()},getId:function(){let{id:id}=this;if(!id){const{dbServer:dbServer="",dbUser:dbUser="",password:password=""}=this.connectionParams;this.id=id=SparkMD5.hash(`db-manager-${dbServer}-${dbUser}-${password}`)}return id},getNavigatorTabTitle:function(){const{connectionParams:connectionParams}=this;let user,server;if(null==connectionParams?void 0:connectionParams.server)server=connectionParams.dbServer,user=connectionParams.dbUser;else{const WPInfo=KSWN.getWebProject().getInfo();server=WPInfo.DBServer,user=WPInfo.UserName}return`[${server} - ${user}] - ${KSWN.Locale.upravlenie}`},getSessionKey:function(){return this.session.key},initNavigator:function(){const title=this.getNavigatorTabTitle();this.mainPanel=new KSWN.core.dbManager.navigator.Panel({tooltip:title,Refresh:this.refresh.bind(this),dbManager:this}),this.mainPanel.on({afterrender:{fn:"load",scope:this,single:!0},destroy:{fn:"destroy",scope:this}}),this.tree=this.mainPanel.getTree(),this.tree.setDbManager(this)},initObjX:function(){const objx=new KSWN.ObjX({id:this.getId(),ObjectCode:"DB_LIST_MANAGER",renderPanel:this.mainPanel});objx.removeContainer(),objx.dbManager=this,this.objx=objx},initOperationsCollection:function(){this.dbListModelOperationsCollection=new KSWN.core.dbManager.dbListModelOperation.Collection,this.relayEvents(this.dbListModelOperationsCollection,["operationstart","operationfinish","operationdestroy"])},runContextMenuItemTask:function(node,taskName){if(!taskName)return;const method=_.chain(taskName).split(".").last().lowerFirst().value();method&&this[method]?this[method](node):this.runNodeTask(node,taskName)},runNodeTask:function(node,taskName){if(!(taskName=taskName||node.getTaskName()))return;const{objx:objx}=this,dbName=node.getDbName(),sessionKey=node.getDbSessionKey();objx.setDataSource(sessionKey,dbName),KSWN.MMX.ExecFunctionInObjX(objx,()=>{KSWN.MMX.ExecStrFunc(taskName);const mmx=KSWN.MMX.tryGetCurrentMMX(),clear=()=>objx.clearDataSource();mmx&&mmx.stop?mmx.on({finished:clear,canceled:clear}):clear()})},checkDbConnectionsExists:async function(_ref33){let{node:node,showDatabaseIsBusyMessage:showDatabaseIsBusyMessage=!0}=_ref33;const result=await this.executeDbListOperation({url:"DbList/CheckDbConnectionsExists",additionalRequestParams:{dbName:node.getDbName()},addNodeDataToProxyCallParams:!1,useDbNodeSessionKey:!1,node:node});if(!result)throw new Error(KSWN.Locale.erroperatsiyanevozmozhna);return result.Fail&&showDatabaseIsBusyMessage&&KSWN.util.ExtUtils.Alert(KSWN.Locale.erroperatsiyanevozmozhnabdispolzuetsyadrugimipolzovatelyami),result.Fail},checkRestoreDatabaseSpace:async function(_ref34){let{node:node,backupFileInfo:backupFileInfo}=_ref34;const result=await this.executeDbListOperation({url:"DbList/CheckRestoreDatabaseSpace",additionalRequestParams:{dbName:node.getDbName(),backupFileInfo:backupFileInfo},addNodeDataToProxyCallParams:!1,node:node});return this.processCheckSpaceResult(result)},processCheckSpaceResult:async function(result){let success=!0;if(result){if(result.Fail){const checkSpaceMsg=[KSWN.Locale.proverka_svobodnogo_mesta_dlya_sozdania_rezervnoy_kopii+".<br><br>",""+(result.Message?result.Message+"<br><br>":""),KSWN.Locale.vseravnoprodolzhit].join("");success=await KSWN.util.ExtUtils.AsyncConfirm({title:KSWN.Locale.podtverzhdenie,message:checkSpaceMsg})}}else success=!1;return success},processList:function(){let dbNode=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();KSWN.core.dbManager.ProcessList.openDbProcessList({dbNode:dbNode})},openMessageList:function(){let node=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.getSelectedDbListNode();if(!node.isMessageDbNode())return;const dbNode=node.getDbNode();KSWN.core.dbManager.MessageList.openDbMessageList({dbNode:dbNode})},getSelectedDbListNode:function(){return this.tree.getSelection()[0]},maskMainPanel:function(){let msg=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];this.mainPanel.setLoading(msg)},unMaskMainPanel:function(){this.mainPanel.setLoading(!1)},executeDbListOperation:async function(){let operationParams=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};operationParams.sessionKey=this.session.key;const operation=this.dbListModelOperationsCollection.createOperation(operationParams);try{return await operation.run()}finally{operation.destroy()}},load:async function(){const res=await Ajax({url:"/DbList/LoadOutcomeByConnection",mask:{text:KSWN.Locale.zagruzka,id:this.mainPanel,showImmediately:!0},params:this.connectionParams});this.processDbListResponse(res)},refresh:async function(){if(this.destoryed)return;const res=await Ajax({url:"DbList/LoadOutcomeByKey",mask:{text:KSWN.Locale.obnovlenie,id:this.mainPanel,showImmediately:!0},params:{key:this.session.key}});this.processDbListResponse(res)},processDbListResponse:function(res){if(!res)return void this.destroy();const treeCmp=this.tree,store=treeCmp.getStore(),{tree:tree,key:key,server:server,user:user,dataSourceType:dataSourceType}=res;store.loadTree(tree),store.setAdminServerNodeSessionKey(key),treeCmp.selectCurrentDBNode(),this.dataSourceType=dataSourceType,this.session={key:key,server:server,user:user}},handleOperationError:function(err){err.isError&&KSWN.ErrorHandler.handle(err);const desc=err.message;this.destroyed?KSWN.app.showNotification({title:"Ошибка выполнения операции",description:err.message,savable:!1}):KSWN.ExtUtils.Alert("#err#Ошибка выполнения операции<br>"+desc)},showFormWindow:function(config){const WindowClassComponent=Ext.ClassManager.getByConfig(config);return WindowClassComponent||Ext.raise("Не найден компонент окна формы!"),config.dbManager=this,WindowClassComponent.showWindow(config)},isMSSQLDataSourceType:function(){return"MSSQL"===this.dataSourceType},isPgDataSourceType:function(){return"PostgreSQL"===this.dataSourceType},closeManager:function(){this.mainPanel.destroy()},getSession:function(){return this.session},destroy:function(){this.observers=null,this.dbListModelOperationsCollection.destroy(),this.callParent()}});