Ext.define("KSWN.meta.workScheduler.model.Calendar",{extend:"Ext.calendar.model.Calendar",config:{eventStoreDefaults:{type:"calendar-events",model:"KSWN.meta.workScheduler.model.Event",proxy:{type:"memory"}}},loadEvents:function(events){var store=this.events();return store.loadRawData(events),store.getRange()}}),Ext.define("KSWN.meta.workScheduler.Panel",{extend:"Ext.panel.Panel",xtype:"ks-workschedulerpanel",layout:{type:"hbox",align:"stretch"},border:0,bodyPadding:4,bodyStyle:{borderTop:"0px"},reference:"workschedulerManager",viewModel:"ks-workscheduler",controller:"ks-workscheduler",listeners:{render:"onRender"},dockedItems:[{xtype:"toolbar",layout:{type:"hbox",align:"center"},items:[]}],items:[{tbar:[{iconCls:"ks-icon-new",tooltip:KSWN.Locale.sozdat,handler:"onAddEventBtnClick"},{iconCls:"ks-icon-edit",tooltip:KSWN.Locale.redaktirovat,handler:"onEditEventBtnClick",bind:{disabled:"{!eventListSelected}"}},"-",{iconCls:"ks-icon-save",tooltip:KSWN.Locale.sokhranit,handler:"onSaveBtnClick"},"-",{iconCls:"ks-icon-delete",tooltip:KSWN.Locale.udalit,handler:"onDropEventBtnClick",bind:{disabled:"{!eventListSelected}"}},"-",{iconCls:"ks-icon-refresh",tooltip:KSWN.Locale.obnovit,handler:"onRefreshBtnClick"},{iconCls:"ks-icon-settings",tooltip:KSWN.Locale.nastroiki,handler:"onSettingsBtnClick"}],dock:"left",xtype:"gridpanel",title:KSWN.Locale.intervali,reference:"workschedulerEventsList",collapsible:!0,collapseDirection:"left",width:450,resizible:!0,resizeHandles:"x",viewConfig:{markDirty:!1},columns:[{text:KSWN.Locale.nazvanie,dataIndex:"title"},{text:KSWN.Locale.nachalo,xtype:"datecolumn",format:"H:i d.m.y",dataIndex:"startDate",width:140},{text:KSWN.Locale.konets,xtype:"datecolumn",format:"H:i d.m.y",dataIndex:"endDate",width:140},{xtype:"booleancolumn",text:KSWN.Locale.povtor,dataIndex:"recurrence",trueText:KSWN.Locale.mnogokratnoe,falseText:KSWN.Locale.odnokratnoe}],height:"100%",margin:"0 4 0 0",listeners:{selectionchange:"onEventsListSelectChange",itemdblclick:"onEventListItemDblClick"},bind:{store:"{eventStore}",selection:"{eventListSelected}"}},{xtype:"panel",tbar:[{text:KSWN.Locale.segodnya,handler:"onTodayClick"},{text:"<",handler:"onClickPrev"},{text:">",handler:"onClickNext"},{xtype:"title",margin:"0 12",style:{fontSize:"12px"},bind:'{ visibleStart:date("d.m.Y") + " - " + visibleEnd:date("d.m.Y") }'}],layout:"fit",border:0,items:{xtype:"ks-workscheduler-calendarpanel",bind:{store:"{calendarStore}",value:"{date}",markedCell:"{eventListSelected}"}},flex:1}],CommitStoreChanges:function(){this.GetCalendarStore().getEventSource().commitChanges()},HasModifiedEvents:function(){return _.size(this.GetUpdatedEvents())>0||_.size(this.GetRemovedEvents())},GetUpdatedEvents:function(){return this.GetCalendarStore().getEventSource().getModifiedRecords()},GetRemovedEvents:function(){return this.GetCalendarStore().getEventSource().getRemovedRecords()},OnBeforeRefresh:function(){const me=this;if(me.HasModifiedEvents())return me.ShowSaveAlertMessage(),!1},Refresh:async function(){const calendarStore=this.GetCalendarStore();if(!1===this.OnBeforeRefresh())return;const res=await this.FetchData();res&&(calendarStore.loadEvents(res.Events,res.Users),this.CommitStoreChanges())},ShowSaveAlertMessage:function(){Ext.Msg.show({title:KSWN.Locale.preduprezhdenie,msg:KSWN.Locale.sokhranitizmeneniya,buttons:Ext.Msg.YESNOCANCEL,icon:Ext.Msg.WARNING,callback:btn=>{"yes"===btn?this.Save():"no"===btn&&(this.CommitStoreChanges(),this.Refresh())}})},FetchData:function(){return KSWN.getConnection().Ajax({url:"WorkScheduler/LoadOutcome",mask:{id:this,msg:KSWN.Locale.zagruzka,showImmediately:!0}})},Save:async function(){try{const dataForSave=this.GetCalendarStore().GetEventsDataForSave(),res=await KSWN.getConnection().Ajax({url:"WorkScheduler/Save",params:dataForSave});if(!res||res.Fail)throw new Error(res.Message);KSWN.app.showBubbleMessage({text:KSWN.Locale.sokhraneno})}catch(e){KSWN.MessageBox.alertMsg(`#err#${KSWN.Locale.oshibkasokhraneniya}<br>${e.message}`)}},GetCalendarStore:function(){return this.lookupViewModel().get("calendarStore")}}),Ext.define("KSWN.meta.workScheduler.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-workscheduler",init:function(){const vm=this.getViewModel(),eventSource=vm.get("calendarStore").getEventSource();vm.setStores({eventStore:eventSource})},addEvent:function(){const event=KSWN.meta.workScheduler.model.Event.CreateEvent({startDate:new Date((new Date).setMinutes(0,0,0)),endDate:new Date((new Date).setMinutes(60,0,0))});this.getCalendar().showAddForm(event)},editEvent:function(){const event=this.getSelectionEvent();event&&this.getCalendar().showEditForm(event)},removeEvent:function(){const event=this.getSelectionEvent();event&&Ext.Msg.confirm(KSWN.Locale.preduprezhdenie,KSWN.Locale.udalitinterval,(function(btn){"yes"===btn&&event.drop()}))},getCalendar:function(){return this.lookupReference("workschedulerCalendar")},getSelectionEvent:function(){return this.getViewModel().get("eventListSelected")},onClickPrev:function(){this.getCalendar().movePrevious()},onClickNext:function(){this.getCalendar().moveNext()},onTodayClick:function(){this.getCalendar().setValue(new Date)},onAddEventBtnClick:function(){this.addEvent()},onEditEventBtnClick:function(){this.editEvent()},onEventListItemDblClick:function(){this.editEvent()},onDropEventBtnClick:function(){this.removeEvent()},onRefreshBtnClick:function(){this.view.Refresh()},onViewDateChange:function(calendar,change){const range=calendar.getVisibleRange?calendar.getVisibleRange():null;range&&this.getViewModel().set({date:change.value,visibleStart:range.start,visibleEnd:new Date(range.end-1)})},onSaveBtnClick:function(){this.view.Save()},drawEvents:function(){const calendarView=this.lookupReference("workschedulerCalendar");calendarView.store&&calendarView.DrawEvents()},onRender:function(){const range=this.getCalendar().getVisibleRange();this.getViewModel().set({visibleStart:range.start,visibleEnd:new Date(range.end-1)}),this.view.Refresh()},onEventsListSelectChange:function(grid,selected){const eventStartDate=selected&&selected[0]?selected[0].getStartDate():null;if(eventStartDate){this.getCalendar().setValue(eventStartDate)}},onEventClick:function(view,context){this.lookupReference("workschedulerEventsList").setSelection(context.event)},onSettingsBtnClick:function(){KSWN.meta.task.Settings.Show({ObjCode:"WORKSCHEDULER"})}}),Ext.define("KSWN.meta.workScheduler.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-workscheduler",data:{date:new Date,activeView:1,eventListSelected:null,dateRange:null},stores:{calendarStore:{type:"ks-workschedulercalendars",data:[]}}}),Ext.define("KSWN.meta.workScheduler.calendar.View",{extend:"Ext.calendar.view.Weeks",xtype:"ks-workscheduler-calendarview",controlStoreRange:!1,firstDayOfWeek:1,visibleWeeks:4,listeners:{valuechange:"onViewDateChange"},privates:{isEventHidden:()=>!1},createAddForm:function(){return{xtype:"ks-workscheduler-eventeditor",view:this}},createEditForm:function(){return{xtype:"ks-workscheduler-eventeditor",view:this}}}),Ext.define("KSWN.meta.workScheduler.calendar.Panel",{extend:"Ext.calendar.panel.Weeks",xtype:"ks-workscheduler-calendarpanel",cls:"ks-workscheduler-calendar",reference:"workschedulerCalendar",border:0,layout:"fit",markedCellCls:"ks-workschedulerview-calendarview__marked-cell",config:{markedCell:null,range:{start:null,end:null}},publishes:["markedCell"],flex:1,view:{xtype:"ks-workscheduler-calendarview"},applyMarkedCell:function(selected){if(selected){var me=this,cell=me.view.getCell(selected.getStartDate());me.markedCell&&me.markedCell.classList.remove(me.markedCellCls),me.markedCell=cell,cell.classList.add(me.markedCellCls)}},GetActiveRange:function(){return this.getVisibleRange()},DrawEvents:function(){var view=this.view;view.clearEvents(),view.doRefreshEvents()}}),Ext.define("KSWN.meta.workScheduler.eventEditor.Form",{extend:"Ext.window.Window",mixins:["Ext.calendar.form.Base"],xtype:"ks-workscheduler-eventeditor",title:KSWN.Locale.nastroikaintervala,itemId:"eventEditForm",closeAction:"destroy",closable:!0,floating:!0,autoShow:!1,width:800,modal:!0,bodyPadding:4,layout:"fit",viewModel:"ks-workschedulereventeditor",controller:"ks-workschedulereventeditor",config:{event:null},listeners:{resize:"onViewResize"},items:[{xtype:"form",border:0,bodyPadding:8,width:600,title:KSWN.Locale.nastroiteintervalvremenivtecheniikotorogoukazannimpolzovatelyambudetzapreshchenorabotat,layout:{type:"vbox",align:"stretch"},defaults:{labelWidth:135,margin:"0 0 8 0",flex:1},items:[{xtype:"textfield",fieldLabel:KSWN.Locale.nazvanie,bind:"{event.title}"},{xtype:"combobox",fieldLabel:KSWN.Locale.tsvet,bind:{store:"{colors}",value:"{event.color}"},queryMode:"local",editable:!1,displayField:"color",valueField:"color",fieldStyle:{textTransform:"capitalize"},listConfig:{minWidth:200,itemTpl:new Ext.XTemplate('<div style="display:flex;align-items:center;">','   <div style="width:16px;height:16px;background-color:{color};margin-right:4px;"></div>','   <div style="text-transform: capitalize;">{color}</div>',"</div>")}},{xtype:"checkbox",boxLabel:KSWN.Locale.povtorenie,margin:"0 0 0 138",bind:{value:"{event.recurrence}"}},{xtype:"panel",layout:"vbox",border:1,bodyPadding:4,defaults:{labelWidth:135},bind:{hidden:"{event.recurrence}"},items:[{xtype:"fieldcontainer",fieldLabel:KSWN.Locale.nachalnoevremya,layout:"hbox",items:[{xtype:"datefield",format:"d.m.Y",margin:"0 8 0 0",flex:1,bind:"{startDate}"},{xtype:"timefield",format:"H:i",increment:5,flex:1,bind:"{startTime}"}]},{xtype:"fieldcontainer",fieldLabel:KSWN.Locale.konechnoevremya,layout:"hbox",items:[{xtype:"datefield",format:"d.m.Y",margin:"0 8 0 0",flex:1,bind:"{endDate}"},{xtype:"timefield",format:"H:i",increment:5,flex:1,bind:"{endTime}"}]}]},{xtype:"ks-workschedulerreccurence-editor",border:1,bodyPadding:"8 4 4 4",bind:{hidden:"{!event.recurrence}"}},{xtype:"textfield",fieldLabel:KSWN.Locale.polzovateli,editable:!1,bind:"{event.usersText}",listeners:{render:function(){const textfield=this;Ext.create("Ext.tip.ToolTip",{target:textfield.id,listeners:{beforeshow:function(){if(!textfield.getValue())return!1;this.setHtml(textfield.getValue())}}})}},triggers:{dict:{cls:"ks-icon-dict",handler:"onUserDictTriggerClick"}}},{xtype:"textarea",fieldLabel:KSWN.Locale.opisanie,height:65,bind:"{event.description}"}]}],buttons:[{text:KSWN.Locale.udalit,handler:"onRemoveClick"},"->",{text:KSWN.Locale.sokhranit,handler:"onSaveClick"},{text:KSWN.Locale.otmena,handler:"onCancelClick"}]}),Ext.define("KSWN.meta.workScheduler.eventEditor.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-workschedulereventeditor",init:function(){const vm=this.getViewModel(),event=this.view.event;vm.set("event",Ext.clone(event.getData()))},onViewResize:function(){this.view.center()},getEvent:function(){return this.view.event},onUserDictTriggerClick:function(){const vm=this.getViewModel(),eventData=vm.get("event");Meta.Users.ShowUserList({mode:"get_tree_groups_users_m",multiSelect:!0,checkedLinks:eventData.Users,callback:function(selection,checked){Ext.isArray(checked)||(checked=[checked]);let users=[],uids=[];checked.forEach((function(user){const INode=user.data.INode;users.push(INode.DefaultName),uids.push(+INode.UID)})),uids=Ext.Array.unique(uids),users=Ext.Array.unique(users),eventData.Users=Ext.Array.unique(uids),eventData.usersText=users.join(","),vm.set("event",eventData)}})},onBeforeOccurrenceDurationSelect:function(combo,record){if("string"==typeof record.data.date)return;const event=this.getViewModel().get("event");let allowed=!0;const weekDayMap={1:1,2:2,4:3,8:4,16:5,32:6,64:7};if(0===event.patternFrequency)allowed=record.get("date").getDate()<=2;else if(1===event.patternFrequency){let days=event.weekPatternDaysOfWeek.map(n=>weekDayMap[n]);if(days.length>1){days=days.sort();let diff=days.at(-1)-days.at(-2);diff>=3&&(diff=7-diff),allowed=record.get("date").getDate()-1<=diff}else allowed=record.get("date").getDate()-1<=7}else allowed=record.get("date").getDate()-1<=7;return allowed||KSWN.MessageBox.alertMsg(KSWN.Locale.dlitelnost_intervala_povtorenii_dolzhna_bit_menshe_chastoti_povtoreniya),allowed},onSaveClick:function(){const form=this.view,values=this.getViewModel().get("event");form.getView().toUtcOffset(values.startDate),form.getView().toUtcOffset(values.endDate),this.calculateRangeEndDate(values),form.fireSave(values)},calculateRangeEndDate:function(event){const{rangeLimit:rangeLimit,recurrence:recurrence}=event;if(!recurrence||1!==rangeLimit)return;const{patternFrequency:patternFrequency,rangeMaxOccurrences:rangeMaxOccurrences,dayPatternType:dayPatternType,dayPatternInterval:dayPatternInterval,weekPatternDaysOfWeek:weekPatternDaysOfWeek,weekPatternInterval:weekPatternInterval,monthPatternInterval:monthPatternInterval}=event;if(0===patternFrequency)event.rangeEndDate=dayPatternType?Ext.Date.add(event.rangeStartDate,Ext.Date.DAY,rangeMaxOccurrences):Ext.Date.add(event.rangeStartDate,Ext.Date.DAY,rangeMaxOccurrences*dayPatternInterval);else if(1===patternFrequency){const valueToAdd=Math.ceil(7*rangeMaxOccurrences/weekPatternDaysOfWeek.length||1)*weekPatternInterval*7;event.rangeEndDate=Ext.Date.add(event.rangeStartDate,Ext.Date.DAY,valueToAdd)}else if(2===patternFrequency){const valueToAdd=Math.ceil(rangeMaxOccurrences*monthPatternInterval);event.rangeEndDate=Ext.Date.add(event.rangeStartDate,Ext.Date.MONTH,valueToAdd)}else 3===patternFrequency&&(event.rangeEndDate=Ext.Date.add(event.rangeStartDate,Ext.Date.YEAR,rangeMaxOccurrences))},onCancelClick:function(){this.view.fireCancel()},onRemoveClick:function(){const view=this.view;view.fireDrop(),view.destroy()}}),Ext.define("KSWN.meta.workScheduler.eventEditor.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-workschedulereventeditor",data:{event:{patternFrequency:0,dayPatternInterval:1,dayPatternType:0,weekPatternInterval:1,weekPatternDaysOfWeek:null,monthPatternType:0,monthPatternInterval:1,monthPatternOccurrenceOfDayInMonth:1,monthPatternDaysOfWeek:1,patternDayOfMonth:1,yearPatternType:0,yearPatternInterval:1,patternMonthOfYear:1,yearPatternOccurrenceOfDayInMonth:1,yearPatternDaysOfWeek:1,occurrenceStartTime:new Date((new Date).setMinutes(0)),occurrenceDuration:Ext.Date.parse("01:00","H:i")}},formulas:{startDate:{bind:{bindTo:"{event.startDate}"},get:function(date){return date},set:function(value){const newDate=new Date(this.get("event.startDate"));newDate.setFullYear(value.getFullYear(),value.getMonth(),value.getDate()),this.set("event.startDate",newDate),this.set("rangeStartDate",newDate)}},endDate:{bind:{bindTo:"{event.endDate}"},get:function(date){return date},set:function(value){this.get("event").endDate.setFullYear(value.getFullYear(),value.getMonth(),value.getDate())}},startTime:{bind:{bindTo:"{event.startDate}"},get:function(time){return time},set:function(value){const newDate=new Date(this.get("event.startDate"));newDate.setHours(value.getHours(),value.getMinutes()),this.set("event.startDate",newDate)}},endTime:{bind:{bindTo:"{event.endDate}"},get:function(time){return time},set:function(value){const newDate=new Date(this.get("event.endDate"));newDate.setHours(value.getHours(),value.getMinutes()),this.set("event.endDate",newDate)}},occurrenceStartTime:{bind:"{event.occurrenceStartTime}",get:function(start){if(!start||isNaN(start.getTime())){const startDate=this.get("event.startDate");start=new Date((new Date).setHours(startDate.getHours(),startDate.getMinutes(),0,0)),this.set("event.occurrenceStartTime",start)}return start},set:function(value){this.set("event.occurrenceStartTime",value),this.set("startTime",value)}},occurrenceEndTime:{bind:"{event.occurrenceDuration}",get:function(duration){if(!duration)return Ext.Date.clearTime(new Date);const start=this.get("event.occurrenceStartTime"),end=new Date(start.getTime());return end.setDate(start.getDate()+duration.getDate()-1),end.setHours(start.getHours()+duration.getHours(),start.getMinutes()+duration.getMinutes()),this.set("event.occurrenceEndTime",end),end},set:function(date){date&&(this.set("event.occurrenceEndTime",date),this.set("endTime",date))}},occurrenceDuration:{bind:{start:"{occurrenceStartTime}",end:"{event.occurrenceEndTime}"},get:function(_ref){let{start:start,end:end}=_ref;if(!start||!end){const initialDuration=this.get("event.occurrenceDuration");if(!initialDuration)return"1 "+KSWN.Locale.chas;const predefinedRecord=this.get("occurrenceDurationStore").findRecord("date",initialDuration);return(null==predefinedRecord?void 0:predefinedRecord.get("text"))??Ext.Date.format(initialDuration,"H:i")}end<start&&end.setDate(end.getDate()+1);const duration=Ext.Date.utcToLocal(new Date(end.getTime()-start.getTime()));this.set("event.occurrenceDuration",duration);const record=this.get("occurrenceDurationStore").findRecord("date",duration);return(null==record?void 0:record.get("text"))||Ext.Date.format(duration,"H:i")},set:function(date){if(Ext.isString(date)&&date.includes(":")){const parsed=Ext.Date.parse(date,"H:i");(date=new Date(0)).setHours(parsed.getHours(),parsed.getMinutes())}else if(Ext.isString(date)){date=this.get("occurrenceDurationStore").findRecord("text",date).get("date")}this.set("event.occurrenceDuration",date)}},rangeStartDate:{bind:{start:"{event.rangeStartDate}",startDate:"{event.startDate}",occurrenceStartTime:"{event.occurrenceStartTime}"},get:function(_ref2){let{startDate:startDate,start:start,occurrenceStartTime:occurrenceStartTime}=_ref2;return start||(start=new Date),start.setHours(occurrenceStartTime.getHours(),occurrenceStartTime.getMinutes()),start.setFullYear(startDate.getFullYear(),startDate.getMonth(),startDate.getDate()),this.set("event.rangeStartDate",start),start},set:function(value){this.set("event.rangeStartDate",value)}},rangeEndDate:{bind:{end:"{event.rangeEndDate}",occurrenceEndTime:"{occurrenceEndTime}"},get:function(_ref3){let{end:end,occurrenceEndTime:occurrenceEndTime}=_ref3;return end||(end=this.get("rangeStartDate")??new Date,end.setHours(occurrenceEndTime.getHours(),occurrenceEndTime.getMinutes()),this.set("event.rangeEndDate",end)),end.setHours(occurrenceEndTime.getHours(),occurrenceEndTime.getMinutes()),end},set:function(value){this.set("event.rangeEndDate",value)}}},stores:{repeatTypes:{data:[{text:KSWN.Locale.yezhedenevno,value:0},{text:KSWN.Locale.ezhenedelno,value:1},{text:KSWN.Locale.yezhemesyachno,value:2},{text:KSWN.Locale.yezhegodno,value:3}]},daysVariants:{data:[{text:KSWN.Locale.den,value:0},{text:KSWN.Locale.ponedelnik,day:!0,value:2},{text:KSWN.Locale.vtornik,day:!0,value:4},{text:KSWN.Locale.sreda,day:!0,value:8},{text:KSWN.Locale.chetverg,day:!0,value:16},{text:KSWN.Locale.pyatnitsa,day:!0,value:32},{text:KSWN.Locale.subbota,day:!0,value:64},{text:KSWN.Locale.voskresene,day:!0,value:1},{text:KSWN.Locale.vikhodnoiden,value:65},{text:KSWN.Locale.rabochiiden,value:62}]},daysOfWeek:{type:"chained",source:"{daysVariants}",filters:[{property:"day",value:!0,operator:"="}]},monthOfYear:{data:[KSWN.Locale.yanvar,KSWN.Locale.fevral,KSWN.Locale.mart,KSWN.Locale.aprel,KSWN.Locale.mai,KSWN.Locale.iyun,KSWN.Locale.iyul,KSWN.Locale.avgust,KSWN.Locale.sentyabr,KSWN.Locale.oktyabr,KSWN.Locale.noyabr,KSWN.Locale.dekabr].map((function(text,index){return{text:text,value:index+1}}))},rangeLimitVariants:{data:[KSWN.Locale.neprerivno,KSWN.Locale.pokolichestvupovtorenii,KSWN.Locale.dozadannoidati].map((function(text,index){return{text:text,value:index}}))},orderNum:{data:[KSWN.Locale.pervii,KSWN.Locale.vtoroi,KSWN.Locale.tretii,KSWN.Locale.chetvertii,KSWN.Locale.poslednii].map((function(text,index){return{text:text,value:index+1}}))},colors:{type:"ks-workscheduler-eventcolors",autoLoad:!0},occurrenceDurationStore:{type:"ks-meta-workscheduler-eventeditor-reccurence-occurenceduration"}}}),Ext.define("KSWN.meta.workScheduler.eventEditor.reccurence.store.OccurenceDuration",{extend:"Ext.data.Store",alias:"store.ks-meta-workscheduler-eventeditor-reccurence-occurenceduration",data:[],constructor:function(){this.callParent(arguments),this.initDefaultData()},initDefaultData:function(){this.loadRawData([{text:"0 "+KSWN.Locale.minut,date:new Date(new Date(0).setHours(0,0))},{text:"5 "+KSWN.Locale.minut,date:new Date(new Date(0).setHours(0,5))},{text:"10 "+KSWN.Locale.minut,date:new Date(new Date(0).setHours(0,10))},{text:"15 "+KSWN.Locale.minut,date:new Date(new Date(0).setHours(0,15))},{text:"30 "+KSWN.Locale.minut,date:new Date(new Date(0).setHours(0,30))},{text:"1 "+KSWN.Locale.chas,date:new Date(new Date(0).setHours(1,0))},{text:"2 "+KSWN.Locale.chasa,date:new Date(new Date(0).setHours(2,0))},{text:"3 "+KSWN.Locale.chasa,date:new Date(new Date(0).setHours(3,0))},{text:"4 "+KSWN.Locale.chasa,date:new Date(new Date(0).setHours(4,0))},{text:"5 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(5,0))},{text:"6 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(6,0))},{text:"7 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(7,0))},{text:"8 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(8,0))},{text:"9 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(9,0))},{text:"10 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(10,0))},{text:"11 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(11,0))},{text:"12 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(12,0))},{text:"18 "+KSWN.Locale.chasov,date:new Date(new Date(0).setHours(18,0))},{text:"1 "+KSWN.Locale.den,date:new Date(new Date(0).setHours(24,0))},{text:"2 "+KSWN.Locale.dnya,date:new Date(new Date(0).setHours(48,0))},{text:"3 "+KSWN.Locale.dnya,date:new Date(new Date(0).setHours(72,0))},{text:"4 "+KSWN.Locale.dnya,date:new Date(new Date(0).setHours(96,0))},{text:"1 "+KSWN.Locale.nedelya,date:new Date(new Date(0).setHours(168,0))},{text:"2 "+KSWN.Locale.nedeli,date:new Date(new Date(0).setHours(336,0))}])}}),Ext.define("KSWN.meta.workScheduler.eventEditor.reccurence.Interval",{extend:"Ext.panel.Panel",xtype:"ks-workschedulerreccurence-interval",layout:{type:"hbox",align:"stretch"},defaultType:"timefield",defaults:{labelAlign:"top",format:"H:i",increment:30,flex:1},items:[{fieldLabel:KSWN.Locale.nachalo,margin:"0 8 0 0",bind:"{occurrenceStartTime}"},{reference:"occurrenceEndTimeField",fieldLabel:KSWN.Locale.konets,margin:"0 8 0 0",bind:"{occurrenceEndTime}"},{xtype:"combo",reference:"occurrenceDurationField",fieldLabel:KSWN.Locale.dlitelnost,editable:!1,queryMode:"local",displayField:"text",valueField:"date",listeners:{beforeselect:"onBeforeOccurrenceDurationSelect"},bind:{value:"{occurrenceDuration}",store:"{occurrenceDurationStore}"}}]}),Ext.define("KSWN.meta.workScheduler.eventEditor.reccurence.Daily",{extend:"Ext.panel.Panel",border:0,xtype:"ks-workschedulerreccurence-daily",defaults:{margin:"0 0 8 0",border:0},items:[{layout:{type:"hbox",align:"center"},items:[{xtype:"label",text:KSWN.Locale.povtoryatkazhduyuie,width:140},{xtype:"container",items:{xtype:"numberfield",minValue:1,margin:"0 16 0 0",bind:{value:"{event.dayPatternInterval}"}}},{xtype:"label",text:KSWN.Locale.denei}],bind:{disabled:"{event.dayPatternType}"}},{xtype:"checkbox",boxLabel:KSWN.Locale.pobudnyam,padding:"0 0 0 138",bind:{value:"{event.dayPatternType}"}}]}),Ext.define("KSWN.meta.workScheduler.eventEditor.reccurence.Monthly",{extend:"Ext.panel.Panel",xtype:"ks-workschedulerreccurence-monthly",border:0,defaults:{layout:{type:"vbox"},defaults:{layout:{type:"hbox",align:"center"},margin:"0 0 8 0",border:0},border:0},items:[{items:[{items:[{xtype:"label",text:KSWN.Locale.povtoryatkazhdii,width:140},{xtype:"numberfield",minValue:1,maxValue:99,margin:"0 16 0 0",bind:"{event.monthPatternInterval}"},{xtype:"label",text:KSWN.Locale.mesyats}]},{items:[{xtype:"label",text:KSWN.Locale.den,width:140},{xtype:"numberfield",minValue:1,maxValue:31,margin:"0 16 0 0",bind:"{event.patternDayOfMonth}"}]}],bind:{hidden:"{event.monthPatternType}"}},{items:[{layout:{type:"hbox",align:"center"},margin:"0 0 8 140",items:[{xtype:"combobox",queryMode:"local",displayField:"text",valueField:"value",editable:!1,flex:1,margin:"0 16 0 0",bind:{store:"{orderNum}",value:"{event.monthPatternOccurrenceOfDayInMonth}"}},{xtype:"combobox",queryMode:"local",displayField:"text",valueField:"value",editable:!1,flex:1,bind:{store:"{daysVariants}",value:"{event.monthPatternDaysOfWeek}"}}]},{items:[{xtype:"label",text:KSWN.Locale.kazhdogo,width:140},{xtype:"numberfield",minValue:1,maxValue:99,margin:"0 16 0 0",bind:"{event.monthPatternInterval}"},{xtype:"label",text:KSWN.Locale.mesyatsa}]}],bind:{hidden:"{!event.monthPatternType}"}},{xtype:"checkbox",boxLabel:KSWN.Locale.podrobno,padding:"0 0 0 138",bind:{value:"{event.monthPatternType}"}}]}),Ext.define("KSWN.meta.workScheduler.eventEditor.reccurence.Range",{extend:"Ext.panel.Panel",xtype:"ks-workschedulerreccurence-range",border:0,defaults:{margin:"0 0 8 0",border:0,layout:{type:"hbox",align:"center"}},items:[{items:[{xtype:"label",width:140,text:KSWN.Locale.diapazonpovtorenii},{xtype:"combobox",queryMode:"local",displayField:"text",valueField:"value",editable:!1,flex:1,bind:{store:"{rangeLimitVariants}",value:"{event.rangeLimit}"}}]},{items:[{xtype:"label",width:140,text:KSWN.Locale.nachalopovtorenii},{xtype:"datefield",format:"d.m.Y",flex:1,bind:"{event.rangeStartDate}"}]},{items:[{xtype:"label",width:140,text:KSWN.Locale.konetszavershenii},{xtype:"numberfield",minValue:1,maxValue:99,flex:1,bind:"{event.rangeMaxOccurrences}"}],bind:{hidden:"{ event.rangeLimit !== 1 }"}},{items:[{xtype:"label",width:140,text:KSWN.Locale.konetszavershenii},{xtype:"datefield",format:"d.m.Y",margin:"0 8 0 0",flex:1,bind:"{event.rangeEndDate}"}],bind:{hidden:"{ event.rangeLimit !== 2 }"}}]}),Ext.define("KSWN.meta.workScheduler.eventEditor.reccurence.Reccurence",{extend:"Ext.panel.Panel",xtype:"ks-workschedulerreccurence-editor",defaultType:"fieldcontainer",defaults:{border:0},items:[{xtype:"ks-workschedulerreccurence-interval",margin:"0 0 8 0"},{margin:"0 0 8 0",layout:{type:"hbox",align:"center"},items:[{xtype:"label",width:140,text:KSWN.Locale.povtoryat},{xtype:"combobox",flex:1,queryMode:"local",displayField:"text",valueField:"value",editable:!1,bind:{value:"{event.patternFrequency}",store:"{repeatTypes}"}}]},{xtype:"ks-workschedulerreccurence-daily",bind:{hidden:"{ event.patternFrequency !== 0 }"}},{xtype:"ks-workschedulerreccurence-weekly",bind:{hidden:"{ event.patternFrequency !== 1 }"}},{xtype:"ks-workschedulerreccurence-monthly",bind:{hidden:"{ event.patternFrequency !== 2 }"}},{xtype:"ks-workschedulerreccurence-yearly",bind:{hidden:"{ event.patternFrequency !== 3 }"}},{xtype:"ks-workschedulerreccurence-range"}]}),Ext.define("KSWN.meta.workScheduler.eventEditor.reccurence.Weekly",{extend:"Ext.panel.Panel",xtype:"ks-workschedulerreccurence-weekly",border:0,defaults:{margin:"0 0 8 0",border:0,layout:{type:"hbox",align:"center"}},items:[{margin:"0 0 8 0",items:[{xtype:"label",text:KSWN.Locale.povtoryatkazhduyuie,width:140},{xtype:"container",items:{xtype:"numberfield",minValue:1,margin:"0 16 0 0",bind:{value:"{event.weekPatternInterval}"}}},{xtype:"label",text:KSWN.Locale.nedelyui}]},{items:[{xtype:"label",text:KSWN.Locale.povtoryatpo,width:140},{xtype:"tagfield",flex:1,queryMode:"local",editable:!1,grow:!1,selectOnFocus:!1,displayField:"text",valueField:"value",bind:{store:"{daysOfWeek}",value:"{event.weekPatternDaysOfWeek}"}}]}]}),Ext.define("KSWN.meta.workScheduler.eventEditor.reccurence.Yearly",{extend:"Ext.panel.Panel",xtype:"ks-workschedulerreccurence-yearly",border:0,defaults:{margin:"0 0 8 0",border:0},items:[{layout:{type:"hbox",align:"center"},items:[{xtype:"label",text:KSWN.Locale.povtoryat,width:140},{xtype:"numberfield",minValue:1,maxValue:31,margin:"0 16 0 0",bind:"{event.patternDayOfMonth}"},{xtype:"combobox",queryMode:"local",displayField:"text",valueField:"value",editable:!1,flex:1,bind:{store:"{monthOfYear}",value:"{event.patternMonthOfYear}"}}],bind:{hidden:"{event.yearPatternType}"}},{layout:{type:"vbox"},defaults:{border:0},items:[{layout:{type:"hbox",align:"center"},margin:"0 0 8 140",items:[{xtype:"combobox",queryMode:"local",displayField:"text",valueField:"value",editable:!1,flex:1,margin:"0 16 0 0",bind:{store:"{orderNum}",value:"{event.yearPatternOccurrenceOfDayInMonth}"}},{xtype:"combobox",queryMode:"local",displayField:"text",valueField:"value",editable:!1,flex:1,bind:{store:"{daysVariants}",value:"{event.yearPatternDaysOfWeek}"}}]},{layout:{type:"hbox",align:"center"},items:[{xtype:"label",text:KSWN.Locale.vmesyatse,width:140},{xtype:"combobox",queryMode:"local",displayField:"text",valueField:"value",editable:!1,margin:"0 0 8 0",bind:{store:"{monthOfYear}",value:"{event.patternMonthOfYear}"}}]}],bind:{hidden:"{!event.yearPatternType}"}},{xtype:"checkbox",boxLabel:KSWN.Locale.podrobno,padding:"0 0 0 138",bind:{value:"{event.yearPatternType}"}}]}),Ext.define("KSWN.meta.workScheduler.model.Event",{extend:"Ext.calendar.model.Event",statics:{modelCount:0,GetNextModelCount:function(){return this.modelCount++},CreateEvent:function(params){params=params||{};const modelCount=KSWN.meta.workScheduler.model.Event.GetNextModelCount(),defaults={Link:-1*modelCount-1e5,title:KSWN.Locale.interval+modelCount,calendarId:1};return new KSWN.meta.workScheduler.model.Event(Ext.apply({startDate:params.startDate,endDate:params.endDate},defaults))}},fields:[{name:"startDate",type:"date",dateFormat:"c",mapping:function(data){return data.StartDateTime}},{name:"endDate",type:"date",dateFormat:"c",mapping:function(data){return data.EndDateTime}},{name:"title",type:"string",mapping:function(data){return data.Subject}},{name:"color",type:"string",defaultValue:"blue",mapping:function(data){let color=data.Detail.Color;const uxColor=Ext.ux.colorpick.ColorUtils.colorMap,rgb=color?color.split(", "):null;return 3===rgb.length&&(color=_.findKey(uxColor,uxRGB=>_.eq(uxRGB.toString(),rgb.toString()))),color||"blue"}},{name:"recurrence",type:"boolean",defaultValue:!1,mapping:function(data){return!!data.Detail.Recurrence}},{name:"isRemoved",type:"boolean",defaultValue:!1,mapping:function(data){return data.Detail.IsRemoved}},{name:"isChanged",type:"boolean",defaultValue:!0,mapping:function(data){return data.Detail.IsChanged}},{name:"occurrenceStartTime",type:"date",mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence){const time=Date.parse(recurrence.OccurrenceStartTime);return new Date(isNaN(time)?"":time)}}},{name:"occurrenceEndTime",type:"date"},{name:"occurrenceDuration",type:"date",mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence){let days,time;recurrence.OccurrenceDuration.includes(".")?[days,time]=recurrence.OccurrenceDuration.split("."):time=recurrence.OccurrenceDuration;const durationTime=Ext.Date.parse(time,"H:i:s"),duration=new Date(0);return duration.setHours(durationTime.getHours(),durationTime.getMinutes()),days&&duration.setDate(+days+1),duration}}},{name:"patternFrequency",type:"int",defaultValue:0,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&recurrence.PatternFrequency?recurrence.PatternFrequency:0}},{name:"dayPatternInterval",type:"int",defaultValue:1,depend:["dayPatternType"],convert:function(value,record){return record.get("dayPatternType")?5:value},mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&0===recurrence.PatternFrequency?recurrence.PatternInterval:1}},{name:"dayPatternType",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence)return 0===recurrence.PatternFrequency?recurrence.PatternType:1},convert:function(value){return+value}},{name:"weekPatternInterval",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&1===recurrence.PatternFrequency?recurrence.PatternInterval:1}},{name:"weekPatternDaysOfWeek",defaultValue:[],mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;let bit;if(recurrence)return bit=1===recurrence.PatternFrequency?recurrence.PatternDaysOfWeek:1,[0,1,2,3,4,5,6].map((function(num){return Math.pow(2,num)})).filter((function(num){return num&bit}))}},{name:"monthPatternInterval",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&2===recurrence.PatternFrequency?recurrence.PatternInterval:1}},{name:"monthPatternOccurrenceOfDayInMonth",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&2===recurrence.PatternFrequency?recurrence.PatternOccurrenceOfDayInMonth:1}},{name:"monthPatternDaysOfWeek",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence)return 2===recurrence.PatternFrequency?recurrence.PatternDaysOfWeek:1}},{name:"monthPatternType",type:"int",defaultValue:0,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence)return 2===recurrence.PatternFrequency?recurrence.PatternType:0}},{name:"yearPatternInterval",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&3===recurrence.PatternFrequency?recurrence.PatternInterval:1}},{name:"yearPatternOccurrenceOfDayInMonth",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&3===recurrence.PatternFrequency?recurrence.PatternOccurrenceOfDayInMonth:1}},{name:"yearPatternDaysOfWeek",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence)return 3===recurrence.PatternFrequency?recurrence.PatternDaysOfWeek:1}},{name:"yearPatternType",boolean:"int",defaultValue:0,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence)return 3===recurrence.PatternFrequency?recurrence.PatternType:0}},{name:"patternDayOfMonth",type:"int",defaultValue:1,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence)return recurrence.PatternDayOfMonth}},{name:"patternMonthOfYear",type:"int",defaultValue:0,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&recurrence.PatternMonthOfYear?recurrence.PatternMonthOfYear:0}},{name:"rangeStartDate",type:"date",mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence)return recurrence.RangeStartDate}},{name:"rangeEndDate",type:"date",mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;if(recurrence)return recurrence.RangeEndDate}},{name:"rangeLimit",type:"int",defaultValue:0,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&recurrence.RangeLimit?recurrence.RangeLimit:0}},{name:"rangeMaxOccurrences",type:"int",defaultValue:10,mapping:function(data){const recurrence=data.Detail?data.Detail.Recurrence:null;return recurrence&&recurrence.RangeMaxOccurrences?recurrence.RangeMaxOccurrences:10}},{name:"usersText",type:"string"}],validators:[{type:"bound",field:"dayPatternInterval",min:1,max:99},{type:"bound",field:"weekPatternInterval",min:1,max:99},{type:"bound",field:"monthPatternInterval",min:1,max:99},{type:"bound",field:"yearPatternInterval",min:1,max:99},{type:"bound",field:"patternDayOfMonth",min:1,max:28},{type:"bound",field:"patternDayOfMonth",min:1,max:28},{type:"bound",field:"rangeMaxOccurrences",min:1,max:99}],convertDateToServerFormat:function(date){return Ext.Date.format(date,"Y-m-d\\TH:i:s")},convertDateToTimeSpan:function(date){const days=date.getDate()-1,time=Ext.Date.format(date,"H:i:s");return days?[days,time].join("."):time},convertDate:function(date){return Ext.Date.format(date,"d.m.Y H:i:s")},getStartDate:function(){return this.get("startDate")},getEndDate:function(){return this.get("endDate")},getUsers:function(){return this.data.users},getUids:function(){return this.data.Users},getRange:function(){return new Ext.calendar.date.Range(this.getStartDate(),this.getEndDate())},isEditable:Ext.returnTrue,getRecurrence:function(){const data=this.data;let result=null,type="";if(data.recurrence){switch(result={OccurrenceDuration:this.convertDateToTimeSpan(data.occurrenceDuration),OccurrenceStartTime:this.convertDateToServerFormat(data.occurrenceStartTime),OccurrenceEndTime:this.convertDateToServerFormat(data.occurrenceEndTime),PatternFrequency:data.patternFrequency,PatternDayOfMonth:data.patternDayOfMonth,PatternMonthOfYear:data.patternMonthOfYear,RangeStartDate:this.convertDateToServerFormat(data.rangeStartDate),RangeEndDate:this.convertDateToServerFormat(data.rangeEndDate),RangeLimit:data.rangeLimit,RangeMaxOccurrences:data.rangeMaxOccurrences},data.patternFrequency){case 0:type="day";break;case 1:type="week";break;case 2:type="month";break;case 3:type="year"}Ext.apply(result,{PatternInterval:data[type+"PatternInterval"]||1,PatternType:data[type+"PatternType"],PatternDaysOfWeek:_.sum(data[type+"PatternDaysOfWeek"]),PatternOccurrenceOfDayInMonth:data[type+"PatternOccurrenceOfDayInMonth"]})}return result},getDataForRemove:function(){return{Link:this.get("Link")}},getDataForSave:function(){const data=this.getData(),startDate=this.convertDateToServerFormat(data.startDate),recurrence=this.getRecurrence(),uxColor=Ext.ux.colorpick.ColorUtils,detail={OriginalStartDateTime:startDate,StartDateTime:startDate,EndDateTime:this.convertDateToServerFormat(data.endDate),IsRemoved:!1,Color:_.join(uxColor.colorMap[data.color],", "),Recurrence:recurrence};return{Link:data.Link,LinkSelf:data.LinkSelf,Users:data.Users,Subject:data.title,IsChanged:!0,IsRemoved:!1,Description:data.description,Detail:JSON.stringify(detail)}}}),Ext.define("Meta.WorkScheduler.Store.Calendars",{extend:"Ext.calendar.store.Calendars",alias:"store.ks-workschedulercalendars",model:"KSWN.meta.workScheduler.model.Calendar",parseEvents:function(data,users){const parseDate=function(date){return new Date(Date.parse(date))};return data=data.map((function(event){return event.Detail=JSON.parse(event.Detail),event.startDate=parseDate(event.Detail.StartDateTime),event.endDate=parseDate(event.Detail.EndDateTime),event.usersText=event.Users.map((function(uid){return users[uid]||""})).join(","),event.calendarId=1,event}))},getEventSource:function(){let source=this.eventSource;return source||(source=this.eventSource=new KSWN.meta.workScheduler.store.EventSource({source:this})),source},loadEvents:function(events,users){const source=this.getEventSource();let calendar;events=this.parseEvents(events,users),calendar=this.add({id:1,title:KSWN.Locale.raspisanieraboti})[0],events=calendar.loadEvents(events),source.addEvents(events)},GetUpdatedEvents:function(){return this.getEventSource().getModifiedRecords()},GetRemovedEvents:function(){return this.getEventSource().getRemovedRecords()},GetEventsDataForSave:function(){return{updated:this.GetUpdatedEvents().map((function(event){return event.getDataForSave()})),removed:this.GetRemovedEvents().map((function(event){return event.getDataForRemove()}))}}}),Ext.define("KSWN.meta.workScheduler.store.EventSource",{extend:"Ext.calendar.store.EventSource",alias:"store.ks-workschedulereventsource",trackRemoved:!0,privates:{onEventStoreAdd:function(store,records){var i,rec,len=records.length,toAdd=[];for(i=0;i<len;++i)rec=records[i],toAdd.push(rec);toAdd.length>0&&this.getDataSource().add(toAdd)},createEvent:function(data){return delete data.allDay,KSWN.meta.workScheduler.model.Event.CreateEvent(data)}},addEvents:function(events){this.getDataSource().add(events)}}),Ext.define("KSWN.meta.workScheduler.store.Colors",{extend:"Ext.data.Store",alias:"store.ks-workscheduler-eventcolors",fields:[{name:"color",type:"string"}],load:function(){const uxColors=Ext.ux.colorpick.ColorUtils.colorMap,colors=[];_.forIn(uxColors,(rgb,color)=>{colors.push({color:color})}),this.loadRawData(colors)}});