Ext.define("KSWN.core.serverCacheManager.model.CacheTable",{extend:"Ext.data.Model",fields:[{name:"checked",type:"boolean"},{name:"Code",type:"string"},{name:"OpenSessionsCount",type:"number"},{name:"Version",type:"number"}]}),Ext.define("KSWN.core.serverCacheManager.store.CacheTablesStore",{extend:"KSWN.core.data.ProxyStore",alias:"store.ks-core-servercachemanager-cachetablesstore",model:"KSWN.core.serverCacheManager.model.CacheTable",loadUrl:"/ServerCacheManager/GetDbCache"}),Ext.define("KSWN.core.serverCacheManager.view.ViewController",{extend:"Ext.app.ViewController",alias:"controller.ks-core-servermanager",init:function(){const dbName=KSWN.getWebProject().getDbName();this.getViewModel().set({cacheTablesGridTitle:Ext.String.format(KSWN.Locale.tablici_kesha_bd_0,dbName)})},onRemoveSelectedCacheTablesBtnClick:async function(){const checkedTables=this.getViewModel().get("checkedCacheTablesCollection"),count=(null==checkedTables?void 0:checkedTables.count())??0;if(0===count)return;if(await KSWN.core.messageBox.MessageBox.asyncConfirm({message:Ext.String.format(KSWN.Locale.vy_deystvitelno_hotite_udalit_0_tablici,count)})){await this.getServerCacheManager().dropCacheTables(checkedTables.getRange())&&this.reloadCacheTablesStore()}},onRemoveAllCacheTablesBtnClick:async function(){if(await KSWN.core.messageBox.MessageBox.asyncConfirm({message:KSWN.Locale.videistvitelnokhotiteudalitvsetablitsi})){await this.getServerCacheManager().dropAllCacheTables()&&this.reloadCacheTablesStore()}},onRefreshCacheTablesStoreBtnClick:function(){this.reloadCacheTablesStore()},reloadCacheTablesStore:function(){this.getStore("cacheTablesStore").reload()},getServerCacheManager:function(){const{serverCacheManager:serverCacheManager}=this.getView();return serverCacheManager}}),Ext.define("KSWN.core.serverCacheManager.view.ViewModel",{extend:"Ext.app.ViewModel",alias:"viewmodel.ks-core-servermanager",data:{cacheTablesGridTitle:"",selectedCacheTable:null,cacheTableGridStatusBarText:"",checkedCacheTablesCount:0,checkedCacheTablesCollection:null},formulas:{cacheTableGridStatusBarText:{bind:{loading:"{cacheTablesStore.loading}",count:"{cacheTablesStore.count}"},get:_ref=>{let{loading:loading,count:count}=_ref;return loading?KSWN.Locale.zagruzka:`${KSWN.Locale.vsego_zapisey} ${count}`}},checkedCacheTablesCollection:{bind:{bindTo:"{cacheTablesStore}",deep:!0},get:store=>store.query("checked",!0)},checkedCacheTablesCount:{bind:{bindTo:"{checkedCacheTablesCollection}"},get:collection=>(null==collection?void 0:collection.count())??0}},stores:{cacheTablesStore:{type:"ks-core-servercachemanager-cachetablesstore",autoLoad:!0}}}),Ext.define("KSWN.core.serverCacheManager.view.View",{extend:"Ext.panel.Panel",xtype:"ks-core-servermanager",viewModel:"ks-core-servermanager",controller:"ks-core-servermanager",layout:"fit",items:{xtype:"panel",layout:{type:"hbox",align:"stretch"},items:[{xtype:"ks-gridbase",reference:"cacheTablesGrid",border:0,bodyBorder:0,flex:1,stateful:!1,operationMode:"show",showFilter:!0,scrollable:!0,header:{border:0,bind:{title:"{cacheTablesGridTitle}"}},tbar:[{iconCls:KSWN.Constant.iconClsPrefix+"delete_from_server",reference:"removeSelectedCacheTablesBtn",text:KSWN.Locale.udalitvibrannie,handler:"onRemoveSelectedCacheTablesBtnClick",bind:{disabled:"{ checkedCacheTablesCount === 0 }"}},{iconCls:KSWN.Constant.iconClsPrefix+"delete",reference:"removeAllCacheTablesBtn",text:KSWN.Locale.ochistit,handler:"onRemoveAllCacheTablesBtnClick"},{iconCls:KSWN.Constant.iconClsPrefix+"refresh",text:KSWN.Locale.obnovit,reference:"refreshCacheTablesStoreBtn",handler:"onRefreshCacheTablesStoreBtnClick"}],columns:[{xtype:"rownum-ext"},{xtype:"check-ext"},{dataIndex:"Code",text:KSWN.Locale.naimenovanie,sortable:!0,flex:1},{dataIndex:"Version",text:"V",sortable:!1,width:30},{dataIndex:"OpenSessionsCount",text:"S",sortable:!1,width:30}],bbar:{xtype:"statusbar",width:"100%",bind:{text:"{cacheTableGridStatusBarText}"}},bind:{selection:"{selectedCacheTable}",store:"{cacheTablesStore}"}}]}}),Ext.define("KSWN.core.serverCacheManager.ServerCacheManager",{objectCode:"SERVER_CACHE_MANAGER",iconCls:KSWN.Constant.iconClsPrefix+"databases",title:KSWN.Locale.menedzherkesha,view:null,viewModel:null,controller:null,objx:null,constructor:function(config){this.initConfig(config),this.init()},init:function(){this.renderView()},renderView:function(){const view=new KSWN.core.serverCacheManager.view.View({serverCacheManager:this}),objx=KSWN.core.dashboard.Starter.CustomTabOpen({objectCode:this.objectCode,iconCls:this.iconCls,title:this.title},view,!0);objx?(this.view=view,this.viewModel=view.getViewModel(),this.controller=view.getController(),this.objx=objx,view.on("destroy",this.onViewDestroy,this)):this.destroy()},onViewDestroy:function(){this.view=null,this.destroy()},dropCacheTables:async function(tables){const tableNames=tables.map(table=>table.get("Code"));return!!await KSWN.getConnection().Ajax({url:"/ServerCacheManager/DropTablesByNames",params:{tableNames:tableNames}})},dropAllCacheTables:async function(){return!!await KSWN.getConnection().Ajax({url:"ServerCacheManager/DropAllTables"})},destroy:function(){Ext.destroy(this.view),this.view=null,this.viewModel=null,this.objx=null,this.controller=null,this.callParent()}});