Ext.define("Ext.calendar.EventBase",{extend:"Ext.Gadget",config:{defaultTitle:"(New Event)",endDate:null,mode:null,model:null,palette:null,resize:!1,startDate:null,title:"",touchAction:{panX:!1,panY:!1},view:null},cloneForProxy:function(){var result=new this.self(this.config);return result.el.unselectable(),result},updateModel:function(model){var dom;model&&(this.setStartDate(model.getStartDate()),this.setEndDate(model.getEndDate()),this.setTitle(model.getTitle()),(dom=this.element.dom).setAttribute("data-eventId",model.id),dom.setAttribute("data-calendarId",model.getCalendarId()))},updateResize:function(resize){this.toggleCls(this.$allowResizeCls,resize)},privates:{$allowResizeCls:Ext.baseCSSPrefix+"calendar-event-resizable"}}),Ext.define("Ext.calendar.Event",{extend:"Ext.calendar.EventBase",xtype:"calendar-event",config:{timeFormat:"H:i"},smallSize:60,getElementConfig:function(){var cfg=this.callParent();return cfg.cls=Ext.baseCSSPrefix+"calendar-event",cfg.children=[{cls:Ext.baseCSSPrefix+"calendar-event-inner",reference:"innerElement",children:[{cls:Ext.baseCSSPrefix+"calendar-event-time",reference:"timeElement",children:[{tag:"span",reference:"startElement",cls:Ext.baseCSSPrefix+"calendar-event-time-start"},{tag:"span",html:" - ",reference:"separatorElement",cls:Ext.baseCSSPrefix+"calendar-event-time-separator"},{tag:"span",reference:"endElement",cls:Ext.baseCSSPrefix+"calendar-event-time-end"}]},{reference:"titleElement",tag:"span",cls:Ext.baseCSSPrefix+"calendar-event-title"},{cls:Ext.baseCSSPrefix+"calendar-event-resizer",reference:"resizerElement"}]}],cfg},updateEndDate:function(date){this.endElement.setText(this.displayDate(date)),this.calculateSize()},updateMode:function(mode){this.addCls(this.modes[mode]),"weekinline"!==mode&&"weekspan"!==mode||this.addCls(this.$inlineTitleCls)},updatePalette:function(palette){var inner=this.innerElement.dom.style,mode=this.getMode();"weekspan"===mode||"day"===mode?(inner.backgroundColor=palette.primary,inner.color=palette.secondary,"day"===mode&&(this.element.dom.style.borderColor=palette.border)):inner.color=palette.primary},updateStartDate:function(date){this.startElement.setText(this.displayDate(date)),this.calculateSize()},updateTitle:function(title){title=title||this.getDefaultTitle(),this.titleElement.setText(title)},privates:{$inlineTitleCls:Ext.baseCSSPrefix+"calendar-event-inline-title",modes:{day:Ext.baseCSSPrefix+"calendar-event-day",weekspan:Ext.baseCSSPrefix+"calendar-event-week-span",weekinline:Ext.baseCSSPrefix+"calendar-event-week-inline"},calculateSize:function(){var small,me=this,start=me.getStartDate(),end=me.getEndDate(),ms=me.getView().MS_TO_MINUTES,isDay="day"===me.getMode();(!isDay||start&&end)&&(small=!isDay||end-start<=me.smallSize*ms,me.element.toggleCls(me.$inlineTitleCls,small))},displayDate:function(d){if(d)return d=this.getView().utcToLocal(d),Ext.Date.format(d,this.getTimeFormat())}}}),Ext.define("Ext.calendar.AbstractList",{extend:"Ext.view.View",updateNavigationModel:function(navigationModel,oldNavigationModel){navigationModel.focusCls=""},onItemClick:function(record,item,index,e){this.callParent([record,item,index,e]),this.handleItemTap(record)}}),Ext.define("Ext.calendar.List",{extend:"Ext.calendar.AbstractList",xtype:"calendar-list",config:{enableToggle:!0},cls:Ext.baseCSSPrefix+"calendar-list",itemTpl:'<div class="<tpl if="hidden">'+Ext.baseCSSPrefix+'calendar-list-item-hidden</tpl>"><div class="'+Ext.baseCSSPrefix+'calendar-list-icon" style="background-color: {color};"></div><div class="'+Ext.baseCSSPrefix+'calendar-list-text">{title:htmlEncode}</div></div>',itemSelector:"."+Ext.baseCSSPrefix+"calendar-list-item",itemCls:Ext.baseCSSPrefix+"calendar-list-item",scrollable:!0,prepareData:function(data,index,record){return{id:record.id,editable:record.isEditable(),hidden:record.isHidden(),color:record.getBaseColor(),title:record.getTitle()}},handleItemTap:function(record){this.getEnableToggle()&&record.setHidden(!record.isHidden())}}),Ext.define("Ext.calendar.date.Range",{end:null,start:null,isRange:!0,statics:{fly:function(){var range=null;return function(start,end){return start.isRange?start:(range||(range=new Ext.calendar.date.Range),range.start=start,range.end=end,range)}}()},constructor:function(start,end){this.start=start,this.end=end},clone:function(){var D=Ext.Date;return new(0,this.self)(D.clone(this.start),D.clone(this.end))},contains:function(d){return this.start<=d&&d<=this.end},containsRange:function(start,end){var other=this.self.fly(start,end);return other.start>=this.start&&other.end<=this.end},equals:function(start,end){var other;return!!start&&(other=this.self.fly(start,end),this.start.getTime()===other.start.getTime()&&this.end.getTime()===other.end.getTime())},getDuration:function(){return this.end.getTime()-this.start.getTime()},isContainedBy:function(start,end){return this.self.fly(start,end).containsRange(this)},overlaps:function(start,end){var other=this.self.fly(start,end);return other.start<this.end&&this.start<other.end}}),Ext.define("Ext.calendar.date.Util",{singleton:!0,clearTimeUtc:function(d,clone){return clone&&(d=Ext.Date.clone(d)),d.setUTCHours(0),d.setUTCMinutes(0),d.setUTCSeconds(0),d.setUTCMilliseconds(0),d},privates:{getDefaultTimezoneOffset:function(){return(new Date).getTimezoneOffset()},getLocalNow:function(){return new Date},expandRange:function(range){var D=Ext.Date,start=range.start,end=range.end;return(start=D.clone(start)).setUTCHours(0),0!==end.getUTCHours()&&(end=D.clone(end)).setUTCHours(24),new Ext.calendar.date.Range(start,end)}}}),Ext.define("Ext.calendar.dd.WeeksProxy",{extend:"Ext.drag.proxy.Placeholder",alias:"drag.proxy.calendar-weeks",config:{titleTpl:'<tpl if="days &gt; 1">({days} days) </tpl>{title}',width:null},draggingCls:Ext.baseCSSPrefix+"calendar-event-dragging",applyTitleTpl:function(titleTpl){return titleTpl&&!titleTpl.isXTemplate&&(titleTpl=new Ext.XTemplate(titleTpl)),titleTpl},getElement:function(info){var me=this,view=info.view,clone=info.widget.cloneForProxy(),el=clone.element;return clone.removeCls(view.$staticEventCls),clone.addCls(me.draggingCls),clone.addCls(me.placeholderCls),view.element.appendChild(el),clone.setWidth(me.getWidth()),me.setTitle(clone),me.clone=clone,el},cleanup:function(){this.clone=Ext.destroy(this.clone),this.callParent()},privates:{setTitle:function(clone){var model,titleTpl=this.getTitleTpl();titleTpl&&(model=clone.getModel(),clone.setTitle(titleTpl.apply({model:model,title:clone.getTitle(),days:this.getSource().getView().getEventDaysSpanned(model)})))}}}),Ext.define("Ext.calendar.util.Dom",{singleton:!0,extractPositions:function(parentNode,method){var i,len=parentNode.length,pos=[];for(i=0;i<len;++i)pos.push(Ext.fly(parentNode[i])[method]());return pos},getIndexPosition:function(positions,pos){var index,i,len=positions.length;if(pos<positions[0])index=0;else if(pos>positions[len-1])index=len-1;else for(i=len-1;i>=0;--i)if(pos>positions[i]){index=i;break}return index}}),Ext.define("Ext.calendar.dd.DaysAllDaySource",{extend:"Ext.drag.Source",requires:["Ext.calendar.dd.WeeksProxy","Ext.calendar.util.Dom"],activateOnLongPress:"touch",config:{proxy:{type:"calendar-weeks",width:200},view:null},describe:function(info){var view=this.getView(),event=view.getEvent(info.eventTarget);info.event=event,info.widget=view.getEventWidget(event),info.setData("calendar-event-allday",event),info.view=view},beforeDragStart:function(info){return this.getView().handleChangeStart("drag",info.event)},updateView:function(view){view&&(this.setHandle("."+view.$eventCls),this.setElement(view.allDayContent))},destroy:function(){this.setView(null),this.callParent()},privates:{setup:function(info){var view,event,positions;this.callParent([info]),view=info.view,event=info.event,positions=Ext.calendar.util.Dom.extractPositions(view.backgroundCells,"getX"),info.index=Ext.calendar.util.Dom.getIndexPosition(positions,info.cursor.current.x),info.positions=positions,info.span=view.getEventDaysSpanned(event)}}}),Ext.define("Ext.calendar.dd.DaysAllDayTarget",{extend:"Ext.drag.Target",requires:["Ext.calendar.util.Dom","Ext.calendar.date.Range"],config:{view:null},updateView:function(view){view&&this.setElement(view.allDayContent)},accepts:function(info){return Ext.Array.contains(info.types,"calendar-event-allday")},onDragMove:function(info){var index,view=info.view;info.valid&&(index=Ext.calendar.util.Dom.getIndexPosition(info.positions,info.cursor.current.x),view.selectRange(index,index+info.span-1)),this.callParent([info])},onDragLeave:function(info){this.getView().clearSelected(),this.callParent([info])},onDrop:function(info){var D=Ext.Date,view=info.view,event=info.event,index=Ext.calendar.util.Dom.getIndexPosition(info.positions,info.cursor.current.x),newStart=view.utcTimezoneOffset(D.add(view.dateInfo.full.start,D.DAY,index)),start=event.getStartDate(),before=newStart<start,difference=D.diff(before?newStart:start,before?start:newStart,D.DAY);before&&(difference=-difference),view.handleChange("drop",event,new Ext.calendar.date.Range(D.add(event.getStartDate(),D.DAY,difference),D.add(event.getEndDate(),D.DAY,difference)),(function(){view.clearSelected()})),this.callParent([info])},destroy:function(){this.setView(null),this.callParent()}}),Ext.define("Ext.calendar.dd.DaysProxy",{extend:"Ext.drag.proxy.Placeholder",alias:"drag.proxy.calendar-days",config:{cursorOffset:null},draggingCls:Ext.baseCSSPrefix+"calendar-event-dragging",getElement:function(info){var view=info.view,widget=info.widget,clone=widget.cloneForProxy(),el=clone.element,eventColumn=view.getEventColumn(0);return clone.removeCls(view.$staticEventCls),clone.addCls(this.draggingCls),clone.setWidth(Ext.fly(eventColumn).getWidth()),clone.setHeight(widget.getHeight()),view.bodyWrap.appendChild(el),this.element=el,this.clone=clone,info.widgetClone=clone,el},cleanup:function(info){info&&info.deferCleanup||(this.clone=Ext.destroy(this.clone),this.callParent())}}),Ext.define("Ext.calendar.dd.DaysBodySource",{extend:"Ext.drag.Source",requires:["Ext.calendar.dd.DaysProxy","Ext.calendar.util.Dom"],activateOnLongPress:"touch",config:{proxy:{type:"calendar-days"},view:null},describe:function(info){var view=this.getView();info.event=view.getEvent(info.eventTarget),info.widget=view.getEventWidget(info.event),info.setData("calendar-event",info.event),info.view=view},beforeDragStart:function(info){var cls=this.getView().$resizerCls;return!Ext.fly(info.eventTarget).hasCls(cls)&&this.getView().handleChangeStart("drag",info.event)},updateView:function(view){var me=this;view&&(me.setHandle("."+view.$eventCls),me.setElement(view.bodyWrap),me.setConstrain({snap:{x:me.snapX,y:me.snapY}}))},onDragStart:function(info){this.callParent([info]),info.widget.element.hide()},onDragEnd:function(info){var w;this.callParent([info]),(w=info.widget).destroyed||info.deferCleanup||w.element.show()},destroy:function(){this.setView(null),this.callParent()},privates:{startMarginName:"left",setup:function(info){var view,days,i,positions=[];for(this.callParent([info]),days=(view=info.view).getVisibleDays(),i=0;i<days;++i)positions.push(Ext.fly(view.getEventColumn(i)).getX());info.sizes={height:info.proxy.element.getHeight(),slotStyle:view.getSlotStyle(),margin:view.getEventStyle().margin,startPositions:positions,startOffset:info.cursor.initial.y-info.widget.element.getY()}},snapX:function(info,x){var sizes=info.sizes,positions=sizes.startPositions,index=Ext.calendar.util.Dom.getIndexPosition(positions,x);return info.dayIndex=index,positions[index]+sizes.margin[info.source.startMarginName]},snapY:function(info,y){var sizes=info.sizes,view=info.view,bodyOffset=view.bodyTable.getY(),halfHeight=sizes.slotStyle.halfHeight,maxSlots=view.maxSlots,offsetY=Math.max(0,y-sizes.startOffset-bodyOffset);return y=bodyOffset+sizes.margin.top+Ext.Number.roundToNearest(offsetY,halfHeight),Math.min(y,bodyOffset+maxSlots*halfHeight-sizes.height)}}}),Ext.define("Ext.calendar.dd.DaysBodyTarget",{extend:"Ext.drag.Target",config:{view:null},updateView:function(view){view&&this.setElement(view.bodyWrap)},accepts:function(info){return Ext.Array.contains(info.types,"calendar-event")},onDragMove:function(info){var y,start,end,slot,sizes=info.sizes,view=info.view,event=info.event,D=Ext.Date;info.valid&&(y=Math.max(0,info.proxy.current.y-view.bodyTable.getY()),slot=Math.floor(y/sizes.slotStyle.halfHeight),start=D.clone(view.dateInfo.visible.start),start=D.add(start,D.DAY,info.dayIndex||0),start=D.add(start,D.MINUTE,view.minimumEventMinutes*slot,!0),end=D.add(start,D.MINUTE,event.getDuration(),!0),info.widgetClone.setStartDate(start),info.widgetClone.setEndDate(end),info.range=[start,end]),this.callParent([info])},onDrop:function(info){var w,view=this.getView(),proxy=info.source.getProxy();info.deferCleanup=!0,view.handleChange("drop",info.event,new Ext.calendar.date.Range(info.range[0],info.range[1]),(function(){proxy.cleanup(),(w=info.widget).destroyed||w.element.show(),view.clearSelected()})),this.callParent([info])},destroy:function(){this.setView(null),this.callParent()}}),Ext.define("Ext.calendar.dd.WeeksSource",{extend:"Ext.drag.Source",requires:["Ext.calendar.dd.WeeksProxy"],activateOnLongPress:"touch",config:{proxy:{type:"calendar-weeks",width:200},view:null},describe:function(info){var view=this.getView();info.event=view.getEvent(info.eventTarget),info.widget=view.getEventWidget(info.eventTarget),info.setData("calendar-event",info.event),info.view=view},beforeDragStart:function(info){return this.getView().handleChangeStart("drag",info.event)},onDragStart:function(info){var view=info.view,cursor=info.cursor.current,cell=view.getCellByPosition(cursor.x,cursor.y),event=info.event;info.span=view.getEventDaysSpanned(event),info.startDate=view.getDateFromCell(cell),this.callParent([info])},updateView:function(view){view&&(this.setHandle("."+view.$eventCls),this.setElement(view.element))},destroy:function(){this.setView(null),this.callParent()}}),Ext.define("Ext.calendar.dd.WeeksTarget",{extend:"Ext.drag.Target",requires:["Ext.calendar.date.Range"],config:{view:null},updateView:function(view){view&&this.setElement(view.element)},accepts:function(info){return Ext.Array.contains(info.types,"calendar-event")},onDragMove:function(info){var cell,d,end,D=Ext.Date,view=info.view,cursor=info.cursor.current,span=info.span;info.valid&&(cell=view.getCellByPosition(cursor.x,cursor.y),d=view.getDateFromCell(cell),end=D.add(d,D.DAY,span-1),view.selectRange(d,end)),this.callParent([info])},onDragLeave:function(info){this.getView().clearSelected(),this.callParent([info])},onDrop:function(info){var difference,D=Ext.Date,cursor=info.cursor.current,view=info.view,cell=view.getCellByPosition(cursor.x,cursor.y),event=info.event;difference=this.calculateDifference(event,view.getDateFromCell(cell),info.startDate),view.handleChange("drop",event,new Ext.calendar.date.Range(D.add(event.getStartDate(),D.DAY,difference,!1),D.add(event.getEndDate(),D.DAY,difference,!1)),(function(){view.clearSelected()})),this.callParent([info])},destroy:function(){this.setView(null),this.callParent()},privates:{calculateDifference:function(event,d,startDate){var before,difference,D=Ext.Date,start=event.getStartDate();return event.getAllDay()?before=(d=D.localToUtc(d))<start:(before=d<startDate,start=startDate),difference=D.diff(before?d:start,before?start:d,D.DAY),before&&(difference=-difference),difference}}}),Ext.define("Ext.calendar.form.CalendarPicker",{extend:"Ext.form.field.ComboBox",xtype:"calendar-calendar-picker",cls:Ext.baseCSSPrefix+"calendar-picker-field",listConfig:{cls:Ext.baseCSSPrefix+"calendar-picker-list",getInnerTpl:function(displayField){return'<div class="'+Ext.baseCSSPrefix+'calendar-picker-list-icon" style="background-color: {color};"></div><div class="'+Ext.baseCSSPrefix+'calendar-picker-list-text">{'+displayField+"}</div>"},prepareData:function(data,index,record){return{id:record.id,title:record.getTitle(),color:record.getBaseColor()}}},afterRender:function(){this.callParent(),this.updateValue()},updateValue:function(){var el,record,me=this;me.callParent(),record=me.valueCollection.first(),me.rendered&&((el=me.iconEl)||(me.iconEl=el=me.inputWrap.createChild({cls:Ext.baseCSSPrefix+"calendar-picker-field-icon"})),record?(el.setDisplayed(!0),el.setStyle("background-color",record.getBaseColor())):el.setDisplayed(!1))}}),Ext.define("Ext.calendar.form.AbstractForm",{extend:"Ext.window.Window",requires:["Ext.layout.container.Fit","Ext.layout.container.VBox","Ext.layout.container.HBox","Ext.form.Panel","Ext.form.field.Text","Ext.form.field.Date","Ext.form.field.Time","Ext.form.field.Checkbox","Ext.calendar.form.CalendarPicker"],layout:"fit",modal:!0,closable:!1,defaultListenerScope:!0,config:{calendarField:{xtype:"calendar-calendar-picker",fieldLabel:"Calendar",name:"calendarId",forceSelection:!0,editable:!1,queryMode:"local",displayField:"title",valueField:"id"},titleField:{xtype:"textfield",fieldLabel:"Title",name:"title",allowBlank:!1},fromContainer:{xtype:"fieldcontainer",fieldLabel:"From",layout:"hbox"},startDateField:{xtype:"datefield",itemId:"startDate",name:"startDate",allowBlank:!1},startTimeField:{xtype:"timefield",itemId:"startTime",name:"startTime",margin:"0 0 0 5"},toContainer:{xtype:"fieldcontainer",fieldLabel:"To",layout:"hbox"},endDateField:{xtype:"datefield",itemId:"endDate",name:"endDate",allowBlank:!1},endTimeField:{xtype:"timefield",itemId:"endTime",name:"endTime",margin:"0 0 0 5"},allDayField:{xtype:"checkbox",itemId:"allDay",name:"allDay",boxLabel:"All Day",hideEmptyLabel:!1,handler:"onAllDayChange"},descriptionField:{xtype:"textarea",fieldLabel:"Description",name:"description",flex:1},dropButton:{text:"Delete",handler:"onDropTap"},saveButton:{text:"Save",handler:"onSaveTap"},cancelButton:{text:"Cancel",handler:"onCancelTap"}},initComponent:function(){var me=this;me.initForm(),me.fbar=me.generateButtons(),me.callParent(),me.form=me.items.first(),me.checkFields(),me.applyValues()},generateButtons:function(){var buttons=[],drop=this.getDropButton();return drop&&buttons.push(drop),buttons.push({xtype:"component",flex:1},this.getSaveButton(),this.getCancelButton()),buttons},applyValues:function(){this.form.getForm().setValues(this.consumeEventData())},createItems:function(){var me=this,calField=me.getCalendarField(),fromCt=me.getFromContainer(),toCt=me.getToContainer();calField.store||(calField.store=me.getCalendarStore()),fromCt.items||(fromCt.items=[me.getStartDateField(),me.getStartTimeField()]),toCt.items||(toCt.items=[me.getEndDateField(),me.getEndTimeField()]),this.items=[{xtype:"form",border:!1,trackResetOnLoad:!0,layout:{type:"vbox",align:"stretch"},bodyPadding:10,items:[calField,me.getTitleField(),fromCt,toCt,me.getAllDayField(),me.getDescriptionField()]}]},privates:{checkFields:function(){var checked=this.down("#allDay").checked;this.down("#startTime").setDisabled(checked),this.down("#endTime").setDisabled(checked)},onAllDayChange:function(){this.checkFields()},onCancelTap:function(){this.fireCancel()},onDropTap:function(){this.fireDrop()},onSaveTap:function(){var form=this.form,values=form.getForm().getFieldValues();form.isValid()&&(values.allDay=this.down("#allDay").checked,this.fireSave(this.produceEventData(values)))}}}),Ext.define("Ext.calendar.form.Base",{extend:"Ext.Mixin",requires:["Ext.data.ChainedStore"],config:{event:null,view:null},fireCancel:function(){this.fireEvent("cancel",this)},fireDrop:function(){this.fireEvent("drop",this)},fireSave:function(data){this.fireEvent("save",this,{data:data})},getCalendarStore:function(){return{type:"chained",autoDestroy:!0,source:this.getView().getStore(),filters:[{filterFn:function(cal){return cal.isEditable()}}]}}}),Ext.define("Ext.calendar.form.Form",{extend:"Ext.calendar.form.AbstractForm",mixins:["Ext.calendar.form.Base"],defaultStartTime:[9,0],defaultEndTime:[10,0],initForm:function(){this.createItems()},consumeEventData:function(){var editable,me=this,D=Ext.Date,view=me.getView(),event=me.getEvent(),start=event.getStartDate(),end=event.getEndDate(),allDay=event.getAllDay(),startDate=allDay?D.utcToLocal(start):view.utcToLocal(start),endDate=allDay?D.utcToLocal(end):view.utcToLocal(end),ignoreTimes=allDay||startDate.getTime()===endDate.getTime(),data={calendarId:event.getCalendarId(),title:event.getTitle(),description:event.getDescription(),allDay:allDay,startDate:startDate,endDate:endDate};return ignoreTimes||(data.startTime=startDate,data.endTime=endDate),allDay&&(data.endDate=D.subtract(endDate,D.DAY,1)),me.setDefaultTime(data,"startTime",me.defaultStartTime),me.setDefaultTime(data,"endTime",me.defaultEndTime),data.calendarId||(editable=view.getEditableCalendars()).length&&(data.calendarId=editable[0].id),data},produceEventData:function(values){var D=Ext.Date,view=this.getView(),startTime=values.startTime,endTime=values.endTime,startDate=values.startDate,endDate=values.endDate,sYear=startDate.getFullYear(),sMonth=startDate.getMonth(),sDate=startDate.getDate(),eYear=endDate.getFullYear(),eMonth=endDate.getMonth(),eDate=endDate.getDate();return values.allDay?(startDate=D.utc(sYear,sMonth,sDate),endDate=D.add(D.utc(eYear,eMonth,eDate),D.DAY,1),delete values.startTime,delete values.endTime):(startDate=view.toUtcOffset(new Date(sYear,sMonth,sDate,startTime.getHours(),startTime.getMinutes())),endDate=view.toUtcOffset(new Date(eYear,eMonth,eDate,endTime.getHours(),endTime.getMinutes()))),values.startDate=startDate,values.endDate=endDate,values},privates:{setDefaultTime:function(data,key,time){data[key]||(data[key]=new Date(2010,0,1,time[0],time[1]))}}}),Ext.define("Ext.calendar.form.Add",{extend:"Ext.calendar.form.Form",xtype:"calendar-form-add",dropButton:null,title:"Add Event"}),Ext.define("Ext.calendar.form.Edit",{extend:"Ext.calendar.form.Form",xtype:"calendar-form-edit",title:"Edit Event"}),Ext.define("Ext.calendar.header.Base",{extend:"Ext.Gadget",mixins:["Ext.mixin.ConfigState"],alternateStateConfig:"compactOptions",config:{cellCls:"",compact:!1,compactOptions:null,format:"",value:null,visibleDays:null},baseCls:Ext.baseCSSPrefix+"calendar-header",constructor:function(config){this.callParent([config]),this.redrawCells()},updateCompact:function(compact){var baseCls=this.baseCls;this.element.toggleCls(baseCls+"-compact",compact),this.element.toggleCls(baseCls+"-large",!compact),this.toggleConfigState(compact)},updateCompactOptions:function(){!this.isConfiguring&&this.getCompact()&&this.toggleConfigState()},updateFormat:function(){this.isConfiguring||this.setHeaderText(!0)},applyValue:function(value,oldValue){return value&&oldValue&&value-oldValue==0&&(value=void 0),value},updateValue:function(){this.isConfiguring||this.setHeaderText()},updateVisibleDays:function(){this.isConfiguring||this.redrawCells()},getElementConfig:function(){return{tag:"table",cls:this.$tableCls,reference:"element",children:[{tag:"tbody",children:[{tag:"tr",reference:"row"}]}]}},privates:{domFormat:"Y-m-d",useDates:!0,$headerCls:Ext.baseCSSPrefix+"calendar-header-cell",$hiddenCls:Ext.baseCSSPrefix+"calendar-header-hidden-cell",$tableCls:Ext.baseCSSPrefix+"calendar-header-table",clearCells:function(limit){var row=this.row.dom,childNodes=row.childNodes;for(limit=limit||0;childNodes.length>limit;)row.removeChild(childNodes[limit])},createCells:function(){var cell,i,me=this,row=me.row.dom,cells=[],days=me.getCreateDays(),cls=Ext.baseCSSPrefix+"unselectable "+me.$headerCls,cellCls=me.getCellCls();for(cellCls&&(cls+=" "+cellCls),i=0;i<days;++i)(cell=document.createElement("td")).className=cls,cell.setAttribute("data-index",i),me.onCellCreate(cell,i),row.appendChild(cell),cells.push(cell);return cells},getCreateDays:function(){return this.getVisibleDays()},onCellCreate:Ext.privateFn,redrawCells:function(){this.clearCells(),this.cells=this.createCells(),this.setHeaderText()},setHeaderText:function(){var cell,i,me=this,D=Ext.Date,value=me.getValue(),format=me.getFormat(),domFormat=me.domFormat,cells=me.cells,len=cells.length,useDates=me.useDates;if(value)for(value=D.clone(value),i=0;i<len;++i)cell=cells[i],useDates&&cell.setAttribute("data-date",D.format(value,domFormat)),cell.setAttribute("data-day",value.getDay()),cell.innerHTML=D.format(value,format),value=D.add(value,D.DAY,1)}}}),Ext.define("Ext.calendar.header.Days",{extend:"Ext.calendar.header.Base",xtype:"calendar-daysheader",format:"D m/d",compactOptions:{format:"d"},getElementConfig:function(){var result=this.callParent();return result.cls=this.$tableCls,delete result.reference,{cls:Ext.baseCSSPrefix+"calendar-header",reference:"element",children:[result]}},privates:{headerScrollOffsetName:"padding-right",$gutterCls:Ext.baseCSSPrefix+"calendar-header-gutter",createCells:function(){var row=this.row,cells=this.callParent();return row.insertFirst({tag:"td",cls:this.$headerCls+" "+this.$gutterCls},!0),row.append({tag:"td",style:"display: none;"},!0),cells},setOverflowWidth:function(width){this.element.setStyle(this.headerScrollOffsetName,width+"px")}}}),Ext.define("Ext.calendar.header.Weeks",{extend:"Ext.calendar.header.Base",xtype:"calendar-weeksheader",format:"D",privates:{useDates:!1,getCreateDays:function(){return Ext.Date.DAYS_IN_WEEK},onCellCreate:function(cell,index){Ext.fly(cell).toggleCls(this.$hiddenCls,index>=this.getVisibleDays())}}}),Ext.define("Ext.calendar.model.EventBase",{extend:"Ext.Mixin",requires:["Ext.calendar.date.Range"],inheritableStatics:{getDaysSpanned:function(start,end){var D=Ext.Date,count=0;for(start=D.clearTime(start,!0);start<end;)++count,start=D.add(start,D.DAY,1);return count},sort:function(a,b){return a.getStartDate().getTime()-b.getStartDate().getTime()||b.getDuration()-a.getDuration()||a.getTitle()-b.getTitle()}},containsRange:function(start,end){return this.getRange().containsRange(start,end)},getCalendar:function(){return this.calendar||null},getRange:function(){return new Ext.calendar.date.Range(this.getStartDate(),this.getEndDate())},isContainedByRange:function(start,end){return this.getRange().isContainedBy(start,end)},isSpan:function(){var nextDayStart,DATE=Ext.Date,startTime=this.data.startTime;return!!this.getAllDay()||(startTime?(nextDayStart=DATE.add(DATE.clearTime(DATE.clone(startTime)),DATE.DAY,1),DATE.diff(startTime,nextDayStart,"mi")<this.getDuration()):this.getDuration()>1440)},occursInRange:function(start,end){return this.getRange().overlaps(start,end)},setCalendar:function(calendar,dirty){dirty=!1!==dirty,this.calendar=calendar,this.setCalendarId(calendar?calendar.id:null,dirty)}}),Ext.define("Ext.calendar.model.Event",{extend:"Ext.data.Model",mixins:["Ext.calendar.model.EventBase"],requires:["Ext.data.field.String","Ext.data.field.Integer","Ext.data.field.Date","Ext.data.field.Boolean"],fields:[{name:"title",type:"string"},{name:"calendarId"},{name:"color",type:"string"},{name:"description",type:"string"},{name:"startDate",type:"date",dateFormat:"c"},{name:"endDate",type:"date",dateFormat:"c"},{name:"allDay",type:"boolean"},{name:"duration",type:"int",depends:["startDate","endDate"],calculate:function(data){var start=data.startDate,end=data.endDate,ms=0;return end&&start&&(ms=end.getTime()-start.getTime()),ms/6e4}}],getAllDay:function(){return this.data.allDay},getCalendarId:function(){return this.data.calendarId},getColor:function(){return this.data.color},getDescription:function(){return this.data.description},getDuration:function(){return this.data.duration},getEndDate:function(){return this.data.endDate},getRange:function(){var range=this.range;return range||(this.range=range=new Ext.calendar.date.Range(this.getStartDate(),this.getEndDate())),range},getStartDate:function(){return this.data.startDate},getTitle:function(){return this.data.title},isEditable:function(){var calendar=this.getCalendar();return!calendar||calendar.isEditable()},setAllDay:function(allDay){this.set("allDay",allDay)},setCalendarId:function(calendarId,dirty){dirty=!1!==dirty,this.set("calendarId",calendarId,{dirty:dirty})},setColor:function(color){this.set("color",color)},setData:function(data){var duration=data.duration;duration?(delete(data=Ext.apply({},data)).duration,this.setDuration(duration)):data.startDate&&data.endDate&&(this.range=null),this.set(data)},setDescription:function(description){this.set("description",description)},setDuration:function(duration){var D=Ext.Date;this.range=null,this.set("endDate",D.add(this.data.startDate,D.MINUTE,duration,!0))},setRange:function(start,end){var D=Ext.Date;start.isRange&&(end=start.end,start=start.start),this.range=null,this.set({startDate:D.clone(start),endDate:D.clone(end)})},setTitle:function(title){this.set("title",title)}}),Ext.define("Ext.calendar.store.Events",{extend:"Ext.data.Store",alias:"store.calendar-events",model:"Ext.calendar.model.Event",requires:["Ext.calendar.model.Event","Ext.calendar.date.Range"],config:{calendar:null,calendarParam:"calendar",dateFormat:"C",endParam:"endDate",prefetchMode:"month",startParam:"startDate"},remoteSort:!1,pageSize:0,sorters:[{direction:"ASC",sorterFn:function(a,b){return Ext.calendar.model.Event.sort(a,b)}}],prefetchSettings:{month:{unit:Ext.Date.MONTH,amount:2},week:{unit:Ext.Date.WEEK,amount:2},day:{unit:Ext.Date.DAY,amount:4}},constructor:function(config){this.requests={},this.callParent([config])},getInRange:function(start,end){var i,rec,records=this.data.items,len=records.length,ret=[];for(i=0;i<len;++i)(rec=records[i]).occursInRange(start,end)&&ret.push(rec);return ret},hasRangeCached:function(range){var current=this.range,ret=!1;return current&&(ret=current.full.containsRange(range)),ret},setRange:function(range){var fetchStart,fetchEnd,fullStart,fullEnd,newRange,me=this,D=Ext.Date,R=Ext.calendar.date.Range,current=me.range,prefetchSettings=me.getPrefetchSetting(),fetchCount=0,isLeading=!1;fullStart=D.subtract(range.start,prefetchSettings.unit,prefetchSettings.amount,!0),fullEnd=D.add(range.end,prefetchSettings.unit,prefetchSettings.amount,!0),newRange={actual:range.clone(),full:new R(fullStart,fullEnd)},me.compareRange(current,newRange)||current&&current.full.containsRange(newRange.full)||(me.hasRangeCached(range)?me.hasRangeCached(newRange.full)||(current.full.start>fullStart&&(fetchStart=fullStart,fetchEnd=current.full.start,++fetchCount,isLeading=!0),current.full.end<fullEnd&&(fetchStart=current.full.end,fetchEnd=fullEnd,++fetchCount),1===fetchCount?me.prefetchRange(fetchStart,fetchEnd,isLeading,newRange):2===fetchCount?me.loadRange(fullStart,fullEnd,newRange):Ext.raise("Should never be here.")):me.loadRange(newRange.full.start,newRange.full.end,newRange),me.requested=newRange)},onProxyLoad:function(operation){var me=this;operation.wasSuccessful()&&(me.range=me.requested,me.requested=null),me.setCalendarFromLoad=!0,me.callParent([operation]),me.setCalendarFromLoad=!1},onCollectionAdd:function(collection,info){this.setRecordCalendar(this.getCalendar(),info.items,!this.setCalendarFromLoad),this.callParent([collection,info])},onCollectionRemove:function(collection,info){this.callParent([collection,info]),this.isMoving||this.setRecordCalendar(null,info.items,!0)},privates:{isMoving:0,abortAll:function(){var request,id,requests=this.requests;for(id in requests)(request=requests[id])&&!request.destroyed&&request.abort();this.requests={}},compareRange:function(a,b){return a&&b?a.full.equals(b.full)&&a.actual.equals(b.actual):(a||null)===(b||null)},getPrefetchSetting:function(){return this.prefetchSettings[this.getPrefetchMode()]},loadRange:function(start,end,newRequested){var requested=this.requested,range=new Ext.calendar.date.Range(start,end);requested&&requested.full.equals(range)||(this.abortAll(),this.load({params:this.setupParams(start,end),requested:newRequested}))},onBeforeLoad:function(operation){this.requests[operation._internalId]=operation},onPrefetch:function(operation){var i,rec,me=this,records=operation.getRecords()||[],toPrune=[],toAdd=[],map=Ext.Array.toMap(records,"id"),range=me.getDataSource().getRange(),len=range.length,start=me.range.full.start,end=me.range.full.end;for(operation.wasSuccessful()&&(me.range=me.requested,me.requested=null),delete me.requests[operation._internalId],me.suspendEvents(),i=0;i<len;++i)map[(rec=range[i]).id]||rec.occursInRange(start,end)||toPrune.push(rec);for(i=0,len=records.length;i<len;++i)rec=records[i],me.getById(rec.id)||toAdd.push(rec);me.ignoreCollectionRemove=me.setCalendarFromLoad=!0,me.getData().splice(0,toPrune,toAdd),me.ignoreCollectionRemove=me.setCalendarFromLoad=!1,me.resumeEvents(),me.fireEvent("prefetch",me,toAdd,toPrune)},prefetch:function(options){var operation,me=this;options=Ext.apply({internalScope:me,internalCallback:me.onPrefetch},options),me.setLoadOptions(options),operation=me.createOperation("read",options),me.requests[operation._internalId]=operation,operation.execute()},prefetchRange:function(start,end,isLeading,newRequested){this.prefetch({params:this.setupParams(start,end),isLeading:isLeading,newRequested:newRequested})},setRecordCalendar:function(calendar,records,dirty){var i,record,len=records.length;for(i=0;i<len;++i)(record=records[i]).$moving=!0,record.setCalendar(calendar,dirty),delete record.$moving},setupParams:function(start,end){var me=this,D=Ext.Date,format=me.getDateFormat(),params={};return params[me.getCalendarParam()]=me.getCalendar().id,params[me.getStartParam()]=D.format(start,format),params[me.getEndParam()]=D.format(end,format),params}}}),Ext.define("Ext.calendar.theme.Theme",{singleton:!0,requires:["Ext.util.Color"],colors:["#F44336","#3F51B5","#4CAF50","#FF9800","#E91E63","#2196F3","#8BC34A","#FF5722","#673AB7","#009688","#FFC107","#607D8B"],lightColor:"#FFFFFF",darkColor:"#000000",generatePalette:function(color){var lightContrast,darkConstrast,me=this,light=me.light,dark=me.dark,lightColor=me.lightColor,darkColor=me.darkColor,brightness=color.getBrightness();return light||(me.light=light=Ext.util.Color.fromString(lightColor),me.dark=dark=Ext.util.Color.fromString(darkColor)),lightContrast=Math.abs(light.getBrightness()-brightness),darkConstrast=Math.abs(dark.getBrightness()-brightness),{primary:color.toString(),secondary:lightContrast>darkConstrast?lightColor:darkColor,border:color.createDarker(.2).toString()}},getBaseColor:function(calendar){var color,map=this.idMap,colors=this.colors,id=calendar.id;return(color=map[id])||(color=colors[this.current%colors.length],map[id]=color,++this.current),color},getPalette:function(color){var o,map=this.colorMap,palette=map[color];return palette||(o=Ext.util.Color.fromString(color),map[color]=palette=this.generatePalette(o)),palette},privates:{colorMap:{},idMap:{},current:0,onIdChanged:function(newId,oldId){var map=this.idMap,val=map[oldId];val&&(delete map[oldId],map[newId]=val)}}}),Ext.define("Ext.calendar.model.CalendarBase",{extend:"Ext.Mixin",requires:["Ext.calendar.store.Events","Ext.calendar.theme.Theme"],config:{eventStoreDefaults:{type:"calendar-events",proxy:{type:"ajax"}}},events:function(){var cfg,me=this,store=me._eventStore;return store||(cfg=Ext.merge({calendar:me},me.config.eventStoreDefaults,me.eventStoreDefaults,me.get("eventCfg")),me._eventStore=store=Ext.Factory.store(me.getEventStoreConfig(cfg))),store},getBaseColor:function(){var color=this.getColor()||this.getAssignedColor();return color||(color=Ext.calendar.theme.Theme.getBaseColor(this),this.setAssignedColor(color)),color},isEditable:function(){return this.getEditable()},isHidden:function(){return this.getHidden()},privates:{onIdChanged:function(newId,oldId){Ext.calendar.theme.Theme.onIdChanged(newId,oldId)}}}),Ext.define("Ext.calendar.model.Calendar",{extend:"Ext.data.Model",mixins:["Ext.calendar.model.CalendarBase"],requires:["Ext.data.field.String","Ext.data.field.Boolean"],fields:[{name:"title",type:"string"},{name:"description",type:"string"},{name:"color",type:"string"},{name:"assignedColor",type:"string",persist:!1},{name:"hidden",type:"bool"},{name:"editable",type:"bool",defaultValue:!0},{name:"eventStore",type:"auto",persist:!1}],constructor:function(data,session){this.callParent([data,session]),this.getBaseColor()},getAssignedColor:function(){return this.data.assignedColor},getColor:function(){return this.data.color},getDescription:function(){return this.data.description},getEditable:function(){return this.data.editable},getEventStoreConfig:function(cfg){return Ext.merge(cfg,this.data.eventStore)},getHidden:function(){return this.data.hidden},getTitle:function(){return this.data.title},setAssignedColor:function(color){this.set("assignedColor",color)},setColor:function(color){this.set("color",color)},setDescription:function(description){this.set("description",description)},setEditable:function(editable){this.set("editable",editable)},setHidden:function(hidden){this.set("hidden",hidden)},setTitle:function(title){this.set("title",title)}}),Ext.define("Ext.calendar.panel.AbstractBase",{extend:"Ext.panel.Panel",requires:["Ext.layout.container.Fit"],layout:"fit",updateDayHeader:function(dayHeader){dayHeader&&this.addItem(dayHeader,"dockedItems","addDocked")},updateView:function(view){this.addItem(view,"items","add")},afterComponentLayout:function(width,height,oldWidth,oldHeight){this.callParent([width,height,oldWidth,oldHeight]),this.syncHeaders()},privates:{addItem:function(item,existing,addMethod){var items=this[existing];items?items.isMixedCollection?this[addMethod](item):(Ext.isArray(items)||(items=[items]),this[existing]=items.concat(item)):this[existing]=item},syncHeaders:function(){var header;this.syncHeaderSize&&(header=this.getDayHeader())&&header.setOverflowWidth&&header.setOverflowWidth(this.getView().scrollable.getScrollbarSize().width)}}}),Ext.define("Ext.calendar.panel.Base",{extend:"Ext.calendar.panel.AbstractBase",config:{dayHeader:null,eventRelayers:{view:{beforeeventadd:!0,beforeeventedit:!0,eventadd:!0,eventedit:!0,eventdrop:!0,eventtap:!0,validateeventadd:!0,validateeventedit:!0,validateeventdrop:!0,valuechange:!0}},view:null},platformConfig:{"!desktop":{compact:!0}},configExtractor:{view:{addForm:!0,compact:!0,compactOptions:!0,controlStoreRange:!0,editForm:!0,eventDefaults:!0,gestureNavigation:!0,store:!0,timezoneOffset:!0,value:!0}},twoWayBindable:{value:1},cls:[Ext.baseCSSPrefix+"calendar-base",Ext.baseCSSPrefix+"unselectable"],constructor:function(config){var cfg,key,item,extractedItem,proxyKey,me=this,C=Ext.Config,extractor=me.configExtractor,extracted={};for(cfg in config=Ext.apply({},config),me.extracted=extracted,extractor){for(key in item=extractor[cfg],extracted[cfg]=extractedItem={},config)key in item&&(!0===(proxyKey=item[key])&&(proxyKey=key),extractedItem[proxyKey]=config[key],delete config[key]);me.setupProxy(item,C.get(cfg).names.get)}me.callParent([config]),me.initRelayers()},onClassExtended:function(cls,data,hooks){var extractor=data.configExtractor;extractor&&(delete data.configExtractor,cls.prototype.configExtractor=Ext.merge({},cls.prototype.configExtractor,extractor))},updateHighlightToday:Ext.emptyFn,getDisplayRange:function(){return this.getView().getDisplayRange()},getVisibleRange:function(){return this.getView().getVisibleRange()},moveNext:function(){this.getView().moveNext()},movePrevious:function(){this.getView().movePrevious()},navigate:function(amount,interval){this.getView().navigate(amount,interval)},showAddForm:function(data,options){this.getView().showAddForm(data,options)},showEditForm:function(event,options){this.getView().showEditForm(event,options)},applyDayHeader:function(dayHeader){return dayHeader&&(dayHeader=Ext.apply(this.extracted.dayHeader,dayHeader),dayHeader=Ext.create(dayHeader)),dayHeader},updateDayHeader:function(dayHeader,oldDayHeader){oldDayHeader&&oldDayHeader.destroy(),dayHeader&&this.getView().setHeader(dayHeader),this.callParent([dayHeader,oldDayHeader])},applyView:function(view){return view&&(view=Ext.create(Ext.apply(this.extracted.view,view))),view},updateView:function(view,oldView){oldView&&oldView.destroy(),this.callParent([view,oldView])},privates:{calculateMoveNext:function(){return this.getView().calculateMoveNext()},calculateMovePrevious:function(){return this.getView().calculateMovePrevious()},createItemRelayer:function(name){var me=this;return function(view,o){return me.fireEvent(name,me,o)}},generateProxyMethod:function(thisCfg,targetCfg,targetName){var me=this,targetSetter=targetCfg.names.set,targetGetter=targetCfg.names.get,setter=thisCfg.names.set,getter=thisCfg.names.get;me[setter]||(me[setter]=function(value){var o=me[targetName]();o&&o[targetSetter](value)}),me[getter]||(me[getter]=function(){var o=me[targetName]();if(o)return o[targetGetter]()})},initRelayers:function(){var key,events,c,name,prefix,C=Ext.Config,relayers=this.getEventRelayers();for(key in relayers)for(name in events=relayers[key],c=this[C.get(key).names.get](),prefix=events.$prefix||"",events)c.on(name,this.createItemRelayer(prefix+name))},refreshEvents:function(){this.getView().refreshEvents()},setupProxy:function(configs,targetName){var key,targetCfg,thisCfg,val,C=Ext.Config;for(key in configs)val=configs[key],thisCfg=C.get(key),targetCfg=!0===val?thisCfg:C.get(val),this.generateProxyMethod(thisCfg,targetCfg,targetName)}}}),Ext.define("Ext.calendar.store.EventSource",{extend:"Ext.data.Store",requires:["Ext.calendar.date.Range"],config:{source:null},sorters:[{direction:"ASC",sorterFn:function(a,b){return Ext.calendar.model.Event.sort(a,b)}}],trackRemoved:!1,constructor:function(config){this.calendarMap={},this.callParent([config])},createEvent:function(data){this.getSource()||Ext.raise("Cannot create event, no source specified."),this.getSource().first()||Ext.raise("Cannot create event, source is empty.");var event=new(this.getSource().first().events().getModel());return data&&event.setData(data),event},updateSource:function(source){var me=this;me.sourceListeners=Ext.destroy(me.sourceListeners),source&&(me.sourceListeners=source.on({destroyable:!0,scope:me,add:"checkData",remove:"checkData",refresh:"checkData"}),me.checkData())},add:function(record){var events=this.getEventsForCalendar(record.getCalendarId());events?events.add(record):Ext.raise("Unknown calendar: "+record.getCalendarId())},move:function(record,oldCalendar){var removed,store=this.getEventsForCalendar(oldCalendar),newCalendar=record.getCalendar();newCalendar&&(store.suspendAutoSync(),++store.isMoving),store.remove(record),newCalendar&&(--store.isMoving,store.resumeAutoSync(),record.unjoin(store),(removed=store.removed)&&Ext.Array.remove(removed,record),(store=this.getEventsForCalendar(newCalendar)).suspendAutoSync(),store.add(record),store.resumeAutoSync())},remove:function(record){var events=this.getEventsForCalendar(record.getCalendarId());events?events.remove(record):Ext.raise("Unknown calendar: "+record.getCalendarId())},hasRangeCached:function(range){var id,hasAny,map=this.calendarMap,current=this.range;if(!current)return!1;for(id in map)if(hasAny=!0,!this.getEventsForCalendar(map[id]).hasRangeCached(range))return!1;return!!hasAny||current.containsRange(range)},setRange:function(range){var cached,store,id,loads,hasAny,me=this,map=me.calendarMap,success=!0,allCached=!0;for(id in me.range=range.clone(),map)hasAny=!0,cached=(store=me.getEventsForCalendar(map[id])).hasRangeCached(range),allCached=allCached&&cached,store.setRange(range),cached||(loads=loads||[],store.on("load",(function(s,records,successful){Ext.Array.remove(loads,s),success=success&&successful,0===loads.length&&me.doBulkLoad(success)}),null,{single:!0}),loads.push(store),me.activeLoad=!0);hasAny&&allCached?me.checkData(!0):loads&&me.fireEvent("beforeload",me)},doDestroy:function(){var id,me=this,map=this.calendarMap;for(id in map)me.untrackCalendar(map[id]);me.calendarMap=me.stores=null,me.setSource(null),me.callParent()},privates:{checkData:function(fromSetRange){var i,id,calendar,events,start,end,me=this,map=me.calendarMap,o=Ext.apply({},map),calendars=me.getSource().getRange(),len=calendars.length,records=[],range=me.range;for(range&&(start=range.start,end=range.end),i=0;i<len;++i)o[id=(calendar=calendars[i]).getId()]&&(delete o[id],me.untrackCalendar(map[id])),me.trackCalendar(calendar),range&&(events=me.getEventsForCalendar(calendar)).getCount()&&Ext.Array.push(records,events.getInRange(start,end)),map[id]=calendar;for(id in o)me.untrackCalendar(o[id]),delete map[id];!0!==fromSetRange&&range&&me.setRange(range),me.loadRecords(records)},doBulkLoad:function(success){var id,events,me=this,map=me.calendarMap,range=me.range,records=[];if(success){for(id in map)events=me.getEventsForCalendar(map[id]),Ext.Array.push(records,events.getInRange(range.start,range.end));me.loadRecords(records)}me.fireEvent("load",me,records,success),me.activeLoad=!1},fireChangeEvent:function(){return!1},getEventsForCalendar:function(calendar){var ret=null;return calendar.isModel||(calendar=this.calendarMap[calendar]),calendar&&(ret=calendar.events()),ret},onEventStoreAdd:function(store,records){var i,rec,range=this.range,len=records.length,toAdd=[];for(i=0;i<len;++i)(rec=records[i]).occursInRange(range.start,range.end)&&toAdd.push(rec);toAdd.length>0&&this.getDataSource().add(toAdd)},onEventStoreBeforeUpdate:function(store,record){record.$moving||(this.suspendEvents(),this.lastIndex=this.indexOf(record))},onEventStoreClear:function(store,records){var result,me=this;records.length>0&&(me.suspendEvents(),result=me.getDataSource().remove(records),me.resumeEvents(),result&&me.fireEvent("refresh",me))},onEventStorePrefetch:function(store,added,pruned){this.getDataSource().remove(pruned)},onEventStoreRefresh:function(){this.activeLoad||this.checkData()},onEventStoreRemove:function(store,records){this.getDataSource().remove(records)},onEventStoreUpdate:function(store,record,type,modifiedFieldNames,info){if(!record.$moving){var me=this,oldIndex=me.lastIndex,contained=-1!==me.lastIndex,contains=me.contains(record);me.resumeEvents(),contained&&contains?me.fireEvent("update",me,record,type,modifiedFieldNames,info):contained&&!contains?me.fireEvent("remove",me,[record],oldIndex,!1):!contained&&contains&&me.fireEvent("add",me,[record],me.indexOf(record))}},trackCalendar:function(calendar){var events=this.getEventsForCalendar(calendar);events.sourceListeners=events.on({destroyable:!0,scope:this,add:"onEventStoreAdd",beforeupdate:"onEventStoreBeforeUpdate",clear:"onEventStoreClear",prefetch:"onEventStorePrefetch",refresh:"onEventStoreRefresh",remove:"onEventStoreRemove",update:"onEventStoreUpdate"})},untrackCalendar:function(calendar){var events=this.getEventsForCalendar(calendar);events.sourceListeners=Ext.destroy(events.sourceListeners)}}}),Ext.define("Ext.calendar.store.Calendars",{extend:"Ext.data.Store",alias:"store.calendar-calendars",requires:["Ext.calendar.store.EventSource","Ext.calendar.model.Calendar"],config:{eventStoreDefaults:null},model:"Ext.calendar.model.Calendar",getEventSource:function(){var source=this.eventSource;return source||(this.eventSource=source=new Ext.calendar.store.EventSource({source:this})),source},onCollectionAdd:function(collection,info){var i,rec,cfg=this.getEventStoreDefaults(),items=info.items,len=items.length;if(this.callParent([collection,info]),cfg)for(i=0;i<len;++i)(rec=items[i]).hasOwnProperty("eventStoreDefaults")||(rec.eventStoreDefaults=Ext.merge({},rec.eventStoreDefaults,cfg))},doDestroy:function(){this.eventSource=Ext.destroy(this.eventSource),this.callParent()}}),Ext.define("Ext.calendar.view.Base",{extend:"Ext.Gadget",requires:["Ext.calendar.store.Calendars","Ext.calendar.theme.Theme","Ext.calendar.Event","Ext.Promise","Ext.calendar.date.Range","Ext.calendar.date.Util"],mixins:["Ext.mixin.ConfigState"],alternateStateConfig:"compactOptions",config:{addForm:{xtype:"calendar-form-add"},compact:!1,compactOptions:null,controlStoreRange:!0,editForm:{xtype:"calendar-form-edit"},eventDefaults:{xtype:"calendar-event"},gestureNavigation:!0,header:null,store:null,timezoneOffset:void 0,value:void 0},platformConfig:{"!desktop":{compact:!0}},twoWayBindable:{value:1},constructor:function(config){this.eventMap={},this.eventPool={},this.callParent([config])},getForm:function(){return this.form||null},moveNext:function(){this.setValue(this.calculateMoveNext())},movePrevious:function(){this.setValue(this.calculateMovePrevious())},navigate:function(amount,interval){var D=Ext.Date;0!==amount&&this.setValue(D.add(this.getValue(),interval||D.DAY,amount,!0))},showAddForm:function(event,options){var range,me=this,D=Ext.Date;me.getAddForm()&&(event||(range=me.getDefaultCreateRange(),event=me.createModel({startDate:range.start,endDate:D.add(range.end,D.DAY,1),allDay:!0})),me.doShowForm(event,"add",me.createAddForm(),"onFormCreateSave",options))},showEditForm:function(event,options){this.getEditForm()&&this.doShowForm(event,"edit",this.createEditForm(),"onFormEditSave",options)},createAddForm:function(){return Ext.merge({view:this},this.getAddForm())},createEditForm:function(event){return Ext.merge({view:this},this.getEditForm())},getEventSource:function(){return this.eventSource},updateCompact:function(compact){var me=this,baseCls=me.baseCls,header=me.getHeader();me.toggleCls(Ext.baseCSSPrefix+"calendar-compact",compact),me.toggleCls(baseCls+"-compact",compact),me.toggleCls(Ext.baseCSSPrefix+"calendar-large",!compact),me.toggleCls(baseCls+"-large",!compact),header&&header.setCompact(compact),me.toggleConfigState(compact)},updateCompactOptions:function(){!this.isConfiguring&&this.getCompact()&&this.toggleConfigState(!0)},updateGestureNavigation:function(gestureNavigation){var method;Ext.supports.Touch&&(method=gestureNavigation?"on":"un",this.getBodyElement()[method]("swipe","onBodySwipe",this))},updateHeader:function(header,oldHeader){oldHeader&&oldHeader.destroy(),header&&(header.setCompact(this.getCompact()),this.refreshHeaders())},applyStore:function(store){return store&&(store=Ext.StoreManager.lookup(store,"calendar-calendars")),store},updateStore:function(store,oldStore){var me=this;me.eventSource=null,oldStore&&(oldStore.getAutoDestroy()?oldStore.destroy():(oldStore.getEventSource().un(me.getSourceListeners()),oldStore.un(me.getStoreListeners()))),store&&(store.on(me.getStoreListeners()),me.eventSource=store.getEventSource(),me.eventSource.on(me.getSourceListeners()),me.isConfiguring||(me.onSourceAttach(),me.refreshEvents()))},applyTimezoneOffset:function(timezoneOffset){return this.autoOffset=!1,void 0===timezoneOffset&&(timezoneOffset=Ext.calendar.date.Util.getDefaultTimezoneOffset(),this.autoOffset=!0),timezoneOffset},applyValue:function(value,oldValue){return value=Ext.Date.clearTime(value||Ext.calendar.date.Util.getLocalNow(),!0),oldValue&&oldValue.getTime()===value.getTime()&&(value=void 0),value},updateValue:function(value){this.isConfiguring||this.fireEvent("valuechange",this,{value:value})},doDestroy:function(){var me=this;me.clearEvents(),me.form=Ext.destroy(me.form),me.setHeader(null),me.setStore(null),me.callParent()},privates:{$eventCls:Ext.baseCSSPrefix+"calendar-event",$eventInnerCls:Ext.baseCSSPrefix+"calendar-event-inner",$eventColorCls:Ext.baseCSSPrefix+"calendar-event-marker-color",$staticEventCls:Ext.baseCSSPrefix+"calendar-event-static",$tableCls:Ext.baseCSSPrefix+"calendar-table",eventRefreshSuspend:0,refreshCounter:0,forwardDirection:"left",backwardDirection:"right",dateInfo:null,calculateMove:function(offset){var interval=this.getMoveInterval(),val=this.getMoveBaseValue();return Ext.Date.add(val,interval.unit,offset*interval.amount,!0)},calculateMoveNext:function(){return this.calculateMove(1)},calculateMovePrevious:function(){return this.calculateMove(-1)},clearEvents:function(){var key,map=this.eventMap;for(key in map)map[key].destroy();this.eventMap={}},createEvent:function(event,cfg,dummy){var widget,d,me=this,defaults=Ext.apply({},me.getEventDefaults());return dummy?(d=me.getUtcNow(),cfg.startDate=d,cfg.endDate=d):cfg.palette=me.getEventPalette(event),(cfg=cfg||{}).model=event,cfg.view=me,widget=Ext.widget(Ext.apply(cfg,defaults)),dummy||(me.eventMap[widget.id]=widget),widget},createEvents:function(events,cfg){var i,len=events.length,ret=[];for(i=0;i<len;++i)ret.push(this.createEvent(events[i],Ext.apply({},cfg)));return ret},createModel:function(data){return this.getEventSource().createEvent(data)},doRefresh:Ext.privateFn,doRefreshEvents:Ext.privateFn,doShowForm:function(event,type,cfg,successFn,options){var c,me=this;me.getStore()&&event.isEditable()&&!1!==me.fireEvent("beforeevent"+type,me,{event:event})&&(options=options||{},me.form=c=Ext.create(Ext.apply({event:event},cfg)),c.on({save:function(form,context){var data=context.data,o={event:event,data:data,validate:Ext.Promise.resolve(!0)};me.fireEvent("validateevent"+type,me,o),o.validate.then((function(v){!1!==v?(options.onSave&&options.onSave.call(options.scope||me,me,event,data),me[successFn](form,event,data),me.fireEvent("event"+type,me,{event:event,data:data})):me.onFormCancel(form)}))},cancel:function(form,context){options.onCancel&&options.onCancel.call(options.scope||me,me,event),me.onFormCancel(form),me.fireEvent("event"+type+"cancel",me,{event:event})},close:function(form){options.onCancel&&options.onCancel.call(options.scope||me,me,event),me.onFormCancel(form)},drop:function(form){var o={event:event,validate:Ext.Promise.resolve(!0)};me.fireEvent("validateeventdrop",me,o),o.validate.then((function(v){!1!==v?(options.onDrop&&options.onDrop.call(options.scope||me,me,event),me.onFormDrop(form,event),me.fireEvent("eventdrop",me,{event:event})):me.onFormCancel(form)}))}}),c.show())},getBodyElement:function(){return this.element},getCalendar:function(id){return this.getStore().getById(id)},getDaysSpanned:function(start,end,allDay){var ret,D=Ext.Date;return allDay?ret=D.diff(start,end,D.DAY):(start=this.utcToLocal(start),end=this.utcToLocal(end),ret=Ext.calendar.model.Event.getDaysSpanned(start,end)),ret},getDefaultCreateRange:function(){var d,now=Ext.calendar.date.Util.getLocalNow(),displayRange=this.getDisplayRange();return now=this.toUtcOffset(Ext.Date.clearTime(now,!0)),d=displayRange.contains(now)?Ext.Date.localToUtc(now):this.toUtcOffset(displayRange.start),new Ext.calendar.date.Range(d,d)},getDefaultPalette:function(){var rec,color,store=this.getStore(),Theme=Ext.calendar.theme.Theme;return store&&(rec=store.first())&&(color=rec.getBaseColor()),Theme.getPalette(color||Theme.colors[0])},getEditableCalendars:function(){var ret,store=this.getStore();return store&&(ret=Ext.Array.filter(store.getRange(),(function(cal){return cal.isEditable()}))),ret||[]},getEvent:function(el){var id,cls=this.$eventCls;return el.isEvent&&(el=el.target),Ext.fly(el).hasCls(cls)||(el=Ext.fly(el).up("."+cls,this.element,!0)),id=el.getAttribute("data-eventId"),this.getEventSource().getById(id)},getEventDaysSpanned:function(event){return this.getDaysSpanned(event.getStartDate(),event.getEndDate(),event.getAllDay())},getEventPalette:function(event){var color=event.getColor()||event.getCalendar().getBaseColor();return Ext.calendar.theme.Theme.getPalette(color)},getMoveBaseValue:function(){return this.getValue()},getMoveInteral:Ext.privateFn,getSourceListeners:function(){return{scope:this,add:"onSourceAdd",refresh:"onSourceRefresh",remove:"onSourceRemove",update:"onSourceUpdate"}},getStoreListeners:function(){return{scope:this,update:"onStoreUpdate"}},getUtcNow:function(){return Ext.Date.utcToLocal(new Date)},handleChange:function(type,event,newRange,callback){var me=this,o={event:event,newRange:newRange.clone(),validate:Ext.Promise.resolve(!0)},fn=callback||Ext.emptyFn;me.fireEvent("validateevent"+type,me,o),o.validate.then((function(v){!1!==v?(fn(!0),event.setRange(newRange),me.fireEvent("event"+type,me,{event:event,newRange:newRange.clone()})):fn(!1)}))},handleChangeStart:function(type,event){var ret=event.isEditable();return ret&&(ret=this.fireEvent("beforeevent"+type+"start",this,{event:event})),ret},handleResize:Ext.privateFn,hasEditableCalendars:function(){return this.getEditableCalendars().length>0},isEventHidden:function(event){var cal=event.getCalendar();return!cal||cal.isHidden()},onBodySwipe:function(e){e.direction===this.forwardDirection?this.moveNext():e.direction===this.backwardDirection&&this.movePrevious()},onEventTap:function(event){this.fireEvent("eventtap",this,{event:event}),this.showEditForm(event)},onFormCreateSave:function(form,event,data){event.setData(data),event.setCalendar(this.getCalendar(event.getCalendarId())),this.getEventSource().add(event),this.form=Ext.destroy(form)},onFormEditSave:function(form,event,data){var id,me=this,oldCalendar=event.getCalendar();me.suspendEventRefresh(),event.setData(data),id=event.getCalendarId(),oldCalendar.id!==id&&(event.setCalendar(me.getCalendar(id)),me.getEventSource().move(event,oldCalendar)),me.resumeEventRefresh(),me.refreshEvents(),me.form=Ext.destroy(form)},onFormDrop:function(form,event){this.getEventSource().remove(event),this.form=Ext.destroy(form)},onFormCancel:function(form){this.form=Ext.destroy(form)},onSourceAdd:function(){this.refreshEvents()},onSourceAttach:Ext.privateFn,onSourceRefresh:function(){this.refreshEvents()},onSourceRemove:function(){this.refreshEvents()},onSourceUpdate:function(){this.refreshEvents()},onStoreUpdate:function(){this.refreshEvents()},refresh:function(){var me=this;me.isConfiguring||(++me.refreshCounter,me.doRefresh(),me.hasListeners.refresh&&me.fireEvent("refresh",me))},refreshEvents:function(){var me=this;me.eventRefreshSuspend||me.isConfiguring||(me.refreshCounter||me.refresh(),me.doRefreshEvents())},refreshHeaders:Ext.privateFn,resumeEventRefresh:function(){--this.eventRefreshSuspend},setSourceRange:function(range){if(this.getControlStoreRange()){var cached,eventSource=this.getEventSource();eventSource&&(range=Ext.calendar.date.Util.expandRange(range),cached=eventSource.hasRangeCached(range),eventSource.setRange(range),cached&&this.refreshEvents())}},suspendEventRefresh:function(){++this.eventRefreshSuspend},toUtcOffset:function(date){var dOffset,D=Ext.Date,d=D.localToUtc(date),autoOffset=this.autoOffset,tzOffset=autoOffset?d.getTimezoneOffset():this.getTimezoneOffset();return autoOffset&&(dOffset=date.getTimezoneOffset())!==tzOffset&&(tzOffset+=dOffset-tzOffset),D.add(d,D.MINUTE,tzOffset,!1)},utcToLocal:function(d){var D=Ext.Date,viewOffset=this.getTimezoneOffset(),localOffset=d.getTimezoneOffset();return this.autoOffset?D.clone(d):D.subtract(d,D.MINUTE,viewOffset-localOffset,!0)},utcTimezoneOffset:function(date){var D=Ext.Date,tzOffset=this.autoOffset?date.getTimezoneOffset():this.getTimezoneOffset();return D.subtract(date,D.MINUTE,tzOffset,!0)}}}),Ext.define("Ext.overrides.calendar.view.Base",{override:"Ext.calendar.view.Base",constructor:function(config){this.callParent([config]),this.initialized=!0},render:function(container,position){this.callParent([container,position]),this.initialized&&!this.getRefOwner()&&this.refresh()},afterComponentLayout:function(width,height,oldWidth,oldHeight){this.callParent([width,height,oldWidth,oldHeight]),this.handleResize()},privates:{refreshEvents:function(){0!==this.element.dom.offsetHeight&&this.callParent()}}}),Ext.define("Ext.calendar.view.DaysRenderer",{end:null,start:null,view:null,constructor:function(config){var view,slotTicks,me=this;Ext.apply(me,config),slotTicks=(view=me.view).slotTicks,me.slots=(view.getEndTime()-view.getStartTime())*(60/slotTicks),me.offset=view.MS_TO_MINUTES*slotTicks,me.events=[]},addIf:function(event){var startSlot,endSlot,me=this,start=me.start,view=me.view,offset=me.offset;!event.isSpan()&&event.isContainedByRange(start,me.end)&&(startSlot=Math.max(0,(view.roundDate(event.getStartDate())-start)/offset),endSlot=Math.min(me.slots,(view.roundDate(event.getEndDate())-start)/offset),this.events.push({event:event,start:startSlot,end:endSlot,len:endSlot-startSlot,colIdx:-1,overlaps:[],edgeWeight:-1,forwardPos:-1,backwardPos:-1}))},calculate:function(){var columns,len,i,firstCol,me=this,events=me.events;if(events.sort(me.sortEvents),columns=me.buildColumns(events),me.constructOverlaps(columns),firstCol=columns[0]){for(len=firstCol.length,i=0;i<len;++i)me.calculateEdgeWeights(firstCol[i]);for(i=0;i<len;++i)me.calculatePositions(firstCol[i],0,0)}},hasEvents:function(){return this.events.length>0},privates:{appendOverlappingEvents:function(event,candidates){this.doOverlap(event,candidates,event.overlaps)},buildColumns:function(events){var i,j,colLen,event,idx,len=events.length,columns=[];for(i=0;i<len;++i){for(idx=-1,event=events[i],j=0,colLen=columns.length;j<colLen;++j)if(!this.hasOverlappingEvents(event,columns[j])){idx=j;break}-1===idx&&(columns[idx=columns.length]=[]),columns[idx].push(event),event.colIdx=idx}return columns},calculateEdgeWeights:function(event){var i,overlaps=event.overlaps,len=overlaps.length,weight=event.edgeWeight;if(-1===weight){for(weight=0,i=0;i<len;++i)weight=Math.max(weight,this.calculateEdgeWeights(overlaps[i])+1);event.edgeWeight=weight}return weight},calculatePositions:function(event,edgeOffset,backOffset){var fwd,i,first,availWidth,overlaps=event.overlaps,len=overlaps.length,nextEdgeOffset=edgeOffset+1;if(-1===event.forwardPos)for(0===len?event.forwardPos=1:(overlaps.sort(this.sortOverlaps),first=overlaps[0],this.calculatePositions(first,nextEdgeOffset,backOffset),event.forwardPos=first.backwardPos),availWidth=(fwd=event.forwardPos)-backOffset,event.backwardPos=fwd-availWidth/nextEdgeOffset,i=1;i<len;++i)this.calculatePositions(overlaps[i],0,fwd)},constructOverlaps:function(columns){var col,i,j,k,colLen,event,len=columns.length;for(i=0;i<len;++i)for(j=0,colLen=(col=columns[i]).length;j<colLen;++j)for(event=col[j],k=i+1;k<len;++k)this.appendOverlappingEvents(event,columns[k])},doOverlap:function(event,candidates,append){var i,other,len=candidates.length,ret=!1;for(i=0;i<len;++i)if(other=candidates[i],this.overlaps(event,other)){if(!append)return!0;append.push(other),ret=!0}return ret},hasOverlappingEvents:function(event,candidates){return this.doOverlap(event,candidates)},overlaps:function(e1,e2){return e1.start<e2.end&&e1.end>e2.start},sortEvents:function(e1,e2){return Ext.calendar.model.EventBase.sort(e1.event,e2.event)},sortOverlaps:function(e1,e2){return e2.edgeWeight-e1.edgeWeight||(e1.backwardPos||0)-(e2.backwardPos||0)||Ext.calendar.model.EventBase.sort(e1.event,e2.event)}}}),Ext.define("Ext.calendar.view.Days",{extend:"Ext.calendar.view.Base",xtype:"calendar-daysview",requires:["Ext.calendar.view.DaysRenderer","Ext.calendar.Event","Ext.scroll.NativeScroller","Ext.calendar.util.Dom"],uses:["Ext.calendar.dd.DaysAllDaySource","Ext.calendar.dd.DaysAllDayTarget","Ext.calendar.dd.DaysBodySource","Ext.calendar.dd.DaysBodyTarget"],isDaysView:!0,baseCls:Ext.baseCSSPrefix+"calendar-days",cellOverflowScrollBug:Ext.isGecko||Ext.isIE11m||Ext.isEdge,config:{allowSelection:!0,compactOptions:{displayOverlap:!1,showNowMarker:!1,timeFormat:"g",timeRenderer:function(hour,formatted,firstInGroup){var d,cls,D=Ext.Date,suffix="";return firstInGroup&&(cls=Ext.baseCSSPrefix+"calendar-days-time-ampm",(d=D.clone(this.baseDate)).setHours(hour),suffix='<div class="'+cls+'">'+Ext.Date.format(d,"a")+"</div>"),formatted+suffix}},displayOverlap:!0,draggable:!0,droppable:!0,endTime:20,resizeEvents:!0,showNowMarker:!0,startTime:8,timeFormat:"H:i",timeRenderer:null,visibleDays:4},constructor:function(config){var me=this;me.slotsPerHour=60/me.slotTicks,me.callParent([config]),me.scrollable=me.createScroller(),me.bodyTable.on("tap","handleEventTap",me,{delegate:"."+me.$eventCls}),me.allDayContent.on("tap","handleEventTap",me,{delegate:"."+me.$eventCls}),me.recalculate(),me.refreshHeaders()},getDisplayRange:function(){var range,me=this;return me.isConfiguring&&me.recalculate(),range=me.dateInfo.active,new Ext.calendar.date.Range(me.utcToLocal(range.start),me.utcToLocal(range.end))},getVisibleRange:function(){var range,D=Ext.Date;return this.isConfiguring&&this.recalculate(),range=this.dateInfo.active,new Ext.calendar.date.Range(D.clone(range.start),D.clone(range.end))},setTimeRange:function(start,end){var me=this;me.isConfiguring=!0,me.setStartTime(start),me.setEndTime(end),this.isConfiguring=!1,me.suspendEventRefresh(),me.recalculate(),me.resumeEventRefresh(),me.refresh()},updateAllowSelection:function(allowSelection){var me=this;me.allDaySelectionListeners=me.selectionListeners=Ext.destroy(me.selectionListeners,me.allDaySelectionListeners),allowSelection&&(me.bodySelectionListeners=me.bodyTable.on({destroyable:!0,scope:me,touchstart:"onBodyTouchStart",touchmove:"onBodyTouchMove",touchend:"onBodyTouchEnd"}),me.allDaySelectionListeners=me.headerWrap.on({destroyable:!0,scope:me,touchstart:"onAllDayTouchStart",touchmove:"onAllDayTouchMove",touchend:"onAllDayTouchEnd"}))},updateDisplayOverlap:function(displayOverlap){this.isConfiguring||this.refreshEvents()},applyDraggable:function(draggable){return draggable&&(draggable=new Ext.calendar.dd.DaysBodySource),draggable},updateDraggable:function(draggable,oldDraggable){var me=this;oldDraggable&&(oldDraggable.destroy(),me.allDayDrag=Ext.destroy(me.allDayDrag)),draggable&&(draggable.setView(me),me.allDayDrag=new Ext.calendar.dd.DaysAllDaySource,me.allDayDrag.setView(me))},applyDroppable:function(droppable){return droppable&&!droppable.isInstance&&(droppable=new Ext.calendar.dd.DaysBodyTarget(droppable)),droppable},updateDroppable:function(droppable,oldDroppable){var me=this;oldDroppable&&(oldDroppable.destroy(),me.allDayDrop=Ext.destroy(me.allDayDrop)),droppable&&(droppable.setView(me),me.allDayDrop=new Ext.calendar.dd.DaysAllDayTarget,me.allDayDrop.setView(me))},updateEndTime:function(){this.calculateSlots(),this.isConfiguring||this.refresh()},updateResizeEvents:function(resizeEvents){var me=this;me.dragListeners=Ext.destroy(me.dragListeners),resizeEvents&&(me.dragListeners=me.bodyTable.on({scope:me,dragstart:"onResizerDragStart",drag:"onResizerDrag",dragend:"onResizerDragEnd",destroyable:!0,delegate:"."+me.$resizerCls,priority:1001})),me.isConfiguring||me.destroying||me.refreshEvents()},updateShowNowMarker:function(showNowMarker){var me=this,markerEl=me.markerEl;Ext.uninterval(me.showNowInterval),me.showNowInterval=null,me.markerEl=null,markerEl&&Ext.fly(markerEl).remove(),showNowMarker&&(me.isConfiguring||me.checkNowMarker(),me.showNowInterval=Ext.interval(me.checkNowMarker,3e5,me))},updateStartTime:function(){this.calculateSlots(),this.isConfiguring||this.refresh()},updateTimeFormat:function(){this.isConfiguring||this.updateTimeLabels()},updateTimeRenderer:function(){this.isConfiguring||this.updateTimeLabels()},updateTimezoneOffset:function(){this.isConfiguring||this.recalculate()},updateValue:function(value,oldValue){var me=this;me.isConfiguring||(me.recalculate(),me.refreshHeaders(),me.checkNowMarker(),me.refreshEvents()),me.callParent([value,oldValue])},updateVisibleDays:function(){var me=this;me.isConfiguring||(me.suspendEventRefresh(),me.recalculate(),me.resumeEventRefresh(),me.refresh())},getElementConfig:function(){var me=this,result=me.callParent(),table=[{tag:"table",cls:me.$tableCls+" "+me.$bodyTableCls,reference:"bodyTable",children:[{tag:"tbody",children:[{tag:"tr",reference:"timeRow",children:[{tag:"td",reference:"timeContainer",cls:me.$timeContainerCls}]}]}]}];return result.children=[{cls:Ext.baseCSSPrefix+"calendar-days-table-wrap",reference:"tableWrap",children:[{cls:Ext.baseCSSPrefix+"calendar-days-header-wrap",reference:"headerWrap",children:[{cls:Ext.baseCSSPrefix+"calendar-days-allday-background-wrap",reference:"allDayBackgroundWrap",children:[{tag:"table",cls:me.$tableCls+" "+Ext.baseCSSPrefix+"calendar-days-allday-background-table",children:[{tag:"tbody",children:[{tag:"tr",reference:"allDayBackgroundRow",children:[{tag:"td",cls:me.$headerGutterCls}]}]}]}]},{tag:"table",cls:me.$tableCls+" "+Ext.baseCSSPrefix+"calendar-days-allday-events",children:[{tag:"tbody",reference:"allDayContent",children:[{tag:"tr",reference:"allDayEmptyRow"}]}]}]},{cls:Ext.baseCSSPrefix+"calendar-days-body-row",children:[{cls:Ext.baseCSSPrefix+"calendar-days-body-cell",reference:me.cellOverflowScrollBug?null:"bodyWrap",children:me.cellOverflowScrollBug?[{cls:Ext.baseCSSPrefix+"calendar-days-body-wrap",reference:"bodyWrap",children:table}]:table}]}]}],result},doDestroy:function(){var me=this;me.scrollable=Ext.destroy(me.scrollable),me.setAllowSelection(!1),me.setShowNowMarker(!1),me.setResizeEvents(!1),me.setDraggable(null),me.setDroppable(null),me.callParent()},privates:{$allDayBackgroundCls:Ext.baseCSSPrefix+"calendar-days-allday-background-cell",$allDayEmptyRowCls:Ext.baseCSSPrefix+"calendar-days-allday-empty-cell",$bodyCls:Ext.baseCSSPrefix+"calendar-days-body",$bodyTableCls:Ext.baseCSSPrefix+"calendar-days-body-table",$dayColumnCls:Ext.baseCSSPrefix+"calendar-days-day-column",$dayEventContainerCls:Ext.baseCSSPrefix+"calendar-days-day-event-container",$headerGutterCls:Ext.baseCSSPrefix+"calendar-days-header-gutter",$markerAltCls:Ext.baseCSSPrefix+"calendar-days-marker-alt",$markerCls:Ext.baseCSSPrefix+"calendar-days-marker",$nowMarkerCls:Ext.baseCSSPrefix+"calendar-days-now-marker",$resizerCls:Ext.baseCSSPrefix+"calendar-event-resizer",$resizingCls:Ext.baseCSSPrefix+"calendar-event-resizing",$selectionCls:Ext.baseCSSPrefix+"calendar-days-selection",$tableCls:Ext.baseCSSPrefix+"calendar-days-table",$timeCls:Ext.baseCSSPrefix+"calendar-days-time",$timeContainerCls:Ext.baseCSSPrefix+"calendar-days-time-ct",baseDate:new Date(2008,0,1),MS_TO_MINUTES:6e4,minimumEventMinutes:30,slotTicks:5,slotsPerHour:null,backPosName:"left",forwardPosName:"right",headerScrollOffsetName:"padding-right",calculateSlots:function(){this.maxSlots=2*(this.getEndTime()-this.getStartTime())},checkNowMarker:function(){this.getShowNowMarker()&&this.doCheckNowMarker()},clearAndPopulate:function(row,nodes,clearAll){for(var i,children=row.dom.childNodes,len=nodes.length,limit=clearAll?0:1;children.length>limit;)row.removeChild(children[limit]);for(i=0;i<len;++i)row.appendChild(nodes[i],!0)},clearEvents:function(){var body,childNodes;if(this.callParent(),body=this.allDayContent.dom)for(childNodes=body.childNodes;childNodes.length>1;)body.removeChild(childNodes[0])},clearSelected:function(){this.selectRange(-1,-1)},constructAllDayEvents:function(events){var week,event,i,row,j,item,widget,rowLen,rowEl,cell,me=this,D=Ext.Date,len=events.length,visibleDays=me.getVisibleDays(),before=me.allDayEmptyRow.dom,content=me.allDayContent.dom;for(week=new Ext.calendar.view.WeeksRenderer({view:me,start:D.clone(this.dateInfo.full.start),days:visibleDays,index:0,maxEvents:null}),i=0;i<len;++i)event=events[i],!me.isEventHidden(event)&&event.isSpan()&&week.addIf(event);if(before.firstChild.className===me.$headerGutterCls&&before.removeChild(before.firstChild),week.hasEvents())for(week.calculate(),i=0,len=week.rows.length;i<len;++i){for(row=week.compress(i),rowEl=document.createElement("tr"),j=0,rowLen=row.length;j<rowLen;++j)item=row[j],(cell=document.createElement("td")).colSpan=item.len,item.isEmpty||((widget=me.createEvent(item.event,{},!1)).addCls(me.$staticEventCls),cell.appendChild(widget.element.dom)),rowEl.appendChild(cell);content.insertBefore(rowEl,before)}Ext.fly(content.firstChild).insertFirst({tag:"td",cls:me.$headerGutterCls,rowSpan:content.childNodes.length})},constructEvents:function(){var i,j,day,frag,event,me=this,D=Ext.Date,events=me.getEventSource().getRange(),len=events.length,visibleDays=me.getVisibleDays(),start=D.clone(me.dateInfo.visible.start),end=start,hours=me.getEndTime()-me.getStartTime();for(me.constructAllDayEvents(events),i=0;i<visibleDays;++i){for(end=D.add(start,D.HOUR,hours,!0),frag=document.createDocumentFragment(),day=new Ext.calendar.view.DaysRenderer({view:me,start:start,end:end}),j=0;j<len;++j)event=events[j],me.isEventHidden(event)||day.addIf(event);day.hasEvents()&&(day.calculate(),me.processDay(day,frag)),me.getEventColumn(i).appendChild(frag),start=D.add(start,D.DAY,1)}},createEvent:function(event,cfg,dummy){var allDay=!!event&&event.getAllDay();return(cfg=cfg||{}).mode=allDay?"weekspan":"day",allDay||(cfg.resize=this.getResizeEvents()),this.callParent([event,cfg,dummy])},createScroller:function(){return new Ext.scroll.NativeScroller({element:this.bodyWrap,x:!1,y:!0})},doCheckNowMarker:function(){var pos,i,me=this,D=Ext.Date,markerEl=me.markerEl,now=me.roundDate(Ext.calendar.date.Util.getLocalNow()),active=me.dateInfo.visible,current=me.utcToLocal(active.start),end=me.utcToLocal(active.end),visibleDays=me.getVisibleDays(),y=now.getFullYear(),m=now.getMonth(),d=now.getDate(),h=now.getHours(),min=now.getMinutes(),startTime=me.getStartTime(),endTime=me.getEndTime();if(markerEl&&Ext.fly(markerEl).remove(),me.markerEl=null,me.element.isVisible(!0)){if(current<=now&&now<end)for(i=0;i<visibleDays;++i){if(current.getFullYear()===y&&current.getMonth()===m&&current.getDate()===d){startTime<=h&&(h<endTime||h===endTime&&0===min)&&(current.setHours(startTime),pos=D.diff(current,now,D.MINUTE)/me.slotTicks*me.getSlotStyle().minSlotHeight);break}current=D.add(current,D.DAY,1)}void 0!==pos&&(me.markerEl=Ext.fly(me.getColumn(i)).createChild({cls:me.$nowMarkerCls,style:{top:pos+"px"}},null,!0))}},doRecalculate:function(start){var end,activeEnd,me=this,D=Ext.Date,R=Ext.calendar.date.Range;return start||(start=D.clone(me.getValue())),start=me.toUtcOffset(D.clearTime(start,!0)),end=D.add(start,D.DAY,me.getVisibleDays()),activeEnd=D.subtract(end,D.DAY,1),{full:new R(start,end),active:new R(start,activeEnd),visible:new R(D.add(start,D.HOUR,me.getStartTime(),!0),D.subtract(end,D.HOUR,24-me.getEndTime(),!0))}},doRefresh:function(){var nodes,me=this,timeContainer=me.timeContainer,allDayBackgroundRow=me.allDayBackgroundRow;me.dateInfo||(me.suspendEventRefresh(),me.recalculate(),me.resumeEventRefresh()),timeContainer.dom.innerHTML="",timeContainer.appendChild(me.generateTimeElements(),!0),me.clearAndPopulate(me.allDayEmptyRow,me.generateAllDayCells(me.$allDayEmptyRowCls,"&#160;"),!0),me.clearAndPopulate(allDayBackgroundRow,me.generateAllDayCells(me.$allDayBackgroundCls)),me.clearAndPopulate(me.timeRow,me.generateColumns()),nodes=Ext.Array.toArray(me.allDayBackgroundRow.dom.childNodes),me.backgroundCells=Ext.Array.slice(nodes,1),me.checkNowMarker(),me.refreshHeaders(),me.syncHeaderScroll(),me.refreshEvents()},doRefreshEvents:function(){var source=this.getEventSource();this.clearEvents(),source&&source.getCount()&&this.constructEvents()},generateAllDayCells:function(cls,html){var i,ret=[],days=this.getVisibleDays();for(i=0;i<days;++i)ret.push({tag:"td",cls:cls,html:html});return ret},generateColumns:function(){var col,i,j,markers,me=this,days=me.getVisibleDays(),start=me.getStartTime(),end=me.getEndTime(),ret=[];for(i=0;i<days;++i){for(markers=[],col={tag:"td",cls:me.$dayColumnCls,"data-index":i,children:[{cls:me.$dayEventContainerCls},{cls:me.$markerContainerCls,children:markers}]},j=start;j<end;++j)markers.push({cls:me.$markerCls,children:[{cls:me.$markerAltCls}]});ret.push(col)}return ret},generateTimeElements:function(){var i,times=this.generateTimeLabels(),len=times.length,ret=[];for(i=0;i<len;++i)ret.push({cls:this.$timeCls,html:times[i]});return ret},generateTimeLabels:function(){var seenAM,seenPM,formatted,i,firstInGroup,me=this,D=Ext.Date,current=D.clone(me.baseDate),start=me.getStartTime(),end=me.getEndTime(),format=me.getTimeFormat(),ret=[],renderer=me.getTimeRenderer();for(i=start;i<end;++i)current.setHours(i),formatted=D.format(current,format),renderer&&(firstInGroup=!1,i<12&&!seenAM?firstInGroup=seenAM=!0:i>=12&&!seenPM&&(firstInGroup=seenPM=!0),formatted=renderer.call(this,i,formatted,firstInGroup)),ret.push(formatted);return ret},getBodyElement:function(){return this.bodyTable},getColumn:function(index){return this.getColumns()[index]},getColumns:function(){return this.bodyTable.query("."+this.$dayColumnCls)},getEventColumn:function(index){return Ext.fly(this.getColumn(index)).down("."+this.$dayEventContainerCls)},getEventStyle:function(){var fakeEvent,el,margin,eventStyle=this.eventStyle;return eventStyle||((el=(fakeEvent=this.createEvent(null,{resize:!0},!0)).element).dom.style.visibility="hidden",this.getEventColumn(0).appendChild(el.dom),(margin=el.getMargin()).height=margin.top+margin.bottom,this.eventStyle=eventStyle={margin:margin,resizerWidth:Ext.fly(el.down("."+this.$resizerCls,!0)).getWidth()},fakeEvent.destroy()),eventStyle},getEventWidget:function(event){var key,w,map=this.eventMap,id=event.id;for(key in map)if((w=map[key]).getModel().id===id)return w;return null},getMoveInterval:function(){return{unit:Ext.Date.DAY,amount:this.getVisibleDays()}},getSlotStyle:function(){var h,me=this,slotStyle=me.slotStyle;return slotStyle||(h=Ext.fly(me.bodyTable.down("."+me.$markerCls,!0)).getHeight(),me.slotStyle=slotStyle={hourHeight:h,halfHeight:h/2,minSlotHeight:h/me.slotsPerHour}),slotStyle},handleEventTap:function(e){var event=this.getEvent(e);event&&(e.preventDefault(),this.onEventTap(event))},handleResize:function(){var me=this;me.slotStyle=null,me.callParent(),me.refreshEvents(),me.checkNowMarker(),me.syncHeaderScroll()},onAllDayTouchEnd:function(e){var startPos,endPos,start,end,diff,event,me=this,D=Ext.Date,creating=me.isAllDayCreating;creating&&(startPos=creating.initialIndex,endPos=Ext.calendar.util.Dom.getIndexPosition(creating.positions,e.pageX),start=creating.startDate,diff=Math.abs(endPos-startPos),startPos>endPos?(end=start,start=D.subtract(end,D.DAY,diff)):end=D.add(start,D.DAY,diff),event=me.createModel({startDate:D.localToUtc(start),endDate:D.add(D.localToUtc(end),D.DAY,1),allDay:!0}),me.showAddForm(event,{scope:me,onSave:me.clearSelected,onCancel:me.clearSelected}),me.isAllDayCreating=null)},onAllDayTouchMove:function(e){var startPos,endPos,creating=this.isAllDayCreating;creating&&(startPos=creating.initialIndex,endPos=Ext.calendar.util.Dom.getIndexPosition(creating.positions,e.pageX),this.selectRange(startPos,endPos))},onAllDayTouchStart:function(e){var positions,index,me=this,D=Ext.Date,start=this.utcToLocal(me.dateInfo.full.start);"touch"===e.pointerType||e.getTarget("."+me.$eventCls,me.headerWrap)||(positions=Ext.calendar.util.Dom.extractPositions(me.backgroundCells,"getX"),index=Ext.calendar.util.Dom.getIndexPosition(positions,e.pageX),me.isAllDayCreating={positions:positions,initialIndex:index,startDate:D.add(start,D.DAY,index)},me.selectRange(index,index))},onBodyTouchEnd:function(e){var w,fn,event,start,end,creating=this.isBodyCreating;creating&&((w=creating.widget)&&(start=w.getStartDate(),end=w.getEndDate(),fn=function(){w.destroy()},event=this.createModel({startDate:start,endDate:end}),this.showAddForm(event,{onSave:fn,onCancel:fn})),this.isBodyCreating=null)},onBodyTouchMove:function(e){var el,w,slot,startSlot,topSlot,bottomSlot,start,end,me=this,D=Ext.Date,creating=me.isBodyCreating,resizeMins=me.minimumEventMinutes,margin=me.getEventStyle().margin;creating&&((w=creating.widget)||(el=(w=me.createEvent(null,{},!0)).element,w.setPalette(me.getDefaultPalette()),w.addCls(me.$resizingCls),w.setWidth("100%"),el.setZIndex(999),me.getEventColumn(creating.index).appendChild(el),creating.widget=w),el=w.element,(slot=me.slotFromPosition(e.getY()))<0||slot>me.maxSlots||((startSlot=creating.startSlot)===slot&&(slot=startSlot+1),startSlot>slot?(topSlot=slot,bottomSlot=startSlot):(topSlot=startSlot,bottomSlot=slot),el.setStyle({top:margin.top+me.slotToPosition(topSlot)+"px",marginTop:0,marginBottom:0}),w.setHeight((bottomSlot-topSlot)*me.getSlotStyle().halfHeight-margin.bottom),start=D.clone(creating.baseDate),start=D.add(start,D.MINUTE,topSlot*resizeMins,!0),end=D.add(start,D.MINUTE,(bottomSlot-topSlot)*resizeMins,!0),w.setStartDate(start),w.setEndDate(end)))},onBodyTouchStart:function(e){var col,index,d,me=this,D=Ext.Date;"touch"===e.pointerType||e.getTarget("."+me.$eventCls,me.bodyTable)||(col=e.getTarget("."+me.$dayColumnCls))&&(index=parseInt(col.getAttribute("data-index"),10),d=D.add(me.dateInfo.visible.start,D.DAY,index),me.isBodyCreating={col:col,index:index,baseDate:d,startSlot:me.slotFromPosition(e.getY())})},onResizerDrag:function(e){if(this.resizing){var end,me=this,D=Ext.Date,resizing=me.resizing,event=resizing.event,w=resizing.widget,halfHeight=me.getSlotStyle().halfHeight,slot=me.slotFromPosition(e.getY()),h=slot*halfHeight-resizing.eventTop,startSlot=resizing.startSlot,start=event.getStartDate(),resizeMins=me.minimumEventMinutes;e.stopEvent(),slot<0||slot>me.maxSlots||slot<=startSlot||(resizing.current=end=D.add(start,D.MINUTE,resizeMins*(slot-startSlot),!0),w.setHeight(h),w.setEndDate(end))}},onResizerDragEnd:function(){if(this.resizing){var me=this,R=Ext.calendar.date.Range,resizing=me.resizing,d=resizing.current,w=resizing.widget,originalHeight=resizing.height,event=resizing.event,fn=function(success){w.destroyed||(w.element.setZIndex(resizing.oldZIndex),w.removeCls(me.$resizingCls)),success||(w.setHeight(originalHeight),w.setEndDate(event.getEndDate()))};me.resizing=null,d?me.handleChange("resize",event,new R(event.getStartDate(),d),fn):fn()}},onResizerDragStart:function(e){var w,el,top,me=this,event=me.getEvent(e);e.stopEvent(),!1!==me.handleChangeStart("resize",event)&&(top=(el=(w=me.getEventWidget(event)).element).getTop(!0),me.resizing={height:w.getHeight(),event:event,eventTop:top,startSlot:me.slotFromPosition(top,!0),widget:w,oldZIndex:el.getZIndex()},w.addCls(me.$resizingCls),el.setZIndex(999))},onSourceAttach:function(){this.recalculate()},processDay:function(day,frag){var i,item,w,back,fwd,forwardPos,backwardPos,styles,me=this,events=day.events,len=events.length,slotHeight=me.getSlotStyle().minSlotHeight,eventStyle=me.getEventStyle(),margin=eventStyle.margin,resizerOffset=0,allowOverlap=me.getDisplayOverlap();for(me.getResizeEvents()&&(resizerOffset=eventStyle.resizerWidth+5),i=0;i<len;++i)forwardPos=(item=events[i]).forwardPos,backwardPos=item.backwardPos,allowOverlap&&(forwardPos=Math.min(1,backwardPos+2*(forwardPos-backwardPos))),back=backwardPos,fwd=1-forwardPos,w=me.createEvent(item.event),(styles={marginTop:0,marginBottom:0,top:item.start*slotHeight+margin.top+"px",zIndex:item.colIdx+1})[me.backPosName]=100*back+"%",styles[me.forwardPosName]=100*fwd+"%",allowOverlap&&item.edgeWeight>0&&(styles.marginRight=resizerOffset+"px"),w.setStyle(styles),w.setHeight(item.len*slotHeight-margin.bottom),frag.appendChild(w.element.dom)},recalculate:function(){var dateInfo=this.doRecalculate();this.dateInfo=dateInfo,this.setSourceRange(dateInfo.full)},refreshHeaders:function(){var header=this.getHeader(),dateInfo=this.dateInfo;header&&(header.setVisibleDays(this.getVisibleDays()),dateInfo&&header.setValue(this.utcToLocal(dateInfo.full.start)))},roundDate:function(d){return new Date(Ext.Number.roundToNearest(d.getTime(),this.slotTicks))},selectRange:function(start,end){var i,cells=this.backgroundCells,len=cells.length;for(start>end&&(i=start,start=end,end=i),i=0;i<len;++i)Ext.fly(cells[i]).toggleCls(this.$selectionCls,i>=start&&i<=end)},slotFromPosition:function(pageY,local){var y=pageY-(local?0:this.bodyTable.getY());return Math.round(y/this.getSlotStyle().halfHeight)},slotToPosition:function(slot){return slot*this.getSlotStyle().halfHeight},syncHeaderScroll:function(){var w,scrollable=this.scrollable,name=this.headerScrollOffsetName;scrollable&&(w=scrollable.getScrollbarSize().width+"px",this.headerWrap.setStyle(name,w),this.allDayBackgroundWrap.setStyle(name,w))},updateTimeLabels:function(){var len,i,times=this.generateTimeLabels(),nodes=this.timeContainer.dom.childNodes;for(times.length!==nodes.length&&Ext.raise("Number of generated times did not match"),i=0,len=times.length;i<len;++i)nodes[i].innerHTML=times[i]}}}),Ext.define("Ext.overrides.calendar.view.Days",{override:"Ext.calendar.view.Days",requires:["Ext.calendar.form.Edit","Ext.calendar.form.Add"],privates:{doRefresh:function(){this.setBodyWrapSize(),this.callParent(),this.updateLayout()},doRefreshEvents:function(){var me=this;me.callParent(),me.setBodyWrapSize(),me.syncHeaderScroll(),me.fireEvent("eventrefresh",me,{})},setBodyWrapSize:function(){var tableHeight,tableWrap=this.tableWrap,bodyWrap=this.bodyWrap;Ext.isIE10m&&(tableHeight=Ext.fly(tableWrap.dom.parentNode).getHeight(),tableWrap.setHeight(tableHeight),bodyWrap.setHeight(tableHeight-this.headerWrap.getHeight()))}}}),Ext.define("Ext.calendar.panel.Days",{extend:"Ext.calendar.panel.Base",xtype:"calendar-days",requires:["Ext.calendar.header.Days","Ext.calendar.view.Days"],config:{dayHeader:{xtype:"calendar-daysheader"},eventRelayers:{view:{beforeeventdragstart:!0,validateeventdrop:!0,eventdrop:!0,beforeeventresizestart:!0,validateeventresize:!0,eventresize:!0}},view:{xtype:"calendar-daysview"}},configExtractor:{dayHeader:{dayHeaderFormat:"format"},view:{allowSelection:!0,displayOverlap:!0,draggable:!0,droppable:!0,endTime:!0,resizeEvents:!0,showNowMarker:!0,startTime:!0,timeFormat:!0,visibleDays:!0,highlightToday:!0}},setTimeRange:function(start,end){this.getView().setTimeRange(start,end)},privates:{syncHeaderSize:!0}}),Ext.define("Ext.overrides.calendar.panel.Days",{override:"Ext.calendar.panel.Days",updateView:function(view,oldView){this.callParent([view,oldView]),view.on("eventrefresh","onEventRefresh",this)},privates:{onEventRefresh:function(){this.syncHeaders()}}}),Ext.define("Ext.calendar.view.Day",{extend:"Ext.calendar.view.Days",xtype:"calendar-dayview",config:{compactOptions:{displayOverlap:!0},visibleDays:1},privates:{getMoveInterval:function(){return{unit:Ext.Date.DAY,amount:1}}}}),Ext.define("Ext.calendar.panel.Day",{extend:"Ext.calendar.panel.Days",xtype:"calendar-day",requires:["Ext.calendar.view.Day"],config:{view:{xtype:"calendar-dayview"}}}),Ext.define("Ext.calendar.view.WeeksRenderer",{days:null,index:null,maxEvents:null,overflow:!0,start:null,view:null,constructor:function(config){var start,me=this,D=Ext.Date;Ext.apply(me,config),start=me.start,me.end=D.add(start,D.DAY,me.days),me.utcStart=this.view.utcTimezoneOffset(start),me.utcEnd=this.view.utcTimezoneOffset(me.end),me.hasMaxEvents=null!==me.maxEvents,me.rows=[],me.events=[],me.seen={},me.overflows=[]},addIf:function(event){var start,end,me=this;event.getAllDay()?(start=me.utcStart,end=me.utcEnd):(start=me.start,end=me.end),event.occursInRange(start,end)&&me.events.push(event)},calculate:function(){var i,j,dayEvents,event,eLen,utcEnd,end,id,eventEnd,span,offsetStart,offsetEnd,offsetRangeEnd,allDay,item,offset,isSpan,dayLen,hasAnyOverflows,overflow,map,prev,dayOverflows,me=this,D=Ext.Date,view=me.view,seen=me.seen,events=me.events,len=events.length,days=me.days,rangeEnd=me.end,utcRangeEnd=me.utcEnd,start=D.clone(me.start),utcStart=D.clone(me.utcStart),maxEvents=me.maxEvents,hasMaxEvents=me.hasMaxEvents,overflows=me.overflows,overflowOffset=me.overflow?1:0,dayEventList=[];for(i=0;i<days;++i){for(end=D.add(start,D.DAY,1),utcEnd=me.view.utcTimezoneOffset(end),dayEvents=[],j=0;j<len;++j)id=(event=events[j]).id,(allDay=event.getAllDay())?(offsetStart=utcStart,offsetEnd=utcEnd,offsetRangeEnd=utcRangeEnd):(offsetStart=start,offsetEnd=end,offsetRangeEnd=rangeEnd),event.occursInRange(offsetStart,offsetEnd)&&(isSpan=event.isSpan(),seen[id]?isSpan&&dayEvents.push({isPlaceholder:!0,event:event,id:id}):(span=1,isSpan&&(span=(eventEnd=event.getEndDate())>offsetRangeEnd?days-i:view.getDaysSpanned(offsetStart,eventEnd,allDay)),seen[id]=span,dayEvents.push({event:event,id:id})));if(eLen=dayEvents.length,dayEvents.sort(me.sortEvents),hasMaxEvents){if(map={},overflows[i]=overflow=[],overflow.$map=map,i>0)for(prev=overflows[i-1].$map,j=0;j<eLen;++j)prev[id=(item=dayEvents[j]).id]&&(overflow.push(item.event),map[id]=!0,dayEvents.splice(j,1),hasAnyOverflows=!0,--j,--eLen);if(eLen>0)if(eLen>maxEvents){for(offset=Math.max(0,maxEvents-overflowOffset),j=0,dayLen=(dayOverflows=Ext.Array.splice(dayEvents,offset)).length;j<dayLen;++j)item=dayOverflows[j],overflow.push(item.event),map[item.id]=!0;hasAnyOverflows=!0}else overflowOffset>0&&overflow.length&&eLen===maxEvents&&(item=dayEvents.pop(),overflow.push(item.event),map[item.id]=!0)}dayEventList.push(dayEvents),start=end,utcStart=utcEnd}for(hasAnyOverflows&&maxEvents>0&&me.calculateOverflows(dayEventList,overflows),i=0;i<days;++i)for(eLen=(dayEvents=dayEventList[i]).length,j=0;j<eLen;++j)(item=dayEvents[j]).isPlaceholder||(event=item.event,me.addToRow(event,i,seen[event.id]))},compress:function(rowIdx){for(var item,row=this.rows[rowIdx],ret=[],days=this.days,count=0,i=0;i<days;)(item=row[i]).event?(count>0&&(ret.push({isEmpty:!0,len:count}),count=0),ret.push(item),i+=item.len):(++count,++i);return count>0&&ret.push({isEmpty:!0,len:count}),ret},hasEvents:function(){return this.events.length>0},privates:{addToRow:function(event,dayIdx,days){var found,i,j,row,idx,rows=this.rows,len=rows.length,end=days+dayIdx;for(i=0;i<len;++i){for(row=rows[i],j=dayIdx;j<end&&!row[j];++j);if(j===end){found=row,idx=i;break}}found||(found=this.makeRow(),rows.push(found),idx=rows.length-1),this.occupy(event,found,idx,dayIdx,end-1)},calculateOverflows:function(dayEventList,overflows){var i,dayEvents,len,item,id,days=this.days,maxEvents=this.maxEvents;for(i=days-2;i>=0;--i)(len=(dayEvents=dayEventList[i]).length)>0&&0===overflows[i].length&&len===maxEvents&&(id=(item=dayEvents[len-1]).id,overflows[i+1].$map[id]&&(overflows[i].unshift(item.event),overflows[i].$map[id]=!0,dayEvents.length=len-1))},makeRow:function(){var i,row=[],days=this.days;for(i=0;i<days;++i)row[i]=0;return row},occupy:function(event,row,rowIdx,fromIdx,toIdx){var i,len=toIdx-fromIdx+1;for(i=fromIdx;i<=toIdx;++i)row[i]=i!==fromIdx||{event:event,len:len,start:fromIdx,weekIdx:this.index,localIdx:rowIdx}},sortEvents:function(event1,event2){return event1=event1.event,+(event2=event2.event).isSpan()-+event1.isSpan()||Ext.calendar.model.Event.sort(event1,event2)}}}),Ext.define("Ext.calendar.view.Weeks",{extend:"Ext.calendar.view.Base",xtype:"calendar-weeksview",requires:["Ext.calendar.view.WeeksRenderer"],uses:["Ext.calendar.dd.WeeksSource","Ext.calendar.dd.WeeksTarget"],isWeeksView:!0,baseCls:Ext.baseCSSPrefix+"calendar-weeks",config:{addOnSelect:!0,allowSelection:!0,compactOptions:{overflowText:"+{0}",showOverflow:"top"},dayFormat:"j",draggable:!0,droppable:!0,firstDayOfWeek:void 0,overflowText:"+{0} more",showOverflow:"bottom",value:void 0,visibleDays:7,visibleWeeks:2,weekendDays:void 0},constructor:function(config){var me=this;me.callParent([config]),me.el.on("tap","handleEventTap",me,{delegate:"."+me.$eventCls}),me.cellTable.on("click","onOverflowClick",me,{delegate:"."+me.$overflowCls}),me.recalculate(),me.refreshHeaders()},getDisplayRange:function(){var range,me=this;return me.isConfiguring&&me.recalculate(),range=me.dateInfo[me.displayRangeProp],new Ext.calendar.date.Range(me.utcToLocal(range.start),me.utcToLocal(range.end))},getVisibleRange:function(){var range,D=Ext.Date;return this.isConfiguring&&this.recalculate(),range=this.dateInfo.visible,new Ext.calendar.date.Range(D.clone(range.start),D.clone(range.end))},updateAllowSelection:function(allowSelection){this.selectionListeners=Ext.destroy(this.selectionListeners),allowSelection&&this.el.on({destroyable:!0,scope:this,touchstart:"onTouchStart",touchmove:"onTouchMove",touchend:"onTouchEnd"})},updateDayFormat:function(dayFormat){this.isConfiguring||this.refresh()},updateDaysInWeek:function(){this.refresh()},applyDraggable:function(draggable){return draggable&&(draggable=new Ext.calendar.dd.WeeksSource(draggable)),draggable},updateDraggable:function(draggable,oldDraggable){oldDraggable&&oldDraggable.destroy(),draggable&&draggable.setView(this)},applyDroppable:function(droppable){return droppable&&(droppable=new Ext.calendar.dd.WeeksTarget),droppable},updateDroppable:function(droppable,oldDroppable){oldDroppable&&oldDroppable.destroy(),droppable&&droppable.setView(this)},applyFirstDayOfWeek:function(firstDayOfWeek){return"number"!=typeof firstDayOfWeek&&(firstDayOfWeek=Ext.Date.firstDayOfWeek),firstDayOfWeek},updateFirstDayOfWeek:function(firstDayOfWeek){this.isConfiguring||(this.recalculate(),this.refreshHeaders(),this.refresh())},updateShowOverflow:function(showOverflow,oldShowOverflow){var base=Ext.baseCSSPrefix+"calendar-weeks-with-overflow-",el=this.element;oldShowOverflow&&el.removeCls(base+oldShowOverflow),showOverflow&&el.addCls(base+showOverflow),this.isConfiguring||this.refresh()},updateTimezoneOffset:function(){this.isConfiguring||this.recalculate()},updateValue:function(value,oldValue){var me=this;me.isConfiguring||(me.suspendEventRefresh(),me.recalculate(),me.resumeEventRefresh(),me.refreshHeaders(),me.refresh()),me.callParent([value,oldValue])},updateVisibleDays:function(){this.isConfiguring||(this.recalculate(),this.refreshHeaders(),this.refresh())},updateVisibleWeeks:function(visibleWeeks){var me=this,table=me.cellTable;me.suspendEventRefresh(),me.recalculate(),me.resumeEventRefresh(),table.removeChild(table.dom.firstChild),table.createChild({tag:"tbody",children:me.generateCells(me.dateInfo.requiredWeeks,!0)},null,!0),me.cells=me.queryCells(),me.isConfiguring||me.refresh()},applyWeekendDays:function(weekendDays){return weekendDays||Ext.Date.weekendDays},updateWeekendDays:function(weekendDays){this.weekendDayMap=Ext.Array.toMap(weekendDays),this.refresh()},getElementConfig:function(){var result=this.callParent();return result.children=[{tag:"table",reference:"cellTable",cls:this.$tableCls+" "+Ext.baseCSSPrefix+"calendar-weeks-week-rows",children:[{tag:"tbody"}]}],result},doDestroy:function(){this.setAllowSelection(!1),this.setDraggable(null),this.setDroppable(null),this.callParent()},privates:{displayRangeProp:"visible",domFormat:"Y-m-d",eventGutter:5,maxDayMonth:new Date(2e3,0,1),sundayDay:new Date(2e3,9,1),startMarginName:"left",trackRanges:!1,$rowCls:Ext.baseCSSPrefix+"calendar-weeks-row",$cellCls:Ext.baseCSSPrefix+"calendar-weeks-cell",$weekendCls:Ext.baseCSSPrefix+"calendar-weeks-weekend-cell",$outsideCls:Ext.baseCSSPrefix+"calendar-weeks-outside-cell",$pastCls:Ext.baseCSSPrefix+"calendar-weeks-past-cell",$futureCls:Ext.baseCSSPrefix+"calendar-weeks-future-cell",$todayCls:Ext.baseCSSPrefix+"calendar-weeks-today-cell",$selectionCls:Ext.baseCSSPrefix+"calendar-weeks-selection",$dayTextCls:Ext.baseCSSPrefix+"calendar-weeks-day-text",$hiddenCellCls:Ext.baseCSSPrefix+"calendar-weeks-hidden-cell",$cellInnerCls:Ext.baseCSSPrefix+"calendar-weeks-cell-inner",$overflowCls:Ext.baseCSSPrefix+"calendar-weeks-overflow",$cellOverflowCls:Ext.baseCSSPrefix+"calendar-weeks-overflow-cell",$overflowPopupCls:Ext.baseCSSPrefix+"calendar-weeks-overflow-popup",clearSelected:function(){var i,cells=this.cells,len=cells.length;for(i=0;i<len;++i)Ext.fly(cells[i]).removeCls(this.$selectionCls)},constructEvents:function(){var i,j,week,frag,event,me=this,D=Ext.Date,daysInWeek=Ext.Date.DAYS_IN_WEEK,events=me.getEventSource().getRange(),len=events.length,visibleDays=me.getVisibleDays(),visibleWeeks=me.dateInfo.requiredWeeks,current=D.clone(me.dateInfo.visible.start),eventHeight=me.getEventStyle().fullHeight,maxEvents=Math.floor(me.getDaySizes().heightForEvents/eventHeight),overflow="bottom"===me.getShowOverflow(),weeks=[];for(me.weeks=weeks,frag=document.createDocumentFragment(),i=0;i<visibleWeeks;++i){for(week=new Ext.calendar.view.WeeksRenderer({view:me,start:current,days:visibleDays,index:i,overflow:overflow,maxEvents:maxEvents}),j=0;j<len;++j)event=events[j],me.isEventHidden(event)||week.addIf(event);week.hasEvents()&&week.calculate(),me.processWeek(week,frag),weeks.push(week),current=D.add(current,D.DAY,daysInWeek)}me.element.appendChild(frag)},createEvent:function(event,cfg,dummy){var span=!event||event.isSpan();return cfg=Ext.apply({mode:span?"weekspan":"weekinline"},cfg),this.callParent([event,cfg,dummy])},doRecalculate:function(start){var value,startOffset,end,me=this,D=Ext.Date,daysInWeek=D.DAYS_IN_WEEK,visibleWeeks=me.getVisibleWeeks(),R=Ext.calendar.date.Range;return start=start||me.getValue(),startOffset=((start=D.clearTime(start,!0)).getDay()+daysInWeek-me.getFirstDayOfWeek())%daysInWeek,value=me.toUtcOffset(start),{full:new R(start=D.subtract(value,D.DAY,startOffset),end=D.add(start,D.DAY,visibleWeeks*daysInWeek-(daysInWeek-me.getVisibleDays()))),visible:new R(start,end),active:new R(start,D.subtract(end,D.DAY,1)),requiredWeeks:visibleWeeks}},doRefresh:function(){var cells,len,i,cell,firstDate,lastDate,me=this,D=Ext.Date,dateInfo=me.dateInfo,dayFormat=me.getDayFormat(),weekendDayMap=me.weekendDayMap,now=D.clearTime(Ext.calendar.date.Util.getLocalNow()),current=me.utcToLocal(dateInfo.visible.start),classes=[],trackRanges=me.trackRanges,visibleDays=me.getVisibleDays(),daysInWeek=Ext.Date.DAYS_IN_WEEK,y=now.getFullYear(),m=now.getMonth(),d=now.getDate();for(trackRanges&&(firstDate=me.utcToLocal(dateInfo.month.start),lastDate=me.utcToLocal(dateInfo.month.end)),i=0,len=(cells=me.cells).length;i<len;++i)cell=cells[i],classes.length=0,classes.push(me.$cellCls),weekendDayMap[current.getDay()]&&classes.push(me.$weekendCls),trackRanges&&(current<firstDate?classes.push(me.$pastCls,me.$outsideCls):current>lastDate&&classes.push(me.$futureCls,me.$outsideCls)),current.getFullYear()===y&&current.getMonth()===m&&current.getDate()===d&&(classes.push(me.$todayCls),me.highlightToday&&classes.push(me.$todayCellHighlightCls+"-weeks-day")),i%daysInWeek>=visibleDays&&classes.push(me.$hiddenCellCls),cell.className=classes.join(" "),cell.setAttribute("data-date",D.format(current,me.domFormat)),cell.firstChild.firstChild.innerHTML=D.format(current,dayFormat),current=D.add(current,D.DAY,1);me.refreshEvents()},doRefreshEvents:function(){var source=this.getEventSource();this.clearEvents(),this.hideOverflowPopup(),source&&source.getCount()&&this.constructEvents()},findIndex:function(sizes,offset){for(var i=0,len=sizes.length;i<len&&!((offset-=sizes[i])<=0);)++i;return i},generateCells:function(numRows,setHeights){var height,i,j,cells,style,me=this,daysInWeek=Ext.Date.DAYS_IN_WEEK,rows=[];for(setHeights&&(height=100/numRows,Ext.isGecko&&(height=parseInt(height,10)),style={height:height+"%"}),i=0;i<numRows;++i){for(cells=[],j=0;j<daysInWeek;++j)cells.push({tag:"td","data-index":j,cls:me.$cellCls,children:[{cls:me.$cellInnerCls,children:[{tag:"span",cls:me.$dayTextCls},{cls:me.$overflowCls}]}]});rows.push({tag:"tr",cls:me.$rowCls,"data-week":i,children:cells,style:style})}return rows},getCell:function(date){var i,cell,ret=null,cells=this.cells,len=cells.length;for(Ext.isDate(date)&&(date=Ext.Date.format(date,this.domFormat)),i=0;i<len;++i)if((cell=cells[i]).getAttribute("data-date")===date){ret=cell;break}return ret},getCellByPosition:function(pageX,pageY){var daySize,containerXY,cellIdx,rowIdx,me=this;return daySize=me.getDaySizes(),containerXY=me.element.getXY(),cellIdx=me.findIndex(daySize.widths,pageX-containerXY[0]),rowIdx=me.findIndex(daySize.heights,pageY-containerXY[1]),me.cells[rowIdx*Ext.Date.DAYS_IN_WEEK+cellIdx]},getCellFromEvent:function(e,inferFromWidget){var ret,xy;return!(ret=e.getTarget("."+this.$cellCls,this.element))&&inferFromWidget&&(xy=e.getXY(),ret=this.getCellByPosition(xy[0],xy[1])),ret},getDateFromCell:function(cell){return Ext.Date.parse(cell.getAttribute("data-date"),this.domFormat)},getDaySizes:function(){var cell,headerHeight,fly,widths,heights,i,h,me=this,daySizes=me.daySizes,cells=me.cells,visibleDays=me.getVisibleDays(),smallest=Number.MAX_VALUE;if(!me.daySizes){for(cell=cells[0],headerHeight=(fly=Ext.fly(cell.firstChild)).getPadding("tb")+Ext.fly(cell.firstChild.firstChild).getHeight(),widths=[],heights=[],i=0;i<visibleDays;++i)fly=Ext.fly(cells[i]),widths.push(fly.getWidth()),h=fly.getHeight(),heights.push(h),h<smallest&&(smallest=h);me.daySizes=daySizes={widths:widths,heights:heights,headerHeight:headerHeight,heightForEvents:Math.max(0,smallest-headerHeight-me.eventGutter)}}return daySizes},getEventStyle:function(){var fakeEvent,el,margin,height,eventStyle=this.eventStyle;return eventStyle||((el=(fakeEvent=this.createEvent(null,null,!0)).element).dom.style.visibility="hidden",this.element.appendChild(el),height=el.getHeight(),(margin=el.getMargin()).height=margin.top+margin.bottom,margin.width=margin.left+margin.right,this.eventStyle=eventStyle={margin:margin,height:height,fullHeight:height+margin.height},fakeEvent.destroy()),eventStyle},getEventWidget:function(el){var id,cls=this.$eventCls;return el.isEvent&&(el=el.target),Ext.fly(el).hasCls(cls)||(el=Ext.fly(el).up("."+cls,this.element,!0)),id=el.getAttribute("data-componentid"),this.eventMap[id]},getMoveBaseValue:function(){return this.utcToLocal(this.dateInfo.visible.start)},getMoveInterval:function(){var D=Ext.Date;return{unit:D.DAY,amount:D.DAYS_IN_WEEK*this.getVisibleWeeks()}},handleEventTap:function(e){var event=this.getEvent(e);event&&(this.hideOverflowPopup(),this.onEventTap(event))},handleResize:function(){this.callParent(),this.daySizes=null,this.hideOverflowPopup(),this.refreshEvents()},hideOverflowPopup:Ext.privateFn,onOverflowClick:function(e){var cell=this.getCellFromEvent(e),date=this.getDateFromCell(cell),week=parseInt(cell.parentNode.getAttribute("data-week"),10),index=parseInt(cell.getAttribute("data-index"),10);this.showOverflowPopup(this.weeks[week].overflows[index],date,cell)},onSourceAttach:function(){this.recalculate()},onTouchEnd:function(){var start,end,temp,event,me=this,D=Ext.Date,cells=me.cells;me.isSelecting&&((start=me.selectedStartIndex)===(end=me.selectedEndIndex)?(start=end=me.getDateFromCell(cells[start]),me.fireEvent("select",me,{date:start})):(start>end&&(temp=end,end=start,start=temp),start=me.getDateFromCell(cells[start]),end=me.getDateFromCell(cells[end]),me.fireEvent("selectrange",me,{range:new Ext.calendar.date.Range(start,end)})),me.getAddOnSelect()&&(me.hasEditableCalendars()&&me.getAddForm()?(event=me.createModel({allDay:!0,startDate:D.localToUtc(start),endDate:D.add(D.localToUtc(end),D.DAY,1)}),me.showAddForm(event,{scope:me,onSave:me.clearSelected,onCancel:me.clearSelected})):me.clearSelected()),me.isSelecting=!1)},onTouchMove:function(e){var end,current,i,cell,swap,me=this,start=me.selectedStartIndex,cells=me.cells,len=cells.length;if(me.isSelecting)for(cell=me.getCellFromEvent(e,!0),(current=Ext.Array.indexOf(cells,cell))>start?end=current:current<start?(end=start,start=current,swap=!0):end=start,me.selectedEndIndex=swap?start:end,i=0;i<len;++i)Ext.fly(cells[i]).toggleCls(me.$selectionCls,i>=start&&i<=end)},onTouchStart:function(e,t){var cell,me=this,el=me.element;"touch"===e.pointerType||e.getTarget("."+me.$overflowCls,el)||e.getTarget("."+me.$overflowPopupCls,el)||(cell=me.getCellFromEvent(e))&&(me.isSelecting=!0,me.selectedStartIndex=me.selectedEndIndex=Ext.Array.indexOf(me.cells,cell),Ext.fly(cell).addCls(me.$selectionCls))},positionEvent:function(el,item){var headerOffset,me=this,daySizes=me.getDaySizes(),eventStyle=me.getEventStyle(),margin=eventStyle.margin,widths=daySizes.widths,start=item.start,idx=item.localIdx,weekIdx=item.weekIdx;headerOffset=daySizes.headerHeight+eventStyle.height*idx+(idx+1)*margin.height,el.setTop(me.positionSum(0,weekIdx,daySizes.heights)+headerOffset),el.setLeft(me.positionSum(0,start,widths)+margin[me.startMarginName]),el.setWidth(me.positionSum(start,item.len,widths)-margin.width)},positionSum:function(start,len,sizes){var i,sum=0,end=start+len;for(i=start;i<end;++i)sum+=sizes[i];return sum},processWeek:function(week,frag){var overflow,row,i,rowLen,j,item,el,cell,len,me=this,rows=week.rows,days=week.days,overflows=week.overflows,cellOffset=week.index*Ext.Date.DAYS_IN_WEEK,showOverflow=me.getShowOverflow(),cells=me.cells,overflowCls=me.$cellOverflowCls,overflowText=me.getOverflowText();if(rows)for(i=0,len=rows.length;i<len;++i)for(j=0,rowLen=(row=week.compress(i)).length;j<rowLen;++j)(item=row[j]).isEmpty||((el=me.createEvent(item.event).element).dom.style.margin="0",frag.appendChild(el.dom),me.positionEvent(el,item));for(i=0;i<days;++i)cell=cells[cellOffset+i],(overflow=overflows&&overflows[i])&&overflow.length&&showOverflow?(Ext.fly(cell).addCls(overflowCls),cell.firstChild.lastChild.innerHTML=Ext.String.format(overflowText,overflow.length)):Ext.fly(cell).removeCls(overflowCls)},queryCells:function(){return this.element.query("."+this.$cellCls)},recalculate:function(){var dateInfo=this.doRecalculate();this.dateInfo=dateInfo,this.setSourceRange(dateInfo.visible)},refreshHeaders:function(){var header=this.getHeader(),dateInfo=this.dateInfo;header&&(header.setVisibleDays(this.getVisibleDays()),dateInfo&&header.setValue(this.utcToLocal(dateInfo.visible.start)))},selectRange:function(from,to){var i,cell,me=this,D=Ext.Date,range=me.dateInfo.active,cells=me.cells,len=cells.length,highlight=!1;if(from<range.start&&(from=range.start),to>range.end&&(to=range.end),from=me.getCell(D.clearTime(from,!0)),to=me.getCell(D.clearTime(to,!0)),from&&to)for(i=0;i<len;++i)(cell=cells[i])===from&&(highlight=!0),Ext.fly(cell).toggleCls(me.$selectionCls,highlight),cell===to&&(highlight=!1)},showOverflowPopup:Ext.privateFn}}),Ext.define("Ext.overrides.calendar.view.Weeks",{override:"Ext.calendar.view.Weeks",requires:["Ext.calendar.form.Edit","Ext.calendar.form.Add"],doDestroy:function(){this.tip=Ext.destroy(this.tip),this.callParent()},privates:{doRefresh:function(){this.callParent(),this.updateLayout()},hideOverflowPopup:function(){var tip=this.tip;tip&&(tip.hide(),tip.removeAll())},showOverflowPopup:function(events,date,cell){var me=this,tip=me.tip;tip||(me.tip=tip=new Ext.tip.ToolTip({ui:"calendar-overflow",anchor:!0,renderTo:document.body,hidden:!0,autoHide:!1,cls:me.$overflowPopupCls,minWidth:200,defaultAlign:"tc-bc?"}),me.tip.el.on("tap","handleEventTap",me,{delegate:"."+me.$eventCls})),tip.removeAll(),events=me.createEvents(events,{cls:me.$staticEventCls}),tip.add(events),tip.el.dom.setAttribute("data-date",Ext.Date.format(date,me.domFormat)),tip.showBy(cell)}}}),Ext.define("Ext.calendar.panel.Weeks",{extend:"Ext.calendar.panel.Base",xtype:"calendar-weeks",requires:["Ext.calendar.header.Weeks","Ext.calendar.view.Weeks"],config:{dayHeader:{xtype:"calendar-weeksheader"},eventRelayers:{view:{beforeeventdragstart:!0,validateeventdrop:!0,eventdrop:!0}},view:{xtype:"calendar-weeksview"}},configExtractor:{dayHeader:{dayHeaderFormat:"format"},view:{addOnSelect:!0,allowSelection:!0,dayFormat:!0,draggable:!0,droppable:!0,firstDayOfWeek:!0,overflowText:!0,showOverflow:!0,visibleDays:!0,visibleWeeks:!0,weekendDays:!0,highlightToday:!0}}}),Ext.define("Ext.calendar.view.Month",{extend:"Ext.calendar.view.Weeks",xtype:"calendar-monthview",config:{value:void 0,visibleWeeks:6},nextMonth:function(months){this.navigate(this.getNavigateValue(months),Ext.Date.MONTH)},nextYear:function(years){this.navigate(this.getNavigateValue(years),Ext.Date.YEAR)},previousMonth:function(months){this.navigate(-this.getNavigateValue(months),Ext.Date.MONTH)},previousYear:function(years){this.navigate(-this.getNavigateValue(years),Ext.Date.YEAR)},privates:{displayRangeProp:"month",maxWeeks:6,$rowClasses:[Ext.baseCSSPrefix+"calendar-month-4weeks",Ext.baseCSSPrefix+"calendar-month-5weeks",Ext.baseCSSPrefix+"calendar-month-6weeks"],$todayCellHighlightCls:Ext.baseCSSPrefix+"today-cell-highlight",trackRanges:!0,doRecalculate:function(start){var days,end,first,l,last,startOffset,me=this,D=Ext.Date,daysInWeek=D.DAYS_IN_WEEK,firstDayOfWeek=me.getFirstDayOfWeek(),requiredWeeks=me.maxWeeks,visibleWeeks=me.getVisibleWeeks(),visibleDays=me.getVisibleDays(),R=Ext.calendar.date.Range;return startOffset=((start=D.getFirstDateOfMonth(start||me.getValue())).getDay()+daysInWeek-firstDayOfWeek)%daysInWeek,first=me.toUtcOffset(start),l=D.getLastDateOfMonth(start),last=me.toUtcOffset(l),null===visibleWeeks&&(startOffset>=visibleDays&&(startOffset=visibleDays-startOffset),days=startOffset+D.getDaysInMonth(start),requiredWeeks=Math.ceil(days/daysInWeek)),end=daysInWeek*requiredWeeks-(daysInWeek-visibleDays),{full:new R(start=D.subtract(first,D.DAY,startOffset),end=D.add(start,D.DAY,end)),visible:new R(start,end),active:new R(start,D.subtract(end,D.DAY,1)),month:new R(first,last),requiredWeeks:requiredWeeks}},doRefresh:function(){var cls=this.$rowClasses,weeks=this.dateInfo.requiredWeeks;this.element.replaceCls(cls,cls[weeks-1-cls.length]),this.callParent()},getMoveBaseValue:function(){return this.utcToLocal(this.dateInfo.month.start)},getMoveInterval:function(){return{unit:Ext.Date.MONTH,amount:1}},generateCells:function(){return this.callParent([this.maxWeeks,!1])},getNavigateValue:function(n){return n||0===n?n:1}}}),Ext.define("Ext.calendar.panel.Month",{extend:"Ext.calendar.panel.Weeks",xtype:"calendar-month",requires:["Ext.calendar.view.Month"],config:{view:{xtype:"calendar-monthview"}},autoSize:!1,nextMonth:function(months){this.getView().nextMonth(months)},nextYear:function(years){this.getView().nextYear(years)},previousMonth:function(months){this.getView().previousMonth(months)},previousYear:function(years){this.getView().previousYears(years)},updateHighlightToday:function(highlightToday){var cellEl,domFormat,view=this.getView(),header=view.getHeader();domFormat=Ext.Date.format(new Date,header.domFormat),(cellEl=view.element.selectNode('td[data-date="'+domFormat+'"]',!1))&&cellEl.toggleCls(view.$todayCellHighlightCls+"-weeks-day",highlightToday)}}),Ext.define("Ext.calendar.panel.AbstractPanel",{extend:"Ext.panel.Panel",requires:["Ext.layout.container.Border","Ext.button.Segmented","Ext.toolbar.Toolbar"],layout:"border",config:{createButton:{ui:"default-small"},sideBar:{region:"west",collapsible:!0}},items:[{xtype:"panel",reference:"mainContainer",region:"center",layout:"fit"}],initComponent:function(){var ct,me=this;me.callParent(),ct=me.lookup("mainContainer"),me.addSideBar({collapsed:me.getCompact()}),me.addTitleBar(),ct.add(me.createView()),me.refreshCalTitle()},onRender:function(parentNode,containerIdx){this.callParent([parentNode,containerIdx]),this.body.unselectable()},updateCompact:function(compact){this.isConfiguring||this.reconfigureItems()},updateCreateButtonPosition:function(){var vis,sheet=this.sheet;this.isConfiguring||(vis=sheet&&sheet.isVisible(),this.reconfigureItems(),vis&&this.showSheet())},updateSwitcherPosition:function(){var vis,sheet=this.sheet;this.isConfiguring||(vis=sheet&&sheet.isVisible(),this.reconfigureItems(),vis&&this.showSheet())},privates:{addSideBar:function(){var cfg=this.createSideBar();cfg&&this.add(cfg)},addTitleBar:function(){var cfg=this.createTitleBar();cfg&&this.lookup("mainContainer").addDocked(cfg)},createSideBar:function(cfg){var me=this,items=[];return"sideBar"===me.getCreateButtonPosition()&&items.push({xtype:"container",margin:"0 0 10 0",layout:{type:"hbox",pack:"center"},items:me.createCreateButton()}),items.push(me.createCalendarList()),"sideBar"===me.getSwitcherPosition()&&items.push(me.createSwitcher({vertical:!0})),cfg=Ext.merge({reference:"sideBar",layout:{type:"vbox",align:"stretch"}},cfg),this.createContainerWithChildren(cfg,this.getSideBar(),items)},createTitleBar:function(){var me=this,items=[];return"titleBar"===me.getCreateButtonPosition()&&items.push(me.createCreateButton({margin:"0 10 0 0"})),items.push(me.createTodayButton(),{xtype:"segmentedbutton",allowToggle:!1,items:[me.createPreviousButton(),me.createNextButton()]},me.createDateTitle()),"titleBar"===me.getSwitcherPosition()&&items.push({xtype:"component",flex:1},me.createSwitcher()),this.createContainerWithChildren({reference:"titleBar"},this.getTitleBar(),items)},onSwitcherChange:function(btn,value){this.doSetView(value,!0)},reconfigureItems:function(){var me=this;Ext.suspendLayouts(),Ext.destroy(me.lookup("titleBar"),me.lookup("sideBar")),me.addTitleBar(),me.addSideBar({collapsed:me.getCompact()}),me.refreshCalTitle(),Ext.resumeLayouts(!0)},setSwitcherValue:function(value){var switcher=this.lookup("switcher");switcher?switcher.setValue(value):this.setView(value,!0)}}}),Ext.define("Ext.calendar.view.Week",{extend:"Ext.calendar.view.Days",xtype:"calendar-weekview",config:{firstDayOfWeek:void 0,visibleDays:7},applyFirstDayOfWeek:function(firstDayOfWeek){return"number"!=typeof firstDayOfWeek&&(firstDayOfWeek=Ext.Date.firstDayOfWeek),firstDayOfWeek},updateFirstDayOfWeek:function(){this.isConfiguring||(this.recalculate(),this.refreshHeaders(),this.checkNowMarker())},privates:{doRecalculate:function(start){var startOffset,activeEnd,end,me=this,D=Ext.Date,R=Ext.calendar.date.Range,daysInWeek=D.DAYS_IN_WEEK;return start=start||me.getValue(),startOffset=((start=D.clearTime(start,!0)).getDay()+daysInWeek-me.getFirstDayOfWeek())%daysInWeek,start=me.toUtcOffset(start),start=D.subtract(start,D.DAY,startOffset),end=D.add(start,D.DAY,me.getVisibleDays()),activeEnd=D.subtract(end,D.DAY,1),{full:new R(start,end),active:new R(start,activeEnd),visible:new R(D.add(start,D.HOUR,me.getStartTime(),!0),D.subtract(end,D.HOUR,24-me.getEndTime(),!0))}},getMoveBaseValue:function(){return this.utcToLocal(this.dateInfo.full.start)},getMoveInterval:function(){var D=Ext.Date;return{unit:D.DAY,amount:D.DAYS_IN_WEEK}}}}),Ext.define("Ext.calendar.panel.Week",{extend:"Ext.calendar.panel.Days",xtype:"calendar-week",requires:["Ext.calendar.view.Week"],config:{view:{xtype:"calendar-weekview"}},configExtractor:{view:{firstDayOfWeek:!0}},$todayCellHighlightCls:Ext.baseCSSPrefix+"today-cell-highlight",updateDayHeader:function(dayHeader,oldDayHeader){this.callParent(arguments),this.updateHighlightToday(this.extracted.view.highlightToday)},updateHighlightToday:function(highlightToday){var headerEl,domFormat,header=this.getView().getHeader();domFormat=Ext.Date.format(new Date,header.domFormat),(headerEl=header.element.selectNode('td[data-date="'+domFormat+'"]',!1))&&headerEl.toggleCls(this.$todayCellHighlightCls+"-day",highlightToday)}}),Ext.define("Ext.calendar.view.Multi",{extend:"Ext.container.Container",xtype:"calendar-multiview",requires:["Ext.calendar.date.Util"],layout:"fit",platformConfig:{"!desktop":{compact:!0}},config:{compact:!1,compactOptions:null,store:null,timezoneOffset:void 0,value:void 0,views:null},defaultView:null,constructor:function(config){var view;this.callParent([config]),(view=this.defaultView)&&this.setView(view)},moveNext:function(){this.setValue(this.activeView.calculateMoveNext())},movePrevious:function(){this.setValue(this.activeView.calculateMovePrevious())},navigate:function(amount,interval){var D=Ext.Date;0!==amount&&this.setValue(D.add(this.getValue(),interval||D.DAY,amount,!0))},setView:function(view){var cfg,me=this,active=me.activeView;active&&active.$key===view||(Ext.suspendLayouts(),active&&me.remove(active),(cfg=me.getViews()[view])||Ext.raise('Invalid view specified: "'+view+'".'),cfg.highlightToday=me.highlightToday,me.activeView=me.add(me.createView(cfg,view)),me.activeView.on("valuechange","onValueChange",me),me.recalculate(me.getValue()),Ext.resumeLayouts(!0))},updateHighlightToday:function(highlightToday){this.highlightToday=highlightToday,this.getActiveItem().updateHighlightToday(highlightToday)},updateCompact:function(compact){this.setViewCfg("setCompact",compact)},applyStore:function(store){return store&&(store=Ext.StoreManager.lookup(store,"calendar-calendars")),store},updateStore:function(store){this.setViewCfg("setStore",store),this.isConfiguring||this.recalculate(this.getValue())},applyTimezoneOffset:function(timezoneOffset){return this.autoOffset=!1,void 0===timezoneOffset&&(timezoneOffset=Ext.calendar.date.Util.getDefaultTimezoneOffset(),this.autoOffset=!0),timezoneOffset},updateTimezoneOffset:function(timezoneOffset){this.setViewCfg("setTimezoneOffset",timezoneOffset)},applyValue:function(value,oldValue){return value=Ext.Date.clearTime(value||Ext.calendar.date.Util.getLocalNow(),!0),oldValue&&oldValue.getTime()===value.getTime()&&(value=void 0),value},updateValue:function(value){this.isConfiguring||this.recalculate(value)},showAddForm:function(data,options){return this.activeView.showAddForm(data,options)},showEditForm:function(event,options){return this.activeView.showEditForm(event,options)},privates:{createView:function(cfg,key){var me=this;return Ext.apply({$key:key,controlStoreRange:!1,compact:me.getCompact(),store:me.getStore(),timezoneOffset:me.autoOffset?void 0:me.getTimezoneOffset(),value:me.getValue()},cfg)},getActiveKey:function(){var active=this.activeView;return active?active.$key:""},onValueChange:function(view,context){this.setValue(context.value),this.fireEvent("valuechange",this,context)},recalculate:function(value){var range,eventSource,view=this.activeView,store=this.getStore();view&&store&&(eventSource=store.getEventSource(),range=Ext.calendar.date.Util.expandRange(view.getView().doRecalculate(value).full),eventSource.setRange(range),view.setValue(value))},setViewCfg:function(setterName,value){var view;this.isConfiguring||(view=this.activeView)&&view[setterName](value)}}}),Ext.define("Ext.calendar.panel.Panel",{extend:"Ext.calendar.panel.AbstractPanel",xtype:"calendar",mixins:["Ext.mixin.ConfigState"],alternateStateConfig:"compactOptions",requires:["Ext.calendar.panel.Day","Ext.calendar.panel.Week","Ext.calendar.panel.Month","Ext.calendar.List","Ext.calendar.view.Multi","Ext.calendar.date.Util"],referenceHolder:!0,platformConfig:{"!desktop":{compact:!0}},config:{calendarList:{xtype:"calendar-list",reference:"list",flex:1},compact:!1,compactOptions:{},createButton:{xtype:"button",cls:Ext.baseCSSPrefix+"calendar-panel-create-button",text:"Create"},createButtonPosition:"sideBar",dateTitle:{xtype:"component",reference:"calTitle",cls:Ext.baseCSSPrefix+"calendar-panel-title",margin:"0 0 0 10"},highlightToday:!0,nextButton:{xtype:"button",text:">"},previousButton:{xtype:"button",text:"<"},sideBar:{xtype:"panel",cls:Ext.baseCSSPrefix+"calendar-sidebar"},store:null,switcher:{xtype:"segmentedbutton",reference:"switcher",cls:Ext.baseCSSPrefix+"calendar-panel-switcher",allowMultiple:!1},switcherPosition:"titleBar",timezoneOffset:void 0,titleBar:{xtype:"toolbar"},todayButton:{xtype:"button",text:"Today",margin:"0 10 0 0"},value:void 0,views:{day:{xtype:"calendar-day",titleTpl:'{start:date("l F d, Y")}',controlStoreRange:!1,label:"Day",weight:10,dayHeader:null},week:{xtype:"calendar-week",dayHeaderFormat:"D d",controlStoreRange:!1,titleTpl:'{start:date("j M")} - {end:date("j M Y")}',label:"Week",weight:20},month:{xtype:"calendar-month",titleTpl:'{start:date("F Y")}',label:"Month",weight:30}}},defaultView:"month",cls:Ext.baseCSSPrefix+"calendar-panel",moveNext:function(){this.getView().moveNext()},movePrevious:function(){this.getView().movePrevious()},navigate:function(amount,interval){this.getView().navigate(amount,interval)},setView:function(view){this.doSetView(view)},updateCompact:function(compact,oldCompact){this.toggleCls(Ext.baseCSSPrefix+"compact",compact),this.toggleConfigState(compact),this.callParent([compact,oldCompact]),this.setViewCfg("setCompact",compact)},updateCompactOptions:function(){!this.isConfiguring&&this.getCompact()&&this.toggleConfigState(!0)},applyStore:function(store){return store&&(store=Ext.StoreManager.lookup(store,"calendar-calendars")),store},updateStore:function(store){var list=this.lookup("list");this.setViewCfg("setStore",store),list&&list.setStore(store)},applyTimezoneOffset:function(timezoneOffset){return this.autoOffset=!1,void 0===timezoneOffset&&(timezoneOffset=Ext.calendar.date.Util.getDefaultTimezoneOffset(),this.autoOffset=!0),timezoneOffset},updateTimezoneOffset:function(timezoneOffset){this.setViewCfg("setTimezoneOffset",timezoneOffset)},applyValue:function(value,oldValue){return value=Ext.Date.clearTime(value||Ext.calendar.date.Util.getLocalNow(),!0),oldValue&&oldValue.getTime()===value.getTime()&&(value=void 0),value},updateValue:function(value){this.setViewCfg("setValue",value),this.refreshCalTitle()},getValue:function(){var view=this.getView();return view?view.getValue():this.callParent()},getView:function(){return this.lookup("view")},privates:{weightStart:0,weightIncrement:10,createCalendarList:function(cfg){return Ext.apply({store:this.getStore()},this.getCalendarList())},createCreateButton:function(cfg){return cfg=cfg||{},cfg=Ext.apply(cfg,this.getCreateButton()),Ext.apply({handler:"onCreateTap",scope:this},cfg)},createContainerWithChildren:function(defaults,cfg,items){var len,i,item,cfgItems=(cfg=Ext.apply({},cfg)).items,weight=this.weightStart,incr=this.weightIncrement;if(cfgItems){for(Ext.isArray(cfgItems)||(cfgItems=[cfgItems]),i=0,len=(items=Ext.Array.clone(items)).length;i<len;++i)null==(item=items[i]).weight&&(items[i]=Ext.apply({weight:weight},item)),weight+=incr;items=items.concat(cfgItems),Ext.Array.sort(items,this.weightSorter),delete cfg.items}return cfg.items=items,Ext.apply(cfg,defaults)},createDateTitle:function(cfg){return cfg=cfg||{},Ext.apply(cfg,this.getDateTitle())},createNextButton:function(){return Ext.apply({handler:"onNextTap",scope:this},this.getNextButton())},createPreviousButton:function(){return Ext.apply({handler:"onPrevTap",scope:this},this.getPreviousButton())},createSwitcher:function(cfg){var me=this,view=me.getView();return cfg=Ext.apply({value:view&&view.getActiveKey()||me.defaultView,listeners:{scope:me,change:"onSwitcherChange"},items:me.getSwitcherItems()},cfg),Ext.apply(cfg,me.getSwitcher())},createTodayButton:function(){return Ext.apply({handler:"onTodayTap",scope:this},this.getTodayButton())},createView:function(){var me=this;return{xtype:"calendar-multiview",reference:"view",compact:me.getCompact(),defaultView:me.defaultView,store:me.getStore(),timezoneOffset:me.autoOffset?void 0:me.getTimezoneOffset(),value:me.getValue(),views:me.getViews(),highlightToday:me.getHighlightToday(),listeners:{scope:me,valuechange:"onValueChange"}}},doSetView:function(view,fromSwitcher){fromSwitcher?(this.getView().highlightToday=this.getHighlightToday(),this.getView().setView(view),this.refreshCalTitle()):this.setSwitcherValue(view)},updateHighlightToday:function(highlightToday){this.isConfiguring||this.getView().updateHighlightToday(highlightToday)},getSwitcherItems:function(){var key,o,views=this.getViews(),items=[];for(key in views)(o=views[key])&&items.push({text:o.label,value:key,weight:o.weight});return items.sort(this.weightSorter),items},onCreateTap:function(){this.getView().showAddForm()},onNextTap:function(){this.moveNext()},onPrevTap:function(){this.movePrevious()},onValueChange:function(view,context){this.setValue(context.value)},onTodayTap:function(){this.setValue(new Date)},refreshCalTitle:function(){var tpl,view=this.getView(),calTitle=this.lookup("calTitle");view&&calTitle&&(tpl=(view=view.activeView).lookupTpl("titleTpl"))&&calTitle.setHtml(tpl.apply(view.getDisplayRange()))},setViewCfg:function(setterName,value){var view;this.isConfiguring||(view=this.getView())&&view[setterName](value)},weightSorter:function(a,b){return a.weight-b.weight}}}),Ext.define("Ext.calendar.theme.Palette",{primary:null,secondary:null,border:null,constructor:function(config){Ext.apply(this,config)}});