#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия @tag_ver@

pgb_cmd=$1

if [ -z "${pgb_cmd}" ]; then
  pgb_cmd="SHOW DATABASES"
fi;

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Цвета
ErrColor=$($dks_bashfile_dir/pgb_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/pgb_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/pgb_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/pgb_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/pgb_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/pgb_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/pgb_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/pgb_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/pgb_const_var.sh emptE)

# Файл обмена хоста и контейнера
tag_name=$($dks_bashfile_dir/pgb_const_var.sh tag_name)
host_stdout=$($dks_bashfile_dir/pgb_const_var.sh host_stdout)
cont_stdout=$($dks_bashfile_dir/pgb_const_var.sh cont_stdout)
dks_cont_name=$($dks_bashfile_dir/pgb_const_var.sh dks_cont_name)
contsoft=$($dks_bashfile_dir/pgb_const_var.sh contsoft)

function fn_file_clr(){
cat > $1 << EOF
EOF
}

fn_file_clr ${host_stdout}
chmod 606 ${host_stdout}

# sudo
is_root=$(${dks_bashfile_dir}/pgb_const_var.sh is_root)
if [ "${is_root}" -ne 0 ]; then
  echo ""
  echo -e "${eRR}Для выполнения текущей операции необходимы права суперпользователя."
  echo ""
  exit 1;
fi

echo ""
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo -e "${WarnColor} Виртуальная БД PgBouncer (${dks_cont_name})${NoColor}"
echo -e "${WarnColor} Выполняемая команда: ${SuccColor}${pgb_cmd}${NoColor}"
echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
echo ""

fn_file_clr ${host_stdout}

# Считываем количество используемых ядер из файла
p_cnt=$(cat ${dks_bashfile_dir}/pgbouncer_to_run)


for ((j=1;j<=p_cnt;j++))
do
  chk_cmd="/opt/${tag_name}/bin/psql -p @pgb_port@ -h /opt/${tag_name}/run/${j} -U @pgb_user@ -c\\\"${pgb_cmd}\\\" -d pgbouncer -o ${cont_stdout}"
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}" -u "postgres" -noerr

  for ((i=1;i<10;i++))
  do
    #sleep 0.5

    if [ -s ${host_stdout} ]; then
      echo -e "${NoColor} Информация\действие по пoтоку N ${j} (/opt/${tag_name}/run/${j})"
      cat ${host_stdout}
      break
    fi;

  done

done

if ! [ -s ${host_stdout} ]; then
  echo -e "${NoColor} Нет информации для отображения. Возможно указана неверная команда.${NoColor}"
  echo -e "${NoColor} Cписок доступных команд:${NoColor}"
  echo -e "${NoColor}         SHOW HELP|CONFIG|DATABASES|POOLS|CLIENTS|SERVERS|USERS|VERSION${NoColor}"
  echo -e "${NoColor}         SHOW FDS|SOCKETS|ACTIVE_SOCKETS|LISTS|MEM${NoColor}"
  echo -e "${NoColor}         SHOW DNS_HOSTS|DNS_ZONES${NoColor}"
  echo -e "${NoColor}         SHOW STATS|STATS_TOTALS|STATS_AVERAGES|TOTALS${NoColor}"
  echo -e "${NoColor}         SET key = arg${NoColor}"
  echo -e "${NoColor}         RELOAD${NoColor}"
  echo -e "${NoColor}         PAUSE [<db>]${NoColor}"
  echo -e "${NoColor}         RESUME [<db>]${NoColor}"
  echo -e "${NoColor}         DISABLE <db>${NoColor}"
  echo -e "${NoColor}         ENABLE <db>${NoColor}"
  echo -e "${NoColor}         RECONNECT [<db>]${NoColor}"
  echo -e "${NoColor}         KILL <db>${NoColor}"
  echo -e "${NoColor}         SUSPEND${NoColor}"
  echo -e "${NoColor}         SHUTDOWN${NoColor}"
  echo -e ""
  echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
else
  echo -e ""
  echo -e "${WarnColor}----------------------------------------------------------${NoColor}"
fi;
echo -e ""

rm -f ${host_stdout}

exit 0;
