#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия @tag_ver@


db_host=$1
pgb_port=@pgb_port@
pgb_cmd="RELOAD"

if [ -z "${db_host}" ]; then
  echo "Не указан ip сервера СУБД."
  exit 1;
fi;

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

tag_name=$($dks_bashfile_dir/pgb_const_var.sh tag_name)

inst_path="/opt/${tag_name}"
conf_path="${inst_path}/conf.d"
ctl_path="${inst_path}/ctl"
bin_path="${inst_path}/bin"
run_path="${inst_path}/run"

# переопределение сервера СУБД
#----------------------  pgbouncer_db.ini ------------------------------

cp ${ctl_path}/pgb_promote_db.ini.t    ${conf_path}/pgbouncer_db.ini
sed -i 's/@db_host@/'${db_host}'/g'    ${conf_path}/pgbouncer_db.ini

chmod 644 ${conf_path}/pgbouncer_db.ini

# RELOAD pgbouncer
# Считываем количество используемых ядер из файла
p_cnt=$(cat ${dks_bashfile_dir}/pgbouncer_to_run)

for ((j=1;j<=p_cnt;j++))
do
  ${bin_path}/psql -p ${pgb_port} -h ${run_path}/${j} -U pgbouncer -c "${pgb_cmd}" -d pgbouncer
done

exit 0;

