#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.25.1


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Цвета
ErrColor=$($dks_bashfile_dir/pgb_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/pgb_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/pgb_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/pgb_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/pgb_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/pgb_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/pgb_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/pgb_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/pgb_const_var.sh emptE)

# Файл обмена хоста и контейнера
host_stdout=$($dks_bashfile_dir/pgb_const_var.sh host_stdout)
cont_stdout=$($dks_bashfile_dir/pgb_const_var.sh cont_stdout)
dks_cont_name=$($dks_bashfile_dir/pgb_const_var.sh dks_cont_name)
dks_serv_name=$($dks_bashfile_dir/pgb_const_var.sh dks_serv_name)
contsoft=$($dks_bashfile_dir/pgb_const_var.sh contsoft)

function fn_file_clr(){
cat > $1 << EOF
EOF
}

fn_file_clr ${host_stdout}
chmod 606 ${host_stdout}

# sudo
is_root=$($dks_bashfile_dir/pgb_const_var.sh is_root)
if [ "$is_root" -ne 0 ]; then
  echo ""
  echo -e "${eRR}Для выполнения текущей операции необходимы права суперпользователя."
  echo ""
  exit 1;
fi;

echo ""
echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo -e "${WarnColor} Процессы пуллера PgBouncer (${dks_cont_name}):${NoColor}"
echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""

fn_file_clr ${host_stdout}

chk_cmd="ps -eo pid=PID,ppid=PPID,uname=USERNAME,pcpu=%CPU%,pmem=%MEM%,cmd=CMD_postgres  | grep -e 'postgres' | grep -v 'grep -e postgres' | grep -v 'ps -eo '"
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

echo ""
echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

if [ ! -f "/lib/systemd/system/${dks_serv_name}" ]; then
  echo -e "${ErrColor}Сервис ${dks_serv_name} отсутствует в системе.${NoColor}"
else
  echo -e "${WarnColor}Сервис ${dks_serv_name}:${NoColor}"
  echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
  systemctl status ${dks_serv_name} --no-pager
fi;


rm -f ${host_stdout}

exit 0;

