#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.25.1

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

tag_ver="1.25.1"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -m|--mode)
        mode="$2"
        ;;
      -h|--db_host)
        db_host="$2"
        ;;
      -p|--db_port)
        db_port="$2"
        ;;

      -u|--pgb_user)
        pgb_user="$2"
        ;;
      -pwd|--pgb_user_pwd)
        pgb_user_pwd="$2"
        ;;

      -bp|--pgb_port)
        pgb_port="$2"
        ;;
      -rc|--run_count)
        run_count="$2"
        ;;


      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ] || [ -z "${mode}" ]; then

echo -e "

 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -m  | --mode                          режим конфигурации
                                       database - изменение параметров подключения к СУБД;
                                       user     - изменение пользователя, обслуживающего пуллер;
                                       count    - конфигурирование количества одновременно
                                                  запущенных процессов;

 -h  | --db_host                       ip адрес СУБД

 -p  | --db_port        5434           порт СУБД

 -u  | --pgb_user       pgbouncer      имя пользователя в СУБД, обслуживающего пуллер

 -pwd| --pgb_user_pwd   1              пароль пользователя в СУБД, обслуживающего пуллер

 -bp | --pgb_port       6434           порт пуллера

 -rc | --run_count      1              количество запущенных процессов

 Примеры вызова:
  - конфигурирование количества одновременно запущенных процессов
    \$ /opt/dks-pgbouncer-${tag_ver}/configure.sh -m \"count\" -rc \"8\"

  - изменение параметров подключения к СУБД
    \$ /opt/dks-pgbouncer-${tag_ver}/configure.sh -m \"database\" -h \"10.38.46.000\" -p \"5434\" -u \"pgbouncer\"

  -  изменение пользователя, обслуживающего пуллер
    \$ /opt/dks-pgbouncer-${tag_ver}/configure.sh -m \"user\" -u \"pgbouncer\" -pwd '~!@#$%^&*()' -bp \"6434\"

"
exit 1;
fi;

if [ -z "${pgb_port}" ] ; then
  pgb_port="6434"
fi;

if [ -z "${db_port}" ] ; then
  db_port="5434"
fi;

if [ -z "${pgb_user}" ] ; then
  pgb_user="pgbouncer"
fi;

if [ -z "${pgb_user_pwd}" ] ; then
  pgb_user_pwd="1"
fi;

if [ -z "${run_count}" ] ; then
  run_count="1"
fi;


if [ "${mode}" = "database" ]; then
  p3=${db_host}
  p4=${db_port}
  p5=${pgb_user}
fi;

if [ "${mode}" = "user" ]; then
  p3=${pgb_user}

  # Вычисляем md5 пароля пользователя
  temp_hash=$(echo -n "${pgb_user_pwd}${pgb_user}" | md5sum)
  p4=$(echo "md5${temp_hash}" | sed -r 's/ .+//')

fi;

if [ "${mode}" = "count" ]; then
  p3=${run_count}
fi;


# Вычисляем md5 пароля пользователя
temp_hash=$(echo -n "${pgb_user_pwd}${pgb_user}" | md5sum)
md5pwd=$(echo "md5${temp_hash}" | sed -r 's/ .+//')



echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~   Конфигурирование пуллера PgBouncer ${tag_ver}"
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

bash ${dks_bashfile_dir}/sh/dks_update.sh "${pgb_port}"     \
                                          "${mode}"         \
                                          "${p3}"           \
                                          "${p4}"           \
                                          "${p5}"

exit;
