#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

dks_cont_name=$($dks_bashfile_dir/pgb_const_var.sh dks_cont_name)
contsoft=$($dks_bashfile_dir/pgb_const_var.sh contsoft)

cont_stdout=$($dks_bashfile_dir/pgb_const_var.sh cont_stdout)
host_stdout=$($dks_bashfile_dir/pgb_const_var.sh host_stdout)

# Цвета
sOK=$(echo $(${dks_bashfile_dir}/pgb_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $(${dks_bashfile_dir}/pgb_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $(${dks_bashfile_dir}/pgb_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $(${dks_bashfile_dir}/pgb_const_var.sh emptE) | tr '#' ' ')


# Если установка прошла без поддержки ssh сервера, то просто ставим "выход"
# иначе ничего
@exit@


action=$1

if [ -z "${action}" ]; then
  action="start"
fi;

if [[ "${action}" != "start" && "${action}" != "stop" ]]; then
  echo "${emptE}Неверный параметр действия."
  echo "${emptE}Доcтупные значения параметра: start или stop."
  echo ""
  exit 1;
fi;


# Запуск/Остановка ssh внутри контейнера
chk_cmd="echo \\\$(ps -ef | grep /usr/sbin/sshd | grep -v root) > ${cont_stdout}"

bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

file_stdout=$(cat ${host_stdout})
rm -f ${host_stdout}

if [ "${action}" = "start" ]; then

  if [ ! -z "${file_stdout}" ]; then
    echo -e "${wOK}Проверка запуска SSH сервера в контейнере ${dks_cont_name}"
    echo -e "${emptE}SSH cервер уже запущен."
    exit 0;
  fi;


  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                   -cn "${dks_cont_name}" \
                                                   -c   "/usr/sbin/sshd"  \
                                                   -u   "postgres"

  if [ $? = "1" ]; then
    echo ""
    echo -e "${eRR}Запуск SSH сервера в контейнере ${dks_cont_name}."
    echo -e "${emptE}Была предпринята неудачная попытка запуска SSH сервера."
    exit 1;
  fi;

  echo -e "${sOK}Запуск SSH сервера в контейнере ${dks_cont_name}."

else

  if [ -z "${file_stdout}" ]; then
    echo -e "${wOK}Остановка SSH сервера в контейнере ${dks_cont_name}."
    echo -e "${emptE}SSH сервер уже остановлен."
    exit 0;
  fi;

  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                   -cn "${dks_cont_name}" \
                                                   -c  "kill -9 \\\$(pidof sshd)"

  if [ $? = "1" ]; then
    echo ""
    echo -e "${eRR}Остановка SSH сервера в контейнере ${dks_cont_name}."
    echo -e "${emptE}Была предпринята неуспешная попытка остановки SSH сервера в контейнере ${dks_cont_name}."
    exit 1;
  fi;

  echo -e "${sOK}Остановка SSH сервера в контейнере ${dks_cont_name}."

fi;

exit;

