#!/bin/bash

###
### Проверка работы сервиса или наличия файла ПО
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия 1.0.0
###

_target_check=$1
_target_text=$2
_target_type=$3

# === Определяем каталог выполнения текущего скрипта ==========================
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# файл констант
_const_file="${_bashfile_dir}/sys_const_var.sh"

_sOK=$(echo $(${_const_file} sOK) | tr '#' ' ')
_wOK=$(echo $(${_const_file} wOK) | tr '#' ' ')
_eRR=$(echo $(${_const_file} eRR) | tr '#' ' ')
_emptE=$(echo $(${_const_file} emptE) | tr '#' ' ')


# Проверка запущенности сервиса
if [ "${_target_type}" = "service" ]; then
  if [ -f "/lib/systemd/system/${_target_check}.service" ]; then
    if systemctl -q is-active ${_target_check}; then
      echo -e "${_sOK}Проверка работы сервиса ПО \"${_target_text}\" (${_target_check}.service)."
    else
      if systemctl -q is-active docker; then
        echo -e "${_sOK}Проверка работы сервиса ПО \"${_target_text}\" (${_target_check}.service)."
      else
        echo -e "${_eRR}Проверка работы сервиса ПО \"${_target_text}\" (${_target_check}.service)."
        echo -e "${_emptE}Сервис ПО \"${_target_text}\" (${_target_check}.service) существует, но не запущен."
        echo -e "${_emptE}Операция установки будет прервана."
        echo ""
        exit 1;
      fi;
    fi;
  else
    echo -e "${_eRR}Проверка работы сервиса ПО \"${_target_text}\" (${_target_check}.service)."
    echo -e "${_emptE}Отсутствует сервис ПО \"${_target_text}\" (${_target_check}.service)."
    echo -e "${_emptE}Операция установки будет прервана."
    echo ""
    exit 1;
  fi;
else
  # Иначе проверка наличия файла программы
  _file_exists=$(which ${_target_check})
  if [ -z ${_file_exists} ]; then
    echo -e "${_eRR}Проверка наличия файла ПО \"${_target_text}\" (${_target_check})."
    echo -e "${_emptE}Отсутствует файл ПО \"${_target_text}\" (${_target_check})."
    echo -e "${_emptE}Операция установки будет прервана."
    echo ""
    exit 1;
  else
    echo -e "${_sOK}Проверка наличия файла ПО \"${_target_text}\" (${_target_check})."
  fi;
fi;


exit 0;

