#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.25.1

db_host=$1
db_port=$2
pgb_user=$3
md5pwd="$4"
pgb_port=$5
pgb_ssh=$6
contsoft=$7
net_isolation=$8

if [ -z "${pgb_port}" ] ; then
  pgb_port="6434"
fi;

# === Определяем каталог выполнения текущего скрипта ==================================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

nameOS="astra18"
typeOS="astra"
container_ssh_port="2222"

tag_ver=$($dks_bashfile_dir/dks_const_var.sh tag_ver)
tag_name=$($dks_bashfile_dir/dks_const_var.sh tag_name)
dks_cont_name=$($dks_bashfile_dir/dks_const_var.sh dks_cont_name)
dks_inst_path=$($dks_bashfile_dir/dks_const_var.sh dks_inst_path)
app_inst_path=$($dks_bashfile_dir/dks_const_var.sh app_inst_path)
dks_stdout=$($dks_bashfile_dir/dks_const_var.sh dks_stdout)


# Цвета
sOK=$(echo $($dks_bashfile_dir/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/dks_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/dks_const_var.sh emptE)

# sudo
is_root=$($dks_bashfile_dir/dks_const_var.sh is_root)

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}


# Проверка прав суперпользователя
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "install"
if [ $? = "1" ]; then exit 1; fi;

fn_file_clr ${dks_stdout}
chmod 606 ${dks_stdout}

echo -e ""

# =========== Проверка параметров ===================================

pgbouncer_msg_title="пуллер pgBouncer"

if [ -z "${db_host}" ]; then
  echo -e "${eRR}Проверка корректности значения указанного ip хоста сервера СУБД."
  echo -e "${emptE}Не указан ip адрес хоста сервера СУБД (параметр -h)."
  echo -e "${emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;

if [ -z "${db_port}" ]; then
  echo -e "${eRR}Проверка корректности значения указанного порта сервера СУБД."
  echo -e "${emptE}Не указан порт сервера СУБД (параметр -p)."
  echo -e "${emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;

if [ -z "${pgb_user}" ]; then
  echo -e "${eRR}Проверка корректности значения пользователя сервера СУБД."
  echo -e "${emptE}Не указан пользователь сервера СУБД (параметр -U)."
  echo -e "${emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;

#if [ -z "${pgb_user_pwd}" ]; then
if [ -z "${md5pwd}" ]; then
  echo -e "${eRR}Проверка корректности значения пароля пользователя сервера СУБД."
  echo -e "${emptE}Не указан пароль пользователь сервера СУБД (параметр -pwd)."
  echo -e "${emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;

# Вычисляем md5 пароля пользователя
# temp_hash=$(echo -n "${pgb_user_pwd}${pgb_user}" | md5sum)
# md5pwd=$(echo "md5${temp_hash}" | sed -r 's/ .+//')


if [ -z "${pgb_port}" ]; then
  echo -e "${eRR}Проверка корректности значения указанного порта для пуллера сервера СУБД."
  echo -e "${emptE}Не указан порт для работы пуллера СУБД (параметр -bp)."
  echo -e "${emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;

bash ${dks_bashfile_dir}/sys/sys_checkport.sh "interval" "${pgb_port}" "${pgbouncer_msg_title}" "5432" "6442"
if [ $? = "1" ]; then exit 1; fi;

# Проверка "свободности" порта на хосте
bash ${dks_bashfile_dir}/sys/sys_checkport.sh "free" "${pgb_port}" "${pgbouncer_msg_title}"
if [ $? = "1" ]; then exit 1; fi;


# Проверка сервиса docker или файла podman на хосте
if [ "${contsoft}" = "docker"  ]; then
  contsoftname="Docker"
  consoftchecktype="service"
else
  contsoftname="Podman"
  consoftchecktype="file"
fi;

bash ${dks_bashfile_dir}/sys/sys_checkservice.sh "${contsoft}" "${contsoftname}" "${consoftchecktype}"
if [ $? = "1" ]; then exit 1; fi;

# Окончательный путь к развертыванию
inst_dir="${app_inst_path}_${pgb_port}"
dks_cont_name="${dks_cont_name}_${pgb_port}"
dks_serv_name="${dks_cont_name}.service"


# === Проверка существующего по порту приложения =======================================
if [ -d ${inst_dir} ]; then
  echo -e "${eRR}Порт ${pgb_port} возможно уже используется другим приложением (${inst_dir})."
  echo -e "${emptE}Укажите другой порт."
  echo -e "${emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;
# ======================================================================================

se_mode="Disabled"
# Проверка Selinux
if [ -f /etc/selinux/config ]; then
  se_mode=$(echo $(getenforce))
  if [ "${se_mode}" = "Enforcing" ]; then
    # переключаем в разрешительный :)
    setenforce Permissive
  fi;
fi;

# == Удаление принудительно контейнер+образ ============================================

if [ ! -z "$(${contsoft} ps -a | grep ${dks_cont_name})" ]; then
  ${contsoft} rm -f ${dks_cont_name} >/dev/null 2>&1
  echo -e "${sOK}Удаление контейнера ${dks_cont_name}."
fi

if [ ! -z "$(${contsoft} ps -a | grep ${tag_name})" ]; then
  ${contsoft} rm -f ${tag_name} >/dev/null 2>&1
  echo -e "${sOK}Удаление контейнера ${tag_name}."
fi

if [ ! -z "$(${contsoft} images | grep ${dks_cont_name})" ]; then
  ${contsoft} rmi -f ${dks_cont_name} >/dev/null 2>&1
  echo -e "${sOK}Удаление образа ${dks_cont_name}."
fi

if [ ! -z "$(${contsoft} images | grep ${tag_name})" ]; then
  ${contsoft} rmi -f ${tag_name} >/dev/null 2>&1
  echo -e "${sOK}Удаление образа ${tag_name}."
fi

# === Загружаем образ ==================================================================

dks_image_tar_file="${nameOS}_${tag_name}_image.tar"
if [ ! -f "${dks_inst_path}/container_image/${dks_image_tar_file}" ]; then
  echo -e "${eRR}Загрузка эталонного локального образа ${tag_name} из архива ${dks_image_tar_file}"
  echo -e "${emptE}Отсутствует файл архива с образом ${dks_inst_path}/container_image/${dks_image_tar_file}"
  echo -e "${emptE}Операция установки будет прервана."

  # восстанавливаем значение для selinux
  if [ "${se_mode}" = "Enforcing" ]; then
    # переключаем обратно.
    setenforce Enforcing
  fi;

  exit 1;
else
  ${contsoft} load -q -i "${dks_inst_path}/container_image/${dks_image_tar_file}" >/dev/null
  echo -e "${sOK}Загрузка эталонного локального образа ${tag_name} из архива ${dks_image_tar_file}."
fi

# === Создаем конечный образ на базе загруженного =====================================

${contsoft} build -t ${dks_cont_name} ${dks_inst_path}/container_image >/dev/null
echo -e "${sOK}Построение конечного образа ${dks_cont_name} на базе эталонного."

# === Создаем структуру каталогов, если нет ===========================================
# переходим в корневой каталог и проверяем наличие структуры

if ! [ -d "${inst_dir}/" ]; then
  echo -e "${emptE}Структура каталогов ${inst_dir} для запуска контейнера ${dks_cont_name} не существует, создаем..."
  mkdir -p ${inst_dir}/conf.d
  mkdir -p ${inst_dir}/ctl
  mkdir -p ${inst_dir}/ctl/sys
  mkdir -p ${inst_dir}/log
  mkdir -p ${inst_dir}/.ssh

  ### файлы управления
  # копируем файлы управления и файл лицензии
  cp ${dks_inst_path}/pgb_files/ctl/* ${inst_dir}/ctl

  # pgb_promote.sh
  cat ${dks_inst_path}/pgb_files/template/pgb_promote.sh.t    | sed 's/@pgb_port@/'${pgb_port}'/g'  > ${inst_dir}/ctl/pgb_promote.sh
  sed -i 's/@tag_ver@/'${tag_ver}'/g'                                                                 ${inst_dir}/ctl/pgb_promote.sh

  # pgb_ssh.sh
  if [ -z "${pgb_ssh}" ]; then ssh_allow="exit;"; else ssh_allow=""; fi;
  cat ${dks_inst_path}/pgb_files/template/pgb_ssh.sh.t    | sed 's/@tag_ver@/'${tag_ver}'/g'        > ${inst_dir}/ctl/pgb_ssh.sh
  sed -i 's/@exit@/'${ssh_allow}'/g'                                                                  ${inst_dir}/ctl/pgb_ssh.sh

  # pgb_promote_db.ini.t
  cat ${dks_inst_path}/pgb_files/template/pgbouncer_db.ini.t   | sed 's/@db_port@/'${db_port}'/g'   > ${inst_dir}/ctl/pgb_promote_db.ini.t
  sed -i 's/@pgb_user@/'${pgb_user}'/g'                                                               ${inst_dir}/ctl/pgb_promote_db.ini.t

  ### формируем файлы конфигов
  # pgbouncer_main.ini
  cat ${dks_inst_path}/pgb_files/template/pgbouncer_main.ini.t | sed 's/@pgb_user@/'${pgb_user}'/g' > ${inst_dir}/conf.d/pgbouncer_main.ini
  sed -i 's/@tag_name@/'${tag_name}'/g'                                                               ${inst_dir}/conf.d/pgbouncer_main.ini

  #pgbouncer_port.ini
  cat ${dks_inst_path}/pgb_files/template/pgbouncer_port.ini.t | sed 's/@pgb_port@/'${pgb_port}'/g' > ${inst_dir}/conf.d/pgbouncer_port.ini

  # pgbouncer_db.ini
  cat ${dks_inst_path}/pgb_files/template/pgbouncer_db.ini.t   | sed 's/@db_host@/'${db_host}'/g'   > ${inst_dir}/conf.d/pgbouncer_db.ini
  sed -i 's/@db_port@/'${db_port}'/g'                                                                 ${inst_dir}/conf.d/pgbouncer_db.ini
  sed -i 's/@pgb_user@/'${pgb_user}'/g'                                                               ${inst_dir}/conf.d/pgbouncer_db.ini


  # auth_user.ini
  cat ${dks_inst_path}/pgb_files/template/auth_user.ini.t      | sed 's/@pgb_user@/'${pgb_user}'/g' > ${inst_dir}/conf.d/auth_user.ini
  sed -i 's/@md5pwd@/'${md5pwd}'/g'                                                                   ${inst_dir}/conf.d/auth_user.ini
  chmod 606 ${inst_dir}/conf.d/auth_user.ini


  cat ${dks_inst_path}/pgb_files/template/pgb_const_var.sh.t   | sed 's/@pgb_port@/'${pgb_port}'/g' > ${inst_dir}/ctl/pgb_const_var.sh
  sed -i 's/@tag_ver@/'${tag_ver}'/g'                                                                 ${inst_dir}/ctl/pgb_const_var.sh
  sed -i 's/@contsoft@/'${contsoft}'/g'                                                               ${inst_dir}/ctl/pgb_const_var.sh

  # psql.sh
  cat ${dks_inst_path}/pgb_files/template/psql.sh.t            | sed 's/@pgb_port@/'${pgb_port}'/g' > ${inst_dir}/ctl/psql.sh
  sed -i 's/@tag_ver@/'${tag_ver}'/g'                                                                 ${inst_dir}/ctl/psql.sh
  sed -i 's/@db_host@/'${db_host}'/g'                                                                 ${inst_dir}/ctl/psql.sh
  sed -i 's/@db_port@/'${db_port}'/g'                                                                 ${inst_dir}/ctl/psql.sh
  sed -i 's/@tag_name@/'${tag_name}'/g'                                                               ${inst_dir}/ctl/psql.sh
  sed -i 's/@dks_cont_name@/'${dks_cont_name}'/g'                                                     ${inst_dir}/ctl/psql.sh
  sed -i 's/@contsoft@/'${contsoft}'/g'                                                               ${inst_dir}/ctl/psql.sh

  # psql_pgb.sh
  cat ${dks_inst_path}/pgb_files/template/psql_pgb.sh.t        | sed 's/@pgb_port@/'${pgb_port}'/g' > ${inst_dir}/ctl/psql_pgb.sh
  sed -i 's/@tag_ver@/'${tag_ver}'/g'                                                                 ${inst_dir}/ctl/psql_pgb.sh
  sed -i 's/@pgb_user@/'${pgb_user}'/g'                                                               ${inst_dir}/ctl/psql_pgb.sh

  # bash.sh
  cat ${dks_inst_path}/pgb_files/template/bash.sh.t            | sed 's/@pgb_port@/'${pgb_port}'/g' > ${inst_dir}/ctl/bash.sh
  sed -i 's/@tag_ver@/'${tag_ver}'/g'                                                                 ${inst_dir}/ctl/bash.sh


  # pgb_registr.sh.t
  cat ${dks_inst_path}/pgb_files/template/pgb_registr.sh.t     | sed 's/@tag_ver@/'${tag_ver}'/g'   > ${inst_dir}/ctl/pgb_registr.sh
  sed -i 's/@pgb_port@/'${pgb_port}'/g'                                                               ${inst_dir}/ctl/pgb_registr.sh

  cp ${dks_inst_path}/pgb_files/ctl/start.sh   ${inst_dir}/ctl/start.sh
  cp ${dks_inst_path}/pgb_files/ctl/stop.sh    ${inst_dir}/ctl/stop.sh
  cp ${dks_inst_path}/pgb_files/ctl/info.sh    ${inst_dir}/ctl/info.sh


  cp ${dks_inst_path}/sh/sys/sys_const_var.sh    ${inst_dir}/ctl/sys/sys_const_var.sh
  cp ${dks_inst_path}/sh/sys/sys_exec_cont.sh    ${inst_dir}/ctl/sys/sys_exec_cont.sh
  cp ${dks_inst_path}/sh/sys/sys_exec_cont_ex.sh ${inst_dir}/ctl/sys/sys_exec_cont_ex.sh

  chmod -R 700 ${inst_dir}/ctl
  chmod 644 ${inst_dir}/ctl/readme.txt
  chmod 644 ${inst_dir}/ctl/COPYRIGHT
  chmod 644 ${inst_dir}/ctl/pgbouncer_to_run
  chmod 644 ${inst_dir}/ctl/pgb_promote_db.ini.t


  # помещаем файл информатор, если по контейнеризации podman
  rm -f ${inst_dir}/podman
  if [ "${contsoft}" = "podman" ]; then
    echo "podman" > ${inst_dir}/podman
  fi;

  echo -e "${sOK}Создание структуры каталогов для запуска контейнера ${dks_cont_name}."
fi;

# == Создание пользователя ks-postgres на хосте ===========================================================

fn_file_echo ${dks_stdout} ${emptEsh}

bash ${dks_bashfile_dir}/sys/sys_useradd.sh "ks-postgres"
if [ $? = "1" ]; then exit 1; fi;
chown -R ks-postgres:ks-postgres ${inst_dir}/.ssh

# ======================================================================================================


# === Создаем контейнер из образа и запускаем в фоновом режиме =========================================
if ! [ -z "${net_isolation}" ]; then
  set_network="-p ${pgb_port}:${pgb_port}"

  if ! [ -z "${pgb_ssh}" ]; then # дополнително пор тдля ssh
    set_network="${set_network} -p ${container_ssh_port}:${container_ssh_port}"
  fi;
  echo -e "${sOK}Монтирование портов в контейнер."
else
  set_network="--network host"
  echo -e "${sOK}Монтирование сети хоста в контейнер."
fi;


${contsoft} run -di \
           -v /etc/localtime:/etc/localtime:ro,z         \
           -v ${inst_dir}/.ssh:/home/postgres/.ssh       \
           -v ${inst_dir}/conf.d:/opt/${tag_name}/conf.d \
           -v ${inst_dir}/ctl:/opt/${tag_name}/ctl       \
           -v ${inst_dir}/log:/opt/${tag_name}/log       \
           ${set_network} \
           --name ${dks_cont_name} ${dks_cont_name} /bin/bash >/dev/null

echo -e "${sOK}Создание контейнера ${dks_cont_name} и запуск в docker (идентификатор ${pgb_port})."
# ======================================================================================================


# временная зона хоста для синхронизации даты и времени в контейнере
if ! [ "${typeOS}" == "alt" ]; then
  tzhost=$(timedatectl status | grep "zone" | sed -e 's/^[ ]*Time zone: \(.*\) (.*)$/\1/g')
  if [ ! -z "${tzhost}" ]; then
    # копировать файл timezone не нужно, т.к. монтируем файл хоста непосредственно в докер
    # просто выполняем переконфигурирование TZ
    run_cmd="dpkg-reconfigure -f noninteractive tzdata"
    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${run_cmd}" -noout
  fi;
fi;

# Корректируем пользователя postgres в контейнере
# Замена ID пользователя postgres на хостовый ID (считываем в переменные)
# Пользователи с равными ID будут наследовать и права доступа
# Поэтому выравниваем id для пользователя postgres

uid_whost=$(id -u ks-postgres)
gid_whost=$(id -g ks-postgres)

run_cmd="groupmod -g ${gid_whost} postgres && usermod -u ${uid_whost} -g ${gid_whost} postgres"
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                 -cn "${dks_cont_name}" \
                                                 -c  "${run_cmd}"       \
                                                 -noout
if [ $? = "1" ]; then exit 1; fi;


# Коррекция прав на каталог развернутого приложения на хосте
chown -R ks-postgres:ks-postgres ${inst_dir}
# коррекция прав на каталоги в контейнере
run_cmd="chown -R postgres:postgres /opt/${tag_name}"
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                 -cn "${dks_cont_name}" \
                                                 -c  "${run_cmd}"       \
                                                 -noout
if [ $? = "1" ]; then exit 1; fi;

# Коррекция прав для работы ssh сервера в контейнере
if [ "${typeOS}" == "alt" ]; then
  run_cmd="chown -R postgres:postgres /etc/openssh"
else
  run_cmd="chown -R postgres:postgres /etc/ssh"
fi;
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                 -cn "${dks_cont_name}" \
                                                 -c  "${run_cmd}"       \
                                                 -noout
if [ $? = "1" ]; then exit 1; fi;


# перенос файлов сертификатов для беспарольного доступа в домашний каталог
# пользователя postgres в контейнере
if [ "${typeOS}" == "alt" ]; then
  run_cmd="\cp -r /etc/openssh/*key* /home/postgres/.ssh"
else
  run_cmd="cp /etc/ssh/*key* /home/postgres/.ssh"
fi;
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                 -cn "${dks_cont_name}" \
                                                 -c  "${run_cmd}"       \
                                                 -noout
if [ $? = "1" ]; then exit 1; fi;

# коррекция прав на каталоги в контейнере
run_cmd="chown -R postgres:postgres /home/postgres"
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                 -cn "${dks_cont_name}" \
                                                 -c  "${run_cmd}"       \
                                                 -noout
if [ $? = "1" ]; then exit 1; fi;

# Останавливаем контейнер
${contsoft} stop -t 1 ${dks_cont_name} >/dev/null
echo -e "${sOK}Остановка контейнера ${dks_cont_name}."


# При запуске текущего скрипта без параметра "CallServ", делаем
# окружение для запуска в systemd. Это необходимо, чтобы
# после аварийного отключения или просто перезагрузки хоста
# заново запустить контейнер

# === Создание автозапуска при перезагрузке хоста =======================================================

if [ -f "/lib/systemd/system/${dks_serv_name}" ]; then
  fn_file_clr /lib/systemd/system/${dks_serv_name}
fi;

# Формирование содержимого файла */service
if [ "${contsoft}" = "docker"  ]; then
  requires_service="Requires=docker.service"
  after_service="After=docker.service"
else
  requires_service=""
  after_service=""
fi;


cat > /lib/systemd/system/${dks_serv_name} << EOF
[Unit]
Description=PgBouncer ${tag_name}:${pgb_port}
# Запускать после старта сервисов и служб
${requires_service}
After=syslog.target
After=network.target
${after_service}

[Service]
Type=forking
WorkingDirectory=${inst_dir}/ctl
ExecStart=${inst_dir}/ctl/start.sh
ExecStop=${inst_dir}/ctl/stop.sh
RemainAfterExit=yes

# Запрет на убийство сервиса вследствие нехватки памяти и срабатывания механизма OOM:
#-1000 полный запрет (такой у sshd стоит), -100 понизим вероятность.
OOMScoreAdjust=-1000

# Таймаут в секундах, сколько ждать system отработки старт/стоп команд.
TimeoutSec=300

[Install]
#Уровень запуска - Многопользовательский режим без графики
WantedBy=multi-user.target
EOF

systemctl daemon-reload

# Анализируем наличие FireWall и пытаемся добавить правило для открытия порта
bash ${dks_bashfile_dir}/sys/sys_firewall.sh "${pgb_port}" "tcp"

# Открываем порт для ssh сервера в контейнере, если поддержка включена
# Анализируем наличие FireWall и пытаемся добавить правило для открытия порта СУБД
if ! [ -z "${pgb_ssh}" ]; then

  bash ${dks_bashfile_dir}/sys/sys_firewall.sh "${container_ssh_port}" "tcp"

fi;


systemctl enable ${dks_serv_name} >/dev/null 2>${dks_stdout}
# показываем
fn_file_echo ${dks_stdout} ${emptEsh}
fn_file_clr ${dks_stdout}
rm -f ${dks_stdout}

systemctl start ${dks_serv_name}

# === Настройка ротации логов
bash  ${dks_bashfile_dir}/sys/sys_logrotate.sh "${inst_dir}/log"         \
                                               "${tag_name}_${pgb_port}" \
                                               "${pgbouncer_msg_title}"


# === Проверяем что служба запустилась ============================================================

if systemctl -q is-active ${dks_serv_name}; then
  echo -e "${sOK}Запуск сервиса ${dks_serv_name}."
else
  echo -e "${eRR}Запуск сервиса ${dks_serv_name}."
  echo -e "${emptE}Была предпринята неудачная попытка запуска сервиса ${dks_serv_name}."
  echo -e "${emptE}Если сервис не будет запущен, то контейнер ${dks_cont_name} не запустится после перезагрузки хоста."
  echo -e "${emptE}Обязательно свяжитесь со своим системным администратором."
fi;



# восстанавливаем значение для selinux
if [ "${se_mode}" = "Enforcing" ]; then
  # переключаем обратно.
  setenforce Enforcing
fi;


echo ""
exit 0;
