#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия @tag_ver@


### Пример вызова:
### ./pgb_registr.sh -h "10.38.46.57" -p "5434" -v "13.1" -pwd "1" -bh "10.38.46.60"


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -h|--db_host)
        db_host="$2"
        ;;
      -p|--db_port)
        db_port="$2"
        ;;
      -v|--db_ver)
        db_ver="$2"
        ;;
      -pwd|--db_pgpwd)
        db_pgpwd="$2"
        ;;

      -bh|--pgb_host)
        pgb_host="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -h  | --db_host                       ip адрес хоста СУБД
 -p  | --db_port        5434           порт СУБД
 -v  | --db_ver         13.1           версия СУБД
 -pwd| --db_pgpwd                      пароль пользователя СУБД postgres
 -bh | --pgb_host                      ip адрес текущего хоста пуллера

"
exit 1;
fi;

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
wOK="[  \033[1;33mИнфо\033[0m  ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  Создание SSH доступа PgBouncer @tag_ver@     "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""


if [ -z "${db_host}" ]; then
  echo -e "${eRR}Не указан ip адрес хоста СУБД."
  echo -e "${emptE}Для просмотра доступных параметров используйте: ./pgb_registr.sh --help"
  echo -e ""
  exit 1;
fi;

if [ -z "${db_pgpwd}" ]; then
  echo -e "${eRR}Не указан пароль пользователя postgres для соединения с СУБД."
  echo -e "${emptE}Для просмотра доступных параметров используйте: ./pgb_registr.sh --help"
  echo -e ""
  exit 1;
fi;

if [ -z "${pgb_host}" ]; then
  echo -e "${eRR}Не указан ip адрес текущего хоста пуллера."
  echo -e "${emptE}Для просмотра доступных параметров используйте: ./pgb_registr.sh --help"
  echo -e ""
  exit 1;
fi;

pgb_port="@pgb_port@"
tag_name=$($dks_bashfile_dir/pgb_const_var.sh tag_name)
doc_inst_path=$($dks_bashfile_dir/pgb_const_var.sh doc_inst_path)

file_id_rsa="${dks_bashfile_dir}/id_rsa.tmp"
file_a_key="${dks_bashfile_dir}/authorized_keys"

# Копирование файла публичного сертификата с мастер узла СУБД
sql_cmd="select xp_bashshell('cat /var/lib/pgsqlks-"${db_ver}_${db_port}/.ssh/id_rsa.pub"')"
bash ${dks_bashfile_dir}/psql.sh -h ${db_host}      \
                                 -p ${db_port}      \
                                 -U postgres        \
                                 -pwd ${db_pgpwd}   \
                                 -d repmgr          \
                                 -c "${sql_cmd}"    \
                                 -k "-t " > ${file_id_rsa}

# Вытаскиваем данные ключа
grep -F "ssh-rsa" ${file_id_rsa} > ${file_a_key}

if ! [ -s ${file_a_key} ]; then
  echo -e "${eRR}Копирование файла id_rsa.pub с хоста ${db_host}:${db_port}."
  echo -e "${emptE}Возможно файл не существует. Выполните настройку ssh на удаленном хосте."
  echo ""
  exit 1;
else
  echo -e "${sOK}Копирование файла id_rsa.pub с хоста ${db_host}:${db_port}."
fi;


# если файл скопировался, то добавляем/создаем
cat ${file_a_key} >> ${dks_bashfile_dir}/../.ssh/authorized_keys
echo -e "${sOK}Добавление данных в файл контейнера /home/postgres/.ssh/authorized_keys."

bash ${dks_bashfile_dir}/bash.sh "chown postgres:postgres /home/postgres/.ssh/authorized_keys" \
                                 "Корректировка владельца файла authorized_keys."              \
                                 "top"

bash ${dks_bashfile_dir}/bash.sh "chmod 600 /home/postgres/.ssh/authorized_keys" \
                                 "Установка прав доступа файла authorized_keys." \
                                 "top"

# Регистрация пуллера в таблицы мастера, для обеспечения режима promote
sql_cmd="select repmgr.pgb_nodes_manage('insert', '"${pgb_host}"', '"${pgb_port}"', '"${tag_name}"');"
bash ${dks_bashfile_dir}/psql.sh -h ${db_host}      \
                                 -p ${db_port}      \
                                 -U postgres        \
                                 -pwd ${db_pgpwd}   \
                                 -d repmgr          \
                                 -c "${sql_cmd}"    \
                                 -m "Регистрация пуллера на узле мастера ${db_host}:${db_port}." \
                                 -s "top" \
                                 -k "-t "


rm -f ${file_id_rsa}
rm -f ${file_a_key}

exit 0;


