#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.25.1

# === Определяем каталог выполнения текущего скрипта ==================================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Цвета
ErrColor=$($dks_bashfile_dir/pgb_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/pgb_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/pgb_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/pgb_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/pgb_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/pgb_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/pgb_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/pgb_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/pgb_const_var.sh emptE)

tag_name=$($dks_bashfile_dir/pgb_const_var.sh tag_name)
dks_cont_name=$($dks_bashfile_dir/pgb_const_var.sh dks_cont_name)
contsoft=$($dks_bashfile_dir/pgb_const_var.sh contsoft)

# Файл обмена
host_stdout=$($dks_bashfile_dir/pgb_const_var.sh host_stdout)
cont_stdout=$($dks_bashfile_dir/pgb_const_var.sh cont_stdout)

app_dir_in_container="/opt/${tag_name}"
dks_serv_name=${dks_cont_name}

function fn_file_clr(){
cat > $1 << EOF
EOF
}

fn_file_clr ${host_stdout}
chmod 606 ${host_stdout}

echo ""
# sudo
is_root=$($dks_bashfile_dir/pgb_const_var.sh is_root)
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

# Проверяем существование и активность контейнера
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "${dks_exists}" ]; then
  echo -e "${wOK}Остановка контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнера ${dks_cont_name} не существует."
  echo ""
  exit;
fi

# Определяем запущен ли контейнера
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "${dks_status}" = "false" ]; then
  echo -e "${wOK}Остановка контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнер ${dks_cont_name} не запущен."
  echo ""
  exit;
fi

# Команды остановки и проверки
stop_cmd="bash ${app_dir_in_container}/bin/stop_all.sh"
chk_cmd="echo \\\$(ps -ef | grep -e 'pgbouncer' | grep -v 'grep -e pgbouncer') > ${cont_stdout}"

bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

file_stdout=$(cat ${host_stdout})

rm -f ${host_stdout}
if [ -z "${file_stdout}" ]; then
  echo -e "${wOK}Процесс(ы) пуллера PgBouncer контейнера ${dks_cont_name} не запущен(ы)."
  exit 1;
fi;

bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${stop_cmd}" -noout

if [ $? = "1" ]; then
  echo ""
  echo -e "${eRR}Остановка пуллера PgBouncer контейнера ${dks_cont_name}."
  echo -e "${wOK}Была предпринята неуспешна попытка остановки пуллера PgBouncer."
  echo ""
  exit 1;
fi;

echo -e "${sOK}Процесс(ы) пуллера PgBouncer контейнера ${dks_cont_name} отстановлен(ы)."

# Остановка ssh сервера
bash ${dks_bashfile_dir}/pgb_ssh.sh "stop"

# Останавливаем контейнер
${contsoft} stop -t 1 ${dks_cont_name} >/dev/null
echo -e "${sOK}Остановка контейнера ${dks_cont_name}."

echo ""

exit 0;



