#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.24.1

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
tag_ver="1.24.1"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -bp|--pgb_port)
        pgb_port="$2"
        ;;
      -all|--all_mode)
        mode="all"
        ;;
      -q|--quiet)
        quiet="1"
        ;;


      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -bp  | --pgb_port      6434           порт пуллера

 -all | --all_mode                     режим полной очистки, включая каталог развертывания

 -q   | --quiet                        выполнение операции удаления без подтверждения

"
exit 1;
fi;

if [ -z "${pgb_port}" ]; then
  pgb_port="6434"
fi;

WarnColor='\033[0;33m'
NoColor='\033[0m'
uQY="[ ${WarnColor}Запрос${NoColor} ] "
emptE="           "


echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  Удаление пуллера PgBouncer ${tag_ver} порт ${pgb_port}"
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

if [ -z "${quiet}" ]; then
  echo ""
  echo -n -e "${uQY}Вы действительно хотите удалить пуллер по порту \"${pgb_port}\"?
           ([да;y]/[N;нет;n]): "

  read item
  case "$item" in
    y|Y|да)
        ;;
    n|N|нет|"") echo -e "${emptE}Операция удаления прервана."; echo "";
        exit;
        ;;
    *) echo -e "${emptE}Операция удаления прервана."; echo "";
        exit;
        ;;
  esac
fi;


bash ${dks_bashfile_dir}/sh/dks_remove.sh "${pgb_port}" "${mode}"

exit;



