#!/bin/bash

###
### Создание пользователя и одноименной группы
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия 1.0.0
###

_username=$1

# === Определяем каталог выполнения текущего скрипта ==========================
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# файл констант
_const_file="${_bashfile_dir}/sys_const_var.sh"

_sOK=$(echo $(${_const_file}   sOK)   | tr '#' ' ')
_wOK=$(echo $(${_const_file}   wOK)   | tr '#' ' ')
_eRR=$(echo $(${_const_file}   eRR)   | tr '#' ' ')
_emptE=$(echo $(${_const_file} emptE) | tr '#' ' ')
_emptEsh=$(${_const_file}      emptE)
_host_stdout=$(${_const_file}  host_stdout)


get_free_uid(){
local __lookfile=$1
local __uid=2001

if [ -z "${__lookfile}" ]; then
  __lookfile="passwd"
fi;

__uids=$( cat /etc/${__lookfile} | cut -d: -f3 | sort -n )

while true; do
    if ! echo ${__uids} | grep -F -q -w "${__uid}"; then
        break;
    fi;

    __uid=$(( ${__uid} + 1))
done

echo ${__uid}
}

function __fn_file_echo() {
local __LeftSpace=$2
__LeftSpace=$(echo ${__LeftSpace} | tr '#' ' ')
cat $1 | while read __line
do
 echo -e "${__LeftSpace}${__line}"
 done
}

if [ -z "${_username}" ]; then
  echo -e "${_eRR}Не указано имя создаваемого пользователя."
  exit 1;
fi;

echo -e "${_sOK}Создание пользователя ${_username}."

# Группа
_exists_group=$(sed 's/:.*//' /etc/group   | grep "${_username}")
_next_gid=$(get_free_uid "group");

if [ -z "${_exists_group}" ]; then
  #echo "groupadd  ${_username} -g ${_next_gid} >/dev/null 2>${_host_stdout}"
  groupadd  ${_username} -g ${_next_gid} >/dev/null 2>${_host_stdout}
  if [ $? = "1" ]; then 
    echo -e "${_eRR}Создание группы ${_username}."
    __fn_file_echo ${_host_stdout} ${_emptEsh}
    rm -f ${_host_stdout}
    exit 1;
  fi;
else
  echo -e "${_emptE}Группа ${_username} существует."
  _next_gid=$(id -g ${_username})
fi;

# Пользователь
_exists_user=$(sed 's/:.*//' /etc/passwd | grep "${_username}")
_next_uid=$(get_free_uid "passwd");

if [ -z "${_exists_user}" ]; then
  # echo "useradd ${_username} -u ${_next_uid} -g ${_next_gid} --create-home"
  useradd ${_username} -u ${_next_uid} -g ${_next_gid} --create-home >/dev/null 2>${_host_stdout}
  if [ $? = "1" ]; then
    echo -e "${_eRR}Создание пользователя ${_username}."
    __fn_file_echo ${_host_stdout} ${_emptEsh}
    rm -f ${_host_stdout}
    exit 1;
  fi;
else
  echo -e "${_emptE}Пользователь ${_username} существует."
fi;

rm -f ${_host_stdout}

exit 0;
