#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.24.1

pgb_port=$1
mode=$2
p3=$3
p4=$4
p5=$5

# === Определяем каталог выполнения текущего скрипта ==================================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"


tag_name=$($dks_bashfile_dir/dks_const_var.sh tag_name)
dks_cont_name=$($dks_bashfile_dir/dks_const_var.sh dks_cont_name)
dks_inst_path=$($dks_bashfile_dir/dks_const_var.sh dks_inst_path)
app_inst_path=$($dks_bashfile_dir/dks_const_var.sh app_inst_path)
dks_stdout=$($dks_bashfile_dir/dks_const_var.sh dks_stdout)


# Цвета
sOK=$(echo $($dks_bashfile_dir/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/dks_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/dks_const_var.sh emptE)

# sudo
is_root=$($dks_bashfile_dir/dks_const_var.sh is_root)

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}

echo ""

# Проверка прав суперпользователя
if [ "${is_root}" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  echo -e "${emptE}Операция невозможна."
  exit 1;
fi


# Окончательный путь к развертыванию
inst_dir="${app_inst_path}_${pgb_port}"
dks_cont_name="${dks_cont_name}_${pgb_port}"
dks_serv_name="${dks_cont_name}.service"

# Проверка существования приложения
if ! [ -d "${inst_dir}" ]; then
  echo -e "${eRR}Отсутствует приложение, развернутое по указанному порту."
  echo -e "${emptE}Убедитесь в правильности указания номера порта, параметр -pb(--pgb_port)."
  echo -e ""
  exit 1;
fi;


isTypeOK="no"

aParamType=("count" "user" "database")
case "${aParamType[@]}" in  *"${mode}"*) isTypeOK="yes" ;; esac

if [ "${isTypeOK}" = "no" ] || [ -z "${mode}" ]; then
  echo -e "${eRR}Некорректное значение режима, параметр -m(--mode)."
  echo -e "${emptE}Значение должно быть: ${aParamType[@]}."
  echo -e ""
  exit 1;
fi;


if [ "${mode}" = "count" ]; then
  run_count=${p3}

  if ! ((1<=${run_count} && ${run_count}<=16)); then
    echo -e "${eRR}Проверка корректности значения количества запускаемых процессов."
    echo -e "${emptE}Некорректное значение параметра -rc(--run_count)."
    echo -e "${emptE}Значение должно быть в диапазоне [1-16]."
    echo -e ""
    exit 1;
  fi;
  echo ${run_count} > ${inst_dir}/ctl/pgbouncer_to_run
  chmod 606 ${inst_dir}/ctl/pgbouncer_to_run
  chown postgres:postgres ${inst_dir}/ctl/pgbouncer_to_run

  echo -e "${sOK}Установка количества одновременно запускаемых процессов."
  echo -e "${emptE}Коррекция файла ${inst_dir}/ctl/pgbouncer_to_run."
  echo -e "${emptE}Для вступления изменений в силу, выполните перезагрузку сервиса:"
  echo -e "${emptE}\$ systemctl restart ${dks_serv_name}."
  echo -e ""

  exit 0;
fi;


if [ "${mode}" = "database" ]; then
  db_host=$3
  db_port=$4
  pgb_user=$5

  if [ -z ${db_host} ];then
    echo -e "${eRR}Пустое значение ip хоста сервера СУБД, параметр -h(--db_host)."
    echo ""
    exit 1;
  fi;

  if [ -z ${db_port} ];then
    echo -e "${eRR}Пустое значение порта сервера СУБД, параметр -p(--db_port)."
    echo ""
    exit 1;
  fi;

  if [ -z ${pgb_user} ];then
    echo -e "${eRR}Пустое значение имени пользователя, параметр -u(--pgb_user)."
    echo ""
    exit 1;
  fi;

  # pgbouncer_db.ini
  cat ${dks_bashfile_dir}/../pgb_files/template/pgbouncer_db.ini.t | sed 's/@db_host@/'${db_host}'/g'  > ${inst_dir}/conf.d/pgbouncer_db.ini
  sed -i 's/@db_port@/'${db_port}'/g'                                                                    ${inst_dir}/conf.d/pgbouncer_db.ini
  sed -i 's/@pgb_user@/'${pgb_user}'/g'                                                                  ${inst_dir}/conf.d/pgbouncer_db.ini

  chown postgres:postgres ${inst_dir}/conf.d/pgbouncer_db.ini
  chmod 606 ${inst_dir}/conf.d/pgbouncer_db.ini

  echo -e "${sOK}Установка параметров сервера СУБД."
  echo -e "${emptE}Коррекция файла ${inst_dir}/conf.d/pgbouncer_db.ini."
  echo -e "${emptE}Для вступления изменений в силу, выполните перезагрузку сервиса:"
  echo -e "${emptE}\$ systemctl restart ${dks_serv_name}."
  echo ""
  exit 0;
fi;


if [ "${mode}" = "user" ]; then
  pgb_user=$3
  pgb_user_pwd=$4

  if [ -z ${pgb_user} ];then
    echo -e "${eRR}Пустое значение имени пользователя, параметр -u(--pgb_user)."
    exit 1;
  fi;

  if [ -z ${pgb_user_pwd} ];then
    echo -e "${eRR}Пустое значение пароля пользователя, параметр -pwd(--pgb_user_pwd)."
    echo ""
    exit 1;
  fi;

  # auth_user.ini
  cat ${dks_bashfile_dir}/../pgb_files/template/auth_user.ini.t | sed 's/@pgb_user@/'${pgb_user}'/g' > ${inst_dir}/conf.d/auth_user.ini
  sed -i 's/@md5pwd@/'${p4}'/g'                                                                        ${inst_dir}/conf.d/auth_user.ini

  chown postgres:postgres ${inst_dir}/conf.d/auth_user.ini
  chmod 606 ${inst_dir}/conf.d/auth_user.ini

  echo -e "${sOK}Установка пользователя и пароля для запроса аутентификации."
  echo -e "${emptE}Коррекция файла ${inst_dir}/conf.d/auth_user.ini."
  echo -e "${emptE}Для вступления изменений в силу, выполните перезагрузку сервиса:"
  echo -e "${emptE}\$ systemctl restart ${dks_serv_name}."
  echo -e ""
  exit 0;
fi;

exit 0;


