#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.24.1

pgb_port=$1
mode=$2

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

#============== Основные переменные ===================================================
tag_name=$($dks_bashfile_dir/dks_const_var.sh tag_name)
dks_cont_name=$($dks_bashfile_dir/dks_const_var.sh dks_cont_name)
dks_inst_path=$($dks_bashfile_dir/dks_const_var.sh dks_inst_path)
app_inst_path=$($dks_bashfile_dir/dks_const_var.sh app_inst_path)

# Цвета
sOK=$(echo $($dks_bashfile_dir/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/dks_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/dks_const_var.sh emptE)

# Цвета
ErrColor=$($dks_bashfile_dir/dks_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/dks_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/dks_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/dks_const_var.sh NoColor)

# sudo
is_root=$($dks_bashfile_dir/dks_const_var.sh is_root)
if [ "${is_root}" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}

#==========================================================

echo ""
is_delete="no"

# Файл обмена
dks_stdout=$($dks_bashfile_dir/dks_const_var.sh dks_stdout)

fn_file_clr ${dks_stdout}
chmod 606 ${dks_stdout}

# Окончательные пути развернутого контейнера
inst_path="${app_inst_path}_${pgb_port}"
dks_cont_name="${dks_cont_name}_${pgb_port}"
dks_serv_name="${dks_cont_name}.service"

if [ -f "${inst_path}/ctl/pgb_const_var.sh" ]; then
  contsoft=$(${inst_path}/ctl/pgb_const_var.sh contsoft)
fi;

# смотрим запущен ли сервис
if [ -f "/lib/systemd/system/${dks_serv_name}" ]; then
  if systemctl -q is-active ${dks_serv_name}; then
    systemctl stop ${dks_serv_name}
    echo -e "${sOK}Остановка сервиса ${dks_serv_name}."
  fi;
fi;

# Удаление принудительно контейнер+образ
if ! [ -z "${contsoft}" ]; then
  if [ ! -z "$(${contsoft} ps -a | grep ${dks_cont_name})" ]; then
    echo -e "${sOK}Удаление контейнера ${dks_cont_name}."
    ${contsoft} stop ${dks_cont_name} >/dev/null 2>&1
    ${contsoft} rm -f ${dks_cont_name} >/dev/null 2>&1
    is_delete="yes"
  fi;

  if [ ! -z "$(${contsoft} ps -a | grep ${tag_name})" ]; then
    ${contsoft} stop ${tag_name} >/dev/null 2>&1
    echo -e "${sOK}Остановка контейнера ${tag_name}."
    ${contsoft} rm -f ${tag_name} >/dev/null 2>&1
    echo -e "${sOK}Удаление контейнера ${tag_name}."
    is_delete="yes"
  fi;

  if [ ! -z "$(${contsoft} images | grep ${dks_cont_name})" ]; then
    ${contsoft} rmi -f ${dks_cont_name} >/dev/null 2>&1
    echo -e "${sOK}Удаление образа ${dks_cont_name}."
    is_delete="yes"
  fi;

  if [ ! -z "$(${contsoft} images | grep ${tag_name})" ]; then
    ${contsoft} rmi -f ${tag_name} >/dev/null 2>&1
    echo -e "${sOK}Удаление образа ${tag_name}."
    is_delete="yes"
  fi;
fi;


# Если есть сервис то удаляем его
if [ -f "/lib/systemd/system/${dks_serv_name}" ]; then

  systemctl disable ${dks_serv_name} >/dev/null 2>${dks_stdout}
  #показываем
  fn_file_echo ${dks_stdout} ${emptEsh}
  fn_file_clr ${dks_stdout}

  rm /lib/systemd/system/${dks_serv_name} -f
  systemctl daemon-reload
  echo -e "${sOK}Удаление сервиса /lib/systemd/system/${dks_serv_name}."

  is_delete="yes"
fi;

# Если задан режим полной очистки, то удаляем и каталог
if [ "${mode}" = "all" ]; then
  if [ -d "${inst_path}" ]; then
    echo -e "${sOK}Задан режим полного удаления."
    rm -R ${inst_path} -f
    echo -e "${emptE}Удаление каталога ${inst_path}."
    is_delete="yes"
  fi;
fi;

# файл конфига logrotate
if [ -f "/etc/logrotate.d/${tag_name}_${pgb_port}.conf" ]; then
  rm -f "/etc/logrotate.d/${tag_name}_${pgb_port}.conf"
fi;


if [ "${is_delete}" = "no" ]; then
  echo -e "${wOK}Нет данных для удаления."
fi

rm -f ${dks_stdout}

echo ""
exit;

