#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия @tag_ver@

### Пример вызова:
### ./psql.sh -h 127.0.0.1 -p 5434 -d postgres -U dbo -pwd 1 -c "select datname from pg_database" -t 60
### ./psql.sh -h 127.0.0.1 -p 5434 -d postgres -U dbo -pwd 1 -f "/var/lib/1.sql" -t 60
###

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

dks_cont_name="@dks_cont_name@"
tag_name="@tag_name@"
pgb_port="@pgb_port@"
db_bin_path="/opt/${tag_name}/bin" # полный путь для запуска в контейнере
contsoft="@contsoft@"

file_stdout="run_pgsqlks_completed.log"
host_stdout="/opt/${tag_name}_${pgb_port}/log/${file_stdout}"
dks_stdout="/opt/${tag_name}/log/${file_stdout}"

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
wOK="[  \033[1;33mИнфо\033[0m  ] "
emptE="           "
emptEsh="###########"


function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}



while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -h|--host)
        host="$2"
        ;;
      -p|--port)
        port="$2"
        ;;
      -d|--dbname)
        dbname="$2"
        ;;
      -U|--username)
        username="$2"
        ;;
      -pwd|--password)
        password="$2"
        ;;
      -c|--command)
        command="$2"
        ;;
      -f|--file)
        file="$2"
        ;;
      -t|--timeout)
        timeout="$2"
        ;;

      -m|--out_msg)
        out_msg="$2"
        ;;
      -s|--out_stat)
        out_stat="$2"
        ;;
      -k|--add_psql_key)
        add_key="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -h  | --host           @db_host@      хост СУБД
 -p  | --port           @db_port@           порт СУБД
 -d  | --dbname         postgres       база для соединения
 -U  | --username       dbo            пользователь СУБД, созданный во время установки
 -pwd| --password                      пароль пользователя СУБД
 -c  | --command        select 1       тестовая команда для выполнения
 -f  | --file                          sql файл-скрипт для выполнения (перебивает команду заданную в -с)
 -t  | --timeout        60 секунд      таймаут ожидания выполнения SQL команды
 -m  | --out_msg                       Дополнительное внешнее сообщение для показа
 -s  | --out_stat                      Где показывать доп. сообщение, если есть top, то
                                       показывается в самом верху, иначе внизу.
                                       если вместо ошибки нужно выводить предупреждение,
                                       то указать no_error. Можно указать сразу два ключа: "top\;no_error"
 -k  | --add_psql_key                  дополнительные ключи непосредственно для psql, например:
                                       -k "-t " - непоказывать заголовок и кол-во записей команды "select"
"
exit 1;
fi;

if [ -z "${host}" ]; then
  host="@db_host@"
fi;

if [ -z "${port}" ]; then
  port="@db_port@"
fi;

if [ -z "${dbname}" ]; then
  dbname="postgres"
fi;

if [ -z "${username}" ]; then
  username="dbo"
fi;

if [ -z "${command}" ]; then
  command="select 1"
fi;

if [ -z "${timeout}" ]; then
  timeout="60"
fi;

if [ ! -z "${password}" ]; then
  SetPwd="PGPASSWORD=${password}"
else
  SetPwd=""
fi;


out_stat_top="noshow"
if [[ "$out_stat" == *"top"* ]];      then out_stat_top="top";  fi;
if [[ "$out_stat" == *"no_error"* ]]; then eRR=${wOK};          fi;


fn_file_clr ${host_stdout}
chmod 606 ${host_stdout}


search_str="Docker_sql_command_completed"
search_err="Docker_sql_command_error"

if [ -z "${out_msg}" ]; then
  echo ""
fi;


# Если задан файл на выполнение, то используем его
# переопределяем ключ и команду на файл
command_key="-c"
if [ ! -z "${file}" ]; then
  command="${file}"
  command_key="-f"
fi;

sql_cmd="${SetPwd} ${db_bin_path}/psql -v ON_ERROR_STOP=1 -U ${username} -d ${dbname} -p ${port} -h ${host} ${command_key} \"${command}\" ${add_key} > ${dks_stdout} 2>&1
if [ \$? -eq 0 ]; then
    echo -e '${sOK}: ${search_str}' >> ${dks_stdout}
else
    echo -e '${eRR}: ${search_err}' >> ${dks_stdout}
fi
"

bash ${dks_bashfile_dir}/sys/sys_exec_cont.sh  "${contsoft}" "${dks_cont_name}" "${sql_cmd}" "postgres"

is_end="0"
is_wait="0"

for ((i=1;i<${timeout};i++))
  do
    sleep 1
    if [[ ! -z "$(grep -i ${search_str} ${host_stdout})"  || ! -z "$(grep -i ${search_err} ${host_stdout})" ]]; then
      if [ ! -z "$(grep -i ${search_err} ${host_stdout})" ]; then
        error=1
      else
        error=0
      fi;
      if [ "${is_wait}" = "1" ]; then
        echo ""
      fi;

      is_end="1"
      break;
    else
      is_wait="1"
      is_end="0"
      echo -en "\r${emptE}Ожидание завершения выполнения SQL команды внутри контейнера ${dks_cont_name}: $i сек.(таймаут = ${timeout} сек.)"
    fi
  done


if [ -z "${out_msg}" ]; then
  echo ""
fi;

if [ "${is_end}" = "0" ]; then
  echo -e "${eRR}: Истекло время ожидания завершения выполнения SQL команды внутри контейнера."
  exit 1;
fi;

# если указано внешнее сообщение, то форматируем под него
if [ ! -z "${out_msg}" ]; then
  # Удаляем статусные строки
  sed -i "/${search_str}/ d" ${host_stdout}
  sed -i "/${search_err}/ d" ${host_stdout}
  # Удаление пустых строк
  sed -i "/^$/d" ${host_stdout}

  out_calc_msg=""
  out_top_msg=""
  out_end_msg=""

  if [ ! "${out_stat_top}" = "noshow" ]; then
    # добавляем наше внешнее сообщение
    # Обработка ошибки
    if [ "${error}" = "1" ]; then
      out_calc_msg="${eRR}${out_msg}"
    else
      out_calc_msg="${sOK}${out_msg}"
    fi;
    # Обработка расположения
    if [ "${out_stat_top}" = "top" ]; then
      out_top_msg="${out_calc_msg}"
    else
      out_end_msg="${out_calc_msg}"
    fi;
  fi;

  if [ ! -z "${out_top_msg}" ]; then
    echo -e "${out_top_msg}"
  fi;
  # форматируем, под внешнее использование
  fn_file_echo ${host_stdout} ${emptEsh}

  if [ ! -z "${out_end_msg}" ]; then
    echo -e "${out_end_msg}"
  fi;

else
  echo ""
  cat ${host_stdout}
  echo ""
fi;

rm -f ${host_stdout}

exit;
