;;;
;;; PgBouncer configuration file
;;;

[pgbouncer]

;;;
;;; Настройки администрирования
;;;

;;; пользователь, на которого меняется root при запуске
user = postgres

;;; нижепересленные настройки указываются в своих файлах конфигурации
;;; каждого инстанса

;;; logfile = /opt/@tag_name@/log/pgbouncer_<номер инстанса>.log
;;; pidfile = /opt/@tag_name@/bin/<номер инстанса>/run/pgbouncer.pid
;;; unix_socket_dir = /opt/@tag_name@/bin/<номер инстанса>

;; Установка SO_REUSEPORT опции сокета (включено)
so_reuseport = 1

;;; IP адреса и порт
;; определены в файле /opt/@tag_name@/conf.d/pgbouncer_port.ini
;; listen_addr = *
;; listen_port = <порт>

;;;
;;; Настройки аутентификации
;;;
auth_type  = md5
;;;; указывается в опции auth_user в записи хоста СУБД в файле pgbouncer_db.ini
;;;; auth_user  = @pgb_user@
auth_file  = /opt/@tag_name@/conf.d/auth_user.ini
auth_query = select uname, phash from dbo.pgbks_auth_query($1)

;; фиксировать в журнале успешные подключения (отключено)
log_connections=0
;; фиксировать отключения с указаниями их причин (отключено)
log_disconnections=0
;; записывать агрегированную статистику (отключено)
log_stats=0

;;;
;;; Пользователи базы 'pgbouncer'
;;;
admin_users = pgbouncer
stats_users = pgbouncer

;;;
;;; Настройки пуллера
;;;
pool_mode = transaction
query_wait_timeout = 0
server_reset_query = DISCARD ALL

;;; максимально допустимое число клиентских подключений
max_client_conn = 1000
;;; размер пула поумолчанию
default_pool_size = 200
;;; максимальное количество подключений одного пользователя (=0 не ограничено)
max_user_connections = 0
;;; игнорирование параметров соединения, которые не обрабатываются pgbouncer и вызывают ошибку
ignore_startup_parameters = extra_float_digits, lc_monetary


;;[databases]
;; определены в файле /opt/@tag_name@/conf.d/pgbouncer_db.ini
