#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия @tag_ver@

param_in=$1

#============== Основные определяющие переменные ========
tag_ver="@tag_ver@"
tag_name="pgbouncer-${tag_ver}"
#========================================================


# Контейнер
dks_inst_path="/opt/dks-${tag_name}"
dks_cont_name="${tag_name}_@pgb_port@"
dks_serv_name="${tag_name}_@pgb_port@.service"
app_inst_path="/opt/${tag_name}_@pgb_port@"
doc_inst_path="/opt/${tag_name}"
contsoft="@contsoft@"

# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

sOK="[###${SuccColor}OK${NoColor}###]#"
wOK="[##${WarnColor}Инфо${NoColor}##]#"
eRR="[#${ErrColor}Ошибка${NoColor}#]#"
emptE="###########"

# Файл обмена
dks_stdout="${dks_inst_path}/dks.stdout"
cont_stdout="/opt/${tag_name}/log/dks.stdout"
host_stdout="${app_inst_path}/log/dks.stdout"

# sudo
is_root=$EUID
#==========================================================



case ${param_in} in
      tag_ver)
          param_out=${tag_ver}
          ;;
      tag_name)
          param_out=${tag_name}
          ;;
      contsoft)
          param_out=${contsoft}
          ;;

      dks_inst_name)
          param_out=${dks_inst_name}
          ;;
      dks_inst_path)
          param_out=${dks_inst_path}
          ;;
      dks_cont_name)
          param_out=${dks_cont_name}
          ;;
      dks_serv_name)
          param_out=${dks_serv_name}
          ;;
      app_inst_path)
          param_out=${app_inst_path}
          ;;
      doc_inst_path)
          param_out=${doc_inst_path}
          ;;

      dks_stdout)
          param_out=${dks_stdout}
          ;;
      cont_stdout)
          param_out=${cont_stdout}
          ;;
      host_stdout)
          param_out=${host_stdout}
          ;;


      ErrColor)
          param_out=${ErrColor}
          ;;
      SuccColor)
          param_out=${SuccColor}
          ;;
      WarnColor)
          param_out=${WarnColor}
          ;;
      NoColor)
          param_out=${NoColor}
          ;;

      sOK)
          param_out=${sOK}
          ;;
      wOK)
          param_out=${wOK}
          ;;
      eRR)
          param_out=${eRR}
          ;;
      emptE)
          param_out=${emptE}
          ;;


      is_root)
          param_out=${is_root}
          ;;

     *)
          param_out="Неизвестный параметр ${param_in}."
          ;;
esac

echo ${param_out}

exit;
