#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия @tag_ver@

### Пример вызова:
### ./bash.sh "ls -la"
### ./bash.sh " echo \"Тестирование\" "
###

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

bash_command=$1
out_msg=$2         # показать внешнее сообщение взамен стандартного
out_stat=$3        # top      - показывать внешнее сообщение сверху основного вывода
                   # notshow  - не показывать внешнее сообщение, только основной вывод
                   # no_error - если ошибка, все равно показывать ${wOK} вместо ${eRR}
                   # notshift - при выводе не делать отступ слева

user_exec=$4       # пользователь, под которым выполняем в контейнере


dks_cont_name=$($dks_bashfile_dir/pgb_const_var.sh dks_cont_name)
app_inst_path=$($dks_bashfile_dir/pgb_const_var.sh app_inst_path)
doc_inst_path=$($dks_bashfile_dir/pgb_const_var.sh doc_inst_path)
contsoft=$($dks_bashfile_dir/pgb_const_var.sh contsoft)

file_stdout="run_bash_completed.log"
host_stdout="${app_inst_path}/log/${file_stdout}"
dks_stdout="${doc_inst_path}/log/${file_stdout}"

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
wOK="[  \033[1;33mИнфо\033[0m  ] "
emptE="           "
emptEsh="###########"
timeout=300

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}

out_stat_top="noshow"
if [[ "$out_stat" == *"top"* ]];      then out_stat_top="top";   fi;
if [[ "$out_stat" == *"no_error"* ]]; then eRR=${wOK};           fi;
if [[ "$out_stat" == *"notshift"* ]]; then emptE=""; emptEsh=""; fi;

fn_file_clr ${host_stdout}
chmod 606 ${host_stdout}

search_str="Docker_bash_command_completed"
search_err="Docker_bash_command_error"

if [ -z "${out_msg}" ]; then
  echo ""
fi;

bash_cmd="${bash_command} > ${dks_stdout} 2>&1
if [ \$? -eq 0 ]; then
  echo -e '${sOK}: ${search_str}' >> ${dks_stdout}
else
  echo -e '${eRR}: ${search_err}' >> ${dks_stdout}
fi
"

bash ${dks_bashfile_dir}/sys/sys_exec_cont.sh  "${contsoft}" "${dks_cont_name}" "${bash_cmd}" "${user_exec}"

is_end="0"
is_wait="0"
error=1

for ((i=1;i<${timeout};i++))
  do
    sleep 1
    if [[ ! -z "$(grep -i ${search_str} ${host_stdout})" || ! -z "$(grep -i ${search_err} ${host_stdout})" ]]; then
      if [ ! -z "$(grep -i ${search_err} ${host_stdout})" ]; then
        error=1
      else
        error=0
      fi;
      if [ "${is_wait}" = "1" ]; then
        echo ""
      fi;
      is_end="1"
      break;
    else
      is_end="0"
      is_wait="1"
      echo -en "\r${emptE}Ожидание завершения выполнения bash команды внутри контейнера: $i сек.(таймаут = ${timeout} сек.)"
    fi;
  done

if [ -z "${out_msg}" ]; then
  echo ""
fi;

if [ "${is_end}" = "0" ]; then
  echo -e "${eRR}: Истекло время ожидания завершения выполнения bash команды внутри контейнера."
  exit 1;
fi;

# если указано внешнее сообщение, то форматируем под него
if [ ! -z "${out_msg}" ]; then
  # Удаляем статусные строки
  sed -i "/${search_str}/ d" ${host_stdout}
  sed -i "/${search_err}/ d" ${host_stdout}
  # Удаление пустых строк
  sed -i "/^$/d" ${host_stdout}

  out_calc_msg=""
  out_top_msg=""
  out_end_msg=""

  if [ ! "${out_stat_top}" = "noshow" ]; then
    # добавляем наше внешнее сообщение
    # Обработка ошибки
    if [ "${error}" = "1" ]; then
      out_calc_msg="${eRR}${out_msg}"
    else
      out_calc_msg="${sOK}${out_msg}"
    fi;
    # Обработка расположения
    if [ "${out_stat_top}" = "top" ]; then
      out_top_msg="${out_calc_msg}"
    else
      out_end_msg="${out_calc_msg}"
    fi;
  fi;

  if [ ! -z "${out_top_msg}" ]; then
    echo -e "${out_top_msg}"
  fi;
  # форматируем, под внешнее использование
  fn_file_echo ${host_stdout} ${emptEsh}

  if [ ! -z "${out_end_msg}" ]; then
    echo -e "${out_end_msg}"
  fi;

else
  echo ""
  cat ${host_stdout}
  echo ""
fi;

rm -f ${host_stdout}

if [ "${error}" = "1" ]; then exit 1; fi;

exit 0;

