#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.24.1

# === Определяем каталог выполнения текущего скрипта ==================================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Цвета
ErrColor=$($dks_bashfile_dir/pgb_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/pgb_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/pgb_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/pgb_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/pgb_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/pgb_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/pgb_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/pgb_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/pgb_const_var.sh emptE)


tag_name=$($dks_bashfile_dir/pgb_const_var.sh tag_name)
dks_cont_name=$($dks_bashfile_dir/pgb_const_var.sh dks_cont_name)
cont_stdout=$($dks_bashfile_dir/pgb_const_var.sh cont_stdout)
host_stdout=$($dks_bashfile_dir/pgb_const_var.sh host_stdout)
contsoft=$($dks_bashfile_dir/pgb_const_var.sh contsoft)

app_dir_in_container="/opt/${tag_name}"
dks_serv_name=${dks_cont_name}

function fn_file_clr(){
cat > $1 << EOF
EOF
}

fn_file_clr ${host_stdout}
chmod 606 ${host_stdout}

echo ""

# sudo
is_root=$(${dks_bashfile_dir}/pgb_const_var.sh is_root)
if [ "${is_root}" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi;

# Определяем запущен ли контейнера
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "$dks_status" = "false" ]; then

  se_mode="Disabled"
  # Проверка Selinux
  if [ -f /etc/selinux/config ]; then
    se_mode=$(echo $(getenforce))
    if [ "${se_mode}" = "Enforcing" ]; then
      # переключаем в разрешительный :)
      setenforce Permissive
    fi;
  fi;

  # Запуск контейнера (процесса) в фоновом режиме
  ${contsoft} start ${dks_cont_name} >/dev/null

  dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

  # восстанавливаем значение для selinux
  if [ "${se_mode}" = "Enforcing" ]; then
    # переключаем обратно.
    setenforce Enforcing
  fi;

  if [ "${dks_status}" = "true" ]; then
    echo -e "${sOK}Запуск контейнера ${dks_cont_name}."
  else
    echo -e "${eRR}Запуск контейнера ${dks_cont_name}."
    echo -e "${emptE}Контейнер ${dks_cont_name} не запустился. Операция запуска не прошла."
    echo ""
    exit 1;
  fi;
else
  echo -e "${wOK}Запуск контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнер ${dks_cont_name} уже запущен."
fi;


# Запуск внутри контейнера
chk_cmd="echo \\\$(ps -ef | grep -e 'pgbouncer' | grep -v 'grep -e pgbouncer') > ${cont_stdout}"
bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

file_stdout=$(cat ${host_stdout})

rm -f ${host_stdout}
if ! [ -z "${file_stdout}" ]; then

  echo -e "${wOK}Процесс(ы) пуллера PgBouncer контейнера ${dks_cont_name} уже запущен(ы)."

else

  start_cmd="bash ${app_dir_in_container}/bin/start_all.sh"
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${start_cmd}"

  if [ $? = "1" ]; then
    echo ""
    echo -e "${eRR}Запуск пуллера PgBouncer контейнера ${dks_serv_name}."
    echo -e "${emptE}Была предпринята неудачная попытка запуска пуллера."
    echo ""
    exit 1;
  fi;

  # Проверяем, + информируем какое количество процессов было запущено
  echo -e "${sOK}Запуск процессов пуллера PgBouncer контейнера ${dks_serv_name}."
fi;

# Запуск ssh сервера
bash ${dks_bashfile_dir}/pgb_ssh.sh "start"


exit 0;