#!/bin/bash

### PgBouncer "K"
###
### Copyright (C) ООО Кейсистемс 2025
###
### Версия 1.24.1

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
tag_ver="1.24.1"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -h|--db_host)
        db_host="$2"
        ;;
      -p|--db_port)
        db_port="$2"
        ;;

      -U|--pgb_user)
        pgb_user="$2"
        ;;

      -pwd|--pgb_user_pwd)
        pgb_user_pwd="$2"
        ;;

      -bp|--pgb_port)
        pgb_port="$2"
        ;;
      -ssh)
        pgb_ssh="1"
        ;;
      -cs|--contsoft)
        contsoft="$2"
        ;;

      -n|--net_isolation)
        net_isolation="yes"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -h  | --db_host                       ip адрес СУБД

 -p  | --db_port        5434           порт СУБД

 -U  | --pgb_user       pgbouncer      имя пользователя в СУБД, обслуживающего пуллер

 -pwd| --pgb_user_pwd   1              пароль пользователя в СУБД, обслуживающего пуллер

 -bp | --pgb_port       6434           порт пуллера

 -ssh| --ssh                           поддержка ssh сервера в контейнере для работы в составе ОУК

 -cs | --contsoft       docker         ПО контейнерезации (docker или podman)

 -n  | --net_isolation                 изоляция сети контейнера

 Например:
  ./install.sh -h 10.38.46.897 -pwd 'P$gh2023!'


"
exit 1;
fi;

if [ -z "${db_port}" ] ; then
  db_port="5434"
fi;

if [ -z "${pgb_user}" ] ; then
  pgb_user="pgbouncer"
fi;

if [ -z "${pgb_user_pwd}" ] ; then
  pgb_user_pwd="1"
fi;

# Вычисляем md5 пароля пользователя
temp_hash=$(echo -n "${pgb_user_pwd}${pgb_user}" | md5sum)
md5pwd=$(echo "md5${temp_hash}" | sed -r 's/ .+//')


if [ -z "${pgb_port}" ] ; then
  pgb_port="6434"
fi;

if [ -z "${contsoft}" ]; then
  contsoft="docker"
fi;

if [ ! ${contsoft} = "docker" ]; then
  contsoft="podman"
fi;


echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~   Установка пуллера PgBouncer ${tag_ver} (${contsoft})"
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

bash ${dks_bashfile_dir}/sh/dks_create.sh "${db_host}"       \
                                          "${db_port}"       \
                                          "${pgb_user}"      \
                                          "${md5pwd}"        \
                                          "${pgb_port}"      \
                                          "${pgb_ssh}"       \
                                          "${contsoft}"      \
                                          "${net_isolation}"

exit;
