import torch
from transformers import pipeline
import gigaam


def preload_model(is_openai_model: bool, model_name: str):
    device = "cuda" if torch.cuda.is_available() else "cpu"

    model = None

    if is_openai_model:
        model = pipeline(
            "automatic-speech-recognition",
            model=model_name,
            device=device,
            torch_dtype=torch.float16,
            generate_kwargs={"language": "russian"}
        )
    else:
        model = gigaam.load_model(model_name, device=device)

    return model


def transcribe(is_openai_model: bool, model, audio):
    if is_openai_model:
        return model(audio)["text"]
    else:
        return model.transcribe(audio)
