from fastapi import Depends
from sqlalchemy.ext.asyncio import AsyncSession
from sqlalchemy import select, insert, update, func, delete, select, func, and_

from services.core.database.database_service import get_async_session

from features.record.record_table import record
from features.record.record_schemas import Record


async def add_record_db(new_record: Record,
                        session: AsyncSession = Depends(get_async_session)):

    stmt = insert(record).values(**new_record.model_dump())

    result_proxy = await session.execute(stmt)

    await session.commit()

    record_id = result_proxy.inserted_primary_key[0]

    return record_id


async def check_record_by_system_id(system_id: int,
                                    session: AsyncSession = Depends(get_async_session)):
    stmt = select(record).where(record.c.system_id == system_id).limit(1)

    result = await session.execute(stmt)

    finded_record = result.mappings().first()

    return finded_record if finded_record else None
