from dotenv import load_dotenv
import os
import configparser
from services.core.database.models.db_config import DataBaseConfig
from services.core.fastapi.models.fastapi_config import FastApiConfig
from services.core.exception_handler.models.monitoring_config import MonitoringConfig
from services.core.authorization.models.auth_config import AuthorizationConfig
from classes.audio_config import AudioConfig


def get_path(file_name) -> str:
    root_path = os.path.dirname(os.path.abspath(__file__))
    return os.path.join(root_path, file_name)


settings_ini = get_path('settings.ini')


load_dotenv()

if os.path.isfile(settings_ini):
    config = configparser.ConfigParser()

    config.read(settings_ini, encoding='utf-8-sig')

    DATABASE = DataBaseConfig(
        host=config["DBConfig"]["DB_HOST"],
        name=config["DBConfig"]["DB_NAME"],
        password=config["DBConfig"]["DB_PASS"],
        port=config["DBConfig"]["DB_PORT"],
        user=config["DBConfig"]["DB_USER"],
        iddle_session_timeout=config["DBConfig"]["BD_IDLE_SESSION_TIMEOUT"]
    )

    vs_code_app_mode = os.environ.get("APP_MODE")

    FASTAPI_CONFIG = FastApiConfig(
        mode=vs_code_app_mode if vs_code_app_mode else config["AppEnv"]["AppMode"])

    AUTHORIZATION = AuthorizationConfig(
        secret_auth=config["AuthConfig"]["SECRET_AUTH"],
        jwt_algorithm=config["AuthConfig"]["JWT_ALGORITHM"],
        jwt_expiration_time=config["AuthConfig"]["JWT_EXPIRATION_TIME_MINUTES"],
        refresh_token_expire=config["AuthConfig"]["REFRESH_TOKEN_EXPIRE_DAYS"],
        cookie_max_age=config["AuthConfig"]["JWT_EXPIRATION_TIME_MINUTES"]
    )

    MONITORING = MonitoringConfig(
        token=config["Monitoring"]["Token"],
        is_enabled=config["Monitoring"]["IsEnabled"],
        url=config["Monitoring"]["Url"],
        request_timeout=config["Monitoring"]["RequestTimeout"]
    )

    AUDIO = AudioConfig(
        audiofile_max_size=config["Audio"]["AUDIOFILE_MAX_SIZE_MB"],
        chunk_max_size_sec=config["Audio"]["CHUNK_MAX_SIZE_SEC"],
        is_openai_model=config["Audio"]["IS_OPENAI_MODEL"],
        model_name=config["Audio"]["MODEL_NAME"]
    )
