from logging.config import fileConfig

from sqlalchemy import engine_from_config
from sqlalchemy import pool

from alembic import context

import sys
import os

sys.path.append(os.path.join(sys.path[0], 'src'))  # nopep8

from config import DATABASE

from services.core.region.region_table import metadata as metadata_region
from services.core.role.role_table import metadata as metadata_role
from services.core.role_regions.role_regions_table import (
    metadata as metadata_role_regions,
)
from services.core.system.system_table import metadata as metadata_system
from services.core.system_type.system_type_table import metadata as metadata_system_type
from features.record.record_table import metadata as metadata_record
from services.core.authorization.user.user_table import metadata as metadata_user
from services.core.authorization.token.token_table import metadata as metadata_token


# this is the Alembic Config object, which provides
# access to the values within the .ini file in use.
config = context.config

section = config.config_ini_section

config.set_section_option(section, "DB_HOST", DATABASE.host)
config.set_section_option(section, "DB_PORT", str(DATABASE.port))
config.set_section_option(section, "DB_USER", DATABASE.user)
config.set_section_option(section, "DB_NAME", DATABASE.name)
config.set_section_option(section, "DB_PASS", DATABASE.password)

# Interpret the config file for Python logging.
# This line sets up loggers basically.
if config.config_file_name is not None:
    fileConfig(config.config_file_name)

# add your model's MetaData object here
# for 'autogenerate' support
# from myapp import mymodel
# target_metadata = mymodel.Base.metadata
target_metadata = [metadata_region,
                   metadata_role,
                   metadata_role_regions,
                   metadata_user,
                   metadata_system_type,
                   metadata_system,
                   metadata_token,
                   metadata_record]

# other values from the config, defined by the needs of env.py,
# can be acquired:
# my_important_option = config.get_main_option("my_important_option")
# ... etc.


def run_migrations_offline() -> None:
    """Run migrations in 'offline' mode.

    This configures the context with just a URL
    and not an Engine, though an Engine is acceptable
    here as well.  By skipping the Engine creation
    we don't even need a DBAPI to be available.

    Calls to context.execute() here emit the given string to the
    script output.

    """
    url = config.get_main_option("sqlalchemy.url")
    context.configure(
        url=url,
        target_metadata=target_metadata,
        literal_binds=True,
        dialect_opts={"paramstyle": "named"},
    )

    with context.begin_transaction():
        context.run_migrations()


def run_migrations_online() -> None:
    """Run migrations in 'online' mode.

    In this scenario we need to create an Engine
    and associate a connection with the context.

    """
    connectable = engine_from_config(
        config.get_section(config.config_ini_section, {}),
        prefix="sqlalchemy.",
        poolclass=pool.NullPool,
    )

    with connectable.connect() as connection:
        context.configure(
            connection=connection, target_metadata=target_metadata
        )

        with context.begin_transaction():
            context.run_migrations()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
