## Профиль VSCode

Находится в .vscode, наименование fastapi.code-profile

## Инструкция

### Необходимо:

-   Python версии 3.12.4
-   Версия СУБД-КС начиная с 14.12, 15.7, 16.2, либо postgresql

### Настройка сервиса

Необходимо выставить настройки в `src/settings.ini` по примерам в комментариях.

### Установка ffmpeg

Перейдите на сайт: https://www.gyan.dev/ffmpeg/builds/
Скачайте архив "Essentials build"
Распакуй в папку, например: `C:\utils\ffmpeg`

Добавьте FFmpeg в системный PATH
Откройте Панель управления → Система → Дополнительные параметры системы → Переменные среды
В разделе Системные переменные найди Path, нажмите Изменить

Добавь путь:
`C:\utils\ffmpeg\bin`

Нажмите OK и перезапустите VS Code или терминал
Проверьте наличие ffmpeg с помощью команды `ffmpeg --version`

### Установка необходимых модулей и настройка

Для локального запуска необходимо создать виртуальное окружение в корневой папке командой `python -m venv venv`, либо командой `py -m venv venv` и активировать его. Команда `venv\Scripts\activate.bat` - для Windows; `source venv/bin/activate` - для Linux и MacOS.

Выполним обновление numpy: с помощью команды `python -m pip install --upgrade pip` либо `python.exe -m pip install --upgrade pip`.

Затем необходимо установить зависимости командой `pip install -r requirements.txt`.

### Создание базы данных

Произведем создание базы данных с помощью команды `alembic upgrade head`.

### Запуск

Далее перейдем в папку `src` командой `cd src` и выполним команду `python main.py` для запуска сервиса на сервере `uvicorn`.

После этого можно зайти в браузере по адресу http://localhost:8000/docs для просмотра доступных эндпоинтов.

После успешного запуска проекта, создаём суперпользователя(админа), для этого переходим в http://localhost:8000/docs и выполняем запрос create_user_by_secret_token. Вводим почту, логин и пароль, так же потребуется выставить значения `"is_superuser": true` и в `secret_token` вставить значение из SECRET_AUTH из `src/settings.ini`

Далее создаем сначала тип системы и систему, после авторизовываем систему с помощью токена системы в system/auth_system http://localhost:8000/docs

### Запуск докер образа

Команда `docker run --gpus '"device={id видеокарты}"' -dt -w /app/src --restart=always -v "{путь к сервису}:/app" -p 7878:8000 --name {название контейнера} {название контейнера}:latest sh -c "cd /app && alembic upgrade head && cd src && python main.py"`
